% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{ifelse}
\alias{ifelse}
\title{Element-wise if-else function.}
\usage{
ifelse(x, a, b)
}
\arguments{
\item{x}{A \code{LazyTensor}, a vector of numeric values,
or a scalar value.}

\item{a}{A \code{LazyTensor}, a vector of numeric values,
or a scalar value.}

\item{b}{A \code{LazyTensor}, a vector of numeric values,
or a scalar value.}
}
\value{
An object of class "LazyTensor" if the function is called with a
\code{LazyTensor}, and an object of class "numeric", "matrix", or "array" otherwise,
depending on the input class (see R default \code{base::ifelse()} function).
}
\description{
Symbolic ternary operation for element-wise if-else function.
}
\details{
If \code{x} is a \code{LazyTensor}, \code{ifelse(x, a, b)} returns a \code{LazyTensor}
that encodes, symbolically,
\code{a} if \code{x >= 0} and \code{b} if \code{x < 0}.  Broadcasting rules apply.
\code{a} and \code{b} may be fixed integers or floats, or other \code{LazyTensor}.

Else, computes R default if-else function.

\strong{Note}

If \code{a} and \code{b} are not scalar values, these should have the same inner
dimension as \code{x}.
}
\examples{
\dontrun{
# basic example
D <- 3
M <- 100
N <- 150
P <- 200
x <- matrix(runif(M * D), M, D)
y <- matrix(runif(N * D), N, D)
z <- matrix(runif(P * D), P, D)
x_i <- LazyTensor(x, index = 'i')
y_j <- LazyTensor(y, index = 'j')
z_i <- LazyTensor(z, index = 'i')

# call ifelse function
if_else_xyz <- ifelse(x_i, y_j, z_i)
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
