% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{grad}
\alias{grad}
\title{Gradient operation.}
\usage{
grad(f, gradin, opstr, var, index)
}
\arguments{
\item{f}{A \code{LazyTensor} or a \code{ComplexLazyTensor}.}

\item{gradin}{A \code{LazyTensor}, a \code{ComplexLazyTensor} encoding a matrix of ones
with an inner dimension equal to 1 and indexed by the
same index and with number of rows equal to
the number of rows of the first \code{x} variable (in \code{x$data}).}

\item{opstr}{A \code{string} formula corresponding to a reduction
(like "Sum" or "Max").}

\item{var}{An \code{integer} number indicating regarding to which
variable/parameter (given by name or by position index starting at 0) the
gradient of the formula should be computed or a one of the \code{LazyTensor}
contained in \code{f}.}

\item{index}{A \code{character} that should be either \strong{i} or \strong{j} to specify
whether if the reduction is indexed by \strong{i} (rows), or \strong{j} (columns).
When the first \code{f} variable is indexed by \strong{i} (resp. \strong{j}), index cannot
be \strong{i} (resp. \strong{j}).}
}
\value{
A \code{matrix}.
}
\description{
Gradient operation.
}
\details{
\code{grad(f, gradin, opstr, var, index)} returns a \code{matrix} which
corresponds to the gradient (more precisely, the adjoint of the differential
operator) of \code{f} with respect to the variable \code{var} and applied to \code{gradin}
with compiling the corresponding reduction operator of \code{opstr}.
It has an additional integer input parameter \code{index} indicating if the inner
dimension corresponds to columns, i.e. \code{index = 'j'} or rows, i.e.
\code{index = 'i'}.
}
\examples{
\dontrun{
nx <- 100
ny <- 150
x <- matrix(runif(nx*3), nrow=nx, ncol=3)     # matrix 100 x 3
y <- matrix(runif(ny*3), nrow=ny, ncol=3)     # matrix 150 x 3
eta <- matrix(runif(nx*1), nrow=nx, ncol=1)   # matrix 100 x 1 
# nrow(x) == nrow(eta)

x_i <- LazyTensor(x, index = 'i')  # LazyTensor from matrix x, indexed by 'i'
y_j <- LazyTensor(y, index = 'j')  # LazyTensor from matrix y, indexed by 'j'
eta_i <- LazyTensor(eta, index = 'i')   # LazyTensor from matrix eta, 
                                        # indexed by 'i' (like x_i)

# gradient with the formula from position
grad_xy <- grad(sqnorm2(x_i-y_j), eta_i, "Sum", var = y_j$formula, "j")  

# gradient with the formula from index
grad_xy <- grad(sqnorm2(x_i-y_j), eta_i, "Sum", var = 0, "j")     
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
