% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rkeops_options.R
\name{get_rkeops_options}
\alias{get_rkeops_options}
\title{Get the current \code{rkeops} options in \code{R} global options scope}
\usage{
get_rkeops_options(option = NULL)
}
\arguments{
\item{option}{string character or vector of string character,
specific option name(s) among \code{"backend"}, \code{"device_id"}, \code{"precision"},
\code{"verbosity"}, \code{"debug"} to get the corresponding option current values.
Default is \code{NULL} and all option values are returned.}
}
\value{
a scalar value if only one option was specified or a list with
specified \code{rkeops} current options values.
}
\description{
\code{rkeops} user-defined operators requires specific options to control
their behavior at runtime (precision, verbosity, use of GPU, debug flag).
Their current values can be printed with \code{get_rkeops_options()}. See
\code{\link[=def_rkeops_options]{def_rkeops_options()}} for more details about these options.
}
\examples{
set_rkeops_options()
get_rkeops_options()
get_rkeops_options("backend")
get_rkeops_options(c("backend", "precision"))

}
\seealso{
\code{\link[=def_rkeops_options]{def_rkeops_options()}}, \code{\link[=set_rkeops_options]{set_rkeops_options()}}
}
\author{
Ghislain Durif
}
