% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keops_utils.R
\name{get_pykeops_formula}
\alias{get_pykeops_formula}
\title{Format RKeOps formula for PyKeOps}
\usage{
get_pykeops_formula(
  formula,
  grad = FALSE,
  var_to_diff = NULL,
  input_grad = NULL
)
}
\arguments{
\item{formula}{character string, RKeOps formula defining an operator}

\item{grad}{boolean, used for recursive call involving \code{Grad}. Default is
\code{FALSE}.}

\item{var_to_diff}{character string, used for recursive call
involving \code{Grad}. Default is \code{NULL}.}

\item{input_grad}{character string, used for recursive call
involving \code{Grad}. Default is \code{NULL}.}
}
\value{
list with items:
\itemize{
\item \code{reduction_op}: character string, name of the reduction that will be
applied.
\item \code{main_formula}: formula defining the symbolic matrix on which the
reduction will be applied.
\item \code{axis}: integer, axis along which the reduction will be applied (see
details).
\item \code{opt_arg}: integer, optional additional argument for the reduction.
}
}
\description{
\code{pykeops.numpy.Genred} and \code{pykeops.torch.Genred} do not handle cases where
the reduction and the axis are given directly in the formula, such as
\code{formula = "Sum_Reduction(SqNorm2(x-y), 0)"}. Instead we need to pass
arguments as
\code{Genred(formula="SqNorm2(x-y)", aliases=..., reduction_op="Sum", axis=0, ...)}

The function \code{get_pykeops_formula()} breaks RKeOps formula into relevant
parts for \code{pykeops} \code{Genred} function.
}
\details{
\code{axis=0} means a reduction over \code{i} (meaning that the result is a \code{Vj}
variable).
\code{axis=1} means a reduction over \code{j} (meaning that the result is a \code{Vi}
variable).
}
\author{
Ghislain Durif
}
\keyword{internal}
