% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_preprocess.R
\name{fixvariables}
\alias{fixvariables}
\title{Fix variables.}
\usage{
fixvariables(x, is_opt = FALSE)
}
\arguments{
\item{x}{A \code{LazyTensor} or a \code{ComplexLazyTensor}.}
}
\value{
A \code{LazyTensor} or a \code{ComplexLazyTensor}.
}
\description{
Assigns final labels to each variable for the \code{KeOps} routine.
}
\details{
\code{fixvariables(x)} will change the identifiers of \code{x} variables in
\code{x$args} and \code{x$formula} into simpler ordered labels of the form \verb{V<n>} where
\code{n} is the apparition order of the variable in the formula.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows, 3 columns
y <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows, 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'
y_j <- LazyTensor(y, index = 'j')   # creating LazyTensor from matrix y, 
                                    # indexed by 'j'

a <- x_i + y_j       # combination of LazyTensors with variable labels 
                     # of the form "A0x.*"

b <- fixvariables(a) # combination of LazyTensors with variable labels 
                     # of the form "V0" and "V1"
b$formula            # returns "V0+V1"
b$args               # returns a vector containing "V0=Vi(3)" and "V1=Vj(3)"
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
\keyword{internal}
