% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{exp1j}
\alias{exp1j}
\title{Element-wise "complex exponential of 1j x" operation.}
\usage{
exp1j(x)
}
\arguments{
\item{x}{A \code{LazyTensor}.}
}
\value{
An object of class "ComplexLazyTensor".
}
\description{
Symbolic unary operation for element-wise "complex exponential of 1j x".
}
\details{
\code{exp1j(x)} returns a \code{ComplexLazyTensor} that encodes, symbolically,
the multiplication of \verb{1j} with \code{x}.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows, 3 columns
x_i <- LazyTensor(x, "i")           # creating LazyTensor from matrix x, 
                                    # indexed by 'i'

z <- exp1j(x_i)                     # ComplexLazyTensor object
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
