% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{clampint}
\alias{clampint}
\title{Element-wise clampint function.}
\usage{
clampint(x, y, z)
}
\arguments{
\item{x}{A \code{LazyTensor}, a vector of numeric values,
or a scalar value.}

\item{y}{An \code{integer}.}

\item{z}{An \code{integer}.}
}
\value{
An object of class \code{LazyTensor}.
}
\description{
Symbolic ternary operation for element-wise clampint function.
}
\details{
\code{clampint(x, y, z)} returns a \code{LazyTensor} that encodes, symbolically,
the element-wise clamping of \code{x} in \verb{(y, z)} which are integers. See \code{?clamp}
for more details.
Broadcasting rules apply.
}
\examples{
\dontrun{
# basic example
D <- 3
M <- 100
x <- matrix(runif(M * D), M, D)
x_i <- LazyTensor(x, index = 'i')

# call clampint function
clp_int <- clamp(x_i, 7, 2)
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
