% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{argmin_reduction}
\alias{argmin_reduction}
\title{Argmin reduction.}
\usage{
argmin_reduction(x, index)
}
\arguments{
\item{x}{A \code{LazyTensor} or a \code{ComplexLazyTensor}.}

\item{index}{A \code{character} corresponding to the reduction dimension that should
be either \strong{i} or \strong{j} to specify whether if the reduction is indexed by
\strong{i} (rows) or \strong{j} (columns).}
}
\value{
A matrix corresponding to the argmin reduction.
}
\description{
Argmin reduction.
}
\details{
\code{argmin_reduction(x, index)} will return the argmin reduction of \code{x}.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows and 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'

argmin_red <- argmin(x_i, "i")  # argmin reduction indexed by "i"
}
}
\seealso{
\code{\link[=argmin]{argmin()}}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
