% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{argmax}
\alias{argmax}
\title{ArgMax.}
\usage{
argmax(x, index = NA)
}
\arguments{
\item{x}{A \code{LazyTensor}, a \code{ComplexLazyTensor}, a vector or a matrix of numeric
values, or a scalar value.}

\item{index}{A \code{character} corresponding to the reduction dimension that should
be either \strong{i} or \strong{j} to specify whether if the reduction is indexed by
\strong{i} (rows) or \strong{j} (columns).
It can be NA (default) when no reduction is desired.}
}
\value{
A matrix corresponding to the argmax reduction or an object of class
"LazyTensor" corresponding to a symbolic matrix.
}
\description{
ArgMax unary operation, or ArgMax reduction.
}
\details{
If \code{x} is a \code{LazyTensor} or a \code{ComplexLazyTensor},
\code{argmax(x, index)} will:
\itemize{
\item{if \strong{index = NA} (default),}{ return a new \code{LazyTensor} object
representing the argmax of the values of \strong{x};}
\item{if \strong{index = i},}{ return the argmax reduction of \strong{x} over the
\strong{i} indices (rows);}
\item{if \strong{index = j},}{ return the argmax reduction of \strong{x} over the
\strong{i} indices (columns).}
}

\strong{Note}

Run \code{browseVignettes("rkeops")} to access the vignettes and find details
about the function in "RKeOps LazyTensor",
at section #Reductions.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows and 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'

argmax_xi <- argmax(x_i, "i")  # argmax reduction indexed by "i"
argmax_x <- argmax(x_i)        # symbolic matrix
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
