% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{argKmin_reduction}
\alias{argKmin_reduction}
\title{argKmin reduction.}
\usage{
argKmin_reduction(x, K, index)
}
\arguments{
\item{x}{A \code{LazyTensor} or a \code{ComplexLazyTensor}.}

\item{K}{An \code{integer} corresponding to the  number of minimal values required.}

\item{index}{A \code{character} corresponding to the reduction dimension that should
be either \strong{i} or \strong{j} to specify whether if the reduction is indexed by
\strong{i} (rows) or \strong{j} (columns).}
}
\value{
A matrix corresponding to the argKmin reduction.
}
\description{
argKmin reduction. Redirects to \code{argKmin} function.
}
\details{
If \code{x} is a \code{LazyTensor} or a \code{ComplexLazyTensor},
\code{argKmin(x, K, index)} will:
\itemize{
\item{if \strong{index = i},}{ return the indices of the \strong{K} minimal
values of \strong{x}
over the \strong{i} indexes (rows);}
\item{if \strong{index = j},}{ return the indices of the \strong{K} minimal
values of \strong{x}
over the \strong{j} indexes (columns).}
}
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows and 3 columns
x_i <- LazyTensor(x, index = 'i')   # creating LazyTensor from matrix x, 
                                    # indexed by 'i'
K <- 2
argkmin_red_x <- argKmin_reduction(x_i, K, "i")  # argKmin reduction 
                                                 # indexed by "i"
}
}
\seealso{
\code{\link[=argKmin]{argKmin()}}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
