% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_preprocess.R
\name{Vj}
\alias{Vj}
\title{Wrapper LazyTensor indexed by "j".}
\usage{
Vj(x, is_complex = FALSE)
}
\arguments{
\item{x}{A matrix of numeric values.}

\item{is_complex}{A boolean (default is FALSE). Whether if we want to create a
\code{ComplexLazyTensor} (is_complex = TRUE) or a \code{LazyTensor} (is_complex = FALSE).}
}
\value{
An object of class "LazyTensor" indexed by "j".
}
\description{
Simple wrapper that return an instantiation of \code{LazyTensor} indexed by "j".
Equivalent to \code{LazyTensor(x, index = "j")}.
}
\details{
See \code{?LazyTensor} for more details.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3)
Vj_x <- Vj(x) # symbolic object representing an arbitrary row of x, 
              # indexed by the letter "j"
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
