% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_preprocess.R
\name{Vi}
\alias{Vi}
\title{Wrapper LazyTensor indexed by "i".}
\usage{
Vi(x, is_complex = FALSE)
}
\arguments{
\item{x}{A matrix of numeric values, or a scalar value.}

\item{is_complex}{A boolean (default is FALSE). Whether if we want to create a
\code{ComplexLazyTensor} (is_complex = TRUE) or a \code{LazyTensor} (is_complex = FALSE).}
}
\value{
An object of class "LazyTensor" indexed by "i". See \code{?LazyTensor} for
more details.
}
\description{
Simple wrapper that return an instantiation of \code{LazyTensor} indexed by "i".
Equivalent to \code{LazyTensor(x, index = "i")}.
}
\details{
See \code{?LazyTensor} for more details.
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3)
Vi_x <- Vi(x) # symbolic object representing an arbitrary row of x, 
              # indexed by the letter "i"
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
