% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{Kmin_argKmin_reduction}
\alias{Kmin_argKmin_reduction}
\title{Kmin-argKmin reduction.}
\usage{
Kmin_argKmin_reduction(x, K, index)
}
\arguments{
\item{x}{A \code{LazyTensor} or a \code{ComplexLazyTensor}.}

\item{K}{An \code{integer} corresponding to the  number of minimal values required.}

\item{index}{A \code{character} corresponding to the reduction dimension that should
be either \strong{i} or \strong{j} to specify whether if the reduction is indexed by
\strong{i} (rows) or \strong{j} (columns).}
}
\value{
A matrix corresponding to the Kmin-argKmin reduction.
}
\description{
K-Min-argK-min reduction. Redirects to \code{Kmin_argKmin} function.
}
\details{
If \code{x} is a \code{LazyTensor} or a \code{ComplexLazyTensor},
\code{Kmin_argKmin(x, K, index)} will:
\itemize{
\item{if \strong{index = i},}{ return the \strong{K} minimal values of \strong{x}
and its indices over the \strong{i} indices (rows);}
\item{if \strong{index = j},}{ return the \strong{K} minimal values of \strong{x}
and its indices over the \strong{j} indices (columns).}
}

FIXME
}
\examples{
\dontrun{
x <- matrix(runif(150 * 3), 150, 3) # arbitrary R matrix, 150 rows and 3 columns
x_i <- LazyTensor(x, index = 'i')   # LazyTensor from matrix x, 
                                    # indexed by 'i'

K <- 2
k_argk_x <- Kmin_argKmin_reduction(x_i, K, "i")  # Kmin-argKmin reduction 
                                                 # over the "i" indices
}
}
\seealso{
\code{\link[=Kmin_argKmin]{Kmin_argKmin()}}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
