% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lazytensor_operations.R
\name{Arg}
\alias{Arg}
\title{Element-wise angle (or argument) of complex.}
\usage{
Arg(z)
}
\arguments{
\item{z}{A \code{ComplexLazyTensor} or any type of values accepted by R default
\code{Arg()} function.}
}
\value{
An object of class "ComplexLazyTensor" if the function is called with
a \code{ComplexLazyTensor}, else see R default \code{Arg()} function.
}
\description{
Symbolic unary operation for element-wise angle (or argument) of complex.
}
\details{
If \code{z} is a \code{ComplexLazyTensor}, \code{Arg(z)} returns a \code{ComplexLazyTensor}
that encodes, symbolically, the element-wise angle (or argument) of
complex \code{z} ; else, computes R default \code{Arg()} function.
}
\examples{
\dontrun{
z <- matrix(2 + 1i^ (-6:5), nrow = 4)         # complex matrix
z_i <- LazyTensor(z, "i", is_complex = TRUE)  # creating ComplexLazyTensor

Arg_z <- Arg(z_i)                             # symbolic matrix
}
}
\author{
Chloe Serre-Combe, Amelie Vernay
}
