% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmc.R
\name{num_grad}
\alias{num_grad}
\title{Numerical Gradient}
\usage{
num_grad(f, x)
}
\arguments{
\item{f}{The function for which the gradient is desired.}

\item{x}{The point at which the gradient should be approximated.}
}
\value{
The gradient of the function `f` at `x`.
}
\description{
Performs numerical differentiation of a function at a specific point.
Uses some numerical tricks to always achieve a reliable, though not
necessarily optimal, error.
}
\examples{
func = function(x) exp(-0.5 * x ^ 2) / sqrt(2 * pi)
grad = function(x) -x * exp(-0.5 * x ^ 2) / sqrt(2 * pi)
num_grad(func, -2)
abs(num_grad(func, -2) - grad(-2))

}
