% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rex2arma.inc.R
\name{symdim}
\alias{symdim}
\title{Get symbolic dimension of a statement (as an R code)}
\usage{
symdim(st, env = parent.frame(), dim_tab = NULL)
}
\arguments{
\item{st}{A statements, i.e. an item in a list obtained as result of
e.g. quote(a+b) or expression(a+b)}

\item{env}{An environement where a statement can be executed to get
its type and structure.}

\item{dim_tab}{A named list caching symbolic dimensions for R symbols.}
}
\value{
a character vector:\enumerate{
\item of legth 2 for a matrix \code{mat}, it returns
 \code{c("nrow(mat)", "ncol(mat)")}
\item of length 1 for a vector, e.g. "length(vec)"
\item a string "1" for a scalar}
}
\description{
Get symbolic dimension of a statement (as an R code)
}
\details{
If some error occurs, a NA is returned
The objects from the statement \code{st} are searched for in \code{env}
if dim_tab is NULL or an object is not there.
}
\examples{
a=b=c=1:2
lapply(parse(t="x <- a\%*\%(b+c); y=a+b"), symdim)
# or
symdim(expression(x <- a\%*\%(b+c))[[1L]])
}
