% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sdemodel.R
\name{sdemodel}
\alias{sdemodel}
\title{Model specification}
\usage{
sdemodel(phi=~x, phiprime=NULL, beta0=~beta0, beta1=~beta1,
   t0=0, x0=0, mu0=0, mup=1, mum=1)
}
\arguments{
\item{phi}{Transformation formula \eqn{y = \varphi(x, parameters)}.}

\item{phiprime}{Optional formula for derivative of \code{phi}.}

\item{beta0, beta1}{Optional formulas or constants, possibly giving a re-parameterization,.}

\item{t0, x0}{Formulas or constants for the initial condition.}

\item{mu0}{Formula or constant for the initial condition \eqn{\sigma_0}{\sigma0} multiplier.}

\item{mup, mum}{Formulas or constants for the process and measurement \eqn{\sigma} multipliers.}
}
\value{
List with model specification, to be used by \code{\link{sdefit}()}.
}
\description{
Specify transformation and re-parametrizations for reducible SDE model.
}
\examples{
   richards <- sdemodel(phi=~x^c, beta0=~b*a^c, beta1=~-b, mum=0)

}
