% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dependencies.R
\name{dependencies}
\alias{dependencies}
\title{Find R Package Dependencies in a Project}
\usage{
dependencies(
  path = getwd(),
  root = NULL,
  ...,
  progress = TRUE,
  errors = c("reported", "fatal", "ignored"),
  dev = FALSE
)
}
\arguments{
\item{path}{The path to a (possibly multi-mode) \R file, or a directory
containing such files. By default, all files within the current working
directory are checked, recursively.}

\item{root}{The root directory to be used for dependency discovery.
Defaults to the active project directory. You may need to set this
explicitly to ensure that your project's \code{.renvignore}s (if any) are
properly handled.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, \code{renv} will signal an error.}

\item{progress}{Boolean; report progress output while enumerating
dependencies?}

\item{errors}{How should errors that occur during dependency enumeration be
handled? See \strong{Errors} for more details.}

\item{dev}{Boolean; include 'development' dependencies as well? That is,
packages which may be required during development but are unlikely to be
required during runtime for your project. By default, only runtime
dependencies are returned.}
}
\value{
An \R \code{data.frame} of discovered dependencies, mapping inferred
package names to the files in which they were discovered.
}
\description{
Find \R packages used within a project.
}
\details{
\code{dependencies()} will crawl files within your project, looking for \R files
and the packages used within those \R files. This is done primarily by
parsing the code and looking for calls of the form:
\itemize{
\item \code{library(package)}
\item \code{require(package)}
\item \code{requireNamespace("package")}
\item \code{package::method()}
}

A subset of popular \R packages used for package management are also supported:
\itemize{
\item \href{https://cran.r-project.org/web/packages/pacman/index.html}{\code{pacman}}: \code{pacman::p_load(...)}
\item \href{https://cran.r-project.org/web/packages/box/index.html}{\code{box}}: \code{box::use(...)}
}

For \R package projects, dependencies expressed in the \code{DESCRIPTION} file
will also be discovered. Note that the \code{rmarkdown} package is required in
order to crawl dependencies in R Markdown files.
}
\section{Suppressing Errors}{


Depending on how you've structured your code, \code{renv} may emit errors when
attempting to enumerate dependencies within \code{.Rmd} / \code{.Rnw} documents.
For code chunks that you'd explicitly like \code{renv} to ignore, you can
include \code{renv.ignore=TRUE} in the chunk header. For example:

\if{html}{\out{<div class="sourceCode">}}\preformatted{```\{r chunk-label, renv.ignore=TRUE\}
# code in this chunk will be ignored by renv
```
}\if{html}{\out{</div>}}

Similarly, if you'd like \code{renv} to parse a chunk that is otherwise ignored
(e.g. because it has \code{eval=FALSE} as a chunk header), you can set:

\if{html}{\out{<div class="sourceCode">}}\preformatted{```\{r chunk-label, eval=FALSE, renv.ignore=FALSE\}
# code in this chunk will _not_ be ignored
```
}\if{html}{\out{</div>}}
}

\section{Ignoring Files}{


By default, \code{renv} will read your project's \code{.gitignore}s (if any) to
determine whether certain files or folders should be included when traversing
directories. If preferred, you can also create a \code{.renvignore} file (with
entries of the same format as a standard \code{.gitignore} file) to tell \code{renv}
which files to ignore within a directory. If both \code{.renvignore} and
\code{.gitignore} exist within a folder, the \code{.renvignore} will be used in lieu of
the \code{.gitignore}.

See \url{https://git-scm.com/docs/gitignore} for documentation on the
\code{.gitignore} format. Some simple examples here:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# ignore all R Markdown files
*.Rmd

# ignore all data folders
data/

# ignore only data folders from the root of the project
/data/
}\if{html}{\out{</div>}}
}

\section{Errors}{


\code{renv}'s attempts to enumerate package dependencies in your project can fail
-- most commonly, because of failures when attempting to parse your \R code.
The \code{errors} parameter can be used to control how \code{renv} responds to errors
that occur.

\tabular{ll}{
\strong{Name} \tab \strong{Action} \cr
\code{"reported"} \tab Errors are reported to the user, but are otherwise ignored. \cr
\code{"fatal"}    \tab Errors are fatal and stop execution. \cr
\code{"ignored"}  \tab Errors are ignored and not reported to the user. \cr
}

Depending on the structure of your project, you may want \code{renv} to ignore
errors that occur when attempting to enumerate dependencies. However, a more
robust solution would be to use an \code{.renvignore} file to tell \code{renv} not to
scan such files for dependencies, or to configure the project to require
explicit dependency management (\code{renv::settings$snapshot.type("explicit")})
and enumerate your dependencies in a project \code{DESCRIPTION} file.
}

\section{Development Dependencies}{


\code{renv} attempts to distinguish between 'development' dependencies and
'runtime' dependencies. For example, you might rely on e.g.
\href{https://cran.r-project.org/package=devtools}{devtools} and
\href{https://cran.r-project.org/package=roxygen2}{roxygen2} during development
for a project, but may not actually require these packages at runtime.
}

\examples{
\dontrun{

# find R package dependencies in the current directory
renv::dependencies()

}
}
