% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsers.R
\name{read_ini}
\alias{read_ini}
\title{Read INI Files}
\usage{
read_ini(file, ...)
}
\arguments{
\item{file}{The name and path of the INI configuration file.}

\item{...}{Other arguments passed to the function (currently there is none).}
}
\value{
The configuration value a named list,
each element of the list being a section of the INI file.
Each element (section) containing the key-value pairs from the INI file.
When no value is provided in the file, the value is \code{""}.
By convention, all values returned by the function are of character type.
R expressions following \code{!expr} are evaluated according to the settings of
the \code{R_RCONFIG_EVAL} environment variable or the option \code{"rconfig.eval"}.
}
\description{
Read INI (\code{.ini} file extension) configuration files.
}
\details{
An INI configuration file consists of sections, each led by a \verb{[section]} header,
followed by key/value entries separated by a specific string (\code{=} or \code{:} by default).
By default, section names are case sensitive but keys are not.
Leading and trailing whitespace is removed from keys and values.
Values can be omitted if the parser is configured to allow it,
in which case the key/value delimiter may also be left out.
Values can also span multiple lines, as long as they are indented deeper than the first line of the value.
Blank lines may be treated as parts of multiline values or ignored.
By default, a valid section name can be any string that does not contain \verb{\\n} or \verb{]}.
Configuration files may include comments, prefixed by specific characters (\verb{#} and \verb{;} by default).
Comments may appear on their own on an otherwise empty line, possibly indented.
}
\examples{
inifile <- system.file("examples", "example.ini", package = "rconfig")

## not evaluating R expressions
op <- options("rconfig.eval" = FALSE)
ini <- rconfig::read_ini(file = inifile)
str(ini)

## evaluating R expressions
options("rconfig.eval" = TRUE)
ini <- rconfig::read_ini(file = inifile)
str(ini)

# reset options
options(op)

}
