% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/obtain_permutation_matrix.R
\name{obtain_permutation_matrix}
\alias{obtain_permutation_matrix}
\title{Obtain Permutation Matrix from a Random Assignment Declaration}
\usage{
obtain_permutation_matrix(declaration, maximum_permutations = 10000)
}
\arguments{
\item{declaration}{A random assignment declaration, created by \code{\link{declare_ra}}.}

\item{maximum_permutations}{If the number of possible random assignments exceeds maximum_permutations, obtain_permutation_matrix will return a random sample of maximum_permutations permutations. Defaults to 10,000.}
}
\value{
a matrix of all possible (or a random sample of all possible) random assignments consistent with a declaration.
}
\description{
Obtain Permutation Matrix from a Random Assignment Declaration
}
\examples{

# complete

declaration <- declare_ra(N = 4)
perms <- obtain_permutation_matrix(declaration)
dim(perms)
obtain_num_permutations(declaration)

# blocked

blocks <- c("A", "A", "B", "B", "C", "C", "C")
declaration <- declare_ra(blocks = blocks)
perms <- obtain_permutation_matrix(declaration)
dim(perms)
obtain_num_permutations(declaration)

# clustered

clusters <- c("A", "B", "A", "B", "C", "C", "C")
declaration <- declare_ra(clusters = clusters)
perms <- obtain_permutation_matrix(declaration)
dim(perms)
obtain_num_permutations(declaration)

# large

declaration <- declare_ra(20)
choose(20, 10)
perms <- obtain_permutation_matrix(declaration)
dim(perms)


}
