% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rSPDE.R
\docType{package}
\name{rSPDE}
\alias{rSPDE}
\title{Rational approximations of fractional SPDEs.}
\description{
\code{rSPDE} is used for approximating fractional elliptic SPDEs
\deqn{L^\beta (\tau u(s)) = W,}
where \eqn{L} is a differential operator and \eqn{\beta>0}
is a general fractional power.
}
\details{
The approximation is based on a rational approximation of the
fractional operator, and allows for computationally efficient
inference and simulation.

The main functions for computing rational approximation objects are:
\itemize{
\item{\code{\link[=fractional.operators]{fractional.operators()}}}{works for general
rational operators}
\item{\code{\link[=matern.operators]{matern.operators()}}}{ works for random fields with
stationary Matern covariance functions}
\item{\code{\link[=spde.matern.operators]{spde.matern.operators()}}}{ works for random fields with
defined as solutions to a possibly non-stationary Matern-type SPDE model.}
\item{\code{\link[=rspde.matern]{rspde.matern()}}} {R-INLA implementation of the
covariance-based rational approximation for random fields with
stationary Matern covariance functions}
}
Basic statistical operations such as likelihood evaluations (see
\verb{[rSPDE.loglike], [rSPDE.matern.loglike]}) and kriging
predictions (see \verb{[predict.rSPDEobj], [predict.CBrSPDEobj]})
using the rational approximations are also implemented.

For illustration purposes, the package contains a simple FEM implementation
for models on R. For spatial models,
the FEM implementation in the \code{R-INLA} package is recommended.

For a more detailed introduction to the package, see the rSPDE Vignettes.
}
