% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strtrimcommon.R
\name{strtrimcommon}
\alias{strtrimcommon}
\title{Trim common portions from both sides of a vector of strings}
\usage{
strtrimcommon(x, split = "", USE.NAMES = FALSE, return.all = FALSE)
}
\arguments{
\item{x}{A vector of strings}

\item{split}{A \code{\link{character}} to use for splitting.  If \code{split} is empty (i.e.
\code{split  = ''}), \code{x} is split into single characters.  Otherwise, \code{x} is
split on \code{split} boundaries.}

\item{USE.NAMES}{logical; if \code{TRUE} use \code{x} as \code{\link{names}} for the result.}

\item{return.all}{logical; if \code{FALSE} (the default), returns only the striped
strings.  If \code{TRUE}, returns a list with elements \code{left}, \code{strings},
\code{right}, containing left and right common portions, and the trimmed
strings, respectively.}
}
\value{
A (named) vector of strings, or a list of string vectors (see
parameter \code{return.all} for details).
}
\description{
Trim common portions from both sides of a vector of strings
}
\examples{
x <- c('/tmp/remind2_test-convGDX2MIF_fulldata.gdx',
       '/tmp/remind2_test-Ariadne_fulldata.gdx',
       '/tmp/remind2_test-NAVIGATE_fulldata.gdx',
       '/tmp/remind2_test-NGFS_fulldata_oneRegi.gdx',
       '/tmp/remind2_test-SHAPE_fulldata.gdx')

strtrimcommon(x, USE.NAMES = TRUE)

x <- c('Some|name|with|common|text|elements',
       'Some|name|without|extra|text|elements')

strtrimcommon(x, split = '|', return.all = TRUE)
}
\author{
Michaja Pehl
}
