% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stacked_dodged.R
\name{ggplot_bar_stacked_dodged}
\alias{ggplot_bar_stacked_dodged}
\alias{add_stacked_dodged_xpos}
\alias{calc_stacked_dodged_xlabels}
\title{Stacked and dodged bar plots}
\usage{
ggplot_bar_stacked_dodged(data, mapping, gap = 1)

add_stacked_dodged_xpos(data, ..., gap = 1)

calc_stacked_dodged_xlabels(data, ..., gap = 1)
}
\arguments{
\item{data}{A data frame}

\item{mapping}{An aesthetic mapping generated by \link[=aes]{ggplot2:aes},
containing the aesthetics \code{x}, \code{y}, \code{fill}, and \code{dodge}.  The aesthetic
\code{x} will form groups on the x-axis, while \code{dodge} will form individual
bars within the groups.}

\item{gap}{The width of the gap between bars, relative to the width of the
bars themselves (default: \code{1}).}

\item{...}{A selection of two columns.  Both will be combined to form x-axis
coordinates.  The first will form the outer iteration (groups), the second
the inner iteration (bars within a group).  If unnamed, the column with
calculated positions will be called \code{xpos}.}
}
\value{
\code{add_stacked_dodged_xpos()} returns the input data frame with an
additional column.  Row and column order are preserved.
\code{calc_stacked_dodged_xlabels()} returns a named character vector for use
with \link[=scale_x_continuous]{ggplot2:scale_x_continuous}.
\code{ggplot_bar_stacked_dodged()} returns a \link[=ggplot]{ggplot2:ggplot} object.
}
\description{
Utility functions for plotting stacked (on top of each other) \emph{and} dodged
(next to each other) bars in the same figure.
}
\details{
\code{add_stacked_dodged_xpos()} adds x-axis positions to a data frame for
plotting two categorical variables within a bar plot.
\code{calc_stacked_dodged_xlabels()} calculates matching label positions on
the x-axis.
\code{ggplot_bar_stacked_dodged()} uses both functions to generate a plot.
}
\examples{
require(tidyverse)

set.seed(0)
(data <- crossing(a = factorise(c('left', 'center', 'right')),
                  b = factorise(c('top', 'middle', 'bottom')),
                  c = letters[1:4],
                  d = LETTERS[25:26]) \%>\%
        mutate(value = abs(rnorm(n())) + 0.2))

(plot.data <- add_stacked_dodged_xpos(data, c('c', 'a')))

(xlabels <- calc_stacked_dodged_xlabels(data, c('c', 'a')))

ggplot(data = plot.data) +
    scale_x_continuous(breaks = xlabels) +
    facet_wrap(~ d, ncol = 1, scales = 'free_x')

ggplot_bar_stacked_dodged(data, aes(x = a, y = value, fill = b, dodge = c),
                          gap = 1/3) +
    facet_wrap(~ d, ncol = 1, scales = 'free_x')
}
\author{
Michaja Pehl
}
