% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_column.R
\name{replace_column}
\alias{replace_column}
\alias{replace_column_}
\title{Replace data frame column}
\usage{
replace_column(
  data,
  mask,
  ...,
  drop.extra = FALSE,
  ignore.ambiguous.match = FALSE
)

replace_column_(
  data,
  mask,
  old_column,
  match_column,
  new_column,
  drop.extra = FALSE,
  ignore.ambiguous.match = FALSE
)
}
\arguments{
\item{data}{A data frame or a quitte object.}

\item{mask}{A data frame containing the \code{match_column} and the
\code{new_column}.}

\item{...}{Definition of \emph{old}, \emph{match}, and \emph{new} columns, see details.}

\item{drop.extra}{Drop rows not present in \emph{match} column?}

\item{ignore.ambiguous.match}{\code{replace_column()} will issue a warning if the
\emph{match} column in \code{mask} does not map unambiguously to \code{data}, unless it
is suppressed (\code{TRUE}).  Using ambiguous matches can be desired for
duplicating specific rows.}

\item{old_column}{\emph{old} column name, see details.}

\item{match_column}{\emph{match} column name, see details.}

\item{new_column}{\emph{new} column name, see details.}
}
\value{
A data frame or a quitte object, same as \code{data}.
}
\description{
Replaces the column of a data frame with that from a mask data frame.
}
\details{
Replaces the \emph{old} column in data frame \code{data} by the \emph{new} column from data
frame \code{mask} based on the matching between \emph{old} (\code{data}) and \emph{match}
(\code{mask}) columns.

This can be used to replace columns based on a mapping to, e.g., rename
scenarios, regions, etc. in model data.
}
\examples{
# simple example with matching old and match column names
(model_data <- data.frame(
    model  = c('Model1', '2ndModel', 'Model Three'),
    region = c('Region 1', 'Region 2', 'Region 1'),
    value  = 1:3))

(mask <- data.frame(
    model  = c('Model1', '2ndModel', 'Model Three', 'fourth Model'),
    clear_name = paste('Model', 1:4)))

replace_column(model_data, mask, model, clear_name)

# mismatched column names
(model_data <- data.frame(
    model  = c('Model1', '2ndModel', 'Model Three', 'fourth Model'),
    region = c('Region 1', 'Region 2', 'Region 1', 'Region 2'),
    value  = 1:4))

(mask <- data.frame(
    ugly_name  = c('Model1', '2ndModel', 'Model Three'),
    clear_name = paste('Model', 1:3)))

replace_column(model_data, mask, model = ugly_name, clear_name)

# SE example
replace_column_(model_data, mask, 'model', 'ugly_name', 'clear_name')

# dropping the extra entries in model
replace_column(model_data, mask, model = ugly_name, clear_name,
               drop.extra = TRUE)

# also works on quitte objects
require(dplyr)
(quitte <- tibble(
    model    = c('Model1', '2ndModel'),
    scenario = 'Scenario',
    region   = 'Region',
    variable = 'Variable',
    unit     = 'Unit',
    period   = 2010,
    value    = 1:2) \%>\%
        as.quitte())
replace_column(quitte, mask, model = ugly_name, clear_name)
str(.Last.value)

}
\author{
Michaja Pehl
}
