% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_quitte.R
\name{check_quitte}
\alias{check_quitte}
\title{Check IAMC-style data frame for inconsistencies.}
\usage{
check_quitte(quitte, check_variables, check_regions = NULL)
}
\arguments{
\item{quitte}{IAMC-style data frame.}

\item{check_variables}{List, string or file of variables to check.}

\item{check_regions}{List, string or file of regions to check.}
}
\value{
A data frame of all entries that did not match.
}
\description{
Check an IAMC-style data frame to see if values across variables and regions
sum up to the totals specified within the data frame.
}
\details{
Checking is performed for all variables and regions in
\code{check_variables} and \code{check_regions}, which can be passed as a list of
format

\if{html}{\out{<div class="sourceCode">}}\preformatted{list("sum" = c("summand1", "summand2", ...))
}\if{html}{\out{</div>}}

a character string of format

\if{html}{\out{<div class="sourceCode">}}\preformatted{sum1
summand1a
summand1b

sum2
summand2a
...
}\if{html}{\out{</div>}}

or as the path to a text file with this format.

If checking should be performed for variables or regions that are neither sum
nor summand (e.g., the variable 'GDP' should be summed across regions, but is
itself not a sum of other variables), include them as sum and their only
summand in the respective list (i.e., \code{list("GDP" = "GDP")} or as a double
line in the character string or file.

If \code{check_regions} is \code{NULL}, variables are check across all regions in
\code{quitte}.
}
\examples{
require(dplyr, quietly = TRUE, warn.conflicts = FALSE)
quitte <- rbind(
    data.frame(
        model    = "REMIND",
        scenario = "Baseline",
        region   = c("World", "USA", "EUR"),
        variable = "GDP",
        unit     = "US$2005",
        period   = 2005,
        value    = c(3, 1, 1)
    ),

    data.frame(
        model    = "REMIND",
        scenario = "Baseline",
        region   = "ROW",
        variable = c("FE|Total", "FE|Solids", "FE|Electricity"),
        unit     = "EJ/a",
        period   = 2005,
        value    = c(3, 1, 1)
    )
)

check_variables <- list(
    "FE|Total" = c("FE|Solids", "FE|Electricity"),
    "GDP"      = "GDP")

check_regions <- paste0("World\nUSA\nEUR\n\nROW\nROW")

print(quitte)
print(check_variables)
cat(check_regions)

check_quitte(quitte, check_variables, check_regions)

}
\author{
Michaja Pehl
}
