% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_quantiles.R
\name{calc_quantiles}
\alias{calc_quantiles}
\alias{calc_quantiles_}
\title{Sample Quantiles}
\usage{
calc_quantiles(
  .data,
  value = NA,
  probs = c(q0 = 0, q25 = 0.25, q50 = 0.5, q75 = 0.75, q100 = 1),
  na.rm = TRUE,
  type = 7
)

calc_quantiles_(
  .data,
  value = "value",
  probs = c(q0 = 0, q25 = 0.25, q50 = 0.5, q75 = 0.75, q100 = 1),
  na.rm = TRUE,
  type = 7
)
}
\arguments{
\item{.data}{a data frame, possibly grouped}

\item{value}{column name for which sample quantiles should be calculated}

\item{probs}{named numeric vector of probabilities with values in
\eqn{[0, 1]}.}

\item{na.rm}{logical; if \code{TRUE}, any \link{NA} and \link{NaN}s are removed from \code{data}
before the quantiles are computed.}

\item{type}{an integer between 1 and 9 select one of the nine quantile
algorithms detailed in \link{quantile} to be used.}
}
\value{
A data frame.
}
\description{
This is a wrapper function for \link{quantile} for easy use with data frames.
}
\examples{
require(dplyr)
require(tidyr)

tibble(group = rep(c("A", "B"), 10),
               value = 1:20) \%>\%
    group_by(group) \%>\%
    calc_quantiles() \%>\%
    pivot_wider(names_from = 'quantile')

}
\author{
Michaja Pehl
}
