% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcDecompEff.R
\name{calcDecompEff}
\alias{calcDecompEff}
\alias{calcDecompEff_scen}
\title{Decomposes a change in a variable based on the changes of its factors
(Kaya-like)}
\usage{
calcDecompEff(df, x, bau = NULL, pol = NULL, gap = "policy")

calcDecompEff_scen(df, x, bau)
}
\arguments{
\item{df}{a quitte object (with coluns model, scenario, region, variable,
unit, period, value)}

\item{x}{a character vector detailing the explained variable from the
decomposition as well as the factors in the decomposition. The explained
variable should be named "explained" in the character vector.}

\item{bau}{the name of the reference scenario, as a character string. It is
\code{NULL} as a default}

\item{pol}{the name of the policy scenario, as a character string. It is
\code{NULL} as a default}

\item{gap}{either \code{"policy"} or \code{"time"}. If \code{"policy"}, \code{bau} and \code{pol}
should be detailed. If \code{"time"}, \code{bau} and \code{pol} should stay \code{NULL}.}
}
\value{
A data frame with the effects of each component of the decomposition.
The data frame contains new columns:
\itemize{
\item \code{explained} gives the name of the explained variable
\item \code{factors} gives the name of the factor considered (from the decomposition
chain)
\item \code{type} gives the parameters:
\itemize{
\item \code{eff} is the result of the decomposition: how much of the change is to
be attributed to the factor
\item \code{value} is the value of the factor
\item \code{lag} is the value of the factor in the reference scenario or in the
previous period
\item \code{delta} is the difference in the factor's value between the policy and
the reference, or between one period and another
}
}
}
\description{
Computes decomposition for a change in time or policy of a variable. The
decomposition follows the methodology of the paper: "Some properties of an
exact energy decomposition model", Sun and Ang, 2000, Energy
}
\examples{
# In this example, emissions = ue * fe_ue * emi_fe
testdf = inline.data.frame(
  c("scenario ;period; variable; value",

    "reference; 2015 ; emissions; 10",
    "reference; 2015 ; ue       ;  4",
    "reference; 2015 ; fe_ue    ;  2",
    "reference; 2015 ; emi_fe   ;  1.25",

    "reference; 2050 ; emissions; 50",
    "reference; 2050 ; ue       ; 25",
    "reference; 2050 ; fe_ue    ;  1.25",
    "reference; 2050 ; emi_fe   ;  1.6",

    "policy1; 2015 ; emissions; 10",
    "policy1; 2015 ; ue       ;  4",
    "policy1; 2015 ; fe_ue    ;  2",
    "policy1; 2015 ; emi_fe   ;  1.25",

    "policy1; 2050 ; emissions; 20",
    "policy1; 2050 ; ue       ; 25",
    "policy1; 2050 ; fe_ue    ;  1.25",
    "policy1; 2050 ; emi_fe   ;  0.64",

    "policy2; 2015 ; emissions; 10",
    "policy2; 2015 ; ue       ;  4",
    "policy2; 2015 ; fe_ue    ;  2",
    "policy2; 2015 ; emi_fe   ;  1.25",

    "policy2; 2050 ; emissions; 10",
    "policy2; 2050 ; ue       ; 25",
    "policy2; 2050 ; fe_ue    ;  1.25",
    "policy2; 2050 ; emi_fe   ;  0.32")
)
testdf = as.quitte(testdf)
decomposition_chain = c(explained = "emissions", "ue","fe_ue","emi_fe")

result = calcDecompEff(testdf,x = decomposition_chain,gap = "time")
result2 = calcDecompEff(testdf,x = decomposition_chain,bau = "reference",pol = "policy1")
result3 = calcDecompEff_scen(testdf, x = decomposition_chain, bau = "reference")

}
\author{
Antoine Levesque
}
