% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_total.R
\name{sum_total}
\alias{sum_total}
\alias{sum_total_}
\title{Sum over one dimension of a data frame}
\usage{
sum_total(data, group, value = NA, name = "Total", na.rm = TRUE, weight = NA)

sum_total_(data, group, value = NA, name = "Total", na.rm = TRUE, weight = NA)
}
\arguments{
\item{data}{a data frame}

\item{group}{column for which the sum is to be calculated}

\item{value}{column of the numbers to be summed}

\item{name}{entry in column \code{group} for the sum; defaults to
\code{"Total"}}

\item{na.rm}{\code{logical.} Should missing values (including NaN) be removed
(default)?}

\item{weight}{column of the weights to be applied, if any}
}
\value{
a data frame
}
\description{
\code{sum_total()} is a short-hand function to calculate and insert the
(weighted) sum of a extensive (intensive) category in a data frame.
}
\examples{

require(dplyr)

(d <- expand.grid(
    UPPER  = LETTERS[1:2],
    lower  = letters[24:26],
    number = 1:2
) \%>\%
        arrange(UPPER, lower, number) \%>\%
        mutate(value = c(1:6, NA, 8:12)))

sum_total(d, UPPER)

sum_total(d, lower, name = 'sum over lower', na.rm = FALSE)

(e <- tibble(
    item = c('large', 'medium', 'small'),
    specific.value = c(1, 10, 100),
    size = c(1000, 100, 1)))

sum_total(e, item, value = specific.value, name = 'Average', weight = size)

}
\author{
Michaja Pehl
}
