% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeColNa.R
\name{removeColNa}
\alias{removeColNa}
\title{Removes all NA columns of a data frame}
\usage{
removeColNa(df)
}
\arguments{
\item{df}{a data frame}
}
\value{
a data frame
}
\description{
\code{removeColNa()} Removes all columns of a data frame for which all entries are
NA, or the default of fct_explict_na
}
\examples{
df <- data.frame(
    character = letters[1:5],
    factor = as.factor(LETTERS[1:5]),
    value = 1:5,
    unit = NA,
    unit2 = forcats::fct_na_value_to_level(factor(NA), level = '(Missing)'),
    stringsAsFactors = FALSE)
str(df)
str(removeColNa(df))
}
\author{
Antoine Levesque
}
