% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overwrite.R
\name{overwrite}
\alias{overwrite}
\title{Replace rows in a data frame with new values}
\usage{
overwrite(lhs, rhs, except = "value")
}
\arguments{
\item{lhs}{data frame with values that will replace others}

\item{rhs}{data frame with values that will be replaced}

\item{except}{names of columns that will not be considered in determining
which columns to replace; defaults to "value"}
}
\value{
data frame in which rows from rhs have been replaced with rows from
lhs
}
\description{
\code{overwrite()} \code{rbind()}s the data frames \code{lhs} and \code{rhs},
removing any duplicate lines, which are determined without regard to the
columns in \code{except}.
}
\examples{
require(dplyr)
data <- data.frame(expand.grid(UPPER = LETTERS[1:2],
                               lower = letters[24:26]),
                   value = 1:6)
data
data \%>\%
  filter(lower == "y") \%>\%
  mutate(value = value * 10) \%>\%
  overwrite(data)

}
\author{
Michaja Pehl
}
