% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor.data.frame.R
\name{factor.data.frame}
\alias{factor.data.frame}
\alias{factor.data.frame_}
\title{(Re-) Factorise factor and character columns in data frame}
\usage{
factor.data.frame(df, ...)

factor.data.frame_(df, .dots)
}
\arguments{
\item{df}{A data frame.}

\item{...}{Column names to factorise.}

\item{.dots}{Character vector of column names to factorise.}
}
\value{
A data frame.
}
\description{
\code{factor.data.frame()} turns character columns in a data frame into
factor columns and refactorises factor columns, silently dropping unused
levels.
}
\examples{
require(dplyr)
(df <- tibble(
    char = letters[1:3],
    fact = factor(LETTERS[24:26], levels = LETTERS[c(1:3, 24:26)]),
    num  = (1:3) ^ 2))

str(factor.data.frame(df))
str(factor.data.frame_(df, 'num'))

}
\seealso{
\code{\link[=character.data.frame]{character.data.frame()}}
}
\author{
Michaja Pehl
}
