% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_populate_range.R
\name{df_populate_range}
\alias{df_populate_range}
\title{Populate Data With Sequence Along Range}
\usage{
df_populate_range(df, column, n = 100)
}
\arguments{
\item{df}{A data frame.}

\item{column}{<\link[=dplyr_tidy_select]{tidy-select}> The column with data to
populate.}

\item{n}{Length of the sequence to return.  Defaults to 100.}
}
\value{
A data frame.
}
\description{
Generate sequences of n equidistant data points for a column in a data frame.
}
\examples{
require(dplyr, warn.conflicts = FALSE, quietly = TRUE)
require(tidyr, warn.conflicts = FALSE, quietly = TRUE)

tibble(A = (1:3) ^ 2,
       B = exp(0:2)) \%>\%
    pivot_longer(everything()) \%>\%
    arrange(name, value) \%>\%
    print() \%>\%
    df_populate_range(value, n = 6)

}
