% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chooseFilter.R
\name{chooseFilter}
\alias{chooseFilter}
\title{Allows to interactively filter data from quitte object}
\usage{
chooseFilter(
  data,
  types = c("model", "scenario", "region", "variable", "period"),
  keep = list()
)
}
\arguments{
\item{data}{A quitte object or something that can be transformed into one by as.quitte}

\item{types}{vector of quitte columns for user to select data if more than one option available}

\item{keep}{list with quitte columns as names and data points that should always be kept.
If the column is not also in types, only the elements in that list are kept}
}
\description{
Allows to interactively filter data from quitte object
}
\examples{
\dontrun{
  qe <- chooseFilter(quitte_example_dataAR6, types = c("model"),
                    keep = list(region = "World"))
}

}
\author{
Oliver Richters
}
