% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/character.data.frame.R
\name{character.data.frame}
\alias{character.data.frame}
\alias{character.data.frame_}
\title{Changes factor columns of a data frame into character columns}
\usage{
character.data.frame(df, ...)

character.data.frame_(df, .dots)
}
\arguments{
\item{df}{a data frame}

\item{...}{Column names to convert to characters.}

\item{.dots}{Character vector of column names to turn into characters.}
}
\value{
A data frame.
}
\description{
\code{character.data.frame()} turns factor columns of a data frame into
character columns.
}
\examples{
require(dplyr)
(df <- tibble(
    char = letters[1:3],
    fact = factor(LETTERS[24:26], levels = LETTERS[c(1:3, 24:26)]),
    num  = (1:3) ^ 2))

character.data.frame(df)
character.data.frame_(df, 'num')

}
\seealso{
\code{\link[=factor.data.frame]{factor.data.frame()}}
}
\author{
Antoine Levesque
}
