% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_addVariable.R
\name{calc_addVariable}
\alias{calc_addVariable}
\alias{calc_addVariable_}
\title{Calculate new variables}
\usage{
calc_addVariable(
  data,
  ...,
  units = NA,
  na.rm = TRUE,
  completeMissing = FALSE,
  only.new = FALSE,
  variable = variable,
  unit = unit,
  value = value,
  overwrite = TRUE
)

calc_addVariable_(
  data,
  .dots,
  na.rm = TRUE,
  completeMissing = FALSE,
  only.new = FALSE,
  variable = "variable",
  unit = "unit",
  value = "value",
  overwrite = TRUE
)
}
\arguments{
\item{data}{A data frame.}

\item{...}{Name-value pairs of calculation formulas. See details.}

\item{units}{Character vector of units corresponding to new variables.  Must
be of length equal to \code{...} or of length one (in which case all new
variables receive the same unit).}

\item{na.rm}{If \code{TRUE} (the default), remove items calculated as \code{NA}.  This
is generally the case for all calculations involving \code{NA} values, and all
calculations involving missing variables.  See \code{completeMissing} parameter.}

\item{completeMissing}{If \code{TRUE}, implicitly missing data, i.e. missing
combinations of input data, are filled up with 0 before the calculation,
and they are therefore not computed as \code{NA} (and potentially removed from
the output).  Make sure \code{0} is a sensible value for your calculations, else
complete missing values manually.  Defaults to \code{FALSE}.}

\item{only.new}{If \code{FALSE} (the default), add new variables to existing
ones.  If \code{TRUE}, return only new variables.}

\item{variable}{Column name of variables.  Defaults to \code{"variable"}.}

\item{unit}{Column name of units.  Defaults to \code{"unit"}.  Ignored if no
column with the same name is in \code{data} (e.g. data frames without unit
column).}

\item{value}{Column name of values.  Defaults to \code{"value"}.}

\item{overwrite}{If \code{TRUE} (the default), values are overwritten if they
already exist. If \code{FALSE} values are discarded and not overwritten if they
already exist}

\item{.dots}{Used to work around non-standard evaluation.  See details.}
}
\value{
A data frame.
}
\description{
Calculate new variables from existing ones, using generic formulas.
}
\details{
\code{...} is a list of name-value pairs with the general format

\if{html}{\out{<div class="sourceCode">}}\preformatted{"lhs" = "rhs + calculations - formula", "`lhs 2`" = "lhs / `rhs 2`"
}\if{html}{\out{</div>}}

where \code{lhs} are the names of new variables to be calculated and
\code{rhs} are the variables to calculate from. If \code{lhs} and \code{rhs}
are no proper \emph{identifiers}, they need to be quoted (see
\link[base:Quotes]{Quotes} for details). When in doubt, just quote.

If the new variables should have units, set \code{units} appropriately.

\code{.dots} is a named list of strings denoting formulas and optionally
units. The general format is

\if{html}{\out{<div class="sourceCode">}}\preformatted{list("`lhs 1`" = "`rhs` / `calculation`",
     "`lhs 2`" = "sin(`rhs 2`)")
}\if{html}{\out{</div>}}

Units are optionally included with the formulas in a vector like

\if{html}{\out{<div class="sourceCode">}}\preformatted{list("`lhs w/ unit`" = c("`rhs 1` + `rhs 2`", "rhs unit")
}\if{html}{\out{</div>}}

Units do not require quoting.

\code{...} and \code{.dots} are processed in order, and variables already
calculated in the same call can be used for further calculations. Other
existing columns, including \code{period}, can be referenced, but this is
not supported and the results are considered \emph{undefined}.
}
\examples{
data <- inline.data.frame(c(
    "model;    scenario;   region;   variable;     unit;                 period;   value",
    "REMIND;   Baseline;   USA;      GDP|MER;      billion US$2005/yr;   2010;     12990",
    "REMIND;   Baseline;   USA;      Population;   million;              2010;       310.4",
    "REMIND;   Baseline;   USA;      PE;           EJ/yr;                2010;        91.62",
    "REMIND;   Baseline;   CHN;      GDP|MER;      billion US$2005/yr;   2020;      8882",
    "REMIND;   Baseline;   CHN;      GDP|MER;      billion US$2005/yr;   2010;      4119",
    "REMIND;   Baseline;   CHN;      Population;   million;              2020;      1387",
    "REMIND;   Baseline;   CHN;      Population;   million;              2010;      1349"))

calc_addVariable(data, "GDPpC" = "`GDP|MER` / Population * 1e3",
                       "`ln GDPpC`" = "log(GDPpC)",
                       units = c("US$2005/cap", NA))
calc_addVariable_(
    data,
    list("`GDPpC`"    = c("`GDP|MER` / `Population` * 1e3", "US$/cap"),
         "`ln GDPpC`" = "log(`GDPpC`)")
)

}
\author{
Michaja Pehl
}
