% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin_distribute.R
\name{bin_distribute}
\alias{bin_distribute}
\alias{bin_distribute_sizes}
\title{Distribute into Equal Bins}
\usage{
bin_distribute(x, binsize)

bin_distribute_sizes(count, binsize)
}
\arguments{
\item{x}{A character vector to be distributed into bins.}

\item{binsize}{The maximum bin size.}

\item{count}{The number of items to be binned.}
}
\value{
\code{bin_distribute()} returns a list with the sub-vectors of \code{x}.
\code{bin_distribute_sizes()} returns a vector of sizes.
}
\description{
\code{bin_distribute(x, binsize)} distributes the items in \code{x} into the minimum
number of bins whose sizes differ at maximum by one and do not exceed
\code{binsize}.
\code{bin_distribute_sizes(count, binsize)} calculates the sizes of such bins for
\code{count} items.
}
\examples{
regions <- c('CAZ', 'CHA', 'EUR', 'IND', 'JPN', 'LAM', 'MEA', 'NEU', 'OAS',
             'REF', 'SSA', 'USA', 'World')

bin_distribute(regions, 5)
bin_distribute_sizes(length(regions), 5)

bin_distribute(regions, 6)
bin_distribute_sizes(length(regions), 6)

bin_distribute(regions, 7)
bin_distribute_sizes(length(regions), 7)

}
\author{
Michaja Pehl
}
