% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transformation.R
\docType{methods}
\name{changeVariables}
\alias{changeVariables}
\alias{changeVariables,qspray,list-method}
\title{Change of variables in a 'qspray' polynomial}
\usage{
\S4method{changeVariables}{qspray,list}(x, listOfQsprays)
}
\arguments{
\item{x}{a \code{qspray} polynomial}

\item{listOfQsprays}{a list containing at least \code{n} \code{qspray} 
objects, or objects coercable to \code{qspray} objects, where \code{n} 
is the number of variables of the polynomial given in the \code{x} argument}
}
\value{
The \code{qspray} polynomial obtained by replacing the variables of 
  the polynomial given in the \code{x} argument with the polynomials given 
  in the \code{listOfQsprays} argument.
}
\description{
Replaces the variables of a \code{qspray} polynomial with 
  some \code{qspray} polynomials. E.g. you have a polynomial \eqn{P(x, y)} 
  and you want the polynomial \eqn{P(x^2, x+y+1)}. This is an alias of 
  \code{\link{composeQspray}}.
}
\examples{
library(qspray)
f <- function(x, y) x*y/2 + 4*y
x <- qlone(1)
y <- qlone(2)
P <- f(x, y)
X <- x^2
Y <- x + y + 1
changeVariables(P, list(X, Y)) == f(X, Y) # should be TRUE
}
