% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqgate.R
\docType{class}
\name{sqgate}
\alias{sqgate}
\alias{sqgate-class}
\title{A single qubit gate}
\description{
This class represents a generic single qubit gate
}
\details{
The qubits are counted from 1 to \code{nbits} starting with the least
significant bit.
}
\section{Slots}{

\describe{
\item{\code{bit}}{Integer. The single bit to act on.}

\item{\code{M}}{complex valued array. The 2x2 matrix representing the
gate}

\item{\code{type}}{a character vector representing the type of gate}
}}

\examples{
x <- qstate(nbits=2)
## application of the X (NOT) gate to bit 1
z <- sqgate(bit=1L, M=array(as.complex(c(0,1,1,0)), dim=c(2,2))) * x
z

}
