// auto-generated by convert_xgboost_json.R
// Rscript convert_xgboost_json.R data/blockshuffle_xgboost_model.json xgboost_model_cpp_standalone.cpp TRUE
#include <array>
#include <memory>
#include <vector>
#include <Rcpp.h>
using namespace Rcpp;


namespace XgboostBlockshuffleModel {

struct XgTree {
  struct XgNode {
    XgNode * left_child;
    XgNode * right_child;
    uint8_t split_idx;
    double split_cond;
  };
  static constexpr uint8_t NULL_FEATURE_IDX = 255;
  static constexpr uint16_t NULL_NODE_INDEX = 65535;
  std::unique_ptr<XgNode[]> nodes;
  // constructor takes initializer lists
  XgTree(const std::vector<double> & split_conditions,
         const std::vector<uint8_t> & split_indices,
         const std::vector<uint16_t> & left_children,
         const std::vector<uint16_t> & right_children) :
  nodes(std::make_unique<XgNode[]>(split_conditions.size())) {
    for(size_t i = 0; i < split_conditions.size(); ++i) {
      nodes[i].split_idx = split_indices[i];
      nodes[i].split_cond = split_conditions[i];
      nodes[i].left_child = left_children[i] == NULL_NODE_INDEX ? nullptr : &nodes[left_children[i]];
      nodes[i].right_child = right_children[i] == NULL_NODE_INDEX ? nullptr : &nodes[right_children[i]];
    }
  }
  template <typename T> double predict(const T & features) const {
    static_assert(std::is_same<typename T::value_type, double>::value, "T::value_type must be double");
    XgNode * current_node = &nodes[0];
    while(true) {
      if(current_node->split_idx == NULL_FEATURE_IDX) {
        return current_node->split_cond;
      }
      if(features[current_node->split_idx] < current_node->split_cond) {
        current_node = current_node->left_child;
      } else {
        current_node = current_node->right_child;
      }
    }
  }
};

static constexpr float base_score = 5E-1;
static const std::array<XgTree, 383> XgForest = {
XgTree({31212.5,6148,9301,12695,3534,12.5,32429.5,7411.5,12.5,3509,7264.5,0.08832343,0.13275252,28154.5,26861,50,9232,0.085832566,0.12690106,3431,7270.5,7911.5,10801.5,25128.5,3.5,17.5,30362,23.5,4096,21958,8839.5,8599.5,7741.5,2135.5,-0.19277361,4347,9744.5,10902,22316,-0.060253423,1.5,-0.05095583,31845.5,21902.5,24721.5,29758.5,-0.03548529,37.5,18.5,3677.5,4638.5,5047.5,0.11624234,-0.09675267,-0.07529861,5.5,11.5,-0.13445579,4151.5,-0.196398,3355,12.5,9415.5,6328.5,4858.5,7168.5,9047,30465,27218.5,-0.038497962,-0.10716915,-0.07020622,-0.046549767,19670.5,24504,19811,-0.034653876,-0.03705976,30593.5,27,25,74.5,82.5,50.5,3099,6469.5,4813,7904.5,5970.5,7644.5,13508.5,4.5,-0.22501735,-0.18804602,-0.13953283,-0.13322094,-0.114333585,4025,-0.112285115,26.5,7040.5,2920.5,6443,12606,7982,5930.5,8268.5,-0.1261012,-0.10418894,8196.5,15494.5,1.5,24800.5,-0.020393373,-0.015238861,-0.026553243,-0.030579448,-0.025660722,-0.043570846,-0.039209906,-0.034925576,-0.049360357,-0.021480907,-0.109388255,-0.16808659,-0.018622398,-0.040027104,-0.019411812,0.051015563,-0.10592949,-0.06157106,-0.125133,-0.08938799,-0.022665503,-0.082187556,-0.030562153,-0.06682978,-0.015644152,-0.027055634,-0.03364571,-0.061703093,-0.2314926,-0.21189044,-0.19836496,-0.14003299,-0.19295715,-0.21000576,-0.12850265,-0.11553935,2.785165e-05,-0.08708977,-0.032977905,-0.07105397,-0.16501567,-0.12512659,-0.1103385,-0.047840297,-0.15254678,-0.19763857,-0.14426774,-0.11352795,-0.03747269,-0.08982993,-0.05169102,-0.030753914,-0.13138494,-0.09627881,-0.15725328,-0.10784673,-0.05828926,-0.11443853,-0.086779125,-0.073719054}, {3,4,0,5,5,8,5,3,8,3,5,255,255,4,6,6,0,255,255,7,4,4,6,2,8,8,2,7,5,1,6,6,6,5,255,5,0,2,3,255,8,255,5,4,4,6,255,6,8,4,0,6,255,255,255,8,8,255,1,255,5,8,3,1,1,1,3,2,2,255,255,255,255,0,4,0,255,255,4,2,5,0,2,7,5,2,6,0,0,0,0,8,255,255,255,255,255,1,255,0,0,1,3,0,1,0,5,255,255,5,3,8,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,65535,23,25,27,29,65535,65535,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,65535,61,63,65,67,65535,69,65535,71,73,75,77,65535,79,81,83,85,87,65535,65535,65535,89,91,65535,93,65535,95,97,99,101,103,105,107,109,111,65535,65535,65535,65535,113,115,117,65535,65535,119,121,123,125,127,129,131,133,135,137,139,141,143,145,65535,65535,65535,65535,65535,147,65535,149,151,153,155,157,159,161,163,65535,65535,165,167,169,171,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,65535,24,26,28,30,65535,65535,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,65535,62,64,66,68,65535,70,65535,72,74,76,78,65535,80,82,84,86,88,65535,65535,65535,90,92,65535,94,65535,96,98,100,102,104,106,108,110,112,65535,65535,65535,65535,114,116,118,65535,65535,120,122,124,126,128,130,132,134,136,138,140,142,144,146,65535,65535,65535,65535,65535,148,65535,150,152,154,156,158,160,162,164,65535,65535,166,168,170,172,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31585.5,6148,9301,12695,3534,12.5,26861,7411.5,12.5,3509,7264.5,0.07783469,0.118565455,14169,31845.5,1198.5,9232,0.076819114,0.11686351,3431,7270.5,7911.5,10801.5,-0.0674208,21746.5,-0.055925544,30589.5,51.5,1487.5,21958,9510,8599.5,2856,2135.5,-0.1736986,4347,9744.5,10902,22316,19.5,17.5,29750,-0.03175097,39.5,19.5,633.5,2087,5047.5,0.10454052,-0.08094872,-0.056886684,5.5,12.5,-0.18964861,3387,-0.1739591,14.5,15.5,9415.5,6328.5,4921.5,7168.5,9047,30465,27222,19560.5,19560.5,24623.5,24900,29829.5,30538.5,76.5,88.5,7430,330,-0.20313524,15.5,18.5,4098.5,7904.5,6867.5,7644.5,13508.5,4.5,-0.2030851,-0.124002255,-0.1546099,-0.11814834,-0.10209916,4061,-0.09937471,26.5,7040.5,2084,6443,12606,7982,5930.5,8255,-0.11127448,-0.09376096,8196.5,15494.5,1.5,24800.5,-0.018717563,-0.013425511,-0.020557433,-0.039885055,-0.024516828,-0.027548825,-0.03406721,-0.029144332,-0.033653587,29799.5,-0.0351874,-0.031542003,-0.024345025,-0.04393069,-0.07903876,-0.16633987,-0.033755537,-0.08859355,0.015915869,-0.020688986,-0.12574139,-0.06634237,-0.024440618,0.02384646,-0.07440428,-0.043552324,-0.014078637,-0.024233436,-0.063230656,-0.030437648,-0.20945907,-0.19003215,-0.17849724,-0.12463992,-0.17334834,-0.18925518,-0.11429246,-0.10372793,0.0010691691,-0.07789762,-0.029527446,-0.066078536,-0.16385257,-0.11209817,-0.09651234,-0.04164366,-0.13615227,-0.17979969,-0.12961142,-0.10191446,-0.034818012,-0.08191276,-0.04724771,-0.02784901,-0.11784561,-0.086984396,-0.14246544,-0.09711028,-0.053115197,-0.10303377,-0.078602895,-0.06592098,-0.031801287,-0.035978228}, {3,4,0,5,5,8,6,3,8,3,5,255,255,4,5,2,0,255,255,7,4,4,6,255,6,255,2,1,3,1,7,6,5,5,255,5,0,2,3,8,8,6,255,0,8,7,2,6,255,255,255,8,8,255,5,255,8,8,3,1,1,1,3,2,2,6,6,4,6,4,0,6,0,0,6,255,8,8,5,0,7,0,0,8,255,255,255,255,255,1,255,0,0,7,3,0,1,0,5,255,255,5,3,8,3,255,255,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,65535,23,25,27,29,65535,65535,31,33,35,37,65535,39,65535,41,43,45,47,49,51,53,55,65535,57,59,61,63,65,67,69,65535,71,73,75,77,79,65535,65535,65535,81,83,65535,85,65535,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,65535,125,127,129,131,133,135,137,139,65535,65535,65535,65535,65535,141,65535,143,145,147,149,151,153,155,157,65535,65535,159,161,163,165,65535,65535,65535,65535,65535,65535,65535,65535,65535,167,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,65535,24,26,28,30,65535,65535,32,34,36,38,65535,40,65535,42,44,46,48,50,52,54,56,65535,58,60,62,64,66,68,70,65535,72,74,76,78,80,65535,65535,65535,82,84,65535,86,65535,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,65535,126,128,130,132,134,136,138,140,65535,65535,65535,65535,65535,142,65535,144,146,148,150,152,154,156,158,65535,65535,160,162,164,166,65535,65535,65535,65535,65535,65535,65535,65535,65535,168,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({32357.5,6077.5,9301,8398,3633,12.5,26861,1148,9908.5,3606.5,7303,0.071411066,0.10789805,17.5,32312,46,1350.5,17160,12.5,6062.5,8359,8824,10801.5,22333.5,24623.5,26293,30589.5,65,18.5,15.5,2159.5,7689,12514.5,0.0713354,0.10403522,2059,6073.5,1856,9.5,4510,9636,15029,22316,16345.5,31701.5,14169,24795,-0.056891646,-0.03898899,29758.5,-0.02858122,39.5,37,3782,784.5,1294,2448,5099.5,4411.5,4191.5,10049.5,-0.11075773,63.5,-0.17544948,1658.5,-0.12044277,8540.5,-0.16511814,13.5,-0.1222045,-0.15244594,3531.5,9454.5,6525.5,4856.5,8387.5,10735.5,29959.5,27222,-0.03854121,19811,-0.071955934,24504,-0.06085459,19811,-0.03118673,-0.02704135,29829.5,30593.5,26,103.5,-0.06184878,-0.15416124,7636.5,19831,621.5,685.5,26.5,2588.5,1334.5,1356,19.5,-0.068376824,5196.5,5675,4.5,15.5,1.5,8047,-0.05036987,-0.067606114,-0.13197546,-0.103653945,5.5,8.5,-0.10830895,-0.09508573,4085.5,2091.5,5630,6609,4559.5,6144.5,12.5,10277,5775,10902,18410.5,31593,8198.5,15494.5,18740,3.5,-0.018004097,-0.012108761,-0.021752704,-0.024758546,-0.021463705,-0.03713825,-0.0302775,29799.5,-0.031717505,-0.028444827,-0.032642074,-0.014567325,-0.058847405,-0.1499997,-0.031238725,-0.07296889,-0.011281392,0.073728345,-0.011971003,-0.07351745,0.060817905,-0.0015144268,-0.11430367,-0.053216774,-0.12295524,-0.056292273,-0.052369505,-0.08871683,-0.1634177,-0.08968789,-0.020666925,0.009320738,-0.074816726,-0.036906715,-0.026137402,-0.059606057,-0.0099985,-0.01806481,-0.008296469,0.00097406463,-0.013157651,-0.028386388,-0.026601652,-0.06756853,-0.17938471,-0.16087392,-0.16318603,-0.18020721,-0.10665758,-0.047899168,-0.14559166,-0.093846545,-0.06533028,-0.07793322,-0.0265264,-0.049367297,-0.12797736,-0.09934768,-0.12124925,-0.041624863,-0.14170235,-0.17202495,-0.1234132,-0.10857896,-0.02360016,-0.05754252,-0.024794834,-0.082041346,-0.022746122,-0.06713819,-0.090622984,-0.044855755,-0.10361645,-0.07853867,-0.12748688,-0.08739639,-0.045766734,-0.09265919,-0.053705703,-0.069386296,-0.028706998,-0.03248554}, {3,0,0,7,1,8,6,6,1,7,1,255,255,8,5,3,7,6,8,6,0,0,6,0,4,0,2,2,8,8,2,6,5,255,255,1,2,1,8,1,4,0,3,0,1,4,2,255,255,6,255,0,0,1,1,0,6,6,1,2,4,255,0,255,7,255,4,255,8,255,255,4,3,5,5,5,2,2,2,255,0,255,4,255,0,255,255,4,4,2,6,255,255,4,1,0,6,0,1,7,3,8,255,7,5,8,8,8,2,255,255,255,255,8,8,255,255,1,5,6,1,1,1,8,4,6,2,0,3,1,3,7,8,255,255,255,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,65535,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,65535,65535,63,65,67,69,71,73,75,77,79,81,83,85,65535,65535,87,65535,89,91,93,95,97,99,101,103,105,107,65535,109,65535,111,65535,113,65535,115,65535,65535,117,119,121,123,125,127,129,131,65535,133,65535,135,65535,137,65535,65535,139,141,143,145,65535,65535,147,149,151,153,155,157,159,161,163,65535,165,167,169,171,173,175,65535,65535,65535,65535,177,179,65535,65535,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,65535,65535,65535,65535,65535,65535,65535,213,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,65535,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,65535,65535,64,66,68,70,72,74,76,78,80,82,84,86,65535,65535,88,65535,90,92,94,96,98,100,102,104,106,108,65535,110,65535,112,65535,114,65535,116,65535,65535,118,120,122,124,126,128,130,132,65535,134,65535,136,65535,138,65535,65535,140,142,144,146,65535,65535,148,150,152,154,156,158,160,162,164,65535,166,168,170,172,174,176,65535,65535,65535,65535,178,180,65535,65535,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,65535,65535,65535,65535,65535,65535,65535,214,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31212.5,6077.5,9301,9908.5,3633,12.5,32429.5,4853.5,14.5,3447,7303,0.06305329,0.09651057,28154.5,21746.5,4148,7364,0.068616845,0.10332783,6062.5,8257,7899,10896.5,25128.5,4.5,18.5,26861,50,3019.5,5224.5,6365.5,2059,8540.5,1856,12.5,4142.5,9629.5,8269,22316,-0.044852916,1.5,-0.035109773,31845.5,19560.5,19560.5,17.5,30403.5,23.5,50.5,1634,5826.5,5405.5,7215,5892,8557,-0.15881824,7495,7.5,5.5,-0.14960927,-0.09549347,5688,-0.14715782,13.5,9699,6822,4856.5,4669.5,10862,31018,27218.5,-0.026664943,-0.082171656,-0.050439198,-0.03629526,-0.01579371,-0.010884113,-0.017133985,-0.033727493,24719,24860,29758.5,-0.025868295,37.5,19.5,65,1010.5,5765,3259.5,4016,5628.5,18.5,5630,6115.5,7689,31338.5,3585.5,-0.07001058,17.5,-0.09587168,-0.12657933,2630,7630,-0.1434669,12.5,-0.1287557,-0.10047221,7114,6477.5,3377.5,7599.5,2353.5,9345.5,6.5,18269,9276.5,7418.5,7780,11195.5,8195,16002.5,1.5,2.5,-0.020401068,-0.022468828,-0.028078271,-0.023954934,29829.5,30551.5,-0.025396137,-0.102277875,-0.01790414,0.0060792514,-0.06025187,-0.13873486,-0.022638718,-0.051733937,-0.09649373,-0.14247942,-0.10294932,-0.08691474,-0.06445934,-0.04188244,-0.07080286,-0.089956395,-0.011574919,0.01602062,-0.019704403,-0.055222053,-0.032243937,-0.0591165,-0.012555256,-0.027212858,-0.04729144,-0.0062138713,-0.08509064,-0.06721427,-0.018770382,-0.014245677,-0.16002889,-0.13491073,-0.14900653,-0.13907139,-0.15486296,-0.16516231,-0.08408938,-0.09557885,-0.06921622,-0.0824039,-0.035504814,-0.06621089,-0.023774348,-0.04732505,-0.12627296,-0.08760793,-0.062404998,-0.033873644,-0.11504751,-0.14836688,-0.10420044,-0.077398784,-0.013559577,-0.05852119,-0.05977431,-0.040568724,-0.0066655762,-0.024014432,-0.046292465,-0.075452626,-0.09084756,-0.07060962,-0.1149379,-0.078670114,-0.039623883,-0.08304722,-0.045287643,-0.06249248,-0.027254043,-0.026144454,-0.028613744,-0.02546227}, {3,0,0,1,1,8,5,7,8,7,1,255,255,4,6,6,4,255,255,6,0,0,2,2,8,8,6,6,1,6,1,1,4,1,8,1,4,5,3,255,8,255,5,6,6,8,6,7,7,1,6,0,7,2,3,255,4,8,8,255,255,5,255,8,3,5,5,6,6,2,2,255,255,255,255,255,255,255,255,4,2,6,255,6,8,2,6,6,3,7,2,8,1,6,6,5,1,255,8,255,255,7,6,255,8,255,255,0,6,4,4,5,2,8,6,0,7,4,7,5,3,8,8,255,255,255,255,4,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,65535,23,25,27,29,65535,65535,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,65535,71,65535,73,75,77,79,81,83,85,87,89,91,93,95,97,65535,99,101,103,65535,65535,105,65535,107,109,111,113,115,117,119,121,65535,65535,65535,65535,65535,65535,65535,65535,123,125,127,65535,129,131,133,135,137,139,141,143,145,147,149,151,153,155,65535,157,65535,65535,159,161,65535,163,65535,65535,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,65535,65535,65535,65535,197,199,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,65535,24,26,28,30,65535,65535,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,65535,72,65535,74,76,78,80,82,84,86,88,90,92,94,96,98,65535,100,102,104,65535,65535,106,65535,108,110,112,114,116,118,120,122,65535,65535,65535,65535,65535,65535,65535,65535,124,126,128,65535,130,132,134,136,138,140,142,144,146,148,150,152,154,156,65535,158,65535,65535,160,162,65535,164,65535,65535,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,65535,65535,65535,65535,198,200,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31585.5,6029,9301,12334,3597.5,12.5,23285.5,5366.5,12.5,3535,7265,0.057978388,0.090688825,17.5,31845.5,3815,5632,0.056882966,0.08595086,3721.5,8105.5,9644,10758.5,16345.5,19811,27625,26861,2256,3035,5303.5,5600.5,5402.5,2561.5,14.5,3755.5,5874.5,14547.5,7408,22316,-0.029850645,21902.5,16445.5,-0.033054873,-0.053117484,-0.0375898,17.5,30219.5,1581.5,2435.5,2977.5,4630,5566.5,7314,5236.5,5077,-0.089275144,14016.5,-0.1375262,6311,-0.089547575,-0.07456879,6225,-0.08348824,7940.5,9359,10259.5,5357,6252,10564,30743,27222,19670.5,-0.017682804,-0.034530398,-0.016585778,24504,24779.5,29750,-0.02339281,50,15.5,5692.5,4618,1599.5,3982.5,4496,5798,-0.046255343,3509.5,6364,10.5,-0.068691194,1797.5,15.5,5927.5,1994.5,12.5,-0.085107505,-0.10678848,-0.14545716,-0.104101814,4694,4136.5,9518,9238.5,5449,7.5,12.5,8918,7643,5397,7422,12817.5,8801.5,15551.5,1.5,24800.5,-0.012917051,16,-0.01745679,-0.020081462,-0.02654486,-0.022296987,29798,29473.5,-0.02023786,-0.040174585,-0.09833309,-0.044817317,-0.0045871898,-0.03455814,-0.04179954,-0.013092073,-0.13038878,-0.09006504,-0.03775576,-0.08201242,-0.04561917,-0.061981983,-0.016288951,-0.059072394,-0.007967003,0.016415007,-0.024929725,-0.0047256975,-0.048305884,-0.069395356,-0.0031949633,-0.030955015,-0.0059099174,0.009289618,-0.045405056,-0.070942126,-0.14087243,-0.13276714,-0.13751213,-0.157084,-0.075586006,-0.055967975,-0.11124082,-0.08414447,-0.05985549,-0.03023538,-0.04736151,-0.021943139,-0.080422886,-0.10195875,-0.081785284,-0.092501484,-0.120646514,-0.1496071,-0.097136505,-0.068916045,-0.020009004,-0.055182826,-0.036797862,-0.06994936,-0.02618744,-0.017135581,-0.06717875,-0.01582368,-0.08498429,-0.063574515,-0.104123235,-0.07116533,-0.035231914,-0.07514268,-0.057426024,-0.046489365,-0.009826398,-0.011496036,-0.02414745,-0.025321422,-0.02916567,-0.02561051}, {3,2,0,3,3,8,2,1,8,5,3,255,255,8,5,0,6,255,255,1,4,2,4,0,0,0,6,7,3,0,3,4,3,8,1,3,2,7,3,255,4,0,255,255,255,8,4,6,0,5,3,1,3,7,0,255,2,255,4,255,255,5,255,2,5,2,3,6,0,4,2,0,255,255,255,4,0,6,255,6,8,6,7,3,6,6,7,255,2,3,8,255,2,8,7,1,8,255,255,255,255,3,3,2,0,3,8,8,1,4,4,5,3,3,5,8,3,255,8,255,255,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,65535,23,25,27,29,65535,65535,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,65535,71,73,65535,65535,65535,75,77,79,81,83,85,87,89,91,93,65535,95,65535,97,65535,65535,99,65535,101,103,105,107,109,111,113,115,117,65535,65535,65535,119,121,123,65535,125,127,129,131,133,135,137,139,65535,141,143,145,65535,147,149,151,153,155,65535,65535,65535,65535,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,65535,189,65535,65535,65535,65535,191,193,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,65535,24,26,28,30,65535,65535,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,65535,72,74,65535,65535,65535,76,78,80,82,84,86,88,90,92,94,65535,96,65535,98,65535,65535,100,65535,102,104,106,108,110,112,114,116,118,65535,65535,65535,120,122,124,65535,126,128,130,132,134,136,138,140,65535,142,144,146,65535,148,150,152,154,156,65535,65535,65535,65535,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,65535,190,65535,65535,65535,65535,192,194,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31212.5,6033.5,9301,7411.5,3534,11.5,32429.5,6017,4726,3528,7264.5,2.5,0.07808974,28154.5,26400,4585,1519.5,11.5,9232,8575.5,8615.5,8749.5,10801.5,2851.5,0.052599426,25128.5,2.5,17.5,10.5,50,8060,-0.12658696,4432.5,0.051111203,0.078117535,8087.5,9510,7.5,6.5,2708.5,3827.5,4328,14669,10902,22316,0.012761064,0.035928898,-0.037134346,-0.067903064,-0.026419822,30484.5,21902.5,24729.5,29386,30355,23.5,4925,4629,5470.5,2958,5560.5,6291.5,5970.5,-0.05926618,-0.034489524,2475,1789.5,3320.5,12.5,-0.11888277,11.5,-0.11769543,-0.087196946,1833,9415.5,9711,5847,8612,13287,29959.5,27218.5,-0.042978927,-0.035668876,13.5,24623.5,19560.5,24922.5,-0.021227047,30221.5,29764.5,-0.02038865,37.5,76.5,1164,6992,41.5,3739,7760,6548,1496,3932.5,5692.5,5920,1225.5,7904.5,1.5,5291,8029.5,2372.5,-0.12235361,2619,-0.1170459,-0.09235528,-0.12605532,-0.13537958,-0.080918826,-0.06663796,-0.13057198,2201,26.5,7040.5,4619,10335.5,11.5,19083,6134,10796.5,-0.07318728,-0.060950745,8196.5,16002.5,18740,3.5,19670.5,-0.010992525,-0.01619373,-0.018124042,-0.015808051,-0.025649248,-0.021160107,-0.0184262,29767,-0.02154517,-0.02154769,-0.022611303,-0.023453197,-0.089502394,-0.0092990175,-0.02100065,-0.036370028,-0.05152778,-0.012418599,-0.057443645,-0.06364727,-0.008897851,-0.006003889,-0.03498799,-0.06824957,-0.042236138,-0.009105221,-0.031085346,-0.046975356,-0.075290814,-0.045075223,-0.065334864,-0.010797237,-0.04974455,-0.060059924,-0.0070241066,-0.0071988315,-0.015386321,-0.0027697177,-0.015339485,-0.0042365347,-0.019933308,-0.03765328,-0.05779199,-0.13648954,-0.12602574,-0.12604064,-0.083704196,-0.11374573,-0.09321609,-0.09830298,-0.07048791,0.00833775,-0.053091276,-0.018621067,-0.0486457,-0.10109353,-0.06633856,-0.09129113,-0.0807243,-0.10644434,-0.1338722,-0.09056612,-0.05173684,-0.020723347,-0.03878508,-0.01560057,-0.07148789,-0.07859906,-0.05697739,-0.09344191,-0.06353309,-0.015760316,-0.06766258,-0.03800605,-0.05113175,-0.0115104355,-0.008827521,-0.022556921,-0.023644572}, {3,4,0,3,5,8,5,2,2,3,5,8,255,4,6,7,7,8,0,2,2,4,6,2,255,2,8,8,8,6,6,255,5,255,255,2,7,8,8,5,1,5,4,2,3,255,255,255,255,255,7,4,2,2,0,7,1,0,2,5,1,5,0,255,255,1,7,1,8,255,8,255,255,3,3,0,3,7,0,2,2,255,255,8,4,6,6,255,2,6,255,6,0,6,0,0,4,1,0,0,4,4,4,6,0,8,4,4,7,255,1,255,255,255,255,255,255,255,7,0,0,5,0,8,0,6,0,255,255,5,3,7,8,0,255,255,255,255,255,255,255,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,37,39,41,43,45,65535,47,49,51,53,55,57,65535,59,65535,65535,61,63,65,67,69,71,73,75,77,79,65535,65535,65535,65535,65535,81,83,85,87,89,91,93,95,97,99,101,103,105,65535,65535,107,109,111,113,65535,115,65535,65535,117,119,121,123,125,127,129,131,65535,65535,133,135,137,139,65535,141,143,65535,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,65535,181,65535,65535,65535,65535,65535,65535,65535,183,185,187,189,191,193,195,197,199,65535,65535,201,203,205,207,209,65535,65535,65535,65535,65535,65535,65535,211,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,38,40,42,44,46,65535,48,50,52,54,56,58,65535,60,65535,65535,62,64,66,68,70,72,74,76,78,80,65535,65535,65535,65535,65535,82,84,86,88,90,92,94,96,98,100,102,104,106,65535,65535,108,110,112,114,65535,116,65535,65535,118,120,122,124,126,128,130,132,65535,65535,134,136,138,140,65535,142,144,65535,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,65535,182,65535,65535,65535,65535,65535,65535,65535,184,186,188,190,192,194,196,198,200,65535,65535,202,204,206,208,210,65535,65535,65535,65535,65535,65535,65535,212,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31212.5,6077.5,9301,8398,3633,12.5,32429.5,1199.5,9908.5,3447,7303,2.5,0.06997978,28154.5,26861,46,1408.5,17160,12.5,8575.5,8257,9404,10896.5,0.030217875,2851.5,25128.5,4.5,17.5,4.5,65,18.5,2528,6525,7583.5,12514.5,0.045704048,3239,5.5,4.5,1856,6.5,5479.5,8992.5,8255,5.5,0.026102403,0.049254,-0.03065567,1.5,-0.025464019,30484.5,21902.5,24623.5,29386,30403.5,39.5,37,1164,446.5,14.5,1254,2416.5,4201,4191.5,6270.5,-0.08209174,-0.037961513,0.07377372,0.022298297,2582.5,1930,-0.10199734,12.5,-0.11228496,14.5,-0.07701616,-0.10617124,7276.5,9425.5,5262,4918.5,5703.5,7780,19671.5,22500,-0.016210798,-0.060972102,-0.039008167,-0.032394093,19670.5,24730,19811,24872,-0.019031456,-0.020851992,29764.5,-0.018486237,26.5,96.5,-0.04753789,6.5,637,7636.5,574.5,670,1414.5,2657.5,-0.14947747,2707,1901,4862.5,7789.5,7570.5,4.5,15.5,1.5,11225.5,7946.5,7009.5,1369,3166.5,-0.112881266,-0.12105167,3714.5,-0.063885234,7254.5,1508.5,6877.5,7599.5,3414.5,9812,14663,6805.5,9330,7418.5,4.5,10801,12500.5,1.5,30743,27290.5,-0.011027157,13,-0.014922224,-0.016425433,-0.01304883,-0.025167987,-0.0198136,-0.01728504,29829.5,30551.5,-0.0223657,-0.0065725814,-0.038252316,-0.13016555,-0.13466468,-0.10998016,-0.016320813,-0.03619159,-0.008755527,-0.05256613,-0.011240238,-0.12426646,0.056800228,-0.0025475062,-0.056971848,-0.08763748,-0.037365686,-0.06994829,-0.10070812,-0.0732784,-0.025072932,-0.00064651604,-0.04415108,-0.01822207,-0.06984424,-0.1120553,-0.051525045,-0.029403979,-0.0016025578,-0.011313901,-0.0022264884,0.005983376,-0.0041262936,-0.017169066,-0.047168672,-0.01579387,-0.12806432,-0.11394302,-0.0661479,-0.11237035,-0.12667069,-0.109412014,-0.102304034,-0.067421615,-0.07934212,-0.06768933,-0.051690992,-0.001186988,-0.110720955,-0.065653846,-0.05428912,-0.039609972,-0.017488012,-0.03387655,-0.076422565,-0.05922664,-0.024288885,-0.041093916,-0.07804632,-0.10667666,-0.07912801,-0.06904793,-0.010723334,-0.041662656,-0.05197058,-0.027381945,0.0059233457,-0.0036454033,-0.025176397,-0.013283886,-0.056887466,-0.04769229,-0.02761337,-0.043101948,-0.053645022,-0.063038684,-0.06263131,-0.04628191,-0.007887202,-0.009857302,-0.01974537,-0.018807271,-0.020747995,-0.01826831}, {3,0,0,7,1,8,5,6,1,7,1,8,255,4,6,3,7,6,8,2,0,0,2,255,2,2,8,8,8,2,8,6,6,6,5,255,0,8,8,1,8,1,6,5,8,255,255,255,8,255,7,4,4,2,6,0,0,1,1,8,5,0,7,2,4,255,255,255,255,7,3,255,8,255,8,255,255,0,3,7,1,6,4,7,1,255,255,255,255,0,0,0,6,255,255,6,255,4,4,255,8,0,4,0,6,6,2,255,0,5,1,6,3,8,8,8,5,0,6,3,1,255,255,5,255,0,5,0,4,7,0,2,5,0,7,8,3,3,8,4,0,255,8,255,255,255,255,255,255,4,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,37,39,41,43,65535,45,47,49,51,53,55,57,59,61,63,65,65535,67,69,71,73,75,77,79,81,83,65535,65535,65535,85,65535,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,65535,65535,65535,65535,117,119,65535,121,65535,123,65535,65535,125,127,129,131,133,135,137,139,65535,65535,65535,65535,141,143,145,147,65535,65535,149,65535,151,153,65535,155,157,159,161,163,165,167,65535,169,171,173,175,177,179,181,183,185,187,189,191,193,65535,65535,195,65535,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,65535,229,65535,65535,65535,65535,65535,65535,231,233,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,38,40,42,44,65535,46,48,50,52,54,56,58,60,62,64,66,65535,68,70,72,74,76,78,80,82,84,65535,65535,65535,86,65535,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,65535,65535,65535,65535,118,120,65535,122,65535,124,65535,65535,126,128,130,132,134,136,138,140,65535,65535,65535,65535,142,144,146,148,65535,65535,150,65535,152,154,65535,156,158,160,162,164,166,168,65535,170,172,174,176,178,180,182,184,186,188,190,192,194,65535,65535,196,65535,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,65535,230,65535,65535,65535,65535,65535,65535,232,234,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31585.5,6077.5,9301,4853.5,3633,14.5,26400,1019.5,9908.5,3606.5,7303,2.5,0.06869989,17.5,32312,47.5,1450.5,7364,14.5,6062.5,8359,9711,10499,2851.5,0.045938127,23907.5,14518,31845.5,30403.5,65,17.5,2528,4150.5,5224.5,6365.5,0.043304134,0.06486601,2059,6073.5,1856,17048.5,4516.5,5137,8269,2.5,0.010166226,0.032791506,16345.5,11856.5,-0.042640533,24730,1.5,-0.022871641,29764.5,-0.01687764,39.5,37,1292.5,561,15.5,1254,2212.5,3019.5,18.5,7215,5892,8557,-0.11183286,7495,3260.5,8540.5,-0.09682367,14.5,-0.09201198,-0.06559578,7276.5,9732.5,10838.5,10125,5775,10902,11536.5,22500,-0.023103863,18319.5,-0.03762662,24737.5,19560.5,24794,-0.011238689,-0.03129927,29829.5,30551.5,22,103.5,-0.042570423,430,751,7636.5,483.5,525.5,1894,686.5,-0.13680625,19.5,744.5,2419.5,1634,6562,5405.5,3876.5,5861,7326,2293.5,13308.5,-0.053245246,17.5,15.5,8011.5,-0.08231487,-0.05954194,4.5,11.5,7662,-0.055463027,3364,2329.5,9425.5,9687.5,10027,5978,9083,7.5,9330,7330,7780,-0.049740076,11386,19711.5,29970.5,28650.5,18602.5,14.5,-0.013438689,-0.01477653,-0.01090189,-0.021524353,-0.01814348,-0.015721213,29741.5,29691,-0.018904528,-0.016703371,-0.023026682,-0.007849041,-0.035992686,-0.11636962,-0.10629119,-0.046349756,-0.016876182,-0.03849454,-0.005394936,-0.046887074,-0.006103684,-0.068938285,0.054225743,0.015515354,-0.07065367,-0.03879201,-0.08073703,-0.029532045,-0.07749036,-0.027845178,-0.012764779,0.0057096835,-0.060823113,-0.023897618,-0.09239771,-0.064451315,-0.04236667,-0.059806515,-0.0075043864,-0.028052071,0.025890244,-0.011355227,-0.019751923,-0.038290378,-0.0037037805,-0.01719725,-0.036440846,-0.012118696,-0.05519579,-0.040199026,-0.012262813,-0.0078059323,-0.06724178,-0.051074054,-0.097537555,-0.063666835,-0.10948696,-0.0948652,-0.09758125,-0.10847854,-0.06656041,-0.049969375,-0.02559836,-0.052072812,-0.09802469,-0.06251195,-0.0431551,-0.019899864,-0.067323215,-0.037635554,-0.04838453,-0.069146246,-0.09566497,-0.05890698,-0.045830607,-0.07549939,-0.057933547,-0.06731423,-0.0106395725,-0.033155438,-0.045710336,-0.024799926,-0.0028662912,-0.015578784,-0.05549134,-0.04223735,-0.037868686,-0.02855724,-0.047958743,-0.05545981,-0.055596318,-0.040321026,-0.00984485,-0.014398994,-0.007188828,-0.009055121,-0.01779395,-0.019542124,-0.019688401,-0.016780458}, {3,0,0,7,1,8,6,6,1,7,1,8,255,8,5,3,7,4,8,6,0,0,6,2,255,0,4,5,6,2,8,6,6,6,1,255,255,1,2,1,2,1,1,5,8,255,255,0,4,255,0,8,255,6,255,0,0,1,1,8,5,0,1,8,7,2,3,255,4,1,4,255,8,255,255,0,4,4,0,6,2,7,1,255,2,255,0,6,2,255,255,4,0,4,6,255,0,4,4,0,4,1,7,255,8,2,1,1,2,0,0,6,6,0,7,255,8,8,0,255,255,8,8,0,255,4,3,3,5,0,3,2,8,0,7,4,255,3,1,0,0,0,8,255,255,255,255,255,255,4,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,37,39,41,43,45,65535,47,49,51,53,55,57,59,61,63,65,65535,65535,67,69,71,73,75,77,79,81,65535,65535,83,85,65535,87,89,65535,91,65535,93,95,97,99,101,103,105,107,109,111,113,115,65535,117,119,121,65535,123,65535,65535,125,127,129,131,133,135,137,139,65535,141,65535,143,145,147,65535,65535,149,151,153,155,65535,157,159,161,163,165,167,169,65535,171,173,175,177,179,181,183,185,187,189,191,65535,193,195,197,65535,65535,199,201,203,65535,205,207,209,211,213,215,217,219,221,223,225,65535,227,229,231,233,235,237,65535,65535,65535,65535,65535,65535,239,241,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,38,40,42,44,46,65535,48,50,52,54,56,58,60,62,64,66,65535,65535,68,70,72,74,76,78,80,82,65535,65535,84,86,65535,88,90,65535,92,65535,94,96,98,100,102,104,106,108,110,112,114,116,65535,118,120,122,65535,124,65535,65535,126,128,130,132,134,136,138,140,65535,142,65535,144,146,148,65535,65535,150,152,154,156,65535,158,160,162,164,166,168,170,65535,172,174,176,178,180,182,184,186,188,190,192,65535,194,196,198,65535,65535,200,202,204,65535,206,208,210,212,214,216,218,220,222,224,226,65535,228,230,232,234,236,238,65535,65535,65535,65535,65535,65535,240,242,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31212.5,6029,9301,12334,3597.5,14.5,32429.5,1198.5,12.5,3535,7367,3123,0.061232734,28154.5,26861,44.5,1905,0.036366474,3203.5,5402.5,2442,9644,10758.5,0.027395466,3196.5,20223,3.5,17.5,2.5,39.5,18.5,3150,3094,0.06255803,18.5,4463.5,4560,7443,7444.5,5874.5,14563,7408,21615,0.044985007,0.031845402,17.5,1.5,31291.5,30484.5,21902.5,24719,29386,30511,76.5,65,76.5,436,15.5,7621,2720,4240.5,0.048182655,0.016697263,-0.043216653,-0.06270858,13150,6342,-0.102344565,-0.059045225,14.5,5681.5,8963.5,8967,10259.5,5357,5817.5,11839.5,30743,27218.5,-0.02108866,-0.040318772,-0.014591955,-0.048920564,-0.015910888,-0.025962478,-0.03108095,-0.025268812,19670.5,24637.5,19560.5,24830.5,-0.015071049,-0.017518139,29796.5,-0.014954551,33,29.5,60.5,70.5,50.5,91,528.5,310.5,700,700,1529,5389.5,18.5,2551.5,4308.5,4804,2005,12.5,6235.5,-0.08732293,3816,-0.047660287,-0.090651505,-0.067384064,2065,4456.5,5243,6328.5,5449,7.5,8.5,9212.5,8017.5,7470,8052.5,-0.06640882,9133,15551.5,1.5,31089,-0.008451997,15.5,-0.011211406,24623.5,-0.0116545195,18.5,-0.015876848,-0.013739473,29823.5,29820.5,-0.017303893,0.002067052,-0.008601779,-0.051558286,-0.11067291,-0.03169219,-0.09628455,-0.038218845,0.006753947,-0.0064807716,-0.052817404,-0.015059518,-0.012014478,-0.1027384,0.056419488,0.0022662461,-0.10510776,-0.066235475,-0.088126525,-0.025903968,-0.0012067616,-0.04346626,0.0057058996,-0.013647854,-0.0030520007,0.01766008,-0.049752686,-0.010363763,-0.028339813,-0.04489951,-0.004411853,-0.021160774,-0.09345121,-0.08657094,-0.09138499,-0.10410011,-0.043480374,-0.06280229,-0.0637751,-0.049347263,-0.0924354,-0.04886229,-0.084405705,-0.06132535,-0.012098326,-0.04710665,-0.06338231,-0.026995692,-0.052276313,-0.06766518,-0.052908797,-0.062068045,-0.07472741,-0.09733551,-0.06575237,-0.04577531,-0.007067965,-0.03126211,-0.03364225,-0.052771438,-0.0064331065,-0.014064686,-0.05892163,-0.04101126,-0.07213424,-0.046525862,-0.019951642,-0.050724607,-0.027511735,-0.038594503,-0.0063751824,-0.0078176055,-0.011536069,-0.013336136,-0.02267748,-0.01872221,-0.016066544,-0.015090659,-0.019553458,-0.01649895}, {3,2,0,3,3,8,5,2,8,5,3,2,255,4,6,1,3,255,0,4,3,2,4,255,4,0,8,8,8,0,8,5,4,255,8,6,1,2,2,3,2,7,3,255,255,8,8,4,7,4,4,2,4,6,2,0,1,8,5,2,3,255,255,255,255,6,1,255,255,8,5,2,0,2,3,6,0,4,2,255,255,255,255,255,255,255,255,0,2,6,2,255,255,0,255,4,0,2,3,2,1,0,6,5,5,2,0,8,3,2,0,3,8,2,255,7,255,255,255,7,3,7,1,3,8,8,1,2,4,6,255,3,5,8,2,255,8,255,4,255,8,255,255,4,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,65535,33,35,37,39,41,65535,43,45,47,49,51,53,55,57,59,65535,61,63,65,67,69,71,73,75,77,65535,65535,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,65535,65535,65535,65535,111,113,65535,65535,115,117,119,121,123,125,127,129,131,133,65535,65535,65535,65535,65535,65535,65535,65535,135,137,139,141,65535,65535,143,65535,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,65535,183,65535,65535,65535,185,187,189,191,193,195,197,199,201,203,205,65535,207,209,211,213,65535,215,65535,217,65535,219,65535,65535,221,223,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,65535,34,36,38,40,42,65535,44,46,48,50,52,54,56,58,60,65535,62,64,66,68,70,72,74,76,78,65535,65535,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,65535,65535,65535,65535,112,114,65535,65535,116,118,120,122,124,126,128,130,132,134,65535,65535,65535,65535,65535,65535,65535,65535,136,138,140,142,65535,65535,144,65535,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,65535,184,65535,65535,65535,186,188,190,192,194,196,198,200,202,204,206,65535,208,210,212,214,65535,216,65535,218,65535,220,65535,65535,222,224,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31585.5,6029,9301,12334,3843,14.5,26861,5200.5,11.5,3312.5,7367,8.5,0.05477887,17.5,32312,3815,5658,3100,3223,3431.5,7847.5,9032.5,10758.5,3123,0.039662894,23285.5,24623.5,3.5,30403.5,2256,3035,7016.5,5600.5,0.035544943,1.5,14.5,18.5,8599.5,8105.5,14.5,4024,9247,4593.5,7315.5,6.5,0.019347122,0.030875493,18319.5,11856.5,19811,24930,-0.016257236,-0.022742238,29758.5,-0.013629717,1653.5,2543,2977.5,3152.5,7245.5,5363,5371.5,4804,0.008845981,0.02715965,0.04359381,0.05965961,0.040533204,3239,4.5,5.5,13.5,8027,4048,-0.0407113,4.5,-0.06373584,2065,7730.5,6.5,9405,5817.5,10385.5,12461.5,22316,16345.5,15.5,4.5,24439.5,16345.5,18.5,-0.014531853,-0.012081538,29829.5,30680,1504,15.5,20.5,3255.5,1192.5,3967,4267,6939.5,3592,-0.039542057,4913.5,1.5,-0.05738954,5662,16.5,10709,0.013813133,0.0041956115,9518,7644.5,-0.07464599,12.5,-0.057208307,7710,-0.09046581,6556,4.5,-0.043349933,-0.064333856,-0.08433281,5267.5,4395,9221,7204.5,-0.05587417,12.5,5200.5,27213.5,8017.5,5404,7807.5,11269,30050,1.5,29930,27222,-0.017031154,18602.5,-0.005737562,-0.0073328908,-0.007867688,-0.03728747,-0.009864553,24441.5,-0.02445722,-0.009588155,-0.02092841,-0.01733246,29367.5,29535,29699.5,-0.013333052,-0.022192262,-0.0004924127,-0.06478931,-0.026142156,0.002615718,0.033352975,-0.02303444,-0.007629039,-0.09118629,-0.06217531,-0.029896898,-0.052349485,-0.029434815,-0.008150617,-0.03270702,-0.045735016,0.0029255354,-0.009285085,-0.040039282,-0.06673853,0.0027278108,-0.012825047,-0.020323148,-0.0017818505,4.471609e-05,0.0128262,-0.044530284,-0.006319053,-0.08957286,-0.053138047,-0.080667965,-0.072766356,-0.08371934,-0.089895785,-0.04763191,-0.036225684,-0.093910076,-0.061787542,-0.050087888,-0.058618415,-0.039358284,-0.0852702,-0.04774274,-0.03988355,0.010021827,-0.027260438,-0.0079616,-0.04663406,-0.07560373,-0.093455136,-0.046530873,-0.025502024,-0.056372613,-0.08396697,-0.0066224085,-0.025730997,-0.018125547,-0.04379906,-0.0034417629,-0.012404279,-0.044413533,-0.0075728446,-0.039980102,-0.058480777,-0.022178415,-0.03417487,-0.039765608,-0.046669763,-0.04583631,-0.034149844,-0.007877156,-0.012254298,-0.009607053,-0.0119537255,-0.013819723,-0.014805527,-0.016458586,-0.013399881,-0.016067732,-0.015155541}, {3,2,0,3,3,8,6,1,8,3,3,8,255,8,5,0,7,4,0,5,2,6,4,2,255,2,4,8,6,7,3,0,3,255,8,8,8,6,4,8,1,1,7,7,8,255,255,2,4,0,4,255,255,6,255,6,6,5,4,3,5,1,0,255,255,255,255,255,0,8,8,8,0,7,255,8,255,7,5,8,0,6,0,5,3,0,8,8,4,0,8,255,255,4,4,1,8,8,5,3,6,0,6,4,255,3,8,255,2,8,0,255,255,0,0,255,8,255,4,255,2,8,255,255,255,0,1,0,3,255,8,1,2,2,4,2,5,4,8,6,2,255,0,255,255,255,255,255,0,255,255,255,255,2,6,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,37,39,41,43,45,65535,47,49,51,53,55,57,59,61,65535,63,65,67,69,71,73,75,77,79,81,83,65535,65535,85,87,89,91,65535,65535,93,65535,95,97,99,101,103,105,107,109,65535,65535,65535,65535,65535,111,113,115,117,119,121,65535,123,65535,125,127,129,131,133,135,137,139,141,143,145,147,149,151,65535,65535,153,155,157,159,161,163,165,167,169,171,173,65535,175,177,65535,179,181,183,65535,65535,185,187,65535,189,65535,191,65535,193,195,65535,65535,65535,197,199,201,203,65535,205,207,209,211,213,215,217,219,221,223,225,65535,227,65535,65535,65535,65535,65535,229,65535,65535,65535,65535,231,233,235,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,38,40,42,44,46,65535,48,50,52,54,56,58,60,62,65535,64,66,68,70,72,74,76,78,80,82,84,65535,65535,86,88,90,92,65535,65535,94,65535,96,98,100,102,104,106,108,110,65535,65535,65535,65535,65535,112,114,116,118,120,122,65535,124,65535,126,128,130,132,134,136,138,140,142,144,146,148,150,152,65535,65535,154,156,158,160,162,164,166,168,170,172,174,65535,176,178,65535,180,182,184,65535,65535,186,188,65535,190,65535,192,65535,194,196,65535,65535,65535,198,200,202,204,65535,206,208,210,212,214,216,218,220,222,224,226,65535,228,65535,65535,65535,65535,65535,230,65535,65535,65535,65535,232,234,236,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31212.5,6029,9301,12334,3597.5,12.5,32429.5,50,12.5,3535,7367,22243,0.046046894,27557.5,24112.5,25.5,50.5,18206,3203.5,3600,2442,9644,10597,0.02259103,0.032870542,25128.5,4.5,17.5,26861,37.5,20.5,65,821,0.043402147,6.5,15.5,18.5,8873,2561.5,7443,7444.5,5777.5,14563,7315.5,6.5,17.5,1.5,1.5,30766.5,21902.5,19811,17.5,6.5,26.5,25,55.5,82.5,60.5,501,18.5,660.5,0.023613414,0.03220203,0.03875806,0.055137467,0.0394716,3239,7.5,4.5,-0.08291457,9069,-0.08249804,-0.0472165,14.5,5681.5,2065,8967,10303,5357,6112.5,10385.5,18889.5,22500,-0.022327742,-0.033741783,-0.011271386,-0.042019114,-0.008889305,-0.015141755,-0.025764573,-0.020956887,19670.5,-0.008678169,-0.00814052,-0.015239187,24719,24829,29386,30221.5,22,27.5,58,-0.08550086,33.5,27,152.5,407,37,12.5,10.5,3807,61,886,395.5,3943,0.013489586,0.0034232356,2475,1994.5,3381,12.5,13,5,4.5,5488,-0.07586931,7,-0.07281186,8963.5,5243,6328.5,5484.5,12.5,12.5,9212.5,8000.5,6037,7422,11230.5,1.5,12671.5,30136.5,21081,-0.0074961022,-0.005235545,2.5,-0.010761336,24862.5,-0.011246434,-0.012463108,30355,29758.5,-0.0120232245,-0.02144602,-0.0102593405,0.018033894,-0.005610926,-0.065032594,-0.041439388,-0.0074017257,0.00895548,-0.04360063,-0.0060989135,-0.003395613,-0.048904564,-0.006422271,0.087719366,-0.036701128,-0.09586265,-0.027231812,-0.02201638,-0.09720098,-0.07675597,-0.015339533,-0.04031977,0.01320559,-0.011078793,-0.005586531,0.039882947,-0.06437894,-0.12110298,-0.026326522,-0.012821483,-0.0786353,-0.060251832,-0.0726546,-0.064770274,-0.06608277,-0.041530043,-0.07482005,-0.0813941,-0.05074492,-0.04037726,-0.039804734,-0.0689679,-0.042892437,-0.052692074,-0.053364463,-0.038451493,-0.03482462,-0.061972864,-0.039603543,-0.05186532,-0.0032969152,-0.03866999,-0.049026392,-0.020510128,-0.041249122,-0.055283677,-0.04374722,-0.051270287,-0.06379523,-0.083125256,-0.053865224,-0.035232946,-0.006966916,-0.025798723,-0.020502783,-0.043488372,-0.0143041415,-0.008283429,-0.04567923,-0.0064406074,-0.025941137,-0.041407,-0.039842725,-0.027940983,-0.03538921,-0.042044796,-0.012000276,-0.0332282,-0.011702525,-0.009422011,-0.014149824,-0.010153665,-0.013944315,-0.012952886,-0.012745555,-0.013477467}, {3,2,0,3,3,8,5,6,8,5,3,1,255,2,2,7,7,5,0,1,3,2,4,255,255,2,8,8,6,6,8,2,6,255,8,8,8,2,3,2,2,3,2,7,8,8,8,8,5,4,0,8,8,4,5,0,2,2,0,8,7,255,255,255,255,255,0,8,8,255,2,255,255,8,5,7,0,2,3,6,0,2,1,255,255,255,255,255,255,255,255,0,255,255,255,4,0,2,2,2,3,0,255,2,7,0,0,0,8,8,0,6,3,7,3,255,255,1,1,7,8,8,8,8,4,255,8,255,2,7,1,7,8,8,1,2,4,5,5,8,3,4,3,255,255,8,255,2,255,255,0,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,37,39,41,43,65535,65535,45,47,49,51,53,55,57,59,65535,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,65535,65535,65535,65535,65535,115,117,119,65535,121,65535,65535,123,125,127,129,131,133,135,137,139,141,65535,65535,65535,65535,65535,65535,65535,65535,143,65535,65535,65535,145,147,149,151,153,155,157,65535,159,161,163,165,167,169,171,173,175,177,179,181,65535,65535,183,185,187,189,191,193,195,197,65535,199,65535,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,65535,65535,231,65535,233,65535,65535,235,237,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,38,40,42,44,65535,65535,46,48,50,52,54,56,58,60,65535,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,65535,65535,65535,65535,65535,116,118,120,65535,122,65535,65535,124,126,128,130,132,134,136,138,140,142,65535,65535,65535,65535,65535,65535,65535,65535,144,65535,65535,65535,146,148,150,152,154,156,158,65535,160,162,164,166,168,170,172,174,176,178,180,182,65535,65535,184,186,188,190,192,194,196,198,65535,200,65535,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,65535,65535,232,65535,234,65535,65535,236,238,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({30131,6029,9828,13362,3843,15.5,32429.5,5058,15.5,3665.5,7442.5,5.5,3108,28754,21746.5,3815,5658,1218.5,3204,3346,8210,9644,10758.5,2574,0.030042225,19.5,2402,1.5,4.5,17.5,26861,15.5,2809,7016.5,1797.5,0.04858395,21984,0.048854858,19,13520,7822,12.5,3755.5,9098.5,15281.5,7315.5,3.5,0.005899896,3233,0.027758902,3203.5,0.026243454,0.04957963,30459,30557.5,29586.5,29477.5,10040.5,19560.5,17.5,13.5,2365.5,44.5,1123.5,5019.5,16.5,5363,6452.5,5366.5,2.5,0.032604218,0.030474639,0.011913878,2005,11.5,14.5,6.5,3816,8061.5,6225,4596.5,4547.5,7941,10303,5848,6130,11839.5,11445.5,9133,0.022709185,0.007970354,0.010232179,0.0032376663,-0.009815855,-0.002930385,-0.04545445,-0.036133543,1.5,30659,-0.013289048,31090,2,19560.5,18206,-0.016331911,24730,24900,29386,30403.5,1348.5,3069,88.5,670,894,4015.5,6939.5,5941,3698,4936.5,4913.5,7114.5,3,4.5,-0.055446632,5806,0.010078325,0.023108384,5.5,6655,-0.06687978,-0.07686676,6566.5,3531.5,3011.5,6306.5,4.5,-0.035518695,6124,-0.025255838,-0.070985965,4.5,-0.04736596,-0.035801448,8462,9541.5,8471,7305.5,5484.5,6.5,8.5,20961.5,8108,5404,7807.5,13263.5,29974.5,1.5,8737,30743,-0.0016158879,29736,30175,30349.5,-0.01957652,-0.017136216,0.003387214,0.015065208,-0.006436483,15.5,-0.010909861,-0.006726259,2.5,24605,24860,-0.00978155,-0.011181733,29504,29767,-0.0104874475,-0.018081067,-0.047406655,0.003220765,-0.0121079385,-0.015645955,-0.068233974,0.012134015,-0.009176485,-0.04455514,-0.08052304,-0.051309325,-0.032378733,-0.027235871,-0.038973283,0.0005044408,-0.021683805,-0.0014322333,-0.009556143,0.023260342,0.0032978368,-0.03355696,-0.058591843,-0.03187014,-0.008897676,0.008591357,-0.0004504609,0.015872262,0.00895439,-0.010443792,-0.03338813,-0.078608416,-0.06629787,-0.0480038,-0.06331247,-0.034960013,-0.0468266,-0.025846362,-0.035743944,-0.074423395,-0.045885507,-0.07883479,-0.0639367,-0.040250655,-0.049908902,-0.02070582,-0.036385786,-0.032260437,-0.057073213,-0.03587052,-0.04967294,-0.033252545,-0.006196771,-0.00494579,-0.023758925,-0.023242107,-0.049459852,-0.037016857,-0.050070304,-0.03624844,-0.045465562,-0.051576145,-0.07377245,-0.051597793,-0.031442385,-0.0068261684,-0.023563545,-0.014537901,-0.039692592,-0.0033881844,-0.010714661,-0.061341524,-0.03906737,-0.033961024,-0.050489087,-0.017554402,-0.026386557,-0.05066178,-0.034406647,-0.029796487,-0.035340235,-0.010231366,-0.0057312567,-0.009048633,-0.015592254,-0.004002565,-0.010974693,-0.004632163,-0.0054570744,-0.010832476,-0.008549943,-0.008129981,-0.009760765,-0.012746905,-0.010854128,-0.014168712,-0.011988026,-0.011285681,-0.011939529}, {7,2,4,3,3,8,5,1,8,5,3,8,6,4,6,0,7,4,0,3,4,2,4,0,255,8,2,8,8,8,6,8,3,0,2,255,7,255,8,2,2,8,1,1,0,7,8,255,2,255,0,255,255,1,3,3,5,0,6,8,8,5,1,3,3,8,5,0,1,8,255,255,255,3,8,8,8,7,0,5,5,1,2,2,1,6,0,7,3,255,255,255,255,255,255,255,255,8,7,255,7,8,6,4,255,0,6,2,6,2,6,0,6,2,5,6,6,2,0,3,0,8,8,255,1,255,255,8,2,255,255,2,7,5,0,8,255,2,255,255,8,255,255,2,2,6,3,7,8,8,4,2,4,2,0,6,8,5,4,255,0,7,3,255,255,255,255,255,8,255,255,8,4,2,255,255,0,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,65535,49,51,53,55,57,59,61,63,65,67,65535,69,65535,71,73,75,77,79,81,83,85,87,65535,89,65535,91,65535,65535,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,65535,65535,65535,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,65535,65535,65535,65535,65535,65535,65535,65535,159,161,65535,163,165,167,169,65535,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,65535,207,65535,65535,209,211,65535,65535,213,215,217,219,221,65535,223,65535,65535,225,65535,65535,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,65535,259,261,263,65535,65535,65535,65535,65535,265,65535,65535,267,269,271,65535,65535,273,275,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,65535,50,52,54,56,58,60,62,64,66,68,65535,70,65535,72,74,76,78,80,82,84,86,88,65535,90,65535,92,65535,65535,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,65535,65535,65535,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,65535,65535,65535,65535,65535,65535,65535,65535,160,162,65535,164,166,168,170,65535,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,65535,208,65535,65535,210,212,65535,65535,214,216,218,220,222,65535,224,65535,65535,226,65535,65535,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,65535,260,262,264,65535,65535,65535,65535,65535,266,65535,65535,268,270,272,65535,65535,274,276,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({27862,6023.5,9828,4349.5,3662.5,15.5,32429.5,3461,4851.5,3528,7348,6.5,3247.5,28329,21746.5,15.5,2847,15186.5,7122,13628.5,2066,8749.5,10499,2820.5,0.028258964,0.041171443,18.5,1.5,21762,17.5,26365.5,2302,52,1292.5,6519,17.5,15.5,6012,6569,2003.5,12.5,-0.06984073,9541.5,4236.5,4800,9170.5,19839.5,25460.5,29746.5,0.03247599,0.002968921,25825.5,27512,0.0063282424,4.5,10040.5,18.5,17.5,24620,1312.5,8899,39.5,670,2182,14.5,4308.5,4079,3946.5,3136.5,32102,0.045535363,5656.5,7250.5,17.5,18781,5.5,6784,-0.06056706,-0.06931845,12.5,27222,3906.5,9035,9048,9693.5,7015,8498,29690,24063.5,0.01572863,0.02740044,0.012391525,0.021543954,-0.0036605222,-0.010712129,-0.040720962,-0.056689925,31314.5,27017,0.013884234,18181,19398,-0.011860508,24637.5,24829,-0.030728156,6.5,47.5,2365.5,3246.5,3369.5,76.5,65,841.5,629,3528.5,-0.08600051,6789,3008,7.5,4783,14.5,7.5,3242,4696.5,403,5397,2.5,0.033238567,933.5,5546.5,5748.5,8795.5,4.5,5062,697,16742.5,7192,1441.5,6477.5,8873,4.5,3368,-0.05409063,16.5,14.5,13.5,5798,7040.5,3642,8.5,9728.5,10335.5,8679,8335.5,8179,6344,10289,14381.5,1.5,31089,28718,1.5,-0.033407256,-0.016804457,-0.006611728,13.5,-0.007922608,-0.016368493,-0.0072531826,24503,24862.5,-0.009153729,29386,29823.5,-0.02122202,-0.009391975,-0.046678517,0.0047133244,0.000849317,-0.01075661,-0.039126415,-0.011168046,-0.0033625904,-0.01749674,-0.02321021,-0.05489207,0.0005353395,0.023752641,-0.07065288,-0.0037461002,-0.06717156,-0.050368845,-0.050880607,-0.038527817,-0.037868187,-0.028003395,-0.010579077,-0.022493063,-0.026018133,-0.011642468,-0.046609238,-0.03026337,-0.025058229,-0.03595596,0.008010133,0.0009779696,-0.013423423,-0.0020564643,-0.0123460395,0.03591241,0.0007592602,0.011902439,0.00991102,0.023804447,-0.034421127,-0.0023108292,-0.011777775,-0.040018123,-0.032995384,-0.019811874,0.0004794004,-0.0232488,0.009824551,0.0029612787,0.029567977,-0.0075707817,0.0023770768,-0.010270059,-0.05805079,-0.034620427,-0.073235385,-0.050575294,-0.0729188,-0.058581915,-0.040887833,-0.028806854,-0.05546685,-0.059643216,-0.03504666,-0.042637724,-0.03533895,-0.023858923,-0.013020433,-0.029712835,-0.043089066,-0.034574687,-0.03432011,-0.026821464,-0.020093322,-0.029170204,-0.008276576,-0.023181075,-0.061511066,-0.0357511,-0.04512696,-0.060439248,-0.022275139,-0.041358784,-0.045850426,-0.038723793,0.0041147154,-0.05591116,-0.015608243,-0.031613994,0.0033167345,-0.0041750018,-0.036673464,-0.007894925,-0.037127722,-0.026043406,-0.051775854,-0.031744417,-0.008869889,-0.04977826,-0.017791243,-0.026260689,-0.015927054,-0.0058276337,-0.008745514,-0.01290562,-0.0042880946,-0.0054503833,-0.0067862803,-0.00873836,-0.011358161,-0.008201203,-0.010104759,-0.011158113,-0.010540324,-0.010036339}, {7,4,4,7,5,8,5,6,6,3,5,8,0,6,6,8,5,1,7,4,7,4,6,4,255,255,8,8,4,8,6,1,1,5,6,8,8,6,6,5,8,255,2,5,5,5,3,1,5,255,255,4,2,255,8,0,8,8,0,0,0,0,6,4,8,2,7,6,0,5,255,1,3,8,6,8,4,255,255,8,1,1,3,0,6,4,4,6,2,255,255,255,255,255,255,255,255,4,4,255,6,6,255,2,0,255,8,5,5,0,4,6,2,1,7,6,255,2,1,8,5,8,8,0,7,0,5,8,255,2,3,4,2,8,0,2,0,4,3,2,2,8,5,255,8,8,8,2,0,1,8,0,0,6,2,2,1,3,7,8,2,0,8,255,255,255,8,255,255,255,0,2,255,2,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,65535,65535,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,65535,79,81,83,85,87,89,91,65535,65535,93,95,65535,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,65535,129,131,133,135,137,139,65535,65535,141,143,145,147,149,151,153,155,157,159,65535,65535,65535,65535,65535,65535,65535,65535,161,163,65535,165,167,65535,169,171,65535,173,175,177,179,181,183,185,187,189,191,65535,193,195,197,199,201,203,205,207,209,211,213,65535,215,217,219,221,223,225,227,229,231,233,235,237,239,241,65535,243,245,247,249,251,253,255,257,259,261,263,265,267,269,271,273,275,277,279,65535,65535,65535,281,65535,65535,65535,283,285,65535,287,289,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,65535,65535,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,65535,80,82,84,86,88,90,92,65535,65535,94,96,65535,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,65535,130,132,134,136,138,140,65535,65535,142,144,146,148,150,152,154,156,158,160,65535,65535,65535,65535,65535,65535,65535,65535,162,164,65535,166,168,65535,170,172,65535,174,176,178,180,182,184,186,188,190,192,65535,194,196,198,200,202,204,206,208,210,212,214,65535,216,218,220,222,224,226,228,230,232,234,236,238,240,242,65535,244,246,248,250,252,254,256,258,260,262,264,266,268,270,272,274,276,278,280,65535,65535,65535,282,65535,65535,65535,284,286,65535,288,290,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31119.5,6023.5,9301,7122,3662.5,15.5,32429.5,6012,6569,3528,7348,30530,0.03914349,28154.5,26877,4195,6992.5,10618.5,18781,14016.5,2066,9630,10499,21836.5,3202,25128.5,4.5,17.5,10.5,50,5096.5,3009,5715.5,18,15.5,8288.5,16742.5,2003.5,8.5,-0.06203589,9541.5,4360.5,22713.5,6887.5,7.5,6,0.028735802,2.5,0.024225283,18,-0.03233568,29800,30473.5,21902.5,24637.5,29703.5,30538.5,22.5,50.5,17.5,5609.5,2007,3066.5,8370.5,6327,5382.5,6022.5,6.5,3203.5,7200.5,1863.5,-0.054160405,-0.029768819,5.5,6784,-0.05272872,-0.06141106,3368,5.5,8795,9035,6.5,12.5,5709.5,10902,18889.5,14937.5,0.006854953,0.019734439,3143.5,0.016899072,-0.01342586,-0.02695778,29790.5,-0.014685287,-0.019286316,28743.5,11.5,24492.5,19560.5,24825,29829.5,30040,29796.5,-0.008440176,37.5,15849.5,65,821,3913,2360,5127.5,5369,-0.073127195,15.5,4845.5,7.5,7.5,5115.5,9811,4.5,15.5,13,0.026861867,-0.0008493753,3100,0.026004625,0.040133465,18.5,5012,8730.5,11.5,3643,7192,1441.5,15.5,8873,3535.5,3728,-0.035449907,-0.04978576,3906.5,7816,5798,8829.5,11030,11867.5,-0.045557775,-0.0678814,7692,7127.5,7134.5,30522,13188.5,21334.5,11575,11668,0.009967841,0.0034184542,27142,-0.0041279444,-0.011462246,-0.015501762,19670.5,-0.0048047183,-0.006253411,24343.5,17285,18.5,24702.5,-0.00793327,29647.5,29535,29663,30199.5,29727.5,29820.5,-0.010053892,-0.055983074,-0.0013820411,-0.03500083,-0.024547208,-0.060845263,-0.0038539108,-0.020417642,0.00020488973,-0.007891094,0.024918031,0.00231466,-0.059289183,-0.0039499723,-0.006001236,-0.034308724,-0.041978747,-0.033308275,-0.0324835,-0.0444859,-0.021975605,-0.029809413,0.00923,0.0048619215,-0.021437367,0.002220644,-0.04459786,-0.020252353,-0.027053867,-0.019148542,0.003797951,0.012202435,0.0008573981,-0.017210975,0.018803453,0.01029263,0.03682467,0.008344507,-0.005395821,-0.034422874,-0.0008547984,-0.03537763,0.0051884423,-0.002872863,-0.030027939,-0.0073880553,-0.06596039,-0.047054525,-0.066725485,-0.052898265,-0.03779061,-0.025912752,-0.050088774,-0.053839292,-0.032533266,-0.043817874,-0.031768996,-0.022745479,-0.03633962,-0.027529573,-0.023791185,-0.05388374,-0.019217784,-0.02770848,-0.009423402,-0.041133102,-0.03754668,-0.027975589,-0.037200313,-0.04356862,-0.00022951335,-0.023424279,-0.034828074,-0.017756876,0.003459153,-0.007877084,-0.030596524,-0.014121547,-0.02558435,-0.037323765,-0.0069612092,-0.021459876,-0.013086557,-0.03829389,-0.041036613,-0.027206222,-0.003457094,-0.009199396,-0.005180606,-0.0038019132,-0.0056052995,-0.0077892668,-0.0024282082,-0.0072911954,-0.014500652,-0.011310401,-0.006284218,-0.010020789,-0.009386383,-0.010632685,-0.011335648,-0.008375666,-0.009609769,-0.010750569,-0.009906121,-0.009103308,-0.009401529,-0.008569987,-0.012529033,-0.009607125}, {3,4,0,7,5,8,5,6,6,3,5,7,255,4,0,7,3,1,6,2,7,4,6,1,0,2,8,8,8,6,4,1,0,8,8,7,0,5,8,255,2,5,4,1,8,8,255,8,255,8,255,4,5,4,2,6,0,7,7,8,5,5,5,2,7,2,0,8,0,2,2,255,255,8,4,255,255,5,8,4,3,8,8,0,2,2,6,255,255,2,255,255,255,0,255,255,0,8,2,6,0,4,0,0,255,6,0,2,6,4,0,4,7,255,8,4,8,8,1,1,8,8,8,255,255,4,255,255,8,2,0,8,3,4,3,8,2,1,7,255,255,1,2,2,0,6,4,255,255,4,0,4,1,1,6,5,7,255,255,7,255,255,255,0,255,255,0,2,8,6,255,0,6,0,6,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,65535,77,79,81,83,85,87,65535,89,65535,91,65535,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,65535,65535,133,135,65535,65535,137,139,141,143,145,147,149,151,153,155,65535,65535,157,65535,65535,65535,159,65535,65535,161,163,165,167,169,171,173,175,65535,177,179,181,183,185,187,189,191,65535,193,195,197,199,201,203,205,207,209,65535,65535,211,65535,65535,213,215,217,219,221,223,225,227,229,231,233,65535,65535,235,237,239,241,243,245,65535,65535,247,249,251,253,255,257,259,261,65535,65535,263,65535,65535,65535,265,65535,65535,267,269,271,273,65535,275,277,279,281,283,285,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,65535,78,80,82,84,86,88,65535,90,65535,92,65535,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,65535,65535,134,136,65535,65535,138,140,142,144,146,148,150,152,154,156,65535,65535,158,65535,65535,65535,160,65535,65535,162,164,166,168,170,172,174,176,65535,178,180,182,184,186,188,190,192,65535,194,196,198,200,202,204,206,208,210,65535,65535,212,65535,65535,214,216,218,220,222,224,226,228,230,232,234,65535,65535,236,238,240,242,244,246,65535,65535,248,250,252,254,256,258,260,262,65535,65535,264,65535,65535,65535,266,65535,65535,268,270,272,274,65535,276,278,280,282,284,286,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({27303,5777,9306.5,4337,3972.5,1295.5,31182,3461,4132.5,3298.5,9837.5,0.053406335,15.5,28650.5,32362,2335.5,2847,4595.5,5616.5,3522,7830,7241,9503.5,5.5,3213.5,1.5,23664,4.5,26877,1548.5,2830,959.5,4308.5,18.5,12.5,4903.5,6239,1452.5,8017.5,14.5,2836,9709,7101,4988.5,10510.5,21948,3083.5,0.033760943,0.020254703,30624,27316,0.0120292995,4.5,31158.5,5318,17.5,1.5,1441.5,15.5,2428.5,3302,-0.062908284,14.5,3323.5,3202,617,3319,3139,0.029390572,7356,4582,6167,6770,-0.06293339,8548.5,15.5,7823,6382.5,7907,-0.054205507,8.5,6452.5,5585.5,4936.5,10282,12.5,20642,11829.5,2.5,0.019894889,2849.5,0.017535128,0.023801966,26765.5,0.002558291,30215,-0.047274306,31320.5,29279.5,3.5,5440.5,-0.024747135,31487,21902.5,24730,29141.5,30403.5,50,680,6.5,1298,18.5,3218.5,3663,8019.5,3966.5,5535,7.5,7.5,4628.5,5239,379.5,5692.5,92,3915.5,2617.5,3.5,-0.036574375,1.5,4668.5,5635,5794,1.5,13,4.5,7.5,4.5,3920.5,4628,-0.056212194,11.5,5.5,8089,3665.5,-0.014524624,3747,6626,3448.5,9352.5,4959.5,6986,10700.5,5426,7893.5,8156.5,4.5,9069,16011,8081.5,8160,10902,11659.5,30136.5,29145,0.017108731,-0.008080519,-0.0026945134,-0.03598122,-0.026644856,29740.5,29288.5,-0.03434153,28713,31353.5,29759,0.0034141026,26752.5,-0.011009102,31845.5,19670.5,24503,19811,24796.5,-0.0077419803,-0.0100651365,29764.5,15.5,-0.0056700814,-0.018861393,-0.024708157,0.008697181,-0.0288295,-0.051963527,-0.03415423,0.0012934927,0.009394022,0.029253725,-0.004980822,0.013050022,-0.01925228,-0.03594197,-0.0050757676,-0.03796503,-0.028296376,-0.043301675,-0.03458873,-0.02175974,-0.014724338,-0.023695339,-0.0034557108,-0.012182839,-0.022794893,-0.03589168,-0.02155125,-0.028645357,-0.0065685585,-0.032137807,0.0001681036,-0.01988714,-0.011544507,0.038085904,-0.0021274127,0.0062515712,0.013820829,0.02296344,0.0066319816,0.001357475,0.006839838,-0.0071163373,-0.043479778,0.004555346,-0.002142821,-0.012993845,-0.03756098,-0.016209854,-0.00751194,-0.04032075,0.0054419865,-0.018984383,0.010841435,0.006462262,-0.052021135,-0.04354542,-0.04289424,-0.051906716,-0.036258437,-0.029162237,-0.010298194,-0.02072467,-0.037647348,-0.04872493,-0.010069405,-0.020546254,-0.034931857,-0.025745725,-0.022050785,-0.02736254,-0.03412841,-0.04283838,-0.0316634,-0.05018699,-0.029588265,-0.01865967,-0.026186123,-0.011851153,-0.02822793,-0.018459566,-0.040898927,-0.024955997,-0.001957859,-0.046314284,-0.006830527,-0.030127306,5.451238e-07,-0.0072025084,0.017405467,-0.036783773,-0.032210607,-0.04353814,-0.058135003,-0.01265047,-0.032595657,-0.04144222,-0.015096992,-0.025767757,-0.018854791,-0.05359396,-0.0041189822,-0.02911203,-0.025466612,-0.014144695,-0.021680962,-0.025917912,0.008771408,0.0011063531,-0.007111738,-0.0012244063,-0.013079554,-0.0076566203,-0.015198471,-0.012063936,0.0056547374,0.00074656884,-0.0046489863,-0.0013898534,-0.014897582,-0.008754059,-0.015775578,-0.010403026,-0.004641712,-0.0034959023,-0.0056755296,-0.006988683,-0.0053950646,-0.011281481,-0.008753025,-0.007256601,-0.0083409725,-0.009071432,-0.008070761,-0.007424665}, {1,6,0,7,7,4,1,6,2,7,4,255,8,0,5,1,5,3,7,3,6,7,5,8,0,8,2,8,0,0,0,5,2,8,8,3,7,1,2,8,1,6,3,5,6,3,0,255,255,1,2,255,8,3,6,8,8,7,8,0,1,255,8,7,1,2,0,0,255,0,6,1,0,255,4,8,6,6,0,255,8,4,3,2,0,8,6,5,8,255,2,255,255,0,255,1,255,0,0,8,4,255,1,4,0,2,6,6,4,8,5,8,1,4,2,6,0,8,8,2,6,2,6,0,3,4,8,255,8,4,3,2,8,8,8,8,8,5,0,255,8,8,0,7,255,5,4,3,6,1,3,7,5,6,3,8,1,2,5,7,2,7,4,3,255,255,255,255,255,6,7,255,7,1,0,255,0,255,5,0,0,0,6,255,255,6,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,65535,65535,93,95,65535,97,99,101,103,105,107,109,111,113,65535,115,117,119,121,123,125,65535,127,129,131,133,65535,135,137,139,141,143,65535,145,147,149,151,153,155,157,159,161,65535,163,65535,65535,165,65535,167,65535,169,171,173,175,65535,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,65535,227,229,231,233,235,237,239,241,243,245,247,65535,249,251,253,255,65535,257,259,261,263,265,267,269,271,273,275,277,279,281,283,285,287,289,291,293,65535,65535,65535,65535,65535,295,297,65535,299,301,303,65535,305,65535,307,309,311,313,315,65535,65535,317,319,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,65535,65535,94,96,65535,98,100,102,104,106,108,110,112,114,65535,116,118,120,122,124,126,65535,128,130,132,134,65535,136,138,140,142,144,65535,146,148,150,152,154,156,158,160,162,65535,164,65535,65535,166,65535,168,65535,170,172,174,176,65535,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,65535,228,230,232,234,236,238,240,242,244,246,248,65535,250,252,254,256,65535,258,260,262,264,266,268,270,272,274,276,278,280,282,284,286,288,290,292,294,65535,65535,65535,65535,65535,296,298,65535,300,302,304,65535,306,65535,308,310,312,314,316,65535,65535,318,320,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({27303,5817.5,9306.5,4337,3757.5,1295.5,32493,2797,4803,3298.5,7241,2.5,13.5,28650.5,25705,2116.5,1311.5,8955.5,5616.5,3288.5,7830,9707.5,10591.5,0.018002855,0.0525935,3197,3247.5,31744,4.5,17.5,26154.5,1161.5,4875.5,1770.5,3836.5,19.5,11.5,4648.5,6279,8540.5,6766.5,14.5,3.5,11090,12463.5,10798,10.5,21041.5,0.022742605,0.02844368,19,1.5,26641.5,22183.5,23664,21902.5,24783,-0.02383108,30219.5,46,13.5,2094,5847.5,1165,678,3150,2961.5,617,5206.5,3142.5,17929.5,6280,5609.5,5797.5,19.5,7.5,4.5,2879.5,1382,4429.5,4026,8636.5,3340,4584,8166.5,10263,6388,8304.5,1159.5,19769.5,14935.5,0.021315832,2647,0.02224872,0.0013415389,29954.5,27316,-0.01660528,-0.009380925,0.009078977,29803.5,0.009479708,29279.5,14.5,4.5,19560.5,24784.5,29796.5,30049,65,20.5,6.5,700,2124.5,17.5,2677,5720,-0.0812088,5,-0.021961264,18.5,15.5,2770,15.5,3647.5,379.5,936,871,6388.5,0.019708592,2.5,0.017022394,0.032208312,6047.5,15.5,5470.5,8438,4790,7655,8.5,6770,2561.5,1978.5,8157.5,18.5,-0.04862083,14.5,-0.029777622,-0.046407547,7,6322.5,5488,-0.014079559,-0.059390284,12487.5,-0.04931597,-0.041410152,8854.5,9728.5,1.5,5.5,5390.5,5.5,5.5,19593,7712.5,10357.5,1154,17.5,20760.5,19154,11575,12671.5,3.5,3116.5,27722,25988,30215,-0.04471931,1.5,1.5,-0.030191649,31314.5,19670.5,-0.0040283143,-0.006697749,24719,-0.0056697815,24860,-0.0030294482,24737.5,29791,29820.5,29771,15.5,-0.011438071,-0.060762126,-0.004328003,0.01454468,-0.02757962,-0.051137526,-0.058795482,-0.01194889,0.011926639,-0.008581067,0.0014664396,0.015260421,-0.03735384,-0.014531622,-0.017375922,-0.0037497215,-0.03867242,-0.061923534,-0.04882691,-0.026050229,-0.024196552,-0.006214638,0.006111667,-0.008847422,-0.03722742,-0.026765604,-0.0076858983,-0.01978009,-0.0068836133,-0.03034985,-0.002951021,0.0031774316,-0.023002883,0.028258836,-0.003515234,0.021548253,0.004604218,0.012002813,-0.002854107,-0.035668958,-0.00018862703,0.0070251315,-0.0073853927,-0.02980313,0.0014377688,-0.0060836263,0.002596237,-0.028157268,0.014867625,-0.006731,0.008658893,0.0030356573,-0.02017742,0.0071635395,-0.047904808,-0.036113,-0.04405974,-0.03787523,-0.073162645,-0.037156794,-0.045642328,-0.051957138,-0.029323403,-0.021297725,-0.0070094327,-0.021589534,-0.036143,-0.028654769,-0.027979791,-0.020182028,-0.02185609,-0.033614054,-0.024931854,-0.050881952,-0.018671362,-0.030146161,0.011923125,-0.0035359745,-0.024116922,-0.013196607,-0.020428352,-0.034926694,-0.020438408,-0.0281203,-0.029672435,-0.047158346,-0.03354778,-0.022460876,-0.0016194748,-0.011636171,-0.025181053,0.023070792,-0.0054024556,-0.035726555,-0.004746645,-0.00054948183,-0.020864118,-0.0032311461,0.0014119522,-0.016165806,-0.009964496,-0.032659348,-0.034468245,-0.022646757,0.0021888393,0.011469441,0.019195434,0.012738587,-0.002343812,-0.007672723,0.0016308995,-0.0029143167,-0.03239702,-0.024640268,0.0015357008,-0.0032116317,-0.004076002,-0.0070361802,-0.011573345,-0.014025934,-0.0040076193,-0.0029122643,-0.005147292,-0.0061514764,-0.009408188,-0.0049457606,-0.008577945,-0.0066799233,-0.007647009,-0.006562356,-0.010790999,-0.008217922,-0.009699235,-0.0076297033,-0.0071999836,-0.006527118}, {1,6,0,7,7,4,5,6,0,7,7,8,8,0,0,1,5,1,7,1,6,6,4,255,255,6,0,3,8,8,0,2,2,7,6,8,8,6,7,4,6,8,8,1,4,3,8,3,255,255,8,8,0,3,2,4,6,255,4,3,8,3,3,5,0,7,1,2,6,6,5,1,4,6,8,8,8,5,5,2,1,2,1,7,2,6,5,0,0,5,6,255,2,255,255,5,2,255,255,255,3,255,0,8,8,6,6,0,0,2,8,8,5,0,8,6,0,255,8,255,8,8,2,8,2,2,0,2,7,255,8,255,255,2,8,5,1,2,0,8,0,7,5,2,8,255,8,255,255,8,2,4,255,255,4,255,255,6,0,8,8,7,8,8,6,6,4,0,8,7,7,5,3,8,4,3,4,1,255,8,8,255,3,0,255,255,4,255,2,255,0,0,0,6,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,65535,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,65535,65535,93,95,97,99,101,103,105,65535,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,65535,173,65535,65535,175,177,65535,65535,65535,179,65535,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,65535,211,65535,213,215,217,219,221,223,225,227,229,65535,231,65535,65535,233,235,237,239,241,243,245,247,249,251,253,255,65535,257,65535,65535,259,261,263,65535,65535,265,65535,65535,267,269,271,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,65535,309,311,65535,313,315,65535,65535,317,65535,319,65535,321,323,325,327,329,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,65535,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,65535,65535,94,96,98,100,102,104,106,65535,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,65535,174,65535,65535,176,178,65535,65535,65535,180,65535,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,65535,212,65535,214,216,218,220,222,224,226,228,230,65535,232,65535,65535,234,236,238,240,242,244,246,248,250,252,254,256,65535,258,65535,65535,260,262,264,65535,65535,266,65535,65535,268,270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,65535,310,312,65535,314,316,65535,65535,318,65535,320,65535,322,324,326,328,330,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({30072,5777,10286.5,4014,3972.5,3214.5,32327,2958,3259.5,3298.5,9831,8.5,21.5,29066,26877,2173,1311.5,15.5,5296.5,3288.5,7830,7241,9223.5,3158.5,2860.5,2.5,-0.0018574157,1.5,3.5,17.5,15.5,1642.5,2422.5,1389,7117,5.5,2311.5,18.5,6739,8540.5,2280,12.5,4.5,9709,6538,4988.5,10267.5,2860.5,3231.5,0.028816376,3044.5,2974,0.014807867,25782.5,30230.5,29803.5,31283.5,21902.5,24503,29094.5,30219.5,1038.5,15.5,18.5,3080.5,921.5,1512,6092,4119,2873,2811,19.5,3182,617,3229,5692.5,7972.5,4.5,8.5,7823,11119,6382.5,7907,2574,11782.5,9505.5,5507,16.5,7101,12.5,19214.5,11829.5,2.5,0.01618069,2.5,0.0224944,0.011757093,20.5,0.02521947,0.00697419,0.0019166487,-0.004360895,30943.5,-0.030466938,-0.02320907,1.5,29710.5,4.5,31120.5,19670.5,2.5,19.5,24805.5,-0.006491413,29453,29776.5,-0.0060246224,825,1088.5,5050.5,745.5,1023.5,2762,15.5,2155.5,-0.020263188,3.5,-0.037492987,-0.07898605,3056.5,3881.5,7496.5,-0.027580371,2433,3,0.013619919,3067.5,0.00026811985,-0.00693566,3215.5,0.007654946,1390,4944,419,5951.5,4944,5704,5355,9172,2475,7630,8157.5,13388.5,5.5,-0.030433496,1804.5,7.5,6.5,4.5,7418,-0.012053177,-0.053743966,12533.5,2462.5,-0.041126102,5923.5,6397,13980,6986,7710,6022.5,5550.5,11839.5,9069,14096,14717,8081.5,9040,2.5,11652,31057.5,-0.00018023634,0.009163898,17.5,-0.003241729,-0.0019239414,31353.5,27416,29772.5,29744,29719,29248.5,24934,-0.013082288,-0.010741809,16.5,13.5,24728,24623.5,19811,19811,24814,24781.5,29533.5,29473.5,29977.5,30728,-0.0090606315,-0.03930455,0.02132808,-0.00452524,-0.0354782,-0.003911986,-0.059464898,-0.0065042884,-0.02257016,0.008443337,0.043966804,-0.0068683936,-0.031087494,-0.0129376445,0.026761724,-0.0006069017,-0.025188733,-0.048164815,-0.02252396,-0.014507875,-0.025080359,-0.01403973,0.007435781,-0.003933595,0.005964572,0.014713424,0.0012583813,0.010516906,0.021166982,0.011211682,0.029478235,0.015189513,-0.006425798,-0.023749666,0.002895361,-0.0018649407,-0.0095359385,0.037870746,0.0005057497,0.013184703,-0.015348226,-0.004244435,-0.030524377,0.00070063066,0.002943725,-0.006009282,-0.0074573234,0.009286215,-0.045405965,-0.029798148,-0.038826432,-0.034012012,-0.059497148,-0.036682133,-0.041672405,-0.045742065,-0.05784272,-0.041858178,-0.047541898,-0.023413079,-0.030213756,-0.044607107,-0.008187061,-0.018472394,-0.022697464,-0.0308827,-0.019771984,-0.024779951,-0.021113498,-0.03523774,-0.0392828,-0.03228818,-0.015508897,-0.02068647,-0.020177227,0.010034734,-0.021494167,-0.004851564,-0.03194982,-0.018125577,0.0041682515,0.015354224,0.021785362,0.0061913123,-0.006401463,-0.026763534,-0.005178667,-0.03635753,-0.03259362,-0.00942685,-0.026677346,-0.048617076,-0.026361534,-0.033641856,-0.011238271,-0.021482825,-0.015440881,-0.0507901,0.00219137,-0.0034096434,-0.021753319,-0.010696872,-0.017301114,-0.021106666,0.016700504,0.005789644,0.0011154012,-0.00044270736,0.0003083002,0.0020067773,-0.00074994535,0.0010004361,-0.00027998726,0.001744446,0.0015139789,-0.0058326493,-0.0021803805,-0.0063340585,-0.006704171,-0.010058801,-0.003610598,-0.0061379313,-0.002764106,-0.002206766,-0.0071867066,-0.005999734,-0.004580509,-0.005572633,-0.0039464845,-0.010777386,-0.0034355528,-0.008076861,-0.006560191,-0.008081474,-0.007543338,-0.0055745486,-0.010819588,-0.008084884,-0.009582762,-0.0070504122,-0.006545055,-0.008390318,-0.0071524903,-0.0050815847}, {5,6,0,7,7,4,3,6,6,7,4,8,8,0,0,7,5,8,0,1,6,7,5,4,6,8,255,8,8,8,8,6,0,4,1,8,0,8,1,4,7,8,8,6,6,5,6,6,0,255,6,0,255,0,3,3,3,4,0,4,4,5,8,8,5,0,0,4,6,4,6,8,2,2,3,3,0,8,8,6,4,6,0,3,2,6,3,8,3,8,2,5,8,255,8,255,255,8,255,255,255,255,5,255,255,8,4,8,7,0,8,8,2,255,2,6,255,4,4,1,7,4,1,8,6,255,8,255,255,5,7,0,255,4,8,255,4,255,255,0,255,4,7,0,7,7,6,7,2,1,6,2,0,8,255,3,8,8,8,6,255,255,4,3,255,0,3,0,3,0,0,3,0,1,4,4,5,7,8,7,2,255,255,8,255,255,5,1,0,0,0,7,1,255,255,8,8,4,4,0,0,4,6,6,0,2,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,65535,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,65535,97,99,65535,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,65535,181,65535,65535,183,65535,65535,65535,65535,185,65535,65535,187,189,191,193,195,197,199,201,65535,203,205,65535,207,209,211,213,215,217,219,221,65535,223,65535,65535,225,227,229,65535,231,233,65535,235,65535,65535,237,65535,239,241,243,245,247,249,251,253,255,257,259,261,263,65535,265,267,269,271,273,65535,65535,275,277,65535,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,65535,65535,311,65535,65535,313,315,317,319,321,323,325,65535,65535,327,329,331,333,335,337,339,341,343,345,347,349,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,65535,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,65535,98,100,65535,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,65535,182,65535,65535,184,65535,65535,65535,65535,186,65535,65535,188,190,192,194,196,198,200,202,65535,204,206,65535,208,210,212,214,216,218,220,222,65535,224,65535,65535,226,228,230,65535,232,234,65535,236,65535,65535,238,65535,240,242,244,246,248,250,252,254,256,258,260,262,264,65535,266,268,270,272,274,65535,65535,276,278,65535,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,65535,65535,312,65535,65535,314,316,318,320,322,324,326,65535,65535,328,330,332,334,336,338,340,342,344,346,348,350,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({27166.5,5943,9306.5,39,3721.5,1295.5,31182,22,38.5,3346,9679.5,0.046785,12.5,28650.5,25453,26.5,27,77,1010.5,1772,2409,7303,10733,3003,3247.5,27216.5,23664,17.5,10947.5,22,17.5,29,20.5,61,6.5,763.5,1408.5,5.5,6704.5,13.5,8359,9728.5,9068.5,4774,10499,2713.5,3214.5,15.5,18.5,0.022828693,1.5,0.011364284,3.5,21902.5,29388,4.5,32312,71,44,146,584,34.5,29.5,27,608,72,90.5,-0.079917274,107.5,637,18.5,867,4038.5,394.5,1441.5,13.5,8540.5,-0.040741187,3670.5,15.5,6.5,9261,9376.5,7808.5,8503,9831.5,10998,11468.5,12.5,0.018806769,3043.5,0.018660879,0.007864146,0.017998965,2402,0.021345409,20.5,25132.5,26812.5,31320.5,29279.5,19670.5,29967,-0.018584466,24812,-0.0044662063,-0.020758003,4.5,4.5,22,-0.04483225,0.011465427,15.5,5,3.5,146,0.06684612,3.5,0.041854065,22,-0.061692417,78,15.5,33,3927,-0.07811899,7.5,75,-0.063549414,95,15.5,44.5,472,994.5,8008.5,761.5,2227.5,2063,4747.5,-0.02392377,7030,-0.047196135,-0.03444815,3696,5963.5,7644.5,4.5,-0.03408934,-0.011434377,7816.5,2974.5,12606,17048.5,5630,6395.5,3811.5,4.5,8292,7995,10132.5,2.5,-0.013985914,7.5,17.5,18084.5,10684,17.5,1.5,21334.5,4.5,0.011763141,0.011096521,0.025013864,-0.0007284416,0.00024352875,0.0034798991,31407,30645,30132.5,31218,30971.5,-0.029328624,27376.5,-0.0038310082,14.5,2.5,-0.010921191,17992.5,24929.5,31223.5,30079,29574.5,30224,-0.011752496,-0.0022040145,-0.009929031,0.00037471604,0.0033023406,-0.0018157909,-0.028136333,-0.0064446046,0.009142769,-0.0015091088,0.025600387,0.014810321,0.016778985,-0.0016640801,-0.01403214,-0.04240468,-0.004504366,0.005342172,-0.0012916352,-0.034786623,0.08099644,-0.010817424,-0.06578218,-0.04536384,-0.012874302,-0.046132993,-0.0417125,-0.074910045,-0.05677079,-0.041828442,-0.011724408,0.0028252734,-0.115393244,-0.022878839,-0.0004881299,0.01217369,0.03929263,-0.039672334,-0.0848535,-0.03670394,-0.019145833,-0.038713258,0.007679754,-0.006173682,-0.018113798,-0.005678639,-0.04752915,-0.027017077,-0.030447472,-0.020696832,-0.0084105125,-0.017182041,-0.03828494,-0.03104887,-0.030650178,-0.037716877,-0.027683308,-0.020043474,-0.008378478,-0.019334411,-0.014864567,-0.032503244,-0.036111575,-0.025359023,-0.013177483,-0.018520286,-0.015644178,0.008813411,-0.022660322,-0.01105102,-0.03348544,-0.025542725,0.0014121507,-0.04278558,-0.010682101,-0.03906516,-0.04855435,-0.005575906,0.0035517903,-0.0034221758,-0.028592,-0.03844972,-0.023539549,-0.028488189,-0.017471498,-0.0018296998,-0.057685163,-0.013957731,-0.0029895674,0.0019947896,-0.008564038,-0.015810043,-0.012953219,-0.020134483,0.0036951464,0.009344836,-0.0057773455,-0.0009952987,-0.025799626,-0.017720243,-0.028897196,-0.04111373,0.00053707475,-0.0061766854,-0.00563488,-0.011190128,-0.013526148,-0.008911504,-0.002454368,-0.003287099,-0.0057561803,-0.004866996,-0.0026111684,-0.0072841286,-0.005970175,-0.0046200147,0.0019269163,-0.0065682395,-0.0059165885,-0.0099963965,-0.0061919843,-0.006929549,-0.0061728447,-0.005664879}, {1,0,0,6,1,4,1,4,7,7,6,255,8,0,0,6,1,4,6,7,3,1,7,2,0,1,2,8,6,2,8,5,8,4,8,1,7,8,6,8,0,0,5,7,6,4,4,8,8,255,8,255,8,4,5,8,5,0,2,0,0,0,0,3,1,2,6,255,4,0,8,7,4,6,3,8,4,255,1,8,8,0,2,0,1,0,3,7,8,255,0,255,255,255,2,255,8,2,6,0,0,0,4,255,2,255,255,8,8,0,255,255,8,8,8,0,255,8,255,2,255,0,8,6,0,255,8,2,255,4,8,1,1,7,2,1,6,6,5,255,6,255,255,5,0,0,8,255,255,4,1,0,2,6,1,3,8,2,7,5,8,255,8,8,5,2,8,8,6,8,255,255,255,255,255,255,7,1,1,3,1,255,5,255,8,8,255,6,4,3,3,6,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,65535,97,65535,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,65535,129,131,133,135,137,139,141,143,145,65535,147,149,151,153,155,157,159,161,163,165,167,65535,169,65535,65535,65535,171,65535,173,175,177,179,181,183,185,65535,187,65535,65535,189,191,193,65535,65535,195,197,199,201,65535,203,65535,205,65535,207,209,211,213,65535,215,217,65535,219,221,223,225,227,229,231,233,235,237,65535,239,65535,65535,241,243,245,247,65535,65535,249,251,253,255,257,259,261,263,265,267,269,271,65535,273,275,277,279,281,283,285,287,65535,65535,65535,65535,65535,65535,289,291,293,295,297,65535,299,65535,301,303,65535,305,307,309,311,313,315,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,65535,98,65535,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,65535,130,132,134,136,138,140,142,144,146,65535,148,150,152,154,156,158,160,162,164,166,168,65535,170,65535,65535,65535,172,65535,174,176,178,180,182,184,186,65535,188,65535,65535,190,192,194,65535,65535,196,198,200,202,65535,204,65535,206,65535,208,210,212,214,65535,216,218,65535,220,222,224,226,228,230,232,234,236,238,65535,240,65535,65535,242,244,246,248,65535,65535,250,252,254,256,258,260,262,264,266,268,270,272,65535,274,276,278,280,282,284,286,288,65535,65535,65535,65535,65535,65535,290,292,294,296,298,65535,300,65535,302,304,65535,306,308,310,312,314,316,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({30131,6029,16962,6426,5134,14.5,32410.5,50,10211,3312.5,9831,2.5,3108,28754,24639,22,50.5,7215.5,1218.5,2005,10626,7480.5,11165.5,1.5,2652.5,18.5,9264,1.5,29477.5,17.5,28845,22,35.5,64.5,657,8972,12.5,3.5,11.5,4.5,6684,2146.5,12.5,9681.5,7807.5,30200.5,10830,3170,2820.5,3157.5,0.015207789,0.01998893,3080,17.5,16.5,30007,30557.5,3.5,3.5,18319.5,19560.5,17.5,29473.5,22,15.5,34.5,31.5,61,166,18.5,528.5,15.5,-0.040892113,5593.5,-0.020651532,0.015859066,0.045016028,22592,31121,1358,1369,3769,13628.5,7693.5,4435.5,4.5,4880,7007,5507,7855,10510,10289,12.5,11366,5.5,0.01201686,0.002507213,0.010499132,3005,6.5,0.011162107,0.010503594,3203.5,0.017391223,-0.0027675664,0.018441914,0.028737057,-0.0064887623,26363,21167,2.5,0.0012583771,29850.5,29359.5,30971.5,18602.5,15.5,18206,19.5,25366.5,24863,27871.5,29413,71,44,584,584,33,0.038537316,46,18.5,12.5,83,6.5,327.5,87.5,745,2645,1025,4.5,5627.5,5.5,5.5,0.009863631,2.5,0.024083218,19,-0.025598083,8216.5,-0.043179933,8337,15.5,6908.5,2643.5,12.5,3773,-0.037937894,8846,7014.5,11811,-0.029634705,12198,-0.04729976,5414.5,6857,3966,8375,7427.5,9184.5,7962,12005,8.5,11344.5,31984.5,-0.043835577,10550.5,-0.027659519,1.5,13824.5,-0.0032532625,0.00017511625,0.0026620128,0.008041773,-0.006459435,0.00013174512,0.00020829936,-0.0024633768,-0.011877741,26847.5,-0.0041773818,-0.017137786,16,-0.0037209603,1.5,30217.5,29717.5,31279.5,16,-0.0056803552,13.5,24372.5,-0.004845236,17809.5,-0.008468712,19811,2.5,-0.005173118,24709.5,26500.5,-0.005250805,30430,-0.009041599,16.5,-0.009534153,-0.04062006,0.010073232,-0.006025741,-0.004759553,-0.010788912,0.00095703185,0.035776872,-0.00048512407,0.008855964,-0.07502005,-0.027085027,-0.003428043,0.008710687,-0.06414157,-0.045702096,-0.011030038,-0.04040083,-0.07520085,-0.051208813,-0.029342426,-0.0049267444,0.0076626004,-0.0048908065,0.002146931,0.0434401,-0.095725596,-0.04973472,-0.0012051745,-0.010787777,0.008925059,0.0015332256,0.021689903,0.0070937015,-0.0013898447,-0.0119744055,-0.0050793467,0.00067279726,0.0089868745,0.017200988,0.009853398,0.0011528118,-0.04256477,-0.058137666,-0.03102382,-0.0383214,-0.026027812,-0.018481823,-0.010069863,-0.019186443,-0.03089833,-0.02656709,-0.03274897,-0.03853332,-0.014649223,-0.025635356,-0.020068562,-0.031509995,-0.00015583813,-0.01655183,-0.014920427,-0.024796715,-0.026500095,-0.039194133,-0.0006400376,-0.023017261,-0.011677927,0.0011101238,-0.021625703,-0.0087457765,-0.02429988,-0.046865415,-0.00599987,0.005567862,-0.040702444,-0.0013800649,-0.008061478,-0.02210831,-0.002565833,-0.021758338,-0.018668255,-0.023970388,-0.008009564,-0.016447728,-0.02625504,-0.036928747,-0.0023087268,0.00897743,-0.006536563,-0.012635401,-0.024855575,-0.015646232,-0.026765108,-0.020381503,-0.0008855533,-0.0019097908,0.0020064588,-0.0011469441,-0.011287331,-0.0053054723,-0.0049237204,-0.007913472,-0.009131171,-0.012739994,-0.0030346473,-0.005566861,-0.0023264266,-0.0016495083,-0.0029717793,-0.00089619413,-0.0015801642,-0.002919608,-0.0016579082,-0.0065025226,-0.0052203634,-0.004442699,-0.00278128,-0.006352611,-0.004545088,-0.0052152188,-0.0082665,-0.004078908,-0.0056934822,-0.005189383}, {7,2,4,3,3,8,1,6,1,3,4,8,6,4,6,4,7,3,4,3,2,3,5,8,2,8,1,8,5,8,6,6,0,6,6,6,8,8,8,8,2,7,8,6,2,4,4,0,4,0,255,255,0,8,8,5,3,8,8,2,6,8,0,2,8,0,3,6,2,8,7,8,255,0,255,255,255,7,1,7,3,5,4,2,1,8,3,2,3,4,3,3,8,6,8,255,255,255,2,8,255,255,0,255,255,255,255,255,0,2,8,255,0,1,1,0,8,4,8,2,6,2,4,0,2,0,0,2,255,0,8,8,0,8,4,6,2,0,2,8,6,8,8,255,8,255,8,255,4,255,0,8,0,7,8,1,255,0,0,0,255,2,255,7,7,5,1,5,4,5,0,8,1,0,255,6,255,8,4,255,255,255,255,255,255,255,255,255,0,255,255,8,255,8,7,0,0,8,255,8,0,255,0,255,0,8,255,6,0,255,2,255,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,65535,65535,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,65535,141,65535,65535,65535,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,65535,65535,65535,179,181,65535,65535,183,65535,65535,65535,65535,65535,185,187,189,65535,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,65535,223,225,227,229,231,233,235,237,239,241,243,245,247,249,65535,251,65535,253,65535,255,65535,257,259,261,263,265,267,65535,269,271,273,65535,275,65535,277,279,281,283,285,287,289,291,293,295,297,65535,299,65535,301,303,65535,65535,65535,65535,65535,65535,65535,65535,65535,305,65535,65535,307,65535,309,311,313,315,317,65535,319,321,65535,323,65535,325,327,65535,329,331,65535,333,65535,335,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,65535,65535,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,65535,142,65535,65535,65535,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,65535,65535,65535,180,182,65535,65535,184,65535,65535,65535,65535,65535,186,188,190,65535,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,65535,224,226,228,230,232,234,236,238,240,242,244,246,248,250,65535,252,65535,254,65535,256,65535,258,260,262,264,266,268,65535,270,272,274,65535,276,65535,278,280,282,284,286,288,290,292,294,296,298,65535,300,65535,302,304,65535,65535,65535,65535,65535,65535,65535,65535,65535,306,65535,65535,308,65535,310,312,314,316,318,65535,320,322,65535,324,65535,326,328,65535,330,332,65535,334,65535,336,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({27862,5777,16962,4299.5,3972.5,15.5,32410.5,15.5,4803,3221.5,9831,29515,3182,28329,21746.5,51,3461,18.5,5616.5,8548.5,12094,7250.5,9473,2462.5,3144.5,3047,3205,1.5,21762,19560.5,28845,78,3052,1518.5,1230.5,3921.5,871,5757,6167,2013.5,12.5,2569,12.5,10810.5,6869.5,8.5,10443,0.011443816,0.01778025,9,3233,0.025983006,0.017213197,0.0040683127,0.016070813,25976,30086,0.015341939,27017,16.5,13,26877,29504,87.5,35,2207,3619,2227.5,1467,-0.03245205,4086.5,3752,936,21.5,5039,7318,4.5,5905,5692,5.5,2570.5,3751,18.5,9688.5,14.5,14516.5,12596,5923.5,4.5,9164.5,8929.5,10323,13410.5,11829.5,19839.5,0.004826968,0.009525203,3247.5,0.007179828,29588.5,29972,27312.5,30557.5,-0.02791281,4.5,15.5,18.5,-0.0020398048,14.5,17.5,-0.00468358,29446.5,29647.5,26.5,105,44.5,34.5,1358.5,2154,4943.5,4327,821,2528,20.5,2546,3694,3428,32102,5,5095.5,16.5,4701.5,617,2711.5,6103,4325,8424.5,0.02409544,5.5,5380,5704,13,5571.5,1358,1339.5,7.5,2710.5,4.5,5.5,15.5,-0.03501053,4118.5,-0.016265787,4.5,10710,4.5,-0.029315948,-0.041350752,14516.5,5940,7034,8173,8188.5,16.5,-0.035257626,5218,10416,4.5,10373.5,8160,8978.5,8160,3.5,29383,24063.5,0.014485947,0.0063091293,-0.0010615758,0.0017839704,-0.0066408836,26417.5,-0.02627624,-0.03533531,20917.5,2.5,29706,31283.5,-0.002889379,-0.0011730783,-0.0053953533,17285,-0.0015899744,-0.0012278687,16.5,24829,28956,29567,29656,29696.5,-0.0059927166,0.011241166,-0.05918308,-0.005674181,-0.06733557,-0.030345185,0.01276049,-0.008712789,-0.016355846,0.0063920617,-0.035420418,-0.020702565,-0.0010667961,-0.009438304,-0.008002588,-0.015796183,-0.0017847894,-0.010319191,-0.030422708,-0.06000747,0.022572504,0.091146976,0.010864735,9.9020486e-05,-0.008091552,6.492893e-05,-0.022236817,-0.011766939,0.012723142,0.01769306,0.005518666,0.0013680699,-0.0013914673,-0.02816613,0.0013982084,0.011475854,-0.009981232,-0.02595806,-0.017249873,0.020594018,0.0037599218,0.0302495,-0.00052711245,0.0069137514,-0.020167498,-0.00082797784,-0.023957849,-0.0019465223,0.0011347967,0.013082114,-0.022507945,-0.0036803146,-0.030652419,-0.010478743,0.0058960766,-0.01501808,0.007817489,0.0045366376,-0.021541001,-0.037702836,-0.040291518,-0.027691161,-0.031313866,-0.024637593,-0.0090433555,-0.022830704,-0.024064157,-0.02886114,-0.054501224,-0.028055016,-0.03455661,-0.027921349,-0.033777304,-0.027552292,-0.014962846,-0.021991057,-0.011780716,-0.029314911,-0.016401207,-0.025271341,-0.023739278,-0.032083463,-0.011577421,-0.033877257,-0.021412043,-0.015471994,0.0069288868,-0.016332023,-0.006103089,0.0034421736,0.005159551,0.013039966,7.045593e-05,-0.01160166,-0.0027739424,-0.017871015,-0.03006166,-0.015717445,0.02118754,-0.015003051,-0.020511346,0.015135652,-0.028988505,-0.016034424,-0.012971814,-0.03552941,0.00154663,-0.0026937649,-0.0122081,-0.018400589,-0.032342967,-0.010112873,0.00042614058,-0.0027516268,-0.0085427305,-0.021454653,-0.0053192927,-0.016002314,0.0019991272,-0.0029594903,-0.0064424337,-0.009268623,-0.0010511338,-0.003684682,-0.004099349,-0.00310483,-0.0053062043,-0.004160905,-0.0047149598,-0.008111033,-0.003703786,-0.00641623,-0.0041089165,-0.0050181267,-0.0062774527,-0.005102931}, {7,6,4,7,7,8,1,8,0,3,4,1,2,6,6,2,6,8,7,4,4,7,5,4,0,4,2,8,4,6,6,0,1,7,5,6,2,6,7,3,8,5,8,1,6,8,6,255,255,8,2,255,255,255,255,0,7,255,4,8,8,0,0,6,7,0,6,6,6,255,2,0,0,8,2,2,8,1,0,8,7,5,8,0,8,2,0,0,8,0,7,0,6,5,3,255,255,0,255,7,5,2,3,255,8,8,8,255,8,8,255,6,0,4,7,1,2,5,1,2,2,6,6,8,0,7,3,5,8,6,8,6,2,4,4,1,3,255,8,0,6,8,6,7,3,8,7,8,8,8,255,3,255,8,6,8,255,255,2,1,2,2,4,8,255,5,0,8,0,1,3,7,8,2,2,255,255,255,255,255,2,255,255,2,8,5,3,255,255,255,2,255,255,8,0,0,6,4,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,65535,65535,95,97,65535,65535,65535,65535,99,101,65535,103,105,107,109,111,113,115,117,119,121,123,65535,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,65535,65535,175,65535,177,179,181,183,65535,185,187,189,65535,191,193,65535,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,65535,247,249,251,253,255,257,259,261,263,265,267,269,65535,271,65535,273,275,277,65535,65535,279,281,283,285,287,289,65535,291,293,295,297,299,301,303,305,307,309,65535,65535,65535,65535,65535,311,65535,65535,313,315,317,319,65535,65535,65535,321,65535,65535,323,325,327,329,331,333,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,65535,65535,96,98,65535,65535,65535,65535,100,102,65535,104,106,108,110,112,114,116,118,120,122,124,65535,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,65535,65535,176,65535,178,180,182,184,65535,186,188,190,65535,192,194,65535,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,65535,248,250,252,254,256,258,260,262,264,266,268,270,65535,272,65535,274,276,278,65535,65535,280,282,284,286,288,290,65535,292,294,296,298,300,302,304,306,308,310,65535,65535,65535,65535,65535,312,65535,65535,314,316,318,320,65535,65535,65535,322,65535,65535,324,326,328,330,332,334,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({27166.5,5777,9306.5,3870.5,3972.5,2568.5,31182,2797,4132.5,3298.5,9831,2,15.5,27290.5,26085.5,2173,1311.5,659.5,5616.5,1789.5,7830,7241,8220,0.0067934277,3134.5,3197,3213.5,1.5,24813,17.5,10947.5,1642.5,2100.5,921.5,3186.5,507.5,6449,4962,6239,5.5,6948,15.5,2916.5,9709,7101,8884,10830,0.020082075,0.038355585,8.5,0.014207669,2950.5,18.5,25341.5,27512,27988,29279.5,24343.5,21902.5,-0.019663079,30079,932.5,14.5,2150,2464.5,-0.01858932,991,3039,3048,1390,-0.032272585,20.5,16.5,7952,3892,5905,6770,7044.5,1441.5,1862.5,8540.5,4708.5,7907,1467.5,6.5,9352.5,5585.5,4746,8324.5,16562,16341,8298.5,19852.5,3149,3087.5,0.009341097,0.01923181,3046.5,3046.5,0.004580922,26153.5,30036.5,-0.031197269,0.024033703,0.01287765,29647.5,4.5,19811,32357.5,14169,24729.5,3.5,31845.5,820.5,1209.5,5050.5,745.5,18.5,17.5,4426.5,4791,-0.06254395,2.5,15.5,2981,15.5,6282,-0.00676899,-0.0159559,41.5,2033,7379,23117.5,4744.5,1.5,17.5,10697.5,5378.5,5815,14,8527.5,7479,-0.018566482,-0.033836175,7600,-0.05957664,6539.5,7700,4.5,6.5,7907,6771.5,18.5,-0.019161679,13.5,3514,6770.5,9231.5,6061,4615,6986,10700.5,6627.5,8374.5,10461.5,10406.5,12.5,6.5,14,0.02816977,11344.5,29594.5,18835.5,2.5,4.5,0.007640276,0.01142172,0.020339346,0.0061243526,3223,0.012956733,29820,26776,25311,26404.5,-0.02846469,2.5,31320.5,27376.5,18602.5,15.5,5.5,24492.5,-0.015685476,18275,24830,24752.5,29004.5,4.5,4.5,30219.5,-0.005860352,-0.03496671,-0.00295652,0.0069415323,-0.029834736,-0.0010865045,-0.047843266,-0.0059563066,0.007329751,-0.010751954,0.011244042,0.055445075,-0.02150501,0.0014825184,0.0079885,-0.005552528,-0.025418943,-0.044732567,-0.02188688,-0.0034098402,0.019021427,0.00030668217,-0.023319473,-0.009132012,-0.010168144,-0.016043298,-0.01055191,0.002839502,0.02668639,0.0021610127,0.00404055,0.014949197,0.025359673,0.011645332,-0.03245973,-0.012620792,0.008389877,-0.003068797,0.0037115004,0.035876237,-0.0013401967,0.016422627,-0.038925096,-0.0073394547,-0.03585072,-0.019177178,0.004622398,-0.012406385,0.009672712,0.0040565482,-0.03409368,-0.044289704,-0.02488373,-0.028342575,-0.023376776,-0.013522952,-0.028592838,-0.02251286,-0.022440057,-0.027962843,-0.0022788912,-0.012886548,-0.019522099,-0.01170602,-0.008057742,-0.013684032,-0.0036489032,-0.0057735923,-0.027690953,-0.034258414,-0.010801322,-0.019913593,-0.012037728,-0.025657276,-0.012080416,-0.031530548,-0.014286505,0.0104269,-0.024529038,-0.0115551455,-0.023947814,-0.0119646955,0.0014142189,-0.03829779,0.009253972,-0.018673766,0.004270335,-0.008048927,-0.014502202,-0.0020574655,-0.020363728,-0.015538706,-0.022973629,-0.030175412,-0.0026835892,-0.008713009,0.0055867517,-0.001644264,-0.021245135,-0.0017101866,-0.010985824,-0.01675569,0.006371792,-0.010813904,0.00096939283,0.0056483215,0.010963201,0.005654815,0.0003659828,-0.0019936597,-0.0016467035,0.0013837977,-0.0052220793,-0.00033294593,-0.026799534,-0.01960076,-0.011532832,-0.017954454,-0.004137454,-0.018620877,4.3837437e-05,-0.005078172,-0.010685316,-0.006468779,-0.0024881768,-0.004702141,-0.0017962515,-0.0027630453,-2.6047734e-05,-0.009879923,-0.0024180242,-0.0037337523,-0.0026179685,-0.0073585818,-0.004523159,-0.007843177,-0.0012107485,-0.0041163526,0.005695853,0.002730998,8.544017e-05,-0.0033382736,-0.0037378513,-0.0077136317,-0.004658863,-0.0041097347}, {1,6,0,7,7,4,1,6,2,7,4,8,8,0,4,7,5,3,7,7,6,7,5,255,0,6,0,8,2,8,6,6,6,0,2,2,7,3,7,8,6,8,1,6,3,3,4,255,255,8,255,0,8,2,2,0,0,0,4,255,3,5,8,4,7,255,3,7,5,4,255,8,8,1,7,1,0,6,3,0,4,2,0,3,8,6,3,2,2,0,7,5,5,0,0,255,255,2,2,255,0,1,255,255,255,3,8,0,3,4,2,8,5,4,7,1,7,8,8,4,2,255,8,8,6,8,4,255,255,0,0,1,1,2,8,8,2,1,2,8,0,0,255,255,0,255,4,2,8,8,0,6,8,255,8,7,0,6,5,7,3,7,6,6,3,2,8,8,8,255,5,6,7,8,8,255,255,255,255,0,255,3,0,4,2,255,8,0,5,0,8,8,2,255,0,4,2,3,8,8,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,65535,65535,93,65535,95,97,99,101,103,105,107,109,65535,111,113,115,117,119,65535,121,123,125,127,65535,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,65535,65535,177,179,65535,181,183,65535,65535,65535,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,65535,217,219,221,223,225,65535,65535,227,229,231,233,235,237,239,241,243,245,247,249,251,65535,65535,253,65535,255,257,259,261,263,265,267,65535,269,271,273,275,277,279,281,283,285,287,289,291,293,295,297,65535,299,301,303,305,307,65535,65535,65535,65535,309,65535,311,313,315,317,65535,319,321,323,325,327,329,331,65535,333,335,337,339,341,343,345,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,65535,65535,94,65535,96,98,100,102,104,106,108,110,65535,112,114,116,118,120,65535,122,124,126,128,65535,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,65535,65535,178,180,65535,182,184,65535,65535,65535,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,65535,218,220,222,224,226,65535,65535,228,230,232,234,236,238,240,242,244,246,248,250,252,65535,65535,254,65535,256,258,260,262,264,266,268,65535,270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,65535,300,302,304,306,308,65535,65535,65535,65535,310,65535,312,314,316,318,65535,320,322,324,326,328,330,332,65535,334,336,338,340,342,344,346,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({27166.5,5955.5,9306.5,15.5,4552.5,1295.5,31182,4219.5,3711,3340,9831,0.03718316,15.5,27290.5,24492.5,37.5,3482,1502,4904,5951,7940.5,7480.5,9243,8.5,3247.5,1.5,24813,17.5,10947.5,29.5,39.5,3.5,5600.5,1745,827.5,18.5,5901.5,8045.5,1441.5,2446.5,4588.5,9681.5,7807.5,5166.5,10830,2849,0.011966718,2950.5,0.004353465,25132.5,27512,27988,29279.5,26124.5,15983,5.5,29004.5,121.5,129,64.5,1225,2935,3047,5599,5339.5,107,895.5,20.5,1204,2930,7329.5,6506.5,5062,5488,4.5,7117.5,8469,5.5,14.5,4475,4297,6782.5,6037,7427.5,10884.5,5.5,10314,11344.5,19771,3083.5,31509,18.5,0.01921326,0.003702969,28870,30645,-0.028193993,0.022043837,0.011554385,29647.5,4.5,21902.5,6.5,-0.015409029,19811,-0.003199678,-0.013836418,4.5,32312,33.5,5,41.5,33,61,6.5,64,1905,0.013378239,1.5,0.010404786,2673.5,8060,4.5,6590,6367,92,533.5,1346,1897.5,18.5,59.5,-0.030447165,1188.5,3194,4229,5746.5,9112,2054,17646.5,8091.5,4675,2757.5,7508,3400.5,512,-0.03409594,4,4.5,12.5,-0.039443973,-0.026248535,4035.5,3924.5,4168.5,6.5,4474,10538,5243,6857,11535,9590.5,5917,7855,5446,2.5,4952,10939,4.5,11656.5,6752.5,16.5,31296,24917,0.0057901125,0.012044884,0.0076859603,2.5,0.0022978855,0.00899473,28360.5,29837,30107,30700.5,-0.026022578,1.5,31320.5,31314.5,15.5,3.5,-0.00029186983,-0.008609089,18206,18146,3.5,-0.0020687736,31379.5,29386,-0.007444113,0.003784133,0.02154321,0.004373544,0.013734152,-0.005779563,0.0041272347,-0.030947769,-0.050394285,-0.009546525,-0.06958687,-0.048849367,0.007353648,-0.0035845786,-0.026539225,-0.008402666,0.010782267,0.0013791156,0.018142734,0.008558444,-0.00302137,-0.0128660295,0.039184533,0.021234507,0.001085577,-0.024623288,-0.021291863,0.0012415426,-0.005153326,-0.03304855,0.012187679,-0.0026062957,-0.021558693,-0.051993605,-0.04058842,0.0068582534,0.008259385,0.0283757,0.029239072,0.063782245,0.05917832,0.005145605,-0.026484592,-0.010657721,-0.008784972,-0.002401658,-0.015498509,-0.0108372,-0.024922093,-0.006904124,0.036202718,0.0038287484,-0.0037167158,-0.034600217,0.0025551743,-0.00997087,0.01638604,-0.02249231,-0.023430638,-0.0153730465,-0.0088643525,-0.016119495,-0.016400615,-0.0072705536,-0.035825364,-0.024747873,-0.011476588,-0.026024407,-0.027081478,-0.020692253,-0.022338172,-0.02668179,-0.017140372,-0.010949842,-0.011628873,-0.004405821,-0.025285034,-0.01502084,-0.015255629,-0.045958728,-0.027544886,-0.0056953323,-0.0036490478,-0.026432464,-0.0027671214,-0.019432055,-0.009483069,0.002150847,-0.010450842,-0.022248087,-0.034388576,-0.019597566,-0.0014998997,-0.030008972,0.005728948,-0.010867751,-0.0019588147,-0.011517134,0.003662613,-0.0021395807,-0.015664862,-0.008663883,-0.0062902975,-0.02669141,-0.027201628,-0.016983725,-0.006524796,-0.016062096,0.0046879393,-0.02156827,-0.0024797565,0.0014586382,-0.010313558,-0.015479087,-0.02633117,-0.007942385,0.0025481128,0.005338676,-0.0012750718,-0.0066177654,-0.0029623492,0.00020495441,-0.020673655,-0.016015714,0.0003177046,-0.009810458,-0.0013226384,-0.01651699,0.00057394005,-0.004679876,-0.0057297423,-0.009437826,-0.0015568805,-0.0025885808,-0.004297498,-0.0021562558,-0.003429436,-0.0015251997,-0.0015745802,-0.005063409,0.005975618,0.0017627703,-0.0037526467,-0.006572284,-0.0035894946,-0.004085372}, {1,2,0,8,3,4,1,5,0,1,4,255,8,0,2,4,4,1,1,0,2,3,5,8,0,8,2,8,6,6,5,8,3,0,6,8,7,4,3,3,7,6,2,5,4,4,255,0,255,2,2,0,0,0,2,8,3,2,0,6,2,2,4,3,0,1,5,8,7,1,0,0,2,4,8,4,2,8,8,7,3,2,1,5,7,8,4,5,3,0,7,8,255,255,5,1,255,255,255,3,8,4,8,255,0,255,255,8,5,4,8,6,4,6,8,4,3,255,8,255,0,6,8,6,3,0,4,4,0,8,6,255,6,7,1,0,0,6,1,0,0,1,2,7,0,255,8,8,8,255,255,7,3,3,8,1,0,7,7,2,0,4,4,4,8,7,2,8,4,3,8,0,2,255,255,255,8,255,255,1,1,7,1,255,8,0,3,8,8,255,255,4,6,8,255,1,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,65535,91,65535,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,65535,65535,179,181,65535,65535,65535,183,185,187,189,65535,191,65535,65535,193,195,197,199,201,203,205,207,209,211,65535,213,65535,215,217,219,221,223,225,227,229,231,233,235,65535,237,239,241,243,245,247,249,251,253,255,257,259,261,65535,263,265,267,65535,65535,269,271,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,311,65535,65535,65535,313,65535,65535,315,317,319,321,65535,323,325,327,329,331,65535,65535,333,335,337,65535,339,341,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,65535,92,65535,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,65535,65535,180,182,65535,65535,65535,184,186,188,190,65535,192,65535,65535,194,196,198,200,202,204,206,208,210,212,65535,214,65535,216,218,220,222,224,226,228,230,232,234,236,65535,238,240,242,244,246,248,250,252,254,256,258,260,262,65535,264,266,268,65535,65535,270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,312,65535,65535,65535,314,65535,65535,316,318,320,322,65535,324,326,328,330,332,65535,65535,334,336,338,65535,340,342,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({27862,5966.5,16962,4238,4124.5,8.5,31182,39,3913,3311,7213,21041.5,29515,28329,26845,33.5,37.5,18.5,5709,744.5,7830,9713.5,10408.5,3090,2820.5,3122.5,3041.5,29216.5,21762,17.5,15.5,3444.5,35.5,65,821,3918.5,3229,5656.5,6317.5,299.5,1789.5,12.5,4070.5,11096.5,14698,6538,12.5,0.014102437,4.5,2.5,2.5,17475.5,17.5,0.0056802942,2402,-0.024410984,1.5,0.016376399,27144.5,24439.5,24547,29703.5,32312,93.5,12,34.5,33,60.5,6.5,44.5,660.5,617,2033,836.5,5598,4928,5750.5,4790,7173,-0.03167002,-0.05361388,5.5,1796.5,3969.5,8610,3994,12.5,7180,8166.5,10335.5,12.5,15.5,7101,18336.5,14772.5,0.011129766,6,0.005303038,0.010393242,3161.5,3195.5,19.5,18.5,2979.5,2843.5,18,13.5,26217,30010.5,27058.5,30971.5,19811,24605.5,19811,24796.5,29702.5,29709.5,-0.0061240625,29709.5,22,-0.029874308,0.019365031,18.5,26.5,0.03516435,20.5,35,119,51.5,-0.053655613,13897.5,33.5,18.5,996,1240.5,379.5,5778.5,16.5,2662.5,4719,4210,3044,24437.5,5038,17.5,5564,6733,4343.5,5328.5,5926,10.5,2347,1455,13.5,6764,5.5,3823,4094,8640.5,4.5,12.5,4.5,-0.045344125,4584,6674.5,1.5,7.5,8388,11694,5.5,5373,6147.5,6022.5,6754,11302.5,13101,21925,11745,12495,0.00017308236,0.0024057357,2950.5,3176,29371,0.008496486,0.009136995,0.0011767348,17.5,0.026064236,0.004991084,0.016218556,-0.003632113,19.5,0.0101089,-0.0014880182,0.009925341,0.014655113,26743,27366,20323.5,26417.5,-0.017729884,4.5,3.5,-0.009182575,18602.5,22333.5,16,4.5,18206,18.5,24769,24816,29975,2.5,29630,30040,29906.5,29753,-0.0072431224,-0.0012512855,0.005860014,0.002813786,-0.0073995492,0.010152114,0.0014247381,0.030453864,-0.02244076,0.0066353404,-0.06123602,-0.046559654,-0.06867551,-0.0073673534,-0.036160123,-0.012159137,0.0041904063,-0.02666454,-0.00065896305,0.010414657,-0.06811046,-0.026844744,0.003010287,-0.008578058,-0.004183537,-0.018790904,0.0015686846,0.010884362,0.0010063724,0.018407019,0.01426099,0.008040945,-0.007492433,-0.022317514,0.0451808,0.026688445,-0.0031887006,0.005044499,0.020409806,-0.008576249,0.0012070138,-0.016452698,0.0030850244,0.016350044,-0.0048660766,-0.035648108,-0.011506422,0.0005359958,-0.030792952,0.004306245,-0.03358595,-0.013736635,0.0075050364,-0.014146762,-0.0017291516,-0.011735577,-0.027337512,-0.036367774,-0.027144266,-0.020740476,0.009429082,-0.015760079,-0.012723672,-0.020207865,-0.013775899,-0.019683836,-0.0015408624,-0.012056024,-0.0105579635,-0.00074172684,-0.004158567,-0.0015140212,-0.014701611,-0.021254469,-0.011566429,-0.0041522263,-0.007712646,-0.027446136,-0.0150098745,-0.009193153,-0.0077162646,-0.024497168,0.014502905,0.0024762107,-0.012259364,-0.003822444,-0.010276693,-0.01774798,-0.007921481,-0.01559673,-0.015161604,-0.019815687,-0.0278539,-0.020791525,0.0113835605,0.004359461,0.020545734,0.006151059,-0.003105659,-0.017518608,-0.0023166912,-0.014487686,-0.007722856,-0.024018673,0.0008366581,-0.008495725,-0.0022477624,-0.022133427,-0.021424234,-0.011559412,0.0007423465,0.002695605,-0.002550599,-0.00013256728,0.00034706798,0.0045068692,0.016455807,0.0048117237,0.0039647184,0.012392152,0.00056058465,0.0027731326,-0.0032378458,0.00025129336,-0.0061522694,-0.01869171,-0.010273271,-0.0151068615,0.004145203,-0.001575746,-0.0016307613,-0.00506708,-0.0023342648,-0.004036012,-0.0014965608,-0.0020050493,-0.0020609193,-0.0004328836,-0.003351689,-0.0029799724,-0.0031459723,-0.0012622294,-0.007014718,-0.0047302986,-0.0031622609,-0.005314882,-0.0013280959,-0.0032641224,-0.0038028657,-0.0056949174,-0.0021786948,-0.002579427,-0.00386489,-0.0072246836,-0.004227471,-0.0035978637,-0.003481621,-0.00534363,-0.002773954,-0.003343217}, {7,6,4,7,7,8,1,6,4,7,7,3,1,6,2,2,7,8,7,0,6,6,0,0,4,4,6,7,4,8,8,4,0,2,6,5,3,1,7,0,7,8,7,1,4,6,8,255,8,8,8,5,8,255,2,255,8,255,1,4,4,6,5,0,8,0,6,2,8,1,7,2,0,2,7,1,5,2,7,255,255,8,7,1,4,7,8,1,2,0,8,8,3,2,0,255,8,255,255,2,6,8,8,2,0,8,8,4,5,4,1,0,0,0,6,6,6,255,2,0,255,255,8,4,255,8,6,0,0,255,0,0,8,1,0,2,6,8,0,6,6,2,7,0,8,3,1,4,2,6,8,1,7,8,6,8,2,7,0,8,8,8,255,7,5,8,8,4,6,8,7,6,0,4,4,3,6,1,3,255,255,0,0,7,255,255,255,8,255,255,255,255,8,255,255,255,255,6,0,2,2,255,8,8,255,0,0,8,8,4,8,4,6,2,8,2,0,0,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,65535,95,97,99,101,103,65535,105,65535,107,65535,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,65535,65535,151,153,155,157,159,161,163,165,167,169,171,173,175,177,65535,179,65535,65535,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,65535,217,219,65535,65535,221,223,65535,225,227,229,231,65535,233,235,237,239,241,243,245,247,249,251,253,255,257,259,261,263,265,267,269,271,273,275,277,279,281,283,285,287,289,291,293,295,65535,297,299,301,303,305,307,309,311,313,315,317,319,321,323,325,327,65535,65535,329,331,333,65535,65535,65535,335,65535,65535,65535,65535,337,65535,65535,65535,65535,339,341,343,345,65535,347,349,65535,351,353,355,357,359,361,363,365,367,369,371,373,375,377,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,65535,96,98,100,102,104,65535,106,65535,108,65535,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,65535,65535,152,154,156,158,160,162,164,166,168,170,172,174,176,178,65535,180,65535,65535,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,65535,218,220,65535,65535,222,224,65535,226,228,230,232,65535,234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,264,266,268,270,272,274,276,278,280,282,284,286,288,290,292,294,296,65535,298,300,302,304,306,308,310,312,314,316,318,320,322,324,326,328,65535,65535,330,332,334,65535,65535,65535,336,65535,65535,65535,65535,338,65535,65535,65535,65535,340,342,344,346,65535,348,350,65535,352,354,356,358,360,362,364,366,368,370,372,374,376,378,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({27407.5,5873,16962,15.5,3975.5,2673.5,22213,6.5,4159,3346,9679.5,3135.5,5.5,9037,31182,1157.5,3741.5,436,4774,13520,7940.5,9138,10733,2583.5,0.017514993,2676,27522,4,24164,29279.5,7777.5,944,4599,1164,3383,451,788,2683.5,7352,2630,12.5,14.5,3973,7427.5,8733,10656,10479.5,15,19,2.5,3179,3182.5,11.5,1.5,-0.001984038,0.024480296,0.013975066,1.5,4.5,-0.014200029,29574.5,37.5,1245,2.5,3853.5,446,1350.5,41.5,3762,37,617,776.5,1299.5,2986.5,18.5,5612.5,18781,7.5,2416,14704.5,6800,4077,5242.5,27222,4176,8168.5,8335.5,6659,8324,10289,21884,11784.5,13526.5,0.009710311,0.01815414,10.5,-0.0064495443,-0.0014182476,0.0040712557,0.0078026736,3209.5,0.008626967,17,7.5,0.013350695,0.0043055997,0.0013986055,25541.5,30089,30290.5,26926.5,30031.5,29430,34.5,22.5,867,2.5,2778.5,3263.5,3362,5715.5,590,1204,12.5,2267.5,316.5,3447.5,3106,7016,74,54,-0.033066075,-0.07106093,20.5,0.08763386,2227.5,1194,3604,-0.004055032,4329.5,5593,5285.5,5375.5,7792.5,11965.5,7946.5,8511.5,5.5,5.5,-0.023189431,1.5,-0.033160746,-0.023151219,6.5,3535.5,5501,6150,2336.5,17,4.5,12.5,4662.5,6687,7434,8527,18.5,3.5,8220.5,1.5,10429.5,29676.5,-0.053593803,-0.029614089,8287,7584,10587.5,14749,0.00058749475,0.010292731,3,4.5,0.005571255,-0.00046282084,0.0028721911,0.0081547955,0.0020764123,26527.5,25600,30557.5,29747.5,1.5,29818.5,31314.5,17.5,27157,29699.5,30221.5,-0.0018397917,0.01617976,-0.05688588,-0.0077474113,-0.041561563,-0.016426668,-0.01928143,-0.0035498012,-0.0121353,0.00020462727,0.0060431496,8.39746e-05,-0.017011056,-0.008135913,0.0018555329,-0.0043328283,-0.0064416737,-0.06320713,0.0025592104,0.019610863,-0.038776882,-0.016622448,0.006717986,-0.013984757,-0.013817024,-0.027400533,0.009697992,-0.00048957777,-0.027875265,-0.013929886,-0.0047160103,-0.0099938875,0.0016966425,-0.022960221,-0.011077648,0.0010480759,0.0066990443,0.029000735,-0.007982486,-0.03673945,0.028693423,0.0041081975,-0.013513754,-0.025803378,-0.0005852812,-0.00695581,-0.013788118,-0.008821915,0.0018243816,0.014807733,0.008963774,-0.012642493,-0.010264,-0.0025808865,-0.03921265,-0.014296084,-0.022774829,-0.019547561,-0.016487613,-0.022949556,-0.033015374,-0.019778963,-0.008950154,-0.015796652,-0.023903264,-0.018235302,-0.012054929,-0.017188445,-0.0037883574,-0.009930222,-0.020278404,-0.011713578,-0.012261301,-0.0031141897,-0.023916837,-0.017857706,0.001267351,-0.012321191,-0.01321924,-0.019329656,-0.012785959,-0.0063918578,-0.0104020685,-0.0065232613,-0.0070641288,-0.038170673,-0.007737799,0.0027616613,-0.025985688,-0.0040360405,0.008155768,0.019210927,0.0074347854,0.00065343466,-0.016489035,-0.0019303687,0.0066671893,-0.0016246397,-0.014042032,-0.053138863,-0.007702348,-0.026046744,-0.0023215113,-0.034535687,-0.024062918,-0.00024359129,-0.006019193,-0.022843054,-0.000715066,-0.008965056,3.9476176e-06,0.0029293732,0.0052454746,0.001263159,-0.0033340328,-0.0005259807,-0.012125659,-0.018629221,-0.014301421,-0.009264891,-0.0019295143,0.0029637082,0.00080969976,-0.0037397519,-0.0001361184,-0.001694268,-0.0042771725,-0.007478952,-0.0026691048,-0.0034141664,-0.0034736076,-0.006886934,-0.006458857,-0.0044539757,-0.003452529,-0.0029441898}, {5,4,4,8,5,0,1,8,6,3,6,4,8,0,1,7,7,1,7,2,2,5,7,0,255,6,3,8,2,0,6,6,4,6,2,0,6,3,6,7,8,8,7,5,4,7,4,8,8,8,0,0,8,8,255,255,255,8,8,255,6,4,3,8,5,7,7,0,3,2,0,6,5,5,8,3,6,8,1,0,0,1,6,1,3,7,2,0,1,3,0,7,6,255,255,8,255,255,255,255,0,255,8,8,255,255,255,2,7,5,3,0,0,4,5,7,8,7,6,1,0,6,7,8,0,2,6,5,0,4,7,255,255,8,255,6,0,4,255,2,2,5,1,7,0,0,0,8,8,255,8,255,255,8,5,2,4,7,8,8,8,7,1,3,4,8,8,6,8,7,0,255,255,5,2,2,6,255,255,8,8,255,255,255,255,255,2,4,3,4,8,0,3,8,2,6,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,65535,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,65535,65535,65535,107,109,65535,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,65535,65535,177,65535,65535,65535,65535,179,65535,181,183,65535,65535,65535,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,65535,65535,233,65535,235,237,239,65535,241,243,245,247,249,251,253,255,257,259,65535,261,65535,65535,263,265,267,269,271,273,275,277,279,281,283,285,287,289,291,293,295,297,65535,65535,299,301,303,305,65535,65535,307,309,65535,65535,65535,65535,65535,311,313,315,317,319,321,323,325,327,329,331,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,65535,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,65535,65535,65535,108,110,65535,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,65535,65535,178,65535,65535,65535,65535,180,65535,182,184,65535,65535,65535,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,65535,65535,234,65535,236,238,240,65535,242,244,246,248,250,252,254,256,258,260,65535,262,65535,65535,264,266,268,270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,65535,65535,300,302,304,306,65535,65535,308,310,65535,65535,65535,65535,65535,312,314,316,318,320,322,324,326,328,330,332,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({27407.5,5817.5,16962,4049.5,4124.5,8.5,22213,2797,4803,3298.5,9831,3158.5,2718.5,9037,31182,2173,1719.5,17.5,5539.5,7644.5,7830,7241,11165.5,2.5,3081,15.5,28554.5,4,24164,29279.5,25654,2289.5,2100.5,3243.5,3150,3921.5,871,7735,7055.5,4.5,7708,3902,4070.5,6182,18781,30200.5,10510.5,3096,3107,0.010682645,3209.5,0.011995198,0.018172476,20.5,18135.5,2,-0.0019218067,0.023094418,3,1.5,27340.5,17.5,26103.5,14.5,1831,2341.5,2694.5,1389,13.5,15.5,3050.5,3766,617,21.5,3333,7389,5602.5,5868,8204.5,3285,744.5,2420,8712,7820,3636.5,6075.5,6.5,7108,6787,2.5,4109,10289,8.5,11829.5,13824.5,2668.5,2823,3101.5,2776.5,6.5,0.006485442,0.003407276,-0.0037834134,18.5,18.5,0.0040065274,0.00067411613,0.0049247793,0.013420852,32035,27316,4.5,2.5,21902.5,24719,-0.01045923,29750,37,69,2520,15,18.5,18.5,4301.5,4907.5,4.5,1054,4,1251.5,6.5,2292.5,2958.5,3049.5,29433,4.5,1390,1.5,4701.5,26.5,84.5,5294.5,7318,7302.5,7393.5,6006.5,5474,5692,5750,8304,4423.5,3173.5,-0.03478877,6150.5,2294,6,15.5,18.5,15.5,3222.5,3192.5,3750.5,3.5,3994,4.5,12,5274.5,4652,4664.5,9695,7976.5,10430.5,-0.050237592,16742.5,13715,13050.5,31984.5,31984.5,9352,17.5,1.5,8.5,0.005819219,0.0011102145,0.0010017055,-0.0065799803,0.008943758,4.5,-0.0021236264,0.004004429,0.0028978416,0.0010003705,17,2985.5,17.5,0.01751098,27059,0.004462618,30904,25921,28705.5,29851,31201.5,31283.5,18181,24724.5,19.5,24769,29731.5,30183.5,0.0006035112,-0.008108824,-0.0054874504,0.0013171725,-0.022639822,-0.03633606,-0.021739172,0.008172158,0.009073085,0.05462102,0.008389282,-0.009852452,-0.015039328,0.0025698268,0.007972918,-0.0010672997,-0.0144502,-0.028779745,-0.062089335,-0.04103058,-0.010975364,-0.024539601,-0.005942717,-0.019150613,-0.008205312,-0.018195655,0.011026356,-0.00903608,0.020444227,0.004650407,-0.01820284,-0.0065120296,0.011719117,0.0075431094,0.0041660457,0.0012509305,-0.0034339693,-0.015206973,0.010325434,0.00076949026,-0.0056377896,-0.021778608,0.01254972,-0.011310658,-0.02375521,0.0261109,-0.000515812,0.014515119,0.0012313797,-0.0320629,0.014618099,0.00046517552,0.012451964,-0.0023966166,-0.042085223,-0.0042980546,-0.019889805,-0.0048797205,-0.032678574,-0.014566936,-0.019777933,0.0063537457,-0.026353016,-0.007839935,-0.025428845,-0.003669078,-0.002058719,-0.01088699,-0.023033766,-0.016768944,-0.0116858585,-0.021747602,0.015740586,-0.0013764197,-0.016475106,-0.011745479,-0.017294617,-0.021600518,-0.014795805,-0.009761508,-0.0016812806,-0.008365711,-0.006962195,-0.0021223503,-0.0142659275,-0.006812694,-0.0067416555,-0.031658184,-0.016229931,-0.0060868347,-0.0055124247,-0.013447972,-0.024150254,-0.041267283,-0.009926825,-0.0032550597,-0.012325575,-0.004716313,-0.0010253335,-0.019236173,-0.0048284787,-0.014784402,0.008279683,0.0007304457,-0.0044034757,-0.000459601,-0.026897764,-0.013686835,-0.010698742,-0.015854746,-0.030472366,-0.004183409,-0.014411501,-0.025494298,-0.026593465,-0.03190511,-0.005287101,-0.034502555,-0.0016766118,0.0015585544,0.015529676,-0.019364132,-0.0054063625,-0.008778811,0.00550352,0.0011500543,0.012966714,0.004317023,-0.0040224036,-0.001225377,0.0084968945,0.003016758,0.0010366034,-0.0017205116,-0.014333348,-0.009269661,-0.008805802,-0.022989871,0.0066449656,0.0028660966,-0.0005703486,-0.0042261845,0.00031194164,-0.004764157,-0.0036882542,-0.006667702,-0.0019884405,-0.0010364937,-0.0019626496,-0.0024996358,-0.0053290846,-0.003710523,-0.0015018445,-0.002972558,-0.003141633,-0.0025615508,-0.0035704498,-0.0026899336}, {5,6,4,7,7,8,1,6,0,7,4,4,0,0,1,7,5,8,7,0,6,7,5,8,0,8,5,8,2,0,0,6,6,4,7,6,2,0,2,8,0,1,7,7,6,4,6,4,4,255,0,255,255,8,3,8,255,255,8,8,1,8,0,8,7,7,7,4,8,8,0,0,2,8,3,4,3,2,4,1,0,7,2,4,5,0,8,6,6,8,0,3,8,5,4,2,2,6,0,8,255,255,255,8,8,255,255,255,255,5,2,8,8,4,4,255,6,2,3,6,8,8,8,4,2,8,2,8,1,8,5,6,5,1,8,4,8,6,0,0,5,2,1,4,5,4,7,4,2,3,3,255,4,1,8,8,8,8,1,5,3,8,7,8,8,2,5,2,6,6,5,255,0,2,2,0,0,6,8,8,8,255,255,255,255,255,8,255,255,255,255,8,0,8,255,1,255,7,0,3,0,3,3,6,0,8,4,2,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,65535,99,65535,65535,101,103,105,65535,65535,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,65535,65535,65535,191,193,65535,65535,65535,65535,195,197,199,201,203,205,65535,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,259,261,263,265,267,269,271,273,275,65535,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,311,313,65535,315,317,319,321,323,325,327,329,331,65535,65535,65535,65535,65535,333,65535,65535,65535,65535,335,337,339,65535,341,65535,343,345,347,349,351,353,355,357,359,361,363,365,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,65535,100,65535,65535,102,104,106,65535,65535,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,65535,65535,65535,192,194,65535,65535,65535,65535,196,198,200,202,204,206,65535,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,264,266,268,270,272,274,276,65535,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,312,314,65535,316,318,320,322,324,326,328,330,332,65535,65535,65535,65535,65535,334,65535,65535,65535,65535,336,338,340,65535,342,65535,344,346,348,350,352,354,356,358,360,362,364,366,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({23986.5,6077.5,21521,16.5,3721.5,19332,30603,7.5,3701,1772,9679.5,19533.5,25310,29264.5,10286.5,8398,4008,436,4669,7496,1796.5,7303,7927,5.5,0.029876068,22420.5,1060,9676.5,4.5,9.5,30185.5,5792,9294,1164,5861,451,363,1314.5,6875,4.5,8072,5.5,3290,2187.5,7808.5,12463.5,29690,0.010531021,0.017209155,1.5,15.5,4,31502.5,2776.5,25937.5,30076.5,30763.5,2844.5,30516.5,26859,30212.5,2843,2823,1.5,6947,763.5,2256,3946.5,4671,112.5,3062.5,18.5,740.5,3686,5263.5,5648,6362,7110,1410.5,6.5,-0.017637016,7272.5,11.5,8575.5,2041.5,8320,3377.5,8137.5,7774,10335.5,6.5,13129,14381.5,0.014611437,2.5,0.007956186,0.0028130084,0.0006272914,-0.0018281409,0.011638364,19,16,32006,2.5,2.5,29769,30565,29769,6.5,2713.5,6.5,15.5,2607.5,26848.5,4,29770.5,32410.5,50,7692.5,2823,5012,9851,3229.5,8434.5,8345,637,1204,1292.5,2769,3133,5656.5,3339,4914,92,19.5,555.5,343,27.5,81,552.5,759.5,19.5,3124.5,18.5,4062,4604,5995.5,5743.5,6341.5,2067,3.5,-0.019972356,6296.5,-0.026868274,6156,2,0.01823284,7272.5,18.5,12.5,4.5,9.5,4.5,15.5,7823,2947.5,7182.5,8037,9549.5,7908,9138,4.5,15.5,1.5,5634.5,10458,17686,12.5,4.5,-0.0043409294,-0.017051551,12.5,-0.0018329959,0.0038845732,-0.007534526,19.5,15.5,25489.5,24057.5,26629.5,25821,31201.5,27223,1.5,30239,29740,29792.5,-0.0036004134,30378,2.5,0.009323696,1.5,0.0053876117,25460.5,0.019788524,18,18.5,-0.013502394,2.5,1.5,29702,4.5,16.5,26524,29796.5,0.0013733268,-0.00728384,0.0028614094,-0.013397942,-0.029715551,-0.01832827,0.00028538005,-0.009096596,0.012663208,0.0035082088,0.007984496,0.0019136502,-0.0327949,-0.010126045,-0.008104702,0.00075748883,-0.0051587326,-0.027962849,0.0016823029,0.017459612,0.00023080663,-0.024780035,0.0028505574,-0.011925187,0.0021308146,0.013550057,-0.0009192109,-0.007427951,-0.0059853503,-0.015783537,-0.00023651459,-0.0053394637,-0.0036930447,-0.027955344,0.009889654,-0.004422046,-0.02993611,-0.06496101,0.00060596265,-0.020767827,-0.007832014,0.009301482,-0.005879343,0.043310784,-0.0014265217,-0.025134964,0.10506602,0.005398614,-0.0066313925,-0.014817128,-0.02138542,-0.029492099,-0.0039551207,-0.010864173,0.0011003915,0.015200435,0.029445637,0.0060714553,-0.022905389,0.003435238,-0.0012298601,-0.010092484,-0.012416802,0.00042291937,-0.019355329,-0.023822932,-0.006990708,-0.0029163384,-0.013940493,-0.015875973,-0.023428883,-0.017465018,-0.00075110135,4.1384217e-05,-0.011059935,0.004597283,-0.008112543,-0.0022008915,-0.015393197,-0.01156678,-0.011026635,-0.017248288,-0.02780587,-0.016607594,-0.0042272774,-0.011499458,-0.015386814,-0.010011772,-0.02652599,-0.012438984,-0.007843646,0.0075536887,-0.007953605,-0.020269511,0.00363442,-0.009871277,-0.031197397,0.0021814487,-0.028031692,0.013653996,-0.007924406,-0.0008935311,-0.018534899,-0.010599772,-0.0058134943,-0.01309029,-0.016741274,-0.009572703,-0.020295305,-0.014521151,-0.0085830735,-0.0007806336,-0.017284924,-0.0045997403,-0.020141281,-0.027472237,-0.0034560238,-0.008438522,0.0037665882,0.015666978,0.005873773,-0.0013815573,0.006786411,0.015943304,-0.0010358752,0.0030311428,-0.011013544,-0.0057156705,-0.00036318696,-0.0070713693,-0.018011639,-0.012609671,0.0014295672,-0.0023333018,0.006088968,0.0025521507,0.0002676452,-0.002061844,-0.0035697955,-0.007999014,-0.005008742,-0.0033739766,-0.0024105906,-0.00045759697,-0.0060665566,-0.0040880893,0.0008756476,0.0048452015,0.0025091346,0.00047901738,0.0020861432,0.012074096,0.0076592513,-0.0011065311,0.0076795924,0.013531278,0.00019134066,-0.008215248,0.000953475,-0.00076583785,-0.005482866,-0.0029845615,0.0025758815,-0.0009452003,0.002181324,0.00068028027,-0.00933424,-0.003379618,-0.0024183241,-0.0028531998}, {7,0,3,8,1,5,7,8,2,7,6,4,5,4,0,7,7,1,3,0,7,1,7,8,255,0,0,0,8,8,3,6,6,6,6,0,6,1,2,8,0,8,1,7,0,4,6,255,255,8,8,8,1,0,7,6,4,4,3,6,3,5,3,8,2,1,7,6,7,1,7,8,5,4,5,5,4,6,1,8,255,0,8,2,3,0,4,6,1,0,8,3,7,255,8,255,255,255,255,255,8,8,3,8,8,2,3,2,8,4,8,8,4,0,8,0,1,6,4,5,2,7,2,4,3,0,7,2,2,4,1,1,7,0,8,2,1,7,2,2,4,8,5,8,3,2,5,1,1,3,8,255,0,255,6,8,255,0,8,8,8,8,8,8,6,5,1,4,3,0,5,8,8,8,1,3,6,8,8,255,255,8,255,255,255,8,8,7,3,6,6,3,7,8,1,4,6,255,5,8,255,8,255,1,255,8,8,255,8,8,1,8,8,4,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,65535,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,65535,65535,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,65535,155,157,159,161,163,165,167,169,171,173,175,177,65535,179,65535,65535,65535,65535,65535,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,259,261,263,265,267,269,271,273,275,277,279,281,65535,283,65535,285,287,65535,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,323,325,327,329,331,65535,65535,333,65535,65535,65535,335,337,339,341,343,345,347,349,351,353,355,357,65535,359,361,65535,363,65535,365,65535,367,369,65535,371,373,375,377,379,381,383,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,65535,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,65535,65535,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,65535,156,158,160,162,164,166,168,170,172,174,176,178,65535,180,65535,65535,65535,65535,65535,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,264,266,268,270,272,274,276,278,280,282,65535,284,65535,286,288,65535,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,326,328,330,332,65535,65535,334,65535,65535,65535,336,338,340,342,344,346,348,350,352,354,356,358,65535,360,362,65535,364,65535,366,65535,368,370,65535,372,374,376,378,380,382,384,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({27166.5,5911,9306.5,16.5,4065.5,1295.5,31182,3196.5,3919.5,5009.5,9679.5,0.028745353,15.5,27290.5,30079,2880,3619,397.5,4774,13364,15.5,9142.5,7927,1.5,3213.5,1.5,24813,5,26085.5,37.5,3035,3189,7.5,353.5,645.5,18.5,7352,2630,12.5,3898.5,6070.5,9053,2.5,6.5,14937.5,0.011891822,2.5,3164.5,17.5,12751,53.5,27988,29279.5,31353.5,28591,17.5,32362,26.5,39.5,2743.5,7.5,3077.5,3172,5715.5,4001,99.5,-0.04684134,21.5,1299.5,3006,5834,5656.5,7595,7.5,2102.5,1.5,15.5,9308.5,4.5,4814.5,7469.5,3628.5,9728.5,10895.5,15.5,4.5,13142,14148.5,11710,22878,2849.5,18.5,17.5,0.014050925,20.5,0.0033894442,28894,18.5,25311,0.021085827,0.013353476,29647.5,3.5,0.00788926,2.5,18.5,29004.5,21902.5,24783,31922.5,1.5,22,65.5,64.5,1240.5,1459.5,4103.5,3504.5,4892,3235,3256.5,4875.5,3209,5556.5,5096.5,4435.5,84.5,28.5,117.5,884.5,602.5,755,620,3296,5732,5857.5,4962,84.5,5546.5,7399,22480,9849.5,8511.5,5.5,4.5,-0.019184409,4.5,-0.020318061,18.5,4639.5,-0.017703602,2.5,11.5,6226,7314,-0.014521007,6830.5,33,11126.5,9222,6254,7939,-0.026290445,6.5,10060,10307,10336.5,6684.5,6580.5,13771,1.5,29974.5,18340,0.0029091984,2713,2713.5,3214.5,0.0072896816,2950.5,0.014464552,3157,3062.5,0.005985525,25831,26290.5,4.5,-0.010292432,25493.5,26581,-0.017270157,2.5,31320.5,29741.5,0.0046697683,0.001678707,-0.003795584,-0.013477335,8.5,16,15.5,4.5,14169,24930,3.5,31425.5,28886,15.5,-0.007178572,-0.00016572369,0.005829084,-0.007316043,-0.009899066,-0.043643054,-1.0761748e-05,-0.007600126,-0.046497945,-0.027173435,-0.011363659,-0.020979505,0.00042579995,-0.0073000537,-0.014241624,-0.003066195,0.009102347,0.0021888244,0.018263994,0.0079282345,0.007583502,-0.003957532,-0.008747688,0.0008223437,-0.0012519477,0.0033290961,0.0004973046,-0.0066192113,-0.0049844743,-0.013393945,-0.024408396,-0.0038279127,-0.004053487,0.005361167,-0.030902883,-0.0029913548,0.0031767848,0.017974524,0.030534482,0.10424209,-0.023806455,-0.0027371475,0.055916745,0.0049490235,-0.01905462,-0.006457314,-0.000765709,-0.017987018,-0.009614023,-0.032170337,-0.0055133975,0.0044956924,-0.026485315,0.00933105,0.0020921505,-0.012893769,-0.008548508,-0.029983152,-0.0018021957,-0.01824221,-0.016263591,-0.012683948,-0.011934493,-0.016768225,-0.025283456,-0.0153426705,-0.006105106,-0.011242989,-0.01096627,-0.0151364375,-0.013166937,-0.019119997,-0.009611338,-0.005258105,-0.0042795762,0.0041399198,-0.005181066,-0.0002745649,-0.0019090159,0.005987234,-0.0022599604,0.0002390036,-0.009552038,-0.0039077173,0.012981856,-0.00047950787,-0.0061995178,-0.00095639424,-0.010402886,0.0029009653,-0.012582602,-0.031157598,0.007191492,0.0018801078,6.9040994e-05,-0.003556459,-0.00126096,0.002729122,-0.018657777,-0.005002323,0.00427841,-0.00754186,-0.009450137,-0.012537663,-0.01805914,-0.012036374,-0.00333063,0.0027306473,0.012615146,-0.023817832,-0.008882997,-0.022405058,-0.016311329,-0.0059022442,-0.0014677292,-0.0055170837,0.00904762,0.0037743137,0.007998897,0.0031257884,0.007304538,0.016857078,-0.0060639163,0.008520979,-0.0048846314,-0.0012579159,-0.0004493112,-0.0051041134,0.0016630233,-0.0008805096,0.005083927,0.0018305222,-0.021023942,-0.010973364,-0.008806133,-0.013188443,-0.0004474173,-0.010458124,0.0012481356,-0.0035802156,-0.004695702,-0.003042047,-0.00017810175,0.0010890472,-0.0009140167,-0.0019103925,-0.0005495312,-0.0017300461,-0.002292738,-0.0017585494,-0.008433058,-0.003342614,-0.0025258518,-0.0012622256,0.00066710537,-0.0035606846,-0.009643081,-0.0047652465,-0.0020478417,-0.003585693,-0.0024774687,-0.002158577}, {1,4,0,8,5,4,1,5,6,7,6,255,8,0,3,4,6,1,7,6,8,5,7,8,0,8,2,8,4,4,3,0,8,0,6,8,6,7,8,5,7,4,8,8,6,255,8,2,8,6,2,0,0,1,0,8,5,6,5,0,8,3,7,0,7,4,255,8,5,1,2,1,7,8,3,8,8,2,8,3,4,2,0,2,8,8,6,1,7,3,2,8,8,255,8,255,5,8,4,255,255,3,8,255,8,8,3,4,6,1,8,2,2,6,0,3,0,4,3,4,7,2,7,3,4,0,0,5,5,1,6,7,0,7,1,1,5,0,3,7,6,2,0,8,8,255,8,255,8,1,255,8,8,2,0,255,0,2,0,0,7,6,255,8,7,6,6,5,1,0,8,6,2,255,2,4,4,255,0,255,0,4,255,0,0,8,255,0,6,255,8,0,4,255,255,255,255,8,8,8,8,4,4,8,3,0,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,65535,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,65535,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,65535,181,65535,183,185,187,65535,65535,189,191,65535,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,259,261,263,265,267,269,271,273,65535,275,65535,277,279,65535,281,283,285,287,65535,289,291,293,295,297,299,65535,301,303,305,307,309,311,313,315,317,319,65535,321,323,325,65535,327,65535,329,331,65535,333,335,337,65535,339,341,65535,343,345,347,65535,65535,65535,65535,349,351,353,355,357,359,361,363,365,367,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,65535,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,65535,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,65535,182,65535,184,186,188,65535,65535,190,192,65535,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,264,266,268,270,272,274,65535,276,65535,278,280,65535,282,284,286,288,65535,290,292,294,296,298,300,65535,302,304,306,308,310,312,314,316,318,320,65535,322,324,326,65535,328,65535,330,332,65535,334,336,338,65535,340,342,65535,344,346,348,65535,65535,65535,65535,350,352,354,356,358,360,362,364,366,368,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({20560.5,5817.5,18988,15.5,3574,17597,9306.5,4957.5,3616,2005,9831,25463.5,20801,1218.5,31182,37.5,1.5,397.5,4928,6039.5,4406,7241,21683,-0.033277016,14274,27479.5,15.5,0.030926783,15.5,25935.5,24079,34.5,39.5,8102.5,5543,376.5,788,2876,4788,-0.03080692,3493,16,1778.5,11090,6869.5,11198,21623,20.5,15.5,0.025310589,0.012844061,29889.5,23150.5,2865.5,29546,23048,16779,18.5,12262,29.5,35.5,64.5,1312.5,6378.5,8244,8721,6739,79.5,961.5,18.5,1400,3227,18.5,3143,5616.5,3.5,5.5,7.5,5809.5,5.5,7757.5,7180,8166.5,9164.5,8798,30184.5,21764,25705.5,15.5,16.5,-0.000611609,4.5,-0.016121106,28942.5,4,24181.5,0.011275976,22592,2873,22243,19.5,24447.5,29171,29098,4.5,16345.5,21902.5,4,2.5,121.5,44.5,34,2.5,61,6.5,640.5,1898.5,6434.5,8955,7197,0.007960357,5721.5,1282.5,5872.5,7427.5,78,1964.5,490.5,-0.01585603,510,114.5,995,1803,4087.5,17,2329.5,5112,18,5456.5,7827,7055.5,8441.5,8441.5,-0.033339065,-0.017980114,2.5,12.5,19,0.00445802,7486,2873.5,7629.5,18.5,2991.5,7303.5,6.5,6.5,7352.5,-0.02303003,7963,10416,10289,12.5,17944.5,20832,1.5,0.012690312,25748.5,27709,3157.5,0.010594725,3.5,25989.5,0.0145140765,18653,0.0038820447,6,0.008788372,20295,5.5,3171,25460.5,2987.5,17.5,2638,3149,3126.5,1.5,1.5,2.5,0.022673575,30988,31296,1.5,18683.5,7,19811,21.5,23285.5,0.0040889173,-0.008966124,31922.5,28040,-0.0050624646,0.009819259,0.0048851967,-0.0035079916,0.0074623227,0.029715016,0.01421906,0.0025973204,-0.035342835,-0.0045977547,-0.048573148,-0.03342865,-0.003445164,0.0028109967,-0.018461285,-0.004405921,0.0095913345,-0.012955821,0.017265458,0.010262984,-0.013120902,-0.030272586,0.004109006,-0.026300086,-0.019572837,-0.008102696,-0.003449674,-0.013489775,0.0058776755,-0.0016821738,-0.0020768265,-0.021946702,0.00362661,0.016845785,-0.029337645,-0.052504826,0.014554125,0.0013043544,-0.018298617,0.031240651,0.00574924,-0.016866904,0.011314449,-8.301154e-05,-0.006807007,-0.019573083,-0.0005539741,-0.0035519227,-0.01226039,-0.0018059943,-0.009701769,-0.005377874,0.0058238986,0.044156533,0.0018719182,0.016951118,0.0037585993,-0.002549621,-0.013129668,-0.0014849909,-0.018154724,0.00041815892,-0.012427668,-0.018239303,-0.0021347948,0.0020417941,-0.0070349798,-0.004137037,0.0018799579,-0.0056452616,-0.019370891,-0.027409095,-0.013013288,-0.018592518,-0.009723361,0.0018151188,-0.011289277,-0.014772891,-0.013461105,-0.0059387847,-0.01011974,-0.022442067,0.009152456,0.0042630015,-0.0066410373,-0.0005057636,0.00059159007,0.0071474253,-0.0018682404,-0.009712922,-0.00080785324,-0.015024048,-0.0092253,-0.0044716983,-0.016284961,-0.023234898,-0.0018973459,-0.025957543,0.021065969,-0.007443691,0.004522369,0.023265144,-0.009701182,0.0062027625,-0.0025509761,0.012682344,0.00068269804,0.0058590504,0.0028180515,0.00028121923,-0.0069883927,-0.001372956,0.008637258,0.01188898,0.00075051555,-0.00019117596,0.0027509786,-0.0008879487,0.0018411687,0.004916705,0.008182249,0.015217285,0.002680022,0.008647113,0.001167694,0.004969355,0.008707917,0.0006065897,0.008098354,0.015903762,0.002955148,0.01403362,-0.0048412895,0.013716118,0.0021368812,-0.030184692,0.009812937,-0.011371979,-0.0016379852,-0.012962162,0.008650708,0.024477784,-0.00045487014,-0.008539568,0.0021212075,-0.0016635448,0.0034968664,-0.0046636327,0.0007132964,0.0049335486,-0.0015962139,-0.00054069445,-0.004519785,0.00039324723,-3.4657776e-05,-0.0026022312,0.0011078961,-0.0028047024,-0.0018215325,-0.002183654}, {1,6,3,8,7,6,0,5,0,3,4,1,6,4,1,4,8,1,1,2,2,7,3,255,0,1,8,255,8,0,0,4,5,2,0,0,6,1,0,255,5,8,7,1,6,5,6,8,8,255,255,1,7,6,1,1,7,8,6,6,0,6,0,5,3,4,1,1,0,8,4,7,8,6,7,8,8,8,0,8,6,1,2,0,7,4,0,4,8,8,255,8,255,0,8,4,255,7,4,1,8,7,2,2,8,0,4,8,8,2,6,0,8,6,8,7,1,4,4,1,255,6,6,3,1,0,5,2,255,0,3,2,0,0,8,6,6,8,3,0,2,0,0,255,255,8,8,8,255,0,1,6,8,3,4,8,8,7,255,3,0,3,8,1,2,8,255,2,3,0,255,8,0,255,7,255,8,255,5,8,4,1,2,8,0,0,6,8,8,8,255,0,0,8,5,8,0,8,2,255,255,1,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,47,49,51,65535,53,55,57,59,61,63,65,67,69,71,73,65535,75,77,79,81,83,85,87,89,91,65535,65535,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,65535,171,65535,173,175,177,65535,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,65535,225,227,229,231,233,235,237,65535,239,241,243,245,247,249,251,253,255,257,259,261,263,265,65535,65535,267,269,271,65535,273,275,277,279,281,283,285,287,289,65535,291,293,295,297,299,301,303,65535,305,307,309,65535,311,313,65535,315,65535,317,65535,319,321,323,325,327,329,331,333,335,337,339,341,65535,343,345,347,349,351,353,355,357,65535,65535,359,361,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,48,50,52,65535,54,56,58,60,62,64,66,68,70,72,74,65535,76,78,80,82,84,86,88,90,92,65535,65535,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,65535,172,65535,174,176,178,65535,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,65535,226,228,230,232,234,236,238,65535,240,242,244,246,248,250,252,254,256,258,260,262,264,266,65535,65535,268,270,272,65535,274,276,278,280,282,284,286,288,290,65535,292,294,296,298,300,302,304,65535,306,308,310,65535,312,314,65535,316,65535,318,65535,320,322,324,326,328,330,332,334,336,338,340,342,65535,344,346,348,350,352,354,356,358,65535,65535,360,362,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({20560.5,6023.5,18988,4687,4427,17597,3247.5,4308.5,4589,4548.5,9679.5,30103.5,20801,1218.5,30764,2116.5,3353.5,4758.5,5620.5,4475,12.5,7427.5,21614.5,23282,14936.5,27479.5,29529,4,8.5,25935.5,30349.5,1506,2428.5,3297.5,4783,2997,5720,7243.5,5278.5,8835.5,5.5,4347,5779,8184,7454.5,22313.5,21623,-0.025284613,-0.009152143,2.5,19,0.022170706,0.009866952,15.5,27336,0.007971591,0.028832123,24004,29433,22585,5.5,28827.5,31906.5,44.5,12.5,2199.5,3052,13.5,6.5,7918,4402.5,-0.026615217,17.5,5,3739,3131,5636.5,5564,7120.5,12.5,3956,4.5,13166,3898.5,9491.5,3387.5,4221,6309,6687,9013.5,7015,7927,23655.5,25705.5,19361.5,0.013321486,12.5,6,-0.0130666215,5.5,24181.5,15.5,5.5,6.5,25994.5,17475.5,2810.5,1.5,29171,27343,16779,16.5,4.5,29088.5,28845,71.5,1159.5,6.5,1298,2171,17.5,2998,7.5,4383.5,4628.5,3211,12.5,3376,4.5,0.019485852,0.0114126345,6.5,0.05122226,2,-0.015159072,17.5,18.5,-0.035662122,8670,5608.5,10320,-0.03849462,4786.5,7827.5,8070.5,3818,2021.5,18.5,4.5,2.5,-0.0077781216,-0.040804714,-0.021750458,3912.5,4847.5,1.5,8.5,-0.01257774,19.5,19.5,-0.012983379,5815.5,4452.5,8659.5,1.5,4.5,-0.019790806,15.5,8879.5,6.5,21973,21025.5,27402,2.5,0.010657819,15.5,17892,0.0035816121,0.009660569,0.0051589413,27038,29051,20629,0.010665542,29499,1.5,19497.5,29804,15.5,4.5,3203,2.5,2820.5,19.5,23117.5,18.5,18.5,21351.5,19371,22358,0.020759188,2.5,29098,26804,18683.5,29842.5,29798,29777,28482,25637.5,31198.5,17.5,29466.5,-0.0040048608,-0.0297016,-0.00070315925,0.009877372,-0.0050584166,-0.032650348,-0.0114366375,0.001416786,0.016602306,0.0048240605,0.010005284,0.030728403,-0.008985433,-0.026019922,0.0031263062,-0.002343737,-0.008638869,-0.020054162,-0.008470581,-0.017938564,-0.006197883,0.0004947728,-0.014022663,-0.008797352,0.0055967635,-0.0060962844,-0.0045792866,-0.019521153,0.0055339714,0.014525488,-0.0059243576,-7.3171614e-06,-0.00026444063,0.0030930245,0.0040940396,0.017531525,0.004971102,-0.009589523,-0.042170204,0.009264677,-0.0012503284,-0.015351136,-0.027999712,0.0011185624,-0.011689476,-0.04079687,0.0020337314,-0.00875805,-0.011657703,-0.007937504,-0.012118242,-0.006742424,-0.010706362,-0.015435323,-0.009010609,-0.022011006,-0.0030269702,0.0010552935,-0.014234172,-0.00819596,-0.00807371,-0.0023379726,-0.010670195,-0.0144807445,-0.004814098,-0.00040254073,0.0012475265,-0.0027065782,-0.0034030247,-0.0075210854,-0.0050774743,-0.019826356,-0.008763167,-0.0033888817,-0.016833214,0.00343126,0.00047668014,-0.03586602,0.030640474,0.012651927,0.004268262,0.009336319,-0.006283566,-0.000882653,-0.0060908245,-0.0094543835,-0.0031599738,-0.007087751,0.00450251,-0.019873338,0.028676627,0.010274847,0.007194955,0.02243693,0.0064710365,-0.0005099601,0.0049419813,-0.0048085013,0.0011776336,-0.0034616669,0.015233916,0.009572336,0.005418149,0.011673602,0.0028880113,0.0068415604,0.0021636363,0.010588988,0.00038894947,0.0033369155,0.007165035,0.0021118817,0.0012918022,-0.000734554,0.0018955173,-0.0035743525,0.0017782182,0.005263097,-0.002217231,0.0026701353,0.00704477,0.004648348,0.0025509717,0.0065031173,0.016871316,0.010221022,0.0051819636,0.0129089225,0.0060858754,0.00047917562,-7.679877e-05,0.0078116613,-0.008880363,-0.026157549,-0.005718642,-0.012890625,-0.0010379422,-0.009380105,0.0067213806,-0.0005933983,0.023242798,0.002745604,0.0024479628,-0.004315827,0.0028323599,0.0012643904,-0.0014807292,0.0014935503,0.00082858803,0.002703755,-0.0056160786,-0.0013298646,-0.0008869629,-0.010434553,-0.0011177516,-0.0036546632,-0.0014407424,-0.0023037626,-0.0040495,-0.0019248056}, {1,4,3,3,5,6,0,2,2,7,6,1,6,4,1,1,3,5,1,7,8,5,3,0,0,1,0,8,8,0,3,0,0,5,5,4,7,6,7,6,8,5,3,7,5,7,6,255,255,8,8,255,255,8,2,255,255,1,1,1,8,5,3,1,8,0,1,8,8,2,2,255,8,8,1,6,2,0,3,8,5,8,0,5,0,5,5,4,1,0,4,7,6,4,1,255,8,8,255,8,4,8,8,8,3,5,4,8,2,0,7,8,8,0,6,0,1,8,5,1,8,1,8,2,4,3,8,6,8,255,255,8,255,8,255,8,8,255,2,0,0,255,2,1,2,7,7,8,8,8,255,255,255,3,7,8,8,255,8,8,255,6,3,7,8,8,255,8,5,8,6,6,6,8,255,8,5,255,255,255,0,0,1,255,4,8,7,0,8,8,2,8,4,8,1,8,8,7,0,0,255,8,2,2,5,4,0,0,0,0,3,8,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,65535,65535,95,97,65535,65535,99,101,65535,65535,103,105,107,109,111,113,115,117,119,121,123,125,127,129,65535,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,65535,177,179,65535,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,65535,65535,241,65535,243,65535,245,247,65535,249,251,253,65535,255,257,259,261,263,265,267,269,65535,65535,65535,271,273,275,277,65535,279,281,65535,283,285,287,289,291,65535,293,295,297,299,301,303,305,65535,307,309,65535,65535,65535,311,313,315,65535,317,319,321,323,325,327,329,331,333,335,337,339,341,343,345,347,65535,349,351,353,355,357,359,361,363,365,367,369,371,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,65535,65535,96,98,65535,65535,100,102,65535,65535,104,106,108,110,112,114,116,118,120,122,124,126,128,130,65535,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,65535,178,180,65535,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,65535,65535,242,65535,244,65535,246,248,65535,250,252,254,65535,256,258,260,262,264,266,268,270,65535,65535,65535,272,274,276,278,65535,280,282,65535,284,286,288,290,292,65535,294,296,298,300,302,304,306,65535,308,310,65535,65535,65535,312,314,316,65535,318,320,322,324,326,328,330,332,334,336,338,340,342,344,346,348,65535,350,352,354,356,358,360,362,364,366,368,370,372,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({20021,6163.5,18801.5,4502,4124.5,32010,32327,4408,29386,8557,29383,67,14.5,27528,10286.5,1939,3067,4936.5,2,2630,9532.5,7590.5,15235,31520,20508.5,1.5,-0.01020667,24004,29610,3135.5,29614.5,1557,2416.5,16.5,5350.5,2914.5,5712,-0.003611495,31979,4.5,2710.5,12.5,12.5,10872,7754.5,12.5,14.5,-0.023338875,4.5,22930.5,20602.5,-0.004086525,-0.0076058866,1.5,11924,27111.5,5.5,3109.5,15.5,30031.5,30224,44.5,18.5,1583.5,897,2579,3135.5,3256,5965,18.5,3941,7717.5,7726.5,-0.034421064,-0.02174647,2718.5,7808.5,14,2951.5,3.5,3473,2671,15.5,7545.5,7737,8065,7406,12738,13503,3.5,18879.5,0.0033951856,-0.0075304657,0.022623362,15.5,25443,22447.5,20101,22242,2849,2.5,15.5,2.5,1.5,31440,18.5,17.5,3218.5,0.0125905005,29951.5,30985,30203,30063.5,39.5,20.5,4.5,912.5,18.5,1978.5,328.5,6.5,569.5,2026,521.5,2070,7.5,2.5,4803.5,7993.5,5363,5584,-0.025819395,6486.5,6900.5,5835,7289.5,7801,7846.5,1382,3486,15.5,5.5,8824.5,6868.5,12.5,3632.5,8683.5,7442,-0.02938496,10588,13628.5,14704.5,18.5,13410.5,7293.5,16306,12068,7238,1.5,7843,8929.5,31856,-0.020554928,31781,-0.030153865,19763,24232,17199.5,29971,1.5,0.0056399195,-0.021488003,16,27569.5,22313.5,20905.5,23013,19134.5,19660,14.5,2.5,1.5,25807,27920,24876.5,-0.0014956217,-0.00696581,22570.5,31440,29827.5,11.5,3083,2866.5,12.5,-0.009599882,0.008899764,6.5,29866,4.5,27157,16.5,29873,-0.005107818,29873.5,5.5,-6.300116e-05,-0.011631456,-0.00068437046,0.0104313,-0.0030582743,-0.020270174,-0.027057773,0.003917451,0.013050439,0.06144302,0.024066618,0.0068562008,0.0011675748,0.012553485,0.0029402287,-0.004754666,-0.01920424,-0.037500504,-0.013287753,-0.017505782,-0.005662837,-0.014665737,0.0015863288,-0.0019117942,0.012868556,0.0012922409,-0.0111401,-0.0042078323,-0.00735248,-0.014493431,-0.0049789967,-0.013811464,-0.010760727,0.009449196,0.027898991,0.050828453,0.0005074534,0.0062786452,-6.055659e-05,0.0056480514,-0.006206798,-0.00067898113,-0.008294321,-0.024166565,0.013790903,-0.0028678833,-0.015825503,-0.011461767,-0.0038807895,-0.025633544,-0.010099548,-0.0157181,-0.009527242,-0.0053589246,0.01764874,0.006017184,-0.0021161388,-0.014171693,-0.0035997243,-0.013058565,-0.0074268053,-0.0030770889,-0.014594309,-0.00346095,-0.009128219,-0.017505905,-0.0046064225,-0.016022537,-0.009258785,-0.013642438,-0.0049954895,-0.0105099445,-0.012963484,-0.016587866,-0.008362274,-0.013170837,-0.005654748,-0.011261357,-0.019917568,-0.0076706433,0.005017125,-0.0004967556,-0.025024284,-0.006451434,-0.0016162045,0.01580221,-0.006457425,-0.039801124,-0.012827128,0.0042905384,-0.008814961,-0.0024342448,-0.010801738,-0.016273849,-0.017152023,-0.023022266,-0.0025761577,0.0023994276,0.014312907,-0.0054636225,-0.011371913,-0.008971128,0.014518961,-0.006952237,0.005275679,0.015107624,0.0065787635,-0.0018110573,0.019431107,0.0057253055,0.010423014,0.00088595273,0.016806882,0.0049709254,0.0030523203,-0.0019230573,-0.0052126814,-0.025240684,-0.00030659506,-0.013224969,0.005537694,0.012200805,-0.0024059035,0.0035670155,0.001823801,-0.0028175672,-0.0041186954,-0.00959909,0.0017630141,0.009765795,-0.00027067563,0.010799013,0.006299007,0.001291932,0.0010783443,-0.0013196863,-0.0021771726,0.0017463425,-0.003243019,-0.0046109594,0.0010018357,0.006227038,0.0051212325,0.013686024,-0.0011805393,0.0069579543,8.689527e-05,0.0049056024,-0.0015811889,-0.0044955146,-0.0006351228,-0.00092072703,-0.002005087,-0.0047582085,-0.00025578562,-4.9946157e-05,-0.0017801262,-0.0024132144,-0.0032936041,-0.0017409645,-0.0017126659,-0.0012128757}, {3,6,5,1,7,0,3,0,0,6,2,4,8,4,0,1,3,0,8,7,0,7,3,3,3,8,255,1,4,4,6,0,0,8,4,6,7,255,0,8,7,8,8,1,7,8,8,255,8,4,3,255,255,8,0,1,8,4,8,0,0,1,8,0,6,4,7,4,0,8,7,0,3,255,255,1,6,8,3,8,5,5,8,1,3,5,6,3,3,8,5,255,255,255,8,0,6,0,3,4,8,8,8,8,4,8,8,2,255,4,0,0,4,0,8,8,1,8,1,6,8,5,3,5,3,8,8,0,0,1,1,255,5,1,5,3,0,0,5,5,8,8,0,6,8,5,0,4,255,2,4,0,8,6,6,1,0,1,8,7,7,0,255,4,255,1,6,5,4,8,255,255,8,3,3,2,1,2,1,8,8,8,5,4,5,255,255,7,4,4,8,0,2,8,255,255,8,4,8,2,8,4,255,6,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,65535,53,55,57,59,61,63,65,67,69,71,65535,73,75,77,79,81,83,85,87,89,65535,91,93,95,65535,65535,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,65535,65535,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,65535,65535,65535,169,171,173,175,177,179,181,183,185,187,189,191,193,195,65535,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,65535,241,243,245,247,249,251,253,255,257,259,261,263,265,267,269,271,65535,273,275,277,279,281,283,285,287,289,291,293,295,297,65535,299,65535,301,303,305,307,309,65535,65535,311,313,315,317,319,321,323,325,327,329,331,333,335,65535,65535,337,339,341,343,345,347,349,65535,65535,351,353,355,357,359,361,65535,363,365,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,65535,54,56,58,60,62,64,66,68,70,72,65535,74,76,78,80,82,84,86,88,90,65535,92,94,96,65535,65535,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,65535,65535,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,65535,65535,65535,170,172,174,176,178,180,182,184,186,188,190,192,194,196,65535,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,65535,242,244,246,248,250,252,254,256,258,260,262,264,266,268,270,272,65535,274,276,278,280,282,284,286,288,290,292,294,296,298,65535,300,65535,302,304,306,308,310,65535,65535,312,314,316,318,320,322,324,326,328,330,332,334,336,65535,65535,338,340,342,344,346,348,350,65535,65535,352,354,356,358,360,362,65535,364,366,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({19768.5,6162.5,9306.5,45.5,4659.5,1218.5,23456,27,50.5,1081,29665.5,0.020564774,15.5,24004,23738,38,21.5,64.5,670,7932.5,4552.5,9998,13082.5,30190,3142.5,1.5,21057.5,29209,32477,29.5,54.5,18.5,368,72,22.5,48.5,702,12,1780.5,4381.5,5468,9051.5,13078,12.5,24317,22592,2610.5,28893.5,2979.5,20873,22612,17.5,30205.5,21753,24677,23424.5,2.5,22,57,61.5,29.5,368,320.5,34,0.06474489,92.5,1326,-0.05430126,107.5,29.5,50.5,464,1010.5,0.01294282,18.5,437,17.5,4341.5,9038,7021.5,6780.5,6179,9984,13211.5,18993,31856,14468,0.026289633,12.5,2.5,3174,3050,2713.5,16.5,18.5,20.5,3081,21083,21374.5,21367,24310,15921.5,19.5,1.5,17.5,20306.5,16,6.5,14.5,15.5,30725,21834.5,8.5,22,17.5,34.5,-0.054695096,58.5,25,15.5,18.5,9.5,2.5,35.5,0.035560902,-0.002916012,38,6.5,-0.038635787,7.5,17,6.5,11.5,15.5,78,6.5,536.5,18.5,668.5,994.5,1432,0.0058379616,106.5,5,12,2.5,-0.0040053576,8469,8162.5,4.5,6.5,16.5,13316.5,1.5,7645,7188,6302,8298.5,11365,11241.5,9255.5,12492,21953.5,6.5,11387.5,15.5,-0.01192665,2.5,18424,-0.0014401897,0.0037329346,2971.5,0.01113589,4.5,4.5,7,2994,2895.5,3165,2731.5,3157,0.0060042217,0.0013876349,0.014919929,0.0071629225,0.012576117,0.0036157153,21725.5,22900,19827.5,-0.018178932,23168.5,25617,5,16907,19670.5,28545,0.0071279197,25356.5,3.5,20042.5,0.02266687,27988,2,20925.5,-0.0020535416,15.5,25989.5,-0.009741678,23310.5,21042,29140,30399.5,1.5,1.5,18779,30378,-0.0047901273,0.0007924147,-0.0010473343,0.005445018,0.011479421,0.029256647,-0.050899297,-0.027841989,-0.0059057516,-0.020565256,0.00058568304,0.00630788,-0.024167145,-0.060322016,0.0075059757,0.0017318971,-0.012403988,-0.00084406976,0.0038088118,-0.007885056,-0.001547753,0.0032457416,0.0011065062,-0.0028505612,-0.03882501,-0.023722792,-0.0025604006,-0.0066020587,-0.039421227,-0.02654898,-0.023258477,-0.012459908,0.0025507498,0.013713175,-0.039024018,-0.014228992,0.033546288,0.0138721345,0.0016967062,0.009401995,-0.0831376,-0.036839083,-0.030679082,-0.0152820125,0.00046894778,0.018345214,-0.009885634,-0.001993271,0.004403841,-0.005322227,0.0032814816,-0.000716368,-0.010282188,0.0010744637,0.0035571118,0.013531454,-0.008007242,-0.009938526,0.0017240793,0.006094,-0.00053226034,-0.01040912,-0.00592948,-0.034622233,0.0039604935,0.01195903,-0.004803959,-0.012430626,-0.0010287424,-0.024122661,0.00036544292,-0.009653385,-0.0031832606,0.0020709825,0.0046573104,-0.0053371224,-0.0060302173,-0.010134234,-0.055506356,-0.029444158,-0.0013591199,0.0013158459,0.006537871,-0.006145797,0.0029443756,-0.017024651,0.017029213,-0.0041747326,-0.0065065706,-0.012993415,-0.015880281,-0.013338181,-0.016858364,-0.020999953,-0.001739052,-0.0050602066,-0.009187079,-0.0067532607,0.007526894,0.0047755246,-0.0008816667,0.0014468889,0.0042022257,0.0015095904,0.0007295261,0.0035965052,0.0057564387,0.0032353536,0.0066842847,0.0009620778,0.01360665,0.007071027,-0.002944599,0.009758569,-0.0061928523,0.0049065067,0.0042643445,0.0011126476,-0.0003525974,-0.00198,-0.029803386,-0.02391719,-0.017913068,-0.010162756,-0.0042218408,-0.009745928,-0.0028737977,0.005176706,-0.0020717292,-0.00042102239,-0.0013145664,-0.003820245,0.0012727857,-0.0020127795,-0.009775357,-0.0030723787,-0.0010269827,-0.0034453638,0.0006332026,-0.00067487353,0.017476963,0.01179311,0.0036012724,0.009392832,0.008817806,0.0009068697,-0.00026475018,0.00029516223,-0.005424942,-0.00016190855,0.015518564,0.007604336,0.015445344,0.0011302422,-0.0073654726,-0.00093707925,0.00023603758,-0.0015955566,0.005928291,0.0012970997,0.00075722544,-0.0014605133,-0.004692598,-0.0018597947,-0.0040108613,-0.0016591589}, {1,4,0,6,1,4,0,7,7,3,0,255,8,1,2,0,8,6,6,4,3,5,7,7,4,8,4,1,0,6,3,8,0,2,1,1,7,8,0,3,7,4,3,8,2,7,2,3,2,0,7,8,7,6,0,3,8,0,4,4,6,0,0,6,255,0,0,255,2,0,2,1,6,255,8,0,8,3,6,2,6,7,5,7,4,0,1,255,8,8,4,0,4,8,8,8,0,2,2,3,7,0,8,8,8,4,8,8,8,8,1,1,8,2,8,0,255,0,1,8,8,8,8,4,255,255,2,8,255,8,8,8,8,8,2,8,5,8,1,7,7,255,0,8,8,8,255,2,0,8,8,8,2,8,6,4,5,5,0,7,4,2,2,8,1,8,255,8,5,255,255,4,255,8,8,8,4,4,0,2,0,255,255,255,255,255,255,0,2,2,255,3,7,8,0,0,1,255,1,8,0,255,0,8,2,255,8,0,255,4,6,2,3,8,8,7,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,65535,127,129,65535,131,133,135,137,139,65535,141,143,145,147,149,151,153,155,157,159,161,163,165,65535,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,65535,223,225,227,229,231,233,235,65535,65535,237,239,65535,241,243,245,247,249,251,253,255,257,259,261,263,65535,265,267,269,271,65535,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,65535,311,313,65535,65535,315,65535,317,319,321,323,325,327,329,331,65535,65535,65535,65535,65535,65535,333,335,337,65535,339,341,343,345,347,349,65535,351,353,355,65535,357,359,361,65535,363,365,65535,367,369,371,373,375,377,379,381,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,65535,128,130,65535,132,134,136,138,140,65535,142,144,146,148,150,152,154,156,158,160,162,164,166,65535,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,65535,224,226,228,230,232,234,236,65535,65535,238,240,65535,242,244,246,248,250,252,254,256,258,260,262,264,65535,266,268,270,272,65535,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,65535,312,314,65535,65535,316,65535,318,320,322,324,326,328,330,332,65535,65535,65535,65535,65535,65535,334,336,338,65535,340,342,344,346,348,350,65535,352,354,356,65535,358,360,362,65535,364,366,65535,368,370,372,374,376,378,380,382,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({20027.5,6162.5,17892,6357,4659.5,24142,16857.5,7631,6802.5,2003.5,9679.5,23401,27645,2868.5,20870,5888.5,9995,2610,8557,7514,5013.5,9257,21953,22807,13095.5,25098,28642,7.5,11.5,24364,16388.5,4941,4409,391.5,9951.5,5044.5,6393.5,6076,8776.5,3.5,1446.5,3022,8885,9816.5,8635,21226.5,21333.5,0.028446982,18,18.5,0.014987752,26343,25969,18666.5,21278,3135.5,2986.5,3197,3124,1.5,27030,17399.5,31182,3353.5,5601,5936,5949.5,13,6738.5,8608,7587.5,17.5,14.5,2.5,7363.5,6417,6116.5,17.5,6456.5,2031,6150.5,2059,18.5,8,6.5,15.5,9353,8168.5,7300,8599.5,10113.5,15.5,29840.5,27402,21451.5,0.015477665,0.005276622,13,0.008172372,11.5,18,17.5,4,15.5,0.015235166,15.5,15.5,3000.5,0.0081387935,3135.5,0.01142128,2.5,3196,18.5,15.5,17685,19817.5,1.5,2.5,-0.01920726,15.5,26097,24785,1933.5,1165,5691,5692,-0.026090404,6057,5750,5813,4.5,17,4926.5,8987,5.5,1.5,14.5,30534.5,4359,4359,8.5,-0.012386085,-0.0021872427,-0.014830552,11.5,15.5,7,-0.030140609,3.5,16.5,5986,5851.5,4,16.5,7192,-0.016568858,16.5,7060.5,4.5,-0.021797264,16.5,2959.5,3.5,14.5,3056.5,15.5,2639,18.5,8604,8405.5,7531.5,7786.5,5758.5,8813.5,7894,15.5,6971.5,10895.5,9698,10951,19372.5,15.5,0.024055934,29281,15.5,16.5,6.5,-0.0039069573,27214,15.5,-0.005181917,0.00025998778,2.5,24629,0.0010026088,-0.004134975,0.009446519,27097.5,10.5,-0.0058926377,2.5,22280.5,4.5,2583.5,18.5,16,1.5,4.5,0.0062482576,2.5,3149,31203,0.004881175,0.009887186,0.017747909,20879.5,16440,21168.5,0.014560796,22477.5,28898.5,18275,28188.5,21761.5,26665.5,3.5,18.5,5.5,-0.0024749322,0.0026020557,-0.020809194,-0.0035134205,0.002294772,0.013448571,0.0009237298,-0.009760204,0.00054385024,0.011985068,-0.025388112,-0.006129712,-0.034506906,-0.01393804,0.007152572,0.004636266,-0.0023303854,0.007969224,-0.01367669,-0.005819138,-0.023912877,-0.004665782,-0.0038812533,0.0063287704,0.01215399,-0.006180273,-0.009619432,-0.018375156,-0.0008689047,-0.014879136,0.024566883,0.010362375,0.009034174,0.04305108,0.006345719,0.001986658,0.0038076595,-0.00020593175,0.0046287016,0.010580489,-0.0009293488,-0.0026522318,0.00047122507,-0.007508587,0.0006006214,0.008259614,-0.0002940177,-0.010275598,-0.0012106502,-0.015600455,0.007853102,0.004904517,0.00019827478,0.0039735376,-0.011804521,-0.0018787863,-0.015514145,-0.008972461,-0.007296131,-0.00932195,-0.0060361284,-0.015518958,-0.010779422,-0.0057551037,-0.017427867,-0.006200401,0.006351746,0.015341182,0.004124312,0.010867132,-0.00753475,0.0060804943,-0.0063571273,-0.0004297359,-0.008907177,-0.0059623616,-0.00056755746,-0.0061910963,-0.003284882,-0.017930668,-0.0012747647,-0.008391186,-0.0037132222,0.0033219985,0.003027483,-0.017755324,-0.006881814,0.0053189797,-0.02401053,-0.008488617,0.0022350333,0.011417769,7.60779e-05,0.005244477,0.0017891446,-0.031310193,-2.3856092e-05,-0.0104601635,-0.03309585,-0.004194598,-0.0021975804,-0.0076700347,0.009242049,-0.02207443,0.0012047658,-0.0036580097,0.013127187,0.006477942,0.006165504,-0.00076210726,-0.0018768877,-0.005544734,-0.0019733373,0.0034210521,0.0021265799,0.0070698396,-0.0013335682,0.0021902428,-0.0030981218,-0.0101643605,-0.006923078,-0.0022016985,0.0035959915,0.0017700673,-0.0025179435,0.003334662,0.0018076824,0.0075702737,0.0054164785,-0.0009853747,0.005464033,0.0015523074,-0.0017279185,0.0003440075,0.0071459487,-0.008729224,0.006989341,0.014136468,0.0029177018,-0.0044272705,0.0035278883,0.0009018575,-0.0025228995,0.0040016766,0.0016705102,0.009988183,0.0075538456,-0.008461244,0.0013338692,0.0049369126,-0.007328248,-0.013818823,-0.02596109,-0.0142034395,-0.010768038,-0.0064822556,0.0040828697,-0.0010805076,-0.0004653644,-0.0019096736,0.017592637,0.010013103,0.004197586,0.010416808,-0.014283203,-0.006660092,0.00075061433,-0.002786785,-0.00061475136,-0.0016442066,-0.0016992841,-0.0013404439}, {5,0,7,1,1,2,4,4,2,5,6,5,2,0,2,1,4,6,3,0,4,5,7,2,0,2,0,8,8,7,1,5,4,0,2,2,1,0,6,8,3,6,6,2,4,3,3,255,8,8,255,4,0,1,5,4,6,6,6,8,5,0,1,4,3,1,3,8,3,7,7,8,8,8,3,1,0,8,1,3,4,1,8,8,8,8,6,7,4,2,5,8,2,6,1,255,255,8,255,8,8,8,8,8,255,8,8,2,255,4,255,8,0,8,8,0,4,8,8,255,8,0,0,1,1,2,1,255,0,5,0,8,8,6,2,8,8,8,2,0,0,8,255,255,255,8,8,8,255,8,8,0,0,8,8,4,255,8,6,8,255,8,7,8,8,5,8,3,8,2,4,6,6,5,0,2,8,3,2,6,4,5,8,255,0,8,8,8,255,0,8,255,255,8,0,255,255,255,0,8,255,8,1,8,0,8,8,8,8,255,8,0,1,255,255,255,3,0,3,255,3,1,0,2,5,7,8,8,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,65535,95,97,65535,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,65535,65535,187,65535,189,191,193,195,197,65535,199,201,203,65535,205,65535,207,209,211,213,215,217,219,221,65535,223,225,227,229,231,233,235,65535,237,239,241,243,245,247,249,251,253,255,257,259,261,263,65535,65535,65535,265,267,269,65535,271,273,275,277,279,281,283,65535,285,287,289,65535,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,323,325,327,329,331,333,65535,335,337,339,341,65535,343,345,65535,65535,347,349,65535,65535,65535,351,353,65535,355,357,359,361,363,365,367,369,65535,371,373,375,65535,65535,65535,377,379,381,65535,383,385,387,389,391,393,395,397,399,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,65535,96,98,65535,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,65535,65535,188,65535,190,192,194,196,198,65535,200,202,204,65535,206,65535,208,210,212,214,216,218,220,222,65535,224,226,228,230,232,234,236,65535,238,240,242,244,246,248,250,252,254,256,258,260,262,264,65535,65535,65535,266,268,270,65535,272,274,276,278,280,282,284,65535,286,288,290,65535,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,326,328,330,332,334,65535,336,338,340,342,65535,344,346,65535,65535,348,350,65535,65535,65535,352,354,65535,356,358,360,362,364,366,368,370,65535,372,374,376,65535,65535,65535,378,380,382,65535,384,386,388,390,392,394,396,398,400,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6900.5,5715.5,6505.5,4945,2586.5,6740.5,31166,4408,5626.5,6153,9415,17.5,7206.5,9095,16313,1499.5,2821,8795.5,6697,14.5,4.5,8478,9531,15.5,7177,7393.5,8703,11782,8000.5,15.5,2.5,1401,2212.5,1646.5,3703.5,5068.5,8832.5,5831.5,6650,7864,322.5,9756,10348,6160.5,13375.5,6555.5,18843.5,6170,0.014803441,0.0015910903,18.5,16.5,8181.5,-0.012050719,7712.5,11693,9038,4.5,10500.5,32151,17631,1.5,18695,44.5,12.5,18.5,2266.5,-0.032288115,6967.5,3188.5,7.5,3371,5548.5,1.5,1.5,5698.5,5909.5,6042.5,9534,4.5,-0.021324113,15.5,2924,3490.5,9868,18.5,2721,7371,6801,10286.5,12.5,0.006306436,1.5,6.5,2.5,5849,5140,0.024167499,0.042357057,4.5,6048.5,0.014115221,15.5,3.5,15.5,5383,10930,14.5,-0.030140841,7138,5702,7344,13129,457,2.5,457,-0.010089304,18571,19125,16650,19122.5,71.5,11496,4.5,1223.5,8428,1689,15.5,2769,12.5,15.5,12.5,7.5,5399.5,11.5,4130,4842.5,8000.5,9295,-0.02553004,-0.009732234,0.008679899,10514.5,1.5,5470.5,5555,5885.5,5551,3.5,6771.5,5885,6409.5,-0.016109504,-0.0041332752,19,5465.5,16,2527,4660.5,9834.5,2.5,16.5,5342,-0.012716859,-0.00821844,6821,5909,1.5,8017,7422,11398,11039,11276.5,-0.0056557627,0.01942699,10345,20119,-0.0057648155,-0.017047366,12.5,0.009911901,6,1.5,1.5,11.5,5593.5,19,7720.5,26733,1.5,15.5,4.5,0.0052809487,4716,7278,0.032401312,13.5,19691,19691,2.5,9199.5,16,7653.5,7189,10095,13090,18340,0.0037169405,31241.5,-0.010133128,-0.014311681,18,18149,31733.5,21669,17917.5,22505.5,15706.5,20448,16.5,11.5,-0.0022854446,-0.023342956,0.00057331886,-0.017000847,-0.0042819297,-0.02312627,-0.030067472,-0.001807921,0.006000368,-0.0036994684,0.030007765,0.0060577635,-0.00955462,0.0026371335,0.0051544565,-0.0011626611,-0.017320672,-0.011531302,-0.0069734785,0.0006024948,-0.013354673,-0.0023248226,0.0066388897,0.00018121091,-0.0011351672,-0.008372572,-0.012603931,-0.006316495,0.00025168454,0.012160921,-0.030357871,0.0006056568,0.0050340877,-0.03773885,0.011980848,-0.0010804023,0.0017532371,-0.0019504082,-0.005583181,-0.03417868,-0.0062536444,-0.020935487,0.00494434,0.011698141,-0.002292131,-0.014138363,0.0024413634,-0.0078040757,0.011684284,0.0058371453,-0.01017546,-0.029761111,-0.0017002845,0.0031979016,-0.012898979,-0.003072009,0.0053821206,-0.00012741108,-0.007598435,-0.016011594,-0.001451247,0.0010957689,-0.009764068,-0.016557975,-0.027524633,-0.0019514187,-0.0027820512,0.009538247,-0.0072444165,-0.0032645077,-0.0069103385,-0.0008434222,0.003073111,-0.008803042,-0.0035280727,-0.025662193,-0.0067158067,0.016041728,0.011463985,-0.0154859815,-0.001862035,0.046028145,-0.006753047,-0.016369306,-0.00021136976,-0.005209595,0.0032333767,-0.007090056,-0.020634025,-0.010715858,0.009778995,0.0017650446,-0.0013364892,0.013277868,0.0058897263,0.002258823,0.0024594055,0.0062458706,0.0062035266,0.00275188,0.0028220685,0.009289128,0.0039497777,0.0018640358,-0.012617177,-0.006485889,0.017834624,0.005611993,-0.0020560625,0.0036073772,0.010809419,0.0057598664,0.0042393836,0.0014322207,-0.0020980558,0.0011211953,0.0050560795,0.00056004286,-0.0007432738,0.008735739,-0.009630414,-0.000972887,0.016983487,-0.0020616394,-0.0056394055,0.010652169,-0.011483821,0.0036766422,0.0059494977,0.0028643168,0.019377373,0.013032049,-0.0029416915,0.0016402586,0.0017166559,0.006186342,0.00048490937,0.025667815,-0.015591978,-0.0032273566,-0.00088347413,0.0020059252,-0.011339394,-0.0013667647,-0.026936596,-0.009118189,0.0032634032,0.0011423602,-0.01837827,-0.0269653,-0.0010753811,0.00045406894,0.0039898437,0.00046402027,-0.005223453,-0.002498365,0.0016449913,-0.0013234003,-0.009281895,-0.018098047,-0.0052544596,-0.017283006,-0.003974788,-0.0058735125,-0.0016456988,-0.0031776286}, {1,0,0,1,3,3,0,0,5,4,3,8,2,1,3,1,5,2,5,8,8,2,3,8,1,3,3,2,0,8,8,0,0,3,2,4,2,1,2,0,4,6,2,1,6,1,7,0,255,255,8,8,5,255,1,2,1,8,1,2,5,8,1,1,8,8,1,255,2,1,8,4,2,8,8,3,1,3,4,8,255,8,5,7,2,8,1,7,0,0,8,255,8,8,8,0,2,255,255,8,0,255,8,8,8,7,0,8,255,2,4,2,3,4,8,4,255,7,7,5,3,0,6,8,2,2,2,8,2,8,8,8,8,4,8,3,7,6,6,255,255,255,3,8,0,0,6,0,8,6,1,2,255,255,8,6,8,1,1,0,8,8,2,255,255,3,0,8,3,7,2,0,4,255,255,2,5,255,255,8,255,8,8,8,8,0,8,3,1,8,8,8,255,7,2,255,8,7,7,8,1,8,0,2,3,2,2,255,0,255,255,8,1,2,1,5,1,5,5,8,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,65535,65535,97,99,101,65535,103,105,107,109,111,113,115,117,119,121,123,125,127,65535,129,131,133,135,137,139,141,143,145,147,149,151,65535,153,155,157,159,161,163,165,167,169,171,65535,173,175,177,179,181,65535,65535,183,185,65535,187,189,191,193,195,197,65535,199,201,203,205,207,209,211,65535,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,65535,65535,65535,257,259,261,263,265,267,269,271,273,275,65535,65535,277,279,281,283,285,287,289,291,293,65535,65535,295,297,299,301,303,305,307,309,65535,65535,311,313,65535,65535,315,65535,317,319,321,323,325,327,329,331,333,335,337,65535,339,341,65535,343,345,347,349,351,353,355,357,359,361,363,65535,365,65535,65535,367,369,371,373,375,377,379,381,383,385,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,65535,65535,98,100,102,65535,104,106,108,110,112,114,116,118,120,122,124,126,128,65535,130,132,134,136,138,140,142,144,146,148,150,152,65535,154,156,158,160,162,164,166,168,170,172,65535,174,176,178,180,182,65535,65535,184,186,65535,188,190,192,194,196,198,65535,200,202,204,206,208,210,212,65535,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,65535,65535,65535,258,260,262,264,266,268,270,272,274,276,65535,65535,278,280,282,284,286,288,290,292,294,65535,65535,296,298,300,302,304,306,308,310,65535,65535,312,314,65535,65535,316,65535,318,320,322,324,326,328,330,332,334,336,338,65535,340,342,65535,344,346,348,350,352,354,356,358,360,362,364,65535,366,65535,65535,368,370,372,374,376,378,380,382,384,386,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({19404,4339.5,18533.5,1915,3600,31386.5,16594.5,1640,1962,5783.5,27517,22313.5,19040,23117.5,20870,1172.5,1153,16.5,2416.5,3208.5,1738.5,19574.5,14456.5,16991.5,22849.5,8.5,4,2605.5,11.5,24395.5,30725,637,1394.5,956.5,14.5,0.021012476,0.06516134,1583.5,3052,14.5,5293,7496,2845.5,17168.5,20430,22905,29334,14802,26854,16.5,16.5,18109.5,15.5,0.0061682076,11.5,19,19.5,1.5,3108,24130.5,27030,27920,25974,566.5,472,20.5,3185.5,602,4.5,6.5,2499,18,2379,15.5,3246.5,2375,2935,7.5,5599,8788.5,4.5,8,1955,16793.5,19551,22807,27031,14062,26908,17407.5,4.5,8222.5,1.5,20199,27501.5,2.5,27846,28403,26353,4,4,17652,17652,0.0012142531,17.5,2304,0.012165249,2,2705,3006,2.5,18.5,3168.5,1.5,0.025897963,1.5,20656,22539.5,29267,18.5,30546,44.5,18.5,368,762.5,686,943.5,2002.5,-0.034871455,-0.026412958,-0.04459394,1236,1661.5,2.5,12.5,1331.5,1755,0.011484939,0.047563862,3070,17.5,6.5,3083,3165.5,4636.5,12,3930,3393.5,4965,3533.5,2963,-0.01781037,16,3.5,19,1314.5,1456.5,3.5,18.5,5.5,1807.5,7103,16697,1.5,21821,16940,11502.5,24038,15.5,-0.020222317,-0.028306503,23626.5,13399,28956,15.5,1.5,15.5,0.0070626372,14569.5,0.014247568,12642.5,0.02923775,0.019129174,-0.008717976,26964.5,14391,20709.5,2631,28342.5,3.5,2.5,-0.005611455,-0.0019493379,29407.5,29407.5,-0.0034120348,-0.005565598,-0.006205718,-0.0036565547,-0.00837103,-0.005469135,-0.00015865033,-0.000996705,16.5,8,0.0031540326,0.012717529,0.011954138,-0.0037906803,2610.5,0.009155378,2810.5,2818.5,15.5,3176,15.5,18.5,18417.5,19422,0.007273558,24935.5,17809.5,1.5,1.5,25810,26860.5,6.5,24547,24547,28827.5,31182,-0.003579183,0.0017418184,0.0068518333,0.062580004,-0.017207619,-0.0702365,-0.015560157,-0.0011925673,0.0055778497,0.009258064,0.045032643,-0.008353524,-0.012555691,0.0038165958,0.02145064,-0.009287374,-0.04049099,-0.016270312,-0.018790303,0.014011336,-0.024134489,-0.0064798235,-0.00814878,0.007956618,-0.036280926,0.004438384,0.0031112009,0.008450933,0.0051544267,0.031631496,-0.005215633,-0.014917388,0.0026479426,-0.023061564,0.0026940338,0.019835152,-0.0011423818,0.0127542615,-0.026729316,-0.0039407494,-0.0123938965,-0.019974876,-0.006794979,-0.012512018,-0.008962258,-0.0010052911,-0.00011849584,-0.007784904,-0.010702261,-0.006449686,-0.013839674,-0.00089036487,-0.009360392,-0.0067446777,-0.014662218,-0.004288603,-0.0069719567,-0.018819809,-0.01268094,-0.008464628,0.006150614,0.015717722,0.0070418613,0.0034727007,-0.014794466,-0.007481651,0.003974548,-0.005907304,-0.003661335,-0.0018219214,-0.010872039,0.018913064,0.018526047,-0.021880597,0.024620933,-0.005909358,-0.016775336,0.026808804,-0.006482412,0.010684176,-0.01754765,-0.0056820977,0.0048746928,0.00044939163,0.00021955797,-0.005044286,-0.0121582085,-0.029355818,-0.0042349263,0.009016226,0.0069082268,-0.0019327833,0.00050713395,-0.0028849917,-0.004247906,-0.0059917592,0.0028387497,0.0009528068,-0.015667193,-0.0059471554,0.012578877,0.006686413,0.000800014,-0.0058595375,0.0058521307,0.0029309047,-0.0030292163,0.0004374954,-0.005834225,-0.002636517,-0.00088675506,-0.0032381937,-0.00519381,0.0016556479,0.0026349167,-0.001702266,-0.001634587,-0.0036583242,0.006207291,0.001120942,0.0008738434,0.0033798758,-0.0007991937,0.0026010643,0.0021588244,-0.0044489815,0.0010659859,0.003254914,0.0032358337,0.008680015,0.004256817,-0.008204826,0.0061843535,0.013167937,0.004373213,0.009214455,0.01986353,0.0060000266,-0.009365308,-0.018992795,-0.0036087667,-0.00914926,0.0004746988,2.1323238e-05,0.0014243302,-0.00068180147,0.002777377,-0.019140726,-0.008595586,-0.0049801813,0.010549875,-0.0052698418,-3.9341707e-05,-0.0025535754,-9.9787685e-05,-0.00084785477,-0.0025240274,-0.00082943466,0.00175399,-0.00026374887,-0.005076436,-0.0011960658}, {7,2,5,1,3,6,4,0,1,0,6,3,1,1,2,1,5,8,0,3,7,5,7,2,1,8,8,0,8,5,1,0,2,1,8,255,255,0,1,8,0,0,4,5,3,2,6,4,6,8,8,1,8,255,8,8,8,8,6,4,5,4,6,1,1,8,2,1,8,8,2,8,0,8,0,4,1,8,0,4,8,8,1,7,4,2,2,0,4,7,8,0,8,0,6,8,0,0,1,8,8,5,5,255,8,0,255,8,0,2,8,8,6,8,255,8,4,3,4,8,3,1,8,1,1,2,4,2,255,255,255,6,0,8,8,2,1,255,255,3,8,8,3,0,3,8,5,6,2,3,0,255,8,8,8,7,7,8,8,8,7,3,2,8,4,0,3,0,8,255,255,4,7,6,8,8,8,255,0,255,0,255,255,255,0,0,1,0,0,8,8,255,255,0,0,255,255,255,255,255,255,255,255,8,8,255,255,255,255,2,255,4,2,8,2,8,8,2,4,255,5,0,8,8,6,1,8,4,4,5,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,65535,65535,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,65535,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,65535,201,203,65535,205,207,209,211,213,215,217,65535,219,221,223,225,227,229,231,233,235,237,239,241,243,65535,65535,65535,245,247,249,251,253,255,65535,65535,257,259,261,263,265,267,269,271,273,275,277,279,65535,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,311,313,65535,65535,315,317,319,321,323,325,65535,327,65535,329,65535,65535,65535,331,333,335,337,339,341,343,65535,65535,345,347,65535,65535,65535,65535,65535,65535,65535,65535,349,351,65535,65535,65535,65535,353,65535,355,357,359,361,363,365,367,369,65535,371,373,375,377,379,381,383,385,387,389,391,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,65535,65535,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,65535,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,65535,202,204,65535,206,208,210,212,214,216,218,65535,220,222,224,226,228,230,232,234,236,238,240,242,244,65535,65535,65535,246,248,250,252,254,256,65535,65535,258,260,262,264,266,268,270,272,274,276,278,280,65535,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,312,314,65535,65535,316,318,320,322,324,326,65535,328,65535,330,65535,65535,65535,332,334,336,338,340,342,344,65535,65535,346,348,65535,65535,65535,65535,65535,65535,65535,65535,350,352,65535,65535,65535,65535,354,65535,356,358,360,362,364,366,368,370,65535,372,374,376,378,380,382,384,386,388,390,392,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({19711.5,5817.5,17981.5,14.5,4584,20596.5,3247.5,3196.5,3592,8742,21851,13062.5,21861,1218.5,23508,1395,2830,3775,3866,3203.5,3807,18803,20701.5,15,29583,23219.5,1204,19,18.5,24208,32515.5,838.5,1324,4090.5,7.5,7449.5,17.5,3077,15211.5,5388,12.5,5.5,4.5,14534,13535,14314,24567,0.013190349,0.0053766663,24832,12.5,25068.5,15.5,15.5,16.5,0.02221359,0.0048228395,2864,2638,22612,17.5,22427,6.5,772,1506,6.5,2124,551,651.5,5580,3268,397.5,1134,2138.5,3318,-0.024702504,3270,6424.5,6056.5,2726.5,7720.5,3187,12324,3232,2331,4547.5,4547.5,10458,1.5,17065,18172,27501,20830.5,27533.5,29267,-0.018232089,-0.008724097,2.5,-0.004034281,0.011869008,0.020302927,2.5,20801.5,2.5,19.5,27590,29529,15.5,2849.5,2535.5,31563,1.5,1.5,21843,20.5,30571.5,30725,1.5,18805.5,50.5,573.5,1028.5,1705,1900,12.5,1176.5,6.5,4.5,3218.5,-0.014920457,3855,5660,5750.5,4806,5765.5,357,637,-0.02698423,17.5,5926,12617,2781,0.037261713,18.5,18.5,5645.5,6943.5,-0.02906235,-0.012485878,-0.03406405,4533,2991.5,2543.5,4325.5,6.5,6095,3509,2.5,14196,7634,10929,8691.5,10994,12.5,18.5,9407.5,15030.5,15096,8996.5,12601.5,11937.5,19927.5,1.5,17738.5,14.5,0.022648007,15.5,15,0.019636573,27645,24777,-0.00054639205,-0.0024206748,0.0011956355,0.009338811,0.0046158405,0.0018566499,0.0058970796,25989.5,-0.0039133625,-0.011750069,1.5,0.003688228,18308,27590,2631,3171.5,17.5,5.5,0.007643103,-0.007179337,2870.5,32006,21953,21569,22526.5,24310,15921.5,25356.5,20377.5,15921.5,25893,15.5,28943.5,30399.5,22381.5,19853.5,16.5,19824.5,-0.0036083465,0.0010442346,-0.07279667,-0.01236736,0.0013139596,0.010035357,-0.008447232,0.0039772578,-0.0020264387,-0.022725528,-0.027894992,-0.0066103423,-0.002593914,0.007485783,-0.0008803011,-0.011758955,0.021876452,0.01286635,0.0060440465,0.012674955,-0.004458083,0.001331373,0.0029580859,-0.0052475417,-0.0043844585,0.0020061713,-0.012187513,-0.0072154934,-0.0028097935,0.0023575774,-0.000121886376,-0.03567522,0.017380457,0.00162159,-0.016337061,-0.008070986,-0.0020117462,0.0044438494,0.012661916,0.0010095001,-0.008275027,0.014357812,-0.0027199604,-0.014227064,0.0025037492,0.00701799,-0.001404481,-0.0074325204,0.0071863616,-0.0007030001,-0.012006214,-0.0023237641,-0.0072197714,-5.399738e-05,-0.0051473468,0.0033553992,-0.009100827,0.0022990245,-0.0030544202,-0.005672203,-0.0053390306,5.679652e-05,-0.0138632525,-0.007716632,-0.0071119913,-0.0028835873,0.0039598052,-0.008226213,-0.0010619486,-0.010555056,-0.0034142875,-0.007129018,0.013359656,0.0027792824,-0.011807352,-0.002007199,-0.014019216,-0.028621078,-0.010644062,-0.01574179,-0.0015275155,-0.0048804353,8.152506e-06,0.02202611,0.01305326,0.020575859,0.002162898,-0.01588953,-0.006480037,0.0048014163,0.012054581,0.0241805,0.028320998,0.012293789,0.007892584,-0.024974285,0.0075002695,-0.0052981493,-0.009466861,-0.015348298,-0.0026107084,-0.0059798425,0.014107232,0.00566058,0.0044559403,0.010417472,0.007050918,0.0005714809,-0.0037041344,0.00033616836,0.005970766,0.01008601,0.008873393,0.0015151793,0.00072498847,-0.0024136265,0.0014055547,0.00427896,0.0057564145,0.010900657,0.00022282987,-0.0048499,0.0003294155,0.0049123913,0.0143569335,0.00841881,-0.009310181,0.008698101,0.0050400826,-0.0008035974,-0.022532498,-0.015816271,0.01082296,0.0023620503,-0.011842503,-0.006126718,0.0037085616,-8.0428326e-05,-0.0066746334,-0.0013978445,-0.0013328677,-0.0036203382,-0.0062662484,-0.0009927402,0.0152221,0.007249409,0.001532487,-0.0018745819,-0.0053455667,-0.00034603852,0.000862645,-0.0010110114,0.0050786897,0.00050861895,0.0010596821,-0.00092396507,-0.0048673367,-0.0065588104,-0.00016341245,-0.0025932076}, {1,6,3,8,7,1,0,5,4,6,0,3,1,4,0,4,0,5,4,3,5,0,5,8,0,2,2,8,8,1,2,5,5,6,8,0,8,5,4,4,8,8,8,1,1,7,2,255,255,0,8,0,8,8,8,255,255,4,0,7,8,3,8,4,0,8,0,2,2,2,1,1,2,0,4,255,7,3,0,0,2,5,2,5,1,1,1,3,8,7,1,6,2,0,4,255,255,8,255,255,255,8,1,8,8,2,0,8,2,0,1,8,8,0,8,0,1,8,7,7,1,7,0,0,8,3,8,8,1,255,7,7,5,6,6,0,0,255,8,7,1,4,255,8,8,3,2,255,255,255,1,3,7,7,8,2,7,8,2,2,2,0,0,8,8,2,0,6,2,1,1,3,8,4,8,255,8,8,255,6,0,255,255,255,255,255,255,255,0,255,255,8,255,5,2,0,2,8,8,255,255,0,3,0,1,4,7,0,1,2,0,0,8,0,3,1,3,8,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,65535,65535,95,97,99,101,103,105,65535,65535,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,65535,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,65535,65535,181,65535,65535,65535,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,65535,239,241,243,245,247,249,251,65535,253,255,257,259,65535,261,263,265,267,65535,65535,65535,269,271,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,65535,319,321,65535,323,325,65535,65535,65535,65535,65535,65535,65535,327,65535,65535,329,65535,331,333,335,337,339,341,65535,65535,343,345,347,349,351,353,355,357,359,361,363,365,367,369,371,373,375,377,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,65535,65535,96,98,100,102,104,106,65535,65535,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,65535,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,65535,65535,182,65535,65535,65535,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,65535,240,242,244,246,248,250,252,65535,254,256,258,260,65535,262,264,266,268,65535,65535,65535,270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,65535,320,322,65535,324,326,65535,65535,65535,65535,65535,65535,65535,328,65535,65535,330,65535,332,334,336,338,340,342,65535,65535,344,346,348,350,352,354,356,358,360,362,364,366,368,370,372,374,376,378,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({19711.5,6111,17981.5,15.5,4662.5,20596.5,9306.5,4510,3353.5,8854.5,9831,13062.5,29209,1218.5,23508,5019.5,4.5,1248,6900.5,3711.5,9095.5,6760.5,20327,16.5,29583,20801,16.5,6.5,15.5,22342,17926.5,2206,4.5,11585.5,4531,2275.5,1394.5,9566,7663.5,15.5,12.5,7.5,4.5,5677.5,7039,22304.5,19210.5,0.013330198,0.0036961667,1.5,12,2.5,15.5,2.5,18.5,0.0057505365,18,2462.5,22243,1.5,22134.5,15136,32429.5,1463,2830,2.5,5845,8171.5,0.01880335,7.5,6068.5,2816,2726.5,18.5,858,5697,1943.5,3998,7746.5,2786,18.5,2673,6095,5.5,4561,8691.5,4120.5,1578.5,7080,6950,7935.5,21518,17516.5,26873,24898,-0.0018272946,24832,2.5,15.5,0.008533135,0.016989117,17011.5,29529,0.007888895,30322.5,-0.0030776795,14274,0.01801865,0.005199024,4.5,2868.5,18.5,2873,20977,23559,16.5,23906,25493.5,25654.5,28228,29796.5,47.5,6.5,3095,3703.5,5778,4132.5,4295,2936,1.5,8372.5,-0.001971864,0.0049525867,5734,7934.5,69,521.5,2573,21.5,1136.5,1364,790,1144.5,5456.5,6850,-0.027958391,4608.5,19.5,5148.5,5488,5835,2475,2837.5,7978.5,3024.5,5.5,6.5,4253,7770.5,4613.5,4262.5,7940.5,9109.5,67,2.5,2331,14.5,806,5530,1.5,6711.5,6948,6057.5,8675.5,10408.5,21851,22807,8213,27402,1.5,15.5,20107,30178,-0.017327588,-0.0070959623,-0.0004998284,4.5,-0.0025199696,-0.0038849884,1.5,1.5,29094.5,27590,-0.0044448744,27038,-0.00417103,-0.013049441,0.0017193326,6.5,6.5,2.5,-0.0045678555,2642,31459,2768,0.007869217,20824,19827.5,19502,21016.5,19.5,23669,3,5.5,1.5,15538.5,23798,25937.5,4.5,29823.5,29820.5,-0.0037731219,0.00012776133,-0.0043153684,-0.015038873,0.0012046661,0.0067285346,-0.0034128358,0.002743989,-0.012821987,-0.0052555404,-0.0011909392,0.008701985,-0.012227444,-0.002129942,-0.009962666,-0.00509138,0.0059268503,0.0015570116,-0.022839306,-0.0028110126,-0.000467331,-0.0036371592,0.0023549171,0.019590069,-0.00078729336,0.0038231432,-0.0062498422,-0.02272819,-0.021238228,-0.03172597,-0.006347158,0.0143949855,0.0061266967,-0.00864933,0.019614657,0.0489978,-0.0034253707,0.016819982,-0.024122452,0.0031897014,-0.001743556,0.005587259,-0.0099875545,0.0017703878,-0.014962274,-0.009679926,0.015209407,0.035091665,-0.022174912,0.008354914,0.02065616,0.0011375765,-0.010989771,-0.00056552526,-0.005830805,0.0019223721,-0.011521233,-0.006278038,-0.004308529,0.0030199618,-0.0069398405,-0.002357146,-0.02295616,-0.008558576,-0.002507392,-0.0052634506,0.0036070023,-0.006795698,-0.0013808976,0.0023014054,-0.0023063633,0.0072119827,-0.0038503644,-0.011236331,-0.003403573,-0.028080767,0.008549644,-0.009340213,-0.0024063417,0.009262704,-0.005090411,-0.00079108693,-0.009408112,-0.00591179,-0.007892985,-0.014417621,-0.01972049,-0.030890916,0.003069987,0.020899314,0.011597819,-0.013824257,0.0029040563,-0.019845817,-0.0020326355,0.020083103,0.01675385,-0.026556497,0.008808923,-0.009982022,-0.00035851152,-0.012991845,-0.0026690867,-0.0044678133,0.022212058,0.008283261,0.0029858402,-0.00789534,0.017871382,0.010007219,0.004960613,0.023192875,0.007847278,0.0013786496,0.00025668586,-0.017996486,0.005661653,-0.001003489,-0.0013009782,-0.0020283728,0.0030265106,0.00891978,-0.0016258926,0.004252031,0.0020371836,0.0055989497,0.0016931508,-0.002207991,0.0014479952,-0.001719244,-0.0031137567,0.00044572065,0.0026084615,0.0057437434,-0.0008620874,0.0024568064,-0.0022410671,0.0041920426,0.005500741,0.008920848,0.0071998946,0.0036757928,-0.001241172,0.0029185554,-0.02195271,-0.015469282,-0.00437379,-0.0087489495,7.472098e-06,-0.0030089747,-0.0029155905,-0.00091110915,-0.010954746,-0.007195844,0.0011166179,-0.0059826355,-0.006654603,-0.01707966,0.0019085996,-0.0054090647,0.00859388,0.0149420025,0.00120564,0.009019844,-0.0010627692,-0.006164229,0.00050724176,-0.0017865235,-0.00090120966,-0.0003690908,-0.0038276673,-0.0010089867}, {1,6,3,8,7,1,0,1,4,6,4,3,1,4,0,0,8,3,1,5,4,6,3,8,0,6,8,8,8,3,7,5,8,2,1,6,2,4,0,8,8,8,8,1,3,7,5,255,255,8,8,8,8,8,8,255,8,4,1,8,2,6,5,4,0,8,0,2,255,8,6,0,7,8,6,1,1,4,1,1,8,7,2,8,1,0,3,0,7,3,3,5,0,2,2,255,0,8,8,255,255,3,0,255,1,255,0,255,255,8,0,8,4,0,7,8,1,0,4,6,0,7,8,3,1,0,1,1,7,8,2,255,255,2,2,3,5,6,8,2,5,4,6,3,0,255,6,8,5,4,5,1,3,0,7,8,8,7,4,7,1,0,0,0,8,1,8,0,0,8,6,3,0,6,0,0,2,0,6,8,8,2,2,255,255,255,8,255,255,8,8,0,2,255,0,255,255,255,8,8,8,255,0,7,6,255,3,2,2,4,8,3,8,8,8,5,5,7,8,4,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,65535,65535,95,97,99,101,103,105,65535,107,109,111,113,115,117,119,121,123,125,127,129,65535,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,65535,183,185,187,65535,65535,189,191,65535,193,65535,195,65535,65535,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,65535,65535,241,243,245,247,249,251,253,255,257,259,261,263,65535,265,267,269,271,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,323,325,327,329,331,333,335,337,65535,65535,65535,339,65535,65535,341,343,345,347,65535,349,65535,65535,65535,351,353,355,65535,357,359,361,65535,363,365,367,369,371,373,375,377,379,381,383,385,387,389,391,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,65535,65535,96,98,100,102,104,106,65535,108,110,112,114,116,118,120,122,124,126,128,130,65535,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,65535,184,186,188,65535,65535,190,192,65535,194,65535,196,65535,65535,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,65535,65535,242,244,246,248,250,252,254,256,258,260,262,264,65535,266,268,270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,326,328,330,332,334,336,338,65535,65535,65535,340,65535,65535,342,344,346,348,65535,350,65535,65535,65535,352,354,356,65535,358,360,362,65535,364,366,368,370,372,374,376,378,380,382,384,386,388,390,392,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({37.5,34.5,22.5,22,29,76.5,6900.5,93.5,74.5,27,2.5,-0.034860294,-0.016787408,5928,7808.5,60.5,15,78,788.5,0.0040079197,77,87.5,18.5,43.5,9230,8127,10500.5,22,14.5,-0.02000517,-0.03080791,32,31,490,39.5,0.028154975,0.014523803,0.021046868,0.0075314725,15.5,36,77,457.5,9022.5,10097.5,8037,7496,7760.5,31365,22,39.5,7,0.015602811,17.5,22,18.5,24988.5,83.5,1986.5,9,20.5,34.5,34.5,0.0013953792,-0.006219987,22.5,107.5,33,548,8227.5,6310.5,6853.5,11004,4.5,6702.5,7079.5,8224.5,9723,5282,13129,16313,15.5,6.5,29,7,1.5,0.0049386513,22,30.5,2.5,21.5,232.5,461.5,15.5,25493.5,-0.011849931,-0.035625335,1118.5,-0.019849105,0.0060142884,0.011146701,4,4215,0.0060386145,7.5,-0.004092985,37.5,106,109,95,78.5,184.5,35,580.5,1010.5,7998,5846.5,1.5,9300,6490.5,1.5,20165,18239,7382,4311.5,6099,5940,7216.5,7608,-0.021672642,7121.5,7908,5.5,4649.5,10259.5,13090,17686,12.5,18817,-0.0021883491,-0.0064330176,-0.006425742,0.0017290583,0.008261972,0.0015898662,-0.0071952115,-0.0045526386,0.0043186927,0.009343565,0.0024104093,-0.0019007021,0.009227913,0.00027665315,-0.00059413415,0.003749861,0.013657204,0.0034829222,0.003909862,-0.0021834343,0.006043371,0.054943856,-0.018826226,-0.038413465,-0.009075411,-0.00050485524,-0.014878139,0.0022247152,0.00862187,0.004620977,-0.0017384738,0.0017984089,0.004113341,0.0008030992,0.0034834817,0.010386485,-0.050682332,-0.020694556,-0.0009432303,-0.028111026,-0.021149613,-0.040918916,-0.028113594,-0.017184751,0.01762589,0.0049884277,-0.029226432,0.0032945795,-0.014794807,-0.039436687,0.003614533,-0.0014507604,-0.0038978083,-0.011178709,0.021325553,-0.013048028,-0.014871681,0.012496586,-0.008083987,0.0021114626,-0.0013409989,0.0074865306,-0.0059404564,0.016853651,-0.0129295215,0.004238554,0.001140783,-0.012445903,0.0055403765,0.01417161,0.007962557,0.0019658383,0.017115852,0.0009680535,-0.0024755325,-0.026997609,-0.014657931,0.005351446,-0.03199394,-0.013851741,-0.01114704,0.0044702673,-0.024011882,0.013478306,0.0029506097,-0.004396664,-0.0017615439,0.0073116357,-0.010249246,-0.0033285923,-0.0003110965,0.0022035919,-0.009478531,-0.00087267597,-0.0070051188,-0.011663625,-0.0037871436,-0.0016309385}, {4,4,5,2,3,6,1,0,6,0,8,255,255,0,0,6,8,0,0,255,0,0,8,5,3,2,1,0,8,255,255,0,4,6,2,255,255,255,255,8,2,4,2,7,2,4,5,1,0,6,6,8,255,8,4,8,0,6,6,8,8,0,0,255,255,1,4,2,3,5,1,0,3,8,0,6,2,0,7,3,3,8,8,0,8,8,255,4,2,8,8,0,0,8,0,255,255,6,255,255,255,8,0,255,8,255,0,2,6,4,0,6,2,2,6,7,2,8,4,0,8,0,3,4,5,2,2,0,1,255,7,0,8,7,0,2,6,8,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,65535,23,25,27,29,31,33,65535,35,37,39,41,43,45,47,49,51,65535,65535,53,55,57,59,65535,65535,65535,65535,61,63,65,67,69,71,73,75,77,79,81,83,85,65535,87,89,91,93,95,97,99,101,103,105,65535,65535,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,65535,149,151,153,155,157,159,161,163,65535,65535,165,65535,65535,65535,167,169,65535,171,65535,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,65535,219,221,223,225,227,229,231,233,235,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,65535,24,26,28,30,32,34,65535,36,38,40,42,44,46,48,50,52,65535,65535,54,56,58,60,65535,65535,65535,65535,62,64,66,68,70,72,74,76,78,80,82,84,86,65535,88,90,92,94,96,98,100,102,104,106,65535,65535,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,65535,150,152,154,156,158,160,162,164,65535,65535,166,65535,65535,65535,168,170,65535,172,65535,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,65535,220,222,224,226,228,230,232,234,236,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({37.5,26.5,4435.5,5672.5,36.5,4408,9340.5,27,10,33.5,27,44.5,1435.5,5336.5,11405.5,71,7.5,4,18.5,1.5,63.5,24988.5,18.5,33.5,202.5,5533.5,3299.5,2108,9268,16304,11416.5,22,-0.021876702,36,21.5,0.018194595,0.010662728,0.0054000537,0.0023200396,0.01640403,27.5,24,-0.043340765,18.5,1.5,15.5,494.5,2529.5,64.5,34.5,1499.5,-0.027402414,383,3252,2.5,18.5,2213,9109.5,10420.5,10319.5,14.5,16.5,18218.5,22,16,28.5,120.5,20.5,447.5,26,13.5,0.02327946,15.5,78,406,0.00755774,25493.5,38,38.5,25.5,20.5,47.5,4565.5,72,9777.5,8.5,19.5,936,2042.5,16,4.5,12.5,7.5,7475,4271.5,3606.5,3441,-0.018725868,7274.5,5600.5,8000.5,9273.5,17.5,5484.5,10391,31863,11433,4.5,13664.5,12585.5,20670.5,22,18.5,-0.0097305095,-0.003282108,23.5,3.5,75.5,306,15.5,33.5,100.5,1300.5,17.5,19.5,25,22,8.5,35,0.0053525455,15.5,579,-0.014757052,4.5,25583.5,-0.0041653975,57.5,544,445,0.011695973,32.5,302,0.045203798,29,20.5,2,5,22.5,6.5,24.5,15.5,92,62,870.5,3720.5,652,1401,19.5,2266.5,4.5,19,6304.5,3010.5,4.5,15.5,2.5,18.5,4568,1720.5,3711.5,4762.5,6.5,15.5,0.00453846,4840.5,7638.5,5749.5,4928,6467.5,8817.5,9619.5,9325,9504,4.5,10582.5,4767,4.5,9336,5175.5,18048.5,2.5,16983.5,18048.5,13317,13664.5,10671,0.013264569,13216,1.5,18097,16109,-0.00267823,0.012807722,0.002490702,0.011259939,0.0025382175,0.0044943257,-0.004578304,-0.001041775,0.0054523856,0.017538091,0.006532935,0.0021725562,-0.002148375,0.0048740464,0.0011135787,-0.012057569,0.0008162331,-0.014045174,0.069105946,0.027560104,0.001509765,0.00815904,-0.0031396323,0.0048356545,0.0037769338,0.007380895,0.0036342235,-0.00078103517,0.016154768,0.007375726,0.020052731,-0.005816184,-0.016555414,-0.027465865,-0.028225983,-0.056037374,-0.003428397,-0.010926602,-0.00046327058,-0.004120325,0.0049610096,0.00022625945,0.010286245,0.0044374266,-0.0036311557,0.003591081,0.0011599169,-0.008061695,0.029523958,0.016945194,-0.0050195036,0.010014438,0.006265408,-0.0012967908,0.009082471,-0.018952655,0.009091706,0.0021791456,-0.045214284,-0.00019246798,-0.033525795,-0.014274401,-0.039079946,-0.019371843,-0.0005033977,-0.0034338643,0.029331816,0.00956594,0.015680376,0.008115477,0.00861166,0.0022643902,-0.006731705,0.009779272,-0.0023311526,-0.01499202,0.001059349,-0.0070500444,0.004960402,0.016525796,-0.0038038492,0.00068668625,-0.003839258,-0.010245886,-0.00024031398,0.005278533,-0.0064385408,0.0024219765,-0.017681751,-0.00948791,-0.0050797276,-0.0138878245,-0.0030188747,0.0010952653,0.004991357,0.010637613,0.0038035729,-0.001492713,-0.0042836373,-0.009459316,-0.014713357,-0.0029067206,-0.0044827606,-0.0025688906,-0.008179639,0.0017234993,0.005805887,0.014925823,-0.0002555735,0.0057318434,0.02788583,0.053948194,0.0033361402,-0.0130915865,-0.028883725,0.0003743598,-0.0010717679,0.005360387,-0.006768065,-0.0014457253,0.00080628536,0.006686239,-0.0039231093,0.0013451831,0.0057469807,-0.005529055,0.024034612,0.014512501,0.002893252,-0.0017552031,-0.0060927174,0.004958601,-0.0033016235,0.003600149,-0.012397295,-0.005469285,0.028883113,-0.00075648254,-0.009600877,-0.0011213023,-0.0037351132,0.008449984,-0.003733874,-0.009468075,-0.005894699,-0.011425781,-0.0064801625,0.006101422,0.0035164696,0.012053574,-0.0007345221,0.008424373,0.0043451143,-0.00082023145,-0.0019806565,0.011691104,0.017399067,-0.011798772,0.017076233,-0.01149046,-0.004384094,-0.0011628681}, {6,6,1,4,0,0,0,2,8,0,7,1,5,0,1,0,8,8,8,8,4,0,8,0,0,0,4,7,0,0,0,4,255,1,8,255,255,255,255,255,2,1,255,8,8,8,0,2,6,2,1,255,5,1,8,8,6,1,3,0,8,8,0,0,8,4,0,8,0,2,8,255,8,0,2,255,0,0,4,2,8,6,2,2,4,8,8,7,0,8,8,8,8,0,1,2,2,255,6,3,0,2,8,7,0,6,3,8,1,3,0,2,8,255,255,0,8,0,0,8,0,2,0,8,8,3,0,8,0,255,8,0,255,8,0,255,0,0,0,255,2,2,255,0,8,8,8,1,8,1,8,0,0,4,5,6,0,8,1,8,8,4,2,8,8,8,8,2,7,5,5,8,8,255,0,4,2,7,2,3,1,0,2,8,1,7,8,1,1,7,8,0,7,7,1,0,255,2,8,1,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65535,65,67,65535,65535,65535,65535,65535,69,71,65535,73,75,77,79,81,83,85,87,65535,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,65535,127,129,131,65535,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,65535,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,65535,65535,205,207,209,211,213,215,217,219,221,223,225,227,229,231,65535,233,235,65535,237,239,65535,241,243,245,65535,247,249,65535,251,253,255,257,259,261,263,265,267,269,271,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,65535,311,313,315,317,319,321,323,325,327,329,331,333,335,337,339,341,343,345,347,349,351,353,65535,355,357,359,361,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,65535,66,68,65535,65535,65535,65535,65535,70,72,65535,74,76,78,80,82,84,86,88,65535,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,65535,128,130,132,65535,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,65535,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,65535,65535,206,208,210,212,214,216,218,220,222,224,226,228,230,232,65535,234,236,65535,238,240,65535,242,244,246,65535,248,250,65535,252,254,256,258,260,262,264,266,268,270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,65535,312,314,316,318,320,322,324,326,328,330,332,334,336,338,340,342,344,346,348,350,352,354,65535,356,358,360,362,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({5.5,63.5,27407.5,32.5,2635,14966.5,18602.5,76.5,27,2923.5,4599,15.5,18486.5,23618.5,22213,26.5,279.5,23,43.5,1241,1165,232.5,4509,4158,7535.5,27959.5,21794,2712.5,2388.5,0.009441372,32144.5,93.5,35.5,28,1719.5,0.0074000168,56.5,35.5,1278.5,99.5,2865,561.5,2563.5,5122.5,13448.5,2.5,7987,1348.5,6427.5,11606.5,13562,12438,0.025562033,12266,13774,16.5,0.010162957,1642,15069.5,29470,29796.5,72,-0.015229811,32,24.5,-0.029852957,-0.012919667,1118.5,1.5,3.5,0.0066845007,36.5,2.5,0.03386232,0.0063197664,81,558.5,2.5,4944.5,-0.013687667,-0.028287861,7504.5,3083,1174,1.5,2801.5,12459.5,6475,2413,8409.5,11453.5,446,1298,5600.5,11072,3637.5,12323,12951.5,11548,12294.5,19492.5,19735,18996.5,27501,22503,15.5,20.5,12,15.5,17.5,16.5,27512,26926.5,29727.5,29719,53.5,3,4.5,3.5,-0.040731426,26.5,-0.004945862,-0.0017385632,0.009662885,0.0036467642,41.5,0.0023332085,-0.0034517974,2.5,28.5,40.5,24.5,2.5,702,1384,1525,2171,2269,8192.5,1941.5,7570.5,4856,6065,-0.008874289,26.5,-0.0045786863,-0.018814307,2936,1884,4109,1.5,2687.5,2653,2385,5785.5,1.5,8414,7986,1.5,438,1512,12.5,2089.5,5737.5,6560.5,4687.5,12402.5,4140,2029.5,11047.5,12460,10408.5,11260,25292.5,14781.5,18.5,0.02879248,14216,23318,30624,21691,12854,21937,16663.5,13422.5,14768.5,21228.5,12.5,-0.000674833,0.009406923,3184.5,-0.0012700567,16,-0.00070748513,-0.004614152,2403.5,2403.5,2987.5,3220,26413.5,-0.011901146,6.5,29791,29653,29729.5,29668,30030,-0.0026080734,0.0019014754,0.012835701,0.0037812858,0.0037944966,0.00044142338,0.0174225,0.009325606,-0.020879094,0.0016134506,-0.005261158,-0.0023321693,0.0114279315,0.0040418883,0.0024440761,0.027607426,0.006624525,0.016750414,0.0009420568,-0.007617071,0.007766367,0.017217616,-0.020544482,0.0020044686,0.00084053114,-0.011639971,0.0063832453,-0.007938041,0.017442873,0.0007600796,-0.0025434503,-0.026548369,0.006344765,-0.0065495716,-0.004287638,-0.011670115,0.026383549,-0.004196085,-0.0034267846,-0.01405502,-0.00021808609,-0.006287639,0.005651743,-0.0016503021,-0.0008555051,0.0048779864,-0.006015054,0.0024312139,-0.022374123,-0.007977775,0.0051751933,0.002004205,-0.017109519,-0.0067130225,0.0091920635,-0.0038744663,-0.015367492,-0.006890431,-0.0037351754,0.00042494564,0.005287229,-0.00037075137,0.008034422,0.001690907,-0.0015960204,-0.0042733597,0.0018363737,-0.00055092294,-0.0016691837,-0.02631518,0.0057184016,-0.0009418412,-0.022582835,-0.0028646586,0.004485914,-0.004338454,-0.0004697016,0.004396836,-0.007613906,-0.0007029536,-0.0066896724,-0.0024905957,0.0006766199,-0.011850279,0.00070266175,0.009298807,-0.0062364633,-0.0012527265,-0.0033168064,-0.010922323,0.0051201037,-0.0033570868,0.0016547196,-0.0067600557,0.006625738,0.017053604,0.008497358,-0.0010375351,-0.015298227,-0.0063932897,-0.006176557,-0.009907626,-0.0049615903,-0.017233891,-0.0067808996,0.012597839,-0.0075811646,-0.014161012,0.025613585,-0.0037482714,0.0074063796,0.021146474,-0.016006568,0.013112435,-0.005033533,0.0035629165,-0.008715435,-0.026839016,0.01261144,-0.009296595,0.005169308,-0.0022140462,0.0013498584,0.0033005315,0.008309479,-0.004777141,0.00021136762,-0.0003750476,0.005785711,0.013093799,-0.0005961745,-0.0033471987,0.00039585392,0.0020158289,0.0054100645,0.0014233867,-0.0024278078,-0.0054976307,0.0010114891,0.0024982917,-0.0016106978,-0.00019093197,-0.00040832927,-0.0013342254,-0.0010892865,2.5483218e-05,-0.0004945531,-0.002426841,-0.001289573,-0.000329576}, {8,4,5,5,7,2,0,6,0,6,4,8,2,7,1,2,6,2,5,5,5,1,5,1,3,4,6,6,2,255,5,0,0,1,0,255,4,7,0,4,2,5,5,6,6,8,6,2,0,6,1,7,255,7,7,8,255,0,1,4,0,6,255,0,3,255,255,6,8,8,255,1,8,255,255,5,1,8,5,255,255,4,1,4,8,4,2,2,5,7,7,7,3,3,0,4,0,0,0,7,7,6,3,6,6,8,8,8,8,8,8,2,3,0,6,0,8,8,8,255,1,255,255,255,255,4,255,255,8,2,0,3,8,7,4,6,1,7,2,3,4,0,6,255,0,255,255,7,1,0,8,1,7,1,0,8,2,3,8,6,6,8,2,4,3,1,7,3,1,0,0,0,7,5,3,8,255,0,0,2,0,7,2,5,7,1,4,8,255,255,0,255,8,255,255,0,0,2,0,6,255,8,4,0,4,4,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,65535,59,61,63,65,67,65535,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,65535,101,103,105,65535,107,109,111,113,115,65535,117,119,65535,65535,121,123,125,65535,127,129,65535,65535,131,133,135,137,65535,65535,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,65535,215,65535,65535,65535,65535,217,65535,65535,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,65535,249,65535,65535,251,253,255,257,259,261,263,265,267,269,271,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,65535,309,311,313,315,317,319,321,323,325,327,329,65535,65535,331,65535,333,65535,65535,335,337,339,341,343,65535,345,347,349,351,353,355,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,65535,60,62,64,66,68,65535,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,65535,102,104,106,65535,108,110,112,114,116,65535,118,120,65535,65535,122,124,126,65535,128,130,65535,65535,132,134,136,138,65535,65535,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,65535,216,65535,65535,65535,65535,218,65535,65535,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,65535,250,65535,65535,252,254,256,258,260,262,264,266,268,270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,65535,310,312,314,316,318,320,322,324,326,328,330,65535,65535,332,65535,334,65535,65535,336,338,340,342,344,65535,346,348,350,352,354,356,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6.5,4609,27407.5,925,3842,15091.5,23117.5,376,2.5,9755,5433.5,6972.5,18486.5,29136,32144.5,31.5,914.5,3278.5,807,6209.5,7938,5314,4768,1025.5,13731,7004,21925,2718.5,14883,29727.5,19560.5,77,61.5,380.5,713.5,1591.5,4262,-0.030638644,3340.5,5.5,3854.5,3157.5,9878,5180.5,6920.5,6324.5,5817.5,1000.5,1426.5,13526.5,13815.5,6161.5,18187.5,18996.5,15987.5,13.5,0.010323866,10.5,0.0019653982,25966,28631,24004,30219.5,83.5,93,27,62,414.5,444,1917,1.5,1571.5,2281,1.5,3734,2430.5,2983.5,4220.5,3493.5,67,8597,6796.5,2,9834.5,3694.5,3295,7420.5,5215.5,5317.5,5451.5,7749,5911,3489.5,51.5,20.5,12.5,2063.5,11787.5,11384.5,7997,13311.5,16585,17672.5,9306,27959.5,12854,21937,28933,22490.5,2673.5,19.5,-0.0010936864,17.5,14404,30089,29800.5,31283.5,15,18.5,29776.5,30059.5,78,279.5,107.5,1640.5,1.5,96,37,90.5,719.5,248,554.5,290,2.5,2.5,2399,4.5,1323,0.036506075,1933,2719,7189.5,18974,3456,4312,2225.5,4.5,2664,4109,2313.5,6286.5,6153,5289,-0.0076954844,6123.5,2510,1842,1.5,-0.016681813,-0.007362073,4.5,-0.0020466482,5,2689,14518.5,-0.023440612,272,6795.5,5230.5,4785.5,5480,-0.009643097,7108,2368,1.5,4.5,11178,5264,5765.5,11374.5,1.5,71.5,670,953,870.5,981,1223.5,1721.5,9404,15.5,10488,7909,14496,-0.010233794,11680.5,15764.5,9240.5,4617.5,4708.5,6923,-0.009531203,12.5,17220.5,23775.5,0.020480176,10565.5,15409,20071,20681,19264.5,29234,15.5,29755.5,3047,0.0011257393,3047,0.009457841,0.00025856038,-0.00036258574,18,26972.5,27528,26217,12.5,29818.5,30483.5,16.5,-0.0002546002,-0.0075964145,17.5,3209.5,30080,29698.5,29740,30331.5,0.0016077113,-0.00606395,-0.026256854,-0.002264702,-0.046387646,-0.015790261,-0.017481402,-0.0039141006,-0.0065392717,0.0019263969,0.02015408,0.007850128,-0.015230807,-0.028060202,-0.000900899,0.005320251,-0.017492866,0.0037661146,0.0006450402,0.009481561,-0.01795297,-0.057145853,0.009741902,-0.015468334,-0.0029475244,0.0022723197,-0.009817754,-0.021263769,-0.004798478,-0.020335462,0.01766208,-0.00037816976,0.0034837965,-0.00413054,-0.008561388,-0.0223041,0.0030381873,-0.00475618,0.0053545847,0.010743535,0.0034791788,-0.0036585468,0.0032157272,-0.0060615917,0.014536761,0.0034869004,0.005742676,-0.0011544758,0.016189313,0.004634522,-0.0005123268,-0.011879966,0.0035890255,-0.0002623962,-0.0126050785,0.0025342186,-0.010027366,-0.005232558,-0.0091547845,-0.0016401046,0.0036892276,-0.001597495,-0.00085361983,0.0041471063,-0.005004997,-0.0010504248,-0.024449034,-0.0077420063,0.0077459663,0.013964735,0.004900235,-0.007866158,0.011612727,-0.00022739512,-0.004409835,-0.00096072303,-0.0121488115,-0.005245446,-0.018336592,0.003152035,0.00968672,0.019370986,0.0009804193,0.004322838,-0.0008912976,0.016425956,-0.020960074,-0.005674792,0.005815837,0.00070978206,-0.014995634,-0.0059075747,-0.03688754,-0.0139971245,0.0001851329,-0.004884402,-0.01635327,-0.0033913814,0.007642892,-0.009001151,0.0038949945,0.014050039,-0.021245679,-0.0012384588,0.0007159044,-0.0007913757,-0.0011603307,-0.017990144,0.0035370283,-0.004530853,0.011240686,0.006075525,0.07922407,0.022721214,-0.023815295,-0.010556178,-0.01980075,-0.001113909,0.010952594,0.0019457955,-0.0017327296,-0.0037587478,-0.0014081358,0.0010697109,-0.001866322,-0.010574075,-0.0046087313,0.0056635602,0.011654156,0.023015028,0.003745772,-0.0023096171,-0.01879002,-0.010167601,-0.001162623,-0.011406851,-0.011027136,-0.005046493,-0.008299974,-0.013851794,0.00066649757,-0.0020212156,-0.0063850447,-0.011103621,-0.017642414,-0.011048525,-0.0065193027,0.011086639,-0.005398165,0.004665157,-0.017104309,0.01987453,-0.020165795,-0.011331401,0.014587839,-0.0025580204,-0.004349726,0.004152167,-0.020837313,-0.008613138,-0.0077210637,-0.013953122,0.0020592948,-0.0022093086,0.0012571061,0.0041035726,0.0022274875,0.0070540695,-0.0059965844,0.0006251583,-0.0023544997,0.00040336256,-0.008002377,-0.0021310262,0.0016273576,-0.003095263,0.0006221109,-0.0006920982,0.0025606668,0.0015658712,-0.0012850068,0.00032816103,-0.0017030746,-0.0026845646,0.0018360727,-0.0018922633,0.006985036,0.0020619445,-0.0003821009,-0.0021720023,-0.0016866506,-0.00067348994,-0.0033139554,-0.00049123634,0.00027211593,-0.00011525984}, {8,2,5,5,3,2,1,4,8,0,4,1,2,4,5,5,7,5,4,4,6,0,7,6,7,5,6,0,0,0,6,4,4,6,5,0,6,255,1,8,0,3,0,0,3,4,6,7,7,6,6,7,6,3,7,8,255,8,255,4,3,1,4,6,6,0,5,3,1,6,8,0,1,8,3,0,5,4,3,0,4,1,8,0,3,6,6,5,0,1,1,5,0,5,8,8,6,2,3,1,5,4,0,3,4,7,2,6,6,0,8,255,8,7,7,6,3,8,8,6,6,0,6,4,0,8,0,5,5,0,6,0,2,8,8,2,8,0,255,4,4,4,3,1,7,6,8,2,3,5,6,4,2,255,6,1,3,8,255,255,8,255,8,5,0,255,4,2,0,4,5,255,0,1,8,8,0,3,6,4,8,4,6,4,1,7,2,4,0,8,7,1,6,255,0,7,0,0,1,5,255,8,7,0,255,7,6,3,1,1,6,8,6,4,255,4,255,255,255,8,1,4,4,8,0,3,8,255,255,8,0,0,4,0,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,65535,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,65535,111,65535,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,65535,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,259,261,263,265,267,65535,269,271,273,275,277,279,281,283,285,287,289,291,293,295,65535,297,299,301,303,65535,65535,305,65535,307,309,311,65535,313,315,317,319,321,65535,323,325,327,329,331,333,335,337,339,341,343,345,347,349,351,353,355,357,359,361,363,65535,365,367,369,371,373,375,65535,377,379,381,65535,383,385,387,389,391,393,395,397,399,65535,401,65535,65535,65535,403,405,407,409,411,413,415,417,65535,65535,419,421,423,425,427,429,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,65535,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,65535,112,65535,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,65535,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,264,266,268,65535,270,272,274,276,278,280,282,284,286,288,290,292,294,296,65535,298,300,302,304,65535,65535,306,65535,308,310,312,65535,314,316,318,320,322,65535,324,326,328,330,332,334,336,338,340,342,344,346,348,350,352,354,356,358,360,362,364,65535,366,368,370,372,374,376,65535,378,380,382,65535,384,386,388,390,392,394,396,398,400,65535,402,65535,65535,65535,404,406,408,410,412,414,416,418,65535,65535,420,422,424,426,428,430,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({19491.5,20178.5,16345.5,14966.5,17853,20585.5,16706,9998,18392.5,23182,31756,14616,25527.5,6358.5,17321,9846,13731,13702.5,21973,22330.5,25146,27031,2.5,0.026240015,19652.5,1.5,26701.5,18,15.5,1.5,16950,6965.5,9466,14949.5,1.5,12294.5,1.5,12959.5,15.5,0.020523611,0.012653542,1.5,26874,31354,15.5,21048,14.5,0.013332604,0.007882833,0.0013606738,18.5,28214.5,27824.5,3,-0.003581477,6.5,2870.5,16490.5,18866.5,25923,13475.5,7897.5,7480.5,7610.5,1.5,15.5,0.02596265,0.018854342,11785.5,12.5,15367,18668,20907.5,19735,18333.5,13762,17469.5,0.0038125482,16,3,15.5,18.5,25679.5,1.5,24952,1.5,-0.000678586,20348.5,20348.5,0.011892817,21942.5,5.5,16.5,29106,29262,0.003367782,0.011256917,2743.5,2743.5,17929.5,24882.5,0.020560663,-0.00048614058,21681.5,17735.5,13734,30145,16.5,20870,18781,6962,7261.5,7946.5,6493,2.5,-0.003371739,11576.5,14709,13526.5,10920.5,17431.5,18214.5,7934,-0.006920226,0.023359535,14536,0.0033756134,14216,0.018827623,19236.5,23612,26873,19614,28197,21476,17447.5,23510.5,0.013225685,0.004841452,0.0010696689,-0.0035174226,2.5,28459.5,3.5,25541.5,18,17.5,22286.5,28642,0.0097231995,22280.5,0.005727802,20057.5,8.5,21048,17.5,-0.0028848783,0.0105914185,0.0029645122,11139,26353,2.5,0.0015686194,15.5,-0.0065118135,1.5,15.5,2715.5,2455.5,23654.5,2785.5,18.5,21.5,16.5,32006,19413.5,19985,19235.5,9,0.013337026,0.021551764,17,18.5,0.014694302,0.0069451975,24310,20654.5,-0.0010473136,-0.02199633,0.005876912,0.014739088,-0.002439299,-0.008255313,0.005380587,-0.0025257,-0.011469746,-0.02857144,0.004407563,0.00058484235,-0.050336596,-0.023458099,-0.00049591396,0.0074706487,0.001327811,0.007822073,-0.013535037,-0.0027984302,-0.013197829,0.0011624733,-0.0041866372,0.00082470564,-0.0059803477,-0.010299175,0.0043211165,0.014892419,-0.005022953,-0.016174214,-0.0036645432,-0.011237085,0.0066953646,-0.0016131395,0.019255893,0.0064409375,-0.02230956,-0.009238192,-0.0020020478,-0.006932399,0.0067123473,-0.0015099834,-0.0070659714,-0.003285852,0.016529424,-0.0033431102,0.00090236386,0.0075549306,0.0018088842,-0.001762115,-0.0016458897,-0.008370965,-0.0012351738,0.0004963418,0.0009476714,0.0059838924,-0.0048429524,0.0009994627,0.0005065944,-0.005331111,0.010114274,0.0052781547,0.0020756251,-0.00146176,0.0030119913,0.00069062307,0.00086278573,5.3736785e-05,-0.00053288124,-0.002371555,-0.00047864564,-0.0018397911,0.003159316,-0.0018703284,-0.0043856534,-0.0012756641,5.232917e-05,0.0053883153,0.0027233262,-0.0022389411,0.00096684037,0.007100634,0.0041446346,-0.0030703049,-0.00021059997,0.0033664105,0.002728389,-0.0014538564,0.005779413,0.0020131671,-5.561614e-05,0.0015988281,0.00062957755,0.0029011022,0.008677385,0.0028582711,-0.0012341643,0.006188326,-0.00185254,0.0029086384,-0.0032737728,-0.016063578,-0.0032254749,0.0013207751,-0.020839455,-0.013281028,-0.0014528091,0.0019097793,0.010326461,0.0058091716,0.002982307,-0.003404921,-0.012514855,-0.00029615723,-0.011667597,-0.0007018383}, {7,5,5,2,3,2,6,5,6,2,0,1,0,1,0,5,7,7,6,0,0,2,8,255,1,8,2,8,8,8,1,4,2,2,8,7,8,7,8,255,255,8,0,5,8,1,8,255,255,255,8,0,6,8,255,8,0,0,2,2,3,5,3,0,8,8,255,255,0,8,0,4,2,6,7,7,1,255,8,8,8,8,0,8,4,8,255,1,1,255,0,8,8,0,2,255,255,6,6,5,3,255,255,7,1,1,2,8,2,6,4,7,3,1,8,255,0,6,6,4,1,6,5,255,255,7,255,0,255,6,2,2,5,6,4,7,0,255,255,255,255,8,2,8,2,8,8,3,0,255,1,255,1,8,1,8,255,255,255,1,1,8,255,8,255,8,8,2,2,1,6,8,8,8,3,6,3,2,8,255,255,8,8,255,255,7,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,65535,65535,77,79,81,83,85,87,65535,65535,65535,89,91,93,95,65535,97,99,101,103,105,107,109,111,113,115,117,65535,65535,119,121,123,125,127,129,131,133,135,65535,137,139,141,143,145,147,149,151,65535,153,155,65535,157,159,161,163,165,65535,65535,167,169,171,173,65535,65535,175,177,179,181,183,185,187,189,191,193,195,197,65535,199,201,203,205,207,209,211,65535,65535,213,65535,215,65535,217,219,221,223,225,227,229,231,65535,65535,65535,65535,233,235,237,239,241,243,245,247,65535,249,65535,251,253,255,257,65535,65535,65535,259,261,263,65535,265,65535,267,269,271,273,275,277,279,281,283,285,287,289,291,293,65535,65535,295,297,65535,65535,299,301,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,65535,65535,78,80,82,84,86,88,65535,65535,65535,90,92,94,96,65535,98,100,102,104,106,108,110,112,114,116,118,65535,65535,120,122,124,126,128,130,132,134,136,65535,138,140,142,144,146,148,150,152,65535,154,156,65535,158,160,162,164,166,65535,65535,168,170,172,174,65535,65535,176,178,180,182,184,186,188,190,192,194,196,198,65535,200,202,204,206,208,210,212,65535,65535,214,65535,216,65535,218,220,222,224,226,228,230,232,65535,65535,65535,65535,234,236,238,240,242,244,246,248,65535,250,65535,252,254,256,258,65535,65535,65535,260,262,264,65535,266,65535,268,270,272,274,276,278,280,282,284,286,288,290,292,294,65535,65535,296,298,65535,65535,300,302,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7.5,6524,24031.5,5308.5,11833,2857.5,21041.5,2964.5,9087.5,6531.5,15328,1905,3600,18109.5,30603,99.5,4008.5,2.5,9506.5,10441,1.5,6945,15498.5,2455.5,1689,2723,14966.5,9488.5,28673,28998,19811,32.5,92.5,2830,7325.5,5600.5,2405,6955.5,5781,0.03204566,0.0070839683,8116,11570,6614.5,1.5,15457,18241.5,1450.5,2683.5,17.5,899.5,2192.5,2204,9998,18551.5,17.5,17396.5,0.01332626,0.008070512,25937.5,30188.5,18.5,27279.5,36.5,27,110,936,3172,5102.5,5007,5212,5599,8727.5,4.5,6987,0.019631244,7532.5,7054.5,11004,5451,6713,10410,7278.5,1.5,11402.5,11438.5,12707,9806.5,0.026562944,1.5,20775.5,2221,1512,13.5,15.5,15.5,0.052223213,20.5,1814.5,3526.5,38,5312.5,2454,8756.5,13530,27959.5,21438.5,2529,3011,16221.5,18.5,17.5,25637.5,29769,30175,2750.5,2975,17.5,30721.5,26.5,57.5,29.5,43.5,-0.04085606,146.5,821,2864.5,327,3231.5,4730,5488.5,3500.5,5521.5,5664.5,5862.5,7325,0.032149296,1.5,10726,8511.5,7264.5,5956.5,6993.5,0.00065799954,0.008041389,1.5,1.5,1.5,7737,25568,8258.5,11473,7239.5,9005.5,8364,7034.5,12277,11886,5707,2.5,5.5,9663.5,14437,12528,11506,6.5,3.5,10487,15251,18539,20703.5,33.5,15.5,118.5,674.5,2815,2525.5,2165,-0.047010224,0.021377055,0.002748382,17.5,2131,15.5,2842,3023,18.5,14,13.5,1673.5,-0.035163622,4067,2710.5,8563,4593.5,13544,12824,13107.5,0.018632514,18623,17443,3173.5,0.007886933,18.5,3804,-0.0020905577,-0.0056084413,-0.0013923101,0.000504318,26181,9404.5,25843,26322.5,29729.5,16.5,30064.5,30450.5,15.5,2935,-0.0042536343,10268.5,-0.00790226,-0.001399142,29647.5,32411.5,-0.001371696,0.004714509,-0.02384171,-0.0012824701,-0.00091856625,-0.018728217,0.007107844,0.016518317,-0.022278959,-0.010728299,-0.0032675199,-0.01409627,0.0016517759,-0.005573842,0.015436641,0.0047144466,0.017290717,0.01096971,0.0015211132,-0.01922683,0.008731974,0.0028502205,-0.00258968,0.0027880527,0.0016392224,0.0056216544,-0.00011415921,-0.007246212,-0.030706475,-0.008585693,-0.0042072535,0.014405655,-0.0018614641,-0.00715647,-0.0130934585,0.0009605665,-0.007290376,0.0008614712,-0.001611357,-0.004465465,-0.0008462082,-0.0051460476,0.023225786,-0.0005034905,-0.02003718,-0.0028260923,0.0074658045,0.000602979,0.011032768,0.0058974964,-0.014864119,0.0020800515,-0.003527671,0.006240088,0.011914688,0.0051650046,-0.016470002,0.00023192664,0.013919579,0.0036612086,-0.00073791866,0.0014318085,0.0015786199,-0.009685437,0.0039259214,0.019946896,-0.013364883,-0.0020386444,-0.0042713713,-0.011376191,0.0038737298,-0.0027178344,0.0007752573,0.013909571,0.004382618,-0.00024991552,-0.015992511,-0.007567818,0.017818373,0.0057534375,-0.007024962,0.011708624,-0.006867976,-0.014910501,0.011079924,0.0038080278,0.0035578448,-0.0068889386,-0.008314093,0.01648664,-0.00063641457,-0.008726844,0.009535939,-0.009139719,0.0057120784,-0.0003927576,0.0015654311,-0.0020869223,-0.014056471,-0.026038272,-0.000340374,0.015005468,-0.018844446,0.0015379535,-0.023700764,-0.0055881385,0.004354711,-0.0143495845,-0.01619898,-0.004955227,0.0040393122,0.010684905,0.01335,0.03677397,-0.0039572953,-0.019148994,0.0058904453,-0.00037471385,-0.018395403,-0.035020974,-0.01640842,0.00065963843,0.0047036475,-0.00014247686,-0.01320336,-0.005490787,-0.0047094673,-0.014289324,0.0021186955,-0.0026576777,0.005248032,-0.004260916,-0.00086855557,0.0052311006,-0.009956024,-0.002615892,-0.0002877037,0.0071952464,0.0034483725,-0.008064245,-0.005410226,-0.010265938,0.009284776,-0.0118701495,-0.004118036,-0.0014513333,0.0037075833,0.0006117225,-0.00020497684,0.005076454,-0.000385162,-0.0036124939,0.0012802902,-0.0006214035,-0.008516965,-0.001047369,-0.0041461713,0.0014404419,-0.011192082,-0.0053205504,-0.0020499413,-0.0004964704,0.0016052074,8.11438e-05,-0.0010820407,0.0011987208,-0.0016628001,-0.0025636854,0.00032956467,-0.0030177783,0.004741819,0.0011827885,0.007906432,0.0018640263,-0.0002610561,-0.0005492713,0.00013082108,0.0008474584}, {8,3,7,2,4,2,3,5,5,3,6,3,3,2,7,4,6,8,4,0,8,1,6,2,2,0,2,0,6,2,0,5,5,0,6,3,1,0,7,255,255,2,4,1,8,6,2,7,2,8,7,3,4,5,2,8,0,255,255,7,0,8,5,4,1,4,7,1,0,6,3,3,6,8,2,255,0,1,7,2,7,0,7,8,0,5,1,1,255,8,2,6,6,8,8,8,255,8,7,2,0,1,7,6,3,4,2,2,4,0,8,8,2,2,7,2,6,8,6,2,6,0,6,255,2,6,2,2,7,3,1,3,0,1,4,7,255,8,4,0,2,0,2,255,255,8,8,8,0,5,6,2,7,3,3,3,5,2,1,8,8,1,4,1,6,8,8,3,7,3,4,0,8,0,5,0,0,0,255,255,255,8,3,8,0,2,8,8,8,6,255,2,6,6,7,2,2,7,255,3,3,6,255,8,2,255,255,255,255,2,0,1,7,4,8,1,3,8,2,255,0,255,255,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,65535,65535,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,65535,65535,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,65535,143,145,147,149,151,153,155,157,159,161,163,165,65535,167,169,171,173,175,177,179,65535,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,65535,233,235,237,239,241,243,245,247,249,251,253,255,65535,257,259,261,263,265,267,65535,65535,269,271,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,323,325,327,329,331,333,65535,65535,65535,335,337,339,341,343,345,347,349,351,65535,353,355,357,359,361,363,365,65535,367,369,371,65535,373,375,65535,65535,65535,65535,377,379,381,383,385,387,389,391,393,395,65535,397,65535,65535,399,401,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,65535,65535,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,65535,65535,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,65535,144,146,148,150,152,154,156,158,160,162,164,166,65535,168,170,172,174,176,178,180,65535,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,65535,234,236,238,240,242,244,246,248,250,252,254,256,65535,258,260,262,264,266,268,65535,65535,270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,326,328,330,332,334,65535,65535,65535,336,338,340,342,344,346,348,350,352,65535,354,356,358,360,362,364,366,65535,368,370,372,65535,374,376,65535,65535,65535,65535,378,380,382,384,386,388,390,392,394,396,65535,398,65535,65535,400,402,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6.5,5332.5,27407.5,754.5,4957,944.5,23117.5,439.5,2.5,6150.5,5817.5,745,1256.5,29136,19726.5,52.5,648,4899,4.5,5174.5,7112,7869.5,6522.5,588.5,20.5,4791,1243,17.5,14883,29487,30603,88.5,74.5,441.5,1276,1348.5,5217,2335,3015.5,5550,2.5,2433,9751,8282.5,5731,4.5,6566,70,907,532.5,741,12.5,10458,1352,3353.5,2718.5,15069.5,10.5,0.0019627798,17.5,24004,27528,29573.5,76.5,26.5,58.5,91,617,606.5,2068.5,1.5,849.5,1135.5,6318,6573.5,2153.5,2415,1472.5,5458.5,2.5,2.5,4060,4228,2731.5,2243,0.025875866,10979,1.5,7315,1.5,4.5,10296.5,9448.5,6583.5,1.5,83.5,99.5,376,719,19.5,885.5,710,1330.5,1299,1206,7117.5,18.5,18.5,20,2227.5,3548.5,15.5,0.00884699,20.5,26787,-0.0008123784,17,16.5,3180,18.5,3179,27312.5,26926.5,29436,30107.5,99,105,46,5.5,4.5,65,87,119.5,-0.022330154,1023,459,2.5,681,-0.020825908,0.010066081,4.5,29302,893.5,1679.5,3196.5,4772,7010.5,5997,3142.5,1021.5,3307,4118,5208,921.5,1435,5695,7466.5,6522.5,6522.5,0.00014092236,0.009049587,1.5,1.5,3.5,9709.5,3499,6841.5,5557,4.5,0.002467138,-9.664069e-05,3691,5681.5,5172,1.5,8460,6992.5,0.01867645,5.5,9098.5,2.5,6658.5,10296.5,6590.5,4.5,7715,9123.5,39.5,28.5,18.5,102.5,-0.06299308,445,385,20.5,0.014266426,324.5,655.5,19.5,0.0016131813,-0.013699393,896.5,1514.5,2368.5,1757,1294,1748.5,5027,13,7.5,10576.5,1977.5,-0.012885389,17.5,0.056103583,12.5,2232.5,5845.5,15091.5,13.5,0.005965569,-0.0060086558,21.5,2599.5,0.0022974247,0.00051919976,-1.4916719e-05,3180,0.0034663975,19.5,-0.0066676326,12.5,-0.007924505,18.5,2780,17.5,-0.011811134,29818.5,28394.5,14.5,-0.0036926267,0.0028095723,31129,0.0016104572,-0.0085978545,-0.022714533,-0.0017874538,-0.010776142,-0.035875153,-0.014107481,-0.028730882,0.026841795,0.016142566,0.0046918136,0.018738393,0.002256095,-0.01162818,0.013390302,0.0014724082,-0.054415442,-0.027380401,-0.005208124,-0.0193597,-0.011548924,0.002486021,-0.0019236263,-0.006683805,0.0023713594,0.00390718,0.0006411627,-0.018287163,0.014775916,0.006014244,-0.025743363,-0.013079109,-0.005504126,0.00056945946,0.006349293,0.013742054,-0.01257846,0.003934281,-0.0159927,0.0013065556,-0.0010832669,0.0033928086,0.012971376,0.0008920814,0.031459596,-0.009698126,-0.00011036671,-0.022723194,0.0044203964,-0.00039146282,0.009430766,0.002521798,-0.013845918,-0.0012037805,0.0065319734,0.0011659313,-0.0022319998,0.007119277,-0.007974556,-0.0020587083,-0.0023360967,0.0020219584,-0.0058444063,-0.0094995415,-0.023076791,-0.008669938,-0.0062864325,-0.001853548,-0.0076637226,-0.001486556,-0.00350296,-0.016371258,-0.0035451453,-0.015206004,-0.0005913259,-0.009707169,7.753845e-05,-0.0028300532,-0.008819513,0.013764872,0.004340585,0.011887039,-0.014482957,0.0019922813,0.008463687,0.0014417934,-0.019540137,0.0049505406,-0.01725938,-0.0022369826,-0.002937526,0.004794968,-0.001619377,-0.011967399,-0.0027873076,0.0025765835,-0.0108886575,-0.0011769688,0.010870897,3.284626e-05,0.03341832,-0.008955949,-0.0063680643,0.008357745,0.010439032,0.0005306178,-0.0022856754,-0.00039862786,0.0015802458,-0.0016723495,-0.025502328,-0.0060805744,0.0070973313,0.015874987,-0.029069906,0.0024281158,-0.027977407,-0.018268457,-0.017879821,0.00046322122,0.0075149685,-0.0048059463,-0.0016131288,0.006693033,0.0038470563,-0.007124658,0.004548683,0.018954797,0.08821683,0.034734808,0.03248049,0.004846737,0.005862454,-0.017158786,-0.02604391,-0.010226618,-0.016254103,0.004133656,-0.022051018,-0.0063533457,0.001207188,0.0028781977,0.00441873,-0.0077512,8.461277e-05,-0.0019479245,-2.2437656e-05,-0.0010026101,0.010512177,0.0008593145,0.008954824,0.017527428,-0.009980514,0.0012902494,0.0195462,0.0022861108,-0.005235715,-0.0024618406,-0.0008622987,-0.001986171,0.0028807714,0.00046529417,0.0007040587,-0.0014681167,0.0029716927,0.008796806,-0.00043965183,0.0002755431,-0.0018947043,0.0030243334,-0.00038759864,0.0056741806,0.0016594917,0.00634012,-2.6498235e-05,0.001301891,-0.0038355214,-0.0010933195,0.0022980643,0.0013225641,0.0010975733,-0.0007587324,-0.0014660837,-0.0023914722,-0.0003471306,0.00037008428}, {8,4,5,1,5,4,1,0,8,4,6,5,5,4,0,1,3,3,8,6,7,2,7,4,8,3,4,8,0,5,7,0,0,1,3,2,5,3,5,4,8,3,4,0,6,8,7,7,6,0,2,8,3,5,4,0,1,8,255,8,1,4,1,6,7,3,1,0,1,4,8,7,3,6,3,2,1,0,1,8,8,1,1,7,7,255,0,8,5,8,8,4,0,5,8,6,6,1,5,8,3,4,3,0,1,1,8,8,8,5,5,8,255,8,0,255,8,8,0,8,0,2,3,1,5,2,7,6,8,8,0,0,0,255,2,0,8,0,255,255,8,0,5,6,5,6,6,6,4,1,6,4,5,1,1,7,2,0,0,255,255,8,8,8,0,5,4,0,8,255,255,1,6,6,8,5,4,255,8,6,8,6,4,1,8,6,6,0,1,8,7,255,5,1,8,255,0,0,8,255,255,0,2,6,0,0,6,0,8,8,2,0,255,8,255,8,5,2,2,8,255,255,8,6,255,255,255,0,255,8,255,8,255,8,2,8,255,0,5,8,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,65535,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,65535,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,65535,221,223,65535,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,65535,259,261,263,265,65535,65535,267,269,271,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,65535,65535,305,307,309,311,313,315,317,319,65535,65535,321,323,325,327,329,331,65535,333,335,337,339,341,343,345,347,349,351,353,355,357,65535,359,361,363,65535,365,367,369,65535,65535,371,373,375,377,379,381,383,385,387,389,391,65535,393,65535,395,397,399,401,403,65535,65535,405,407,65535,65535,65535,409,65535,411,65535,413,65535,415,417,419,65535,421,423,425,65535,65535,427,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,65535,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,65535,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,65535,222,224,65535,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,65535,260,262,264,266,65535,65535,268,270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,65535,65535,306,308,310,312,314,316,318,320,65535,65535,322,324,326,328,330,332,65535,334,336,338,340,342,344,346,348,350,352,354,356,358,65535,360,362,364,65535,366,368,370,65535,65535,372,374,376,378,380,382,384,386,388,390,392,65535,394,65535,396,398,400,402,404,65535,65535,406,408,65535,65535,65535,410,65535,412,65535,414,65535,416,418,420,65535,422,424,426,65535,65535,428,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({37,26.5,22.5,71,74,119,4639,3438.5,15.5,129,90,-0.028671637,-0.012027981,4462.5,5600.5,29.5,13,-0.015305707,-0.025599679,27,1233,47.5,46.5,4552.5,5590.5,10434,6524,22,18.5,4.5,0.0027956795,78,33.5,154,27038,-0.010822177,-0.033212565,364.5,514,12.5,29386,4400.5,8742,5584,3157,10686.5,6531.5,28.5,22,2.5,21.5,0.013816724,0.008590112,34.5,-0.018858163,43.5,35,16,-0.023654489,17.5,5.5,-0.014702799,-0.0065863575,2.5,11,7.5,3246.5,8284.5,31979,2924,4615.5,4.5,3952,1542,5734.5,-0.030624935,10962,6151,6413.5,10441,2.5,27.5,5.5,15.5,4.5,-0.0046757963,16,24,-0.0005210479,26.5,56,47.5,60,1118.5,4.5,7.5,-0.013896574,4.5,14274,0.0010748532,-0.0020108966,0.023537938,0.012435409,0.006667152,16,2.5,1320.5,1281.5,7496.5,19.5,5110.5,-0.024626592,-0.012968379,827.5,3417,3380,5622.5,6361,5610,18.5,18.5,2622.5,15.5,17.5,5777,3943.5,11432,9239,6499.5,6377,9996,12.5,12604.5,12125.5,31339.5,-0.001974543,-0.008392004,0.0013239223,0.0042945636,-0.0018586656,0.0030638732,0.004222829,0.0099815475,0.0022267317,-0.0015730391,0.008172511,0.015440799,0.002568388,0.009863423,0.022193031,0.0028691485,0.00091543235,0.0056404965,0.017485602,0.006857653,-0.020672927,-0.0070664557,0.018134132,0.0017163163,-0.00050235074,-0.0025570516,0.0029142192,0.0057234666,0.0036122394,-0.004023003,0.002992387,-8.62832e-05,-0.0038028227,0.0007746596,-0.0014018536,-0.008667071,-0.00048338372,0.004821058,-0.0023158246,-0.012789302,0.0024477968,0.010039658,0.012829539,-0.000103874096,-0.024219764,-0.010492294,0.0025366403,-0.0026482407,-0.004514096,-0.0009035037,-0.008731516,-0.0049597546,-0.005599616,-0.0015493011,0.001684768,-0.0015547518,-0.0020064383,-0.0047114147,-0.006509234,-0.015479565,-0.000351463,-0.018346723,0.00093436235,0.00329056,0.0021776364,0.014304615,0.015316536,0.020549132,-0.006325919,0.0024193083,-0.011956807,-0.003366572,0.0009238878,-0.0049269306,-0.0144623695,-0.004244404,0.014277485,0.0009066322,0.004892932,-0.00064302055,0.026627395,0.016092693,0.00575255,0.0022694732,0.0033222567,-7.196569e-05,-0.00062772946,-0.0017210592}, {2,6,3,0,4,0,7,4,8,0,5,255,255,6,3,0,8,255,255,7,0,5,0,1,2,6,3,6,8,8,255,0,2,0,0,255,255,4,0,8,0,2,6,3,4,4,3,2,0,8,8,255,255,0,255,0,2,8,255,8,8,255,255,8,8,8,0,1,0,5,4,8,5,1,4,255,4,1,5,0,8,0,8,8,8,255,8,2,255,0,0,6,0,6,8,8,255,8,0,255,255,255,255,255,8,8,2,1,2,8,0,255,255,0,1,3,6,6,2,8,8,2,8,8,0,5,6,6,2,7,2,8,0,0,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,65535,23,25,27,29,65535,65535,31,33,35,37,39,41,43,45,47,49,51,65535,53,55,57,59,65535,65535,61,63,65,67,69,71,73,75,77,79,81,83,85,87,65535,65535,89,65535,91,93,95,65535,97,99,65535,65535,101,103,105,107,109,111,113,115,117,119,121,123,65535,125,127,129,131,133,135,137,139,141,65535,143,145,65535,147,149,151,153,155,157,159,65535,161,163,65535,65535,65535,65535,65535,165,167,169,171,173,175,177,65535,65535,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,65535,24,26,28,30,65535,65535,32,34,36,38,40,42,44,46,48,50,52,65535,54,56,58,60,65535,65535,62,64,66,68,70,72,74,76,78,80,82,84,86,88,65535,65535,90,65535,92,94,96,65535,98,100,65535,65535,102,104,106,108,110,112,114,116,118,120,122,124,65535,126,128,130,132,134,136,138,140,142,65535,144,146,65535,148,150,152,154,156,158,160,65535,162,164,65535,65535,65535,65535,65535,166,168,170,172,174,176,178,65535,65535,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6.5,4617,19425,686,6477,15091.5,17581.5,513.5,2.5,8267.5,11894.5,15.5,18439.5,17237.5,18439.5,99.5,471.5,5005,4.5,2.5,1.5,1.5,15328,13771,10965.5,7983,21896,16276,22447.5,24856,19493.5,32.5,92.5,574.5,351,1418,1.5,2365.5,1885,5611.5,2299.5,23825.5,6683.5,8115.5,11631,6992.5,15498.5,48.5,12585.5,11196.5,12377,18298.5,18187.5,13486.5,21868,3087.5,25493.5,26220,20428,18431.5,0.011592597,19840,23869,83.5,27,1693,217.5,314.5,1023,4.5,938.5,1336.5,1987,3672,10736.5,1225,2789,1348.5,4198,5025.5,11113.5,5367.5,6636.5,5430.5,-0.0023717813,1816,7334,8213.5,6698.5,10410,7278.5,1.5,1.5,13020.5,17149.5,30,2330.5,6383.5,15491.5,3712,11297,11298,12585.5,14415.5,17578.5,16024,15557.5,11986,18996.5,17311.5,27377.5,16,17.5,25981,25078.5,0.017445864,24617,15.5,31756,-0.014544879,17910,16076.5,15.5,24222,23109.5,132,279.5,29.5,30,106.5,4999,71,415.5,-0.0056385985,-0.021248037,-0.04868534,-0.020958954,324.5,-0.012421074,3711.5,-0.024205709,1619,1405,3823.5,3332,3158,3697,6231.5,26883.5,1240.5,2268.5,3772.5,5908,904,1155,2789,5090,5988,8970,6506,11216.5,1577,4.5,6317.5,4.5,4972,15600,3.5,5846.5,5713.5,5781,5541,6797.5,6295,8220.5,8988,8364,7158.5,12254.5,8308.5,9571.5,11526,11994,15120.5,2.5,14374.5,20653.5,36.5,41.5,1348.5,3112.5,2867,11241.5,14611,14622.5,3846,18.5,10550.5,-0.010941333,9910,3524.5,10375.5,18964,15265.5,5787.5,-0.014106557,-0.00792985,12.5,18029,20716,16915,12.5,24955,18771.5,-0.016898992,22027.5,21192.5,15.5,30403.5,0.0147922905,0.0045217043,9023.5,19.5,-0.010797345,-0.0030937425,16.5,17.5,0.009819163,0.0042152414,26297,20826.5,15.5,-0.0029930947,15,-0.005771069,13,-0.008879465,22089.5,15294,19232,22791,15.5,19613,0.000822193,-0.018381907,-0.021274261,0.0018130292,0.0007195193,-0.017545156,0.00039317092,0.012498191,-0.032446243,-0.019299723,-0.0016765887,-0.00931211,-0.0012350881,0.0074630803,-0.005799415,0.0049393,-9.023723e-05,0.0052734246,-0.013583163,-0.005025551,0.004274679,0.00043751157,0.0054574315,0.030374987,-0.015140544,0.021605758,0.0022165074,-0.0033743724,0.0029498595,0.009518034,-0.00839569,0.0040768515,0.004091194,0.00055423926,-0.0020741338,-0.006503787,0.0018733876,-0.012064441,0.018657355,-0.0018230362,-0.0041481135,0.001337658,0.0049099065,-0.000423406,0.013650589,0.0010785614,-0.014769514,-0.0026608713,0.0011635096,0.0045364327,-0.0058014663,-0.00072643365,-0.0066382154,-0.002446982,0.003478758,-0.004448664,-0.0012441393,-0.009705233,0.015873581,-0.0003447384,0.0023447236,-0.018895162,-0.0053051803,-0.0023460158,-0.00019938264,0.004930393,-0.0067131035,4.0497358e-05,0.0034466076,0.0068409005,0.011344927,0.0032069285,-0.000194679,0.0016490007,0.012185748,0.00016794608,6.752638e-05,-0.013603303,0.0004086967,0.0050882967,0.0057530706,0.012174981,0.006737633,-0.010150292,-0.013940282,-0.00106778,-0.014797238,0.004923105,-0.00073113467,0.0015404982,0.0017846752,-0.01081551,0.004401895,0.021839773,-0.014345015,-0.003447111,-0.010053665,0.005985629,0.0030728576,-0.009758102,-0.007352996,0.014627076,-0.006110009,-0.0116423,0.023191566,0.010189351,0.00520293,-0.0068576904,-0.0004292043,-0.008013515,0.0025120182,-0.00018634401,0.0007182833,-0.017414927,0.008058314,0.003787315,-0.001324973,-0.0042936737,0.0016516264,-0.001907835,-0.009203683,-0.003203258,0.0026735105,0.009705927,-0.0035927517,-0.01036002,0.004024509,-0.0044110115,0.0009401161,0.011437201,0.00041421616,-0.001467632,0.003156624,0.01746504,-0.00011188003,-0.011089171,-0.0028280774,-0.008361893,-0.0011606284,0.006763159,-0.010190441,0.0018561553,-0.010535396,-0.0049427603,-0.0034750868,-0.001309144,-0.003526299,-0.010188027,-0.013935663,-0.008198428,-0.005430148,-0.01689875,0.01744293,-0.0073440224,-0.0026538065,-0.0071256333,0.0040659304,-0.0017912226,0.018220149,0.006768785,-0.0040972047,0.011009461,0.025768593,-0.0017022033,0.014671865,0.007755934,0.007487052,0.004312377,0.0021934183,0.0060588922,-0.008093965,0.0014077061,-0.0012462423,0.0026459666,-0.0030848281,-0.0014086096,0.013032575,0.008585698,0.0066514723,0.0007154217,0.005034472,-0.000598931,-0.00025659,-0.0023156402,-5.3763604e-05,-0.0009698758,0.0014288416,0.005219934,0.004236219,0.0018792298,-0.0124711795,-0.0076796077,-0.0003356222,-0.002714822,0.010399238,0.0025880325,0.0028401536,-0.00045547928}, {8,2,3,5,3,2,7,4,8,5,4,8,2,6,7,4,1,5,8,8,8,8,6,0,4,5,2,0,6,3,4,5,5,0,7,4,8,5,1,3,1,4,0,2,4,1,6,2,3,5,0,4,6,3,5,2,0,2,1,0,255,3,2,6,1,0,4,0,2,8,7,7,7,2,7,2,3,2,3,3,4,2,1,3,255,0,0,6,7,0,7,8,8,3,6,3,1,3,3,0,6,2,3,4,0,0,1,7,3,1,0,8,8,2,2,255,4,8,0,255,7,0,8,7,4,2,6,0,6,4,0,6,5,255,255,255,255,3,255,2,255,0,2,4,4,4,3,4,3,0,1,5,1,5,3,3,5,2,2,2,4,3,8,3,8,2,5,8,2,2,7,6,0,1,2,3,3,5,5,3,3,5,5,0,8,1,0,2,6,2,4,7,7,0,2,1,8,6,255,3,5,7,7,2,3,255,255,8,3,6,1,8,6,1,255,7,0,8,0,255,255,0,8,255,255,8,8,255,255,0,3,8,255,8,255,8,255,6,0,0,6,8,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,65535,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,65535,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,65535,227,229,231,65535,233,235,237,239,241,243,245,247,249,251,253,255,257,65535,65535,65535,65535,259,65535,261,65535,263,265,267,269,271,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,323,325,327,329,331,333,335,337,339,341,343,345,347,349,351,353,355,357,359,361,363,365,367,369,371,373,375,65535,377,379,381,383,385,387,65535,65535,389,391,393,395,397,399,401,65535,403,405,407,409,65535,65535,411,413,65535,65535,415,417,65535,65535,419,421,423,65535,425,65535,427,65535,429,431,433,435,437,439,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,65535,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,65535,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,65535,228,230,232,65535,234,236,238,240,242,244,246,248,250,252,254,256,258,65535,65535,65535,65535,260,65535,262,65535,264,266,268,270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,326,328,330,332,334,336,338,340,342,344,346,348,350,352,354,356,358,360,362,364,366,368,370,372,374,376,65535,378,380,382,384,386,388,65535,65535,390,392,394,396,398,400,402,65535,404,406,408,410,65535,65535,412,414,65535,65535,416,418,65535,65535,420,422,424,65535,426,65535,428,65535,430,432,434,436,438,440,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({3622.5,2857.5,6227.5,2355.5,1290,4936.5,11386,2478.5,902,5533.5,18.5,4928,6640.5,9407.5,11023.5,2600.5,21.5,18.5,2842,18.5,4.5,15.5,1374,5664,18,5623.5,7804,9692.5,9547,13032.5,19425,37.5,1759.5,50,2600.5,3035,1314.5,2199.5,4061,4.5,1524,8429.5,15.5,6.5,1994.5,5645,5140.5,3655.5,1578.5,0.008411216,0.047366634,5166,5858,6691.5,7880.5,9595.5,8787,7258.5,9556,17.5,10550.5,21809,17581.5,145.5,22.5,1169,4.5,5167,20.5,0.06596565,1964.5,15.5,6.5,0.040369704,0.015031382,18.5,2535.5,17.5,7.5,1524,12.5,3037.5,20.5,-0.002346645,0.005254371,2780.5,2780.5,4568,6060,16.5,2149,20.5,-0.003094401,2860,9415.5,18,3676,-0.024211219,5755,4923,4949,5756,5802.5,6556,5555,6879.5,7774,6302,6196,7976,10145,9363,8794.5,14.5,10300,4.5,10818,9723,0.015559665,20271,19004.5,17237.5,20870,121.5,18.5,107.5,43.5,-0.033722725,2528.5,2.5,12.5,17.5,-0.01757301,6309.5,2609.5,6935,3736.5,7,-0.004601162,0.0045286235,0.0080759665,2358.5,3286,18.5,3129,1607.5,-0.016251856,4793.5,4164,-0.015975945,2.5,3009,942.5,-0.0062277517,-0.02003478,0.004384441,1603.5,12.5,12.5,5254,19.5,2.5,2402.5,4593.5,8632,1412.5,3050.5,7684.5,2494.5,0.020503607,0.008592719,2338,3385,6750.5,10941,3549.5,3549.5,2284.5,3839.5,17.5,5818.5,4419.5,5320,3800,5565.5,5656,6582.5,-0.032624386,5536,0.006960321,0.038757678,8096,7726.5,7816.5,7818.5,7268,5835,4652,3172.5,0.0011255331,9827,7841,8050,17.5,-0.018422337,7792.5,6350,9541,11439.5,5246,15.5,10038,14873.5,13156,10818,8910,0.011557507,0.006519455,4.5,21851,22384,22330.5,-0.021470528,21607,29189,18454,19628,0.0009919712,0.024769345,-0.015901068,-0.050860953,-0.019365856,-0.0033222956,-0.0038103757,-0.0006650333,-0.014041719,-0.026639942,-0.01186449,0.022920733,-0.018822817,0.0022863157,0.0008775919,-0.010822069,0.00069241604,0.0057108584,0.036723513,0.0039463765,-0.010281535,0.0032643415,0.027209569,0.0020301652,-0.0021135597,0.0013479544,0.004867138,-0.0007704358,-0.008521681,0.033342164,0.010288509,0.045764647,-0.0012800827,0.009440064,-0.019536484,-0.0029127642,0.006290904,0.0015711278,0.002455746,-0.0012859552,-4.675163e-05,-0.0076329717,-0.009742815,-0.020982658,-0.006522806,-0.017369969,-0.007291199,-0.0011978066,-0.0022054596,-0.01007542,-0.009913285,-0.003052406,-0.0020962718,-0.006971807,0.0066207894,0.00086434477,-0.0027819963,0.0029232057,-0.0030781257,-0.00067263696,-0.005963528,-0.0013715733,-0.0015542553,-0.0030922573,-0.0028126386,-0.010454389,-0.0129490215,-0.0013391796,-0.003645708,0.0058455733,-0.020841278,-2.684352e-05,0.0070731044,-0.0053934674,-0.016914073,-0.006445491,-0.0019321177,-0.004183659,0.0009271106,0.004117158,0.0081808455,0.014539495,0.002589943,0.0009296964,0.008076226,-0.0023785757,0.009741257,0.0015088131,0.006658116,0.014367639,0.004528958,-0.013653797,-0.0031044974,0.013526037,-0.027917514,-0.008348173,0.0014451356,-0.003547873,0.007818006,-0.00082651945,-0.026957741,-0.009497474,0.0003182777,-0.02457437,-0.006821575,-0.01842901,0.0067516426,0.0007928974,-0.008073534,0.008092435,0.0025167107,-0.006776123,-0.011013831,-0.024983099,0.0005536414,0.009866634,-0.006573532,-3.6245354e-05,-0.00071064685,0.0028085501,-0.023436245,-0.002088878,-0.038338296,-0.022996267,0.0011452936,0.0037662468,0.013011664,0.006982494,0.0001552491,0.0035243556,0.0023974353,-0.017777566,-0.01255232,-0.0043401215,-0.014378342,-0.029468536,-0.039417632,-0.0073809414,0.0010596146,0.019159434,0.0061548958,0.0019022342,-0.0023821767,-0.022466376,-0.0001807748,-0.0031751692,0.0025107262,0.0076199807,-0.00067223806,0.01027873,0.0050580013,0.002879454,0.006177678,0.0034920964,-0.00024381488,-0.0022030114,-0.013494699,0.0042853397,0.015155557,0.008308818,-0.0111531755,-0.00032709775,0.0073288972,0.0012816356,0.0009157179,-0.007455164,0.0025033262,-0.0003609418}, {3,2,6,3,5,0,3,7,6,0,8,0,1,2,2,6,8,8,0,8,8,8,5,6,8,5,0,3,2,3,3,4,5,0,6,0,4,0,0,8,3,0,8,8,1,0,0,3,0,255,255,4,6,1,0,3,2,5,2,8,6,5,7,2,5,2,8,6,8,255,5,8,8,255,255,8,0,8,8,3,8,2,8,255,255,1,1,2,2,8,1,8,255,3,1,8,5,255,2,5,5,5,1,0,7,2,1,5,0,2,0,0,1,8,2,8,0,6,255,1,3,6,2,3,8,2,5,255,2,8,8,8,255,1,6,6,4,8,255,255,255,2,3,8,1,4,255,7,7,255,8,2,4,255,255,255,0,8,8,2,8,8,1,5,4,7,2,0,4,255,255,6,6,0,0,0,0,4,5,8,3,5,5,3,5,0,1,255,0,255,255,3,3,0,0,1,5,5,1,255,0,1,2,8,255,1,7,2,4,0,8,1,0,7,0,4,255,255,8,0,0,0,255,1,4,2,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,65535,65535,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,65535,135,137,139,65535,65535,141,143,145,147,149,151,153,155,65535,65535,157,159,161,163,165,167,169,65535,171,173,175,177,65535,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,65535,219,221,223,225,227,229,231,233,65535,235,237,239,241,65535,243,245,247,249,251,65535,65535,65535,253,255,257,259,261,65535,263,265,65535,267,269,271,65535,65535,65535,273,275,277,279,281,283,285,287,289,291,293,295,297,65535,65535,299,301,303,305,307,309,311,313,315,317,319,321,323,325,327,329,65535,331,65535,65535,333,335,337,339,341,343,345,347,65535,349,351,353,355,65535,357,359,361,363,365,367,369,371,373,375,377,65535,65535,379,381,383,385,65535,387,389,391,393,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,65535,65535,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,65535,136,138,140,65535,65535,142,144,146,148,150,152,154,156,65535,65535,158,160,162,164,166,168,170,65535,172,174,176,178,65535,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,65535,220,222,224,226,228,230,232,234,65535,236,238,240,242,65535,244,246,248,250,252,65535,65535,65535,254,256,258,260,262,65535,264,266,65535,268,270,272,65535,65535,65535,274,276,278,280,282,284,286,288,290,292,294,296,298,65535,65535,300,302,304,306,308,310,312,314,316,318,320,322,324,326,328,330,65535,332,65535,65535,334,336,338,340,342,344,346,348,65535,350,352,354,356,65535,358,360,362,364,366,368,370,372,374,376,378,65535,65535,380,382,384,386,65535,388,390,392,394,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({11054.5,8425,10749,8797.5,7959,18.5,1159.5,3194,7569,7950.5,11353,4.5,10674,611,15.5,74.5,3919.5,4.5,9239,9058,18.5,9972.5,11518,10674,13032.5,10699.5,0.010536216,6.5,-0.023368843,17686,22551.5,28,70.5,2830,8211,8169.5,22,7657.5,7894,18.5,8153,0.03888163,0.019814676,10181,6001.5,9817,28583,10346,0.011490877,8635,10622,6569,10546.5,-0.0013953097,-0.0036643872,12975,20703.5,21600.5,17389,76.5,39,107.5,553,3077.5,5328.5,5600.5,7894,7437.5,8776.5,18.5,15.5,12.5,0.012925399,11.5,8617,8429,11708.5,7222.5,15806.5,8915,8017,12682.5,1.5,0.015819062,0.0302067,8527.5,20281.5,9122,11554.5,13026,15.5,3149,0.01310422,5642,11824.5,31563,10622,14962.5,1.5,17730.5,18628.5,18693,17420.5,17520.5,30102.5,132,147,30,27,139.5,40.5,552,643,18.5,3913.5,5011,5573.5,5599,9098.5,5874.5,7230.5,2.5,0.0028948034,5981.5,12308.5,11,-0.016093617,12.5,7961,0.009766224,15.5,8461,7334.5,12,16.5,8708,10271,4555.5,11862.5,6956.5,6842.5,2.5,26539.5,7049.5,8637.5,-0.025747342,10951,17,3.5,11186,10361,8237.5,12348.5,-0.017798899,31637.5,0.008466677,10325,1.5,10550.5,9122,7208,10818,10818,17.5,12034.5,1459,0.0018561081,11380,11845,12221.5,3126.5,0.0062451684,0.012497686,12479.5,21985.5,32357.5,20175.5,11259.5,21607.5,21858,13279,14051.5,18172,20867,21319,19812,28355.5,25886,24637.5,0.00040791775,-0.019109601,-0.017082017,0.0020655266,0.011824378,0.00052908267,0.003576135,0.007933888,-0.027266687,-0.011259725,-0.007493593,-0.019336043,0.00048629814,0.013614903,-0.017468026,-0.0015313495,0.004334658,-0.0047320514,0.011225186,0.0021554732,0.00024739487,-0.013140395,0.016412662,0.0018816453,-0.000387847,0.020654684,-0.0034621258,0.0032171842,0.0027658187,0.013098699,-0.00100239,-0.025078667,0.0072652563,0.0051018163,0.00069802994,-0.002701704,0.0048324973,0.003211266,-0.0003459806,-0.002208402,0.0008524034,-0.002854615,0.0028639927,-0.000844506,0.0023775874,0.004433314,0.0060718167,0.000686043,0.006509381,0.0010829327,0.014194988,0.007483424,0.0050736107,0.009844413,-0.0013570016,-0.024405675,-0.0020052034,-0.00045893362,-0.0064916494,-0.0011172217,-0.009669771,-0.0042921393,0.0008307946,0.007212034,-0.0063452953,-0.025851239,-0.0072922627,0.016410032,0.0062231743,0.0035453446,-0.0061283004,-0.03282394,-0.0053780093,-0.017972833,0.0029284633,-0.026924444,-0.0010521534,-0.005402505,-0.011518473,-0.007823608,-0.0019546947,0.007139943,-0.045118954,-0.029266415,-0.0023645244,-0.009973995,-0.008796226,-0.0003847237,0.00070384145,-0.0063967765,0.001828437,0.0044593927,0.008209917,-0.0032494252,0.0058430484,0.009492409,0.0039030414,0.00058946834,-0.00085619773,0.0053979894,-0.0012162247,0.00869929,0.0009427801,0.009027062,0.0005765501,-0.009131691,0.005482157,0.00268013,-0.0004696849,-2.2269958e-05,0.006058205,0.00850765,0.0015786045,0.0042590764,0.0032818578,-0.0046169017,-0.007043435,0.0038894378,0.0006467779,-0.0042489325,0.02394161,-0.0010823095,0.011081699,-0.002871835,-0.009236416,0.0023812086,0.0005887441,0.010986156,-0.009716581,0.0006615317,0.016471185,0.004487468,-0.0027655857,-0.000146293,0.0015000893,-0.008622602,0.007866512,-0.010371345,0.019598981,-0.0049703843,0.0048794723,-0.0018563744,0.0027714681,-0.0070728147,0.01109509,0.0030059011,-0.0052746837,-0.00079255406,-0.0010471069,-9.391209e-05}, {3,2,2,3,5,8,0,5,0,5,6,8,0,0,8,4,6,8,1,3,8,0,6,0,3,5,255,8,255,6,7,5,5,0,2,4,6,0,2,8,4,255,255,3,7,0,6,6,255,4,2,0,2,255,255,1,4,0,1,6,6,4,2,3,3,3,3,0,6,8,8,8,255,8,0,2,6,5,0,4,0,0,8,255,255,5,2,5,3,7,8,0,255,1,1,1,2,0,8,5,6,0,1,0,7,2,0,4,0,7,5,3,3,8,3,3,2,3,1,5,7,8,255,0,5,8,255,8,2,255,8,0,2,8,8,0,0,3,6,4,6,8,0,6,0,255,4,8,8,1,0,3,6,255,4,255,2,8,6,5,0,0,0,8,7,0,255,7,1,4,6,255,255,5,0,3,4,5,7,0,3,1,1,2,6,4,4,6,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,65535,53,65535,55,57,59,61,63,65,67,69,71,73,75,77,65535,65535,79,81,83,85,87,65535,89,91,93,95,65535,65535,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,65535,131,133,135,137,139,141,143,145,147,149,65535,65535,151,153,155,157,159,161,163,65535,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,65535,223,225,227,65535,229,231,65535,233,235,237,239,241,243,245,247,249,251,253,255,257,259,261,65535,263,265,267,269,271,273,275,65535,277,65535,279,281,283,285,287,289,291,293,295,297,65535,299,301,303,305,65535,65535,307,309,311,313,315,317,319,321,323,325,327,329,331,333,335,337,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,65535,54,65535,56,58,60,62,64,66,68,70,72,74,76,78,65535,65535,80,82,84,86,88,65535,90,92,94,96,65535,65535,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,65535,132,134,136,138,140,142,144,146,148,150,65535,65535,152,154,156,158,160,162,164,65535,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,65535,224,226,228,65535,230,232,65535,234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,65535,264,266,268,270,272,274,276,65535,278,65535,280,282,284,286,288,290,292,294,296,298,65535,300,302,304,306,65535,65535,308,310,312,314,316,318,320,322,324,326,328,330,332,334,336,338,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4339.5,773,4543,637,890,4515.5,5432.5,1371,433,18.5,4.5,4510,4517.5,11223.5,5510.5,43.5,2696.5,374.5,692.5,961,954.5,2.5,12.5,4422.5,4811,11.5,4539,9743.5,11369,5573.5,11047,77,546.5,2.5,6,-0.060552817,405.5,2457,17.5,442,849.5,650,21.5,1021.5,2268.5,2271.5,3825.5,1990.5,12.5,4.5,5234,-0.010293134,-0.023273058,9.5,4,6591.5,12.5,1168.5,1.5,5643.5,8534,8855,10597,114.5,107.5,44.5,579,26.5,18.5,4.5,13.5,18.5,15.5,798.5,17.5,598,669.5,958,0.013496659,8.5,6.5,-0.009759603,21.5,876.5,0.015902007,1353,3714.5,1416,2545.5,1320.5,3007.5,921,4636.5,6035.5,3975.5,4.5,7646.5,4571,4429.5,12.5,8316,4.5,2814,-0.0050715227,-0.017671501,4575,8007,5182,9733,-0.020691825,11343.5,31701.5,127.5,-0.037374772,7035.5,5518.5,4,8743,10734.5,17.5,13824.5,78,24.5,95,40.5,29.5,50.5,15.5,2.5,0.010515081,-0.011548415,15.5,26.5,0.001052875,0.0002699518,0.00509135,0.0015786517,-0.037464432,-0.009949053,802.5,-0.02787654,18.5,374.5,2765,544.5,688.5,701,-0.026705815,21.5,7.5,16.5,0.0014241717,17.5,1.5,11.5,732,0.06434161,20,-0.018244294,846,1221,1913.5,5987,2656.5,1325.5,29302,4773.5,1931.5,6.5,2816,3414.5,1029,848.5,5338,19,7573,6966,5785.5,6.5,2.5,8.5,0.0060772947,15.5,0.010768375,4212,4638.5,9,7348.5,4866,3944,11732.5,2814,2814,-0.010962054,14.5,-0.019138534,3592,8893.5,318.5,9033,4.5,7889,8475.5,4.5,11441.5,29150,-0.004119023,31520,28545,5594.5,0.006543282,1.5,0.011022238,11239,6,6143.5,11099.5,8898.5,11724.5,4.5,6276.5,1.5,20670.5,0.00089509407,-0.0041868007,-0.023098275,-0.0135726435,-0.009065589,-0.02723066,-0.0076671713,-0.021608444,0.0036574502,-0.0065719048,0.011515123,0.0029846283,-0.013466484,-0.025895664,-0.0015409839,0.0027008718,-0.013855341,-0.021341415,-0.0014102649,-0.018514672,-0.010036269,-0.021605564,-0.0073620365,-0.0282771,-0.009355697,-0.03462271,-0.009146758,-0.0058755293,0.0028123513,-0.004799134,0.00011326341,-0.009158515,-0.0052666734,0.00059769175,-0.01354527,0.00015297238,0.0039896304,-0.00032012066,0.008671212,-0.002385535,0.0036275913,0.00072668766,-7.433029e-05,-0.004164454,-0.00021664076,-0.001291552,-0.006542038,0.03298,-0.0021527463,-0.0006305951,-0.005620199,0.0026484355,-0.024079552,-0.0067842775,0.004806076,-0.0033514414,0.004665003,-0.0009624052,0.004008346,-0.0105806,-0.0054831016,0.022206195,-0.0004872061,-0.010105631,0.0044671637,0.0010943123,0.005099279,-0.008294532,-0.0024440105,-0.014624486,0.005266557,0.00082685886,-0.003123657,0.001017832,-0.0270903,-0.0042188126,0.0073076473,0.0015159772,-0.0012165774,0.00396155,0.009563122,0.02773716,-0.011286393,-0.004391612,-0.0013592881,-0.0039773607,-0.0037771687,-0.0012126667,-0.0035160948,0.0009559163,-0.0011332196,0.008584794,-0.0018317861,0.0017182165,0.0070958207,0.012562575,-0.01457647,-0.0031323058,-0.008089571,0.00043605166,-0.0066272207,-0.022560375,0.005175836,-0.0013571633,0.00071103376,0.009521569,-0.004377323,0.0021072263,-0.015254902,-0.0028580234,0.003859497,0.0012769419,0.0008093877,-0.0025563359,-0.0042540864,-0.0013780211,0.0038163222,-0.00029733495,0.012764861,-0.0019367917,-0.011909107,0.001823454,-0.0040999632,0.0025322277,0.008855737,0.004021145,0.012857327,0.007821389,0.0037092336,0.016509628,0.0042281905,-0.014742054,0.002643145,-0.0043070405,0.006614037,0.0018207784,-0.010989467,-0.00028847472,-0.00052491983,0.0053585838,-0.013783208,-0.008047537,0.0046082595,-0.0005706474,-0.016830077,-0.0009041444,0.01156539,-0.009193665,0.0012857285,-0.001624972,0.0015972041,0.032323483,-0.0029085139,-0.012327417,0.004221867,-0.0014826156,0.002579458,-0.00012346226,-0.00070912874,0.0030614443,0.012365263,-0.0071606184,0.0012815798,-0.0005983703}, {2,1,3,0,0,3,5,2,5,8,8,5,3,2,5,5,3,1,1,2,1,8,8,5,5,8,3,4,3,4,3,4,0,8,8,255,1,4,8,2,1,0,8,1,1,1,0,5,8,8,5,255,255,8,8,7,8,0,8,3,0,2,4,6,4,1,0,0,8,8,8,8,8,6,8,7,6,1,255,8,8,255,8,0,255,2,1,4,7,2,2,0,3,2,7,8,2,5,3,8,2,8,0,255,255,2,6,5,0,255,2,1,4,255,1,1,8,2,2,8,4,0,1,4,5,0,2,8,8,255,255,8,0,255,255,255,255,255,255,0,255,8,1,6,1,0,0,255,8,8,8,255,8,8,8,0,255,8,255,5,7,0,6,6,0,0,1,6,8,0,3,1,7,7,8,0,2,0,8,8,8,255,8,255,1,7,8,0,5,3,0,0,0,255,8,255,4,2,4,0,8,0,6,8,2,0,255,3,1,0,255,8,255,0,8,7,0,1,2,8,4,8,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,65535,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,65535,65535,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,65535,151,153,65535,155,157,65535,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,65535,65535,195,197,199,201,65535,203,205,207,65535,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,65535,65535,239,241,65535,65535,65535,65535,65535,65535,243,65535,245,247,249,251,253,255,65535,257,259,261,65535,263,265,267,269,65535,271,65535,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,311,313,315,65535,317,65535,319,321,323,325,327,329,331,333,335,65535,337,65535,339,341,343,345,347,349,351,353,355,357,65535,359,361,363,65535,365,65535,367,369,371,373,375,377,379,381,383,385,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,65535,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,65535,65535,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,65535,152,154,65535,156,158,65535,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,65535,65535,196,198,200,202,65535,204,206,208,65535,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,65535,65535,240,242,65535,65535,65535,65535,65535,65535,244,65535,246,248,250,252,254,256,65535,258,260,262,65535,264,266,268,270,65535,272,65535,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,312,314,316,65535,318,65535,320,322,324,326,328,330,332,334,336,65535,338,65535,340,342,344,346,348,350,352,354,356,358,65535,360,362,364,65535,366,65535,368,370,372,374,376,378,380,382,384,386,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({2857.5,18.5,3355.5,2274,396.5,3096,31339.5,987.5,551.5,334,310.5,3011.5,3507,3828.5,17199.5,708.5,1137,-0.015584509,2816,87.5,6621,2040,742.5,4.5,15,5049,3677,1018,7590.5,24104,1.5,689.5,1220,1080,1767.5,3129,3145,54,26.5,700,0.0044216802,20.5,3627.5,816,655,2.5,12.5,6.5,-0.04273723,4087.5,2867,3560,7720.5,4558,2102,7456.5,7754.5,-0.021588182,18529.5,21834.5,29878,48.5,441,308,1206.5,308.5,1345,1384.5,2538,2379,3255.5,2685.5,3043.5,26.5,64,38.5,70,348,-0.011046923,288,35,1138.5,25989.5,459.5,921.5,2388.5,891,2273.5,2235,1889.5,2817,-0.01335519,-0.0035506927,16.5,1.5,13.5,18.5,6974.5,1.5,3334.5,7725,21.5,11.5,18.5,2244.5,7451,7544,8065,7823,31864.5,1.5,18936.5,27987,20807,18879.5,78,54,-0.050125297,4792.5,996.5,382,-0.027806222,21484.5,14,5.5,1278,11.5,1142.5,15.5,12.5,3809.5,6.5,17.5,16.5,2346,2681.5,3128,4.5,4.5,76.5,229,0.005978318,0.0116841635,95,0.0021120922,20.5,127.5,-0.008361439,-0.027231086,0.031360116,353,31,0.070143856,2265.5,2723,-0.023798598,-0.0077640563,21.5,560,20.5,21101,0.07796648,20.5,1266.5,799,2101,1856,688.5,2802.5,1222.5,3919,2094.5,2785,3082,3875,5055,3324,3,20,4780,8802.5,7.5,6.5,-0.03155245,15.5,1071,7,7.5,18.5,3967,0.021873048,6485,212,2680,5126.5,5656.5,4104.5,5601,12,7120,8257.5,16.5,6832,5139,7457.5,11329.5,15.5,18842.5,19049,19638,18825.5,22491.5,30449,-0.009904972,28802,32085.5,12.5,0.0019453954,-0.009277252,-0.011893777,-0.00078500126,-0.009845122,-0.0002295674,-0.008745193,0.0037218512,0.0118418215,0.0047647953,0.0014123268,-0.009924448,-0.0027421578,-0.011256232,-0.012164129,-0.029457092,0.013298838,-0.0021266702,-0.012026198,0.0009129355,0.004123235,-0.0025671476,0.008083417,-0.0008472657,-0.012278962,-0.002450799,-0.0026432965,0.0013542761,0.0015592094,0.006601778,0.00012925811,0.007655479,0.010775211,0.016280048,0.009431398,0.0037271623,0.002230277,-0.017267345,0.006534037,0.0028596355,-0.0041364697,-0.0020315964,0.0026078213,-0.00041108235,0.0022745936,-0.01090291,-0.0039212885,0.0034216165,-0.021086192,-0.008605982,0.008630583,-0.0014193546,-0.008112901,-0.00014961678,-0.025261993,0.018908966,0.043101486,-0.040496882,0.000113828355,0.0044483854,0.020925788,0.010690886,0.007598392,-0.008385299,-0.0358523,-0.017288236,-0.004801247,0.020740086,-0.002330535,-0.01799189,0.007059595,0.03855985,-0.04187386,-0.0026865585,0.021503627,0.003366226,-0.0067957416,9.639061e-05,-0.018522693,-0.004928821,-0.0013552129,-0.010421528,-0.0018375026,0.026720608,-0.003413162,-0.017043857,-0.0013563571,-0.010994727,-0.0050509586,0.0023861614,-0.013604333,-0.004404865,-0.010613908,0.00070300366,0.007532084,0.002874274,0.02022509,0.0083674425,0.0073158145,0.0029438776,-0.0042101885,-0.009429914,0.0011622121,-0.0034827273,0.0033124227,0.00055842736,-0.0021842024,0.0006175339,0.00026811418,-0.0053317915,-0.0067626946,-0.011335914,-0.01311401,-0.019407382,0.008008563,-0.0024772503,-0.0060143787,-0.012958787,0.017474448,0.006701093,-0.0007575423,-0.002614448,0.007862131,-0.00021181596,0.0020469648,-0.0046530217,-0.003198354,-0.010265841,0.010960795,0.003457673,0.032084003,0.007170763,-0.022190092,-0.006125688,-0.00029857885,0.0030993028,-0.000230496,-0.0013345546,0.020445472,0.007384711,0.0010447608,-0.02488107,-0.00878588,0.024632532,0.008566417,0.019415434,-0.01573785,-0.031195102,0.011758854,-0.018175896,0.0038675987,-0.00021189176,-0.010546758,-0.002299507,-0.0046487562,-0.0068770424,-0.0025287939,0.00331554,-0.0019029463,-0.0034244785,0.0015390835,-0.0026523639,0.0027797446,0.00551493,-0.003958192,0.0010598771,-0.0021682905,-0.00018290013,-0.002299497,-0.0040198774,8.101085e-05,-0.0021208448,9.504021e-05,-0.00081913325}, {2,8,3,3,1,4,6,2,0,0,6,4,2,6,5,7,3,255,0,6,4,0,2,8,8,6,2,7,7,2,8,6,4,4,4,1,3,7,5,0,255,8,1,1,0,8,8,8,255,4,3,2,2,2,6,7,7,255,1,1,2,2,1,5,5,5,2,4,4,2,1,3,0,5,6,1,4,2,255,2,6,2,0,1,0,6,2,4,4,5,3,255,255,8,8,8,8,0,8,3,2,8,8,8,6,7,6,5,7,6,8,3,1,0,5,0,0,255,0,0,4,255,0,8,8,4,8,4,8,8,1,8,8,8,2,3,4,8,8,0,0,255,255,0,255,8,0,255,255,255,3,6,255,0,0,255,255,8,7,8,0,255,8,5,6,6,1,6,0,3,0,3,4,0,0,1,0,8,8,1,0,8,8,255,8,3,8,8,8,0,255,4,6,4,2,4,2,3,8,6,1,8,2,4,6,0,8,1,7,1,7,1,7,255,0,4,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,65535,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,65535,79,81,83,85,87,89,91,65535,93,95,97,99,101,103,105,107,65535,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,65535,149,151,153,155,157,159,161,163,165,167,169,171,65535,65535,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,65535,221,223,225,65535,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,259,261,263,65535,65535,265,65535,267,269,65535,65535,65535,271,273,65535,275,277,65535,65535,279,281,283,285,65535,287,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,323,325,327,65535,329,331,333,335,337,339,65535,341,343,345,347,349,351,353,355,357,359,361,363,365,367,369,371,373,375,377,379,381,383,65535,385,387,389,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,65535,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,65535,80,82,84,86,88,90,92,65535,94,96,98,100,102,104,106,108,65535,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,65535,150,152,154,156,158,160,162,164,166,168,170,172,65535,65535,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,65535,222,224,226,65535,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,264,65535,65535,266,65535,268,270,65535,65535,65535,272,274,65535,276,278,65535,65535,280,282,284,286,65535,288,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,326,328,65535,330,332,334,336,338,340,65535,342,344,346,348,350,352,354,356,358,360,362,364,366,368,370,372,374,376,378,380,382,384,65535,386,388,390,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4543,3507,5427,2355.5,3576.5,11709.5,6972.5,645,2460.5,3106,3649,4732.5,11.5,5535.5,6979.5,588.5,764.5,2233,2308,15,2572.5,19.5,2464,5572,7776.5,26422.5,4771.5,4483,5722,12.5,6650.5,868,18.5,6121.5,944.5,21.5,18.5,2180,6946.5,-0.012889877,-0.019974228,7,7.5,3606.5,4994,4052.5,18.5,5086,5536.5,7137,18.5,4.5,4780.5,26161.5,5949.5,15.5,5315,5919.5,7253.5,10186,20.5,3386,6783.5,459.5,18.5,500.5,634,477,20361.5,18.5,953.5,3036,2380,6.5,2496.5,3190,17,3582.5,1.5,2,-0.010779361,2.5,4627.5,6353,4994,0.02613745,3615.5,3755,-0.033467114,15.5,8953.5,4599,11441.5,18,4930.5,7039.5,11707.5,7832,7514.5,10225,4614,1.5,6.5,4530.5,0.015145336,18.5,32077,4666,0.01280599,5182.5,5527,7414,1.5,5701.5,9308.5,0.021387605,0.0059788898,0.008480682,0.0025499116,16.5,7183,8419,6803.5,52,20.5,72.5,3651,0.010524018,15.5,630.5,1068.5,868.5,329.5,11.5,-0.018474195,109,1145.5,1457,18.5,18.5,19.5,0.0042165876,2040.5,3453.5,3053.5,21.5,0.04904857,5068,15,3475.5,17586,7.5,3667,6605,7.5,-0.011264454,4.5,4627.5,6.5,12.5,0.002126452,0.007824529,7,7,5525,-0.00038229855,0.0024337114,-0.022365576,4.5,4408,2029.5,3973,9296,-0.012143153,-0.026240787,4685.5,12930.5,7.5,0.02471174,6649,5768,5553.5,6961.5,5576,14177,1.5,5167.5,6888.5,5288,8074,11545.5,6.5,5570,0.003684687,0.0124408705,4809.5,4809.5,12.5,24494.5,5163.5,21.5,2932.5,17.5,12.5,0.011667079,11.5,5519.5,5085,-0.020352531,8670,2461,-0.024976207,5528.5,4081.5,5781.5,7477.5,10317,2388.5,3233.5,17.5,1.5,7256.5,3172.5,0.025974546,7935,-0.00079378387,0.002753883,-0.009058486,-0.03491403,-0.0010332651,0.0017946752,0.021732712,-0.005291579,0.0024362048,-0.0017346388,0.0033221662,-0.0045169867,0.06527256,0.02993676,-0.037774205,-0.015972212,0.0016086651,-0.011036612,0.0017159692,-0.0025266446,-0.0023542342,0.0064663463,-0.004132543,0.008426423,-0.0027472568,-0.029906532,-0.0018384078,0.002191686,0.0029297387,-0.010203108,0.0047005666,0.01395005,-0.016218416,-0.0053508477,0.00093752326,0.0044257357,0.0103863655,0.0055589937,0.0042742835,0.00093761843,-0.018237641,-0.031226298,-0.00045678506,-0.0072001144,0.009071243,0.003417988,-0.013628821,0.0018938096,0.0030538558,-0.00079056405,0.0104244985,0.0029109467,-0.0030634676,-0.017330179,-0.000328097,-0.0047055553,0.0004084337,-0.0027842359,-0.003634318,0.004548912,0.0030265278,0.0005852389,-0.008516487,-0.0039910963,0.0023367212,0.00017960304,-0.0022725724,-0.00031101995,0.005199915,0.0016141193,0.00091113895,-0.006838613,0.000593341,-0.0018066053,-0.0027365086,0.0019517605,-0.0026383805,0.0008219834,-0.016394828,-0.0026398974,-0.004695755,-0.00015730884,-0.00914096,-0.005983766,0.0025738755,0.008231227,-0.021504087,-0.0023874023,0.0063829497,0.0010915779,0.009682569,0.0012987894,-0.006330505,-0.0369219,-0.020426426,0.0076053166,-0.0042831646,0.011413097,-0.020147588,-0.006660137,0.004605055,-0.0008219474,0.027195364,-0.0014308736,0.0069554197,0.0003008472,-0.009257517,-0.00030124746,-0.0010513611,0.0025183817,-0.0028308262,0.0023938678,-0.0059853806,-0.0017713452,-0.00020432321,-0.0030658739,0.0015473443,0.0003006722,-0.00057614385,-0.0076326705,-0.0012682499,-0.0067353235,-0.0073114685,-0.0031087634,-0.011373252,-0.0074931667,-0.0067683132,-0.0022243862,-0.0006519159,0.0036450557,0.0023775038,-0.0014090386,-0.005472325,-0.010114936,-0.03412671,-0.013192094,0.0030018534,-0.0049741925,0.008539433,-0.007830507,0.00040220298,-0.0046355627,-0.0030794602,-0.021953782,-0.006071257,0.004693842,-0.01928134,-0.005818467,0.005972602,-0.00506957,-0.0031104349,8.887112e-05,0.005468216,0.0004680558,0.0030099924,-0.0052676047,0.0051740105,0.008897808,0.009350815,-0.003229924,-0.006056914,-0.021242479,-0.023335641,0.0027132405,0.0025303888,-0.0003870972}, {3,2,7,3,2,4,7,6,2,1,2,5,8,2,7,7,7,4,5,8,3,8,6,1,1,6,3,2,0,8,6,1,8,0,4,8,8,7,6,255,255,8,8,2,0,3,8,2,0,0,8,8,1,0,1,8,2,4,4,0,8,0,2,1,8,2,2,7,0,8,4,1,3,8,3,2,8,5,8,8,255,8,1,0,0,255,2,2,255,8,2,0,2,8,3,0,0,1,0,0,1,8,8,7,255,8,5,0,255,2,2,6,8,3,0,255,255,255,255,8,4,7,2,1,8,7,1,255,8,0,0,0,0,8,255,5,5,0,8,8,8,255,6,5,5,8,255,0,8,0,0,8,5,0,8,255,8,1,8,8,255,255,8,8,0,255,255,255,8,0,1,3,0,255,255,3,2,8,255,0,3,2,1,4,0,8,3,2,2,1,2,8,1,255,255,5,5,8,4,3,8,7,8,8,255,8,3,1,255,2,0,255,0,5,7,5,4,2,0,8,8,1,1,255,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,65535,65535,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,65535,157,159,161,163,65535,165,167,65535,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,65535,199,201,203,65535,205,207,209,211,213,215,65535,65535,65535,65535,217,219,221,223,225,227,229,231,65535,233,235,237,239,241,243,65535,245,247,249,251,253,255,65535,257,259,261,263,65535,265,267,269,271,273,275,277,279,65535,281,283,285,287,65535,65535,289,291,293,65535,65535,65535,295,297,299,301,303,65535,65535,305,307,309,65535,311,313,315,317,319,321,323,325,327,329,331,333,335,337,65535,65535,339,341,343,345,347,349,351,353,355,65535,357,359,361,65535,363,365,65535,367,369,371,373,375,377,379,381,383,385,387,65535,389,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,65535,65535,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,65535,158,160,162,164,65535,166,168,65535,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,65535,200,202,204,65535,206,208,210,212,214,216,65535,65535,65535,65535,218,220,222,224,226,228,230,232,65535,234,236,238,240,242,244,65535,246,248,250,252,254,256,65535,258,260,262,264,65535,266,268,270,272,274,276,278,280,65535,282,284,286,288,65535,65535,290,292,294,65535,65535,65535,296,298,300,302,304,65535,65535,306,308,310,65535,312,314,316,318,320,322,324,326,328,330,332,334,336,338,65535,65535,340,342,344,346,348,350,352,354,356,65535,358,360,362,65535,364,366,65535,368,370,372,374,376,378,380,382,384,386,388,65535,390,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4.5,51.5,32144.5,28.5,6555.5,10942,23117.5,109,87.5,2.5,6576.5,12.5,15.5,17.5,24761,70,22,70.5,79.5,8304.5,5453.5,11183.5,12143.5,4008,10314,5665.5,10126.5,0.008820605,2705,17.5,30221.5,26.5,-0.00961374,0.013786957,0.0064733378,22,32,533,1824,137,1.5,2511,10298.5,10087,19530.5,11073,17139,4502,7717.5,6143.5,4187.5,11710.5,7495.5,6713,11570.5,0.0042426805,21,3029,3168.5,30194.5,30057,56.5,28.5,2.5,38.5,13611,146,-0.017002186,1.5,34,0.006214613,53,1896.5,14798,6278.5,7063,7444.5,8859,6479.5,0.024404055,0.013131375,-0.0074660056,0.00044804436,6965.5,7041,11442,20229.5,1320.5,4531,5321,6.5,6139,9999.5,11058,9471,4926.5,12.5,11633.5,13414.5,5665.5,12109,16778,17605.5,-0.0033371844,-0.0009388484,6.5,24808.5,21.5,19811,29764.5,-0.0033617632,30677,29782.5,36.5,27.5,-0.010226382,0.00012557374,33.5,33.5,3.5,0.018813172,95,0.0052012983,0.0009730666,0.002770326,0.0006554105,1986.5,-9.51913e-05,122.5,61,59.5,26.5,8596.5,6904.5,12413,7001,10107.5,1325.5,8511.5,2635,9330,6740.5,5848.5,6338.5,6224,9751.5,6979.5,11617,9477.5,8092.5,1.5,18893.5,18781.5,893,1021.5,7345,3919.5,5264.5,7620.5,9664.5,6520.5,4589.5,0.02135901,9845,15.5,9901.5,15.5,7466.5,10654.5,2709.5,8377,14016.5,2498.5,12228.5,6433.5,7418,13094,4771.5,11642,11297.5,7967,11698.5,12062,19564,19000.5,0.0049924343,2979.5,24802.5,24833.5,2545,0.0018240636,3197,24729.5,29725.5,29492.5,30312.5,0.0007214576,0.0010168729,30279,-0.0012009033,-0.003350655,0.0033295867,0.0012354142,-0.003926777,-0.0014086714,-0.0011489749,0.0028748792,0.010601589,0.018547038,-0.002744461,-0.012083775,-0.0024601643,-0.008417573,-0.0014905011,-0.0035817833,-0.012614197,0.0010837282,0.0030261178,0.0080112135,-0.015296176,-0.005348708,-0.0010720073,-0.0037595702,0.013978261,0.006655812,-0.010000843,0.0041500363,0.0075659356,0.0011386347,-0.0070984215,0.0021259913,-0.0011295252,0.005717238,-0.005943272,0.0019381834,-0.0012214518,0.0041675624,0.0015785302,-0.002653765,-0.0029568924,0.0054531037,0.006289272,-0.009962786,0.0018652261,0.0087567065,0.00042677156,-0.0034811918,-0.0013235563,-0.009914792,0.024797713,0.0014155952,-0.0026748865,0.005566934,0.02704193,0.0024490405,-0.0012494273,-0.0077442634,0.01094874,-0.0059069186,-0.0014010918,0.007577365,0.012728602,4.8243764e-05,-0.0015181908,0.0050632674,-0.013821189,-0.002337929,0.005252064,-0.00051131815,0.000109947134,-0.003966756,-0.00029888397,0.002856456,-0.0014121459,0.0058480096,-0.00059535785,0.0047366405,-0.0046428205,-0.0006662596,-0.00018554796,0.0014862226,-0.0013799721,-0.019484183,-0.0016787201,0.0021209877,-0.0036953948,0.000658656,-0.008026953,-0.0053174007,0.0073341555,0.02189937,0.0027645414,-0.013677909,-0.006520667,-0.0018538492,-0.013954774,-0.006660809,0.0014065899,-0.0018043619,-0.009768835,-0.004087789,0.005849951,-0.0005815579,-0.006689822,0.00046221065,-0.00020795505,-0.0068459148,-0.006625363,-0.00022512898,-0.0013254301,-0.007877345,0.007864849,-0.0010817563,0.0088336645,-0.007820325,-0.0015131646,-0.0060098236,0.005321157,-0.008392566,-0.004966679,-0.00014090228,-0.0028763372,0.00409892,-0.0054281666,-0.00089203235,-0.001708008,0.0019820945,0.00066190294,0.0015507049,-0.00032274192,0.00037268325,0.00020576858,-0.0076511092,0.0055504194,0.0018215933,-0.000706681,0.0017826721,-0.00012465623,0.00026628008,-0.0024322083,-0.00031793455,-0.001481444,-0.0005065958,0.00086637906,0.00027924762}, {8,2,5,0,7,4,1,4,6,8,7,8,8,8,2,4,0,0,0,5,7,0,0,7,4,5,5,255,0,8,2,0,255,255,255,4,7,6,4,0,8,3,6,0,0,0,6,1,6,7,3,2,1,5,5,255,8,0,6,2,6,4,2,8,6,0,0,255,8,4,255,3,3,4,2,6,1,6,3,255,255,255,255,7,1,5,4,2,1,5,8,7,5,0,5,5,8,6,6,5,4,4,7,255,255,8,6,8,0,6,255,2,4,6,2,255,255,0,0,8,255,0,255,255,255,255,6,255,0,6,1,5,2,0,1,0,0,2,0,7,0,6,4,3,7,2,7,4,1,5,8,6,6,3,1,0,6,2,6,4,7,3,255,5,8,0,8,5,6,5,0,2,1,4,5,2,2,3,6,6,5,1,1,5,2,255,2,4,4,0,255,6,2,2,4,2,255,255,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,65535,55,57,59,61,65535,65535,65535,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,65535,103,105,107,109,111,113,115,117,119,121,123,65535,125,127,65535,129,131,133,135,137,139,141,143,65535,65535,65535,65535,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,65535,65535,185,187,189,191,193,65535,195,197,199,201,65535,65535,203,205,207,65535,209,65535,65535,65535,65535,211,65535,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,259,261,263,265,267,269,271,273,275,277,279,65535,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,323,65535,325,327,329,331,65535,333,335,337,339,341,65535,65535,343,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,65535,56,58,60,62,65535,65535,65535,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,65535,104,106,108,110,112,114,116,118,120,122,124,65535,126,128,65535,130,132,134,136,138,140,142,144,65535,65535,65535,65535,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,65535,65535,186,188,190,192,194,65535,196,198,200,202,65535,65535,204,206,208,65535,210,65535,65535,65535,65535,212,65535,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,264,266,268,270,272,274,276,278,280,65535,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,65535,326,328,330,332,65535,334,336,338,340,342,65535,65535,344,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31339.5,4435.5,17199.5,4408,6501,24104,18713,1939,5757,5670.5,6687,-0.018606365,18752.5,18664.5,2.5,1430,1960,2948.5,5250.5,6313.5,6048,9219,7808.5,31864.5,4.5,19710.5,2,22466,29725.5,11976,12.5,17.5,7450.5,521.5,2845.5,5003.5,8070.5,5104,17.5,5727,5632.5,8963,6314,7141.5,11022,7.5,12.5,1.5,30426.5,31447.5,17841,-0.002359656,-0.0062694163,19532.5,27106.5,28802,17.5,44.5,611,7.5,2289.5,14.5,0.05213366,3542.5,9980,16,3118.5,18.5,7.5,2.5,11.5,11301.5,4299.5,2060.5,8795.5,6818.5,4708,5761,6037,5740,6172,5284.5,-0.031158457,7.5,1.5,6304.5,7903.5,7760.5,10396.5,11411,31423,28740.5,19182,19503,19062,19895,19315,5,32061,22410,-0.014727384,19861.5,1.5,1.5,30378,15,19360,21048,24094,65,21.5,6,3,1032.5,4755.5,1144.5,1777.5,7,0.0023150083,2416.5,1724,7656,4079,2.5,7693,-0.015103976,2761.5,7149,7149,2755.5,12.5,7514.5,5833.5,10294,14.5,4.5,6591,12.5,-0.012445177,20.5,2734,5683.5,8832.5,0.01831218,15.5,0.028386911,0.009871363,5366.5,1.5,6093,5817,6493,7.5,5870,7067.5,-0.02614808,5505.5,0.0030613185,16.5,0.010556991,10122,6177.5,6733.5,7314,7795.5,9404,8205.5,10550.5,11072,4.5,2.5,16412.5,11001.5,9,16916,15706.5,17682,0.001472633,0.0035515428,-0.0011820509,2.5,-0.0032904972,-0.002640269,7,15,-0.0032232571,-0.011013339,6805.5,18083.5,0.008669942,16777,19335,19432,20557.5,20631.5,23765,24017,30410,30011.5,-0.0014138919,-0.0027055012,-0.0036110692,-0.0029384557,19559.5,24094,19349,30603,-0.00017004379,-0.0053160894,0.0005615543,0.0072745457,-0.0010764837,-0.0030895823,-0.027201805,-0.015087806,-0.0064588874,0.0017576829,-0.012994021,-0.0009437548,-0.004949811,0.0050507905,-0.018363139,-0.0005529224,0.011636917,0.0215452,0.0033136215,-0.00026155505,0.008902076,0.0024339089,-0.00586142,-0.019473469,0.0065687518,-0.011857165,0.0013848704,-0.003494149,0.0020910425,0.008135873,-0.003359494,-0.0076438063,0.0045256354,0.009360488,-0.0073139737,0.0041272803,-0.0071564973,0.0006542527,-0.0075779357,-0.0014585494,-0.0048530647,-0.00017484148,0.0014274748,-0.0010052096,0.0029956207,-0.0041944296,0.0072215647,0.01090489,-0.008285619,-0.013367488,-0.0048944834,-0.0070509086,0.005487574,-0.0035045408,0.0031490386,0.019290274,-0.01639882,0.00015446125,0.0053471974,-0.012539418,-0.0076557654,6.4924265e-05,0.002315977,0.006297853,-0.007135792,-0.0030204502,-0.003949147,-0.025807032,-0.00012293358,-0.007835213,-0.03966282,-0.006332829,-0.017814817,0.0032086202,0.022336675,0.013135247,-0.002960107,-0.016775407,0.0024215088,-0.0015278918,0.015089593,-0.009369767,-0.00010087921,0.0019624834,0.0067718006,0.0036262067,0.00023102283,0.014077054,0.00088139455,-0.010032763,-0.007821081,0.012677319,-0.008268877,0.0033688773,0.0027670036,-0.000979481,-0.0061340597,-0.001195494,0.0010230317,0.00795319,-0.0044678133,-6.443262e-05,0.000683197,0.0064727156,0.00045456304,-0.0026119996,-0.010433235,-0.0054993494,-0.006042721,-0.002229716,0.0021483095,0.000118248645,-0.0040597916,-0.0023354765,-0.005806984,-0.01205085,-0.0010020783,-0.0039635478,0.000496737,-0.00014327225,-0.0014369083,-0.0009778854,-0.0003773458,0.0004953748,0.0014028206,-0.0031723285,-0.0014314837,-0.0003307241,-0.00414145,-0.0009992564,0.0011952732,-0.0015767874,0.002527057,0.005339565,0.005031453,0.0030229269,0.0033022694,0.0018374566,0.0006908193,0.0014683217,-0.00044094012,0.00025823622,-0.0038177713,0.0002564746,-0.00192295,-0.00018814535,-0.00024959596,0.00075488444,-0.0009126761,5.9341688e-05,-0.00038703388,-0.0012971975,-0.00020273261,0.0009724631}, {6,1,5,0,0,2,1,1,6,5,0,255,1,1,8,0,1,7,5,0,5,2,0,6,8,3,8,1,2,7,8,8,4,5,4,5,0,4,8,2,3,2,1,5,1,8,8,8,4,4,1,255,255,3,1,0,8,1,0,8,6,8,255,1,4,8,4,8,8,8,8,4,1,6,2,1,4,7,5,1,3,6,255,8,8,5,5,1,0,3,4,0,3,1,1,1,1,8,2,0,255,1,8,8,5,8,1,1,5,2,8,8,8,5,2,2,7,8,255,0,4,5,0,8,0,255,7,0,0,5,8,4,6,4,8,8,0,8,255,8,7,1,2,255,8,255,255,0,8,1,0,4,8,3,2,255,3,255,8,255,2,5,1,4,1,0,1,6,0,8,8,0,3,8,5,5,1,255,255,255,8,255,255,8,8,255,255,0,7,255,1,1,7,1,1,5,7,7,1,255,255,255,255,7,5,1,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,65535,65535,101,103,105,107,109,111,113,115,117,65535,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,65535,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,65535,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,65535,225,227,229,231,233,235,65535,237,239,241,243,245,247,249,251,253,255,257,259,65535,261,263,265,267,65535,269,65535,65535,271,273,275,277,279,281,283,285,65535,287,65535,289,65535,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,323,65535,65535,65535,325,65535,65535,327,329,65535,65535,331,333,65535,335,337,339,341,343,345,347,349,351,65535,65535,65535,65535,353,355,357,359,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,65535,65535,102,104,106,108,110,112,114,116,118,65535,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,65535,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,65535,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,65535,226,228,230,232,234,236,65535,238,240,242,244,246,248,250,252,254,256,258,260,65535,262,264,266,268,65535,270,65535,65535,272,274,276,278,280,282,284,286,65535,288,65535,290,65535,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,65535,65535,65535,326,65535,65535,328,330,65535,65535,332,334,65535,336,338,340,342,344,346,348,350,352,65535,65535,65535,65535,354,356,358,360,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({42.5,21.5,58,39.5,438.5,35.5,33,33.5,44,50,3880,136.5,7.5,74,36.5,3444.5,70.5,-0.03931159,27.5,26.5,25,114.5,-0.0066419593,42.5,15,27,2466.5,5.5,15.5,533,22.5,22,13,33.5,261,29.5,15.5,22,27,-0.0019875502,-0.01216742,0.0145243285,288,-0.02005748,-0.009697285,-0.029248044,-0.016408946,5,50.5,50,17.5,57,37,22,1351,83.5,1986.5,92.5,6.5,22,22,0.008711325,15.5,66.5,24,-0.03521767,19.5,102,25,86,40.5,22,35.5,0.018279323,29.5,728,180.5,-0.0034841415,-0.011492615,5.5,5.5,192,13.5,14,-0.032388195,0.01625236,0.0064550876,21.5,0.010312333,50.5,69,21.5,17.5,6,170,1118.5,319.5,49.5,15.5,4408,530,16.5,25.5,29,26,0.0010319505,0.0037431966,15.5,5,0.019024566,6.5,11.5,-0.012317012,15.5,8.5,5,24988.5,0.015712848,7.5,450,17.5,-0.006449462,0.006093228,0.0027755534,22,0.0042563058,42.5,0.06938063,0.021609887,0.012763644,0.038138837,58,6.5,533,45,58.5,17,10.5,21,0.0018978833,-0.001073403,16,-0.0040068678,7,494,4.5,4.5,32.5,104.5,0.001474351,-0.006027841,-0.00096537283,-0.0066965446,-0.02385424,-0.014678589,-0.0075699436,0.008912995,-0.011528821,15.5,-0.025709352,-0.014752868,12,-0.008239537,867,4692.5,406,686,-0.0015590506,-0.005867799,0.012140742,-0.001974211,0.0046350025,0.00028837434,-0.006879148,-0.00040769132,0.006397463,-0.00034908645,0.004789829,-0.0034213015,0.001618246,0.011405651,0.0054939594,0.0012937592,-0.0029993393,0.0031963268,0.011060978,0.0023956818,-0.008843486,0.00023557163,-0.015080534,-0.0011853263,0.0014464656,-0.0026459896,0.008258249,-0.002911331,0.0051443237,0.038128965,0.0001375889,-0.00062604964,-0.0016353772,0.00246601,0.019772707,0.008120746,0.0011637755,0.005978668,0.001745672,-0.0029207491,0.013777085,0.003477626,-0.0039524264,-0.008028823,-6.45309e-05,-0.003982054,-0.0022764797,-0.00027163592,0.0021952363,0.007659623,0.002540849,0.012579135,0.007345135,0.004516074,0.0015085539,0.0045195036,-0.0025255003,-0.00037668852,-0.00045475154,0.0043827966,0.0047680093,0.012899508,0.0051087677,-0.0037125077,-0.0060171653,-0.0025890907,-0.0017289432,0.0025098077,-0.001314449,0.0022766036,-0.0012324792,0.00018877511,-0.00017000675,0.008906032,-0.0078149,-0.00046019984}, {6,8,6,0,1,7,2,2,0,0,0,0,8,7,2,4,4,255,5,0,1,3,255,4,8,0,0,8,8,6,3,0,8,0,2,4,8,6,3,255,255,255,2,255,255,255,255,8,2,6,8,0,0,2,4,6,6,0,8,2,4,255,8,2,1,255,8,2,1,0,7,2,2,255,0,0,4,255,255,8,8,0,8,8,255,255,255,8,255,4,0,8,8,8,6,6,4,0,8,0,4,8,4,0,2,255,255,8,8,255,8,8,255,8,8,8,0,255,8,2,8,255,255,255,0,255,0,255,255,255,255,0,8,2,6,0,8,8,8,255,255,8,255,8,0,8,8,5,6,255,255,255,255,255,255,255,255,255,8,255,255,8,255,7,1,5,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,65535,35,37,39,41,65535,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,65535,65535,65535,75,65535,65535,65535,65535,77,79,81,83,85,87,89,91,93,95,97,99,101,103,65535,105,107,109,65535,111,113,115,117,119,121,123,65535,125,127,129,65535,65535,131,133,135,137,139,65535,65535,65535,141,65535,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,65535,65535,175,177,65535,179,181,65535,183,185,187,189,65535,191,193,195,65535,65535,65535,197,65535,199,65535,65535,65535,65535,201,203,205,207,209,211,213,215,65535,65535,217,65535,219,221,223,225,227,229,65535,65535,65535,65535,65535,65535,65535,65535,65535,231,65535,65535,233,65535,235,237,239,241,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,65535,36,38,40,42,65535,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,65535,65535,65535,76,65535,65535,65535,65535,78,80,82,84,86,88,90,92,94,96,98,100,102,104,65535,106,108,110,65535,112,114,116,118,120,122,124,65535,126,128,130,65535,65535,132,134,136,138,140,65535,65535,65535,142,65535,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,65535,65535,176,178,65535,180,182,65535,184,186,188,190,65535,192,194,196,65535,65535,65535,198,65535,200,65535,65535,65535,65535,202,204,206,208,210,212,214,216,65535,65535,218,65535,220,222,224,226,228,230,65535,65535,65535,65535,65535,65535,65535,65535,65535,232,65535,65535,234,65535,236,238,240,242,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7.5,5809,19404,539,6522.5,15091.5,18533.5,485,5765.5,3.5,6566,13821,18993,29850.5,30031,99.5,472,8185,7489.5,5610.5,5361,9744,7542.5,15.5,13173,18987.5,21438.5,15526.5,17421.5,26104,23117.5,32.5,121,555.5,19471,6304,8905.5,6989.5,4.5,7504.5,9020.5,2424.5,4.5,8001,9089.5,7517.5,7772,10299.5,11549,11260,15490.5,11544.5,12056,13507.5,20344.5,24955.5,22313.5,16.5,18909.5,17987.5,30806,16226.5,27476.5,76.5,27,34,682.5,4.5,-0.02810854,4727.5,-0.01641402,4588.5,8787,6455.5,11692.5,2973,-0.011313939,0.018245917,5.5,4778,7510,7314,10276,2787,4589,10298.5,6614.5,9610,9642.5,-0.015116735,6451,11567,7749,7800,11253.5,1270.5,11076,11499.5,11859.5,9355.5,11590.5,16473.5,14661.5,7004,14216,15892,18963.5,18352,17390.5,17404.5,18939.5,28678.5,26769,16951,23102.5,20957,-0.0035987038,18,16.5,2802,15084.5,23466.5,20340,17.5,0.002192824,2545,17992.5,79.5,73.5,70,41.5,4,3089,382,1324.5,-0.021920238,-0.013500686,222,4.5,2.5,5287.5,6432.5,9063,5858,4799.5,2.5,1.5,0.010621284,4.5,-0.0026354622,9936.5,1314.5,4430.5,0.02496712,1732,5481,7471,9946.5,5333,2016.5,8037.5,3242.5,4.5,9274,6494,5931.5,6.5,1.5,0.0029560523,4.5,3,0.0036503244,20493.5,5432.5,11641.5,0.02135641,2.5,7361,7992,8967,7905.5,446,1451.5,7043.5,10809.5,1730.5,8895,6459,12615,14046,11456.5,11095,11833,14233.5,14991,13070.5,19.5,18380.5,12.5,16587,19676,23476,11523.5,24078,24255,-0.013020314,12383,19323,16727,18977,30592,26873,23248.5,16080,0.0072451467,0.014436173,16.5,15998.5,18226.5,2631,15.5,29407.5,0.0032384123,-0.0007701807,-0.0018738554,27382,27382,11.5,20.5,14569,19425,15.5,29796,18936.5,24082.5,2358.5,2705,19,17.5,16.5,30224,0.0007705867,-0.005022625,-0.012760587,-0.00022058967,-4.7202404e-05,-0.014080985,0.005252348,0.00905695,0.0012087327,0.0042846906,-0.01350987,-0.0021201025,0.0039850934,-0.0020755806,-0.0125679225,-0.0034368306,0.00503278,-0.004240836,0.005497783,0.0020709466,-0.00040924858,0.0022622524,-8.541237e-05,-0.005373854,0.014930944,0.0043878844,-0.0034064252,0.001615532,-0.0032164566,0.0052379062,-0.004824207,-0.009919306,-0.0020605293,0.003768906,-0.009173419,-0.0026830167,0.0031190198,-0.00062625477,0.009215924,0.000872208,-0.008244946,0.0025944503,0.0015497339,-0.0036530797,-0.008488846,-7.0335685e-05,0.007410197,-0.0055640186,0.01857918,0.0010026976,-0.009736875,-0.0067789997,-0.006728738,-0.00074390793,0.0008949384,-0.0024984318,-0.006465424,-0.014141679,-0.003786696,0.0047532073,0.0010882355,-0.0010988617,-0.00065494806,-0.008843918,0.0048788073,-0.0026699395,0.004519992,-0.007857486,0.0062671616,-0.00042306638,0.003715473,-0.015956964,0.025849521,0.015647732,-0.005511682,0.014989189,-0.0039376128,0.00017513972,0.002176696,-0.0011013836,0.012802978,0.0018999774,0.0016956859,0.008423898,-0.017887821,0.0020253367,0.006000621,-0.0010857083,-0.010594562,-0.0018229658,-0.011353368,3.063597e-05,-0.0015152205,0.0026940254,-0.0060894284,-0.0012991746,0.00020395448,0.0052911607,-0.00077645195,-0.007926847,-0.0006916079,0.0005376532,0.017665243,-0.0026465787,-0.00202773,-0.007336018,-0.00084761356,-0.009514809,0.0010923871,-0.0029314996,0.0037760437,0.008608052,0.014081073,0.008817423,0.017021714,0.02372863,-0.00329552,-0.007947154,-0.005340691,-0.014808305,-0.000504347,-0.006665642,0.006855614,0.00020000625,-0.0017786224,-0.012500702,-0.0023811606,-0.006282144,-0.006490013,0.0028740303,-0.010719686,-0.0028755262,0.0014146421,0.005491722,-0.0003896534,-0.0032909059,0.018358804,-0.00075090275,-0.012845851,0.002554312,-5.346826e-05,0.002995919,0.017552285,0.010187899,0.009765515,-0.011583011,-0.002837873,0.022325559,0.0036510366,-0.0012115043,0.014552714,0.004884272,-0.012297268,0.0016625216,0.0015527623,-0.0056231297,0.007112451,0.003027696,0.009510279,0.017377479,0.002492273,0.0076011713,-0.0005081326,0.004843286,0.0017835078,-0.0017542631,-3.5406854e-05,-0.0024996568,0.0049353926,0.0022387244,0.00054353254,0.0015209675,0.001208345,0.0057381247,0.0009232019,-0.0016339837,-0.011873118,0.01489305,-0.010670103,-0.004929523,0.0100007,0.0041724066,-0.0011976771,0.0019643274,-0.0010726753,0.0003969136,-0.00091628666,-0.00018513613,0.0018533443,0.00801107,0.005626909,-0.001950181,-1.8584084e-05,0.003383514,-0.0007209386,-0.0034877292,0.0006663647,0.0023722253,1.5533162e-06,0.00028480482}, {8,6,7,5,7,2,5,4,6,8,7,2,4,6,5,4,1,2,0,3,7,2,1,8,3,6,2,3,5,4,1,5,5,2,0,5,2,2,8,4,6,3,8,6,0,1,0,2,6,7,3,5,5,3,3,4,3,8,3,4,4,0,1,6,1,6,2,8,255,1,255,4,1,0,0,4,255,255,8,0,4,4,2,7,2,6,6,0,0,255,3,4,6,1,7,0,7,6,6,7,1,6,0,5,0,4,1,2,3,5,5,6,0,1,4,1,255,8,8,0,3,3,3,8,255,0,6,2,7,4,4,8,0,4,0,255,255,6,8,8,7,5,1,0,6,8,8,255,8,255,1,1,2,255,3,4,4,6,1,3,4,1,8,6,1,7,8,8,255,8,8,255,0,5,6,255,8,2,6,0,1,7,1,1,0,7,3,5,1,2,1,1,3,2,0,0,8,4,8,3,1,0,1,6,0,255,3,1,7,7,4,2,2,4,255,255,8,5,0,0,8,0,255,255,255,0,0,8,8,0,3,8,6,3,3,0,0,8,8,8,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,65535,137,65535,139,141,143,145,147,65535,65535,149,151,153,155,157,159,161,163,165,167,169,65535,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,65535,223,225,227,229,231,233,235,65535,237,239,241,243,245,247,249,251,253,255,65535,65535,257,259,261,263,265,267,269,271,273,275,65535,277,65535,279,281,283,65535,285,287,289,291,293,295,297,299,301,303,305,307,309,311,65535,313,315,65535,317,319,321,65535,323,325,327,329,331,333,335,337,339,341,343,345,347,349,351,353,355,357,359,361,363,365,367,369,371,373,375,377,379,65535,381,383,385,387,389,391,393,395,65535,65535,397,399,401,403,405,407,65535,65535,65535,409,411,413,415,417,419,421,423,425,427,429,431,433,435,437,439,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,65535,138,65535,140,142,144,146,148,65535,65535,150,152,154,156,158,160,162,164,166,168,170,65535,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,65535,224,226,228,230,232,234,236,65535,238,240,242,244,246,248,250,252,254,256,65535,65535,258,260,262,264,266,268,270,272,274,276,65535,278,65535,280,282,284,65535,286,288,290,292,294,296,298,300,302,304,306,308,310,312,65535,314,316,65535,318,320,322,65535,324,326,328,330,332,334,336,338,340,342,344,346,348,350,352,354,356,358,360,362,364,366,368,370,372,374,376,378,380,65535,382,384,386,388,390,392,394,396,65535,65535,398,400,402,404,406,408,65535,65535,65535,410,412,414,416,418,420,422,424,426,428,430,432,434,436,438,440,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({45.5,27.5,53,93.5,35.5,36.5,33,3444.5,15,33.5,22.5,136.5,6.5,15.5,36.5,22,11.5,-0.011714191,-0.022579407,22,57,-0.03680745,27,42.5,-0.02344591,27,47.5,37,1363,139.5,22.5,22,26.5,4.5,14.5,3.5,49.5,34.5,-0.03126266,25.5,18.5,-0.018901637,-0.008450835,4.5,55,1261,44,22,89,19.5,-0.008943521,83.5,1118.5,92.5,2857.5,22,17.5,20.5,15,0.0096457815,7,0.0011252029,0.003653507,0.006433842,18.5,29,15.5,6.5,0.018316424,15.5,12905.5,368,368,2.5,0.0020284546,4.5,3,49,18.5,9.5,15.5,2.5,9,4.5,22,72,104.5,6.5,-0.020598285,-0.009424349,1986.5,49.5,15,1270.5,3355.5,22,0.010731007,26,21.5,8.5,22,-0.008653147,20.5,0.003184531,0.0069295675,17.5,-0.0051322966,32,17,22,17.5,3.5,9.5,187.5,3248,15.5,25493.5,263.5,2.5,35.5,20.5,-0.0017730292,-0.004429956,0.026209805,47,0.002685992,1252.5,7.5,-0.007861224,16.5,0.0024922919,0.008072305,15.5,7.5,18,25.5,7.5,27,27,0.00432701,0.010979592,13,5.5,18.5,1007.5,0.008471435,20.5,-0.0005362002,-0.006035592,0.008748777,319.5,-0.022022726,15.5,7,-0.005631811,985.5,1394.5,5439,8424,-0.0025236753,0.0012311883,0.0027747499,-0.0010906565,0.007120665,0.012471732,-0.0010543586,-0.0039905286,0.0013881106,0.004851213,-0.001810545,-0.003578866,-0.0029441884,0.0015465481,0.002642851,0.0048238216,-5.2873103e-05,-0.002423039,0.009685061,0.005210062,0.0009980061,-0.0008557872,0.011586496,0.019374443,0.0013541676,0.009593034,0.0013190784,-0.0026521233,0.004716753,-0.015188299,-0.009494721,-0.027884671,-0.00654837,0.0006095966,0.0020577575,0.00995472,-0.009229854,0.0006565731,0.0015696817,-0.0035461118,0.018533831,0.039015498,0.0008149465,0.005430418,-0.00011254034,-0.001684404,-0.010748938,-0.003510451,-0.00024688666,-0.009083991,-0.003589723,0.0054248436,-0.0038037337,-0.0016017593,-0.0074363733,-0.0011243554,0.011937869,0.0038548203,-0.0014970838,0.0026902466,-0.00090683036,-0.002460876,-0.0007809336,0.0008769328,0.0054930416,0.0017611403,0.004428048,0.0023057016,-0.0002847414,0.008564571,0.013297282,0.0057577486,0.0039185113,-0.0027228973,-0.010483104,-0.0043721627,-0.007794256,-0.015908115,-0.0017449757,0.0014296719,0.00027218208,-0.0022531976,0.01038967,0.0010243471,-0.003640767,-0.000818493,0.00027994742,-0.00036133945}, {6,2,6,0,0,7,2,4,8,0,1,0,8,8,2,4,8,255,255,4,4,255,7,4,255,0,6,0,4,7,3,0,0,8,8,8,4,0,255,7,8,255,255,8,2,0,2,2,0,8,255,6,6,0,2,2,8,8,8,255,8,255,255,255,8,5,8,8,255,8,0,0,0,8,255,8,8,0,8,8,8,8,8,8,2,6,6,8,255,255,6,0,8,3,3,6,255,0,8,8,0,255,8,255,255,8,255,0,8,0,8,8,8,0,4,8,0,0,8,4,8,255,255,255,0,255,0,8,255,8,255,255,8,8,8,4,8,2,2,255,255,8,8,8,0,255,8,255,255,255,4,255,8,8,255,2,2,4,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,65535,65535,35,37,65535,39,41,65535,43,45,47,49,51,53,55,57,59,61,63,65,67,65535,69,71,65535,65535,73,75,77,79,81,83,85,65535,87,89,91,93,95,97,99,101,65535,103,65535,65535,65535,105,107,109,111,65535,113,115,117,119,121,65535,123,125,127,129,131,133,135,137,139,141,143,145,147,65535,65535,149,151,153,155,157,159,65535,161,163,165,167,65535,169,65535,65535,171,65535,173,175,177,179,181,183,185,187,189,191,193,195,197,199,65535,65535,65535,201,65535,203,205,65535,207,65535,65535,209,211,213,215,217,219,221,65535,65535,223,225,227,229,65535,231,65535,65535,65535,233,65535,235,237,65535,239,241,243,245,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,65535,65535,36,38,65535,40,42,65535,44,46,48,50,52,54,56,58,60,62,64,66,68,65535,70,72,65535,65535,74,76,78,80,82,84,86,65535,88,90,92,94,96,98,100,102,65535,104,65535,65535,65535,106,108,110,112,65535,114,116,118,120,122,65535,124,126,128,130,132,134,136,138,140,142,144,146,148,65535,65535,150,152,154,156,158,160,65535,162,164,166,168,65535,170,65535,65535,172,65535,174,176,178,180,182,184,186,188,190,192,194,196,198,200,65535,65535,65535,202,65535,204,206,65535,208,65535,65535,210,212,214,216,218,220,222,65535,65535,224,226,228,230,65535,232,65535,65535,65535,234,65535,236,238,65535,240,242,244,246,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({36.5,22,42.5,93.5,23.5,64.5,74.5,22,15.5,27,18.5,61,46,49,70.5,15.5,4.5,-0.0113557745,-0.0214748,3.5,0.01613589,11.5,121.5,28.5,12.5,-0.025056122,20957.5,21.5,47,91,389,5.5,23,25.5,60.5,1.5,0.0020492177,122.5,26.5,35,218.5,26.5,27,6.5,63.5,28.5,7.5,46,1011.5,4.5,15.5,16.5,16.5,322.5,430,2.5,23,-0.0054199635,19,1.5,-0.008218455,39.5,21,-0.00074329803,0.00044319904,41.5,1247.5,29.5,43.5,74.5,28.5,0.054655313,3767.5,42.5,108.5,-0.013675893,38,83,83,15.5,15.5,-0.01278386,12.5,0.0024323692,0.007625525,8,2.5,22,0.018912531,0.013510375,19.5,43,70,-0.026390208,18.5,139.5,109.5,210,20.5,1240.5,455,23,4.5,13.5,29,-0.0011305934,0.007938588,22,22,9.5,7,15,-0.003832129,32,33.5,49,1.5,232.5,83.5,12.5,15.5,33.5,490,31,68.5,-0.02892597,25163,-0.016975623,6.5,-0.030712625,96.5,35,3.5,63.5,-0.018353958,63.5,-0.015028938,0.002987036,18,0.006005756,83,32.5,109,49,20.5,68,273.5,0.000214236,0.002435916,0.008428473,21.5,24,6.5,20.5,21,-0.003655605,-0.0133426655,-0.012663761,-0.006428443,-0.010193798,18.5,133.5,2502,2204.5,783.5,550.5,9477.5,4.5,472.5,-0.0034563807,-0.0014053829,-0.0014442832,-0.003588625,-0.00021466384,-0.0016949542,-0.0032755376,-4.7249785e-05,0.009438161,-0.00042600636,-0.004299976,0.00033521806,0.00048406926,0.0041185855,0.0018877616,-0.0033263601,0.0035400141,0.009714372,0.00011196276,0.008693462,0.0014044694,-0.008866998,-0.009925608,-0.000856294,0.007973634,0.0020943193,-0.0008441191,0.0022437237,-0.0034009572,-0.013132933,0.010698321,-0.0005346186,0.002813367,0.011144698,0.0040041963,0.011035247,-0.014550285,-0.0015639516,-0.0029606388,-0.01848185,0.00014683964,0.018222228,-0.000238474,-0.005468078,-0.011149606,-0.0036972263,-0.004910206,-0.02298534,-0.00017625261,-0.0062539964,0.0070878873,0.00012634268,0.0027270508,0.0022466786,-0.0010291514,-0.003471853,-0.0009242624,-0.0024440966,0.0029241361,0.0067094597,-0.0046649687,-0.012004807,-0.007358373,0.001839715,-0.0008581399,0.005944725,-0.004817454,0.0011867214,0.0011585862,-0.0059710415,0.003900728,0.0008255192,0.0021519777,0.0056222132,0.001130696,-0.0019923444,0.010674717,0.0028312223,0.009151097,0.0027844857,0.00018225543,-0.013316455,0.0011342424,0.00030619136,0.00020288241,0.0061946907,-0.015967889,-0.0016671609,0.008074221,0.00087114744,-0.00024306262,0.04118038,-0.008354707,-0.027884154,-0.0022282589,-0.014313697,-0.02157977,0.013426627,-0.008093591,-0.00028301342}, {4,2,5,0,3,6,4,6,8,0,8,6,0,6,5,8,8,255,255,8,255,8,3,5,8,255,1,8,4,6,6,8,0,4,6,8,255,0,5,0,2,5,1,8,0,1,8,4,0,8,8,8,8,7,7,8,0,255,8,8,255,6,8,255,255,6,0,4,0,6,7,255,0,4,2,255,6,0,0,8,8,255,8,255,255,8,8,0,255,255,8,0,1,255,8,7,0,6,8,0,6,0,8,8,0,255,255,0,0,8,8,8,255,0,2,3,8,0,6,8,8,0,6,6,2,255,2,255,8,255,0,0,8,0,255,0,255,255,8,255,0,1,2,0,8,4,0,255,255,255,8,2,8,8,8,255,255,255,255,255,8,6,0,0,2,2,4,8,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,65535,65535,35,65535,37,39,41,43,65535,45,47,49,51,53,55,57,59,61,63,65535,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,65535,105,107,65535,109,111,65535,65535,113,115,117,119,121,123,65535,125,127,129,65535,131,133,135,137,139,65535,141,65535,65535,143,145,147,65535,65535,149,151,153,65535,155,157,159,161,163,165,167,169,171,173,175,65535,65535,177,179,181,183,185,65535,187,189,191,193,195,197,199,201,203,205,207,209,65535,211,65535,213,65535,215,217,219,221,65535,223,65535,65535,225,65535,227,229,231,233,235,237,239,65535,65535,65535,241,243,245,247,249,65535,65535,65535,65535,65535,251,253,255,257,259,261,263,265,267,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,65535,65535,36,65535,38,40,42,44,65535,46,48,50,52,54,56,58,60,62,64,65535,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,65535,106,108,65535,110,112,65535,65535,114,116,118,120,122,124,65535,126,128,130,65535,132,134,136,138,140,65535,142,65535,65535,144,146,148,65535,65535,150,152,154,65535,156,158,160,162,164,166,168,170,172,174,176,65535,65535,178,180,182,184,186,65535,188,190,192,194,196,198,200,202,204,206,208,210,65535,212,65535,214,65535,216,218,220,222,65535,224,65535,65535,226,65535,228,230,232,234,236,238,240,65535,65535,65535,242,244,246,248,250,65535,65535,65535,65535,65535,252,254,256,258,260,262,264,266,268,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({2857.5,2274,3209.5,2176,2631,3589.5,7.5,29302,2212,2356,902,3545,1251.5,5332.5,31119,18.5,2,15.5,17.5,3234,18.5,19.5,18.5,2170,1192.5,11.5,3798.5,5365.5,6223.5,10453,17199.5,334,894.5,-0.0013009734,19,2905,-0.025444826,2472,3931,551.5,18.5,6.5,2024.5,3035,1314.5,1145,3221,16.5,15.5,299.5,2887.5,2.5,0.015759682,2204,4729.5,11520.5,6109,5093.5,7782,6694.5,11577,19062,18695,90.5,397.5,835,934.5,-0.011135912,-0.018831177,-0.017828962,-0.0032926076,6,15.5,-0.0191787,-0.0007927918,-0.0135524515,2069,13,0.03638966,2024.5,2024.5,-0.01355785,2306.5,18,6.5,0.031938784,3122.5,-0.016760875,3175,2622,3174.5,2106,1729,2302,-0.02067281,-0.006944477,-0.014742784,879,7.5,0.021131527,8.5,2076,4479,2846,3125,4202,11564,5417,8327,4091.5,4.5,7693,2185.5,6648.5,6127.5,13164,18983.5,27957.5,19503,20609.5,29557,84.5,1934,368,4.5,808,1175.5,1060.5,883,-0.0034451117,14,7766,-7.948075e-05,17,17.5,7.5,15.5,0.009719791,3.5,15,16.5,0.021147886,0.045220803,13.5,0.007120485,4.5,0.0055895853,0.007940533,0.014141383,3157,2292.5,2796,3063.5,-0.012594814,3255.5,1704,5,1559,20.5,-0.0140296165,8.5,19,1.5,2,16.5,5.5,0.0022283422,16.5,5206,6.5,6022,8406,4125.5,0.0077228295,12.5,4232.5,4329.5,6287.5,1.5,4950,5568,7176,2.5,4680,5905.5,6543.5,6229,7586.5,6220.5,19749,3602,12.5,7617,7726.5,10799,12998.5,21636,11288,20659.5,-0.015106389,15.5,19315,19895,31840,-0.013310626,11.5,17.5,0.00052293134,-0.010024951,0.0052346443,0.00082701474,-0.009999024,-0.026907146,0.0024206406,-0.0012339499,-0.00067076756,0.017330078,-0.03759418,-0.0057686595,0.033664,0.007896635,0.013673059,0.0014917549,0.011140479,0.0014653485,-0.008251514,-0.0013225403,-0.00023052398,-0.015353416,0.0006672792,0.009315224,0.003072417,0.011227645,0.0007033142,0.0025861345,0.005466125,-0.00081572786,0.02223475,0.0015265216,0.007533261,0.016735833,-0.00023234803,-0.005431288,0.0033038661,0.001683265,0.0027519972,0.008039199,0.007911323,-0.00077344174,0.0072841593,-0.0016857261,-0.017403489,-0.007524427,0.0077947765,1.0296854e-05,-0.007688451,-0.0113011375,0.00039583235,0.0035069205,-0.0011624863,-0.033154707,0.0109024625,0.0011605436,-0.0063106096,-0.010786536,0.0077159232,-0.001516355,-0.003576449,0.0015848734,-0.0042437385,0.0018197304,-0.005805672,-0.00020734084,-0.003391331,-0.00093928503,-0.0040618735,0.0029017595,-0.013201654,-0.026998648,0.00528469,0.0011068446,-0.0052747484,-0.000647956,-0.00329769,-0.008371607,-0.004638875,-0.0011944672,-0.0005417829,-0.0042379326,0.000625618,-0.013644326,0.010018504,0.0029761936,-0.014875432,-0.0053337137,0.0052381433,-8.914363e-05,-0.001316843,0.0075901025,-0.01042665,0.0042110626,0.0017097656,0.010459888,-0.0067466237,-4.8769994e-06,-0.0053095235,0.0014473435,0.0039135246,0.012852902,-0.0057582213,-5.163458e-05,0.00086030544,-0.0055934037,0.0018463893,0.011831419,0.0034478256,-0.006425491,-0.010566755,0.0010953809,0.004649434,-5.3856027e-05,-0.0009672059,0.00025073957,0.0043090777,0.011154027,-0.0005965039,0.004062937,-0.0024024555,0.0008794795,0.0007516245,-0.009017439,0.0054301424,-0.002669016,0.001004156,-0.0028195393,0.0062044105,-9.311275e-05,-0.002883664,-0.004399983,-0.00062152767,0.000100413956,-0.0025692275,-0.0020536794,-0.0050895745,-0.00095199485,-0.0017983703,-0.003029825,-1.2065026e-05,-0.0005428014}, {2,3,3,3,1,0,8,0,3,1,6,6,1,4,2,8,8,8,8,3,8,8,8,1,0,8,7,1,4,5,5,0,3,255,8,0,255,0,0,0,8,8,0,0,4,6,5,8,8,0,1,8,255,4,5,2,3,2,2,5,5,1,1,5,1,3,1,255,255,255,255,8,8,255,255,255,4,8,255,0,0,255,0,8,8,255,0,255,3,3,1,5,1,0,255,255,255,1,8,255,8,6,2,5,1,2,3,3,7,1,8,6,7,5,6,6,2,4,1,5,6,4,6,1,8,3,1,2,5,255,8,0,255,8,8,8,8,255,8,8,8,255,255,8,255,8,255,255,255,3,2,0,3,255,1,5,8,1,8,255,8,8,8,8,8,8,255,8,0,8,2,6,1,255,8,1,2,0,8,3,5,7,8,3,7,2,0,6,5,0,3,8,3,3,3,0,2,4,0,255,8,1,1,2,255,8,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,65535,67,69,65535,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,65535,101,103,105,107,109,111,113,115,117,119,121,123,125,127,65535,65535,65535,65535,129,131,65535,65535,65535,133,135,65535,137,139,65535,141,143,145,65535,147,65535,149,151,153,155,157,159,65535,65535,65535,161,163,65535,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,65535,223,225,65535,227,229,231,233,65535,235,237,239,65535,65535,241,65535,243,65535,65535,65535,245,247,249,251,65535,253,255,257,259,261,65535,263,265,267,269,271,273,65535,275,277,279,281,283,285,65535,287,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,323,325,327,329,331,333,335,65535,337,339,341,343,65535,345,347,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,65535,68,70,65535,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,65535,102,104,106,108,110,112,114,116,118,120,122,124,126,128,65535,65535,65535,65535,130,132,65535,65535,65535,134,136,65535,138,140,65535,142,144,146,65535,148,65535,150,152,154,156,158,160,65535,65535,65535,162,164,65535,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,65535,224,226,65535,228,230,232,234,65535,236,238,240,65535,65535,242,65535,244,65535,65535,65535,246,248,250,252,65535,254,256,258,260,262,65535,264,266,268,270,272,274,65535,276,278,280,282,284,286,65535,288,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,326,328,330,332,334,336,65535,338,340,342,344,65535,346,348,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({41.5,39.5,4666,36.5,21.5,32.5,5425.5,32,32.5,236.5,231,47.5,53,11100,7427.5,53,63.5,22.5,31,15.5,14.5,-0.0009649515,0.047934256,7.5,104.5,36.5,37,6167.5,4.5,10629,7454,22,2.5,28.5,35,-0.023520773,78,15.5,35,2.5,42.5,4,18,5,13.5,42,18.5,29.5,29.5,162.5,2800,9575,9028.5,11027.5,9029.5,7908.5,11633.5,12.5,7015,22,27,0.010347279,16.5,3.5,17.5,-0.025701502,20,58,13611,131,3927,12905.5,16.5,35,7.5,35,0.008025341,-0.012148897,7.5,0.005065041,0.020295374,-0.0028818764,-0.012063952,8.5,18.5,18,4.5,1.5,1432.5,13.5,533.5,789.5,5.5,-0.019539623,1367,2494.5,1290,5314.5,13190,8831.5,9128.5,4559,27213.5,5348.5,28545,9593,7945.5,5728,10862.5,7576.5,7431,8439.5,7675,23,23.5,14.5,21.5,7.5,27.5,34.5,13.5,44,34.5,16,-0.016229277,6.5,4,15.5,17,8.5,1.5,461.5,6332,18.5,25493.5,7.5,21.5,0.030241236,0.009379427,0.0051832497,11.5,20,17.5,0.0018315226,-0.0036322025,-0.0005622459,-0.0018030781,-0.006176749,20,2.5,24,57,55,213,41.5,20.5,21.5,6,17.5,106,1986.5,7.5,8,92,60,364.5,-0.0015308105,2053.5,2791,3526.5,4620.5,3509.5,5906.5,11.5,3,5152,1.5,2.5,12081.5,1.5,1.5,4708.5,1.5,18291,5595,18.5,17,7659.5,4.5,-0.034388956,6991,11475,6440,5859.5,15.5,5.5,0.019794442,0.020196281,9013.5,15.5,21.5,7633,7764,-0.0019672979,0.0004807084,0.00389652,-0.00086669764,0.00025448253,0.0039111767,-0.0019783224,0.002533875,0.0014448252,0.005488889,0.0017821931,-0.00087773765,-0.0010253603,0.008778657,0.014108144,0.008137917,0.0035202657,0.012012201,0.0008337313,-0.0053896117,-0.00012967325,0.007896756,-0.013636023,-0.004925461,-0.006244551,0.0018923935,-0.01000452,-0.020625679,0.0034220745,-0.0044753184,0.010009717,0.0014287878,-0.0074594007,-0.00029906706,0.0028168727,0.01363184,-0.01098955,-0.0020869784,-0.009749878,-0.036713187,-0.005893808,-0.00033428127,0.00379892,-0.0026823638,0.007859641,-0.0047698445,0.018687088,0.00804574,0.00034970057,0.0020545523,-0.006493149,-0.00091244373,0.0011354825,-0.0033160613,0.009184739,-0.00034404796,0.009324375,0.0013281427,0.0060842503,0.019397436,0.0018022497,0.008242172,-0.007684694,0.0008217104,0.004595595,0.0016945921,-0.001027771,-0.004540284,0.0011109143,0.0043724375,-0.0010835547,-0.0031360302,0.0020580094,0.004589617,-0.016316814,-0.009363616,0.0028365727,-0.00866811,-0.002113246,0.00074755354,-0.00037850693,0.005019422,0.007262032,0.0006282187,-0.0042524296,-0.011724762,-0.008972491,-0.005379909,9.297575e-05,-0.0032324009,0.0064838366,0.0025538974,-0.017541278,-0.0021931161,-0.00079205784,-0.0061829956,0.00014219354,0.0065813023,-0.004751686,0.00058510975,0.0043894616,0.011286839,-0.00651228,0.00057445036,0.005919333,0.01226776,-0.0050153434,0.0024215411,-0.03315421,-0.00865675,0.0014934002,-0.008993676,-0.0022182649,0.0068090484,0.003799796,-0.0011319096,0.0015375459,0.0073920586,-0.003981636,0.0011768617,-0.0069427527,-0.0014860196,0.010591315,-0.000545839,-0.0006694519,0.00075866474,0.006785076,-0.0034061961,-0.0012199216,0.0043052332,-0.0072279773,-0.0015680165,-0.0021817177,-0.013504446,-0.0028121674,0.005606117,0.008032452,0.0040528933,-0.00032181686,0.0043825493,-0.0003228017,-0.00330988,-0.00094342063,0.011343273,0.0056549637,-0.010941979,0.004483485,0.009360204,0.00012704586,0.0045957393,-0.0129230535,0.0073806657,-0.010957077,-0.00016092972}, {6,7,1,0,8,2,5,0,3,0,0,6,4,2,5,4,4,1,6,8,8,255,255,8,6,1,2,7,8,6,5,6,8,1,0,255,0,8,6,8,0,8,8,8,8,0,8,0,4,6,4,4,6,4,3,7,6,8,4,2,5,255,8,8,8,255,8,0,0,0,0,0,8,0,8,0,255,255,8,255,255,255,255,8,8,8,8,8,0,8,6,0,8,255,4,5,5,0,0,2,6,4,2,1,1,0,7,3,4,4,0,5,5,0,0,8,8,8,2,0,8,2,0,8,255,8,8,8,8,8,8,0,0,8,0,8,8,255,255,255,8,8,8,255,255,255,255,255,8,8,0,0,6,6,4,8,8,8,8,2,6,8,8,0,2,4,255,4,1,2,1,2,0,8,8,4,8,8,6,8,8,1,8,6,1,8,8,6,8,255,1,6,7,5,8,8,255,255,0,8,8,4,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,65535,65535,43,45,47,49,51,53,55,57,59,61,63,65,65535,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,65535,117,119,121,65535,123,125,127,129,131,133,135,137,139,141,65535,65535,143,65535,65535,65535,65535,145,147,149,151,153,155,157,159,161,163,65535,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,65535,225,227,229,231,233,235,237,239,241,243,245,247,65535,65535,65535,249,251,253,65535,65535,65535,65535,65535,255,257,259,261,263,265,267,269,271,273,275,277,279,281,283,285,287,289,65535,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,323,325,327,329,331,333,65535,335,337,339,341,343,345,65535,65535,347,349,351,353,355,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,65535,65535,44,46,48,50,52,54,56,58,60,62,64,66,65535,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,65535,118,120,122,65535,124,126,128,130,132,134,136,138,140,142,65535,65535,144,65535,65535,65535,65535,146,148,150,152,154,156,158,160,162,164,65535,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,65535,226,228,230,232,234,236,238,240,242,244,246,248,65535,65535,65535,250,252,254,65535,65535,65535,65535,65535,256,258,260,262,264,266,268,270,272,274,276,278,280,282,284,286,288,290,65535,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,326,328,330,332,334,65535,336,338,340,342,344,346,65535,65535,348,350,352,354,356,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({2125,1199.5,1738.5,734.5,1199.5,3050.5,2857.5,588.5,754,20.5,3600,2423,2005,41.5,4584,689.5,631,5032.5,895.5,1435,942.5,4.5,18.5,16.5,1391.5,1432.5,8164,26.5,3202,2.5,5432.5,67,719.5,18.5,2131.5,656,11.5,1548,2071,18.5,18.5,0.021081463,0.059735514,1890,1205,2680,6677.5,4.5,2157.5,686,15.5,3,2031,2021.5,6474.5,17,316.5,15.5,3259.5,8108.5,4560.5,10434,5510.5,64.5,207.5,-0.03644519,4844,625.5,678,20.5,18.5,6.5,868.5,20302,3750.5,1491.5,8.5,1411.5,18.5,913,1087,15.5,0.03711332,2.5,2.5,1438,2267.5,0.008967729,17.5,0.030260075,0.002237085,2333.5,12.5,2337.5,20.5,2780.5,1008.5,6.5,-0.048297886,0.010491878,18.5,5254,16.5,18.5,18.5,19,5.5,475.5,21.5,319.5,-0.013477437,6.5,2613.5,19.5,2842,2323.5,12473.5,18.5,10.5,5989,5061,5573.5,5522.5,27.5,28.5,21.5,256.5,-0.0057011284,9028,0.009039758,16,0.0733592,20.5,678.5,-0.022178024,7,3332.5,514,-0.010214428,19.5,16.5,8434.5,-0.012563023,20302,7260.5,20.5,19,2.5,10.5,985,15.5,6.5,3447,5.5,12.5,0.016323395,-0.02028314,6.5,17,1220,1508.5,2085.5,2640,13.5,15.5,970,2341.5,7.5,0.01123683,3,-0.018994743,1313.5,1313.5,18.5,0.0061171954,1527.5,-0.0075954306,6.5,11,-0.021977693,15,-0.023618229,13,15,20.5,14.5,6161,1584,4512.5,-0.0127989,-0.0029944906,9602.5,7479,13,-0.0040732403,7471.5,-0.00789814,0.006873288,5,18.5,0.014323272,-0.007350032,15.5,2.5,2478.5,2600,3108.5,4145,2163.5,279,16,3344,4462.5,1.5,1.5,15.5,7232.5,6.5,6554.5,7938,6367,4613.5,5483.5,5643.5,8534,5810.5,11241.5,-0.0007817341,0.002117882,-0.014279823,-0.0045202225,0.0032310204,0.022818659,-0.009247728,0.00035438835,0.002020191,-0.0013904589,0.003808995,-0.0014575239,0.0050084363,0.04380308,0.007225308,-0.0018220845,0.003565516,0.00567339,0.030869344,0.0100428965,-0.00077413826,-0.0048090206,-0.027235469,-0.0039127762,-0.0116254855,-0.025851382,0.0035887056,0.00025253205,-0.0006108274,-0.010196695,-0.01061308,-0.00571827,0.0026053186,-0.008354646,-0.014356852,0.017167352,-0.0034493878,0.018371833,-0.008897191,0.007366862,0.0024274294,-0.0048401146,-0.008671689,-0.024374789,0.0020779916,-0.0010752723,0.018918654,5.2109997e-05,0.004901396,0.010317972,0.004938867,0.0017926842,0.010267816,0.019212058,0.0022620475,-0.007512489,0.026312584,-0.0014406646,0.00088987045,0.02816993,0.00023313465,0.004828075,-0.009100224,0.00014418164,0.0015767204,-0.0015157702,-0.012960883,-0.029013515,0.0032831356,-0.0012553474,0.01754989,0.00014763839,0.001861562,0.004776858,0.006117886,0.032536715,-0.0013907694,-0.013368823,-0.017794585,0.0029005078,0.005271827,0.012228009,0.002329513,-0.00045343014,-0.008369121,-0.0013466268,0.0010277743,-0.00333042,-0.00752412,-0.017516397,0.00017309184,-0.004321651,-0.006242218,-0.01559113,0.0050656395,-0.0015156904,-0.0013761403,0.012056139,-0.0052147303,0.00086281303,-0.0007799695,-0.0042160414,0.009522392,-0.0005986879,-0.0015302929,-0.008918615,-0.0041321195,-0.008961715,-0.0017861968,-0.0002828649,-0.003914384,-0.015257484,0.0052410006,0.0015949227,-0.0056506502,-0.013298317,-0.0047200928,-0.0011800786,-0.0041197087,0.0039559803,-0.008296641,0.00043889947,0.004144842,0.024856769,-0.010972135,0.00068172964,0.008266035,0.0008076868,0.034759242,0.0065504024,0.004263039,0.0011441358,0.0025936586,0.018142967,-0.021084933,-0.006010724,-0.00056298624,-0.004069516,0.002892805,-0.00073586113,-0.006518481,-0.0016802484,-0.0006688353,0.0022086864,-0.0021751174,0.0037128914,0.003512048,-0.0059304642,-0.0064122984,-0.01983962,-0.00010492804,0.004091986,0.0027857085,0.018422352,-0.007445472,-0.0013648558,0.0031405177,-0.0010828112,-0.030502522,-0.0030506689,0.002296852,-0.0059038503,0.005923224,0.019816918,-0.00061980996,-2.909684e-05}, {6,7,7,6,6,2,2,7,7,8,2,6,1,0,7,6,6,0,5,0,2,8,8,8,3,0,4,0,7,8,5,7,0,8,2,0,8,0,4,8,8,255,255,5,6,4,0,8,6,1,8,8,3,1,2,8,2,8,7,6,7,6,5,6,6,255,0,2,0,8,8,8,0,0,2,0,8,5,8,0,1,8,255,8,8,0,7,255,8,255,255,0,8,2,8,0,1,8,255,255,8,2,8,8,8,8,8,2,8,4,255,8,7,8,2,3,2,8,8,7,7,4,5,7,1,8,7,255,0,255,8,255,8,1,255,8,0,0,255,8,8,0,255,0,0,8,8,8,8,4,8,8,4,8,8,255,255,8,8,6,4,4,5,8,8,5,7,8,255,8,255,4,4,8,255,0,255,8,8,255,8,255,8,8,8,8,4,5,0,255,255,0,0,8,255,0,255,255,8,8,255,255,8,8,7,7,5,0,0,0,8,6,6,8,8,8,1,8,0,4,4,1,7,3,0,0,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,65535,65535,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,65535,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,65535,159,161,163,165,65535,167,65535,65535,169,171,173,175,177,179,181,65535,65535,183,185,187,189,191,193,195,197,199,201,65535,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,65535,235,65535,237,65535,239,241,65535,243,245,247,65535,249,251,253,65535,255,257,259,261,263,265,267,269,271,273,275,277,65535,65535,279,281,283,285,287,289,291,293,295,297,299,65535,301,65535,303,305,307,65535,309,65535,311,313,65535,315,65535,317,319,321,323,325,327,329,65535,65535,331,333,335,65535,337,65535,65535,339,341,65535,65535,343,345,347,349,351,353,355,357,359,361,363,365,367,369,371,373,375,377,379,381,383,385,387,389,391,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,65535,65535,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,65535,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,65535,160,162,164,166,65535,168,65535,65535,170,172,174,176,178,180,182,65535,65535,184,186,188,190,192,194,196,198,200,202,65535,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,65535,236,65535,238,65535,240,242,65535,244,246,248,65535,250,252,254,65535,256,258,260,262,264,266,268,270,272,274,276,278,65535,65535,280,282,284,286,288,290,292,294,296,298,300,65535,302,65535,304,306,308,65535,310,65535,312,314,65535,316,65535,318,320,322,324,326,328,330,65535,65535,332,334,336,65535,338,65535,65535,340,342,65535,65535,344,346,348,350,352,354,356,358,360,362,364,366,368,370,372,374,376,378,380,382,384,386,388,390,392,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4.5,6788,31866.5,5920.5,6969,10453,16313,2.5,10800,6967.5,7642.5,8845.5,11577,27139.5,18879.5,6894,3057,8354.5,6884.5,7432,0.0244613,8055.5,11325.5,14.5,8903.5,13164,18964.5,24247.5,12.5,18281,16671.5,92,272,3801,5787,6420,8403.5,25163,11887.5,6495.5,9252,6194.5,6471.5,7256.5,28200.5,4063,8597,8238,8298.5,12998.5,7.5,10920.5,20542.5,-0.01597904,12.5,12592,8425.5,15940,18624,18,12.5,27.5,1117,-0.017623033,9138,1225,8872.5,4152.5,6039,1.5,2.5,-0.024272759,10892.5,0.014390849,1.5,6305.5,6055.5,6241,9892,9336.5,1.5,1007,9292.5,2.5,1.5,7102.5,7918.5,1.5,21726,1326,4052,4758.5,8210,7383.5,6.5,8283.5,9729,11496,9662.5,20494.5,21490,10548,21437.5,19025,20183,10.5,-0.0033192534,11244,18561.5,0.0013816974,31781,-0.00891202,18426.5,22223.5,12208.5,28063,-0.0047170483,21224,24082.5,3638,75.5,1376,1855.5,5821.5,7038.5,323.5,2375.5,3760.5,15542,2862,5922.5,2329.5,5020.5,5312,7605,7038,6681.5,9399.5,1.5,0.00493871,-0.0025942028,6432.5,6300.5,1.5,11617.5,5848.5,1.5,7424.5,12250,6895.5,0.0017844504,0.01217099,0.0053712963,721,3089,6186,6905,0.0042129694,0.0009588208,7962.5,7079.5,6095.5,7988.5,8086.5,7935,22185,10618.5,22333,27279.5,406,1258,3671.5,11126.5,646,1994.5,7517,8078,-0.018861884,10784,5.5,12.5,4457,6,6896.5,10444,10832.5,10419,15.5,13663,11557,13139,11241.5,24274.5,10536.5,10547.5,13188.5,20489,13359.5,24871,17387,17420.5,0.0015570053,-8.6961685e-05,8425.5,11315.5,-0.0039535444,-0.0028718486,32304,16.5,17920,32309,16.5,18574.5,-0.009733149,30426.5,10,-0.0036141274,18936.5,21266,20457.5,30603,0.0006110811,0.007647728,0.009305631,0.0012889112,-0.004096336,-0.016458467,0.008822578,-0.001814871,0.0067511024,0.021443477,-0.01472636,0.0027270701,0.0010344699,-0.005167234,0.013069141,0.00027325432,-0.00045235103,-0.0040477,0.0018236783,-0.0049339016,-0.0015732332,0.003586705,-3.9134808e-05,-0.005387712,-0.0046641356,0.00493125,0.0060377344,-0.002386293,0.0006806211,0.0128419055,-0.0025974975,0.0014825546,0.0026795047,-0.007422031,-0.0042493953,0.0058751935,-0.0035074612,-0.0083716875,-0.0075172433,0.0010395654,0.0018607632,-0.0058443765,-0.0010249204,0.0074204593,-0.00096528727,0.004581628,0.0032928344,-0.005586964,0.009964219,0.0033198576,0.0028133402,-0.006755562,-0.0080855405,0.023481948,0.0047273897,-0.0040282514,-0.004283307,-0.011231886,0.004256485,0.009212005,-0.016219368,0.00048474158,0.0124392,0.0064227767,-0.0035555225,-0.009900981,0.0016952305,-0.008160329,-0.0096257,-0.02736489,0.0028140561,-0.0018539362,0.013862915,-0.004725441,-0.0032190722,-0.020630062,0.035023794,-0.0015664293,0.0062556765,0.0011801163,0.0025520439,0.0001574159,0.0033857753,0.00069006835,-0.0070285234,-0.00041447158,-0.0011193963,0.0019705303,-0.00807381,-0.0009981091,0.0004438678,0.004019973,-0.00086333015,0.003050589,-0.00031558363,0.0019827231,-0.0019448389,0.00027755531,0.0068126093,0.021226075,-0.010853014,0.000656011,0.0014648631,0.008684171,-0.0057397187,-0.0017205252,-0.014828319,-0.022899728,-0.0020380325,-0.00016111856,-0.00064176304,0.023628704,0.00083589694,-0.02121448,-0.0013288817,-0.023362985,0.0003822896,-0.010082076,0.0052437703,0.01411347,-0.0057608215,0.00037542827,-0.014540913,-0.009297352,-0.0053818873,0.014287989,0.0052467817,-0.0011638998,0.0035624676,0.007729473,0.0013321595,-0.0023492144,0.00036362486,-0.02712715,0.0050928034,-0.011327028,-0.0002131778,-0.005777761,0.014366852,-0.0017866035,0.00216299,0.016191052,-0.0056343265,0.0067559923,0.01053646,-0.0061100563,-0.0014008839,0.00017941147,-0.0002340793,-0.0033628184,0.0021885012,-0.0010488244,0.0012578575,-0.0027100937,-0.0038779897,-0.0053748144,-0.0011175465,-0.011349093,0.0007218022,-0.00022135333,0.0007468965,-0.00069750746,-0.0032666984,-0.012056318,-0.0022888158,-0.00085584924,0.00019212406,-0.0010351498,-0.00013822621,0.0009221627,-0.005750857,-0.00029901043,-0.00032009342,-0.0009647712,3.484954e-05,0.0011291144}, {8,5,6,1,5,5,3,8,2,5,4,4,5,4,5,7,1,6,6,3,255,6,5,8,4,6,2,0,8,7,1,0,4,6,0,4,6,2,2,3,3,2,3,3,7,5,4,6,5,0,8,2,0,255,8,1,0,5,7,8,8,1,1,255,6,2,0,1,3,8,8,255,6,255,8,3,5,6,0,1,8,0,0,8,8,3,3,8,4,4,3,6,5,0,8,5,4,4,6,0,4,2,6,3,4,8,255,1,1,255,4,255,1,0,0,0,255,1,3,4,2,0,0,0,2,0,5,0,2,6,4,3,1,4,1,2,4,0,8,255,255,1,5,8,6,3,8,0,6,5,255,255,255,2,1,6,6,255,255,1,2,6,5,1,3,4,4,1,5,5,5,3,0,7,1,5,0,255,1,8,8,3,8,3,5,6,7,8,1,5,7,7,4,2,0,1,7,1,2,5,1,255,255,0,1,255,255,0,8,1,2,8,7,255,4,8,255,3,1,7,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,65535,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,65535,105,107,109,111,113,115,117,119,121,65535,123,125,127,129,131,133,135,65535,137,65535,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,65535,203,205,65535,207,65535,209,211,213,215,65535,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,259,65535,65535,261,263,265,267,269,271,273,275,277,65535,65535,65535,279,281,283,285,65535,65535,287,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,65535,323,325,327,329,331,333,335,337,339,341,343,345,347,349,351,353,355,357,359,361,363,365,367,65535,65535,369,371,65535,65535,373,375,377,379,381,383,65535,385,387,65535,389,391,393,395,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,65535,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,65535,106,108,110,112,114,116,118,120,122,65535,124,126,128,130,132,134,136,65535,138,65535,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,65535,204,206,65535,208,65535,210,212,214,216,65535,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,65535,65535,262,264,266,268,270,272,274,276,278,65535,65535,65535,280,282,284,286,65535,65535,288,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,65535,324,326,328,330,332,334,336,338,340,342,344,346,348,350,352,354,356,358,360,362,364,366,368,65535,65535,370,372,65535,65535,374,376,378,380,382,384,65535,386,388,65535,390,392,394,396,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({5.5,5547.5,10945,1353.5,6490.5,8815.5,21732.5,422.5,1557.5,9324,7792.5,15.5,9215,20968,17465,362.5,550.5,774.5,1731.5,5082,9860,7533.5,8054.5,9061.5,8179.5,4659.5,9308.5,13888,20029.5,21391,23456,22.5,1.5,459.5,1242.5,686,2.5,2329,2128,9081.5,7213.5,5469.5,1.5,8069.5,7990.5,9555.5,12689,8079,12.5,3712,7046.5,9207,8487,7251,9658,13952.5,18327,20225,19779.5,10193,15.5,22608,23691,37.5,65.5,372.5,94,4.5,1250.5,3276,1145.5,544.5,-0.026639452,2221,2227.5,2.5,3.5,2.5,2778.5,3705,1.5,7112.5,8364.5,0.012457579,0.0055287885,5267.5,5990.5,7360.5,8178.5,7456.5,7423.5,7650,7613,11073,16994.5,5313,7959.5,8000.5,7843.5,390.5,4141,6893.5,2026.5,4336.5,4618.5,7798.5,8839,5597.5,5691,7251,18.5,10660,11313.5,19492.5,18413.5,12803.5,23791.5,19277.5,30614.5,26094,19770.5,15804.5,21516.5,21224.5,22358,18822,31379,27,55.5,109,56.5,-0.00014596652,0.005622731,0.0045270114,0.009532244,382.5,-0.011349733,19471,2676,1331,-0.012204997,1913.5,1707.5,1684,-0.007100567,8280.5,4447.5,2657.5,6172,2371,2698,2598,2885.5,2101.5,4.5,3137,3068,1.5,5366.5,-0.019530527,4.5,5323,0.02161332,7519,1.5,0.002280894,0.0076178955,4.5,7992.5,8013,7745,0.010803003,8060.5,2014.5,7930,9210,1.5,7924.5,9616,9367,7367,4.5,8611,8176.5,20653.5,1320.5,5334.5,10039.5,10665.5,7894,7584.5,7597,8101.5,369,467,18.5,4155,5516.5,6505,8366,4083,9126.5,12.5,9071.5,-0.017482676,9015,8012,8823.5,9015.5,19.5,9229,9835,9268,6822,8281,9710.5,7208,10550.5,12935.5,7.5,18835.5,19982.5,15782.5,11501,17578.5,-0.0060318396,18007,18192,28571,0.0138153685,-0.0016165836,21455.5,0.019179137,10002.5,6828,20830.5,11502.5,0.011961274,0.006757735,0.009424928,0.0031193893,-0.0066652047,22463,22234,-0.004753523,20474.5,27806.5,23424.5,30199.5,-0.0014600813,0.010849709,-0.009939305,-0.027278066,0.002338009,-0.0057988246,-0.0076759807,0.00047209402,-0.010097734,-0.024361981,-0.006713375,-0.0126038855,0.003729761,0.0009956134,0.002747049,-0.0050529893,-0.010287429,-0.022880357,0.0029371004,-0.0037452735,0.0056720395,-0.000758972,-0.004421061,0.008767194,0.018208917,-0.004160126,0.0188004,0.0028594413,-0.006459011,0.002447073,0.0009265639,-0.01678617,-0.0022367763,0.02033743,-0.0055426294,-0.019281631,-0.01721979,6.231843e-05,0.009026813,-0.008653221,0.017569896,0.00092208193,-0.0043618837,0.0010657285,-1.590809e-05,0.0017285561,-0.0041369665,-0.00094044406,0.005661879,0.0030820847,-0.0032111162,-0.0006948477,-0.007271785,-0.0018557574,-0.016226327,-0.0032172874,-0.03108265,-0.016015936,2.8516472e-05,0.0019157281,0.0010292138,0.0028239924,-0.00070220017,0.0019268919,-0.004086809,-0.022097684,0.005084688,0.0012253154,-0.017820157,0.0050054546,0.020411951,0.007837637,-0.0016291104,0.013743049,-0.00661784,-0.027706647,-0.012862535,-0.0016032081,-0.019749016,-0.0007299272,0.008979135,0.0036393476,-0.009043062,0.0024249367,-0.00042326617,0.0026498379,0.018704358,0.003421338,-0.0009355151,-0.0052424925,0.0026652878,0.00015332931,-6.214948e-05,-0.0018103261,0.0044016875,-0.00029077896,-0.0012463122,-0.021438556,-0.03417574,-0.0046204207,0.0034631768,0.011143906,0.0071487958,0.00077459455,-0.0009846103,-0.0043598595,0.004814198,-0.0012209212,-0.00024108616,-0.015886754,0.016537119,0.0016761053,-3.2370644e-06,-0.0020863896,0.022688806,0.0007287991,0.0031988327,-0.0019792137,-0.0049990285,-0.024817085,0.0018020675,-0.011202781,0.0020937826,0.005910638,-0.005536524,-0.012929762,-0.0101279495,-0.023952901,0.003081422,-0.0029989877,0.0022546332,-0.004693053,-0.015952906,-0.035778593,-0.023258546,-0.0073373835,0.005682541,0.0002723737,0.0021058335,0.003995653,-0.0006575281,-0.006415156,0.005330788,-0.0022748667,0.005626211,0.01281102,-0.0031092984,0.012732001,-0.024768079,-0.0050680432,0.0064753215,-0.00035753087,0.002522139,-0.0023719317,0.00053242035,0.009063481,-0.008467051,-0.0008871173,-0.004800037,0.0031641924,0.011230101,0.0027578284,-0.0070530623,0.0064115706,0.005453124,0.00066881155,-0.0024282914,0.014731198,0.011921028,-0.0016736574,0.018347846,0.013391956,0.0022942186,-0.009734522,0.0025514923,0.006750221,0.00080582796,-0.007547395,0.0043350044,0.0007230653,0.0031997473,-0.0012016251,0.0106950635,-0.0024118468,-0.0038011011,0.004900383,-0.012838758,-0.0030317286,-0.0016216256,0.0017195769,-0.011079216,-0.00036355652,0.010915794,0.0011008134,0.0038216633,-2.3893528e-05,-0.0029212667,-0.00033633618}, {8,4,1,6,4,0,0,6,7,7,6,8,0,2,1,7,7,3,7,6,7,6,4,1,0,1,0,7,0,7,0,1,8,1,4,1,8,4,7,0,3,1,8,7,4,3,0,1,8,0,2,2,4,4,0,6,6,3,6,3,8,3,6,0,2,0,0,8,2,0,3,1,255,6,6,8,8,8,7,5,8,3,6,255,255,1,5,7,5,0,7,3,4,0,6,2,6,0,4,1,3,7,1,3,1,5,0,2,1,3,8,2,7,7,7,1,3,1,2,0,5,1,2,3,0,6,0,0,4,6,3,255,255,255,255,3,255,0,0,6,255,0,2,0,255,0,0,2,0,0,0,0,0,6,8,5,1,8,5,255,8,6,255,1,8,255,255,8,6,0,5,255,2,0,7,0,8,6,7,6,0,8,4,1,0,2,2,2,7,2,3,2,0,1,0,8,3,4,2,0,7,2,8,0,255,0,5,0,4,8,0,6,0,7,4,0,2,6,2,8,6,5,1,1,5,255,3,0,2,255,255,0,255,3,5,2,3,255,255,255,255,255,1,0,255,1,1,3,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,65535,145,147,149,151,153,155,157,159,161,163,65535,65535,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,65535,65535,65535,65535,257,65535,259,261,263,65535,265,267,269,65535,271,273,275,277,279,281,283,285,287,289,291,293,295,297,65535,299,301,65535,303,305,65535,65535,307,309,311,313,65535,315,317,319,321,323,325,327,329,331,333,335,337,339,341,343,345,347,349,351,353,355,357,359,361,363,365,367,369,371,373,375,377,65535,379,381,383,385,387,389,391,393,395,397,399,401,403,405,407,409,411,413,415,417,65535,419,421,423,65535,65535,425,65535,427,429,431,433,65535,65535,65535,65535,65535,435,437,65535,439,441,443,445,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,65535,146,148,150,152,154,156,158,160,162,164,65535,65535,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,65535,65535,65535,65535,258,65535,260,262,264,65535,266,268,270,65535,272,274,276,278,280,282,284,286,288,290,292,294,296,298,65535,300,302,65535,304,306,65535,65535,308,310,312,314,65535,316,318,320,322,324,326,328,330,332,334,336,338,340,342,344,346,348,350,352,354,356,358,360,362,364,366,368,370,372,374,376,378,65535,380,382,384,386,388,390,392,394,396,398,400,402,404,406,408,410,412,414,416,418,65535,420,422,424,65535,65535,426,65535,428,430,432,434,65535,65535,65535,65535,65535,436,438,65535,440,442,444,446,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7.5,931.5,944.5,1143,4785,745,1173,87.5,2.5,2.5,5102.5,588.5,18.5,1794,1248.5,50.5,763.5,2540.5,4.5,1484,3747,5.5,5308.5,535.5,907,532.5,748,1241,1763.5,20.5,1384.5,64.5,40,455,811.5,1405.5,2308,1855,2368.5,1459,2135,4.5,3768,5700.5,5529.5,3036.5,5779,479.5,530.5,376,385,0.007854076,927,0.06454661,937,12.5,1890.5,18.5,12.5,18.5,1352,15.5,1683.5,132,24,73,39.5,102.5,459.5,0.01073419,1153,1184.5,-0.020739796,-0.0029753824,0.0010707636,1632.5,2485.5,1371.5,2308,969,1468,2075.5,3754.5,2134.5,1134,3744,783.5,2939,4918,2939,5654.5,4351.5,5242.5,4.5,5792,406,598,328.5,850.5,16,18.5,168,4514.5,655.5,850,982,0.050792027,1292.5,1369,19,1142.5,1435.5,1726,5729.5,1086.5,1250.5,1213.5,926.5,2083.5,12.5,5042.5,1519.5,10500.5,116.5,38,-0.018861597,76.5,2.5,4,4.5,80.5,37.5,201,516,474.5,1113.5,20656.5,-0.01174924,-0.0049370737,0.022300862,1704,-0.02293502,741,0.017749714,1548,-0.006688855,6426.5,1.5,1.5,0.024075693,0.0048410054,1362.5,3715.5,3364,8396,1526,2075,1758.5,1828.5,1964.5,6922.5,7932.5,1340,4968.5,7504,2.5,2.5,4930.5,6.5,5015.5,-0.01360296,2483.5,5679,5190.5,7237.5,6490,5593,6763,5281,378.5,20.5,18.5,592.5,20.5,21.5,-0.015496025,893.5,-0.03842786,-0.008206411,1329,471.5,18.5,15.5,732.5,12.5,15.5,1153,15.5,1156,517.5,809.5,838,975.5,1187.5,1034.5,15,20.5,15,5829.5,16,2550.5,1595,1282,2481,0.0037378226,5032.5,7208.5,0.009861599,1286.5,1058.5,0.01639527,3188.5,1634.5,0.056321234,0.019764235,981,1291,1218,14394.5,18.5,18.5,8855,21732.5,0.00022891951,0.00734405,0.0009282224,-0.0064175674,-0.00562681,0.0026184288,0.008583484,0.0013801554,-0.003688847,-0.0010279244,0.01852943,0.008611651,0.009109047,-1.993888e-05,-0.008936736,-0.0013186426,0.004168582,-0.0025527317,-0.008302079,-0.022416113,-0.011518912,-0.003717189,-0.010822608,-0.00017559383,0.0014146086,-0.010899672,-0.00044116416,0.009218774,-0.005769623,0.0036372442,-0.02313832,-0.010632382,0.003991702,-0.0023945828,-0.0051170406,-0.0027016324,0.006295441,0.00094197405,-0.008400147,0.004017311,-0.015623979,0.017153429,0.0012553934,-0.0020459562,0.004956666,-0.0031377238,-0.0017767567,0.016405197,-0.003608136,0.0041174474,0.004005198,0.05256128,-0.0031438924,0.002741996,-0.0076403837,-0.00029419162,0.0047102002,0.0011711388,0.0059252107,-0.00217833,-0.0067572184,-0.0002089151,-0.013392568,-0.0054764072,-0.0038554699,-0.016886754,0.0006129292,-0.001998356,0.005855216,0.00147043,-0.001045813,-0.011288027,0.00024201465,0.002226822,-0.0068306327,-0.0009998019,-0.012031463,-0.0059954217,-0.00835158,0.0028761649,0.0016083258,0.009772743,-0.010683714,0.0022453903,-0.0043365094,0.00022299336,0.0010120543,-0.0050821025,0.020060336,-0.0037818775,0.0056381556,2.2152342e-05,0.000104626015,-0.0058528166,0.0065672733,-0.00656522,-0.0068984474,-0.023992,-0.0043205232,0.00042923205,0.0058552003,-0.008172201,0.01783148,-0.001927323,0.011651226,0.002407126,-0.010356667,0.0007999275,-0.0052066366,-0.022186568,0.004638539,-0.010514824,-0.019054621,-0.006303783,0.00093620777,-0.0016769813,0.007484813,0.0019990595,0.001115396,0.0053904317,-0.005911163,0.00011972046,0.0029159216,-0.0018140984,0.010934611,0.005813723,0.0074725696,-0.009551134,0.0016025318,0.021519748,-0.012558388,0.018712262,-0.023267701,-0.00751282,-0.0041051586,-0.01978141,0.007860653,-0.032740682,-0.01950434,-0.037030023,-0.0059101204,-0.018142244,0.008670554,-0.006400738,-0.011605386,-0.0060015745,-0.0139960125,0.008964683,0.004646171,-0.0012652348,0.010018643,0.02070202,-0.00876366,0.0042777765,0.0034692478,-0.006378799,-0.015252612,-0.009176201,-0.00533369,0.001235177,0.0006355997,0.003860286,-0.02621952,-0.007187009,0.009190106,0.02121103,-0.012165285,-0.0036514685,-0.0028755139,0.0030508223,0.0011642417,-0.0031471306,-0.02136494,-0.009512474,0.00034287336,-0.003727046,0.0017649144,-0.009443796,0.0050902097,0.026212374,-0.0001989499,-0.0010277812,0.00066294847,-0.00032293767}, {8,7,4,6,0,5,5,6,8,8,0,4,8,2,4,7,1,4,8,4,7,8,2,5,6,0,5,1,1,8,4,6,0,0,0,4,0,4,2,4,5,8,5,1,4,5,2,4,4,1,1,255,5,255,4,8,0,8,8,8,5,8,4,2,1,7,2,7,1,255,1,4,255,255,255,0,4,0,0,7,4,4,1,7,7,2,2,7,0,7,7,7,3,8,2,5,7,2,3,8,8,0,0,0,6,5,255,2,4,8,4,6,6,1,7,3,4,6,0,8,2,4,1,2,6,255,6,8,8,8,4,1,6,2,6,2,0,255,255,255,2,255,1,255,0,255,0,8,8,255,255,3,0,0,5,6,4,6,7,5,2,4,0,2,4,8,8,0,8,0,255,7,0,2,1,1,3,1,0,4,8,8,2,8,8,255,0,255,255,2,1,8,8,5,8,8,2,8,1,6,1,3,1,4,5,8,8,8,0,8,2,0,3,2,255,0,0,255,5,4,255,0,0,255,255,2,5,7,0,8,8,2,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,65535,103,65535,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,65535,135,137,65535,65535,65535,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,65535,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,65535,237,239,241,243,245,247,249,251,253,255,257,65535,65535,65535,259,65535,261,65535,263,65535,265,267,269,65535,65535,271,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,65535,309,311,313,315,317,319,321,323,325,327,329,331,333,335,65535,337,65535,65535,339,341,343,345,347,349,351,353,355,357,359,361,363,365,367,369,371,373,375,377,379,381,383,385,387,65535,389,391,65535,393,395,65535,397,399,65535,65535,401,403,405,407,409,411,413,415,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,65535,104,65535,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,65535,136,138,65535,65535,65535,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,65535,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,65535,238,240,242,244,246,248,250,252,254,256,258,65535,65535,65535,260,65535,262,65535,264,65535,266,268,270,65535,65535,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,65535,310,312,314,316,318,320,322,324,326,328,330,332,334,336,65535,338,65535,65535,340,342,344,346,348,350,352,354,356,358,360,362,364,366,368,370,372,374,376,378,380,382,384,386,388,65535,390,392,65535,394,396,65535,398,400,65535,65535,402,404,406,408,410,412,414,416,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6.5,11876.5,19425,11072,15334,21791.5,17581.5,10566,11283.5,8507.5,15498.5,15563.5,19399.5,17237.5,11050.5,9005.5,8528,8911,9208,13552.5,1.5,15223.5,16864,12.5,13650,18152,-0.014655541,30835.5,28633,15.5,32429.5,7778,9873,5930.5,10347,0.030760512,11275,7098,10852.5,7452,13574.5,11507,16086,11599.5,4.5,17171.5,21973,6395,6305.5,13319,17583.5,3817.5,22330.5,15121.5,17.5,20856,15.5,0.0069868104,0.0016506462,26132.5,19811,7592.5,3.5,1.5,10011.5,10718.5,5.5,11804.5,9942,10657,0.015299015,11581,11810,1.5,7904.5,7316.5,1.5,-0.014621249,1.5,9663.5,14132,11856,15835.5,13025,0.021783449,15792,15839.5,15123.5,1.5,18316,22423,1270.5,10548,12220,9998,13852,13343.5,13812,20861,15.5,17,10494,13437,1634,-0.0060936133,20441.5,20441.5,16934.5,16.5,32010,21985,18422,23915,18.5,29647.5,7778,6814.5,6635,9685.5,9795.5,9916,6773.5,10348.5,2.5,10896,8836.5,-0.009210643,11664,-0.019636173,11022,10993.5,11130,11241.5,4163,6961.5,4.5,11567.5,-0.02462099,-0.005467017,6304,1.5,4282.5,-0.015235712,8969,13566.5,6422,3007,-0.026733873,11934,0.016632326,13014,11624.5,15281.5,0.0198784,19760.5,0.002596101,0.0114837615,2.5,15839.5,15574.5,-0.0037557178,18060.5,1.5,5424,16419,12854,20903.5,16264.5,25038,446,1030.5,5061,13094,4543,2691.5,9989,14211,10133.5,12.5,-0.025756508,28710,0.018302005,17148.5,18097,22686.5,2575.5,1060,10403.5,10403.5,16.5,0.01250571,-0.0020466358,16.5,31940.5,25263,0.0072570145,25637.5,-0.003033312,31912,0.013061176,19.5,20796,21461.5,12887.5,8.5,30656,22142,22787.5,25886,30145,19816,3155.5,3135.5,29620.5,29696.5,0.00013418267,0.0045567816,-0.0025359935,0.010380809,-0.0015223793,-0.00737435,-0.00042402442,0.0043752496,0.008276142,-0.008128363,0.0027565898,-0.009711016,-0.0014383852,-0.013816567,0.0009621998,0.004837627,-0.0038274557,-0.0007815904,-0.015592678,-0.0074434737,-0.027298024,-0.005647437,0.0012494697,0.0076757446,0.00046890028,-0.0059012095,-0.020941753,-0.008236344,0.0093842,-0.0071442463,0.0015054371,-0.0028146876,0.001346661,-0.005887981,0.012342714,0.0023113727,0.017393682,0.009671213,-0.0062019713,0.0035047703,-0.0011000652,0.0053249295,0.009904406,-0.010398484,0.0022471582,-0.00025864036,-0.01301408,-0.0034158346,0.0112276,0.005468694,-0.0029731558,-0.013806914,-0.004833521,0.00019294847,-0.004499353,0.005717737,-0.0014049794,0.006812072,-0.0056928652,0.022483101,-0.009843129,0.0018564012,-0.011721978,-0.00020410337,-0.002361714,0.0007035104,0.0010470649,0.0027944972,-0.0015129739,0.00016411475,-0.0022453335,0.011294396,0.00679034,-0.012755439,0.0016603848,0.017649198,0.0036487535,-0.0013495403,0.0011674062,0.009801283,-0.0003766666,-0.014313419,1.7891847e-05,-0.007851137,0.00051306904,-0.00038456896,-0.0010927906,0.0026282538,-0.012338272,-0.0015118913,0.002926911,-0.0006285126,0.0027639186,-0.0038666192,0.00025893058,0.0013804907,-0.009357775,-0.0013168546,-0.0010092856,-0.028998425,0.0010843077,-0.004214197,-0.00035309506,-0.008999399,-0.0004851561,-0.0021585706,-0.0022481626,-0.008737646,-0.0037214065,-0.0090482095,0.0139077855,-0.008737881,-0.004538796,-0.0003724063,0.0005610208,-0.0009372461,0.0013149608,0.0038817157,0.007735067,0.0009401167,-0.002691479,0.0027841793,0.007591148,0.0031753238,0.007609018,0.0043684426,-0.007463708,-0.0018667799,0.00057780347,-0.0019445479,0.00069103483,-0.0038363163,0.003362953,0.00035524802,0.008583213,0.005358767,0.0018690715,0.0068091596,0.00504381,0.00076953456,0.00288409,0.005754137,-0.00076752173,-0.0018034208,0.0011841357,0.006013974,-0.0013166795,-0.0031668076,0.0017226435,8.597165e-06,-0.0056071463,-0.0005478861,0.007643388,0.0020417876,0.0012377313,-0.00015533756,-0.0014193931,0.0013320986,0.00018585355,0.0033900605,0.00021760537,0.0012527693,-0.0008294779,0.00011573249}, {8,4,3,0,6,5,7,0,0,3,6,4,3,6,1,3,4,4,1,4,8,2,6,8,1,0,255,1,0,8,5,6,3,7,6,255,0,3,1,7,4,7,4,1,8,7,6,1,7,1,0,2,0,6,8,3,8,255,255,2,0,6,8,8,3,0,8,5,3,4,255,0,2,8,7,7,8,255,8,1,1,5,2,0,255,0,0,1,8,7,6,0,2,2,5,2,1,1,0,8,8,1,1,4,255,0,0,5,8,0,6,2,0,8,0,7,2,5,0,2,0,0,4,8,0,5,255,1,255,6,4,2,0,1,2,8,0,255,255,6,8,7,255,0,6,3,1,255,1,255,3,7,7,255,0,255,255,8,0,2,255,2,8,0,6,7,2,1,1,7,1,5,1,3,1,5,1,0,8,255,4,255,2,1,0,0,0,0,0,8,255,255,8,3,2,255,0,255,1,255,8,0,4,7,8,0,3,5,6,2,3,2,4,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,65535,53,55,57,59,61,63,65,67,65535,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,65535,65535,111,113,115,117,119,121,123,125,127,129,131,65535,133,135,137,139,141,143,65535,145,147,149,151,153,155,65535,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,65535,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,65535,237,65535,239,241,243,245,247,249,251,253,65535,65535,255,257,259,65535,261,263,265,267,65535,269,65535,271,273,275,65535,277,65535,65535,279,281,283,65535,285,287,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,65535,321,65535,323,325,327,329,331,333,335,337,65535,65535,339,341,343,65535,345,65535,347,65535,349,351,353,355,357,359,361,363,365,367,369,371,373,375,377,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,65535,54,56,58,60,62,64,66,68,65535,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,65535,65535,112,114,116,118,120,122,124,126,128,130,132,65535,134,136,138,140,142,144,65535,146,148,150,152,154,156,65535,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,65535,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,65535,238,65535,240,242,244,246,248,250,252,254,65535,65535,256,258,260,65535,262,264,266,268,65535,270,65535,272,274,276,65535,278,65535,65535,280,282,284,65535,286,288,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,65535,322,65535,324,326,328,330,332,334,336,338,65535,65535,340,342,344,65535,346,65535,348,65535,350,352,354,356,358,360,362,364,366,368,370,372,374,376,378,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({546.5,542.5,540.5,62,17.5,528.5,641,71.5,404,8,0.05268345,1167.5,7212,18.5,686,92,26.5,374,6.5,-0.003503926,12.5,645,771,537,20.5,580,592.5,16.5,500.5,90.5,87,22.5,12.5,318,390.5,665,573.5,11.5,14,432.5,15.5,0.0011573486,18.5,15.5,6,2.5,876,0.010217107,1.5,-0.013219607,565.5,787,1029,480,893,74.5,1994,22.5,18.5,12.5,13.5,4.5,32.5,22,1664,486,8,4.5,445,20.5,665,-5.655853e-05,2.7320653e-05,0.001204673,1.766427e-05,6.5,-0.008257445,615.5,700,-0.008699256,-0.0019916152,2.5,-0.015505919,2.5,16,9009.5,18.5,0.0020486983,-0.00798587,595,8.5,-0.005350129,0.056475013,510,2.5,-0.025674582,-0.005909447,868,20.5,1309.5,987.5,32.5,33.5,20.5,48.5,13.5,79,5167,7064,5.5,0.0034137324,90.5,36.5,156.5,5.5,15.5,132,93.5,18.5,643.5,2.5,1.5,-0.024898393,0.0014476314,0.00047229495,538.5,451,0.0062702806,1.5,410.5,492,15.5,20.5,-0.008843854,-0.019380251,-0.011794622,-0.032343145,-0.024670875,21.5,-0.0028766932,-0.007217256,0.0062590004,-0.022352558,14.5,-0.00440593,-0.0005015671,0.0038986814,15.5,0.0025293035,608,-0.015118973,563,621,3,1.5,0.0026744583,4358.5,18,1947,0.0075753205,3935,1418,1511.5,21.5,1018,0.00039371065,0.004782061,-0.021740193,-0.0065836827,0.0071688513,-0.00042382922,-0.0038607884,0.00094184355,-0.0020129944,-0.006811242,-0.014314169,-0.008648193,0.0015503081,-0.003787974,-0.009510118,0.0034054925,-0.0051327376,-0.0014177113,-0.0063248426,-0.018401818,-0.003578644,-0.012601349,0.0003256249,-0.006306088,-0.018676661,-0.007497132,-0.00047272156,0.009502827,0.0016469135,-0.005274237,0.0023124884,-0.009793403,0.0033728722,-7.471258e-05,-0.0041838037,0.0008460755,-0.00088913285,-0.01226712,-0.004018312,-0.013528543,-0.015529347,0.004547651,-0.0061822548,0.003668572,0.0035675652,-0.00010729327,0.0037889548,0.018204607,0.05101409,-0.007741975,-0.011166627,-0.027226955,0.0014486237,0.015513726,-0.0082537485,0.00047729813,-0.0003966994,0.009597412,0.00102042,-0.0011624399,0.003949055,-0.0033571094,-0.0032298602,0.002025806,-0.003224056,0.0014480789,-0.0010775089,-0.0041871825,-0.003000954,-0.00909123,0.00081071904,-0.003602874,0.0022302112,-0.03815421,0.0037230407,-0.00077966286,0.051309723,0.0028461132,-0.0059635486,-0.0008712789,-0.0043433714,-0.022811616,0.0024568539,0.030139148,-0.014140807,-0.00013540457}, {0,0,1,1,8,5,0,0,1,8,255,2,6,8,0,2,7,1,8,255,8,2,0,1,8,0,0,8,2,5,3,7,8,0,1,3,2,8,8,5,8,255,8,8,8,8,0,255,8,255,1,4,6,3,3,4,6,1,8,8,8,8,1,2,4,0,8,8,0,8,3,255,255,255,255,8,255,0,0,255,255,8,255,8,8,2,8,255,255,1,8,255,255,6,8,255,255,1,8,7,2,1,7,8,0,8,6,6,5,8,255,0,1,4,8,8,6,0,8,2,8,8,255,255,255,0,1,255,8,2,0,8,8,255,255,255,255,255,8,255,255,255,255,8,255,255,255,8,255,0,255,1,0,8,8,255,4,8,0,255,0,0,6,8,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,65535,21,23,25,27,29,31,33,35,65535,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,65535,79,81,83,85,87,65535,89,65535,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,65535,65535,65535,65535,133,65535,135,137,65535,65535,139,65535,141,143,145,147,65535,65535,149,151,65535,65535,153,155,65535,65535,157,159,161,163,165,167,169,171,173,175,177,179,181,65535,183,185,187,189,191,193,195,197,199,201,203,65535,65535,65535,205,207,65535,209,211,213,215,217,65535,65535,65535,65535,65535,219,65535,65535,65535,65535,221,65535,65535,65535,223,65535,225,65535,227,229,231,233,65535,235,237,239,65535,241,243,245,247,249,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,65535,22,24,26,28,30,32,34,36,65535,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,65535,80,82,84,86,88,65535,90,65535,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,65535,65535,65535,65535,134,65535,136,138,65535,65535,140,65535,142,144,146,148,65535,65535,150,152,65535,65535,154,156,65535,65535,158,160,162,164,166,168,170,172,174,176,178,180,182,65535,184,186,188,190,192,194,196,198,200,202,204,65535,65535,65535,206,208,65535,210,212,214,216,218,65535,65535,65535,65535,65535,220,65535,65535,65535,65535,222,65535,65535,65535,224,65535,226,65535,228,230,232,234,65535,236,238,240,65535,242,244,246,248,250,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4006.5,18.5,4169.5,2415,395.5,4491.5,4230,483.5,7430,98.5,31,3851,4246.5,5785.5,4262,67,435.5,3319,-0.019018197,87.5,3150.5,20.5,546.5,18.5,15.5,3388.5,-0.014515539,4992,5844.5,20.5,4379.5,64.5,811,7675.5,4.5,3206,3425,26.5,85.5,1497.5,5167,766,166.5,1178,562,7.5,-0.014236248,6.5,18.5,8.5,5738.5,17.5,4154,5250.5,2706.5,2.5,3551,4366.5,5314.5,132,46,44.5,5492,1041,12.5,2.5,1430,1860,3654.5,6923.5,6407.5,22,54,85,20.5,26.5,2522.5,21.5,5809.5,0.019222429,0.009494814,0.037535887,0.018108895,328.5,495.5,906.5,2910,5.5,-0.0081150355,4801.5,12.5,3472,2802,1.5,-0.00408407,12.5,17.5,2867,1878.5,3317.5,5464,5017,9906,0.018934075,14904,5034,7814.5,0.0034006827,-0.000808045,4980.5,4,1801.5,5317.5,27.5,51.5,76,4.5,29.5,4.5,5930.5,7130.5,645,1014,4491.5,876,1904.5,1331.5,15.5,12.5,15,3100.5,3565,7.5,3228.5,2898.5,7760,-0.015453937,23,22.5,40.5,21.5,-0.01664172,38.5,29.5,42.5,152.5,47,1934,-0.010440058,841,3096.5,567.5,180,21.5,408,0.014708838,0.05217893,374.5,2190,762.5,3916,-0.006055489,6.5,2.5,-0.0067133144,-0.0099850325,-0.0064287498,4084.5,4037.5,0.0024902083,3583,-0.0043891235,4.5,6697,3687,0.008286396,0.004080813,3593,4.5,18.5,3544,5919,14.5,-0.006747181,8.5,4887,15.5,3447.5,9.5,1.5,16.5,4251,7056,6.5,11.5,4323,2,4373.5,6476,18.5,2739,1.5,6400,-0.00083343213,0.0014385479,-0.0011414802,-0.013849906,-0.011692036,-0.020935856,-0.0023407226,-0.0070997956,0.0032497142,-0.005451027,-0.0002643227,0.0054086293,-0.00152992,-0.010688574,0.002913148,9.666881e-05,-0.011292711,-0.030757347,-0.011423433,-0.0049524237,-0.0037844707,0.0030546682,0.0016566496,-0.0056039393,0.0019653717,-0.0072861337,-0.002317811,0.008272799,0.0005010482,-0.0037563124,-0.004201559,-0.0003165661,0.01637583,0.0011101238,-0.0009599868,0.0022669553,0.0040818914,0.009128637,0.00082858605,-0.0046554166,-0.002313989,-0.007969924,0.003334513,-0.0021561251,0.0014470404,-0.0004836199,-0.0039753052,0.0031497094,0.0072577945,0.002980653,0.0025440184,-0.004117984,0.0031828869,0.009271001,-0.0076455795,0.00071855966,0.006533788,-0.0003098007,-0.006800808,0.002955241,-0.0058522816,-0.014921457,0.0020857777,-0.005325685,-0.00855334,-0.019737834,-0.0056339763,0.011678475,0.024524441,0.008339887,0.0035521395,-0.010118879,-0.0013988538,0.0016475728,0.02007308,0.07996341,-0.018466828,0.0008640702,-0.031447243,-0.011246878,0.0020019908,-0.014757367,-0.0071780565,0.0061822026,-0.0018918765,0.0039592977,0.00084237166,-0.000624496,-0.0021326398,0.0009300367,0.0013415754,-0.0012962166,0.0028569777,0.0067282068,-0.0049723694,-0.0019277864,-0.00022208477,0.003294918,0.0077168616,0.0013839636,-0.0054268083,0.00070692296,-0.008984665,-0.0036578446,-0.0016029825,0.0011662206,-0.0024883456,-0.018781954,-0.0013256861,-0.0046825516,-0.008008115,-0.0043087965,-0.0041806703,-0.001284567,-0.0068182456,-0.0131544,-0.00016442574,-0.008645072,0.004536267,0.009635824,-0.0043859365,0.0036899399,-0.0026006515,-0.009111677,-0.0009978467,0.0067914687,-5.0414248e-05,-0.0011967152,0.0018452777,0.005612335,-0.00030685062,-0.0025337734,0.009769897,0.0051080226,-0.005223499,0.0047860625,-0.005348418,-0.0019964173,-0.0034808912,0.0079327775,0.0053363903,-0.007019446,0.00091028755,-0.015440446,0.0032223256,0.030336937,-0.005927944,0.0011825132,-0.0203897,-0.006381608,-0.00050033734,-1.5610785e-05}, {0,8,0,1,1,7,1,0,4,2,6,2,1,0,1,7,1,1,255,6,7,8,0,8,8,1,255,0,3,8,1,6,2,6,8,1,1,5,7,7,6,0,2,4,3,8,255,8,8,8,5,8,1,5,1,8,5,1,0,2,0,1,3,2,8,8,0,0,5,6,4,6,7,0,8,7,7,8,3,255,255,255,255,4,0,1,3,8,255,4,8,1,1,8,255,8,8,1,6,7,0,5,6,255,0,2,0,255,255,5,8,6,0,2,6,4,8,0,8,7,3,2,0,2,0,0,0,8,8,8,3,5,8,0,4,5,255,0,1,2,8,255,1,0,0,2,7,6,255,2,2,2,0,8,7,255,255,5,0,1,5,255,8,8,255,255,255,0,0,255,1,255,8,2,1,255,255,2,8,8,1,2,8,255,8,5,8,1,8,8,8,1,0,8,8,3,8,1,0,8,6,8,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,65535,37,39,41,43,45,47,49,65535,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,65535,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,65535,65535,65535,65535,153,155,157,159,161,65535,163,165,167,169,171,65535,173,175,177,179,181,183,185,187,65535,189,191,193,65535,65535,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,65535,249,251,253,255,65535,257,259,261,263,265,267,65535,269,271,273,275,277,279,65535,65535,281,283,285,287,65535,289,291,65535,65535,65535,293,295,65535,297,65535,299,301,303,65535,65535,305,307,309,311,313,315,65535,317,319,321,323,325,327,329,331,333,335,337,339,341,343,345,347,349,351,353,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,65535,38,40,42,44,46,48,50,65535,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,65535,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,65535,65535,65535,65535,154,156,158,160,162,65535,164,166,168,170,172,65535,174,176,178,180,182,184,186,188,65535,190,192,194,65535,65535,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,65535,250,252,254,256,65535,258,260,262,264,266,268,65535,270,272,274,276,278,280,65535,65535,282,284,286,288,65535,290,292,65535,65535,65535,294,296,65535,298,65535,300,302,304,65535,65535,306,308,310,312,314,316,65535,318,320,322,324,326,328,330,332,334,336,338,340,342,344,346,348,350,352,354,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({11419,14660,11076.5,15549.5,12.5,10088,18645.5,12120.5,1083,15069,10674,6101,10270,12585.5,20670.5,10014.5,11436.5,5,10231.5,5074,32005.5,7967,24006.5,11440,17.5,-0.021052657,10470.5,14491,1.5,18172,13912,10011,9458,7.5,14107.5,4109,-0.013508496,11.5,-0.009191403,14542,2.5,1.5,10795,27213.5,15773.5,11097.5,15366.5,10959,7.5,4.5,0.008551607,10674,13276.5,7853,14295,22012,24050,13364,20848.5,26201,20525.5,7103,0.0143309925,7284,7862,10265,7696,7.5,16,-0.0083950525,-0.0036568944,7532.5,11777,10843.5,14722.5,10796,7967,12208.5,17419.5,1.5,7.5,25850.5,16.5,9321,11601.5,12200,12958.5,20681,30526,0.0017241063,13,11614,11066,8611,10284.5,9122,10931,3.5,10286.5,6089,11571.5,-0.014349908,11565.5,12868.5,16741,21534.5,16123,21427,19578.5,1.5,23488.5,16868,13319,18894.5,24117,7012.5,9881,0.026330734,10346,6887.5,10927.5,8568.5,11378.5,7545.5,15139,6.5,0.0055232183,0.026024932,0.00901315,0.0024000227,3,5669.5,15.5,3215,9.5,6.5,2.5,-0.010707948,13435,4.5,16129,18195.5,18912.5,16983.5,18388,0.0013315846,6.5,2.5,10868.5,17963,0.012931277,15.5,-0.00728172,13865,15,8167.5,16194,8718,14331,18.5,11220,26402,7250.5,10066,5544,0.00083077914,-4.255629e-05,-0.00083193573,2.5,17.5,16.5,0.0042405636,0.00782461,9763,0.006916606,9594.5,18.5,0.0052234307,0.009595272,0.0054163258,10586.5,0.010342437,4.5,4331,11985,7.5,10756.5,7,5.5,15011.5,17120.5,0.0004583165,18049.5,16423.5,15776.5,0.015115018,0.0054145823,13314,14,16668.5,20520,15243,5.5,22316.5,2.5,11687,24693.5,26371,13512,20960.5,18841,20903.5,22958,-0.0002842232,-0.005662634,9.935456e-05,0.0076114545,0.0005097025,0.0048634964,-4.4785826e-05,0.009175076,-0.024719562,-0.007136938,0.0076242066,0.00017852841,-0.005433399,-0.0014326267,0.00046067583,-0.006560088,0.0034691659,-0.003032556,-0.003832612,-0.0007673026,-0.005002408,0.0008398414,-0.00020769022,-0.00082335615,-0.0023423675,-0.00396812,-0.0002895124,0.0033007113,-0.005320819,-0.0018361409,-0.0068148794,-0.0016993865,-0.0019495821,0.000126248,-0.0026811254,-0.007650634,-0.0017091427,-0.0068767304,-0.0019012608,-0.011740429,0.015074781,-0.004546557,-0.006284238,-0.0018066233,0.000435009,-0.0059994548,0.004153538,0.0006786778,-0.0026814023,-7.690679e-05,-0.00220174,-0.0050387504,-0.0020692113,-0.0031455494,-0.00080626406,-0.004693835,-0.005005248,0.00043670592,-0.01221726,-0.0071758376,-0.00070801476,-0.0031587144,-0.007389949,-0.0012416076,0.0023457336,-0.005302313,0.001326494,-0.0054142238,0.0020361086,0.0095357,0.0013598475,0.00032820713,-0.004170678,-0.010946437,-0.0018172696,-0.009683749,0.0030087484,-0.0020423224,0.0031495288,-0.0012572333,0.00047442425,-0.0028173174,0.0015132142,0.00036762803,-0.0017808555,-0.0005829652,-0.0003175703,7.463071e-05,0.0042071017,0.0031298527,0.0050656307,0.008603821,2.624008e-05,0.002066231,0.0039828042,0.0020891314,0.0027081647,-0.0012969875,0.0014462614,-0.0011517126,0.0066185803,0.0028703024,-0.0042332327,0.0058471235,-0.017422756,-0.008393331,-0.0023200398,0.003708149,0.025164662,0.018067893,0.0018077858,-0.0018882271,0.012847262,0.005598862,-0.003907903,-0.0010146777,-0.0041259737,-0.009164898,0.0036468257,0.00210758,0.0014368246,0.00804614,-0.0057521486,-0.0004981667,0.011680069,0.015745692,0.0048402823,0.0003591524,0.0013060247,0.006468795,-0.013658481,-0.0068032877,-0.0013616144,0.0023932075,-0.00052394497,-0.0068611265,0.013051522,-0.00026006074,0.009313539,-0.001701778,-0.008468549,-0.0028081038,-0.017446883,-0.003451918,0.0014418038,-0.0020532277,0.0075120847,-0.0068517714,0.0007005083,-0.0028334956,0.0035919547,1.3257655e-05}, {1,4,0,6,8,3,0,0,5,6,7,2,3,3,0,1,5,8,5,7,0,5,6,1,8,255,2,6,8,1,1,1,0,8,0,0,255,8,255,6,8,8,3,2,4,1,7,0,8,8,255,0,7,6,0,3,4,1,1,0,6,3,255,3,3,3,1,8,8,255,255,3,0,5,0,5,5,0,2,8,8,6,8,1,0,2,3,0,4,255,8,5,0,4,0,5,0,8,0,6,1,255,1,2,0,3,1,2,3,8,4,7,1,6,0,3,0,255,6,2,7,4,3,1,2,8,255,255,255,255,8,4,8,3,8,8,8,255,0,8,0,4,2,0,4,255,8,8,1,4,255,8,255,0,8,0,4,0,7,8,1,6,1,1,1,255,255,255,8,8,8,255,255,0,255,0,8,255,255,255,2,255,8,6,0,8,2,8,8,0,0,255,0,0,0,255,255,7,8,1,0,6,8,1,8,1,0,0,1,0,7,2,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,65535,51,53,55,57,59,61,63,65,67,69,65535,71,65535,73,75,77,79,81,83,85,87,89,91,93,65535,95,97,99,101,103,105,107,109,111,113,115,65535,117,119,121,123,125,127,65535,65535,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,65535,165,167,169,171,173,175,177,179,181,183,185,65535,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,65535,217,219,221,223,225,227,229,231,65535,65535,65535,65535,233,235,237,239,241,243,245,65535,247,249,251,253,255,257,259,65535,261,263,265,267,65535,269,65535,271,273,275,277,279,281,283,285,287,289,291,293,65535,65535,65535,295,297,299,65535,65535,301,65535,303,305,65535,65535,65535,307,65535,309,311,313,315,317,319,321,323,325,65535,327,329,331,65535,65535,333,335,337,339,341,343,345,347,349,351,353,355,357,359,361,363,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,65535,52,54,56,58,60,62,64,66,68,70,65535,72,65535,74,76,78,80,82,84,86,88,90,92,94,65535,96,98,100,102,104,106,108,110,112,114,116,65535,118,120,122,124,126,128,65535,65535,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,65535,166,168,170,172,174,176,178,180,182,184,186,65535,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,65535,218,220,222,224,226,228,230,232,65535,65535,65535,65535,234,236,238,240,242,244,246,65535,248,250,252,254,256,258,260,65535,262,264,266,268,65535,270,65535,272,274,276,278,280,282,284,286,288,290,292,294,65535,65535,65535,296,298,300,65535,65535,302,65535,304,306,65535,65535,65535,308,65535,310,312,314,316,318,320,322,324,326,65535,328,330,332,65535,65535,334,336,338,340,342,344,346,348,350,352,354,356,358,360,362,364,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31867.5,11419,17012,2554.5,13139,18342.5,1.5,18.5,1232.5,14114.5,13201,15706.5,16411,21726,31838.5,1024.5,312.5,2104,2562,10422,19724.5,28330,17996,12538.5,32324.5,9,19049,19048,27134,18677.5,32211.5,1266.5,1106.5,126.5,637,15.5,13,-0.026014984,7774.5,9306,11596.5,11590.5,17365.5,3.5,-0.023493169,11416,20775.5,10770.5,15288.5,-0.008266476,-0.014430063,2.5,-0.008773973,19870,5,31838.5,18623.5,23840.5,30102.5,18399.5,19114.5,32194,17.5,1254,14.5,1065.5,893,35.5,20.5,595.5,720,1755.5,5582.5,6.5,18,7227,7712,29302,11174.5,11919.5,13335,7.5,5.5,10137,26151.5,14048,-0.0059986943,17050,1.5,17920,20084,2.5,15.5,5.5,4.5,0.00020594515,-0.003510135,3,20964,18752.5,7.5,18795,17075,-0.0010844826,19727,23415,24256.5,-0.0023547746,30792,31385.5,18949.5,17,19911.5,6,18127,21224,23536.5,78,14.5,1500,2195,15.5,1092.5,855.5,1136.5,34.5,50,2368.5,1972.5,326,0.054366227,671.5,2132,2.5,6.5,-0.020621208,19,2780.5,7.5,-0.0071576745,20,7182.5,6642,7795.5,9356,8560,-0.010093213,7093,2.5,5,7.5,1.5,14501,14329.5,14329.5,0.022094531,12108,26094,20981.5,15.5,15.5,-0.0028252045,0.00016620818,13276.5,3249,23898.5,20818.5,6.5,19529,18417,17465,0.0012377904,4.5,11588,31980,-0.0069449344,15.5,2,-0.003316595,0.0010353784,19315,-0.0015374132,16,-0.0025422403,2.5,-0.0024423155,-0.0018939438,18429,19080,0.00078109436,19046,18661.5,19824.5,20995,24197.5,23802,24748,30269,-0.0010605537,2.5,19729,18429,29811.5,6.5,-0.00073891116,15.5,22297.5,-0.0029063758,16.5,17.5,18265,18644,21266,31995,24143.5,0.00041598626,-0.0008539141,0.020279674,-0.006019411,-0.010418675,-0.0025800702,0.0065636947,-0.010692816,0.021345334,-0.03959377,0.0021858204,0.025224466,0.00036032812,-0.013869779,0.005250002,2.0438358e-05,0.0019348679,0.015443643,-0.0042358316,0.0010601336,-0.0037095032,0.0062458483,-0.010645221,-0.0014886033,0.036053285,0.0022737351,-0.02513892,-0.014136381,0.0067675076,0.0006389368,0.00400399,-0.00640359,-0.018878417,-0.009065529,-0.0018849876,-0.0005098545,-0.0044828495,-0.00013783615,0.0017061429,0.0067356923,0.0029877545,-0.004149069,-8.397467e-05,-0.0033103859,-0.0007174125,0.0027878655,-0.022066893,0.002621527,-0.0043193973,-0.0001322872,0.0046114675,0.001267917,0.0018834611,-0.015157727,0.002434679,0.0002754143,0.00040164287,-0.0010516035,-0.0033020284,0.003568804,0.0044494905,-0.009287078,-0.0011700824,0.004660205,-0.0066587403,-0.0028806997,0.00032882692,0.00534682,0.01332216,0.017925492,0.004216799,0.00034245008,0.0018735519,-0.0010025755,0.014211433,0.0069405804,0.006155697,0.001397878,0.0025574134,0.0075720237,2.6914071e-05,0.00334662,0.009828951,-0.002866592,-0.0049803164,0.0019191739,0.015666423,0.010993271,-0.010341174,-0.00068128406,0.010874636,-0.0029982058,-0.00091490237,0.00022425629,-0.0023107778,-0.0003578062,-0.0029095267,-0.0012614185,-0.0054137236,-0.0035006478,-0.0029631497,-0.005675157,-0.0008962242,-0.0020328294,-0.0006286062,0.0001300923,0.0009829355,-0.0013166476,-0.00010452017,-0.0008959672,-0.0012067677,-0.0023112004,0.003068309,0.0013413753,0.0018305829,0.0030140604,0.0027487732,0.007453558,0.005418027,0.0035323016,0.00092145475,-0.00045791533,0.000599664,3.1540116e-05,0.0010736306,0.0006141456,0.0014261656,0.00057087594,-0.00013879225,0.00029304126,-0.0035831623,-0.0018709804,0.00084796175,-0.00038261915,-0.0029719945,-0.0052362746,-0.0026207177,-0.001505837,-0.00034812946,4.5946694e-05,0.0028407637,0.0009393788,0.00092758855,0.00030525614,-0.0020661259,-0.0027299593,0.00048157107,-0.00046250952,-0.0026061882,-0.0006909493,-0.00026054098,0.0007332956,-0.006554601,-0.0002097816,0.0016746782,-0.000843809,-0.0001828739,0.00032607184}, {0,1,5,6,3,1,8,8,7,2,3,5,2,3,2,7,1,2,6,2,0,0,0,1,0,8,7,7,1,3,6,6,1,2,0,8,8,255,1,4,1,1,1,8,255,6,2,3,1,255,255,8,255,1,8,2,1,7,1,7,3,2,8,6,8,7,3,0,8,0,0,0,0,8,8,5,0,0,5,0,5,8,8,3,0,5,255,5,8,1,0,8,8,8,8,255,255,8,1,1,8,1,7,255,1,5,5,255,5,2,1,8,1,8,3,1,7,0,8,6,2,8,1,2,4,0,6,6,2,4,255,6,1,8,8,255,8,0,8,255,8,1,1,1,1,2,255,3,8,8,8,8,0,0,0,255,7,0,2,8,8,255,255,7,6,3,3,8,1,1,1,255,8,1,6,255,8,8,255,255,1,255,8,255,8,255,255,1,1,255,5,3,3,1,3,1,5,1,255,8,1,1,2,8,255,8,1,255,8,8,3,1,1,0,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,65535,75,77,79,81,83,85,65535,87,89,91,93,65535,65535,95,65535,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,65535,163,165,167,169,171,173,175,177,65535,65535,179,181,183,185,187,189,65535,191,193,195,65535,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,65535,241,243,245,247,65535,249,251,253,65535,255,257,259,261,263,265,65535,267,269,271,273,275,277,279,281,65535,283,285,287,289,291,65535,65535,293,295,297,299,301,303,305,307,65535,309,311,313,65535,315,317,65535,65535,319,65535,321,65535,323,65535,65535,325,327,65535,329,331,333,335,337,339,341,343,65535,345,347,349,351,353,65535,355,357,65535,359,361,363,365,367,369,371,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,65535,76,78,80,82,84,86,65535,88,90,92,94,65535,65535,96,65535,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,65535,164,166,168,170,172,174,176,178,65535,65535,180,182,184,186,188,190,65535,192,194,196,65535,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,65535,242,244,246,248,65535,250,252,254,65535,256,258,260,262,264,266,65535,268,270,272,274,276,278,280,282,65535,284,286,288,290,292,65535,65535,294,296,298,300,302,304,306,308,65535,310,312,314,65535,316,318,65535,65535,320,65535,322,65535,324,65535,65535,326,328,65535,330,332,334,336,338,340,342,344,65535,346,348,350,352,354,65535,356,358,65535,360,362,364,366,368,370,372,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({1906.5,1439,1916.5,1411.5,1403,18,3836.5,536.5,5.5,821.5,1689,6.5,1990.5,2830,3846,481.5,942,2.5,12.5,21.5,1141.5,1641.5,1236,2167.5,1567,0.04982124,1973.5,2028,3564,7977,1512.5,67,1202,937,973.5,1.5,984.5,1085,1574,5.5,817,4.5,12,12.5,18.5,1.5,1568,4937,2,13.5,12,0.0028199346,-0.0071314494,14.5,2036,3767,3622.5,-0.02398745,-0.007066098,2093.5,3333,64.5,207.5,386.5,304,455,19,5.5,3511.5,0.003906063,1114.5,0.023211397,1263.5,0.011256596,1770,14.5,19.5,1225.5,11.5,0.002643848,0.03858396,3.5,19.5,1055.5,1259,1057.5,14.5,16.5,0.035156876,0.020070527,15.5,724.5,3050.5,0.010732862,0.00026485042,-0.0009066645,4095,4127.5,15.5,7.5,4904.5,7.5,15.5,2434.5,2997,18.5,3811,3,2175.5,18.5,5865,18.5,4929,22,28.5,20.5,29.5,420.5,18.5,12.5,12.5,2536.5,709.5,4.5,0.049910273,951.5,986.5,15.5,18.5,0.0025313986,0.0003442713,0.010357126,0.0012520674,11.5,6.5,2198,0.012125986,1183.5,1085,1773.5,2.5,1225.5,1225.5,949.5,0.008978134,16.5,858.5,0.012743138,6.5,16,15.5,1074,5,1593,18.5,4,-0.0075665726,1160.5,-0.021296613,602,1094.5,2445,6735,-0.005514617,-0.0011168459,0.005269355,0.00069625926,4127.5,-0.0033502032,-0.0012263177,-0.009069325,0.004552857,15.5,3.5,13,-0.0030757037,20,12.5,-0.023775848,18.5,2805.5,2.5,2321,17.5,7.5,3594.5,4.5,2165.5,4661,17.5,5122.5,7490.5,934.5,3406,3700.5,3219,1916,-0.001911187,0.00023011319,-0.0111538805,-0.002626614,0.0019612599,0.014639854,0.004024912,-0.00094684353,-0.022014132,-0.011550084,-0.0048619765,-0.0142051475,-0.010044565,-0.0021093169,0.0032083516,-0.0016989544,0.006214353,-0.00026608142,-0.0035470542,0.0024399196,-0.00034690517,0.0008973957,-0.0029530744,0.003937883,-0.0037809703,-0.018512148,0.0006677358,-0.0045810626,0.0024993257,0.014292142,-0.008113963,0.0014181278,-0.0020119257,0.0019698795,0.0085708825,-0.00017251058,-0.0011756074,0.0024820473,-0.0030322035,0.0008462201,-0.00035307335,-0.008506614,-0.0021199111,0.017966514,-0.000120438344,-0.018991232,-0.0050207945,0.0029944158,-0.0152064655,-0.003052076,-0.014590803,-0.030194754,0.013663341,-0.032692824,-0.008525504,-0.018003648,0.0004332161,-0.009846145,0.009002834,0.0031487972,-0.00862627,-0.0027283765,0.023799604,-0.004432447,0.0067110225,0.016109394,-0.0019361072,0.008971444,0.0012712831,0.016081668,0.0025628477,-0.009466417,-0.0028555244,-0.020218922,-0.0047613014,0.0010569791,0.0012191851,-0.008767552,-0.0003818329,-0.0024915289,0.00023722067,0.0007628059,-0.00066452625,-0.003937037,0.0021559128,-0.0046567414,-0.016140487,-0.005384854,0.0040294644,-9.7531694e-05,0.0035607652,-0.0024233626,0.00408392,0.018103603,0.0009262398,0.005890772,-0.005200693,-0.0002456959,-0.019470895,-0.00358613,-0.010483195,-0.02209695,0.0007049995,-0.0058245393,0.0051771076,-0.018032202,0.023350604,0.0091343215,-0.0038594608,-0.025384663,-0.0015500688,0.0013763312,0.00024412664,-0.010131451,0.014347647,-0.0022164683,0.001057478,-0.0048530134,-0.0038160663,-0.021532731,0.002882327,0.00024120475,-0.0014348825,0.008399195,-0.0040679346,-0.0004945473,-0.0025352694,-6.4540545e-06}, {5,4,5,4,2,8,6,5,8,1,2,8,0,0,6,4,4,8,8,8,7,2,6,7,3,255,1,5,0,0,1,7,2,4,4,8,3,0,7,8,3,8,8,8,8,8,1,0,8,8,8,255,255,8,6,4,0,255,255,3,4,6,6,1,0,6,8,8,1,255,0,255,3,255,3,8,8,0,8,255,255,8,8,0,0,3,8,8,255,255,8,1,2,255,255,255,0,0,8,8,0,8,8,0,1,8,2,8,4,8,7,8,6,2,1,8,0,7,8,8,8,0,4,8,255,4,5,8,8,255,255,255,255,8,8,0,255,1,0,4,8,0,0,1,255,8,1,255,8,8,8,5,8,0,8,8,255,0,255,1,3,0,2,255,255,255,255,0,255,255,255,255,8,8,8,255,8,8,255,8,0,8,4,8,8,0,8,4,0,8,6,2,0,5,5,7,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,65535,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,65535,65535,101,103,105,107,65535,65535,109,111,113,115,117,119,121,123,125,127,65535,129,65535,131,65535,133,135,137,139,141,65535,65535,143,145,147,149,151,153,155,65535,65535,157,159,161,65535,65535,65535,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,65535,219,221,223,225,65535,65535,65535,65535,227,229,231,65535,233,235,237,239,241,243,245,65535,247,249,65535,251,253,255,257,259,261,263,265,65535,267,65535,269,271,273,275,65535,65535,65535,65535,277,65535,65535,65535,65535,279,281,283,65535,285,287,65535,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,323,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,65535,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,65535,65535,102,104,106,108,65535,65535,110,112,114,116,118,120,122,124,126,128,65535,130,65535,132,65535,134,136,138,140,142,65535,65535,144,146,148,150,152,154,156,65535,65535,158,160,162,65535,65535,65535,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,65535,220,222,224,226,65535,65535,65535,65535,228,230,232,65535,234,236,238,240,242,244,246,65535,248,250,65535,252,254,256,258,260,262,264,266,65535,268,65535,270,272,274,276,65535,65535,65535,65535,278,65535,65535,65535,65535,280,282,284,65535,286,288,65535,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({18.5,1994.5,7603.5,1463,2801.5,8943.5,14531,858.5,1165,12.5,4339.5,3971.5,9046,7832.5,18418,755.5,2297.5,1792,1767.5,2323.5,2784,4129,5195,2311.5,5920.5,7809.5,9410,7253.5,7838,1421.5,29216.5,505,1645.5,1185.5,2413.5,837,3.5,1480.5,3050.5,4.5,3245,2137,15.5,3108.5,6162,5404,5427,783.5,4364.5,4547.5,5290.5,0.006775375,4754,4692,9508,6121.5,7772,-0.029070914,6995.5,-0.019059371,17605.5,18526,24783,438,606,14.5,1352.5,15.5,1266.5,3,16220.5,4.5,15.5,5798,1818.5,1297.5,15.5,6.5,1752,1796,2178.5,2230,2710,16.5,2102,4455.5,4455.5,3258,3352,4309.5,6876.5,1634.5,6643,15.5,5295,532,626,143.5,15550.5,8462,5590.5,5029.5,8554.5,8856.5,5235.5,4440.5,10456,5525.5,11267.5,11614.5,7727.5,7111.5,8012,5244,8300.5,19564,29679.5,18465.5,26210,24764.5,24724.5,84.5,865.5,7.5,543.5,866.5,1226,363,5.5,1705,1715,1462,1118,4035,16.5,7615,11965.5,664,664,1332,1332,602,8103,4.5,2189.5,15.5,1669.5,2117.5,2117.5,2.5,12.5,3592.5,2075.5,1264,2253,2180.5,7.5,831.5,5541,4.5,4196,1809,2088,15.5,2223.5,3148.5,-0.0019616194,3627,0.0015896788,6.5,2828.5,3150,3393.5,3781,4397.5,-0.017819313,7861.5,934.5,2859.5,4762,-0.02364499,5308.5,5945.5,5346,7533.5,506.5,19.5,20.5,776,-0.027504513,897,3565.5,-0.013801306,3758,8640,5047,5922.5,5601.5,4921.5,7276.5,6937.5,-0.0034128432,-0.021211332,-0.0061979974,-0.010986905,9406.5,8578.5,12229.5,3804.5,0.0012090023,-0.013654378,10092,12343,7725,0.0051471535,7643,6608.5,0.0059144367,0.017974079,6553.5,7673.5,3149,5519,5631,9587,15091.5,22807,18217.5,32028,30728,29413,15451,29443,19560.5,25998,24810.5,24804.5,0.00034521703,-0.0013834902,-0.008037115,-0.02410652,0.0015439092,0.011579381,-0.008487156,0.00066396483,-0.007178812,-0.018036628,-0.010388414,0.0053279046,-0.002804275,-0.009754769,0.00787012,-0.001520332,0.005693849,0.027797392,0.005528938,-0.026346017,-0.00016736056,-0.01161727,-0.0054048365,0.0044123544,0.0019613018,-0.008275667,-0.008426707,-0.013587891,0.00035264294,0.0040194406,-0.011580269,-0.00036794948,-0.013170965,0.012588851,-0.002626995,-0.010702707,-0.004929931,-0.01599328,-0.038227126,-0.0030034848,-0.0039682835,-0.016105693,-0.00049325055,0.007933549,0.0078023314,-0.0043291426,0.031152451,0.00062028674,-0.0035687962,-0.014819576,0.007301127,0.0006721089,0.016192606,0.003968148,-0.0038768027,0.0013136995,-0.009896604,0.0072637433,-0.0146357315,0.0009003651,0.005234148,0.00026451444,0.0028387532,-0.0020462659,0.0032036572,0.021022815,0.0017386997,-0.004581071,-0.0012703601,0.0054345247,-0.0031668933,-0.011131174,0.0051725097,0.00032953426,0.0040242528,0.007717956,0.0038693459,0.0077123516,-0.004202289,0.000921693,0.0012866626,-0.0036784783,-0.004064595,-0.017014926,0.002997643,0.0085293,-0.0053794496,0.0002386573,0.0012850798,0.0037035083,0.012950107,0.0072092297,0.0033772085,-0.0016555481,6.805057e-05,-0.00807276,0.00060242246,0.003489143,-0.007552102,-9.231566e-05,0.009781706,0.0045464295,0.0010844091,0.015022091,-0.0033266798,-0.0007238788,-0.007682855,-0.02549243,-0.01679455,-0.0016769118,0.0045993156,0.0005176209,0.004889421,4.4170115e-06,-0.0005516452,0.002556228,-0.014168309,-0.030334955,-0.0012733834,1.26797995e-05,-0.0011122028,0.035907786,0.0031984726,-0.014411147,0.0097735,0.026626393,-0.036440693,0.0014945212,0.004069143,-0.0063925697,-0.0024090982,-0.00079594005,-0.0051926067,0.0028331883,-0.008061334,0.0029422182,0.008775929,-0.00717061,0.015361763,0.006057545,0.0063525136,-0.0035005359,0.02614797,0.0024612218,-0.0075034164,0.0014429911,0.0034301102,-0.0069304965,-0.014172162,-0.001331255,-0.0044388194,0.006031944,0.007207828,-0.010980269,0.00011545634,-0.0080561545,-0.0020728994,0.00169221,-0.004018463,-0.0008587154,-0.005640245,0.0010224449,-0.0012371753,-0.012903022,0.0019361116,-0.0023691885,0.003619738,0.013340016,0.0029063476,-0.016309755,0.0022920214,-0.0023274557,0.020889666,0.0076869847,0.0027436875,-0.009784639,0.00018409883,0.0018197738,0.00088396383,-0.0026944985,0.008944066,0.00097121496,-0.0037723803,0.0054072146,-0.0032902788,-0.00084805547,0.000818724,-2.0586753e-05,0.006816871,0.0019027165,0.0042000753,-0.0034651065,0.0018841395,-0.00064641243,0.0018279965,-0.00025503602,-0.0035831928,-0.0009313351,-0.0003863449,-0.0018621769,0.0014501775,0.00027080518}, {8,5,3,4,4,2,2,7,5,8,2,3,2,3,3,6,6,2,4,7,4,2,2,1,1,0,0,7,3,1,7,7,0,1,7,1,8,0,2,8,5,2,8,5,0,3,7,1,0,1,7,255,1,5,0,7,7,255,2,255,7,3,6,6,0,8,2,8,1,8,6,8,8,0,6,6,8,8,7,1,6,1,6,8,3,1,1,7,3,4,0,0,0,8,2,0,6,4,1,2,2,3,0,0,1,3,4,1,2,0,3,0,6,4,3,5,6,3,2,6,4,2,2,8,3,6,0,3,8,0,6,0,7,0,8,1,0,3,3,6,6,1,0,8,2,8,6,2,2,8,8,2,4,0,7,7,8,2,2,8,1,0,4,8,5,5,255,0,255,8,1,3,5,3,1,255,0,0,6,2,255,2,4,0,6,0,8,8,6,255,6,5,255,4,2,3,2,0,2,2,3,255,255,255,255,2,0,2,0,255,255,6,0,3,255,3,0,255,255,1,5,0,4,1,5,2,2,2,2,0,0,7,2,6,0,6,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,65535,103,105,107,109,111,65535,113,65535,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,259,261,263,265,267,269,271,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,323,325,65535,327,65535,329,331,333,335,337,339,65535,341,343,345,347,65535,349,351,353,355,357,359,361,363,65535,365,367,65535,369,371,373,375,377,379,381,383,65535,65535,65535,65535,385,387,389,391,65535,65535,393,395,397,65535,399,401,65535,65535,403,405,407,409,411,413,415,417,419,421,423,425,427,429,431,433,435,437,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,65535,104,106,108,110,112,65535,114,65535,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,264,266,268,270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,326,65535,328,65535,330,332,334,336,338,340,65535,342,344,346,348,65535,350,352,354,356,358,360,362,364,65535,366,368,65535,370,372,374,376,378,380,382,384,65535,65535,65535,65535,386,388,390,392,65535,65535,394,396,398,65535,400,402,65535,65535,404,406,408,410,412,414,416,418,420,422,424,426,428,430,432,434,436,438,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4778.5,4288.5,5432.5,4695.5,4913.5,10997,5510.5,4418.5,6900,4841,2.5,9743.5,4783.5,7362.5,5620,10700,5945.5,2734,3995,4606.5,1.5,4398.5,6445.5,3692.5,11.5,6.5,12909.5,6827,6506,5502.5,5768.5,4348,3041.5,6496.5,-0.016254952,2270,2485,3791.5,6057,2627,7.5,-0.004330664,-0.028168118,4822,4560,5516,4.5,3252,8588,12902,9793.5,0.007002305,0.015307786,7.5,17.5,5362.5,0.008760041,2,6468.5,5354.5,5771.5,5594.5,5824.5,3798.5,4585.5,7.5,-0.0062825764,14.5,10.5,5480.5,6649,5528,18.5,318.5,2290.5,7.5,9227,11.5,14.5,6616,12.5,-0.007997877,7231,8319,6929,6138,7.5,4560,7055.5,2.5,4678,5627,4128,5190.5,-0.010273721,10096,12902,9178.5,9178.5,4.5,4705.5,5865,6.5,-0.0031003791,-0.026610702,7.5,16,-0.03210834,7345.5,15.5,9934.5,4037,10290,5345,5907.5,3622.5,3701.5,6006,7.5,-0.006270232,-0.016325494,1.5,0.011099926,6950,5427.5,19,2,3.5,3.5,14.5,15.5,1.5,4901,31520,7.5,-0.011088095,5375,7743,7830.5,4715.5,9016.5,0.0046766712,15,8,0.0048344857,5.5,-0.00788286,6767,6767,4337.5,-0.00531822,5035,4501,4545.5,4596,16.5,0.015040834,7400,17.5,3356.5,9997,4608,18.5,-1.424324e-05,13.5,7.5,7.5,5395,5700,13,8435.5,10158.5,9724.5,6297.5,4772,8475.5,-0.0034190495,-0.00700216,3,14,12.5,1.5,4874,14693.5,27841.5,16.5,0.009926098,7243.5,-0.006918903,5672,8965.5,11239,-0.0059341877,5355.5,0.010687427,5835.5,5815.5,9358.5,12668,17.5,-0.023571713,9074.5,7708.5,18,5699.5,6330.5,5616.5,-0.00029124526,0.0007867731,0.0031798126,-0.002029414,0.0046889614,0.0080675315,0.00025369372,0.0021476846,-0.00037657673,0.0015715001,-0.0090411,-0.00088449736,-0.0055475663,0.0008884797,0.0047533535,0.013052642,-0.008411078,-0.0016115742,-0.0037116378,-0.014883171,-0.008764325,-0.0013694684,-0.000466302,-0.0060386537,0.007912518,-0.00062124117,0.013794593,0.0053124535,0.024635753,0.003357616,-0.006156564,0.0019092849,0.0016297784,-9.753708e-05,-0.008943108,-9.838961e-05,0.005449943,0.0006491681,-0.0053368835,0.00062360865,0.0006180551,0.005855053,0.002796962,-0.002481607,-0.002299731,-0.012110423,-0.0011018468,0.0011606263,-0.002139196,0.0037378073,-0.009872969,-0.0032116,-0.0011704628,-0.00776442,0.00068323285,0.0028344237,0.0010774583,-0.005235472,0.003431759,-0.003187691,0.0029368645,0.015253091,0.008433335,-0.0025490269,0.002850372,0.00047578738,-0.0026473207,0.0017006699,0.002467979,-0.0017754261,-0.009546253,0.0016528023,0.007967266,0.00058277283,-0.0034167327,-0.0008534182,0.013024037,0.0038625356,-0.0061332947,-0.010705802,-0.0006555403,0.00224664,-0.002355026,-0.005034528,0.0037856686,0.009310707,-0.0255759,0.000494177,0.0029333981,0.011895387,-0.0029627383,0.0006203404,0.0027024604,-0.0036799032,0.002602479,0.0060398886,0.0053380635,0.010148146,0.0044280854,0.0066421526,0.004741857,0.014318796,0.004811235,-0.0010742269,-0.0113574155,-0.007022995,-0.0043375096,-0.016918153,-0.0056421203,0.0035181332,-0.0021617713,-0.008599568,-0.0026816358,-0.0004561659,-0.008624238,-0.0054713855,0.0009871096,-0.0047964044,0.0009780877,-0.009105393,0.0005436318,0.0020244296,-0.0007379909,-0.004766401,-0.010757449,-0.005126092,-0.0043275426,-0.0158056,0.001712681,0.013370079,0.005458006,0.020749686,-0.00038509443,-0.010115463,0.0115461685,-0.0007572251,-0.005406607,-0.01768102,-0.0022620927,-0.011128116,0.0008325403,0.0068548024,0.008314088,0.022530988,-0.023151224,0.0030064993,-0.010415545,-0.0013301173,0.0008098904,-0.000115267714}, {5,5,5,3,6,4,5,3,2,1,8,4,5,6,5,7,1,7,5,5,8,5,4,1,8,8,2,6,2,4,5,3,0,2,255,7,0,5,0,2,8,255,255,7,7,6,8,1,2,0,0,255,255,8,8,2,255,8,1,2,2,0,5,3,7,8,255,8,8,2,0,3,8,4,0,8,2,8,8,0,8,255,4,6,6,0,8,7,7,8,4,1,1,5,255,4,0,0,0,8,1,0,8,255,255,8,8,255,2,8,6,0,6,2,5,3,2,0,8,255,255,8,255,6,1,8,8,8,8,8,8,8,2,3,8,255,3,3,2,3,0,255,8,8,255,8,255,2,2,5,255,6,5,5,7,8,255,7,8,3,6,5,8,255,8,8,8,7,0,8,3,4,0,2,7,6,255,255,8,8,8,8,1,0,2,8,255,0,255,0,0,0,255,4,255,0,6,6,2,8,255,6,0,8,2,6,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,65535,69,71,73,75,77,79,65535,65535,81,83,85,87,89,91,93,95,65535,65535,97,99,101,65535,103,105,107,109,111,113,115,117,119,65535,121,123,125,127,129,131,133,135,137,139,141,143,145,147,65535,149,151,153,155,157,159,161,163,165,167,169,171,65535,173,175,177,179,181,183,185,187,65535,65535,189,191,65535,193,195,197,199,201,203,205,207,209,211,213,65535,65535,215,65535,217,219,221,223,225,227,229,231,233,235,237,239,65535,241,243,245,247,249,65535,251,253,65535,255,65535,257,259,261,65535,263,265,267,269,271,65535,273,275,277,279,281,283,65535,285,287,289,291,293,295,297,299,301,303,305,307,65535,65535,309,311,313,315,317,319,321,323,65535,325,65535,327,329,331,65535,333,65535,335,337,339,341,343,65535,345,347,349,351,353,355,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,65535,70,72,74,76,78,80,65535,65535,82,84,86,88,90,92,94,96,65535,65535,98,100,102,65535,104,106,108,110,112,114,116,118,120,65535,122,124,126,128,130,132,134,136,138,140,142,144,146,148,65535,150,152,154,156,158,160,162,164,166,168,170,172,65535,174,176,178,180,182,184,186,188,65535,65535,190,192,65535,194,196,198,200,202,204,206,208,210,212,214,65535,65535,216,65535,218,220,222,224,226,228,230,232,234,236,238,240,65535,242,244,246,248,250,65535,252,254,65535,256,65535,258,260,262,65535,264,266,268,270,272,65535,274,276,278,280,282,284,65535,286,288,290,292,294,296,298,300,302,304,306,308,65535,65535,310,312,314,316,318,320,322,324,65535,326,65535,328,330,332,65535,334,65535,336,338,340,342,344,65535,346,348,350,352,354,356,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({2830,11667,3025.5,1828,12.5,6587.5,11047,2411.5,1732.5,4330.5,3370,3479,2375,9851.5,21538.5,12.5,2562,18.5,2805.5,67,11775.5,1665,73.5,12.5,2774.5,15.5,-0.021758439,9705.5,7614.5,17781,16038,956.5,2442.5,2437.5,15.5,5.5,1512.5,6136,3057.5,2,11.5,1294,11764.5,-0.005196722,18,-0.0022743552,18.5,2381.5,2381.5,6941.5,3125,6,-0.014742427,9676.5,8078.5,7089.5,7621.5,17541,21727,18294.5,22838,1266.5,1222,1312.5,1827,2229.5,4003,6.5,-0.042605314,1092,14.5,0.044792555,-0.016453959,3095,6303.5,-0.0034002436,16.5,-0.006023794,4.5,4.5,512,-0.009840543,7.5,7.5,-0.0012648173,-0.0010800655,2703,877.5,1409.5,4,7.5,17.5,18.5,16.5,12,18.5,2900.5,-0.007653442,13,8099,6231.5,4.5,7841,7885.5,7230.5,0.016856289,9407.5,13959,13574,1.5,19188,25487.5,23886.5,16884.5,24300,26.5,6.5,1758,1326,1216,1257,18.5,17.5,-0.015833987,12.5,11.5,12.5,2.5,12.5,0.002192719,2,1512.5,17.5,5099.5,5870.5,806,4045,8,0.011227777,0.00044472655,-0.0027879186,0.0054340777,10281,-0.0016791683,0.0021024146,1.5,-0.0072990046,0.00084575143,8.9270296e-05,-0.0001868388,0.00017129836,17.5,14.5,-0.011805641,-0.0021381692,2920.5,-0.01186088,2.5,11.5,16,2920.5,2842,-0.01235768,0.009177554,0.003857214,0.0026813014,0.00080444245,2896.5,3022,18.5,11.5,0.0019864552,-0.0036772047,7590.5,7600,0.0010216312,-0.02311204,9772,9772,10033,17.5,9436,2.5,0.0036823098,1.5,10727,11392,14198.5,1.5,9291.5,16689,20319.5,21293,2.5,17.5,31400.5,11330.5,19.5,26571.5,21665,22497.5,19817.5,23707.5,-0.0016631092,6.138235e-05,-0.0025017594,-0.01436805,0.0022137465,0.0117857,0.0012262876,-0.0020223458,0.0009951522,-0.0075652287,0.005210275,-0.002854596,-0.003896271,-0.014147143,-0.0022171866,0.003978602,-0.008771168,-3.2529624e-05,-0.0034488996,0.0021454585,-0.0047373655,-0.015804378,-0.0070538535,-0.021701535,0.0058158333,-0.0025289347,-0.0008701949,-0.00509412,0.007139135,0.016155565,0.0034856156,-0.0018345773,0.0006713249,-0.01059408,0.0026295208,0.009712731,-0.008457774,-0.022640036,0.0021786129,-0.00064613,0.006697427,0.004152428,0.0022741163,0.004137442,-0.003590595,-0.0006304974,-0.0040713637,-0.0010944871,-0.003743035,-0.011036165,-0.0070742103,-0.00076299225,-0.0027667154,0.0014028493,-0.0028736512,-0.0009949794,0.0006554539,-0.005912419,0.008033338,0.0039429027,-0.004316274,-0.00047243392,0.0005448439,-0.00231449,-0.0067035295,-0.001227041,-0.0006094119,0.0006525772,0.0042869593,0.0009412419,-0.00019542997,0.0028438556,0.003347092,-0.0022176492,0.016839363,0.009312039,0.010183438,0.006174288,0.0016378195,0.0004170204,0.003441034,0.006883852,-0.0032198299,-0.014763022,0.0037891685,-0.00053599867,-0.0014420557,-0.02717394,0.003691621,0.0011741815,-0.009893636,-0.00058325386,0.0003375279,0.003786314,0.010790671,-0.004634041,-0.008005249,0.0020919957,0.018256797,0.009527679,0.011730502,0.00054941134,-0.0050908187,0.00887093,0.009220368,0.0025213351,0.00062762323,-0.0010022427,-0.00014500105,-0.015568733,-0.00038816873,-0.0032244723,0.010830752,0.0021275708,0.002870433,-0.00031140327,0.0060713026,0.018682942,-0.0064452174,0.00052567007,0.007225544,-7.5582364e-05,0.0040090154,4.3188702e-05}, {0,2,0,5,8,4,3,4,4,7,5,3,1,3,4,8,0,8,0,0,3,0,0,8,1,8,255,3,6,5,5,7,0,2,8,8,0,6,1,8,8,0,2,255,8,255,8,1,1,2,6,8,255,3,6,6,6,4,5,1,4,6,7,0,2,0,4,8,255,0,8,255,255,3,6,255,8,255,8,8,0,255,8,8,255,255,0,1,1,8,8,8,8,8,8,8,1,255,8,7,0,8,1,4,0,255,2,5,5,8,1,0,6,1,6,3,8,0,4,4,7,8,8,255,8,8,8,8,8,255,8,0,8,6,6,0,3,8,255,255,255,255,4,255,255,8,255,255,255,255,255,8,8,255,255,0,255,8,8,8,0,0,255,255,255,255,255,0,4,8,8,255,255,7,6,255,255,3,3,4,8,1,8,255,8,3,6,4,8,7,0,1,4,8,8,6,7,8,4,0,1,1,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,65535,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,65535,85,65535,87,89,91,93,95,97,65535,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,65535,129,131,65535,65535,133,135,65535,137,65535,139,141,143,65535,145,147,65535,65535,149,151,153,155,157,159,161,163,165,167,169,65535,171,173,175,177,179,181,183,65535,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,65535,219,221,223,225,227,65535,229,231,233,235,237,239,241,243,65535,65535,65535,65535,245,65535,65535,247,65535,65535,65535,65535,65535,249,251,65535,65535,253,65535,255,257,259,261,263,65535,65535,65535,65535,65535,265,267,269,271,65535,65535,273,275,65535,65535,277,279,281,283,285,287,65535,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,323,325,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,65535,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,65535,86,65535,88,90,92,94,96,98,65535,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,65535,130,132,65535,65535,134,136,65535,138,65535,140,142,144,65535,146,148,65535,65535,150,152,154,156,158,160,162,164,166,168,170,65535,172,174,176,178,180,182,184,65535,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,65535,220,222,224,226,228,65535,230,232,234,236,238,240,242,244,65535,65535,65535,65535,246,65535,65535,248,65535,65535,65535,65535,65535,250,252,65535,65535,254,65535,256,258,260,262,264,65535,65535,65535,65535,65535,266,268,270,272,65535,65535,274,276,65535,65535,278,280,282,284,286,288,65535,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,326,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({11411.5,8757,11076.5,8563,9341,10727,17583.5,8743.5,10881.5,5888.5,9381,9192,10674,12585.5,20670.5,6303,9878,7631,17.5,17.5,9329.5,9363,11386,6101,-0.016738877,10328.5,11001.5,14491,1.5,17944.5,13912,6253.5,5430,3.5,-0.015821025,4670.5,2.5,0.02603733,0.015151853,0.018205844,0.008132388,4568.5,9275.5,7807.5,0.020704731,8518.5,11396.5,7.5,17.5,9122,10374.5,10794.5,0.008919538,7853,14295,15648,20818.5,13364,19549.5,28336.5,17.5,5027.5,3469,5223.5,7039,7142.5,6641.5,5003.5,8715,-0.009703557,-0.033657264,4392,6296,-0.030255735,-0.0141932815,5.5,-0.0022511778,8457.5,11330.5,10.5,24883,11614,11457.5,10284.5,12247,11726.5,16.5,0.008771064,10420.5,0.0056167464,2.5,5749,11571.5,-0.011882119,11565.5,18488.5,15185.5,5.5,23898.5,21427,19578.5,1.5,19043.5,16189.5,31177.5,14181.5,19176,5019.5,7255,6.5,0.041591868,3757,7085,9902.5,10001.5,9788,8000,6155.5,7278,6.5,8319,8652,0.009454354,9285.5,12.5,6588,9171,0.0010077665,17.5,1.5,0.0155243,10743,7.5,0.023434957,0.010298384,12023,19501.5,4.5,0.0013005894,10959,19.5,4.5,6801,0.0071307146,0.0033877473,16,6.5,4.5,11397,15,9330,0.004242386,5,4331,12011.5,7.5,10756.5,7.5,15870,15252.5,17397,17096.5,25756,18727,18727,10.5,17,13314,2.5,16649.5,20520,16643.5,6.5,1.5,1.5,11663.5,24592.5,12520.5,13213.5,14533,22765.5,5186,29216.5,-0.00019985608,-0.00930168,0.0001399114,0.0027146,-0.0013817478,-0.005179919,0.0006988623,-0.01314111,0.0075459466,0.0013795568,-0.005589997,0.018071054,-0.00016984802,-0.0151458485,0.007901292,0.0030589777,3.0269663e-05,0.0036778932,0.0014608625,-0.005159347,0.0060528866,0.0019110028,0.00022808684,-0.008987035,0.0028733097,-0.0014601554,0.00597851,-0.0010982127,-0.0026679372,-0.010108932,-0.005594029,-0.017997844,-0.007716345,0.001367141,-0.0068630213,8.7219836e-05,-0.00048609116,0.0009589064,-0.0025456012,-0.00020750922,-0.018151142,-0.0006478751,-0.0022098364,0.00045507198,0.00024009452,0.0032873426,-0.0014858588,0.0067726024,-0.00068364403,0.0005834213,0.00067114143,-0.00035444324,-0.0015428757,-0.00046953288,0.0055801505,0.0027808258,0.005594236,0.008999005,0.002807534,0.0055199284,0.0012531846,0.0076180855,0.0007654399,-0.0007466553,0.0024002623,0.00077809143,-0.0013593076,0.00084227603,0.0044887844,0.0024324476,-0.0011888961,0.0021323024,0.0010234363,-0.001144733,-0.00054353,0.003809519,-0.003315949,0.004280347,-0.01244806,-0.0068405285,-0.0030295223,0.0020433122,0.016130937,0.011803374,0.011485974,0.005126381,0.0014760661,0.0054552467,-0.0013280096,0.0019129735,0.0072993427,-0.0016240583,-0.006888834,-0.016008137,-0.0028935873,-0.009781978,0.001980191,0.003138783,0.002349708,0.0004270148,0.0005237794,0.005259302,-0.020756684,-0.004220823,-0.007917657,0.010601231,0.005383679,0.00093116815,0.00090927136,0.006469878,-0.014238216,-0.0072863484,0.008825547,0.0014348038,0.006898844,-0.003200198,0.011071766,-0.00052919314,0.0074642017,-0.001479039,-0.0007987774,-0.017925141,-0.0025743938,0.0001555153,0.00049469684,0.005443062,-0.0012802903,0.0001568856,-0.010961112,-0.0012665121,-0.0004997403,0.00014483742}, {1,6,0,6,6,3,0,7,0,2,6,2,0,3,0,7,0,1,8,8,6,6,3,2,255,4,0,6,8,1,1,7,5,8,255,1,8,255,255,255,255,7,0,0,255,1,3,8,8,5,4,0,255,6,0,0,3,1,1,0,8,3,0,0,3,2,4,2,6,255,255,7,1,255,255,8,255,1,6,8,4,5,1,0,7,1,8,255,4,255,8,7,1,255,1,4,7,8,3,2,3,8,0,7,2,3,3,3,4,8,255,4,0,1,0,7,1,4,4,8,0,6,255,6,8,2,6,255,8,8,255,3,8,255,255,0,7,8,255,0,8,8,3,255,255,8,8,8,5,8,6,255,8,6,1,8,2,8,0,0,2,1,1,2,2,8,8,7,8,2,0,4,8,8,8,1,0,1,1,7,0,2,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,65535,49,51,53,55,57,59,61,63,65,65535,67,69,65535,65535,65535,65535,71,73,75,65535,77,79,81,83,85,87,89,65535,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,65535,65535,123,125,65535,65535,127,65535,129,131,133,135,137,139,141,143,145,147,65535,149,65535,151,153,155,65535,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,65535,189,191,193,195,197,199,201,203,205,207,209,65535,211,213,215,217,65535,219,221,65535,223,225,65535,65535,227,229,231,65535,233,235,237,239,65535,65535,241,243,245,247,249,251,65535,253,255,257,259,261,263,265,267,269,271,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,311,313,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,65535,50,52,54,56,58,60,62,64,66,65535,68,70,65535,65535,65535,65535,72,74,76,65535,78,80,82,84,86,88,90,65535,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,65535,65535,124,126,65535,65535,128,65535,130,132,134,136,138,140,142,144,146,148,65535,150,65535,152,154,156,65535,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,65535,190,192,194,196,198,200,202,204,206,208,210,65535,212,214,216,218,65535,220,222,65535,224,226,65535,65535,228,230,232,65535,234,236,238,240,65535,65535,242,244,246,248,250,252,65535,254,256,258,260,262,264,266,268,270,272,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,312,314,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31866.5,31922,17611,11419,28579.5,27139.5,17582,8372,25937.5,20541.5,29830,24247.5,17427.5,17087,1.5,8205.5,8483.5,27996,26308.5,12.5,2.5,17.5,18750.5,-0.013464214,11.5,16313,-0.010877497,30426.5,18942,21834.5,18713,8079,9598.5,8463,8128,27925,30873.5,26068,32327,1.5,-0.011249489,0.0021539629,17.5,3.5,32366.5,18443.5,1.5,3,16,8425.5,17311.5,32361.5,19686,2,-0.0021856658,19571.5,22304.5,20609.5,20459.5,6390.5,8101,7334.5,11882.5,5723,8321,9704,10286.5,17168.5,13604.5,15468,29994.5,3.5,26224.5,29734.5,3.5,-0.00011299465,18767,4,-0.0013666032,32366.5,19037,-0.00061351183,-0.0027778088,18051,4,24343,19042,0.002202153,4.5,-0.00085081515,-0.003687381,10,24142,-0.0076767527,30471,3.5,19895,2,7.5,-0.0026906661,-0.009998521,20043,19807.5,-0.003927002,30361.5,31887,-0.012280789,19574,20476,6313,5427.5,8380,16129,8339.5,10037.5,12.5,23607,4433.5,8695.5,1.5,8386.5,7594,18,7131,10291.5,16793.5,23581.5,-0.019606432,28385,28375.5,15.5,2.5,16.5,2.5,22326,0.003462145,3,26252.5,30999.5,2574,24761,-0.008295193,-0.004562778,-0.0010964153,8.5,-0.0035169974,1.5,-0.0023293314,10.5,4.5,3.5,1.5,5.5,21541,0.000103017315,7,21323,-0.0008038329,8.5,4.5,0.001222002,1.5,12483,1.5,17241,1.5,-0.002596583,2.5,2.5,0.0014538412,7,-0.001982064,16.5,18329.5,0.0056032045,18726.5,31987.5,24407.5,30064.5,18615,32234,18616,19828,-0.0077303383,30603,-2.582144e-05,-0.0035897405,0.0028177283,0.00038136088,-0.0069350335,0.00055694906,-0.0369368,-0.002492269,0.005268854,-0.0006565741,-0.0033577734,-0.023661949,0.025181923,0.017832687,0.001271885,0.008055902,0.00031166238,0.008800387,-0.01508749,-0.0006725843,-0.005878884,-0.039042708,-0.00045536613,-0.01067657,0.0010500117,0.0032213815,0.013350225,0.0053570378,0.00074755884,-0.00431809,0.014726223,-3.19543e-05,0.00030501248,0.00440056,-0.002969196,0.00286621,-0.0064610834,-0.0014066839,0.0017156231,-0.014977904,0.006843553,0.001597108,0.00084481336,-0.0016589158,-4.3515533e-06,-0.0007927269,0.0013979148,0.0003359348,-0.0013895815,-0.008168716,0.0023969952,-0.00027145472,0.0010594663,-0.002094981,0.0019067628,-0.0006638057,-0.006897442,-0.00043720411,0.00048036766,7.534723e-05,-4.357606e-05,0.00069457537,0.00021124122,-0.0012390536,-0.002022633,-0.0010200639,0.00020340325,-0.00104527,-0.0010304986,-0.002630081,0.002000113,0.00080696394,-0.0010248887,-7.499754e-05,0.002178801,0.0008677475,0.0007616719,0.001185758,5.5208122e-05,0.00038699055,0.0013056174,0.00018913469,0.0015385143,3.700839e-05,-6.7998124e-05,-0.008023424,-0.0019005099,-0.0030281239,-0.0011137748,-0.0028998335,-0.00018830466,-0.0022077893,-0.00042678564,-0.0014921372,0.00021706893,-0.001486149,-0.0016583147,-0.0010004451,-0.00041793459,0.000364999,-0.0011513538,-0.0019211223,0.003408022,0.00048368447,0.0031561952,0.0063612172,-0.0026397503,0.0031136642,0.0005737748,0.0011461136,-0.0012433054,-0.00011338408,-0.0026974464,-0.010522171,-0.0014629507,2.8697692e-05,0.0011813309,-0.00020930333,0.0018527342,0.00016571346,-0.00021752345,0.0010466982}, {6,0,3,1,4,4,5,1,7,1,6,0,3,5,8,1,1,4,7,8,8,8,5,255,8,3,255,4,1,1,1,1,0,1,0,4,4,0,3,8,255,255,8,8,0,1,8,8,8,0,1,0,3,8,255,7,1,5,3,1,7,4,0,2,0,1,3,5,1,1,6,8,0,4,8,255,1,8,255,0,5,255,255,1,8,5,5,255,8,255,255,8,0,255,2,8,1,8,8,255,255,3,3,255,5,2,255,7,3,1,7,3,0,1,2,8,0,2,7,8,0,0,8,3,3,7,4,255,0,0,8,8,8,8,0,255,8,5,3,0,2,255,255,255,8,255,8,255,8,8,8,8,8,1,255,8,1,255,8,8,255,8,5,8,3,8,255,8,8,255,8,255,8,5,255,3,4,5,1,5,6,5,3,255,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,47,49,65535,51,53,55,57,59,61,63,65,67,69,71,73,75,65535,65535,77,79,81,83,85,87,89,91,93,95,97,99,65535,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,65535,141,143,65535,145,147,65535,65535,149,151,153,155,65535,157,65535,65535,159,161,65535,163,165,167,169,171,65535,65535,173,175,65535,177,179,65535,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,65535,221,223,225,227,229,231,233,65535,235,237,239,241,243,65535,65535,65535,245,65535,247,65535,249,251,253,255,257,259,65535,261,263,65535,265,267,65535,269,271,273,275,277,65535,279,281,65535,283,65535,285,287,65535,289,291,293,295,297,299,301,303,65535,305,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,48,50,65535,52,54,56,58,60,62,64,66,68,70,72,74,76,65535,65535,78,80,82,84,86,88,90,92,94,96,98,100,65535,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,65535,142,144,65535,146,148,65535,65535,150,152,154,156,65535,158,65535,65535,160,162,65535,164,166,168,170,172,65535,65535,174,176,65535,178,180,65535,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,65535,222,224,226,228,230,232,234,65535,236,238,240,242,244,65535,65535,65535,246,65535,248,65535,250,252,254,256,258,260,65535,262,264,65535,266,268,65535,270,272,274,276,278,65535,280,282,65535,284,65535,286,288,65535,290,292,294,296,298,300,302,304,65535,306,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7.5,2405,944.5,2736,8032.5,745,1298.5,754.5,4654.5,7533.5,9550.5,588.5,18.5,1227.5,1131.5,92,2.5,1717.5,1346.5,7458,6853,10890.5,9556.5,535.5,907,532.5,748,17.5,1360.5,20,1531.5,32.5,105,2034,4.5,7285,2.5,7893,5086,5455.5,7475.5,8292,8271.5,7763.5,4.5,0.018875787,11915,424.5,530.5,17.5,13.5,17.5,16.5,0.05745188,937,1034.5,1128,12.5,1877,18,0.06700775,1519.5,2000.5,65,74.5,4.5,100.5,1155.5,601,1419,1506,2.5,3.5,2121,4.5,7319,118,5028.5,3593,4924,8529.5,1.5,7030.5,7545.5,7923,7482,7620.5,9448.5,9210.5,11302.5,6902.5,11237.5,17845,305,1016,328.5,574.5,376,878,384,2768.5,267,0.01175913,1180.5,613.5,1366.5,0.042247366,1106.5,1290,810,1225,1292.5,1292.5,1590,2072,14.5,0.013427943,1300,19.5,1568,1791.5,26,29.5,63,59,26.5,113,101.5,625,1412,1389.5,7737,2267.5,904,1865,1218.5,1034.5,26.5,2563,-0.020912273,-0.008634849,1.5,1.5,2672,2001,7739.5,4.5,3,0.0077187247,6.5,3735.5,2018.5,7553,4748.5,5558.5,7947.5,7304.5,1.6211703e-05,-0.019352738,7512,7317,1.5,1.5,2.5,5968.5,7954,7797.5,5280,7621.5,9327,4.5,7151,8425,13830,11155,5713.5,8910,4.5,10181,6068,19416,210,321,18.5,19.5,20.5,18.5,20.5,20.5,-0.019998318,1329,549,0.0017731602,77,458,21.5,4514.5,0.0034863432,14,1056,906.5,796,706.5,937.5,20.5,1067,12.5,830,15.5,-0.0090280725,-0.04335311,1082,19.5,0.022269093,-0.016007937,17,18.5,12.5,15.5,11.5,2221,0.0058832737,0.0010950434,18.5,20.5,16,0.037215855,1107,12.5,18.5,2146,-0.0012829925,0.0007348993,0.0003461029,-0.005583186,0.0042870766,0.009826663,-0.004962782,0.002373991,-0.008332992,-0.0027784342,-0.015322777,-0.005604092,-0.0010358252,0.0077881487,-0.006796231,-5.8544712e-05,0.00081161933,-0.010520431,0.010329953,0.0019263205,0.0015193837,0.005977132,-0.014544258,0.001016848,0.003965217,-0.002530178,0.015417601,-0.000121368845,0.005764234,0.00023626734,-0.008375386,0.0014398735,0.009327512,-0.00053180824,-0.011756763,-0.0051199566,-0.008325729,-0.016817883,0.0044151973,-0.0013767951,0.01622547,-0.0020142426,-0.0041815946,0.0005511256,0.0013856146,-0.0041766856,0.007454635,0.002027033,0.0021129674,0.0003724292,0.000819537,0.0044191373,-0.006574154,-0.01363897,0.00024885032,-0.0016235039,-0.00012036712,0.009226854,0.001000134,-0.0024041536,0.0014483317,0.0046225907,-0.00076165627,0.0043893713,0.001268599,0.007980003,-0.010290118,0.00019696292,0.017911365,-0.00030850322,-0.009980747,-0.0006489949,0.005617868,-0.016428877,0.0036673942,-0.00027623904,0.0052315774,0.012736465,0.004911111,-0.012458452,0.018568093,0.006985829,-0.0027309107,-0.027628874,0.010629092,-0.00048372833,-0.0006381069,0.0117802005,-0.009634943,7.895549e-06,-0.0066738646,-0.020187724,0.0169357,-0.006679576,0.002543345,-0.0031222354,-0.013842793,0.002807782,-0.00015053888,-0.014513512,0.0036603238,-0.0003693468,-0.00080481265,0.0017518176,0.003998427,-0.005276139,0.00023410907,-0.0027167264,0.0027048518,0.00013249861,2.3222843e-05,-0.005367205,0.022345476,0.0052444073,-0.003987245,-0.01754087,-0.0017814294,0.003140778,0.004004791,-0.01813525,0.00967645,0.018192137,0.0008737426,-0.005779659,0.002496902,0.015343541,-0.0075173615,0.0026361502,-0.0038576343,-0.018036434,-0.0023510354,0.0058773314,-0.011845046,0.000520914,-0.0035958837,-0.010996635,0.00097532506,0.0035675697,0.008136832,0.0036234276,-0.00018601444,0.0022489324,0.009022645,0.00241932,-0.0079026045,-0.0039451006,0.0036001552,-0.0016919092,0.0010640937,-0.010264375,0.007733722,0.02038775,-0.004441339,0.01997695,-0.018050427,-0.007934165,0.011635635,0.006175607,0.0028404933,-0.005961872,-0.0006109453,-0.013352557,-0.001508295,0.007830653,0.011879288,-0.024732048,0.008522335,0.01760454,-0.010395799,0.0022625953,-0.003205367,-0.021796575,-0.004192089,0.001606969,-0.0090291,-0.002168965,0.00089031225,-0.013129969,0.0030208977,0.010798008,0.013335647,-0.0070983926,-0.009056192,0.000990628,-0.00618273,-0.0010916085,-0.0020888427,-0.021108845,0.0010451471,-0.00012869814}, {8,1,4,4,6,5,5,1,4,6,2,4,8,2,4,0,8,1,3,6,2,7,2,5,6,0,5,8,2,8,4,1,1,0,8,7,8,7,2,2,6,7,2,1,8,255,6,4,4,8,8,8,8,255,4,3,7,8,2,8,255,4,5,6,0,8,4,7,5,4,0,8,8,7,8,0,2,4,7,6,0,8,2,7,5,0,6,2,0,4,2,6,6,5,2,2,4,1,4,3,6,0,255,5,6,1,255,1,6,1,2,2,2,0,4,8,255,1,8,1,4,0,0,0,1,7,4,2,7,4,7,0,3,5,3,7,3,0,6,255,255,8,8,3,5,4,8,8,255,8,3,3,0,3,1,7,6,255,255,6,2,8,8,8,0,4,2,0,6,2,8,3,1,7,6,2,5,8,1,5,4,4,4,8,8,8,8,8,8,255,2,0,255,0,5,8,0,255,8,0,0,4,2,0,8,1,8,0,8,255,255,6,8,255,255,8,8,8,8,8,4,255,255,8,8,8,255,2,8,8,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,65535,91,93,95,97,99,101,103,65535,105,107,109,111,113,115,65535,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,65535,199,201,203,65535,205,207,209,211,213,215,217,219,221,65535,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,259,261,263,265,65535,65535,267,269,271,273,275,277,279,65535,281,283,285,287,289,291,293,295,65535,65535,297,299,301,303,305,307,309,311,313,315,317,319,321,323,325,327,329,331,333,335,337,339,341,343,345,347,349,351,353,355,65535,357,359,65535,361,363,365,367,65535,369,371,373,375,377,379,381,383,385,387,389,65535,65535,391,393,65535,65535,395,397,399,401,403,405,65535,65535,407,409,411,65535,413,415,417,419,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,65535,92,94,96,98,100,102,104,65535,106,108,110,112,114,116,65535,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,65535,200,202,204,65535,206,208,210,212,214,216,218,220,222,65535,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,264,266,65535,65535,268,270,272,274,276,278,280,65535,282,284,286,288,290,292,294,296,65535,65535,298,300,302,304,306,308,310,312,314,316,318,320,322,324,326,328,330,332,334,336,338,340,342,344,346,348,350,352,354,356,65535,358,360,65535,362,364,366,368,65535,370,372,374,376,378,380,382,384,386,388,390,65535,65535,392,394,65535,65535,396,398,400,402,404,406,65535,65535,408,410,412,65535,414,416,418,420,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4781.5,16.5,4883.5,4963,18.5,17.5,6248.5,4903.5,5504.5,2188,2443,9.5,4822.5,1.5,6760.5,4699.5,1.5,7229,5545,459.5,4276.5,529,306.5,4.5,27213.5,4796,11786,5838.5,7720.5,6652,6770.5,4500,4,8118,5179,1.5,1008.5,5543,12239,289,1552.5,34,1737.5,459.5,635.5,6811.5,5218.5,2038,6.5,5232.5,12.5,5025.5,18.5,3557,23735,8352,9538,6816.5,5994,6073,7140.5,1.5,6467.5,7464,9178,5371,7486,-0.03179089,-0.007881842,12.5,-0.010601801,4960,5342.5,12,5499,2.5,-0.023362694,4372,6024,63.5,868.5,536.5,1297.5,-0.015169126,1580,0.007918703,9024.5,65,646.5,602.5,1144.5,3614.5,7906.5,1443,6122,-0.0109691275,1.5,6225.5,20221,7579,4677.5,4800,4801,0.008712262,0.003210891,-0.0044449265,8092,7779.5,5875,20.5,-0.004108112,5480,-0.023568539,5287.5,5689.5,8357,6773.5,7001,5659.5,15.5,4893,7354.5,1.5,-0.01038343,6395.5,8309,8654,7442.5,5723.5,6.5,9786.5,4969,-0.005945589,5479,11.5,-0.0061026867,7394.5,0.0016748395,0.012197598,4298,15.5,0.0060961354,-0.003482659,8,12.5,0.0025145756,3357,4162,10643,6.5,7749.5,39,138.5,17.5,442,-0.014163739,1213.5,980.5,1777,5236.5,3069,5025,4613.5,284.5,2681,-0.027700234,-0.007538771,868,20.5,993.5,2157.5,2286.5,3995.5,6023,24951,1286.5,2175.5,3850.5,4437.5,8350,5633.5,3247.5,4675,7536,4780.5,15.5,15.5,9839.5,9764,-0.00036644784,0.0018206242,16.5,-0.003918452,4526,-0.004996585,6142.5,9711.5,-0.0012834392,4508.5,13515,16043,5193.5,5772.5,0.01908025,5563.5,0.0025938542,0.004821464,7534,8384,5748,7373,5965.5,8217,8997,6251,3.5,9013,3978.5,5637.5,5428,9457,7749.5,8904,0.02159452,15.5,6920.5,3473.5,7963,8703,-0.00048741963,-0.0027038062,-0.002947238,0.0003058223,-0.000742471,-0.005567409,0.0028182128,-0.0006462939,-0.0017991647,0.001442802,-0.0072668917,-0.011692378,-0.0054415558,0.0033269543,-0.0032525535,0.0041524777,0.005994551,0.0032300763,0.0018916456,0.004966171,-0.001494753,-0.006166657,-0.0010695521,-0.0053640525,-0.0011343464,0.0014416588,0.00042484445,-0.0019510261,0.0027415634,-0.00019405482,0.001260567,-0.0020709909,-0.009830746,-0.002433057,0.0016442313,-0.004357252,0.0033585322,-0.003266263,0.007024746,0.014322728,-0.0066743717,0.0032590597,-0.001561934,-0.0055863904,-0.02954562,-0.011764646,-0.003528044,-0.015555042,-0.013536408,0.0011074044,0.0072349436,0.0029486232,-0.003744384,0.0010711938,-0.0074533722,-0.0012933154,0.00024816536,0.013070769,-0.004281806,0.004017628,-0.009226772,0.01743698,0.026939273,0.057205893,-0.019845353,0.0017570753,0.0016982174,0.011216725,-0.017025318,-3.3227109e-06,-0.023470193,-0.010294339,0.005780677,0.0003158763,-0.0055890135,0.0015406,-0.0022628007,0.015636086,-0.017313307,-0.0011912808,0.020833025,-0.0019397499,0.005818879,-0.0006460616,0.0009420598,-0.0035596173,0.0009828688,0.004869987,-0.0013163326,0.0029546078,-0.0057862834,-0.002612312,0.0014800563,-0.0015575908,0.009760708,0.00178026,0.0014550852,-0.0033280365,-0.0020041035,4.599447e-05,0.003914825,-0.00033129487,0.0035591521,0.008172828,-0.00047527748,-0.0024584692,0.0022094122,-0.0007604981,-0.0011391001,-0.0044911723,0.0019051249,0.00045532538,0.0064052492,0.0107612675,-0.00011242491,0.0017849291,0.00024457593,-0.0016980494,0.0031347126,0.013555077,-0.00650857,0.0017488964,0.0013833438,0.011812997,0.0007760577,-0.011496158,-0.028769841,-0.016520586,0.0019051245,-0.0141938375,0.03145046,0.0074923644,0.003931378,0.013907953,0.007254374,-0.0010730339,0.0048888223,-0.005480114,-0.015488639,-0.007441856,0.0032575147,0.0073509025,0.022649596,0.0057219514,-0.00088919187,0.007179569,-0.013362752,-0.00019367375,0.0031706698,-0.0064925663,0.0032230464,0.010892692,0.0020295994,0.013519935,-0.014048454,-0.004759989,-0.0012127132,-6.919621e-05,-0.00088387355,-0.008513306,-0.0015270985,0.0022689267,0.0038746695,-0.00067884655,-0.0107465135,-6.255859e-05}, {7,8,7,5,8,8,6,5,0,4,0,8,7,8,6,7,8,4,0,1,5,1,7,8,2,7,0,0,4,2,6,5,8,0,1,8,1,0,0,7,4,0,0,1,6,0,3,5,8,2,8,5,8,3,0,2,4,4,3,7,4,8,2,0,2,1,4,255,255,8,255,4,5,8,5,8,255,7,6,0,6,1,0,255,5,255,6,4,6,6,6,1,0,4,2,255,8,6,0,0,5,1,7,255,255,255,2,0,4,8,255,1,255,3,6,0,0,0,6,8,2,5,8,255,0,7,6,6,6,8,2,0,255,0,8,255,0,255,255,6,8,255,255,8,8,255,7,6,4,8,6,6,4,8,5,255,1,3,6,0,6,0,1,0,7,255,255,1,8,7,2,1,1,1,4,5,4,6,1,2,2,2,5,0,1,8,8,2,4,255,255,8,255,2,255,0,0,255,1,4,0,2,7,255,4,255,255,2,0,7,0,0,5,4,7,8,0,2,2,4,3,3,3,255,8,7,1,3,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,65535,65535,135,65535,137,139,141,143,145,65535,147,149,151,153,155,157,65535,159,65535,161,163,165,167,169,171,173,175,177,65535,179,181,183,185,187,189,191,65535,65535,65535,193,195,197,199,65535,201,65535,203,205,207,209,211,213,215,217,219,221,65535,223,225,227,229,231,233,235,237,65535,239,241,65535,243,65535,65535,245,247,65535,65535,249,251,65535,253,255,257,259,261,263,265,267,269,65535,271,273,275,277,279,281,283,285,287,65535,65535,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,323,325,327,329,331,65535,65535,333,65535,335,65535,337,339,65535,341,343,345,347,349,65535,351,65535,65535,353,355,357,359,361,363,365,367,369,371,373,375,377,379,381,383,65535,385,387,389,391,393,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,65535,65535,136,65535,138,140,142,144,146,65535,148,150,152,154,156,158,65535,160,65535,162,164,166,168,170,172,174,176,178,65535,180,182,184,186,188,190,192,65535,65535,65535,194,196,198,200,65535,202,65535,204,206,208,210,212,214,216,218,220,222,65535,224,226,228,230,232,234,236,238,65535,240,242,65535,244,65535,65535,246,248,65535,65535,250,252,65535,254,256,258,260,262,264,266,268,270,65535,272,274,276,278,280,282,284,286,288,65535,65535,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,326,328,330,332,65535,65535,334,65535,336,65535,338,340,65535,342,344,346,348,350,65535,352,65535,65535,354,356,358,360,362,364,366,368,370,372,374,376,378,380,382,384,65535,386,388,390,392,394,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4468,4369.5,5322.5,4346,4968,4293,5417,390.5,20.5,2496,3314.5,3607.5,5605.5,9525,2980.5,369,20.5,4361,6215,0.019779475,3680.5,4428,1.5,4496.5,29386,5544.5,4.5,5822,1.5,6251,5569,7583.5,4969,2859.5,343.5,7.5,5,-0.0017791992,-0.01560766,14,18.5,-0.0063190716,14.5,0.0037970864,17.5,12.5,4.5,4536.5,18.5,4440,7517.5,4306.5,5442,6102,6212,0.0018080373,8462.5,0.010866867,6743.5,5361,5851,99.5,89,377,6.5,459.5,6583,507.5,588.5,4.5,-0.0073495144,-0.0035733208,17.5,0.012862253,0.0030117556,4462,4462,7,-0.0036387697,12.5,0.0013123453,4475.5,-0.008444836,4423.5,3359,0.016695665,4567.5,31979,-0.010347606,5779,4811,6471,7548,6493,6629.5,7968.5,6465,16.5,8852.5,12,-0.0052111275,-0.0047117784,6.5,6341.5,18.5,5354,6085,5832,6170,114.5,109.5,63.5,14.5,-0.020886248,6.5,0.0014501663,15,393.5,529,5778.5,8229.5,0.06091237,114.5,436,631,-0.006486248,6,15.5,-0.001524756,14.5,15,0.00056548946,0.015945261,-0.002689099,11.5,4.5,-0.0014685265,-0.004423026,6.5,4038.5,-0.005168029,894,14.5,-0.02105641,3379.5,15,2.5,20.5,18.5,5395,4954.5,8.5,8,-0.017254766,-0.031435188,3806,1.5,6223,8438,17.5,8312.5,5708,-0.0175819,0.0054353434,0.0015157765,5094,0.0032162406,6108,6108,4.5,17.5,9.5,12.5,7024.5,6608.5,5737,7584,7406,8.5,9303,15.5,7218.5,6760.5,0.00035724268,-0.0027242706,-0.014091022,-0.0008639572,0.0017784605,-0.0015938141,0.0055736112,0.0018918886,-0.00495556,-0.011446693,-0.00058545027,0.00084771164,-0.002195962,0.0078963665,-0.010463212,-0.00042142608,0.0010006314,0.0048666266,-0.0021751106,0.0005485421,-0.02348766,0.01735831,-0.005024206,-0.019610766,0.042441007,0.0016864811,-0.00037311183,0.00084542215,-0.0009569944,0.00096617726,0.008903704,0.0024681815,-0.0015004784,0.003972353,-0.0008991544,-0.00012914045,-0.0011154874,0.00028932063,-0.004405078,0.0019522173,-0.0007067849,0.0035102305,-0.009285986,-0.000112618276,-0.0045374916,-0.0017690983,0.001428012,6.1740946e-05,-0.008232823,-0.0011992919,0.00042722002,-0.0039043964,-0.0033161098,0.0024577174,0.0029625297,0.0005173435,-0.0056863,-0.015707064,-0.0034402583,0.006637682,-0.0024335643,-0.0071849236,0.002976489,0.0011749152,-0.0059701046,0.003220724,-0.031435486,-0.00612393,0.001459743,-0.016148938,0.009158651,0.0006358094,0.0029039404,-0.0015946769,-0.0018507602,0.0076828934,-0.00868438,0.0022669428,0.0062966696,0.014051859,0.002054886,-0.0024560948,-0.002215218,0.006946411,-0.0018144645,8.8517445e-06,-0.0026857276,-0.0011496821,0.0029901392,0.00041711034,-0.008461776,0.004810099,0.0025975714,0.0045808004,-0.0040339697,0.0041928277,-0.001773095,-0.01842219,0.00095056155,-0.0021940058,-0.009189422,-0.024035396,0.0053905468,-0.00087215024,0.0016246552,-0.0005699641,0.004471319,0.019645376,-0.0058627822,0.003208524,-0.0007287181,-1.0085687e-05}, {0,0,6,0,2,6,6,1,8,2,1,1,4,4,2,1,8,0,4,255,3,0,8,0,0,5,8,2,8,6,2,5,2,7,6,8,8,255,255,8,8,255,8,255,8,8,8,0,8,2,1,7,7,0,1,255,0,255,0,3,4,4,0,1,8,1,6,0,7,8,255,255,8,255,255,0,0,8,255,8,255,0,255,3,5,255,0,0,255,0,2,0,1,5,1,4,0,8,0,8,255,255,8,0,8,0,5,4,4,6,4,0,8,255,8,255,8,5,1,6,7,255,3,6,6,255,8,8,255,8,8,255,255,255,8,8,255,255,8,2,255,2,8,255,5,8,8,8,8,1,7,8,8,255,255,3,8,0,1,8,3,0,255,255,255,7,255,0,0,8,8,8,8,6,6,7,0,6,8,6,8,0,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,65535,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,65535,65535,73,75,65535,77,65535,79,81,83,85,87,89,91,93,95,97,99,65535,101,65535,103,105,107,109,111,113,115,117,119,121,123,125,65535,65535,127,65535,65535,129,131,133,65535,135,65535,137,65535,139,141,65535,143,145,65535,147,149,151,153,155,157,159,161,163,165,167,65535,65535,169,171,173,175,177,179,181,183,185,187,189,65535,191,65535,193,195,197,199,201,65535,203,205,207,65535,209,211,65535,213,215,65535,65535,65535,217,219,65535,65535,221,223,65535,225,227,65535,229,231,233,235,237,239,241,243,245,65535,65535,247,249,251,253,255,257,259,65535,65535,65535,261,65535,263,265,267,269,271,273,275,277,279,281,283,285,287,289,291,293,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,65535,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,65535,65535,74,76,65535,78,65535,80,82,84,86,88,90,92,94,96,98,100,65535,102,65535,104,106,108,110,112,114,116,118,120,122,124,126,65535,65535,128,65535,65535,130,132,134,65535,136,65535,138,65535,140,142,65535,144,146,65535,148,150,152,154,156,158,160,162,164,166,168,65535,65535,170,172,174,176,178,180,182,184,186,188,190,65535,192,65535,194,196,198,200,202,65535,204,206,208,65535,210,212,65535,214,216,65535,65535,65535,218,220,65535,65535,222,224,65535,226,228,65535,230,232,234,236,238,240,242,244,246,65535,65535,248,250,252,254,256,258,260,65535,65535,65535,262,65535,264,266,268,270,272,274,276,278,280,282,284,286,288,290,292,294,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({8479,9023,8480.5,9893,7879,-0.033565357,8639.5,9135.5,6974.5,7569,9011,7720.5,8750,9040,9293,6286,7524,8265.5,18.5,12.5,15.5,8945,8554,8417,10962.5,9245,7207.5,1914,8627.5,6036,1.5,7221.5,7614,8101,5865,9239,7668,0.0105426125,15.5,4.5,0.0057760254,6482.5,-0.020981641,-0.03323134,2.5,6834.5,8746,8291,21600.5,8100,9955.5,14,-0.023406131,4.5,6966.5,9361,-0.023587128,5061.5,7006.5,-0.011775136,6129,7384,-0.03329901,2.5,12849.5,9492.5,-0.008723068,-0.00045090177,0.005120167,17.5,7597,7657.5,7656,14.5,17.5,9763,12.5,1.5,8044,-0.0019501655,-0.016899785,8732.5,1.5,9.5,10085,8283.5,11353,18645.5,22765.5,7359.5,7441,4844,-0.010887339,4.5,-0.0018625883,-0.00662186,6350,14.5,4900,4301.5,9876,12.5,5493.5,-0.003705645,-0.019216394,0.00065637944,0.012937131,1.5,8,-0.0007444936,-0.008634447,1.5,2,17.5,7961,0.007424239,0.0018914007,11.5,7764,9392,0.00668271,-0.0017391107,-0.0030896214,0.0039051794,0.0010647954,0.010849203,0.0061483607,0.0057659154,0.0022222728,0.0027091354,9763,4288.5,7338.5,5410,8543.5,8654,3898.5,0.008607342,8677,1.5,8616,12.5,17.5,18.5,12,9258,11457,14180,18172,15910,20764.5,5.721121e-05,0.0025403525,-0.00017726919,-0.024865165,0.0013487497,0.0043576113,-0.0012516429,0.0027638138,-0.0034297449,0.0037061952,0.013532363,0.008585903,0.0059838546,0.0013374047,-0.015510837,-0.003743979,0.0009202743,0.0071246712,-0.007773773,8.524927e-05,0.0042356635,-0.0009278534,0.0056260847,-0.018015612,0.0057834494,0.00057463057,0.0101990355,-0.0027505716,-0.017405333,0.0071355165,0.00088492734,-0.0011891029,0.002181057,-0.00022000434,0.0047977716,0.0027112754,0.00021809994,0.0033098743,0.0013747333,0.00071377325,0.0014587934,0.0005197473,0.0032935708,-0.01780078,0.007040555,0.0014317168,-0.0056132316,-0.017959943,0.0068331095,-0.0019565637,-0.0049655004,0.0019916845,0.00035724728,-0.013123675,-0.005452543,-0.014966338,-0.005340859,0.0019788889,0.008721402,0.0007330561,0.004820292,0.014460337,0.020126794,0.0061550546,-2.4953511e-05,-0.0015095099,0.023607433,0.015025127,-0.0017650657,-0.014939003,0.012347406,-0.000106268984,0.00055644574,-0.002239636,0.0039403667,-0.0011311043,-0.0002890131,-0.004722069,0.0062716864,-2.8140645e-05}, {2,3,2,6,0,255,2,6,3,0,0,5,2,6,6,3,2,2,8,8,8,3,2,4,3,7,0,1,3,3,8,0,3,2,1,1,0,255,8,8,255,4,255,255,8,5,2,5,0,7,0,8,255,8,2,6,255,7,0,255,0,2,255,8,6,6,255,255,255,8,2,0,2,8,8,0,8,8,0,255,255,2,8,8,0,5,6,0,0,7,0,0,255,8,255,255,0,8,0,0,6,8,7,255,255,255,255,8,8,255,255,8,8,8,2,255,255,8,0,1,255,255,255,255,255,255,255,255,255,255,0,0,6,1,2,2,0,255,2,8,3,8,8,8,8,2,6,1,1,5,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,65535,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,65535,73,75,65535,77,65535,65535,79,81,83,85,87,89,91,93,65535,95,97,99,65535,101,103,65535,105,107,65535,109,111,113,65535,65535,65535,115,117,119,121,123,125,127,129,131,133,65535,65535,135,137,139,141,143,145,147,149,151,153,155,65535,157,65535,65535,159,161,163,165,167,169,171,65535,65535,65535,65535,173,175,65535,65535,177,179,181,183,65535,65535,185,187,189,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,191,193,195,197,199,201,203,65535,205,207,209,211,213,215,217,219,221,223,225,227,229,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,65535,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,65535,74,76,65535,78,65535,65535,80,82,84,86,88,90,92,94,65535,96,98,100,65535,102,104,65535,106,108,65535,110,112,114,65535,65535,65535,116,118,120,122,124,126,128,130,132,134,65535,65535,136,138,140,142,144,146,148,150,152,154,156,65535,158,65535,65535,160,162,164,166,168,170,172,65535,65535,65535,65535,174,176,65535,65535,178,180,182,184,65535,65535,186,188,190,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,192,194,196,198,200,202,204,65535,206,208,210,212,214,216,218,220,222,224,226,228,230,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7.5,7838.5,18817.5,7721,9265,23866,17794,9109.5,2720,5439.5,8375,17592.5,14720,29850.5,18952,8990.5,5492,7335.5,7785,7436.5,6409,6388.5,11253.5,15.5,19183,21571.5,22459.5,21386,18453,17817.5,18968.5,7973.5,7735,1.5,9840.5,0.0024024418,0.012832547,6848,9033.5,8265.5,6859,7182.5,6473,6397,6504,10531.5,25905.5,10299.5,11264.5,17118,21139.5,22618.5,22009.5,22170,21793.5,12808.5,22308,-0.0075090677,19049,26000,32519,-0.008345436,18061,7120.5,5690.5,3,2216.5,30580,3171.5,7351,9986.5,5681,0.010921143,6760.5,7764,5013,8420.5,4.5,8794.5,5877.5,8535.5,6220,9250.5,8129.5,4.5,4.5,9618.5,10732,15119,2.5,31182,8920.5,5774.5,3927.5,12015,19065,16941,17718,20393,27960.5,15.5,15.5,22738.5,0.012432033,19332.5,29334,29498,28510,25250,12.5,24053.5,16.5,28450,16,0.002379617,16.5,16.5,26733,17321,5918.5,8057.5,3631.5,7280,7506.5,7506.5,1.5,8547.5,7256.5,-0.004120235,3162.5,12217,7714.5,6931.5,-0.020988865,0.0014209759,3283,1.5,6853.5,2.5,4,4,0.0060867346,0.012008893,1.5,2.5,3054,1496,4375.5,5898.5,2.5,6904,7056,0.003407929,3191,8286.5,10080,1.5,9890,10531.5,11019.5,10563.5,10951.5,6525,9253,12246.5,1.5,10146,8195,32011.5,21973,19009.5,28329,31223.5,6976,6520.5,12.5,16115,3783.5,5682,11570,17219.5,16804.5,-0.001494222,12441,18091.5,0.011482738,0.0050012423,0.008117356,0.0147999,27258,14062,13222.5,27312.5,0.007938164,23778.5,13.5,17.5,17,16.5,16958,16936,17.5,17,-0.00477723,0.0028026593,8387,14723,22776.5,13308.5,18,18.5,14.5,0.00013956953,15.5,-0.0015255319,0.007666548,0.0024357915,22027,21504.5,8.5,18748,15.5,3003,18310,16388.5,0.00047646483,-0.0011745692,0.0032412005,-0.006234639,-0.0059765,0.002084214,-0.0019847846,-0.01170855,0.0012683788,0.0056521543,-0.0016310252,0.0009319042,0.002279122,-0.0001044727,-0.0004704486,-0.023646217,0.0010403171,0.0042080707,-0.0010097472,-0.004712906,0.00072357926,-0.0010980972,-0.0053743403,0.0038394872,0.004839562,0.018148022,0.00066009973,0.0083958935,-0.007894877,0.00072508457,-0.0003044449,0.002403179,-0.00725566,-0.020287067,0.0012501188,-0.0005373595,0.00511272,0.002176641,-0.01671224,-0.00082064216,0.0076776366,0.0016904989,-0.004029218,-0.0017847707,-0.0030130951,-0.007676477,0.0028273966,0.013189013,0.0014921972,-0.009302218,-0.0025298884,-0.011393336,-0.004354194,0.0007544374,-0.02705147,-0.009879865,0.004066155,-0.0037415728,-0.017523639,-0.006583129,0.00016677701,-0.0024660828,-0.036846288,-0.006529572,-0.00023842875,-0.012007948,0.0010991301,-6.282724e-05,-0.0079601295,-0.0012437578,0.0060432404,-0.004215011,-0.006841299,0.0005026634,0.0069943625,-0.0001443423,-0.0028661774,0.017837612,0.003368916,-0.00013280545,0.0051143626,-0.020955902,0.0010295081,-0.007014777,0.0039009338,-0.004315217,0.0012247033,-0.0021330474,0.0023458267,0.00057171186,-0.0009990493,0.00039851028,-0.0035398824,0.00011465283,0.0034059666,-0.00020123289,-0.00071625016,0.00027537474,-0.0025799137,-0.00087872165,-0.0003796295,-0.002072662,0.0013904412,-0.0011996398,6.10249e-05,-0.0022655008,0.0020370637,0.00027532532,0.0002379746,-0.0044253343,-1.1436833e-05,-0.00600293,0.0048880484,0.0027712549,-0.0038433701,-0.008468324,-0.00021843021,-0.0044600647,-0.0032898902,0.00011211961,-0.0063360916,-0.011293601,-0.0005145542,-0.0019508187,-0.0016029123,-0.0030433845,0.000167276,0.0022369241,-0.00021793139,-0.0035490603,0.0019564468,0.00035702533,0.001496881,-0.002052844,0.0050989403,0.0028043995,-0.00069873803,0.0028893426,-0.0022914445,-0.0006667491,0.008956626,0.0039457004,0.0031914152,-0.0004710937,-0.0016197695,0.009175758,-0.004599847,0.0047514215,0.00021928607,0.004950043,-0.0001989341,0.0020827993,-0.0004481993,0.0027808591,-0.0009976506,-0.002923372,0.00021743168,0.0005832982,-0.00052952586,-0.003982865,2.3912305e-06,0.0019612836,0.00096897315,-0.0020655007,0.00079503935,0.0005511399,-0.00035493897,0.0002107004,0.0014415545,0.00403195,-0.00063360645,0.0013173363,-0.0043048263,-0.0005657223,0.0027103291,-1.1834384e-05}, {8,2,7,2,6,6,5,1,3,4,1,7,7,6,7,1,6,0,3,6,4,5,7,8,6,3,4,1,0,3,7,4,4,8,6,255,255,1,3,3,7,7,0,1,7,6,7,2,2,6,4,2,1,2,5,3,3,255,7,0,4,255,6,3,7,8,2,7,0,6,0,4,255,4,0,5,3,8,2,6,7,7,6,2,8,8,6,2,0,8,1,6,5,3,6,0,2,0,6,6,8,8,1,255,4,6,0,0,2,8,7,8,0,8,255,8,8,1,0,1,6,1,1,0,0,8,0,5,255,2,0,5,2,255,255,5,8,0,8,8,8,255,255,8,8,4,0,4,0,8,1,0,255,0,3,0,8,0,2,6,0,4,5,2,0,8,0,4,6,6,2,6,3,2,7,8,7,3,1,4,7,5,255,0,4,255,255,255,255,0,0,7,4,255,0,8,8,8,8,7,5,8,8,255,255,1,3,1,0,8,8,8,255,8,255,255,255,0,3,8,1,8,2,3,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,65535,65535,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,65535,111,113,115,65535,117,119,121,123,125,127,129,131,133,135,65535,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,65535,197,199,201,203,205,207,209,211,213,215,65535,217,219,221,223,225,227,229,231,233,235,237,239,241,65535,243,245,247,249,65535,65535,251,253,255,257,259,261,65535,65535,263,265,267,269,271,273,275,277,279,65535,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,323,325,327,329,331,333,335,337,65535,339,341,65535,65535,65535,65535,343,345,347,349,65535,351,353,355,357,359,361,363,365,367,65535,65535,369,371,373,375,377,379,381,65535,383,65535,65535,65535,385,387,389,391,393,395,397,399,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,65535,65535,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,65535,112,114,116,65535,118,120,122,124,126,128,130,132,134,136,65535,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,65535,198,200,202,204,206,208,210,212,214,216,65535,218,220,222,224,226,228,230,232,234,236,238,240,242,65535,244,246,248,250,65535,65535,252,254,256,258,260,262,65535,65535,264,266,268,270,272,274,276,278,280,65535,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,326,328,330,332,334,336,338,65535,340,342,65535,65535,65535,65535,344,346,348,350,65535,352,354,356,358,360,362,364,366,368,65535,65535,370,372,374,376,378,380,382,65535,384,65535,65535,65535,386,388,390,392,394,396,398,400,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({2289.5,1183.5,1232.5,69,1622,2104,2635,65.5,246.5,19.5,4848.5,16.5,12.5,2496,2670.5,78,26.5,44.5,405.5,1126,2133,3653.5,18.5,1869.5,5582.5,6.5,17.5,2447,10831,20.5,7.5,90,74.5,48,81,92,15.5,742,513.5,1380,4.5,1325.5,0.042281535,1173.5,5686,2071.5,6677.5,6.5,7.5,-0.015352857,19.5,544.5,7.5,15.5,21,1.5,15,2631,11669.5,2629.5,2973.5,3777.5,3966.5,75,19.5,18.5,2,150,1.5,4.5,6.5,13,201,7.5,301.5,326,21.5,4.5,493,1144.5,15.5,1003.5,1003.5,1279.5,20.5,2516.5,2211.5,3152,20.5,0.004624858,15,0.020158127,-0.0015262917,2.5,12.5,3,-0.005277033,-0.00018321683,0.00045654687,3.5,-0.0036401798,0.0022492788,0.007787986,544.5,5266.5,19.5,-0.002707392,2297.5,133.5,5.5,-0.03530351,6286.5,-0.020600896,10866,18,18.5,18516,7401,2379.5,13364,4668,3866,4040.5,27.5,48,40.5,29.5,32.5,62,-0.003666617,19,83,5,-0.0046571065,-0.016267287,28.5,39,2.5,122.5,3,18.5,15.5,16,1.5,346.5,20.5,20.5,291.5,738.5,1713,2590.5,415.5,415.5,449,455,2.5,18.5,1059,-0.0104389405,1.5,1185.5,12.5,12.5,1380,505.5,962.5,1196.5,16.5,15.5,9.5,2063.5,15.5,-0.02905246,4.5,-0.0071100625,6.5,17,0.0026917264,2204,7.5,-0.0059458506,-0.0045577814,-0.016656654,0.002082857,-2.6164202e-05,-0.0033167272,-0.007980576,-0.0050656204,16.5,0.004415069,0.0006729002,0.024274401,2400.5,18,17.5,-0.013641014,10.5,1733,7044.5,5.5,4.5,5.5,-0.0022566202,6.5,1086.5,15.5,12.5,426.5,0.0012165097,1859.5,7669.5,2323.5,1.5,4516.5,4696,18.5,4057.5,5368,4341,-0.00078768795,0.0008993484,-0.014526337,-0.0035792086,0.003528603,0.007940675,0.0025133821,-0.010967533,-0.0064339894,-0.00087449973,-0.008318349,-0.02175294,0.0035197565,-1.3716373e-05,-0.004821522,-0.011561393,-0.0026804286,0.00022206582,-0.0032678207,0.0017984513,-0.012664065,-0.005528658,0.0019283964,-0.011232845,0.0056080646,-0.00035995242,-0.0013823936,0.0023365552,0.013756429,0.0039329133,-0.0034947644,-0.0017099491,-0.005008671,-0.009948987,1.6922142e-05,0.0055094524,-0.0009933878,0.005738864,0.004195331,-0.006273112,0.006733082,0.021888945,-0.004443712,0.005217282,-0.013006203,-0.0060430593,0.0026819285,-0.0010396364,0.022787422,0.0036252334,-0.017157735,0.0016098984,0.011323999,0.0037482248,-0.0122455135,-0.006284681,0.005202087,-0.00011554215,-0.0017979298,0.0038224366,-0.00072368514,-0.008810014,-0.0021677196,-0.006414734,-0.0029560414,0.019965492,0.005133158,0.0002464142,-0.004751259,0.0063053006,0.008028275,0.0013863255,0.0070353644,-0.007974732,0.005889281,-0.007915496,0.0052710297,-0.00559584,0.04148262,0.0073172636,0.008927654,0.02584503,-0.002160271,-0.0070136576,0.001293173,-0.0032550138,0.005777692,-0.00047722078,-0.006793839,-0.016233353,0.00075361365,-0.0012870093,-0.0012988567,0.0015580816,0.0035263754,0.008948555,-0.0063813888,-0.014087371,-0.0006769611,0.0044887806,-0.00034327147,0.00055440626,-0.0070108287,0.00033842213,0.0029541021,-0.0149818165,-0.006702147,-0.0011371007,-2.9256813e-05,-0.0010538294,0.017544819,-0.00011918439,-0.0260561,-0.0018535499,-0.014388554,-0.006962309,-0.0015682135,-0.0041471254,-0.002404303,0.0043789227,-0.00084520347,0.001522419,-0.019939912,-0.0015526608,0.005731882,0.008272477,-0.0007196525,0.0008504909,0.014077387,0.028499577,-0.0025206,-0.009861742,0.004194737,0.00023981454,-0.0013917848,0.0015203201,-0.0046390644,-0.0007709017,-0.0002634392,-0.0028535414,0.012849571,0.000107658,-0.00083080085,-0.0051637865,0.0036008004,-0.000620775,0.0012158582,0.005554513,-0.0015403088,-2.8691215e-05}, {6,7,7,3,0,2,7,2,2,8,3,8,8,4,6,0,7,1,5,3,7,2,8,4,0,8,8,4,0,8,8,5,7,3,0,2,8,1,4,5,8,3,255,6,4,6,0,8,8,255,8,1,8,8,8,8,8,7,1,6,7,5,7,4,8,8,8,2,8,8,8,8,4,8,0,4,8,8,5,1,8,1,1,7,8,0,2,4,8,255,8,255,255,8,8,8,255,255,255,8,255,255,255,1,0,8,255,6,0,8,255,1,255,0,8,8,1,0,0,6,1,4,7,2,0,2,0,7,3,255,8,2,8,255,255,1,4,8,6,8,8,8,8,8,4,8,8,4,6,0,0,5,5,1,0,8,8,2,255,8,1,8,8,5,4,0,0,8,8,8,6,8,255,8,255,8,8,255,0,8,255,255,255,255,255,255,255,255,8,255,255,255,7,8,8,255,8,2,0,8,8,8,255,8,0,8,8,0,255,0,0,3,8,1,1,8,4,4,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,65535,85,87,89,91,93,95,65535,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,65535,175,65535,65535,177,179,181,65535,65535,65535,183,65535,65535,65535,185,187,189,65535,191,193,195,65535,197,65535,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,65535,231,233,235,65535,65535,237,239,241,243,245,247,249,251,253,255,257,259,261,263,265,267,269,271,273,275,277,279,281,65535,283,285,287,289,291,293,295,297,299,301,303,305,307,65535,309,65535,311,313,65535,315,317,65535,65535,65535,65535,65535,65535,65535,65535,319,65535,65535,65535,321,323,325,65535,327,329,331,333,335,337,65535,339,341,343,345,347,65535,349,351,353,355,357,359,361,363,365,367,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,65535,86,88,90,92,94,96,65535,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,65535,176,65535,65535,178,180,182,65535,65535,65535,184,65535,65535,65535,186,188,190,65535,192,194,196,65535,198,65535,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,65535,232,234,236,65535,65535,238,240,242,244,246,248,250,252,254,256,258,260,262,264,266,268,270,272,274,276,278,280,282,65535,284,286,288,290,292,294,296,298,300,302,304,306,308,65535,310,65535,312,314,65535,316,318,65535,65535,65535,65535,65535,65535,65535,65535,320,65535,65535,65535,322,324,326,65535,328,330,332,334,336,338,65535,340,342,344,346,348,65535,350,352,354,356,358,360,362,364,366,368,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({19.5,15.5,270.5,10299.5,6694.5,48.5,371.5,5418.5,2586.5,1733,6836.5,73.5,281.5,384,2640.5,5180.5,5960.5,10348,12200,1014,1530.5,9651,6980.5,63.5,29.5,31,-0.022945542,20.5,327,791,4010.5,5272,4405.5,4772,7.5,14.5,12.5,9698,18290.5,765,1139,536,2397.5,9355,11695.5,7425,7315,63.5,27.5,25989.5,815.5,100,55.5,435,0.051154774,294,-0.011586483,252.5,2196,3444,4183.5,2.5,9237.5,272,5707,5789.5,5466.5,5966,5817.5,10340,-0.00094288,2.5,10368,7067,10796.5,20509.5,21547.5,734.5,1116,1064.5,1727.5,4236,822,3643,2773.5,6575,0.0046522818,10037,15773.5,6683,3411.5,7789,10112,51.5,118.5,55,156,-0.018064413,-0.0054697543,97.5,19267.5,931.5,0.015280855,536.5,237,0.009121473,-0.0038019181,4175,304.5,901.5,383.5,1511.5,1860,3069,1554,2504.5,11549,3900,4.5,8993.5,10520.5,4.5,4182.5,7627,5137,1489,5540.5,5673.5,5721,4.5,6579,8549,10000.5,1.5,6.5,10113,4.5,13.5,-0.0070039327,6982,11777.5,11419.5,1.5,12707,-0.01183384,18228,22241.5,28.5,1842.5,18.5,1323,837,18.5,16.5,4898.5,2321,18.5,-0.014464334,7755,3059,1994.5,10015.5,6396,3789,7614,17.5,7266.5,11809.5,0.004813653,1761.5,8733.5,2455.5,4954,7330,9856,7675,13091.5,68.5,39,125,57.5,-0.005933862,52,190.5,0.0010841329,-0.0019207265,1007.5,-0.0022917087,-0.007098178,20.5,-0.0063598417,97.5,-0.026857663,191,-0.011475989,0.0017030264,-0.0005100672,-0.0071449922,4237,0.00286378,0.009692824,698,391.5,1323,2285.5,2218.5,2041.5,2779.5,3578.5,67,1251.5,0.0256884,4094,958.5,12045.5,-0.00044240258,-0.0023137878,0.0014155942,-0.00026649534,0.0041327802,-0.001468059,0.011294989,0.006010582,-0.014848383,-0.007894046,0.0010162058,-0.0024877917,0.008558628,0.0017446205,0.0025647765,-0.0075464337,-0.006157177,0.0009519225,0.013251031,0.005378919,-0.0024961282,-0.013244803,-0.00057469984,-0.0045693023,0.0007811131,0.0126788365,0.00064593274,-0.00038099717,0.0013815725,-0.0009726955,-0.0019141965,-0.0005823572,0.0006891483,0.0028175723,-0.00019971002,0.002140068,-0.0015823521,-0.0052361945,0.0011011928,-0.0035919372,-0.0011114891,-0.003908196,0.0010642492,-0.002560031,0.009757327,0.00063698523,0.0011629991,-0.0028670956,0.009990432,-0.010885459,-9.074562e-05,-0.001894488,0.0035589356,-0.00031034724,0.00035784728,-0.00013973044,-0.0005804863,0.0015638268,-0.013416025,-0.003144759,0.0049222894,0.013877161,-0.0149411755,0.0034502756,-0.0078059137,-0.037636783,-0.0064639756,-0.020780085,-0.0051015136,-7.276677e-05,-0.03315225,-0.0023960038,-0.007918192,0.0023576026,-0.008201028,0.0065046027,-0.002025036,-0.0073253266,0.008681681,-0.015493791,-0.0048533296,0.002735098,-0.0033547338,0.0009294531,0.00070922036,0.0018196922,-0.004332136,0.011336366,-0.017300515,-0.007199973,0.0008889548,-0.0048146807,0.011273336,0.002334817,-0.0067019598,-0.0034097594,-0.0062997113,0.004323675,-0.011114288,0.0019604578,0.0067134933,-0.00055360043,0.0054476117,0.010208809,-0.0068417722,0.0034553276,-0.025079144,0.003282398,0.0036703926,5.2956322e-05,-0.002490782,-0.00021335087,-0.00051349355,-0.009087521,0.0010415479,0.0059401602,-0.011403578,-0.0045210505,0.00036583608,-0.0047659967,-0.0023044643,0.00205574,0.0063585336,0.0019425983,0.0052235685,0.0018247688,-0.00095298415,-0.0027295246,-0.010439697,-0.004938072,-0.0050388756,0.0005918793,-0.00259453,-0.00033609243,-0.02372467,-0.001764535,0.030799067,-0.004154717,-0.0059178188,0.0058463337,0.02513409,0.00671904,-0.0063571422,-0.022583794,0.013182859,-0.00038322152,-0.008493033,0.00070641516,-0.014442019,-0.007045553,-0.001417816,-0.014006701,0.008773829,-0.0011351052,-0.004927406,0.008401076,-0.008204046,0.0007004936,-0.0038163334,-0.0003931345}, {8,8,3,2,5,3,2,5,3,7,5,1,2,4,2,7,5,2,2,7,3,0,4,0,7,4,255,8,3,2,3,5,1,3,8,8,8,3,2,7,7,0,7,3,6,5,4,2,3,0,4,2,5,0,255,3,255,4,1,6,3,8,0,4,1,7,0,5,6,2,255,8,4,3,0,0,4,6,5,5,7,6,0,0,7,4,255,0,0,4,0,6,6,5,6,2,0,255,255,0,0,0,255,0,3,255,255,0,3,0,5,7,0,6,0,4,6,1,8,6,0,8,5,6,5,7,5,6,5,8,7,4,5,8,8,0,8,8,255,1,0,2,8,1,255,3,5,5,0,8,0,1,8,8,0,6,8,255,0,1,1,6,4,0,0,8,3,2,255,0,0,2,6,7,2,5,6,6,3,2,0,255,6,6,255,255,0,255,255,8,255,1,255,3,255,255,255,255,0,255,255,6,5,0,6,1,0,4,0,0,1,255,7,7,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,65535,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,65535,107,65535,109,111,113,115,117,119,121,123,125,127,129,131,133,65535,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,65535,165,167,169,171,173,175,177,179,181,183,65535,65535,185,187,189,65535,191,193,65535,65535,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,65535,257,259,261,263,265,65535,267,269,271,273,275,277,279,281,283,285,287,289,65535,291,293,295,297,299,301,303,305,307,309,65535,311,313,315,317,319,321,323,325,327,329,331,333,65535,335,337,65535,65535,339,65535,65535,341,65535,343,65535,345,65535,65535,65535,65535,347,65535,65535,349,351,353,355,357,359,361,363,365,367,65535,369,371,373,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,65535,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,65535,108,65535,110,112,114,116,118,120,122,124,126,128,130,132,134,65535,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,65535,166,168,170,172,174,176,178,180,182,184,65535,65535,186,188,190,65535,192,194,65535,65535,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,65535,258,260,262,264,266,65535,268,270,272,274,276,278,280,282,284,286,288,290,65535,292,294,296,298,300,302,304,306,308,310,65535,312,314,316,318,320,322,324,326,328,330,332,334,65535,336,338,65535,65535,340,65535,65535,342,65535,344,65535,346,65535,65535,65535,65535,348,65535,65535,350,352,354,356,358,360,362,364,366,368,65535,370,372,374,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({11386,12.5,11396.5,11237.5,6694.5,12.5,21438.5,8653,11633.5,12836.5,10293,0.019464472,0.008637368,1.5,17289,8929.5,6551.5,6289.5,1.5,4625.5,6609,8370,6847,10470.5,22682.5,20182.5,21669.5,8563,7894,6515.5,10890.5,2916,11762,10235.5,10289,4556,7218,12753.5,6827,8351.5,7586,5923.5,11079.5,3096,11526.5,14202.5,22950.5,20596.5,15.5,1.5,24481,6304,9998.5,878,8660,5888.5,7951,7999,10450,11473,13813.5,9224,10288,7767,12121,7763,7.5,8479.5,3156.5,5692,9411.5,11412.5,4771.5,15.5,6685.5,7642.5,9393,7080,7959,10708,7335,10267.5,29109,24075.5,12151,14380,22899.5,14458,18327,0.015234296,25466,8081.5,15.5,25945.5,22607,0.0032093774,21805,21572.5,17947.5,5916.5,5324.5,6350,0.020801272,0.006775241,2750.5,4.5,6.5,5103.5,10279,5937.5,0.018227173,1.5,11303,9449.5,1.5,2.5,5852,6184.5,4.5,6350.5,10710,7,7.5,12234.5,-0.023567999,11199.5,8546.5,7017,11482.5,18829.5,15396.5,3719,8344,7600.5,6515,5489.5,4914.5,7022.5,10307,13359.5,6169,26161.5,5693.5,0.005966686,19,0.0064017363,15.5,7909,7695.5,15,0.0013117795,6523.5,9693,9759.5,9803.5,7022.5,5486,7327.5,7988,9469.5,12588,14345,24447,2433,3003,9664.5,3158.5,9795.5,-0.007832882,16632,17732,10758.5,19646.5,14195,18159,23293,24793.5,25363.5,17738.5,1.5,17011.5,0.00988069,3.5,0.009953604,24256.5,7.5,7.5,19927.5,23378.5,17871,18578.5,-0.00056223775,0.0010620578,0.0028299724,-0.0021303098,-0.002268792,0.002656616,-0.0014021453,0.0021871373,0.011163301,0.0049961708,0.0016604889,-0.0004024493,-0.00092679745,0.012654952,-0.0015185213,0.0014036731,0.0037057132,-0.0029486588,-0.0111903325,-0.0021092033,-0.018139359,-0.0053955833,0.0012434102,-0.015763942,0.009480193,-0.018919064,-0.0037036415,-0.0010885649,-0.007917354,-0.0047582677,0.0035688702,-0.0037425102,-0.0017723291,-0.0051437435,0.0016141244,0.013118601,0.00014627766,-0.00812485,0.00311924,0.0076095792,-0.0018089692,-0.0002679386,-0.00881001,0.0030221788,-0.0007295787,0.0116702905,-0.0066835033,-0.0018893763,0.00038412015,-0.0038260974,0.003485199,-8.879423e-05,-0.004158445,0.0004160794,0.0025882612,-0.001872157,0.0003131189,0.0014932791,-0.00021263654,-0.0022023122,-2.7612403e-05,0.0069589736,-0.00528345,-0.010409554,0.00010410021,0.003484698,0.009578039,-0.0055356533,0.0008161439,0.00643031,-0.00012930749,0.004889715,-0.0035494987,-0.0126121,-0.0024723904,-0.0102260215,-0.0006615046,0.01185955,-0.004689307,0.0044269483,0.0027821918,0.001452708,0.0004995368,0.003180676,-0.00066526694,0.003210696,0.0029417076,-0.0025048011,0.006494373,0.017449474,-0.013314608,-0.005519043,-0.027063211,-0.009814987,0.0031822876,-0.0016764135,-0.010043675,-0.001993029,-0.011127815,-0.003578815,0.0025443693,-0.0032061718,0.013321883,0.005171754,0.002938533,0.004699131,0.00039121718,-0.019227633,-0.011558396,-0.002339305,0.003497444,0.0011402245,-0.0058488464,-0.0010007947,0.0005357144,-0.0017540971,-0.0016719539,-0.0075752833,0.00033443136,0.0017340897,0.00039404465,0.0030079638,0.0038301237,-0.001307596,0.00591525,0.01089782,-0.0035479583,0.00044195392,0.0004923698,-0.0026597404,0.010538383,0.002448896,0.0007991117,-0.0034800458,0.008568348,-0.0004531537,-0.0054892725,0.0016212959,0.006002527,0.002215848,0.0063420623,0.002217293,0.014847137,-0.001468182,0.0013535431,0.0074039414,0.003514481,0.0004004687,0.00079478836,0.004739595,0.0026895737,0.0006657704,-0.015583709,-0.009177583,-0.0045702043,-0.0007501322,0.009664911,0.0025431544,-0.0043098484,0.0022073637,0.003559983,0.0006359363,-0.0006557609,8.684766e-05}, {3,8,3,6,5,8,2,6,6,6,5,255,255,8,3,7,1,1,8,5,5,6,1,2,0,5,2,6,2,1,7,1,0,4,3,5,0,4,3,6,4,1,2,4,3,1,0,1,8,8,6,7,0,0,2,2,0,5,6,2,4,1,2,3,2,7,8,2,7,1,0,0,3,8,5,4,0,2,5,4,2,6,4,5,7,4,3,0,6,255,0,5,8,2,2,255,3,0,3,5,5,2,255,255,0,8,8,1,0,0,255,8,1,2,8,8,0,1,8,7,0,8,8,0,255,5,3,7,7,0,6,5,4,0,0,3,5,6,6,6,5,0,1,255,8,255,8,5,5,8,255,0,2,4,4,0,0,0,2,2,5,2,0,4,2,6,4,0,255,7,2,4,4,0,7,0,1,2,4,8,3,255,8,255,0,8,8,3,0,5,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,65535,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,65535,175,177,179,181,183,65535,185,187,189,191,193,195,65535,65535,197,199,201,203,205,207,65535,209,211,213,215,217,219,221,223,225,227,229,231,233,65535,235,237,239,241,243,245,247,249,251,253,255,257,259,261,263,265,267,269,65535,271,65535,273,275,277,279,65535,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,311,313,65535,315,317,319,321,323,325,327,329,331,333,335,337,65535,339,65535,341,343,345,347,349,351,353,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,65535,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,65535,176,178,180,182,184,65535,186,188,190,192,194,196,65535,65535,198,200,202,204,206,208,65535,210,212,214,216,218,220,222,224,226,228,230,232,234,65535,236,238,240,242,244,246,248,250,252,254,256,258,260,262,264,266,268,270,65535,272,65535,274,276,278,280,65535,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,312,314,65535,316,318,320,322,324,326,328,330,332,334,336,338,65535,340,65535,342,344,346,348,350,352,354,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({1939,1548.5,1888,1003.5,1570.5,1654.5,7675,992.5,20.5,2417,3864.5,18.5,2105,7562.5,7803,967,4.5,15.5,5033.5,12.5,14.5,5165,5865,16.5,1814.5,17.5,18.5,7541.5,7551.5,8308.5,7537.5,1119.5,771.5,0.001812291,18.5,1108,1325.5,1508,5880.5,6,1280.5,6.5,-0.029929271,1713,3543.5,7685.5,24.5,6.5,-0.0068674246,0.030083975,-0.010836993,6.5,2442,6.5,0.020976963,7427.5,1.5,6657.5,8753.5,9199,8033,9534.5,9355.5,637,18.5,12,1467.5,-0.019411905,21,1733,8669,1948.5,1391.5,953,495.5,680.5,7253,1280.5,1280.5,-0.008273882,15.5,-0.012920411,6.20475e-05,8.5,1770,3269.5,2428,18.5,18.5,52,1420.5,2.5,12.5,3,12.5,18.5,1794.5,4.5,12.5,7407.5,9204.5,0.0077109076,8422.5,7643,8806,15.5,7766,7293,7762,-0.00760917,1.5,5994.5,7776,7959,8772,344.5,608.5,845.5,1216.5,5,-0.026122037,1.5,13.5,-0.0024795784,-0.01371253,2.5,4.5,1340,118,1904.5,2453.5,1010,16.5,937,1297.5,749,0.041862812,-0.010888338,-0.0030841534,21.5,-0.005797208,-0.002276333,3.5,-0.0068618315,-0.016377527,-0.0043474776,18.5,7144.5,12.5,15.5,1921,1.5,17,-0.008026546,-0.0038821846,12.5,591.5,5.5,5257.5,2.5,-0.0021072326,6509.5,-0.02412532,0.007878779,4.5,0.01750989,1814.5,-0.002299105,-0.00503544,1809,1872,-0.003122666,-0.021814626,20.5,18.5,1703,0.0002187357,0.006959233,1703,1620,2.5,7456,17.5,-0.009486075,9089,20.5,7,7485.5,-0.002407843,1.5,0.01683873,13320,1.5,7204.5,7443,13930,9363,-0.0063948366,-0.039580543,5720,15.5,4.5,2.5,7951,6164,9486.5,9998,-0.00046737326,0.0028178955,-0.00728655,-0.0005270745,0.0021485358,-0.005681304,0.02443765,0.0026105612,-0.015736593,-0.0004160258,0.014276448,-0.0066734175,-0.0028371317,0.0054655196,0.009177345,0.0021308297,-0.0036818776,0.029000068,0.0031955128,0.0004759801,0.0012832978,0.006082768,-0.0050649187,-0.03396341,0.010457258,-0.0035639354,-0.007321529,0.011487947,-0.0056835893,0.0012404014,0.005377391,0.04293884,-0.025648627,0.0036066473,-0.003630868,0.014153185,-0.0013097873,0.0013615687,-0.010040548,-0.0035405208,0.005748373,0.0019176161,0.0042725927,-0.0018914243,-0.0040588924,0.001496748,-0.0038526363,-0.021833168,-0.005383165,-0.0012915762,0.0035919093,0.00032818332,0.0018289257,0.007087582,0.001135689,-0.0015977472,0.0053831674,0.009217449,-0.0072014853,-0.0010846456,-0.0020761692,-0.0174832,-0.0024032886,0.0027521346,-0.012953475,-0.006064286,-0.0010095814,0.0056551276,0.004565542,0.010561111,0.010886015,0.0016322574,0.00094857253,-0.0028040388,-0.00297294,-0.0076001175,-0.0042617708,0.008731787,0.0010726942,0.0029188315,4.3133667e-05,0.004196104,-0.0008973679,0.00013261117,-0.0061508063,-0.020061648,0.010013132,0.0013764928,-0.009079739,-0.005908952,-0.0043427437,0.0017911338,0.0017152595,-0.001583443,0.00012907115,-0.005553397,-0.015040754,-0.027179493,-0.006187768,0.009127662,0.0005648613,-0.0065174787,-0.001885308,0.005737796,-0.0042699757,0.01039452,0.00043688598,-0.015160128,-0.0020466617,0.001970438,0.021743773,0.008783225,-0.00026514824,-0.01571699,0.0024687431,0.0054856827,0.0007306189,-0.0020553656,-0.002256436,-0.017553909,0.0018513594,0.020528603,0.00035803582,-0.0050428673,0.0002283812,0.0025794439,-0.0026917954,-5.285528e-06}, {1,3,0,5,3,4,5,5,8,0,5,8,2,5,5,3,8,8,6,8,8,7,7,8,0,8,8,5,4,7,4,1,1,255,8,5,3,7,4,8,0,8,255,3,4,4,1,8,255,255,255,8,5,8,255,5,8,0,0,0,0,2,5,0,8,8,6,255,8,0,7,4,1,4,0,0,0,0,0,255,8,255,255,8,3,4,2,8,8,0,0,8,8,8,8,8,0,8,8,5,0,255,0,5,0,8,7,3,5,255,8,2,0,5,4,7,1,5,1,8,255,8,8,255,255,8,8,4,2,4,4,4,8,4,6,2,255,255,255,8,255,255,8,255,255,255,8,6,8,8,4,8,8,255,255,8,0,8,5,8,255,4,255,255,8,255,0,255,255,0,4,255,255,8,8,0,255,255,0,7,8,5,8,255,0,8,8,0,255,8,255,0,8,2,4,0,0,255,255,2,8,8,8,5,7,5,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,65535,67,69,71,73,75,77,79,81,65535,83,85,87,89,91,65535,65535,65535,93,95,97,65535,99,101,103,105,107,109,111,113,115,117,119,121,65535,123,125,127,129,131,133,135,137,139,141,143,65535,145,65535,65535,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,65535,183,185,187,189,191,193,195,65535,197,199,201,203,205,207,209,211,213,215,65535,217,219,65535,65535,221,223,225,227,229,231,233,235,237,239,241,65535,65535,65535,243,65535,65535,245,65535,65535,65535,247,249,251,253,255,257,259,65535,65535,261,263,265,267,269,65535,271,65535,65535,273,65535,275,65535,65535,277,279,65535,65535,281,283,285,65535,65535,287,289,291,293,295,65535,297,299,301,303,65535,305,65535,307,309,311,313,315,317,65535,65535,319,321,323,325,327,329,331,333,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,65535,68,70,72,74,76,78,80,82,65535,84,86,88,90,92,65535,65535,65535,94,96,98,65535,100,102,104,106,108,110,112,114,116,118,120,122,65535,124,126,128,130,132,134,136,138,140,142,144,65535,146,65535,65535,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,65535,184,186,188,190,192,194,196,65535,198,200,202,204,206,208,210,212,214,216,65535,218,220,65535,65535,222,224,226,228,230,232,234,236,238,240,242,65535,65535,65535,244,65535,65535,246,65535,65535,65535,248,250,252,254,256,258,260,65535,65535,262,264,266,268,270,65535,272,65535,65535,274,65535,276,65535,65535,278,280,65535,65535,282,284,286,65535,65535,288,290,292,294,296,65535,298,300,302,304,65535,306,65535,308,310,312,314,316,318,65535,65535,320,322,324,326,328,330,332,334,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({2865,1258,4584,2624,1320,4560.5,5600.5,37.5,13,20.5,2764.5,5991,7.5,11786,6782.5,22,74,5.5,-0.023936925,3204.5,1013.5,474.5,3301,5274.5,6628.5,2853,8704.5,2151,12567.5,9879,6787,93.5,23.5,65.5,317.5,-0.0090546245,0.0029081968,18.5,0.018047964,0.042816505,823,1.5,1309.5,3034,2773,4919.5,17.5,1526.5,7644.5,0.008226838,6709,18.5,13,4757,5599,8630.5,12.5,6990,11952,7024,217.5,26,15.5,27,145.5,47.5,13.5,349.5,949,16.5,588.5,0.00016496923,0.016750352,0.001493089,3913.5,4935,2436.5,17.5,16.5,18.5,26733,5610,5003,7237.5,5762.5,8309.5,7551,6670.5,7836,3,3.5,17.5,6554.5,-0.006718044,-0.016782632,846.5,5012.5,3899,12.5,8378,6412.5,4753,14767.5,6757.5,6826,1.5,5873,0.022946052,8798.5,3.5,6899,60.5,18.5,3,-0.013980861,15,0.012673609,41.5,15.5,31.5,71,2.5,106,143,15.5,992,917,1013.5,1071.5,0.013716015,1253,-0.006751781,-0.012487419,12,12.5,1144.5,1713.5,15.5,21.5,4.5,3073,16.5,-0.00815128,4.5,18.5,3602,7211.5,3.5,8000.5,5844,5467.5,5475,6648.5,5.5,5.5,3814,8308.5,12.5,6829,7458,4055.5,-0.005036805,6.5,0.0044244244,0.00020275974,-0.0052715424,-0.0012054293,-0.005697046,-0.01095192,9.5,1147.5,5694,4.5,7966,6.5,0.015679343,0.006764383,7,1.5,16.5,-0.013151473,7782,4763.5,8897,4771.5,5817.5,7746,7852.5,1.5,10916,8872,6106.5,1.5,3.5,0.0042430838,-0.017992383,-0.006671378,9453,7278,-0.0013643116,0.0022743049,-0.0010873877,0.011604421,-0.0024198839,-0.0063261422,0.0017460141,0.00082118734,0.0020168084,-0.0008028496,-0.0035905733,-0.015303368,0.0012233501,-0.009492948,0.0006673494,-0.0020903493,-0.00066505076,-0.0070949383,-0.0045095114,0.0016201911,0.0027428453,-0.0019300331,0.0038332164,0.0073489696,-0.002478509,0.00041546705,0.008678957,0.0001108288,0.0038931004,0.0018298241,0.0022564353,-0.00994529,-0.0076062977,0.0060062627,-0.0131493285,0.00012759648,-0.00019159119,-0.0017886953,-0.005319548,0.002709951,-0.017010063,0.0003409496,0.0021347227,0.009826741,-0.0011977903,-0.0054722545,0.007221646,0.0036340733,0.014520786,0.0058303657,-0.0021244918,0.0014784344,0.003727131,0.0006430466,-0.0017749505,0.0013503425,-0.001436266,-0.00011565806,-0.005622938,-0.0025807777,-0.0060139266,-0.02203842,0.00276744,-0.008425034,-0.00070038496,-0.024867421,0.004705678,0.0015787755,0.0020728156,-0.013100318,0.018797386,0.00033085866,-0.001919263,0.0005622944,-0.017673649,-0.007272379,0.0031319186,0.009360171,-0.0029859764,0.0024839668,-0.0012867143,0.0010972673,-0.00072378863,-0.0028809595,0.0004208579,0.005993698,0.0002698462,-0.0012024984,0.0014343399,0.00023635237,0.0012216353,-0.0028487004,-0.010090205,-0.02231407,-0.005734609,-0.0029774539,-0.0023443934,-0.009400041,0.0012783327,-0.0017987948,0.0001652342,0.0023175736,0.0057251872,0.015976887,0.0012760278,-0.0018677808,-0.004337249,-0.008073129,-0.002784568,-0.00022633716,0.010280618,0.0005608344,-0.00075875554,0.006143782,-0.0005144014,-0.004768118,0.000284548,-0.00555233,0.0023732458,-0.0114309555,0.0036418256,0.011001155,0.009754892,-0.012703237,-0.014141663,0.006010559,0.011753061,0.0057158223,0.0016189531,0.0057237637,0.004501285,0.0011348967,0.002577705,-0.0015149842,0.0053102705,-0.00018189312,-0.0028193195,-9.279881e-06}, {2,3,7,2,2,7,3,4,8,8,2,2,8,4,2,2,3,8,255,0,2,0,1,3,2,1,0,1,4,0,2,0,3,2,2,255,255,8,255,255,0,8,3,4,2,3,8,3,0,255,0,8,8,2,3,2,8,0,0,1,4,0,8,0,2,0,8,5,7,8,0,255,255,255,4,0,0,8,8,8,1,2,4,1,0,4,0,6,2,8,8,8,0,255,255,0,3,5,8,1,1,3,4,3,1,8,3,255,0,8,3,6,8,8,255,8,255,6,8,0,0,8,0,4,8,1,6,2,2,255,0,255,255,8,8,6,1,8,8,8,0,8,255,8,8,3,4,8,0,1,2,0,0,8,8,7,0,8,4,6,1,255,8,255,255,255,255,255,255,8,0,4,8,6,8,255,255,8,8,8,255,5,3,2,3,4,4,0,8,0,4,6,8,8,255,255,255,2,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,65535,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,65535,65535,69,65535,65535,71,73,75,77,79,81,83,85,87,65535,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,65535,65535,65535,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,65535,65535,169,171,173,175,177,179,181,183,185,187,189,191,65535,193,195,197,199,201,203,65535,205,65535,207,209,211,213,215,217,219,221,223,225,227,229,65535,231,65535,65535,233,235,237,239,241,243,245,247,249,65535,251,253,255,257,259,261,263,265,267,269,271,273,275,277,279,281,283,285,65535,287,65535,65535,65535,65535,65535,65535,289,291,293,295,297,299,65535,65535,301,303,305,65535,307,309,311,313,315,317,319,321,323,325,327,329,331,65535,65535,65535,333,335,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,65535,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,65535,65535,70,65535,65535,72,74,76,78,80,82,84,86,88,65535,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,65535,65535,65535,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,65535,65535,170,172,174,176,178,180,182,184,186,188,190,192,65535,194,196,198,200,202,204,65535,206,65535,208,210,212,214,216,218,220,222,224,226,228,230,65535,232,65535,65535,234,236,238,240,242,244,246,248,250,65535,252,254,256,258,260,262,264,266,268,270,272,274,276,278,280,282,284,286,65535,288,65535,65535,65535,65535,65535,65535,290,292,294,296,298,300,65535,65535,302,304,306,65535,308,310,312,314,316,318,320,322,324,326,328,330,332,65535,65535,65535,334,336,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({42.5,28.5,53,35.5,21.5,35.5,33,34.5,32,22,250.5,46,7.5,37,36.5,22,0.011791603,46,31,2.5,29,26,0.026326815,5.5,92.5,1.5,50,20,89,170,893,33.5,56.5,-0.021302927,18.5,20.5,12905.5,514,15.5,17.5,40.5,0.00959962,0.0021970419,150.5,18.5,12.5,7,45,63,79.5,13,15.5,21.5,2.5,2.5,83.5,1118.5,822.5,987.5,2.5,27,2.5,-0.020701542,82.5,78,15.5,287.5,18.5,3.5,56,-0.014226288,8.5,40,31.5,32,2.5,18.5,-0.002018923,0.0021296863,13,-0.005183832,116,116,166,15.5,-0.014461805,-0.0024260655,2.5,1380,47.5,16.5,-0.0024401785,0.0036754664,22,72,-0.0027799231,-0.007442457,57,5,544,544,12.5,7.5,5.5,1986.5,455,15.5,20.5,1017,62.5,7.5,19,18,27.5,27.5,58,13611,-0.0020378397,313,252,19.5,92.5,1300.5,256.5,487.5,25128.5,25128.5,-0.0031609782,0.0005388093,146,40,20,-0.0013643481,16,14.5,-0.0045441077,18.5,36.5,12.5,3,0.016741661,150.5,15.5,-0.01084878,4.5,-0.003071224,16,-0.006287049,-0.012210793,-0.016951634,-0.009065508,42.5,45.5,2.5,5.5,10.5,11.5,12.5,18.5,2.5,5,18,0.009838146,0.0034129003,0.01597886,-0.00066460203,15.5,-0.004265306,0.0036089781,14,19,0.00033742585,-0.0007097855,-0.00571008,-0.014773564,221,201,0.008371108,319.5,344.5,536.5,1230.5,1106.5,980.5,980.5,15.5,2059,0.0003595233,0.0058293683,-0.0020870876,-0.0005147742,0.0018819213,0.0049403864,0.0014075253,0.0005302914,0.0015722823,-0.0046826256,0.0054549845,0.0007364664,-0.006971558,0.00040782243,-0.008092211,0.0027511779,-0.016238024,-0.0074588195,0.0013063321,-0.0019943311,0.0039726105,-0.0027079417,-0.0011865394,-0.007141744,0.035463825,-0.00084391696,-0.0011462462,-0.007087942,-0.00878386,-0.030521557,0.007858726,0.00038909997,0.00027358922,-0.0030146006,0.00048445957,0.002656577,-0.0026017355,0.0016961124,0.004749175,-0.0001771853,-0.0010790573,0.005987032,0.0048922836,4.6085956e-05,-0.0016162826,-2.8939749e-05,0.019891959,0.0022733717,0.006132283,0.0020053114,-0.014263262,-0.0024493844,-0.0040335837,-0.0017799129,-0.0006748864,-0.001943523,-0.0006395594,-0.0065870592,-0.0021574711,0.0013013141,0.016580496,0.0029521498,0.0034915973,-0.0022377183,-0.0003810222,0.010998008,-0.0009787304,0.0032291932,-0.0071002417,-0.0039609117,0.0075050257,-0.0057688546,-0.0011197797,-0.002072436,-0.0074951025,-0.0031826,0.0059234225,2.4943123e-05,-0.0030878852,-0.0008865413,9.650183e-05,0.005574599,0.007502409,0.0043399264,0.0017609714,0.007159217,0.0025038708,-0.0014526494,0.0019294327,-0.0042577614,-0.0034513238,-0.0072979922,-0.0060312,-0.0008732021,-0.00053398724,0.0018323737,-0.00687152,-0.0004922066,-0.003747613,0.01776706,-0.027759314,-0.006376561,0.0007511891,0.00631172,0.007676769,0.04505234,-0.0043068905,-0.0133964885,0.00080706476,-3.704093e-05}, {6,7,6,0,8,7,2,0,3,4,0,0,8,0,2,0,255,0,6,8,0,4,255,8,2,8,6,8,0,6,3,4,4,255,8,8,0,0,8,8,7,255,255,2,8,8,8,6,0,4,8,8,8,8,8,6,6,3,2,8,2,8,255,1,0,8,0,8,8,0,255,8,6,2,6,8,8,255,255,8,255,0,0,2,8,255,255,8,0,6,8,255,255,2,6,255,255,0,8,0,0,8,8,8,6,0,8,8,2,2,8,8,8,0,1,0,0,255,0,0,8,2,0,0,0,2,2,255,255,0,6,8,255,8,8,255,8,0,8,8,255,2,8,255,8,255,8,255,255,255,255,0,6,8,8,8,8,8,8,8,8,8,255,255,255,255,8,255,255,8,8,255,255,255,255,6,6,255,4,7,1,2,1,2,2,8,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,65535,33,35,37,39,41,65535,43,45,47,49,51,53,55,57,59,61,65535,63,65,67,69,71,73,75,65535,65535,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,65535,115,117,119,121,123,125,127,65535,129,131,133,135,137,139,65535,65535,141,65535,143,145,147,149,65535,65535,151,153,155,157,65535,65535,159,161,65535,65535,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,65535,203,205,207,209,211,213,215,217,219,65535,65535,221,223,225,65535,227,229,65535,231,233,235,237,65535,239,241,65535,243,65535,245,65535,65535,65535,65535,247,249,251,253,255,257,259,261,263,265,267,65535,65535,65535,65535,269,65535,65535,271,273,65535,65535,65535,65535,275,277,65535,279,281,283,285,287,289,291,293,295,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,65535,34,36,38,40,42,65535,44,46,48,50,52,54,56,58,60,62,65535,64,66,68,70,72,74,76,65535,65535,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,65535,116,118,120,122,124,126,128,65535,130,132,134,136,138,140,65535,65535,142,65535,144,146,148,150,65535,65535,152,154,156,158,65535,65535,160,162,65535,65535,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,65535,204,206,208,210,212,214,216,218,220,65535,65535,222,224,226,65535,228,230,65535,232,234,236,238,65535,240,242,65535,244,65535,246,65535,65535,65535,65535,248,250,252,254,256,258,260,262,264,266,268,65535,65535,65535,65535,270,65535,65535,272,274,65535,65535,65535,65535,276,278,65535,280,282,284,286,288,290,292,294,296,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31866.5,1733,17611,1494,1796.5,17427.5,18879.5,788,1520.5,1794.5,3919.5,27139.5,-0.010954498,18281,32196.5,766.5,15.5,1520.5,2766.5,1736,12.5,15.5,3924.5,24247.5,31473,32309,31887,32098.5,20457.5,755.5,19.5,10743,1393.5,6156.5,18.5,15.5,16.5,18.5,2446.5,8.5,17,1987,2602.5,-0.024043499,3352,-0.011652998,15,30825.5,19265.5,31589.5,6.5,18615,17582,31781,19836.5,3.5,18049.5,588.5,1018,404.5,404.5,1393.5,7,833,1312.5,15.5,17.5,5.5,1477.5,6.5,-0.034083508,4841,6614,4.5,3736,15.5,1459.5,0.022524979,0.011792902,14,-0.0015601945,1897,3656.5,1911,2773.5,5723.5,3471.5,2.5,-0.0036569268,8425.5,1.5,12538.5,18342.5,1.5,3,18024,14434,18418,-0.010913524,17067,19204.5,30246.5,20293.5,30585,-0.00567819,18936.5,16.5,-0.010367302,20066.5,585.5,631,4886,-0.011991075,15.5,13,0.0009074467,0.036048926,1748.5,1582.5,-0.014371695,-0.003003064,776,879,1066.5,1803,1763,-0.014069143,15.5,6697.5,1758.5,1476.5,1381.5,6292.5,1.5,2566,7,8496,5357,1583.5,3736,15.5,0.0002117659,0.025147049,-0.0004275009,-0.021147411,-0.010242031,5.5,0.000996906,0.0034192342,12.5,2478.5,3810.5,4575.5,1817.5,2285.5,3235,2357.5,11692.5,7644.5,5831.5,4584,0.0018994518,4.5,10,23494.5,0.0024494892,17.5,12336.5,32324.5,19930,1.5,0.0006660503,7,0.0025710885,7,4.5,29559.5,18,30929.5,6.5,-0.0036709004,19225,18942,2.5,19950,0.0011945234,2.5,16.5,1.5,2.5,16.5,19548,18879.5,18936.5,19075,20035.5,20574.5,8.547092e-05,-0.005348156,0.009043763,0.0010579545,-0.0049723308,-0.0017786728,0.0038684853,0.013384267,-0.0022492667,-0.00042046458,0.00024054902,0.009155801,-0.0030616587,0.00012651853,-0.0025350105,0.012589939,0.003841939,-0.012756201,-0.026768615,-0.0069068857,0.005212608,-0.0017066405,-0.009893371,-0.002142267,0.0011733546,-0.0035431178,0.0010921642,0.0031256322,0.0009493503,-0.002069708,0.003502509,0.0012464192,0.0030467745,-0.0073324414,0.0016602852,-0.0022919134,-0.0047895485,-0.023731492,-0.010470096,0.0049758805,-0.00025704244,-0.017292585,-0.0010796417,-0.01361374,0.008033055,0.0016367863,-0.0052775987,-5.6422938e-05,0.011872931,0.002136643,0.0023873362,0.0062262877,0.005119111,-0.00030167142,0.0064669363,0.0020957103,-0.0043369173,0.0004405486,0.00053062825,0.004350222,-0.0013981321,0.00028267057,0.0028508347,-0.009889397,0.024691952,0.006451165,-0.0077195815,-0.00013636726,0.014758113,0.0014566287,-0.0016481599,-0.0056207306,-0.0013119068,0.00026278757,0.00032130428,0.0025749898,-0.00042027398,0.000110825225,-0.0009818793,3.4723602e-05,0.0005249557,0.0014067083,-0.005859075,-0.0009777925,0.00060240016,8.350499e-05,-0.0018303533,-0.000498134,-0.005879439,-0.0025143754,0.0008458562,-0.00025211644,-0.00018368218,-0.0017973488,-0.00041041686,0.00017611489,0.00032862127,0.0015305149,-6.809152e-05,-0.001040089,-0.0005060689,-0.0014936085,0.0010923984,9.275872e-05,-0.0007529453,2.8809105e-05,-0.0022967777,-0.0017941429,-0.0014716368,-0.0005515355,-0.008743276,-0.0018710754,0.0025950868,-0.00021565767,-0.0015950233,0.000721157,-0.00042870312,0.00025025735,-0.0007782082,-0.0012098615,0.00035503655,-0.0017635346,-0.0011103421,-0.0021459393,0.0002961013,-0.00028044402,0.0009776499,-0.0023588133,0.0011576089,0.0027573574,7.377305e-05,0.00075275794,0.00047406415,-0.00034340436,0.0022616654,0.000711322,-0.0019077935,-9.7228476e-05}, {6,7,3,7,7,3,5,6,5,7,6,4,255,7,6,7,8,7,0,7,8,8,6,0,0,2,2,6,7,6,8,0,4,4,8,8,8,8,4,8,8,5,1,255,7,255,8,0,1,2,8,5,5,0,1,8,1,7,3,0,0,4,8,5,0,8,8,8,1,8,255,0,4,8,0,8,1,255,255,8,255,6,3,4,4,6,7,8,255,0,8,1,7,8,8,5,1,1,255,5,1,2,1,0,255,3,8,255,3,6,6,0,255,8,8,255,255,6,4,255,255,5,4,7,0,1,255,8,2,1,5,6,4,8,0,8,2,0,7,0,8,255,255,255,255,255,8,255,255,8,7,2,3,1,6,7,5,0,0,0,7,255,8,8,0,255,8,3,0,1,8,255,8,255,8,8,0,8,0,8,255,1,1,8,1,255,8,8,8,8,8,1,7,3,7,5,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,65535,85,65535,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,65535,135,137,139,141,143,145,65535,65535,147,65535,149,151,153,155,157,159,161,65535,163,165,167,169,171,173,175,177,179,65535,181,183,185,187,189,65535,191,193,65535,195,197,199,201,65535,203,205,65535,65535,207,209,65535,65535,211,213,215,217,219,65535,221,223,225,227,229,231,233,235,237,239,241,243,245,247,65535,65535,65535,65535,65535,249,65535,65535,251,253,255,257,259,261,263,265,267,269,271,273,65535,275,277,279,65535,281,283,285,287,289,65535,291,65535,293,295,297,299,301,303,65535,305,307,309,311,65535,313,315,317,319,321,323,325,327,329,331,333,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,65535,86,65535,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,65535,136,138,140,142,144,146,65535,65535,148,65535,150,152,154,156,158,160,162,65535,164,166,168,170,172,174,176,178,180,65535,182,184,186,188,190,65535,192,194,65535,196,198,200,202,65535,204,206,65535,65535,208,210,65535,65535,212,214,216,218,220,65535,222,224,226,228,230,232,234,236,238,240,242,244,246,248,65535,65535,65535,65535,65535,250,65535,65535,252,254,256,258,260,262,264,266,268,270,272,274,65535,276,278,280,65535,282,284,286,288,290,65535,292,65535,294,296,298,300,302,304,65535,306,308,310,312,65535,314,316,318,320,322,324,326,328,330,332,334,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({1.5,8700,493,5011,8884.5,490,549.5,7498,7845.5,7207.5,6752.5,74,19.5,3039,269,7413,2672,12924.5,7834,6519.5,11081,6010.5,6744,65.5,21.5,0.0063709132,0.03408489,322,5513,273,1460.5,4923.5,2130.5,7511,7216.5,6005,-0.021322425,7645.5,10473.5,5432.5,9591,6430.5,8527.5,7245,8692.5,18274.5,31229,78,26.5,543,418,14,484.5,13,20174,7934,588.5,1411.5,1888,4814.5,5854,-0.0021006293,-0.014219043,0.019288452,7486.5,4270,6968,5988.5,8319.5,9023.5,-0.026117122,6098.5,-0.012161087,6029.5,9995.5,0.022192223,11988,-0.01167225,9892.5,9922.5,8635.5,-0.011688337,0.0014119012,0.011793959,26175.5,-0.0219229,0.0022658496,7183,29836.5,22,115.5,55,185.5,460.5,608.5,126.5,383,8.5,0.0065601165,724,530.5,6.5,-0.0020642085,19.5,-0.0056593097,13.5,-0.0064555737,375,10.5,867,6176,6.5,31866.5,7722.5,-0.029421566,4786.5,10305.5,6260,2474,2961.5,9943.5,9066.5,-0.0031351794,7969,-0.02118925,6451,7981.5,-0.009478705,-0.002055834,-0.009386555,9521,5645,-0.005951871,5917,6045,7068.5,6592.5,-0.04037552,-0.013281395,0.0018883959,11187,28753,0.010187517,6254.5,-0.003099353,-0.015714345,22101,29829.5,30211,29.5,35.5,164,19.5,123.5,58.5,40.5,15,352.5,126,15.5,27,43,301.5,261,567,-0.0022398073,-0.00024915076,17.5,20.5,-0.012698062,15.5,4,0.009193036,12.5,7976,30193,73,15.5,6,258.5,4289.5,459.5,2628.5,1258.5,6458,2058,5135.5,10299.5,17986.5,-0.00067694555,0.006184518,0.0012221354,0.011298545,0.0015113208,-0.010046792,0.0014574679,-0.0073469663,0.0052307937,0.009105635,-0.0064510168,0.004103606,-0.003405731,-0.009004854,0.007191842,0.0036516946,0.004561816,-0.012985082,0.0051554567,0.0144118015,0.004671409,-0.0059982357,0.010717305,0.003525043,-0.0010827684,0.0074920827,-0.009774911,-0.0057756933,-0.0051567755,-0.00031540787,0.00045529983,0.010845336,0.009878092,-0.008740054,-0.004531111,-0.010752033,0.003324364,-0.0031523262,0.0047890744,0.0102738775,0.0025386314,0.0007215497,-0.00069261156,0.001003521,-0.0019401925,-0.0010994371,-0.0010517804,0.0021742876,0.0032136452,0.00032607125,-0.0061606164,-0.018932661,0.001196776,-0.005016265,-0.012432001,-0.0051859827,-9.898416e-06,-0.0053765606,-0.00025761253,-0.0043863147,-0.014076217,-0.0063719354,0.0014665619,0.0052909404,0.0005369961,-0.008058822,-0.0032363187,-0.012734507,-0.0031852399,0.0010336464,-0.0007751048,0.0011493166,-0.011723814,-0.0022564132,0.025824472,0.061782558,-0.018998956,0.003512925,-0.008903236,-0.016567988,-0.0045631337,0.002576328,-0.0018335654,-0.0005311066,-0.00034776932,0.00048467788,-0.0002789262,-0.002912291,0.006271034,-0.0005587849,0.00054560415,0.0048658834,-0.004173581,-8.947844e-05,-0.010322652,-0.0016474351,-0.003736651,-0.014834921,-0.006213851,0.0010636181,-0.0029626165,-0.006791092,0.005049224,-0.0036551103,0.00037847896,-0.0013882554,0.004437574,-0.009855627,0.0019886813,-0.001306595,0.00059568766,-0.0034787431,0.005238177,-0.0009186316,-0.00012541267,0.00013886443,-0.0015235408,-7.490822e-05}, {8,6,2,7,7,2,3,4,4,7,0,3,8,0,5,4,5,0,5,7,6,2,4,2,8,255,255,1,0,4,1,5,1,4,5,4,255,5,2,3,6,0,5,4,3,0,3,0,5,0,1,8,5,8,0,7,0,1,0,5,1,255,255,255,2,5,2,4,7,0,255,1,255,5,6,255,6,255,0,2,7,255,255,255,2,255,255,0,4,6,1,0,2,2,1,2,4,8,255,6,3,8,255,8,255,8,255,0,8,7,0,8,6,1,255,0,0,0,1,1,0,5,255,0,255,0,0,255,255,255,5,5,255,5,3,7,7,255,255,255,0,0,255,0,255,255,4,4,0,0,6,0,8,2,0,5,8,3,0,8,7,1,1,4,4,255,255,8,8,255,8,8,255,8,0,1,6,8,8,5,0,1,5,0,2,5,2,2,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,65535,65535,51,53,55,57,59,61,63,65,67,65535,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,65535,65535,65535,117,119,121,123,125,127,65535,129,65535,131,133,65535,135,65535,137,139,141,65535,65535,65535,143,65535,65535,145,147,149,151,153,155,157,159,161,163,165,65535,167,169,171,65535,173,65535,175,65535,177,179,181,183,185,187,189,65535,191,193,195,197,199,201,203,65535,205,65535,207,209,65535,65535,65535,211,213,65535,215,217,219,221,65535,65535,65535,223,225,65535,227,65535,65535,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,259,261,263,265,65535,65535,267,269,65535,271,273,65535,275,277,279,281,283,285,287,289,291,293,295,297,299,301,303,305,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,65535,65535,52,54,56,58,60,62,64,66,68,65535,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,65535,65535,65535,118,120,122,124,126,128,65535,130,65535,132,134,65535,136,65535,138,140,142,65535,65535,65535,144,65535,65535,146,148,150,152,154,156,158,160,162,164,166,65535,168,170,172,65535,174,65535,176,65535,178,180,182,184,186,188,190,65535,192,194,196,198,200,202,204,65535,206,65535,208,210,65535,65535,65535,212,214,65535,216,218,220,222,65535,65535,65535,224,226,65535,228,65535,65535,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,264,266,65535,65535,268,270,65535,272,274,65535,276,278,280,282,284,286,288,290,292,294,296,298,300,302,304,306,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4425.5,4100.5,5313,20.5,4309.5,5310,5392.5,4089.5,2619,6490.5,5026.5,5740,-0.026918007,7843.5,5587.5,3873,16.5,566.5,3416,3955,-0.015155613,4422,8103,1634.5,16.5,7028,-0.019567758,7387.5,318.5,3979,5013.5,7.5,-0.0030760998,198,623.5,3519,3971,6.5,11.5,2.5,7.5,6219,2,934.5,6356,2.5,1769,16.5,5373,4448.5,-0.018593227,12977,18.5,3851,4507,1217,3721,-0.0048857606,-0.010841436,315.5,700.5,646,783.5,847,3079,3385.5,2415,4386,12.5,0.0034105163,19,1.5,7.5,1.5,4073.5,17.5,0.012637238,-0.015879363,6503,13,2.5,5676,8147.5,0.0053429636,5539.5,0.0034446698,17.5,4526.5,5369,15.5,0.021504857,3227.5,6153.5,17.5,2.5,7475,2192,1905,7,5,1.5,26.5,2721,14.5,5612,25.5,451,206.5,3553.5,0.050280076,-0.015346127,870.5,924,2637,2757.5,2859.5,5499,3301,4221,27767.5,3991.5,3304.5,2.5,4040,4247.5,-0.0017163577,20.5,-0.0023146686,-9.552339e-05,5232,19,4432.5,3910.5,12.5,6491.5,4724.5,6042.5,15,0.0043469234,4.5,4776,-0.0038832303,-0.018129386,5185,5062,3497.5,4602,7,12.5,0.0053685196,0.013393575,15.5,5168.5,19.5,5181.5,12.5,5641.5,12.5,18,6002,6837.5,-0.0061071976,8459.5,1.5,25163,6427.5,7760.5,2869,3828.5,-0.00024273312,0.0005152232,-0.0060146125,-0.010209101,-0.004951478,-0.00019646024,-0.00549191,-0.026247043,0.0014117889,-0.010822223,0.016739529,0.0021952495,-0.0040424503,2.7933333e-05,0.002061292,0.00029677644,0.0021034905,-0.0014835227,0.034016296,-0.011029301,-0.0051206495,-0.01256631,0.01075086,-0.004018372,-0.013433724,2.6013293e-05,0.022650264,0.004148634,-0.0029907818,0.0015127336,-0.012062785,-0.006789319,0.0011351424,0.0039468748,-0.0038424216,0.0037638254,0.0011954566,0.017570548,-0.003529568,0.00013941641,0.01712789,-0.0038252112,-0.013426676,0.0017267343,0.009360119,0.005617086,0.0023071568,-0.00066440174,0.0063970457,0.012981936,0.008687224,0.002196633,2.5469912e-05,0.00018242918,-0.0002235835,0.0043203975,0.0016880773,0.00026419145,-0.0040445547,0.0017354777,0.0030500123,-0.0011323725,-0.005764254,-0.0032109765,0.005654347,-0.0011673572,0.0014815122,0.004792291,0.010979438,0.004136871,-0.0015513729,-0.0044723875,-9.026419e-05,-0.00837637,0.0074545294,-0.0062059187,-0.0018028592,0.0023255534,0.0012288026,-0.018119557,-0.018783672,0.0060123056,-0.009372282,-0.0008863492,-0.0010625595,0.0007826915,0.003596992,3.7649876e-05,-0.005718836,0.0026195548,0.0033779894,-0.0013049793,-0.003977533,-0.00091072096,0.0072101722,0.0006301618,0.0035806675,0.0016891429,0.009307588,0.0031719457,0.0031441525,-0.0014715365,0.0014659789,0.017834617,-0.0030541944,-0.011969198,0.003621306,-0.0017380997,-0.0044096666,0.0020057322,0.0065568686,0.0016027307,0.00027874493,-0.002911581,0.00023102578,-0.00122265,0.00055339956,1.5087861e-05,-0.0015080208,-0.0070120203,0.005963766,-0.00015233592}, {2,2,2,8,4,2,2,2,1,1,7,3,255,6,2,4,8,1,1,5,255,4,7,0,8,7,255,7,4,2,4,8,255,6,1,6,3,8,8,8,8,7,8,0,5,8,0,8,2,4,255,0,8,4,0,0,5,255,255,0,2,0,1,6,3,0,4,0,8,255,8,8,8,8,3,8,255,255,0,8,8,7,4,255,6,255,8,7,2,8,255,5,4,8,8,0,7,3,8,8,8,0,6,8,4,3,0,2,4,255,255,7,0,0,4,1,4,0,4,1,7,0,8,4,2,255,8,255,255,0,8,1,1,8,0,0,0,8,255,8,2,255,255,2,2,0,6,8,8,255,255,8,3,8,7,8,0,8,8,6,0,255,0,8,2,0,1,5,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,37,65535,39,41,43,45,47,65535,49,51,53,55,57,65535,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,65535,93,95,97,99,101,103,65535,65535,105,107,109,111,113,115,117,119,121,123,65535,125,127,129,131,133,135,65535,65535,137,139,141,143,145,65535,147,65535,149,151,153,155,65535,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,65535,65535,193,195,197,199,201,203,205,207,209,211,213,215,217,219,65535,221,65535,65535,223,225,227,229,231,233,235,237,239,65535,241,243,65535,65535,245,247,249,251,253,255,65535,65535,257,259,261,263,265,267,269,271,273,275,65535,277,279,281,283,285,287,289,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,38,65535,40,42,44,46,48,65535,50,52,54,56,58,65535,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,65535,94,96,98,100,102,104,65535,65535,106,108,110,112,114,116,118,120,122,124,65535,126,128,130,132,134,136,65535,65535,138,140,142,144,146,65535,148,65535,150,152,154,156,65535,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,65535,65535,194,196,198,200,202,204,206,208,210,212,214,216,218,220,65535,222,65535,65535,224,226,228,230,232,234,236,238,240,65535,242,244,65535,65535,246,248,250,252,254,256,65535,65535,258,260,262,264,266,268,270,272,274,276,65535,278,280,282,284,286,288,290,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6.5,28200.5,5593.5,3057,30010.5,5484,5607,2109.5,3766,28329,24260.5,5754.5,5893.5,14.5,5078,2104.5,2101.5,2980.5,3823.5,23702,3.5,3233,23964,5738.5,7236,4899.5,5761,5630,5718.5,4055.5,5712.5,2166.5,2482.5,2755,7710.5,2611,7059.5,5140.5,4109,24980,1.5,27925.5,29801,2455.5,2974,-0.008192095,1.5,4425.5,-0.024307197,16.5,2743.5,5421,7180,-0.019330261,5987,7109,-0.013149299,4459,5938,3990.5,7488.5,5759.5,5783.5,1049.5,223,3.5,0.020520123,2687.5,1473,7412,7858.5,792.5,4163.5,6838.5,3071,3798,1.5,4.5,4116,3143.5,3170,26523,27506.5,17021,29748,28369.5,14916.5,4.5,2.5,1.5,1.5,31167.5,26234.5,4129,5221,3351,5467.5,18.5,17.5,5603,4023.5,6109,12.5,-0.0029395055,-0.007929121,5914.5,10510,6112.5,16,-0.013849734,5569,3531.5,7295.5,3859.5,6247,15.5,5776,5743.5,6142,323.5,1060.5,1.5,4569.5,5656.5,2231.5,1287.5,8517,1008.5,5.5,2999.5,-0.017664114,6924,5826,2815,2220.5,1.5,6342,2.5,4.5,4.5,13624.5,2.5,2.5,7274,4.5,2.5,6692.5,-0.018307416,3219,3.5,-0.005612559,2903,2.5,-0.00022473487,0.0028957173,-0.008898645,-0.0038013333,0.0014576077,0.0056590936,2,0.0020404966,-0.0030797995,-0.0011234409,0.00014123082,0.0014796271,2.5,-0.0013879383,-0.0028384964,3029,0.0001400274,0.0036618465,-0.0007861542,19560.5,31303.5,29372,24709.5,26629.5,12.5,4570.5,3761.5,5167.5,0.008615154,6092,5362.5,0.017038492,2676,2715.5,2433,3144.5,15,-0.011224929,12.5,10.5,5693.5,0.0130685,6301,8457.5,5343,0.0041988096,-0.0057079326,-0.0012341611,18.5,19,0.00063914637,0.011475894,-0.0025810194,13023,7511,8033.5,19,8,3754.5,6203.5,17.5,9054.5,5739,5455,-0.023185378,5668.5,15.5,7995,6109.5,9102.5,0.00042936546,-0.0020105802,0.037221853,0.00097204046,-0.0158094,-0.006245656,-0.001996155,0.0037595031,-0.012791636,0.0011654221,0.00065711775,0.014193385,-0.0008793287,-0.0118674,-0.0006831891,-0.0046701864,0.004498421,-0.002177854,-0.014741014,-0.00030252337,-0.0033259874,-0.00033350286,-0.0016262124,0.012892238,0.010372598,-4.6777175e-05,0.0006056904,-0.004907876,-0.008359688,-0.0015731193,-0.0007832125,0.0027175483,-0.006146202,-0.0007057991,0.00085174275,0.0032032535,0.009039326,0.003634937,0.009047438,0.0031002564,0.0010487789,-0.0012016945,0.0021751449,0.006855113,-0.0022596912,-0.00015581267,0.00016476616,-0.0013741277,-0.0052632117,-0.00090630056,0.0005957924,0.0059743314,0.002200302,-0.0038932946,-0.0013796942,0.00037475541,-0.00074850355,-0.0025531205,0.0015505034,-0.0025714533,0.0031480812,4.5689136e-05,0.000896623,8.192511e-05,0.0028380547,0.0010385605,0.00019470278,-0.0018379753,0.0014947095,0.000898519,0.0029517978,-0.0011951122,-0.00039558878,-0.0013420248,-0.0004848145,0.00020777674,-0.0030574626,-0.00022834449,-0.0007825641,0.000120247445,0.0013007732,0.010432641,0.0004826756,-0.0025867417,0.0017018855,-0.0039785006,0.00078181777,0.0026246372,0.010588794,-0.00352897,-0.00084182667,0.0016110413,0.0061738207,0.0014074179,-0.0026753682,0.00051176647,0.0008229054,-0.0038897598,-0.0019029662,-0.0065738126,-0.0032625657,-0.0008458135,-0.0053371266,-0.003465844,0.0016412201,-0.004780439,0.0050135027,-0.0020367673,-0.00546213,-0.0014127496,0.003465299,0.0010977954,-0.00035889857,4.75066e-05,0.001306287,0.004121557,0.00046543343,-0.0006172109,0.00321097,-0.002467769,-0.0036363215,4.2610995e-05,0.00016798766,0.001010749,-0.00014144043,0.0056672413,-0.00077308516,-0.0050972137,0.0044637662,-0.0004948029,-0.001540449,-0.011927112,-0.019894479,-0.005680982,0.0017109899,0.0065336362,-0.002394993,0.0171753,0.00048853416,0.005618943,-0.0023020878,0.002593703,-0.018393606,0.0007851873,0.00029867337,0.0102856,-0.00088705804,6.1983264e-05}, {8,7,2,1,5,2,2,5,3,6,4,3,7,8,0,5,7,5,3,2,8,2,0,3,5,3,3,3,4,0,0,1,1,3,2,7,4,2,3,1,8,5,4,2,0,255,8,2,255,8,6,6,1,255,0,0,255,1,0,0,4,2,0,3,4,8,255,4,7,0,2,6,2,4,1,3,8,8,3,2,0,2,4,1,0,1,0,8,8,8,8,3,2,2,2,0,2,8,8,0,1,0,8,255,255,0,0,0,8,255,6,7,4,1,6,8,2,1,1,0,3,8,3,0,3,0,4,1,8,7,255,0,6,2,5,8,0,8,8,8,4,8,8,0,8,8,2,255,7,8,255,0,8,255,255,255,255,255,255,8,255,255,255,255,255,8,255,255,0,255,255,255,6,0,6,6,2,8,3,4,3,255,3,2,255,6,2,4,0,8,255,8,8,3,255,0,0,0,255,255,255,8,8,255,255,255,0,2,2,8,8,7,2,8,4,2,0,255,0,8,7,1,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,65535,91,93,65535,95,97,99,101,65535,103,105,65535,107,109,111,113,115,117,119,121,123,65535,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,65535,65535,197,199,201,203,65535,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,65535,245,247,249,251,253,255,257,259,261,263,265,267,269,271,273,275,65535,277,279,65535,281,283,65535,65535,65535,65535,65535,65535,285,65535,65535,65535,65535,65535,287,65535,65535,289,65535,65535,65535,291,293,295,297,299,301,303,305,307,65535,309,311,65535,313,315,317,319,321,65535,323,325,327,65535,329,331,333,65535,65535,65535,335,337,65535,65535,65535,339,341,343,345,347,349,351,353,355,357,359,65535,361,363,365,367,369,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,65535,92,94,65535,96,98,100,102,65535,104,106,65535,108,110,112,114,116,118,120,122,124,65535,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,65535,65535,198,200,202,204,65535,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,65535,246,248,250,252,254,256,258,260,262,264,266,268,270,272,274,276,65535,278,280,65535,282,284,65535,65535,65535,65535,65535,65535,286,65535,65535,65535,65535,65535,288,65535,65535,290,65535,65535,65535,292,294,296,298,300,302,304,306,308,65535,310,312,65535,314,316,318,320,322,65535,324,326,328,65535,330,332,334,65535,65535,65535,336,338,65535,65535,65535,340,342,344,346,348,350,352,354,356,358,360,65535,362,364,366,368,370,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({36.5,26.5,53.5,107,137.5,29.5,37,21.5,21.5,41.5,936,123.5,25.5,7.5,46,4.5,73.5,17.5,359,29,33.5,15.5,1719.5,45.5,5.5,475.5,27,62,55,36.5,8756.5,81,22,22,-0.016923053,4.5,359,-0.009285751,0.031929128,27,24,72,1118.5,42,26.5,21,25163,-0.022388807,5.5,46,16.5,70,2186.5,46.5,20.5,0.011230275,5.5,15.5,16,3.5,19267.5,9334.5,6512.5,26.5,0.004753813,27,22,22,29.5,359,359,-0.0065735946,0.00064577366,18.5,8,14.5,78,18.5,16.5,83.5,1986.5,154,7.5,19.5,18.5,6.5,0.018341132,19.5,31940.5,76,-0.014393811,0.00025469143,-0.012478259,54.5,46,22,19.5,16.5,12.5,-0.019450856,4.5,358,176.5,1.5,517,11,60,514,21.5,109,6.5,14.5,3,8795.5,9943,9937,6566,22,2.5,22,23.5,6.5,30.5,-0.0020635333,22,62.5,-0.0019170368,0.010920208,0.004666103,6,12.5,3.5,22,6,16.5,0.007904023,0.012154235,38.5,17,15.5,22,6.5,0.009329855,6.5,12.5,0.007168115,-0.0053644967,6.5,-0.010275197,401,587,-0.0022143063,0.0027304532,-0.010475189,-0.019657759,1.5,12.5,25425,26087.5,3.5,15,-0.006222164,-0.0013233314,14,15,-0.005487908,-0.0021807894,7.5,19.5,15.5,29.5,12.5,1881.5,1.5,18.5,58,112,36.5,42.5,36.5,-0.01268764,517,0.0005244021,0.004629722,0.0013744168,60,12.5,19.5,18.5,8.5,13,57,0.0060908003,-0.0016250716,0.0034267695,-0.018909112,85.5,2941.5,2941.5,1.5,19,8747,8924,6959.5,10782,9893,12525.5,9688.5,8795,-0.0016141,0.004158831,-0.005661134,-0.0013638766,-0.00031745626,-0.006301507,-0.0021032786,0.0016531375,-0.003969558,0.0007801372,0.0072698905,9.244777e-05,0.0004865937,0.0018396294,0.0054367343,0.00019411679,0.0012737054,0.004883236,-0.00073121133,0.0016931556,0.0018051675,0.00040192582,0.00013107537,0.0035015724,0.0011705442,-1.8599947e-05,-0.0046332455,-0.00089324516,0.003941057,0.0072575784,0.0012253544,-0.008306489,-0.0012777605,-0.0042683515,0.0065413797,-0.00060466776,0.0073316963,0.0014738404,0.0032570257,-0.0012527448,-0.006747216,-0.013582783,0.004223107,0.0010628194,0.0037048627,-0.004198355,-0.005210502,-0.00030229308,0.0017430958,-0.00044653701,0.004457994,0.0015348764,0.00047834963,0.0029137018,-0.0013718465,-0.0035794433,-0.0013566101,-0.0049792356,0.0021330102,-0.0028717094,-0.0035337526,-0.00015209167,3.7541377e-05,-0.002400131,-0.0015402421,0.0023493571,-0.0023455427,0.0033104566,0.0026205976,0.008005629,0.0028623508,-0.0015462933,-0.0023213378,0.0047646905,0.0015486634,-0.0083892085,0.00016982167,0.0037685612,-0.00037586587,0.0023619325,-0.001170071,-0.0057947114,-0.009729105,-0.0055830344,-0.00040387927,0.0037319642,-0.00013423372,-0.0025717826,-0.003306187,0.0011197163,-0.00025732396,0.0030745338,-0.0065097767,-0.0026357921,0.0014171087,-0.002729902,-8.353831e-06,-0.0021122163,0.0004993558,0.0036822073,0.0015171526,0.0062356284,0.0034364932,0.0008662167,-0.00064554735,0.0012762198,-0.009252683,-0.0028335012,0.0045314482,0.0004154384,-0.0034640853,-0.0016838954,-0.0001308359,0.00091448164,-0.00377457,-0.0075787245,6.857166e-05,0.007467702,-0.0070399367,-0.001307724,0.0066146227,0.0011112134,-0.0016737723,0.0012313557,-0.0013291186,-0.0073113064,0.000492959,-0.0010988895,0.010204085,0.0004553216,-0.0046060993,-2.6315256e-05}, {4,6,0,2,0,5,2,8,8,6,0,2,1,8,2,8,0,8,0,0,2,8,0,6,8,2,1,0,6,1,6,2,6,2,255,8,0,255,255,5,1,6,6,2,4,8,2,255,8,0,8,4,3,6,8,255,8,8,8,8,0,2,7,0,255,2,0,6,0,0,0,255,255,8,8,8,0,8,8,6,6,0,8,8,8,8,255,8,3,4,255,255,255,4,0,0,8,8,8,255,8,2,2,8,0,8,0,0,8,0,8,8,8,2,2,6,7,2,8,4,0,8,0,255,0,2,255,255,255,8,8,8,0,8,8,255,255,6,8,8,0,8,255,8,8,255,255,8,255,0,0,255,255,255,255,8,8,0,0,8,8,255,255,8,8,255,255,8,8,8,2,8,6,8,8,3,4,1,0,0,255,0,255,255,255,0,8,8,8,8,8,0,255,255,255,255,0,0,0,8,8,2,2,1,2,6,4,2,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,65535,69,71,65535,65535,73,75,77,79,81,83,85,87,65535,89,91,93,95,97,99,101,65535,103,105,107,109,111,113,115,117,65535,119,121,123,125,127,129,65535,65535,131,133,135,137,139,141,143,145,147,149,151,153,155,65535,157,159,161,65535,65535,65535,163,165,167,169,171,173,65535,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,65535,221,223,65535,65535,65535,225,227,229,231,233,235,65535,65535,237,239,241,243,245,65535,247,249,65535,65535,251,65535,253,255,65535,65535,65535,65535,257,259,261,263,265,267,65535,65535,269,271,65535,65535,273,275,277,279,281,283,285,287,289,291,293,295,297,65535,299,65535,65535,65535,301,303,305,307,309,311,313,65535,65535,65535,65535,315,317,319,321,323,325,327,329,331,333,335,337,339,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,65535,70,72,65535,65535,74,76,78,80,82,84,86,88,65535,90,92,94,96,98,100,102,65535,104,106,108,110,112,114,116,118,65535,120,122,124,126,128,130,65535,65535,132,134,136,138,140,142,144,146,148,150,152,154,156,65535,158,160,162,65535,65535,65535,164,166,168,170,172,174,65535,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,65535,222,224,65535,65535,65535,226,228,230,232,234,236,65535,65535,238,240,242,244,246,65535,248,250,65535,65535,252,65535,254,256,65535,65535,65535,65535,258,260,262,264,266,268,65535,65535,270,272,65535,65535,274,276,278,280,282,284,286,288,290,292,294,296,298,65535,300,65535,65535,65535,302,304,306,308,310,312,314,65535,65535,65535,65535,316,318,320,322,324,326,328,330,332,334,336,338,340,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({78,35.5,28.5,31.5,22.5,113.5,202.5,22,63.5,46,41,6.5,20.5,87.5,198,47,22,1.5,-0.016516956,-0.019337213,4.5,25.5,50,45,52,132.5,49.5,122.5,2.5,311.5,373,22,2.5,20.5,1.5,55,29.5,1.5,58,12.5,26.5,6.5,68.5,3.5,2.5,20.5,15.5,12.5,1247.5,12905.5,116.5,8.5,70,329.5,198,12.5,-0.009801325,294.5,404.5,15.5,28.5,0.0075525492,7.5,26,26,0.0067815627,15.5,-0.0080467975,0.0010330705,22,3.5,0.00052409427,-0.009161928,12.5,8.5,47.5,63.5,3.5,36,55.5,51.5,14.5,16.5,37,-0.030740723,-0.0012981283,-0.0036369418,-0.0061859037,111.5,-0.008387059,0.008664886,37,117.5,2.5,32312,145.5,-0.004392543,48.5,3.4427692e-05,2.5,138,51,12.5,123,1.5,100.5,17.5,159.5,211.5,224.5,21.5,1167.5,893.5,6.5,22,15.5,3.5,27.5,13.5,18.5,8,0.001739613,0.010000968,36,264.5,14,19.5,24,7.5,-0.0039413027,17.5,7.5,14,6.5,2872,16.5,18.5,6359.5,406,36.5,2.5,51.5,2.5,20,15.5,4.5,67,46,50,-0.009414799,0.0023386253,-0.012816544,-0.0014686757,-0.0050381413,114,15,59.5,31,29.5,4215,16.5,-0.0107291285,-0.03219533,-0.0022038217,-0.008197913,0.008216962,154.5,12.5,0.006939586,37.5,-0.013456756,8.5,93.5,0.0021856432,-0.0058733346,126,127.5,16,15.5,6.5,0.009768555,-0.008523317,9.5,13.5,18.5,15.5,588.5,318.5,0.055124875,374.5,2408.5,745,1298.5,-0.0021998892,0.0005961189,-0.0045499355,0.002850773,0.011825689,0.005959326,0.0012504858,-0.0028006572,0.0016427375,-0.0036288293,0.0048118476,0.0009488592,0.007717792,0.0009602722,0.0028784773,-0.00031852265,-0.00080401433,-0.0033335243,0.0007430349,0.0060219523,0.001253571,0.00021379335,-0.0019835168,0.00379484,0.004688605,0.012455387,0.00093414076,0.0067388634,-4.5142784e-05,-0.0024152577,0.00028449515,-0.0006637409,0.0018970702,0.0006591365,-0.00021403562,-0.0020138281,0.0036938563,0.00062144565,-0.004016913,-0.00072935823,0.0031621677,0.00056054123,-0.0020675415,0.0035667587,-0.006983829,-0.0033898253,-0.0059417007,4.5371094e-06,0.015528529,0.0026323446,0.002597171,0.009995803,0.002575534,-0.0008203379,0.0078192605,-0.006655667,-0.002443917,-0.0042860005,0.009910381,0.006046002,0.001687395,-0.0035731152,0.0029654203,-0.00067641394,0.009208593,0.0019877108,0.0054209954,0.003242566,0.0012152172,-0.005887542,0.0029893152,0.0005026519,-0.015972873,-0.0014117288,-0.00011780573,-0.0066086585,0.002436598,0.00026645785,0.005876006,0.00024881246,-0.0033892342,0.0035358157,-0.00203437,0.0034695396,0.00080856355,-0.004085939,0.0055647925,0.003118018,-0.006055966,0.0055873864,0.0013084665,0.004785729,0.00048385328,-0.00038050063,0.012373642,0.0028638057,0.0024012642,0.004410519,0.0025731164,0.005002006,-0.0015423406,0.0001464827,-0.00048012976,-0.006940108,0.0034420055,-0.0023427892,-0.00042877215,0.0040656733,-0.01111542,-0.0018166984,-0.005666836,0.0058756256,-0.01784685,-0.0070801997,-0.0023880096,0.0005006025,-3.0875734e-05,0.00249662,-0.0017663202,1.3719166e-05}, {0,6,5,6,7,0,0,0,4,0,1,8,8,1,1,4,2,8,255,255,8,1,6,1,2,0,6,6,8,5,4,2,8,8,8,0,0,8,0,8,1,8,2,8,8,8,8,8,0,0,2,8,1,2,0,8,255,5,5,8,2,255,8,0,0,255,8,255,255,0,8,255,255,8,8,3,6,8,3,0,0,8,8,1,255,255,255,255,0,255,255,1,0,8,1,2,255,2,255,8,0,1,8,1,8,0,8,1,0,5,8,2,5,8,6,8,8,2,8,8,8,255,255,1,2,8,8,1,8,255,8,8,8,8,4,8,8,7,6,6,8,0,8,8,8,8,0,0,0,255,255,255,255,255,1,8,2,6,4,0,8,255,255,255,255,255,0,8,255,5,255,8,0,255,255,1,0,8,8,8,255,255,8,8,8,8,0,3,255,1,7,5,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,65535,65535,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,65535,109,111,113,115,65535,117,119,121,65535,123,65535,65535,125,127,65535,65535,129,131,133,135,137,139,141,143,145,147,149,65535,65535,65535,65535,151,65535,65535,153,155,157,159,161,65535,163,65535,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,65535,65535,209,211,213,215,217,219,65535,221,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,65535,65535,65535,65535,65535,259,261,263,265,267,269,271,65535,65535,65535,65535,65535,273,275,65535,277,65535,279,281,65535,65535,283,285,287,289,291,65535,65535,293,295,297,299,301,303,65535,305,307,309,311,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,65535,65535,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,65535,110,112,114,116,65535,118,120,122,65535,124,65535,65535,126,128,65535,65535,130,132,134,136,138,140,142,144,146,148,150,65535,65535,65535,65535,152,65535,65535,154,156,158,160,162,65535,164,65535,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,65535,65535,210,212,214,216,218,220,65535,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,65535,65535,65535,65535,65535,260,262,264,266,268,270,272,65535,65535,65535,65535,65535,274,276,65535,278,65535,280,282,65535,65535,284,286,288,290,292,65535,65535,294,296,298,300,302,304,65535,306,308,310,312,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4639,4629.5,4913.5,8742,1.5,4862.5,4918,5244,9756,-0.027575582,-0.0077616735,4.5,5304,1.5,2018.5,4919.5,5423,4613.5,10929,5901.5,4557,6457.5,7330.5,-0.017943183,-0.005204464,1798,4017,18.5,5003,11273,6781,4.5,11.5,2269.5,2684.5,3847,4625,5901.5,9270,27213.5,7616.5,15.5,4987.5,5095.5,4823.5,3986.5,4195.5,12.5,1014.5,2.5,8000.5,1.5,4.5,18.5,7178,9207,9207,1.5,0.011252265,4.5,4240,4.5,12108,2.5,9010.5,0.009746788,2,6348.5,18.5,-0.010575187,6.5,4049,12.5,-0.010197865,3,5254.5,4688,12.5,4671.5,18,7062.5,17.5,17,3913.5,-0.016041098,17.5,5600.5,7.5,1631,1011.5,1127,-0.0048742276,-0.01877606,3403.5,1.5,8186,7316,2.5,16.5,5596.5,3018,7053,7895,6689.5,2.5,12.5,15.5,-0.0014732622,5,2.5,10239,2.5,12.5,2.5,10278.5,3487,12.5,4726,3995,-0.0036337995,1.5,-0.0017194061,0.0053560585,20.5,18.5,7733.5,4625,0.0010649456,17.5,7367.5,23076,1.5,16.5,-0.006160327,11,7.5,13.5,16.5,5920.5,4.5,7414,0.001748695,0.013636558,725,0.014120044,4005.5,16.5,16.5,19.5,7,0.0048662573,3698.5,6767,5065.5,5583,9629.5,5626,8.109635e-05,-0.0007996,6.4892454e-05,0.0010487749,0.00024340472,0.029020965,-0.019625125,-0.0007895604,-0.0012641668,0.004383296,-0.025629198,-0.0055669434,0.0015470547,-0.003280457,0.004829223,-0.00156885,-0.0027439443,0.004049004,-0.0012719478,-0.002971595,-0.011970236,0.00087348,0.00072780024,0.01189158,-0.0011385877,0.0003036657,-0.0026181103,0.0016655565,-0.004146125,0.008426262,-0.005690589,-0.0006778299,-0.002334872,-0.011255567,-0.0040455568,-0.00018969945,0.003912182,0.00023023442,-0.0022323262,0.0015422431,-0.002540733,-0.0008137103,0.005234985,0.0022411284,-0.0053085233,0.002693403,-0.0052194963,0.0010321114,-0.0014897094,-0.004331987,0.003913074,-0.0014188093,0.00010496296,-0.0014982987,0.0014409012,0.004452432,-0.0009778845,0.00075440475,0.0008837416,-0.000913399,0.0007369079,0.0037504693,-0.0006691249,0.000998955,0.00049213966,-0.0045427964,-0.009192209,-0.0027774242,-0.0009132079,0.00065222196,-0.005999607,0.0008324124,0.00231292,0.009784536,-0.0020058076,0.0012481756,-0.0020372577,-0.004419886,-0.003129888,-0.0015421564,-0.005625146,-0.0010797274,0.0031373713,-0.0028433716,0.0036633653,0.013771272,-0.007569205,0.0027870645,0.0066611813,-0.00027024545,0.009321374,0.0015754037,0.00071813905,-0.0021276802,-0.008732724,-0.0016298257,0.0021967033,-0.002297975,0.0026032967,1.7663235e-05,0.01138906,0.0012908652,0.0054951236,0.012218933,-0.0015217809,-0.0039828173,0.0003180677,-0.003224313,0.002963669,0.012077056,0.006188669,0.017520288,0.0017545586,-0.0014838731,-0.0067859716,2.484842e-06}, {7,7,7,6,8,2,7,3,6,255,255,8,5,8,2,3,3,7,2,6,2,3,0,255,255,2,3,8,4,0,2,8,8,1,3,2,0,6,0,2,0,8,3,6,0,3,3,8,7,8,0,8,8,8,4,2,2,8,255,8,1,8,2,8,0,255,8,1,8,255,8,1,8,255,8,2,6,8,6,8,6,8,8,5,255,8,3,8,7,7,7,255,255,6,8,0,1,8,8,3,6,2,5,0,8,8,8,255,8,8,2,8,8,8,4,1,8,0,3,255,8,255,255,8,8,0,0,255,8,2,0,8,8,255,8,8,8,8,2,8,1,255,255,0,255,0,8,8,8,8,255,3,2,1,5,4,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,65535,65535,19,21,23,25,27,29,31,33,35,37,39,41,65535,65535,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,65535,109,111,113,115,117,119,65535,121,123,125,65535,127,129,131,65535,133,135,137,139,141,143,145,147,149,151,65535,153,155,157,159,161,163,65535,65535,165,167,169,171,173,175,177,179,181,183,185,187,189,191,65535,193,195,197,199,201,203,205,207,209,211,213,65535,215,65535,65535,217,219,221,223,65535,225,227,229,231,233,65535,235,237,239,241,243,245,247,65535,65535,249,65535,251,253,255,257,259,65535,261,263,265,267,269,271,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,65535,65535,20,22,24,26,28,30,32,34,36,38,40,42,65535,65535,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,65535,110,112,114,116,118,120,65535,122,124,126,65535,128,130,132,65535,134,136,138,140,142,144,146,148,150,152,65535,154,156,158,160,162,164,65535,65535,166,168,170,172,174,176,178,180,182,184,186,188,190,192,65535,194,196,198,200,202,204,206,208,210,212,214,65535,216,65535,65535,218,220,222,224,65535,226,228,230,232,234,65535,236,238,240,242,244,246,248,65535,65535,250,65535,252,254,256,258,260,65535,262,264,266,268,270,272,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({2047,1299.5,2202.5,1293,1248.5,18.5,2405,1640,15.5,18,1204,2611,3949.5,18.5,2481,765,1654.5,2.5,20.5,6.5,470.5,735,20.5,2096,6.5,886.5,2089,4.5,2540.5,2954.5,6214.5,536.5,876.5,4.5,15.5,1.5,7.5,-0.009379544,-0.017186008,1.5,3285.5,-0.0047251466,20.5,969.5,19.5,2105.5,1689,15.5,2101,2080,11.5,0.0011138784,2163,974.5,2633.5,2.5,2278.5,2292.5,2336.5,2539.5,4010.5,6357,6442.5,446.5,581.5,21.5,27,2.5,-0.01557635,1839.5,1839.5,-0.001260215,0.0008266777,4.5,10.5,2143,3.5,0.00411516,12,2083.5,0.029329961,15,641,966.5,1355.5,1078,16.5,1864,1872,2086,2055,2228,12.5,2,2.5,2026,15.5,-0.026012657,2868,0.0017723592,21.5,-0.00085731567,-0.003022919,2276,2251,12.5,15.5,2303.5,-0.015206145,0.028625665,2156,6.5,15,2854.5,15,5697,6210,7704.5,6445.5,21.5,459.5,608.5,21.5,20.5,784.5,15.5,942,0.008676569,0.0025342836,1059.5,3.5,1305.5,-0.037976775,-0.007733653,5.5,1391,-0.0052087842,0.0012577996,0.003140362,-0.00032730942,1131.5,0.002237668,15.5,0.0029056682,0.019213129,-0.0044215554,-0.011419705,12.5,15.5,14.5,3.5,1218,2558,12.5,15.5,272,536,1285,530,-0.021726906,2730.5,5.5,0.0069282087,16.5,1569,2195,4775,1758,3152.5,-0.00038112592,-0.0037400366,0.002849613,2116,0.003618411,0.008996379,12.5,2026,-0.0051902817,-0.015244943,20.5,-0.00079865113,1088,2978.5,1874.5,2143.5,7.5,15.5,6.5,4486,2441,1705.5,2.9080697e-05,0.0062145516,2.5,12.5,7.5,-0.02473163,13,15.5,2700.5,18,4945,6360,9356,-0.014436762,6105.5,6752,-0.029084105,6585.5,0.0003606633,-0.0021117895,0.0055317003,-0.0035001975,-0.0059783147,-0.00034036234,0.00041121733,-0.0056288666,0.0048295422,-0.005725348,-0.010027513,0.023131011,-0.0027062718,-0.025289262,-0.00030744527,0.0015987844,-0.008130773,0.00031630832,-0.00070080574,0.03570184,0.0059607006,-0.0025129986,-0.0019104006,-0.004580085,-0.0023641044,0.0032545184,-0.0002458362,0.0010935332,0.00042862623,-0.00038165817,0.0014106316,-0.0009559823,0.0049022036,0.0010090944,-2.615501e-05,-0.007118825,-0.0021594437,-0.0070487633,-0.004649187,0.004573411,-0.022677219,-0.006777033,-0.0022149305,0.0046729757,0.007829017,0.0011002282,0.005705928,0.00051737454,-0.01991642,0.00045440844,-0.0013191565,0.022607384,-0.008716003,0.032671567,-0.0012614819,-0.009498986,-0.0026166842,0.0013531143,-0.00067919755,-0.0017664995,-0.002444592,-0.007102214,-0.007558595,-0.019222364,-0.0012156729,-0.004620861,-0.0055756657,0.0037155778,0.0030894463,-0.0019560556,-0.00080244493,9.169509e-06,0.0019726215,-0.0014285285,0.0012178489,0.0051959394,-0.00048127683,0.00056836585,0.0025458427,-0.013580428,0.0009330003,0.0073747905,-0.0013214444,0.021333938,-0.003134235,0.008616419,-0.0008460452,-0.013707715,-0.0001151369,0.0065832674,-0.0008874473,0.0044697425,-0.0054403674,0.0020470195,-0.0020567093,0.0010023759,0.0074301674,0.002950575,-0.014229059,0.011370345,-0.011369789,-0.0021768196,-0.0061996733,0.0026128439,3.3926226e-05,-0.00098694,0.0095225265,0.0028671143,-0.0010520217,-0.0025253787,0.0020765893,-0.00060088676,-0.0004416244,0.0013967708,-0.0023502994,-0.010284371,0.0020659273,-0.00019106381,0.0010931621,-0.0019223305,0.012267439,0.0014374395,-0.0029932226,2.01667e-05}, {4,5,4,5,4,8,4,0,8,8,7,5,6,8,4,1,0,8,8,8,0,6,8,4,8,0,4,8,5,2,0,0,0,8,8,8,8,255,255,8,0,255,8,2,8,7,2,8,6,2,8,255,7,0,0,8,3,5,6,0,1,1,0,1,5,8,7,8,255,4,4,255,255,8,8,2,8,255,8,0,255,8,6,6,5,3,8,6,2,4,4,5,8,8,8,2,8,255,1,255,8,255,255,3,2,8,8,4,255,255,0,8,8,0,8,1,0,5,0,8,1,1,8,8,1,8,7,255,255,1,8,1,255,255,8,0,255,255,255,255,4,255,8,255,255,255,255,8,8,8,8,0,1,8,8,0,0,3,2,255,5,8,255,8,0,3,0,5,2,255,255,255,0,255,255,8,2,255,255,8,255,7,0,2,6,8,8,8,0,1,5,255,255,8,8,8,255,8,8,0,8,1,5,3,255,1,3,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,65535,65535,75,77,65535,79,81,83,85,87,89,91,93,95,65535,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,65535,129,131,65535,65535,133,135,137,139,65535,141,143,65535,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,65535,177,65535,179,65535,65535,181,183,185,187,189,65535,65535,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,65535,65535,225,227,229,65535,65535,231,233,65535,65535,65535,65535,235,65535,237,65535,65535,65535,65535,239,241,243,245,247,249,251,253,255,257,259,261,65535,263,265,65535,267,269,271,273,275,277,65535,65535,65535,279,65535,65535,281,283,65535,65535,285,65535,287,289,291,293,295,297,299,301,303,305,65535,65535,307,309,311,65535,313,315,317,319,321,323,325,65535,327,329,65535,331,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,65535,65535,76,78,65535,80,82,84,86,88,90,92,94,96,65535,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,65535,130,132,65535,65535,134,136,138,140,65535,142,144,65535,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,65535,178,65535,180,65535,65535,182,184,186,188,190,65535,65535,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,65535,65535,226,228,230,65535,65535,232,234,65535,65535,65535,65535,236,65535,238,65535,65535,65535,65535,240,242,244,246,248,250,252,254,256,258,260,262,65535,264,266,65535,268,270,272,274,276,278,65535,65535,65535,280,65535,65535,282,284,65535,65535,286,65535,288,290,292,294,296,298,300,302,304,306,65535,65535,308,310,312,65535,314,316,318,320,322,324,326,65535,328,330,65535,332,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({11425.5,7774.5,11868,6838.5,7163,11858.5,15492,6694.5,6840.5,16.5,7903.5,2794,21853,28068,14646.5,6673.5,9792,9,5544,12.5,3509,1.5,11232.5,29302,16.5,0.016065722,5.5,29107.5,28319,25163,17807.5,12.5,10130,5539,7037.5,0.022013955,13.5,3466,7058.5,7294.5,15.5,7093,7040,7963.5,7873,10549.5,11281.5,1.5,3,12942.5,9824,0.0025057436,10,11167.5,15.5,27762,21567.5,13238.5,13454.5,16149.5,16609,7.5,7608.5,0.011514248,13561,3395.5,8971,16.5,-0.0118115675,0.012155301,0.007708672,7440.5,6888.5,7335.5,7067.5,5611,4.5,6938,7930,17.5,19,18.5,7893.5,7789,7824,7795,7801,9095,8233,12,14341.5,1981.5,25989.5,1.5,-0.004117778,9816.5,10137,7748,9829,0.00024617635,0.0008658119,13664.5,14809,26047,26047,12,-0.017628195,-0.011512057,14334.5,12279.5,20565,27691,26972.5,15640,19259,22068,12174.5,6765,48.5,11479,16.5,4.5,14.5,8.5,0.0064178556,7107.5,6.5,5830.5,6713,17.5,2976.5,9038,7305.5,7417.5,6921.5,8287,7507,6908.5,3.5,4825,7.5,14.5,7142.5,7055.5,6930.5,0.0025360312,6838.5,-0.0005140963,20.5,0.0050338237,0.013790796,17.5,18.5,0.006905136,0.0020018748,-0.014068424,-0.028549591,-0.017062856,6599.5,-0.008208322,-0.01966164,9994.5,9972.5,10301,1.5,0.016455596,0.009736428,14324.5,16972.5,0.0028006963,0.00075123645,2176,27038,-0.00015676771,-0.00094706164,9003,7906,11861,14569.5,0.00799945,8963.5,17.5,10672,13192.5,10931,13810,21524,29408.5,2.5,23182,27551.5,0.002943849,0.0010869027,24745,13882.5,1.5,15194,16988.5,15244.5,17867,27741.5,25881.5,16009,0.007913455,17218.5,1.5,20400,17065,20527.5,29621,23088.5,-2.3179286e-05,-0.0026349423,0.0014452477,-0.00082400517,0.0002213742,-0.001367046,0.0013565446,0.009150306,0.011945227,0.0047898623,0.0001515479,0.0028158247,0.00013406701,-0.0017338529,-0.007906928,-0.019199211,0.0002459164,-0.008971253,-0.0022312105,0.0017751431,0.010470853,-0.0031447436,-0.0040016025,-0.012292582,0.0021247917,-0.0013432878,0.0012415712,0.012708857,0.0119438665,0.0020538603,0.001024179,-0.0027419773,-0.0062536946,-0.016790466,-0.0033177657,-0.016646722,0.011074313,0.00076820544,0.0024835784,-0.00047232333,0.005350558,0.0033202244,0.0039912197,0.0018284731,-0.00052253366,0.0014825307,-0.0016625453,-0.0036738538,-0.00097089226,0.0011592924,0.002237604,0.007267742,-0.0027444018,0.00019978998,0.00018581229,-0.0014331087,0.003948079,0.0012935929,0.009511753,0.0049618813,0.0012609629,0.0029517391,0.0043573002,-0.0034026776,-0.0031760093,0.01988594,0.00052942516,-0.0024688721,-0.0056976182,-0.00068626483,0.011660954,-0.0146301715,0.001034341,0.014736272,-0.0006909906,0.0025116296,-0.0012000323,-0.0024849998,0.00387358,-0.0016654752,0.0008129612,-0.00030408392,-0.0028011673,-0.00912474,0.0049268343,0.0017847455,0.0035265815,-0.0007682883,0.0044581094,0.001640967,0.0030564582,0.001080655,-0.008087794,0.0004219186,-4.629337e-05,0.003178658,0.0047491826,0.007641857,-0.006063824,-0.0011559611,0.0022211117,-0.0011669409,0.005983493,0.010645542,0.0016074987,0.0038601488,0.0019835446,0.004747905,0.0004822774,0.00012967523,0.0022863378,-0.0013724763,-0.009671508,-0.0028584348,-0.008354584,0.0024054248,0.0055100797,0.011079611,-0.0022712906,-0.006957851,-0.0029013027,0.0042426395,-0.0011146078,0.0014812968,-0.007090594,-0.0017818628,-0.0028608462,-0.0007993185,0.0015513689,0.0052589094,-0.005476352,0.00044696048,0.0045876475,-0.0053852587,0.0044036503,-0.00030132604,0.008675194,0.000456602,0.00021374213,0.006260107,0.014921925,0.0010867513,-0.0012113947,4.251229e-05}, {1,1,3,5,0,3,3,5,5,8,1,6,0,2,5,5,2,8,7,8,4,8,0,0,8,255,8,4,2,2,6,8,0,3,1,255,8,7,2,2,8,0,4,0,1,0,0,8,8,6,0,255,8,0,8,0,4,5,5,2,1,8,1,255,0,0,2,8,255,255,255,5,1,1,4,6,8,6,2,8,8,8,2,0,1,1,0,1,3,8,4,2,0,8,255,2,3,4,3,255,255,1,2,2,2,8,255,255,3,4,6,4,2,3,2,2,7,1,2,4,8,8,8,8,255,2,8,7,5,8,0,5,1,4,4,7,4,0,8,4,8,8,0,0,0,255,0,255,8,255,255,8,8,255,255,255,255,255,5,255,255,0,0,1,8,255,255,4,7,255,255,7,0,255,255,2,7,7,4,255,2,8,5,3,0,3,4,4,8,2,0,255,255,6,1,8,1,1,1,4,0,0,3,255,7,8,2,5,5,0,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,65535,51,53,55,57,59,61,63,65,67,65535,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,65535,99,101,103,105,107,109,111,113,115,117,119,65535,121,123,125,127,65535,65535,65535,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,65535,175,177,179,181,65535,65535,183,185,187,189,191,65535,65535,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,65535,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,259,261,263,65535,265,65535,267,65535,65535,269,271,65535,65535,65535,65535,65535,273,65535,65535,275,277,279,281,65535,65535,283,285,65535,65535,287,289,65535,65535,291,293,295,297,65535,299,301,303,305,307,309,311,313,315,317,319,65535,65535,321,323,325,327,329,331,333,335,337,339,65535,341,343,345,347,349,351,353,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,65535,52,54,56,58,60,62,64,66,68,65535,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,65535,100,102,104,106,108,110,112,114,116,118,120,65535,122,124,126,128,65535,65535,65535,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,65535,176,178,180,182,65535,65535,184,186,188,190,192,65535,65535,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,65535,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,262,264,65535,266,65535,268,65535,65535,270,272,65535,65535,65535,65535,65535,274,65535,65535,276,278,280,282,65535,65535,284,286,65535,65535,288,290,65535,65535,292,294,296,298,65535,300,302,304,306,308,310,312,314,316,318,320,65535,65535,322,324,326,328,330,332,334,336,338,340,65535,342,344,346,348,350,352,354,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({881,773,1131,638.5,18.5,941,1212.5,566.5,599.5,961,961,18.5,1849,20.5,1463.5,546.5,18.5,419,15823,277.5,17.5,549.5,1246.5,6.5,681.5,1122,1441,2878.5,969,5117.5,2436.5,529,6676.5,2.5,571,728,6.5,724,-0.00923958,7.5,549.5,6.5,784.5,302,20.5,0.029949987,21.5,1096.5,15.5,0.0052109263,31,2.5,20.5,15.5,1028,1107,13,1349.5,1172.5,1165,-0.01765279,2403.5,2633,22,18,15.5,18.5,571,5.5,0.002127742,0.03579512,15.5,15.5,420.5,516.5,15.5,626,863.5,15.5,12,17.5,1.5,754,-0.001615631,-0.012362174,21,20.5,667,667,0.013084459,0.0064935656,932.5,2.5,719.5,1044,-0.00053028157,3107,1294,4.5,18.5,-0.015768377,7,-0.031762052,593.5,16.5,1164,1249,2.5,0.014227869,0.03191039,0.013823708,1231,3985,2.5,3299,2042.5,18.5,1713.5,2684,22,36.5,536,0.034853008,587,622.5,2.5,547.5,0.005686322,-0.017041883,0.005118426,15.5,7.5,-0.006604943,0.011509824,-0.0014898594,4.5,680.5,11.5,14.5,965.5,19.5,7,1.5,0.00034777765,0.0050263954,863.5,863.5,0.0053375396,17.5,3.5,-0.0014896046,0.00037927285,849.5,8.5,13.5,0.0102527095,0.0011297774,0.0071885586,0.022038393,-0.0023853525,-0.025027717,-0.010157913,0.0078887185,889,1.5,0.0028419367,810.5,461.5,1235,31,3316,-0.02769119,-0.009788766,1278.5,1769.5,2390,12.5,4,1706,-0.013961846,-0.0017652598,13,1183,3439.5,3439.5,15.5,1122,16.5,18.5,0.017487364,5.5,1125.5,-0.00039686906,0.006746194,-0.0019755503,1582.5,15.5,987.5,17.5,21116,1766,4.5,2416.5,15.5,5790,6968.5,2689.5,-0.0014451644,0.0003750674,0.0018161593,3.540501e-05,0.0027045964,-0.002248369,-0.0045527746,-0.000815159,-0.016858926,-0.008544075,0.0023766689,-0.00012626684,0.0015111609,-0.0058339774,-0.0015588041,0.0032617548,-0.00091000414,0.0014999962,-0.010317656,-0.0029694356,0.0014576808,-0.0016911047,-0.016722847,-0.0105260955,-0.0033964843,-0.008985473,-0.0023814107,0.0007982947,-0.0068290937,0.00016272231,0.000363339,0.0028855277,0.00392452,0.00036433764,-0.00073399174,-0.003478773,0.0002782902,0.002835275,0.00256275,0.0048446646,0.0025037692,0.008521341,-0.0018258188,-0.004053491,0.0010580558,0.00029941773,-0.0013727184,-0.000356717,-0.0036319443,-0.008122583,-0.0057110903,-0.00067556807,-0.01624499,-0.0050785313,0.001612354,0.0056218836,-0.0051458953,0.0059948447,-0.004144225,-0.008319585,-0.0022250784,-0.0004371906,0.008801095,0.0016336903,-0.014451868,-0.002259685,0.013052888,-0.0030180244,-0.002456092,0.0026685954,0.0013517173,-0.006560398,-0.006277421,0.010328888,0.0039298595,-0.0007208678,-0.0130463345,-0.0016024386,0.020043535,-0.0074597,-0.040620346,-0.008746064,-0.004269607,-0.011770094,-0.0014762649,0.0006663908,0.0055338214,-0.005352688,-0.0009662588,0.007635752,-0.004346779,0.0027403652,-0.0049512326,-0.01412593,-0.0018042009,0.024088841,-0.0041451524,-0.012328562,-0.0053560054,-0.00028018322,0.00078463845,0.009875993,0.0015019195,-0.005485596,-0.004018049,6.2712126e-05,0.0075792046,0.0017031953,0.028962085,0.0036615867,-0.0033745833,-0.026299754,-0.0026951833,0.0016783417,0.0034976795,0.00033088855,-0.0074298917,-1.6423166e-05}, {0,1,1,0,8,6,1,1,7,2,2,8,4,8,1,0,8,6,6,4,8,2,2,8,1,1,6,0,7,5,0,1,6,8,0,0,8,0,255,8,2,8,0,2,8,255,8,0,8,255,6,8,8,8,1,2,8,0,1,3,255,0,0,4,8,8,8,0,8,255,255,8,8,7,3,8,2,0,8,8,8,8,0,255,255,8,8,0,0,255,255,0,8,6,0,255,0,0,8,8,255,8,255,1,8,1,0,8,255,255,255,0,2,8,5,0,8,1,0,2,4,0,255,0,6,8,1,255,255,255,8,8,255,255,255,8,0,8,8,2,8,8,8,255,255,0,0,255,8,8,255,255,1,8,8,255,255,255,255,255,255,255,255,1,8,255,1,4,2,6,0,255,255,7,4,6,8,8,0,255,255,8,5,2,2,8,0,8,8,255,8,4,255,255,255,0,8,6,8,2,6,8,0,8,6,7,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,65535,77,79,81,83,85,87,65535,89,91,93,65535,95,97,99,101,103,105,107,109,111,113,65535,115,117,119,121,123,125,127,129,65535,65535,131,133,135,137,139,141,143,145,147,149,151,153,65535,65535,155,157,159,161,65535,65535,163,165,167,169,65535,171,173,175,177,65535,179,65535,181,183,185,187,189,65535,65535,65535,191,193,195,197,199,201,203,205,207,209,211,65535,213,215,217,219,65535,65535,65535,221,223,65535,65535,65535,225,227,229,231,233,235,237,239,65535,65535,241,243,65535,245,247,65535,65535,249,251,253,65535,65535,65535,65535,65535,65535,65535,65535,255,257,65535,259,261,263,265,267,65535,65535,269,271,273,275,277,279,65535,65535,281,283,285,287,289,291,293,295,65535,297,299,65535,65535,65535,301,303,305,307,309,311,313,315,317,319,321,323,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,65535,78,80,82,84,86,88,65535,90,92,94,65535,96,98,100,102,104,106,108,110,112,114,65535,116,118,120,122,124,126,128,130,65535,65535,132,134,136,138,140,142,144,146,148,150,152,154,65535,65535,156,158,160,162,65535,65535,164,166,168,170,65535,172,174,176,178,65535,180,65535,182,184,186,188,190,65535,65535,65535,192,194,196,198,200,202,204,206,208,210,212,65535,214,216,218,220,65535,65535,65535,222,224,65535,65535,65535,226,228,230,232,234,236,238,240,65535,65535,242,244,65535,246,248,65535,65535,250,252,254,65535,65535,65535,65535,65535,65535,65535,65535,256,258,65535,260,262,264,266,268,65535,65535,270,272,274,276,278,280,65535,65535,282,284,286,288,290,292,294,296,65535,298,300,65535,65535,65535,302,304,306,308,310,312,314,316,318,320,322,324,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({2285.5,2253,1341.5,2177.5,18.5,2104,1347.5,43.5,3944,14.5,0.028599603,16.5,1268.5,4,1891,131,1819.5,12.5,4268,2055,4654.5,6.5,17.5,12.5,4.5,0.018105697,8.5,2673,1940,64.5,317,1770,2281,4642,3592.5,-0.022465585,15.5,6.5,6.5,-0.0023958073,0.0004033731,1755.5,12.5,1869.5,1135,6.5,17.5,1327.5,12.5,6.5,19,18.5,2760,17,1557.5,22.5,68.5,47,25163,1745,1883,2268.5,2173,8.5,10995,8133,-0.005955956,5249.5,-0.013916271,2.5,13.5,1.5,12.5,2.5,-0.012738201,8.5,1588.5,-0.016211687,-0.0032071664,-0.009882754,4967,2780.5,0.0073006093,15.5,20.5,2.5,5989,5300.5,5300.5,-0.0055402056,-2.1953267e-05,16.5,0.010161921,2413.5,788.5,18028,3832,12.5,1766.5,3842,4055.5,47,12.5,46,4.5,145,18.5,18.5,31940.5,64,13.5,6.5,18.5,17.5,16.5,2125.5,2309,3,-0.009251702,5295.5,4.5,15.5,17.5,-0.0001596746,-0.0037001588,0.0013595776,-0.0032380894,5777,0.00085194776,0.0014952836,5,0.006215689,-0.0011193029,1.5,4.5,1135,1588.5,0.00053278595,-0.005886326,0.0009028986,0.00023025747,2,5,544.5,5266.5,5266.5,5266.5,-9.3237104e-05,0.00061948947,3,0.007529996,-0.004576278,6.5,15.5,15.5,13.5,-0.0041760146,12.5,6.5,20.5,2546,1879.5,-0.008622679,57,724.5,6.5,15,-0.0034224258,0.015447765,6099.5,6,2677.5,5908.5,-0.00063249335,-0.006037584,6.471067e-05,0.001767801,-0.010280247,-0.0027201544,-0.0019630038,0.00095677434,-0.0063221096,-0.00096342136,-0.0073941434,-0.02186237,0.0032644526,-0.0016495284,-0.0050958036,-0.00027070075,0.003420875,0.00072720414,-0.0017837664,-0.016805705,0.012546891,-0.00018403713,0.0061540916,0.023402195,-0.0022276873,0.0028638302,-0.0037984964,-0.018567666,0.00012361942,-0.0062890733,0.00016161121,0.0047954186,-0.008498595,0.0007156979,0.00360331,0.0012167129,-0.0013125725,-0.00010236843,0.002385042,0.0044669984,-0.0011656927,2.6659423e-05,-4.958169e-05,0.00024042283,-0.0005541855,0.00037687976,-0.0007787635,0.0017559363,-0.0069690025,-0.0024246587,4.8699785e-05,-0.0044216323,0.0009124391,0.005308719,-0.00078231405,-0.0037751931,0.002197259,-0.0008078231,-0.00185111,-0.00606924,-0.0032487344,0.0004673087,0.0070429826,0.0026821846,0.00070930965,-0.0013030575,0.004033943,0.0009777269,-0.0014494004,0.0016558546,0.001410927,-0.0023651058,-0.007761226,-0.0030421338,0.0027516328,0.013233589,-0.0051913965,-0.00016921441,-0.0015728859,0.0030210293,-0.019770833,-0.0017227134,0.0034484286,-0.010997329,7.413211e-05,-0.0044335998,-0.0030252908,0.00047475527,0.00046533765,-0.008658401,0.0008956815,0.005167465,-0.0018874021,0.003118608,-0.008316151,-0.0010778807,-0.01284277,-0.0054448233,-0.0016320295,0.0006815254,-0.0005531021,2.1324855e-05}, {6,6,7,6,8,2,7,5,3,8,255,8,3,8,1,2,0,8,2,2,0,8,8,8,8,255,8,6,0,6,2,0,1,0,2,255,8,8,8,255,255,0,8,4,1,8,8,1,8,8,8,8,5,8,7,7,7,3,2,0,1,5,7,8,0,0,255,0,255,8,8,8,8,8,255,8,0,255,255,255,0,0,255,8,8,8,0,0,0,255,255,8,255,7,2,6,3,8,0,1,0,4,8,0,8,2,8,8,3,4,8,8,8,8,8,7,4,8,255,0,8,8,8,255,255,255,255,0,255,255,8,255,255,8,8,1,0,255,255,255,255,8,8,1,0,0,0,255,255,8,255,255,8,8,8,8,255,8,8,8,2,1,255,0,1,8,8,255,255,2,8,2,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,65535,21,23,25,27,29,31,33,35,37,39,41,43,45,47,65535,49,51,53,55,57,59,61,63,65,65535,67,69,71,65535,65535,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,65535,123,65535,125,127,129,131,133,65535,135,137,65535,65535,65535,139,141,65535,143,145,147,149,151,153,65535,65535,155,65535,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,65535,207,209,211,213,65535,65535,65535,65535,215,65535,65535,217,65535,65535,219,221,223,225,65535,65535,65535,65535,227,229,231,233,235,237,65535,65535,239,65535,65535,241,243,245,247,65535,249,251,253,255,257,65535,259,261,263,265,65535,65535,267,269,271,273,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,65535,22,24,26,28,30,32,34,36,38,40,42,44,46,48,65535,50,52,54,56,58,60,62,64,66,65535,68,70,72,65535,65535,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,65535,124,65535,126,128,130,132,134,65535,136,138,65535,65535,65535,140,142,65535,144,146,148,150,152,154,65535,65535,156,65535,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,65535,208,210,212,214,65535,65535,65535,65535,216,65535,65535,218,65535,65535,220,222,224,226,65535,65535,65535,65535,228,230,232,234,236,238,65535,65535,240,65535,65535,242,244,246,248,65535,250,252,254,256,258,65535,260,262,264,266,65535,65535,268,270,272,274,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31867.5,27990,18721.5,27934,27804,18795,2.5,28677,13815,16760,17181,27957.5,19335,21807.5,31974.5,29206.5,30341,-0.015319926,18230.5,25614,21628.5,29190,17489.5,-0.011823514,18682,30566,18848.5,19181,22614.5,18618,20210,25493,29320,23672.5,-0.010967187,26029.5,1.5,25904,20138.5,11942.5,29887,27773.5,11180,12.5,31201.5,31874,-0.008967182,-0.0011682239,18801,19267,19503,29842.5,1.5,-0.004373671,1.5,18917.5,31824.5,19762,18267,27208,4769,29247,1.5,18311.5,24864,-0.0027545483,6.5,-0.001546651,15,9211,14993.5,24714.5,0.0033893497,28250,17663,28900.5,15,3.5,28599,6.5,20454.5,29243.5,15.5,30526,29504,-0.006362242,18746,31768,3.5,13985.5,1.5,7,2.5,-0.0028844757,19599.5,20525,19211,27959.5,30214,-0.009822311,19351,19114.5,6.5,18541.5,19828,-0.00913237,24134.5,15.5,28778.5,6.5,28984,3,15.5,25997.5,15.5,16176,19012.5,24534,21179,-0.002436656,-0.0066858004,28634,28634,0.0076504494,24541.5,0.003581525,7.5,6.5,27205.5,16,7,0.015634457,16.5,26594.5,29373.5,28895,29170,-0.003761335,16.5,-0.010174735,-0.0152612645,4.5,12.5,17872.5,15.5,1.5,3.5,0.0026915784,24765,25148,31369.5,29078,2.5,18109.5,17012,15,5.5,0.004951198,7,4,6.5,0.0021856667,20912,4.5,17.5,0.00047947312,16,19638,18860,19767.5,20500.5,18879.5,18049.5,24104.5,29832.5,25578,31665.5,7.5,20197,19431.5,19911.5,4.5,15.5,18442.5,19075,19974,21110,31906.5,30971.5,-0.00012531132,0.00017781042,0.0019248236,0.01020463,0.0062957737,0.011567172,-0.0009785005,0.0027855705,-0.0031299118,0.0036791514,0.010699392,0.003445979,-0.0023606203,-0.0076868595,0.0036611904,-0.000103948165,0.0045894473,0.013545192,-0.004020478,0.0035567468,0.004653547,0.00052446994,0.00078707794,-0.0016980062,0.00014738382,0.002097159,0.00022521695,-0.002641984,0.0026429526,-0.0010730386,0.009904175,0.005454504,-0.001235485,-0.0028133306,-4.9647882e-05,-0.0013985054,0.003315321,0.00058970775,-0.0007149818,-0.0030087677,0.009739872,0.0036243394,0.0007997371,0.00018593667,-0.0018891677,0.001057939,0.005311668,0.0017836234,0.0012339279,-0.00027743817,0.0026833017,0.00044352948,0.0016600244,0.008248403,-0.00051511126,0.0019499892,-0.0019109583,-0.004170156,0.008151937,0.0014011468,0.0020565214,0.0074582696,-6.032892e-05,0.0026136376,0.0022999744,-0.00039818088,0.0046121604,0.0008968948,-0.00062078016,0.0007084186,1.6083422e-05,-0.0015683344,-0.0006498619,6.7403846e-05,-0.0012270933,-0.0028740817,-0.0013758274,-0.00016799915,-2.963916e-05,0.0002640411,0.0001540978,0.00061852275,0.0006171779,0.0020484575,-0.00076499215,-0.0034752896,-0.0018038113,-0.00117651,0.0008044378,0.00019128043,0.0005176835,-0.0006466619,0.0005233988,0.00021078557,-0.0014325677,-0.0002128084,0.00030590172,-0.0015744846,0.0015797804,0.0042721755,0.0044441833,0.0031871148,0.0010134247,0.0025139113,-0.00084730453,0.0008251481,-0.005744988,0.0024333817,0.00032591828,0.00082414347,-0.001416685,-0.00021869176,-0.00024288392,-0.0017959186,0.0006501865,-2.7685953e-06,-0.0022278517,-0.0013938448,-0.0009804693,-0.00025397405,5.1870866e-05,-0.0007214999,0.0017520413,0.00042108048,-0.00033319165,-5.0630624e-05,-0.0014736011,-0.000572348,0.00048175384,-0.0005375105,0.0011564795,-0.00016630584,0.0028584094,0.0019104903,0.00042959402,-0.004800851,-0.005228433,-0.00029557475,0.00031623399,-0.0023749743}, {0,4,5,4,6,1,8,0,3,1,5,4,1,1,2,2,2,255,1,0,1,6,7,255,5,4,7,3,1,3,5,4,2,6,255,0,8,6,3,7,0,0,5,8,3,0,255,255,3,3,1,2,8,255,8,5,2,7,1,2,3,2,8,1,2,255,8,255,8,3,7,2,255,0,5,4,8,8,0,8,1,4,8,4,0,255,3,4,8,2,8,8,8,255,7,1,7,1,1,255,1,3,8,7,3,255,3,8,6,8,6,8,8,0,8,1,1,4,7,255,255,0,0,255,6,255,8,8,0,8,8,255,8,6,0,2,4,255,8,255,255,8,8,1,8,8,8,255,2,3,0,0,8,3,5,8,8,255,8,8,8,255,1,8,8,255,8,1,3,1,5,5,1,5,1,1,1,8,1,1,1,8,8,3,7,1,1,4,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,65535,35,37,39,41,43,65535,45,47,49,51,53,55,57,59,61,63,65535,65,67,69,71,73,75,77,79,81,83,85,65535,65535,87,89,91,93,95,65535,97,99,101,103,105,107,109,111,113,115,117,65535,119,65535,121,123,125,127,65535,129,131,133,135,137,139,141,143,145,147,149,151,65535,153,155,157,159,161,163,165,65535,167,169,171,173,175,65535,177,179,181,183,185,65535,187,189,191,193,195,197,199,201,203,205,207,209,211,65535,65535,213,215,65535,217,65535,219,221,223,225,227,65535,229,231,233,235,237,65535,239,65535,65535,241,243,245,247,249,251,65535,253,255,257,259,261,263,265,267,269,65535,271,273,275,65535,277,279,281,65535,283,285,287,289,291,293,295,297,299,301,303,305,307,309,311,313,315,317,319,321,323,325,327,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,65535,36,38,40,42,44,65535,46,48,50,52,54,56,58,60,62,64,65535,66,68,70,72,74,76,78,80,82,84,86,65535,65535,88,90,92,94,96,65535,98,100,102,104,106,108,110,112,114,116,118,65535,120,65535,122,124,126,128,65535,130,132,134,136,138,140,142,144,146,148,150,152,65535,154,156,158,160,162,164,166,65535,168,170,172,174,176,65535,178,180,182,184,186,65535,188,190,192,194,196,198,200,202,204,206,208,210,212,65535,65535,214,216,65535,218,65535,220,222,224,226,228,65535,230,232,234,236,238,65535,240,65535,65535,242,244,246,248,250,252,65535,254,256,258,260,262,264,266,268,270,65535,272,274,276,65535,278,280,282,65535,284,286,288,290,292,294,296,298,300,302,304,306,308,310,312,314,316,318,320,322,324,326,328,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({17.5,48.5,1059,30.5,5735.5,934.5,1069.5,81,50,5713.5,5939,589.5,905,20.5,1021,22,2,70.5,29.5,7.5,5757,5845.5,6154,547,635.5,21.5,20.5,18.5,0.029222531,1353,1043.5,22,27,22,6.5,78,-0.015307496,119,45.5,1418,1439,5.5,2.5,7480.5,5921.5,6296.5,6738,25.5,6047.5,565.5,850.5,18.5,891.5,1086.5,943.5,1066,1066,834,1491,1549,2175.5,93.5,22,29.5,1.5,0.004726368,0.012555365,39,22,30,13611,118,15.5,42,16.5,2016,1571,406,2028,5713,16.5,-0.0024852955,5726.5,5828.5,5156.5,2.5,6008,7162.5,6331,7445.5,7258,93.5,542.5,568.5,0.0015692207,547.5,19,669.5,797.5,-0.0065118037,737.5,0.0068523423,-0.017096547,18.5,1199.5,0.008511566,978,0.0010180225,0.010413093,0.014686379,0.006051609,18.5,-0.023014156,18.5,2657.5,-0.00023093676,-0.031251017,19.5,1860,22,2,0.010800288,4,14.5,13,213,49,0.003101108,4.5,0.0024747436,15,49,14.5,154,27038,2.5,1367,142.5,-0.0026254978,2906,14.5,321.5,0.0076286993,1769.5,10025,1870.5,1714.5,53,407.5,12.5,2133.5,5251.5,-0.0071472884,5008,0.0032019217,6554,-0.015451595,5902.5,7354.5,13,7.5,-0.004758069,-0.01293837,0.01393793,6066,7183.5,7452.5,0.01117582,6502.5,7382,6257.5,8070.5,7263,29.5,111.5,448.5,19.5,-0.016163232,580,670,-0.0032420177,618.5,0.035136323,688.5,18.5,18.5,1202.5,-0.01111785,-0.03200173,891.5,-0.02176517,18.5,1285,-0.0022129698,-0.0090805935,665.5,1882,-0.0009978381,0.015186222,18.5,2178,1124.5,1095.5,18.5,3939,-0.0006734708,0.0004879635,-0.0005929794,-0.0040073027,0.0032595836,-0.0009512172,-0.0069556586,-0.0015616327,0.0010780657,-0.00858726,-0.0082671,1.0682075e-05,-0.00041997872,0.0017723948,-0.0012934607,0.0010042496,0.0060499473,0.00089122326,0.0007235193,0.0047342945,0.0043574795,0.0076021045,-0.0019447145,-0.008369841,0.002686217,-0.00039946195,-0.0012373135,-0.007519781,-0.002595732,0.001266749,0.0053191166,0.0011091781,0.0029786925,0.00032381,-0.0013364807,0.00026530784,0.0026284454,0.00079580065,-0.00042181072,0.004438464,-0.0022673497,-0.014522885,0.0022719929,0.011960151,-0.0049786135,0.00043140422,-0.005036711,-0.00031309857,0.014827847,0.0010274017,-0.0050192284,-0.00020522461,0.0020004069,-0.0006433138,-0.0011836176,0.00066404464,0.0014460008,-0.0026965009,-0.0038874205,-0.011522795,0.0033676226,-0.0002815276,0.007268657,0.01873236,-0.0036906202,0.00119845,0.0014130948,-0.0011406753,-0.017695507,-0.00016385701,-0.009779723,0.009281523,0.016447663,-0.0016717876,-0.006046768,0.0019807043,0.0009789681,0.0053014043,-0.015549058,-0.0015370294,-0.0015797019,0.0025413698,0.011508354,6.81798e-05,0.00064557366,0.005597415,-0.010183823,-0.0005412884,-0.0012743756,-0.0062279813,-0.012306143,0.020321464,-0.0048450697,-0.009363336,0.0015132731,0.00028024983,0.00041821046,0.002257775,-0.009986855,-0.019369831,-0.0042788433,0.0019870035,0.0045320694,0.018039303,0.0028292832,-0.009881075,-0.001457822,0.00073101296,0.002016834,0.009079245,-0.005470439,-0.011460627,-0.0005101477,-0.007016656,0.0047223684,-0.0018086631,-0.00089080696,0.006863153,-0.01549896,0.0009538874,-0.0049543334,0.0029891862,0.004550378,-0.00093985966,-0.0036879093,-0.01508777,-0.00083210104,-0.000106164676}, {8,2,0,2,4,1,0,4,6,4,4,0,6,8,1,4,8,4,3,8,1,5,4,0,0,8,8,8,255,2,1,2,6,2,8,0,255,0,2,1,4,8,8,6,5,5,4,3,2,1,1,8,2,6,4,0,0,3,6,0,1,0,0,0,8,255,255,0,2,6,0,7,8,2,8,4,1,5,5,0,8,255,4,7,1,8,5,2,5,3,4,0,0,0,255,1,8,6,0,255,4,255,255,8,6,255,0,255,255,255,255,8,255,8,2,255,255,8,0,0,8,255,8,8,8,6,0,255,8,255,8,4,8,0,0,8,4,0,255,0,8,0,255,4,2,0,1,2,5,8,6,1,255,3,255,0,255,2,6,8,8,255,255,255,5,0,2,255,5,7,4,5,4,1,0,1,8,255,0,5,255,0,255,0,8,8,5,255,255,0,255,8,3,255,255,1,4,255,255,8,6,1,5,8,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,65535,57,59,61,63,65,67,69,65535,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,65535,65535,127,129,131,133,135,137,139,141,143,145,147,149,151,153,65535,155,157,159,161,163,165,167,169,171,173,175,177,65535,179,181,183,185,65535,187,65535,65535,189,191,65535,193,65535,65535,65535,65535,195,65535,197,199,65535,65535,201,203,205,207,65535,209,211,213,215,217,65535,219,65535,221,223,225,227,229,231,233,235,65535,237,239,241,65535,243,245,247,249,251,253,255,257,259,65535,261,65535,263,65535,265,267,269,271,65535,65535,65535,273,275,277,65535,279,281,283,285,287,289,291,293,295,65535,297,299,65535,301,65535,303,305,307,309,65535,65535,311,65535,313,315,65535,65535,317,319,65535,65535,321,323,325,327,329,331,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,65535,58,60,62,64,66,68,70,65535,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,65535,65535,128,130,132,134,136,138,140,142,144,146,148,150,152,154,65535,156,158,160,162,164,166,168,170,172,174,176,178,65535,180,182,184,186,65535,188,65535,65535,190,192,65535,194,65535,65535,65535,65535,196,65535,198,200,65535,65535,202,204,206,208,65535,210,212,214,216,218,65535,220,65535,222,224,226,228,230,232,234,236,65535,238,240,242,65535,244,246,248,250,252,254,256,258,260,65535,262,65535,264,65535,266,268,270,272,65535,65535,65535,274,276,278,65535,280,282,284,286,288,290,292,294,296,65535,298,300,65535,302,65535,304,306,308,310,65535,65535,312,65535,314,316,65535,65535,318,320,65535,65535,322,324,326,328,330,332,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({2145.5,503,2223.5,438,2315,3944,5871.5,322.5,4032.5,926.5,19.5,17.5,4268,5869,5872.5,198,6.5,17.5,262,1304.5,988.5,2388.5,2363.5,4.5,2174.5,-0.021774454,16.5,5715.5,-0.019820346,6145,5873.5,127.5,125.5,446,21.5,432,444.5,18.5,18.5,21.5,20,18.5,1025,18.5,2300.5,0.022284994,3892.5,2.5,2696,1641,18.5,2.5,-0.013445034,5456.5,5457.5,4332,-0.0068812384,-0.03258769,5136,115.5,21.5,227,19.5,251.5,-0.015054548,446,706.5,645,11.5,20.5,18.5,12,0.006701269,1039,8286,694.5,390,18.5,0.04421563,1027,931,20.5,1252.5,4.5,0.017451039,2219,3905,2100.5,5126.5,2177.5,2408.5,12.5,6.5,18.5,2035,0.0005051836,-0.011792036,0.0033721353,-0.0045881383,4617,5599,8086,5743.5,13.5,12,6301,5629.5,70,109,134.5,194.5,16,-0.005503736,2.5,207.5,1551.5,2538.5,383,19.5,583.5,0.018592125,6,15.5,1.5,474.5,19.5,392,-0.0046060677,-0.017805224,5.5,15.5,6.5,12.5,-0.009504109,8556,6.5,1006,690,676.5,12.5,0.010980408,932.5,17.5,-0.0033652396,-0.019086884,17.5,0.010705471,1578,1215,3.5,17.5,3363.5,5068,2.5,4735.5,1202.5,-0.008239292,6010.5,4136,1.5,1.5,2918,4689,2719,13.5,-0.000594509,12.5,0.002386099,0.008787982,18.5,18.5,1900,5476.5,15.5,5806,5839.5,-0.02157454,5755,6205.5,5,0.011002932,0.014474625,0.0075521204,6515.5,8492.5,5499,5928,3.7370119e-06,0.0018457692,-0.005224292,6.3118176e-05,0.0038659764,0.00024444758,-0.00067726814,0.051252246,-0.008309986,-0.0148142725,-0.0035958372,-0.0005432146,0.0077073104,-0.0071763955,-0.00052203477,-0.014844708,0.0042528803,0.0003420495,0.0035926818,0.0007138022,0.0114189135,-0.0024230042,-0.0053788847,0.0007716025,-0.0016853939,-0.0038947312,-0.0156804,0.0019463552,0.0007758221,-0.0022579974,-0.009827117,-0.0035221546,-0.008672215,-0.0015297853,0.0015219926,0.005334519,0.0017628467,0.007404761,-0.004229837,-0.00010163011,-0.00476407,-0.0018820827,0.00096053083,-0.0007711143,-0.0048147547,-0.00021994249,-0.00036919402,0.00622192,-0.00018479917,0.0024703757,-0.0034143794,0.014207129,-0.017187504,-0.0076903016,0.00066291686,-0.0027602282,-0.0028760075,-0.007020791,0.002172542,-0.0022276333,0.0050086984,-0.007766613,-0.00022924214,0.0024357184,-0.0074763433,-0.0004969302,2.410315e-05,0.020553868,0.0018890984,0.004518769,-0.0019094864,0.0022666408,-0.0032009073,-0.018099109,-0.0009918071,0.0038075193,-0.0017725371,0.0016806092,-0.0058581047,0.003193327,0.019252714,0.009585784,0.004769613,-0.0007365533,0.0028181206,0.0007498378,-0.0006303046,-0.009613459,0.019440928,0.006877654,-0.004260422,-0.0009870128,-0.00418271,-0.010591999,0.004263093,-0.0028219197,0.005248107,0.0008611058,0.006375962,0.0029096308,-0.00047038138,0.001269299,-0.0025654477,0.00041707946,-0.0012805535,-0.011083003,0.0017391313,0.0065869926,-0.0034781152,0.00052338355,-0.0046756123,-0.016538387,-0.0004992515,0.003450999,-0.017266303,0.0003806355,0.007955186,0.0043255626,0.0018149589,-2.8254535e-06,0.0058430913,-0.00077982777,-0.0010582416,-0.008796896,0.0031979785,-3.1075813e-06}, {6,7,6,6,2,3,0,7,0,0,8,8,2,0,0,6,8,8,5,3,0,2,2,8,7,255,8,0,255,1,0,7,7,7,8,3,1,8,8,8,8,8,0,8,4,255,3,8,5,2,8,8,255,3,4,1,255,255,4,6,8,6,8,2,255,7,2,2,8,8,8,8,255,4,0,6,5,8,255,2,1,8,7,8,255,5,2,7,2,2,1,8,8,8,5,255,255,255,255,2,3,6,1,8,8,7,4,7,2,7,6,8,255,8,6,0,0,6,8,4,255,8,8,8,6,8,5,255,255,8,8,8,8,255,4,8,7,0,6,8,255,1,8,255,255,8,255,6,6,8,8,0,0,8,3,5,255,0,0,8,8,2,0,4,8,255,8,255,255,8,8,5,1,8,3,0,255,7,1,8,255,255,255,0,6,4,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,65535,51,53,65535,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,65535,87,89,91,93,95,97,65535,99,101,103,65535,65535,105,107,109,111,113,115,65535,117,119,121,123,125,127,129,65535,131,133,135,137,139,65535,141,143,145,147,149,65535,151,153,155,157,159,161,163,165,167,169,65535,65535,65535,65535,171,173,175,177,179,181,183,185,187,189,191,193,195,65535,197,199,201,203,205,207,209,65535,211,213,215,217,219,221,65535,65535,223,225,227,229,65535,231,233,235,237,239,241,65535,243,245,65535,65535,247,65535,249,251,253,255,257,259,261,263,265,65535,267,269,271,273,275,277,279,281,65535,283,65535,65535,285,287,289,291,293,295,297,65535,299,301,303,65535,65535,65535,305,307,309,311,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,65535,52,54,65535,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,65535,88,90,92,94,96,98,65535,100,102,104,65535,65535,106,108,110,112,114,116,65535,118,120,122,124,126,128,130,65535,132,134,136,138,140,65535,142,144,146,148,150,65535,152,154,156,158,160,162,164,166,168,170,65535,65535,65535,65535,172,174,176,178,180,182,184,186,188,190,192,194,196,65535,198,200,202,204,206,208,210,65535,212,214,216,218,220,222,65535,65535,224,226,228,230,65535,232,234,236,238,240,242,65535,244,246,65535,65535,248,65535,250,252,254,256,258,260,262,264,266,65535,268,270,272,274,276,278,280,282,65535,284,65535,65535,286,288,290,292,294,296,298,65535,300,302,304,65535,65535,65535,306,308,310,312,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({18.5,1178,2524.5,1134.5,1248.5,303.5,7590.5,404.5,1569,1250.5,15.5,241.5,307,6312.5,7741,378.5,428,1717.5,15.5,6.5,6.5,11237.5,6220,24,19.5,20.5,720.5,5218.5,5437.5,8065,21558.5,39,738.5,3.5,455,12.5,1.5,1257.5,2016,996,387.5,1.5,12.5,7776.5,11633.5,1586,6225,83,32.5,-0.003326767,-0.01018146,19.5,451,427,809.5,3435,4701,5717.5,9159.5,8675.5,-0.017805403,8827.5,23168.5,96.5,48.5,639.5,2.5,530,530,6.5,893,1291,1226.5,0.018831095,1003,893.5,14.5,1290.5,879.5,5,1080,0.0040994054,0.007301055,1294.5,2003,1108,2003,7608.5,7924.5,6289.5,11659,16.5,2150.5,-0.00678046,6380.5,26,118.5,27.5,26.5,608,68.5,0.03848447,619,402,584.5,949,2164,1610,3326,0.014960735,3838.5,6101,0.012655728,7508.5,7341.5,5668,-0.0019721752,7230,21937,23164.5,19144,65,46,45.5,53.5,5.5,15.5,379,4050.5,-0.01565644,0.0074161324,15.5,0.0073570684,537.5,426.5,763.5,12.5,1226.5,11.5,15.5,861.5,2.5,11.5,4.5,2.5,1695.5,2526,-0.020756459,1848,2765,3103,-0.0019948564,0.00143907,0.0029102266,1.5,-0.0010123856,0.0032459025,5.5,2.5,0.0029319022,0.0053311307,13.5,17.5,6373,6814.5,9171.5,13035.5,5709,11491.5,10869.5,21427,826.5,4654.5,1730.5,2446,6234.5,6507.5,23.5,37.5,-0.010092041,20.5,81,31.5,19.5,26.5,402.5,2198.5,48.5,27.5,197.5,2424,-0.006968394,20.5,20.5,622.5,751,1092,2176,2687,584,2625.5,3919.5,4064.5,5564,5687.5,7887.5,2658,7265.5,6499,8182,10679.5,0.003893498,0.0139735285,3134,8426,16435.5,11982,21638.5,23347.5,0.0063895728,23211,-0.00013552011,-0.004373891,-0.0103676645,-0.0018318841,0.001573352,0.005754788,-0.0024204408,0.00025194438,-0.0011728393,-0.006963998,-0.015013968,0.00038683423,0.0049765683,-0.005462603,-0.0029034417,0.00013710758,0.013976606,0.006757423,-0.0067595425,0.00062531244,0.0016318811,0.008863675,-0.0006555998,-0.0054335413,0.0010750633,-0.0008150031,-0.003649611,0.009294548,-0.014095274,-0.0052192057,-0.0011647297,-0.023012575,0.0034150907,-0.004635145,-0.011410098,-0.0005025902,-0.0043838276,-0.018262416,0.0039171893,0.024905441,0.01672974,-0.00037611875,-0.005445197,-0.00021251105,0.012466301,-0.0050382833,-0.0040543117,-0.02406839,-0.0069393464,-6.118e-05,0.0037076424,-0.0007457466,0.0025121884,0.00053892675,-0.0016162454,-0.00044358752,0.0001161691,-0.0007014025,0.00014381387,-0.0029010216,0.00037385683,0.0036851827,0.00011142341,-0.00088952685,-0.0031255798,0.0062053683,-0.004854662,0.001884244,-0.00041034128,0.0023208184,-0.0005251334,0.0025382482,0.0090782605,-0.003696778,-0.0040618493,-0.0138056725,0.00025194767,-5.8320475e-05,0.0015444761,-0.0048019583,-0.0038687165,0.0015425765,-0.002237289,0.0037358508,-0.0024629938,0.0014181421,0.00014667862,0.003831866,-0.00531163,-0.00013549613,-0.0015411255,0.0031265598,0.008451039,0.0009434665,0.0013170363,-0.0015791769,-0.0013830651,0.0028257123,0.001832412,0.0049821334,-0.0016032904,-0.008433065,-0.007883576,-0.0014572165,-2.9023931e-05,-0.0015412251,0.013278636,0.0037603409,-0.003835559,-0.015527524,-0.006697461,0.0004204289,-0.0027170642,-0.014433232,0.017737372,-0.004535477,0.0076693194,0.00081836554,-0.009217344,-0.01839848,0.01048045,-0.0063138306,0.020725524,-0.0041047796,0.027896395,0.00979592,0.00047574795,-0.009183186,0.007590552,0.00082683854,1.4824329e-05,0.005297556,-0.015117407,-0.004360085,0.0011034787,0.009861246,-0.0033522986,-0.0006560372,-0.0069898567,0.003128621,-0.0033897522,0.0007172627,-0.005715907,0.0040619737,0.0018107485,0.00819674,-0.006469045,-0.019451508,-0.004864111,-0.0012236757,-0.004258678,0.0037318715,0.017980417,0.0023050332,-0.0006563095,0.005325857,-0.006268119,-0.00047992417,0.0010588672,-0.0004508303,-0.0011895177,0.0064791674,0.0018542967,-0.0036499302,0.005731825,-0.0008190294,0.0028025631,4.3491986e-05}, {8,5,2,4,4,1,7,5,6,3,8,1,6,7,7,4,4,2,8,8,8,6,5,5,8,8,4,1,4,5,6,3,6,8,2,8,8,4,2,4,0,8,8,6,6,1,5,1,2,255,255,8,0,1,0,6,0,5,1,2,255,7,5,4,2,6,8,0,0,8,3,2,2,255,7,5,8,4,1,8,4,255,255,0,0,6,0,6,6,1,6,8,1,255,7,0,0,2,3,1,3,255,1,2,7,2,2,0,2,255,6,3,255,6,6,4,255,6,2,6,3,2,0,2,3,8,8,5,2,255,255,8,255,6,2,2,8,2,8,8,7,8,8,8,8,2,6,255,2,6,6,255,255,255,8,255,255,8,8,255,255,8,8,7,2,3,3,1,7,0,7,2,4,7,6,7,7,3,6,255,8,4,1,8,6,0,0,2,7,2,0,255,8,8,6,4,2,3,6,6,0,5,2,1,4,0,4,6,7,4,0,255,255,0,6,0,7,4,6,255,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,65535,65535,99,101,103,105,107,109,111,113,115,65535,117,119,121,123,125,127,129,131,133,135,137,139,65535,141,143,145,147,149,151,153,65535,65535,155,157,159,161,163,165,167,169,171,173,65535,175,177,179,181,183,185,187,65535,189,191,193,195,197,199,201,65535,203,205,65535,207,209,211,65535,213,215,217,219,221,223,225,227,229,231,233,235,65535,65535,237,65535,239,241,243,245,247,249,251,253,255,257,259,261,263,265,65535,267,269,271,65535,65535,65535,273,65535,65535,275,277,65535,65535,279,281,283,285,287,289,291,293,295,297,299,301,303,305,307,309,311,313,65535,315,317,319,321,323,325,327,329,331,333,335,65535,337,339,341,343,345,347,349,351,353,355,357,359,361,363,365,367,369,371,373,65535,65535,375,377,379,381,383,385,65535,387,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,65535,65535,100,102,104,106,108,110,112,114,116,65535,118,120,122,124,126,128,130,132,134,136,138,140,65535,142,144,146,148,150,152,154,65535,65535,156,158,160,162,164,166,168,170,172,174,65535,176,178,180,182,184,186,188,65535,190,192,194,196,198,200,202,65535,204,206,65535,208,210,212,65535,214,216,218,220,222,224,226,228,230,232,234,236,65535,65535,238,65535,240,242,244,246,248,250,252,254,256,258,260,262,264,266,65535,268,270,272,65535,65535,65535,274,65535,65535,276,278,65535,65535,280,282,284,286,288,290,292,294,296,298,300,302,304,306,308,310,312,314,65535,316,318,320,322,324,326,328,330,332,334,336,65535,338,340,342,344,346,348,350,352,354,356,358,360,362,364,366,368,370,372,374,65535,65535,376,378,380,382,384,386,65535,388,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({8321.5,8296.5,9187,9171,6329.5,9180,7118.5,8079,6796.5,5786.5,1.5,9436,-0.02038849,6850,7179.5,7240,7960.5,7803,7165,3474,-0.023809422,7131.5,7838,7962,9467.5,3456,8049.5,7176.5,10031.5,5610,7138.5,7925,7432.5,5917.5,8180,10251,8419.5,1.5,11.5,0.0069002593,-0.008946593,0.02698628,15.5,7865.5,8498.5,0.024883607,10214.5,4355.5,6096,1.5,7985,0.005337006,2.5,11015,9639.5,4962,7852.5,6999.5,6722,8211,0.027913516,8185,1.5,10542,9324,-0.012879047,3.5,9426,6484,8260,6860,0.0044841766,4.5,6503.5,0.009254846,6.5,6644.5,6329.5,17.5,9079.5,8985.5,9596.5,1.5,25128.5,6.5,6004,6473,8773,9688.5,5.5,9368.5,-0.006105779,-0.01990651,9900.5,13662.5,9501,11536.5,7938,2734,6142.5,7997.5,6955.5,6932,5598,8369,8546.5,7061.5,-0.020246508,8713.5,-0.00087420485,8675,8817.5,4312,0.0071814046,7097,-0.0013654486,-0.0073195244,0.029208139,0.017826244,6.5,10650,1.5,-0.029279439,3.5,7945.5,2.5,18.5,0.0066232174,7.5,7708,6644.5,0.00349664,0.014644124,5808,8225.5,0.013741654,19.5,8554,0.010044462,8926.5,9103,6140,6156,0.010777395,11149,15.5,32013.5,2.5,11692.5,1.5,1.5,6.5,1.5,7936,0.020049013,4.5,4.5,0.0015334843,-0.0072994353,14.5,2.5,9373.5,11462.5,8408.5,10931,9288,10695,11507,11848,4.8701007e-05,0.006480098,-0.014914003,0.0021887107,0.00041705323,-0.004485288,-0.020292927,-0.005155705,0.00016990576,0.006918249,-0.009996869,-0.024768068,0.000105748586,-0.012057189,0.009256127,-0.010982507,0.0014721133,-0.012340332,-0.0010584205,-0.022935608,-0.0016566626,-0.018556273,-0.035108235,-0.024045916,0.00061539345,0.005679254,0.00028598364,-0.0007305955,-0.009899717,0.001596343,0.0015339007,0.0031900068,0.011029831,0.0045392453,-0.026195139,-0.0051675346,-0.001191373,-0.013085983,0.00071580836,0.00438997,-0.0010379931,-0.0034655442,0.0009571806,-0.0016878527,-0.0012352618,0.0026747936,0.005345439,0.00013386643,0.0038433974,0.008455786,-0.00068910024,0.0042715385,-0.0029567822,-0.013150019,0.0028242106,0.0069399336,-0.030504635,-0.016857302,0.007492059,-0.003212206,-0.011219726,-0.0021444934,0.0010206769,0.010452435,-0.008716829,0.0014242802,-0.0040801987,-0.009072806,0.002546861,-0.0015069664,-0.0034703952,0.0012725826,-0.0044951313,0.00063940993,-0.0017562619,-0.0055007897,-0.0045002135,0.002920647,-0.008426006,0.011061644,-0.0012312148,0.001219775,0.011029724,-0.0073037297,-0.0046447925,-0.024591245,0.013479284,0.00466028,0.007955416,0.013181768,0.0018909452,0.0030671544,-0.0015291653,0.00063689495,-0.00094928005,0.013419541,-0.020725852,-0.0034964525,0.0020118677,-0.00021849918,0.0037016512,0.006908608,-0.0027462218,0.0012809908,-0.00537504,-0.024649778,0.0008089879,0.012439411,-0.001037107,1.6836366e-05}, {2,2,2,1,1,2,6,1,6,1,8,3,255,6,6,7,6,2,3,1,255,1,4,5,3,7,5,0,6,3,0,6,3,6,2,0,7,8,8,255,255,255,8,5,4,255,0,6,6,8,4,255,8,3,2,3,1,0,2,0,255,1,8,1,1,255,8,0,2,2,2,255,8,0,255,8,0,1,8,5,5,3,8,2,8,6,5,0,2,8,2,255,255,1,1,2,6,1,7,7,1,0,2,3,7,4,7,255,1,255,7,3,7,255,5,255,255,255,255,8,0,8,255,8,4,8,8,255,8,1,0,255,255,1,7,255,8,2,255,2,2,0,6,255,1,8,3,8,0,8,8,8,8,0,255,8,8,255,255,8,8,1,0,4,0,2,1,6,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,37,65535,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,65535,65535,65535,75,77,79,65535,81,83,85,87,89,65535,91,93,95,97,99,101,103,105,65535,107,109,111,113,65535,115,117,119,121,123,65535,125,127,65535,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,65535,65535,161,163,165,167,169,171,173,175,177,179,181,183,185,187,65535,189,65535,191,193,195,65535,197,65535,65535,65535,65535,199,201,203,65535,205,207,209,211,65535,213,215,217,65535,65535,219,221,65535,223,225,65535,227,229,231,233,65535,235,237,239,241,243,245,247,249,251,253,65535,255,257,65535,65535,259,261,263,265,267,269,271,273,275,277,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,38,65535,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,65535,65535,65535,76,78,80,65535,82,84,86,88,90,65535,92,94,96,98,100,102,104,106,65535,108,110,112,114,65535,116,118,120,122,124,65535,126,128,65535,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,65535,65535,162,164,166,168,170,172,174,176,178,180,182,184,186,188,65535,190,65535,192,194,196,65535,198,65535,65535,65535,65535,200,202,204,65535,206,208,210,212,65535,214,216,218,65535,65535,220,222,65535,224,226,65535,228,230,232,234,65535,236,238,240,242,244,246,248,250,252,254,65535,256,258,65535,65535,260,262,264,266,268,270,272,274,276,278,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31867.5,28007.5,18772,30955,29396,18713,2.5,28950,31113.5,22227,29267,28579.5,31241.5,21807.5,19826.5,21973,30025,0.012676961,31211,15167,30765.5,17070.5,29453,-0.010084828,18891,13985.5,18941,19320,22491.5,19567.5,24094,19562.5,22484,26797,24247.5,6.5,2.5,28508.5,15.5,3.5,29343.5,1.5,15.5,29533.5,23665.5,18816.5,32014,19.5,1.5,32370,18182,32394,18049.5,-0.0060274834,25723,19720,18049.5,32140.5,30603,15103,19853,16480,22494.5,23612.5,2.5,-0.008177095,15.5,-0.00562272,19,-0.003639266,31369.5,25614,-0.01298537,20559.5,28706,27823,15.5,7.5,9,22046,15.5,20573,20573,29512.5,29507.5,25325,29473.5,31874,3.5,7.5,19456.5,2.5,-0.0065515274,0.0017611663,6.5,4.5,1.5,19279,19481,32411,18920.5,-0.0054407683,31992.5,1.5,30603,18488,12,-0.008685603,19612,32097.5,20511,30175,30216,15090,19337.5,12959.5,22546,2.5,23022,0.01225445,21228.5,26118,16.5,-0.0071303598,15.5,26567.5,26795,16.5,-0.0027418963,0.005788869,6.5,19642,28103.5,16048.5,0.008099153,17169.5,28139.5,-0.00046169266,-0.0048805377,27823,29374.5,28776,29217.5,0.0008059209,0.0024711967,-0.0047302027,-0.0010925934,29941.5,29941.5,0.014444761,3.5,0.005955331,0.0020334867,-0.0024842517,-0.0038581882,-0.0025382272,3.5,0.012748708,8.5,16474,11180,-0.005576543,18109.5,-0.0020189125,-0.007926787,30841,32366.5,19336.5,32403,0.0013415384,-0.0019497456,3.5,17.5,0.0010448205,14.5,0.0019784712,18828,6.5,7.5,19186,19953,31994.5,1.5,18341,20169,-0.00097418897,19703.5,23439,24091,30378,31665.5,32082,32157,0.0027285414,0.0017071232,9.5,20108,20221,-0.0048934836,16.5,19817.5,30064.5,4.5,4.5,30412,6.257804e-05,0.0065505104,-0.0013382005,0.0015925056,0.00021484819,0.0066841366,-0.0060083037,0.0011352785,-0.008736628,0.00031912987,-0.0046846503,0.00012932703,0.001601485,-0.00031088732,-0.0023046827,0.00025494306,0.007917955,0.0021098403,0.000867481,-0.0024205577,0.0003794825,-0.0023576932,-0.003166841,-0.0009843879,-0.0014466322,0.00073431403,-0.00066246436,0.002991478,-0.0014721815,0.0026739123,0.0032693886,-0.0012021947,-0.0012877317,0.0053403596,0.0016577531,0.0052548433,0.0059120045,-0.00021764722,-0.0013012689,0.0010032187,-0.00079863303,-0.0027681668,-6.406631e-05,0.00013019757,0.0001718046,0.00081937294,0.0012766934,0.005013957,0.0020980854,-0.00053291366,0.000845795,0.008721883,0.00032686573,0.0009765136,-0.0028166976,-0.00043662076,-0.00611329,-0.0005750893,0.0019020931,5.895662e-05,-0.0011113846,-0.0022004307,-0.0027139883,-0.0010651879,-0.00037831973,-0.0014719925,0.0004083029,-0.00044747637,-0.0011217396,-0.0042172484,-0.0008628267,-0.0023931626,-0.0011015142,-0.0014720428,0.0022232083,0.0013883593,0.00023425063,0.0007301964,-0.0004087584,5.9532245e-05,0.00063829863,0.00095712225,0.00031355463,-0.00053556403,-0.0012383215,-0.0004953363,-0.00030927206,0.00058969617,0.0037724196,0.0010170836,0.0022382296,0.00021448103,-0.0016635025,0.002432772,0.0041153184,0.0020343596,-0.00023346183,0.000523484,-0.00042472174,0.0002375725,-0.0028483958,-0.0009057289,0.00037713992,-0.00023624045,-0.0016104551,0.0005265912,0.00083845,-0.00057500246,0.0032606316,0.0021854127,0.0019281557,0.0007768749,-0.0009949461,-0.0017942956,0.00034354703,-0.00035470308,0.00067645824,-0.00046934854,0.00018725761,0.0016360966,-0.0027984716,-0.0010262217,-0.0002779447,-1.9644036e-05,0.0023290017,0.00086030335}, {0,4,3,0,2,1,8,6,0,3,4,4,2,1,3,6,6,255,0,1,5,1,2,255,5,2,1,5,1,7,5,6,6,4,0,8,8,0,8,8,2,8,8,6,6,5,2,8,8,0,7,4,1,255,1,3,1,6,7,2,7,5,6,2,8,255,8,255,8,255,0,0,255,7,0,0,8,8,8,0,8,3,3,0,0,0,0,0,8,8,7,8,255,255,8,8,8,1,1,0,3,255,6,8,7,1,8,255,1,6,1,7,1,2,4,7,7,8,5,255,4,0,8,255,8,0,2,8,255,255,8,0,4,5,255,1,4,255,255,0,4,6,0,255,255,255,255,2,2,255,8,255,255,255,255,255,8,255,8,3,5,255,3,255,255,2,0,5,0,255,255,8,8,255,8,255,1,8,8,7,1,0,8,1,1,255,1,3,3,5,1,0,2,255,255,8,5,5,255,8,5,1,8,8,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,65535,35,37,39,41,43,65535,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,65535,103,105,107,109,111,113,115,117,119,121,123,65535,125,65535,127,65535,129,131,65535,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,65535,65535,171,173,175,177,179,181,183,65535,185,187,189,191,193,65535,195,197,199,201,203,205,207,209,211,213,215,65535,217,219,221,65535,223,225,227,229,65535,65535,231,233,235,237,65535,239,241,65535,65535,243,245,247,249,65535,65535,65535,65535,251,253,65535,255,65535,65535,65535,65535,65535,257,65535,259,261,263,65535,265,65535,65535,267,269,271,273,65535,65535,275,277,65535,279,65535,281,283,285,287,289,291,293,295,297,65535,299,301,303,305,307,309,311,65535,65535,313,315,317,65535,319,321,323,325,327,329,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,65535,36,38,40,42,44,65535,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,65535,104,106,108,110,112,114,116,118,120,122,124,65535,126,65535,128,65535,130,132,65535,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,65535,65535,172,174,176,178,180,182,184,65535,186,188,190,192,194,65535,196,198,200,202,204,206,208,210,212,214,216,65535,218,220,222,65535,224,226,228,230,65535,65535,232,234,236,238,65535,240,242,65535,65535,244,246,248,250,65535,65535,65535,65535,252,254,65535,256,65535,65535,65535,65535,65535,258,65535,260,262,264,65535,266,65535,65535,268,270,272,274,65535,65535,276,278,65535,280,65535,282,284,286,288,290,292,294,296,298,65535,300,302,304,306,308,310,312,65535,65535,314,316,318,65535,320,322,324,326,328,330,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({11421,7774.5,9082.5,7713,7163,11195,9101.5,7227,15.5,15.5,7915.5,9594.5,6.5,2.5,11666,7182.5,7108,7437,7813.5,12.5,3509,7911,9090,20,0.0063797557,18627,24341,-0.001885543,-0.0097499145,11639.5,10408.5,7203.5,7225.5,6402.5,8565.5,7215,6739.5,10302.5,10378,2.5,8017,6962.5,7040,7438,-0.021574333,8990.5,8232.5,0.0038107857,0.0012962444,29870.5,12642.5,13120.5,23804,9146,12899.5,5542,15492,7098,7214,7225,7560.5,6224.5,8178,6086.5,9640.5,2.5,3,13.5,4.5,7763,0.0033153351,18,-0.004993222,3509,6878,6270.5,5723,17.5,17.5,18,7893.5,8167.5,7994,8532.5,8457,6932.5,10058.5,12404,25522.5,5.5,24081.5,-0.010068217,21.5,24953.5,27682.5,8690.5,11630,18.5,15.5,4331,11795,28006.5,14646.5,6767.5,6313.5,7524,6701.5,6799,5291,1.5,6737.5,5709.5,6325,7304.5,6551,7383,7344.5,9306.5,13948,6727.5,6.5,0.0006869258,11206,7.5,0.00030389125,7747,5.5,17.5,17.5,0.001965763,0.004282633,0.0061796764,7105,7.5,7201.5,0.00069565326,7989,30.5,14.5,16.5,6838.5,7093,18.5,0.0038445962,6896.5,17.5,17.5,7480.5,1.5,1.5,1.5,4997.5,13495.5,20.5,2188,6815,7212,8552.5,9165.5,1.5,1.5,1.5,4.5,4.5,-0.00020031934,13754,0.006110072,16.5,15042.5,15.5,25363.5,0.002524397,15,11562.5,18.5,11721.5,7.5,10973,-0.00027997047,0.014323327,11651.5,3188.5,1.5,13231,9802.5,17433,28319,23109.5,13932.5,-3.2011874e-05,-0.00096160045,0.02013833,0.001160732,-0.005766829,-0.019104669,-0.0018458881,0.0017439427,-0.017474484,0.0027524175,0.0067108027,-0.0014059623,0.0073035597,-0.012333821,0.0019606573,-0.0073730364,0.0009736673,-0.001530071,0.010932347,0.0014508475,0.032110266,-0.0071107866,-0.0024113893,0.0059026363,-0.015497458,0.00010992503,-0.02344014,0.008179056,-0.013548064,-0.005789577,0.0029852323,-0.0002941945,-0.0068385764,-0.00060814474,-0.0014215525,0.00040793346,-0.009084482,-0.002847621,0.0008554715,0.0017102404,0.011236431,0.005040998,-0.0053469134,0.0058889906,0.0022332775,0.00926062,0.018318646,0.010384494,0.0030598955,-0.00033396573,0.0015233128,0.0028159104,-9.044411e-05,0.0014939911,0.00014248762,-0.0002490192,-0.0016941142,0.00046612896,-0.002003858,-0.0040838583,0.0013284282,0.00016930042,0.00034729516,-0.00110531,6.2719475e-05,0.003062926,-0.0008996489,0.0018408211,0.009582327,0.016672406,0.007051316,0.0043046153,0.0007940139,0.0024970814,-0.0043352535,0.004800811,-0.012301887,-0.0033276237,0.0043697422,-0.014119925,-0.026575753,-0.0011790188,0.0020479385,-0.005443109,0.0026928692,-0.0008153167,0.00030679652,0.014257069,0.00019696126,-0.0124049075,0.0001841332,-0.01120299,0.013216724,0.0015694896,0.00017998645,-0.00873541,0.0008954978,-0.00041345568,-0.019567084,0.00091917516,0.0013623008,-0.001279863,-0.0013135785,0.0027932865,0.008369786,-0.0008660174,0.00012028355,0.0005298549,0.0015319741,0.0041337996,0.002226034,0.003847186,0.0028417176,-0.0010348249,-0.0005813981,-0.002602706,0.003150108,-0.0003142968,0.007468179,0.0013896796,0.0034548517,0.006330413,0.0007834285,0.0033147892,-0.0015462383,8.172081e-05,-0.001848199,0.002560458,-0.0007463547,-0.0018741643,0.00416372,0.011340983,0.0005996854,0.0020465462,0.0022794472,-0.0008901187,0.0006970141,-0.008745314,0.0029006114,0.00041431453,-0.00037940324,0.0017813264,-0.013829254,-0.001481521,0.0044812937,0.0002733928,0.0021538583,-5.104562e-06}, {1,1,5,1,0,0,5,5,8,8,1,0,8,8,1,1,0,3,5,8,4,1,1,8,255,4,0,255,255,1,3,5,7,0,4,7,0,0,4,8,1,0,4,3,255,1,2,255,255,1,1,0,4,4,0,3,3,5,5,1,1,0,6,2,4,8,8,8,8,0,255,8,255,4,0,0,2,8,8,8,2,0,0,0,0,7,3,1,0,8,4,255,8,6,0,2,6,8,8,6,1,2,5,1,6,3,0,4,2,8,5,0,0,5,2,0,5,4,4,4,8,255,0,8,255,1,8,8,8,255,255,255,0,8,6,255,1,4,8,8,0,0,8,255,0,8,8,0,8,8,8,3,0,8,2,7,3,3,0,8,8,8,8,8,255,1,255,8,1,8,2,255,8,1,8,5,8,0,255,255,1,2,8,4,3,1,2,4,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,65535,49,51,65535,65535,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,65535,83,85,65535,65535,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,65535,129,65535,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,65535,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,65535,225,227,65535,229,231,233,235,65535,65535,65535,237,239,241,65535,243,245,247,249,251,253,255,65535,257,259,261,263,265,267,269,271,273,275,277,279,281,283,285,287,289,291,293,295,65535,297,65535,299,301,303,305,65535,307,309,311,313,315,317,65535,65535,319,321,323,325,327,329,331,333,335,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,65535,50,52,65535,65535,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,65535,84,86,65535,65535,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,65535,130,65535,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,65535,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,65535,226,228,65535,230,232,234,236,65535,65535,65535,238,240,242,65535,244,246,248,250,252,254,256,65535,258,260,262,264,266,268,270,272,274,276,278,280,282,284,286,288,290,292,294,296,65535,298,65535,300,302,304,306,65535,308,310,312,314,316,318,65535,65535,320,322,324,326,328,330,332,334,336,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({5432.5,4778.5,5510.5,4282,11090.5,7362.5,10734,4222,4581,5104,4780.5,6298.5,6506,10444,11656.5,4183.5,4229.5,4841,5922.5,5087.5,10997,6.5,11356.5,6675,5480,2.5,7869.5,10429,9814.5,11482.5,6835,21.5,2090,0.014748998,3547,8290,-0.01901537,5882,5626,8025.5,-0.020407218,3692.5,5,0.004996359,0.010063647,8360.5,11438.5,5857,0.006721829,0.008394566,6830,-0.0050204406,3097.5,7.5,6468.5,10414,5744.5,8554,12331.5,10433,9361,6344,12749.5,3469,3309,-0.013418959,4190,17.5,4260,6.5,11,7.5,-0.01874037,0.012134667,4798.5,4749.5,0.010675761,9855,5285,-0.0019383151,14,2.5,6.5,8050,7299,14.5,7.5,-0.0023301344,0.0070979083,-0.010032632,-0.019290885,1.5,18.5,7,14,5960.5,-0.017200066,12.5,15.5,2.5,2.5,11046,10218.5,10112,11912.5,8236.5,11834,26175.5,7400,12738,6779.5,15.5,3198.5,726.5,3504.5,14.5,5763,5,5638,11.5,7.5,4582.5,15.5,4.5,0.0036039946,4492.5,4596,6546,19.5,17.5,5008,2.5,4.5,6800.5,12.5,-0.008659399,-0.005227735,0.00069765165,18.5,12343,12343,2.5,8.5,1.5,5181,5865,5457,-0.007721008,-0.0034843876,0.0024103797,4.5,5479,5698,3,13,11239,-0.0045453976,9411.5,5962.5,4.5,0.010280524,1.5,12406.5,-0.0005610705,-0.012947889,-0.0032190531,-0.02552338,8.5,8043,2,2.5,2,6207,5698,10961,1.5,13192,8514.5,11959,7.5,7.5,0.009607484,0.0033164956,12.5,12503.5,6301,7761,-8.385095e-05,0.00037354694,-0.0014284246,0.0008234956,0.0006699206,0.0067340992,-0.0007432057,0.0007371628,-0.0060921065,-0.01037276,0.0005193444,-0.0030855055,0.0014788089,-0.00031088968,0.0069434973,5.7206616e-05,0.0030834489,0.009016123,0.006109712,0.0005314793,0.0035560678,-0.001246396,-0.003793728,-0.0057486696,0.0022852358,-0.0012469108,-0.0031857986,1.80808e-05,-0.0019273473,0.0009391922,-0.0039568087,0.011933056,0.0019077867,-0.00053529005,-0.00048404737,0.00472079,0.011849065,-0.009346756,-0.019408464,-0.0046010357,0.0076590604,0.0027862561,0.0038115256,0.009264085,0.001289043,0.0035797064,-0.0013150043,-0.00033033235,-9.906489e-05,-0.006770053,-0.0129271345,-0.005608295,0.00047057797,-0.0008927652,0.0023299279,0.010711831,0.0027379333,-0.00044528418,-0.001112287,-0.007603451,0.00068844267,0.0059512705,0.0009653477,-0.003543581,-0.00053850684,0.0009313345,-0.0012446969,-0.000106237436,0.00080742623,-9.257026e-05,-0.0013961215,0.0017188011,-0.006939865,-0.0028673585,-0.008345597,-0.003638542,-0.00019568259,-0.0048321835,0.01067651,-8.424402e-05,0.0078111687,0.0031834075,-0.0026165836,0.0016076061,0.0032815367,0.0060593016,-0.005943524,-0.000203445,0.0007561224,-0.0180221,0.0025537205,0.0075283074,0.004564579,0.0011741471,-0.0089896,0.0062503344,0.0071104565,0.013728878,-0.008489788,0.0034554289,0.0027810007,-0.0022375376,0.012856555,-0.00620322,0.003944247,0.0008179983,0.0011418152,-0.006622474,0.00049234246,0.0053584473,0.0043076626,0.0022234672,0.00069471076,-0.003371687,0.00078102585,-0.0022959656,-0.01067306,-0.00019265997,0.010819382,0.0023516244,-0.0015299403,1.6551487e-05}, {5,5,5,5,2,6,6,5,6,4,5,1,2,6,4,5,5,1,1,4,4,8,2,6,5,8,0,6,2,7,0,8,0,255,3,0,255,1,6,6,255,1,8,255,255,0,2,6,255,255,0,255,0,8,1,6,1,1,1,0,0,0,4,5,6,255,5,8,5,8,8,8,255,255,4,4,255,4,0,255,8,8,8,0,0,8,8,255,255,255,255,8,8,8,8,5,255,8,8,8,8,7,0,0,2,2,5,2,1,6,5,8,7,5,7,8,0,8,0,8,8,0,8,8,255,5,7,2,8,8,5,8,8,2,8,255,255,255,8,0,0,8,8,8,7,0,5,255,255,255,8,1,4,8,8,0,255,0,5,8,255,8,0,255,255,255,255,8,0,8,8,8,7,1,4,8,3,2,2,8,8,255,255,8,5,7,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,65535,67,69,65535,71,73,75,65535,77,79,65535,65535,81,83,85,65535,65535,87,65535,89,91,93,95,97,99,101,103,105,107,109,111,113,65535,115,117,119,121,123,125,65535,65535,127,129,65535,131,133,65535,135,137,139,141,143,145,147,65535,65535,65535,65535,149,151,153,155,157,65535,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,65535,213,215,217,219,221,223,225,227,229,231,65535,65535,65535,233,235,237,239,241,243,245,247,249,65535,65535,65535,251,253,255,257,259,261,65535,263,265,267,65535,269,271,65535,65535,65535,65535,273,275,277,279,281,283,285,287,289,291,293,295,297,299,65535,65535,301,303,305,307,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,65535,68,70,65535,72,74,76,65535,78,80,65535,65535,82,84,86,65535,65535,88,65535,90,92,94,96,98,100,102,104,106,108,110,112,114,65535,116,118,120,122,124,126,65535,65535,128,130,65535,132,134,65535,136,138,140,142,144,146,148,65535,65535,65535,65535,150,152,154,156,158,65535,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,65535,214,216,218,220,222,224,226,228,230,232,65535,65535,65535,234,236,238,240,242,244,246,248,250,65535,65535,65535,252,254,256,258,260,262,65535,264,266,268,65535,270,272,65535,65535,65535,65535,274,276,278,280,282,284,286,288,290,292,294,296,298,300,65535,65535,302,304,306,308,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4456,3318.5,5322.5,4838.5,3890,6530.5,5415.5,4131.5,5054.5,3295,4929.5,7517.5,6795.5,5162.5,5555.5,3979,3161,5064.5,4.5,20.5,3563.5,6725,9055,5285.5,6989,0.012109543,4437.5,8852.5,6408,5524.5,1439,4060.5,4042.5,4489.5,6671.5,18.5,-0.013584386,6910.5,4602,3443.5,279,14.5,15.5,4773.5,6047,18.5,9108.5,7260.5,4828.5,5,1.5,1.5,8876.5,5851,10993.5,5958,8462.5,6950.5,5470,7062.5,6235.5,3314.5,18.5,4788.5,-0.021830823,12,-0.006331245,16.5,7.5,3242,4024.5,2.5,5079,15.5,1153,19.5,18.5,21.5,4680,3894.5,4148.5,4459,4277.5,6355.5,-0.012395719,-0.017066253,5.5,7153,6479.5,-0.008206369,4312,6432,-0.016234307,2.5,6161,3,16,-0.0006507149,6299,10149,7317.5,9436.5,6743,8.5,5094,0.0023520186,17.5,2.5,0.007752772,-0.0038698853,5502,6681.5,5771,6007.5,5749,370.5,1422,6808,6782.5,3766,3423.5,5710,3967,4073,5042.5,8,18.5,5328,4287.5,8095.5,15.5,15.5,17.5,-0.008517392,-0.001476873,4244,2378.5,5714.5,2.5,2816,9167,20.5,5228.5,3593,-0.008960855,17.5,4792.5,0.004658369,0.019429158,3694,0.0038139024,4,0.0103749605,17.5,3989.5,3.5,6.5,0.011741236,17,6209,16.5,6752,8176,4316,7492.5,5230.5,0.01679901,11529.5,21.5,4902,5913,6433,4.5,15.5,7178.5,0.003674914,0.00089179183,13,0.00013164847,-0.023857279,-0.014724793,-0.024813963,-0.0071193236,5.5,11616,7694,-0.01015302,18.5,5804.5,5794.5,5520.5,0.0042812726,0.0108354725,2.5,5123,-0.0050572283,12,2.5,7.5,5344.5,2.5,6985,-0.013713931,7.5,0.004615087,1.5,5711,1.5,-0.013183891,11242,-0.014195457,5879,5914.5,6772,6804.5,1.737727e-05,0.00076442043,-0.008887291,0.0005013726,-0.00026452137,0.004215561,-0.003664994,0.017760051,-0.0027973622,-0.0059899897,0.0041429005,0.0015562241,0.0012507777,0.006408483,-0.00023856798,-0.0038705976,0.005968012,0.0012867799,0.016631618,0.0050292136,-0.0020319095,0.0042403867,-0.004567196,-0.0015835507,-0.0028242122,-0.005280229,-0.0017814925,0.0011553749,-0.010982327,4.3181895e-05,0.0033693418,-0.0018186503,0.007524957,0.0037885339,-0.00042271984,0.0020578275,-0.00019597707,-0.003807177,0.00020822677,-0.005517122,-0.0012057304,-0.0067868563,0.0016754257,-0.0005088022,0.0042144307,0.0008924515,0.00018537849,-0.007838568,-0.0018822848,0.010850509,0.00096505444,-0.00043059542,0.002025543,0.005753774,0.0017723627,-0.003878339,0.004163129,0.0016316673,0.004343823,0.0012789671,0.0008499102,-0.004803266,0.00024766938,-0.00011359029,-0.00017829011,-0.013528253,0.001819251,0.004593308,0.006821602,0.00016803193,-0.003191694,-0.0006590923,0.001858781,-0.002707494,0.012986495,0.0034440104,-0.0040164716,0.0031505849,0.0005211375,0.0018535281,-0.0007720014,0.002333727,-0.00218577,-0.0005633088,0.009701502,-0.00073522347,-0.006819115,-0.025591543,-0.0015497531,-0.008927401,0.0020105036,-0.0013598708,0.00991434,0.0027460798,-0.0006068926,-0.0028716258,0.0029982869,0.005398672,-0.004213492,-0.000870767,0.004425019,0.0010756374,-0.00088531786,0.0012272535,-0.0066949143,-0.00066176325,0.0057900175,-6.5769644e-05,0.006996603,0.0006315959,0.00024145399,-0.0010966057,0.0003463968,-0.0002582182,0.0018084514,-0.0010242881,-0.000101440004,-0.0018016065,0.00082440575,-0.0004227096,0.0011496375,-0.004035638,0.0016292584,0.0056778644,0.002004683,-0.0022797238,-0.0018750789,-0.0050283014,0.0019700062,-0.017477704,-0.006329109,-0.0024010164,0.0045736814,-0.004656554,-0.00010432126,-0.0035763346,0.0006523654,-0.0020940222,0.00085203315,0.0053035347,-9.660557e-06,-0.0034688048,0.0038016618,2.8866748e-06}, {6,7,6,2,1,5,6,2,2,4,4,1,5,3,6,2,5,3,8,8,7,0,1,6,0,255,7,0,0,6,0,3,3,2,4,8,255,2,3,6,0,8,8,4,2,8,1,3,7,8,8,8,5,1,0,0,0,4,7,6,6,7,8,0,255,8,255,8,8,1,0,8,4,8,6,8,8,8,7,0,2,2,0,0,255,255,8,4,3,255,7,1,255,8,0,8,8,255,2,0,0,3,2,8,7,255,8,8,255,255,2,2,3,3,7,1,0,7,6,4,0,1,0,2,1,8,8,1,2,4,8,8,8,255,255,4,7,1,8,1,4,8,1,3,255,8,7,255,255,6,255,8,255,8,0,8,8,255,8,0,8,1,0,6,0,4,255,0,8,6,2,0,8,8,0,255,255,8,255,255,255,255,255,8,0,3,255,8,0,0,1,255,255,8,2,255,8,8,8,3,8,0,255,8,255,8,0,8,255,3,255,7,6,3,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,65535,51,53,55,57,59,61,63,65,67,69,65535,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,65535,125,65535,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,65535,65535,161,163,165,65535,167,169,65535,171,173,175,177,65535,179,181,183,185,187,189,191,65535,193,195,65535,65535,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,65535,65535,243,245,247,249,251,253,255,257,259,65535,261,263,65535,65535,265,65535,267,65535,269,271,273,275,65535,277,279,281,283,285,287,289,291,65535,293,295,297,299,301,303,305,307,65535,65535,309,65535,65535,65535,65535,65535,311,313,315,65535,317,319,321,323,65535,65535,325,327,65535,329,331,333,335,337,339,65535,341,65535,343,345,347,65535,349,65535,351,353,355,357,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,65535,52,54,56,58,60,62,64,66,68,70,65535,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,65535,126,65535,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,65535,65535,162,164,166,65535,168,170,65535,172,174,176,178,65535,180,182,184,186,188,190,192,65535,194,196,65535,65535,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,65535,65535,244,246,248,250,252,254,256,258,260,65535,262,264,65535,65535,266,65535,268,65535,270,272,274,276,65535,278,280,282,284,286,288,290,292,65535,294,296,298,300,302,304,306,308,65535,65535,310,65535,65535,65535,65535,65535,312,314,316,65535,318,320,322,324,65535,65535,326,328,65535,330,332,334,336,338,340,65535,342,65535,344,346,348,65535,350,65535,352,354,356,358,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({8422.5,8840.5,8639.5,7765.5,6490.5,6509.5,8750,6645,7368,316,7879,5948.5,7255.5,8417,8781,6614.5,7763.5,7315,7741,13.5,30287.5,4.5,8630.5,5527,5.5,8497,8419,6834.5,9988.5,8776,4533.5,5888.5,6633,6505,6329.5,9195.5,0.021310925,7986,8817,0.004804551,-0.0009656727,3044.5,17.5,7856.5,6001,19.5,15.5,4953,-0.027686715,2.5,11.5,0.0087604625,18.5,2.5,1.5,8732.5,2.5,12.5,19.5,5.5,-0.014639841,3712.5,4780.5,4941,4914.5,6487.5,6.5,17.5,7110.5,6819,7480.5,7163,6950,1.5,7660.5,7138,10886,2886,25460.5,12.5,3168.5,7698,9260.5,15,8908.5,4.5,7923.5,9763,0.0042082197,7266.5,4644.5,1.5,8532,0.0039809556,16,5521,9618.5,-0.008952698,-0.020149613,-0.03437042,9904,1770,3898.5,0.0019769592,8677,8807,8966,0.01212313,0.0062982053,7176.5,8755,2259,8367,4749.5,5139,4583.5,5435,4899,10866,-0.01946555,-0.010664508,0.0015654194,-0.0042588958,12.5,5636.5,1.5,7977,6496,0.03191604,8154.5,1.5,15.5,5690,1.5,9914,8938,7408,8366.5,2.5,-0.011104381,2.5,-0.013551091,16,32102,17.5,17.5,18.5,2.5,3124,18.5,18.5,9133.5,1.5,-0.0044930577,6572.5,12.5,0.0066778744,-0.0049691377,15.5,0.008511848,15.5,0.003200074,0.0014505902,13,4,6156,7711,7,8536.5,-0.0057477094,-0.0025831102,3.5,8679,7894.5,0.006411453,5,6.5,-0.012189202,0.00021857247,8485.5,-0.0035644998,5,8659,11.5,-0.010187505,-0.0030357118,-0.009742797,9395.5,9760,16.5,7082.5,-0.008532084,-0.001633275,-0.006696231,3338.5,8843,12.5,3893,8578.5,9084,28017,5181,5232,1.7564398e-05,-0.0021446699,0.0031565186,0.00034047678,-0.0009295011,0.006231302,-0.0035688567,0.0053438614,0.0027059542,-1.6831073e-05,-0.003070054,0.008651653,0.009036385,-0.0060711186,0.003022328,-0.0061413725,0.0052002366,-0.007700993,0.0011281483,-0.012647204,-0.007421755,0.0077546905,0.0011040353,0.005364444,6.758912e-05,-0.006000526,0.0028886837,1.14305085e-05,0.021061467,0.004663046,0.0055451575,-0.032303926,-0.014232891,0.0013612057,-0.009201772,-0.0014720223,-0.006442483,-0.021699598,-0.013733457,-0.034173977,-0.0067994925,-0.0027107068,-0.00041777315,0.0017775486,-0.0011620421,-0.0051885834,-0.00035226066,0.0010889258,0.0010905414,0.0031424803,-0.0038088919,-0.0013517754,0.006409917,-0.0003902608,0.0016823538,-0.009470925,-0.0066892947,0.0015771901,0.0017790953,0.0032575123,0.0076780715,0.0048055956,0.0026482986,-0.0012351805,0.004937352,0.0010693412,0.00035153245,0.0015037708,0.00487867,0.007477227,0.0027736311,0.0007475297,0.0011397008,0.0005243104,-0.0009041465,-0.004196538,0.004630264,-4.9840706e-05,-0.0035578539,-0.007331682,-0.0011109604,0.004109904,0.00023567256,0.00084477477,-0.00028356878,-1.06659e-05,0.0052518095,0.015131331,-0.0018045964,0.0010351111,-0.005409271,-0.0025718173,-0.007195262,-0.010622379,-0.009773901,-0.0022882398,-0.0016486634,0.0019139983,0.00041301988,-1.9107938e-05,-0.00011318371,-0.0038926804,0.0025428326,0.004367584,0.012992953,0.0068658697,-0.005886962,0.002565923,0.004219664,0.0005866976,-0.0064117312,-0.0017648764,0.00039494663,-0.0005941749,-0.0041905013,-0.00029368678,-0.016127309,-0.0024205723,0.006031261,0.00046904097,0.007829887,-0.0006179191,0.00019709543,-0.0057838946,0.0043668947,-4.119987e-05}, {2,3,2,1,4,5,2,1,2,4,0,1,6,4,2,1,2,2,5,8,1,8,0,1,8,2,4,5,0,2,5,1,1,0,7,1,255,3,4,255,255,6,8,6,6,8,8,5,255,8,8,255,8,8,8,2,8,8,8,8,255,5,3,5,5,0,8,8,0,0,0,0,6,8,6,6,0,6,1,8,6,2,7,8,3,8,0,0,255,6,1,8,0,255,8,0,0,255,255,255,4,7,0,255,2,6,4,255,255,7,2,7,4,1,3,5,5,3,4,255,255,255,255,8,0,8,5,0,255,2,8,8,2,8,0,0,2,3,8,255,8,255,8,5,8,8,8,8,6,8,8,3,8,255,0,8,255,255,8,255,8,255,255,8,8,0,6,8,2,255,255,8,0,0,255,8,8,255,255,2,255,8,2,8,255,255,255,4,0,8,0,255,255,255,3,0,8,5,0,2,0,7,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,65535,73,75,65535,65535,77,79,81,83,85,87,89,65535,91,93,65535,95,97,99,101,103,105,107,109,65535,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,65535,165,167,169,171,65535,173,175,177,65535,65535,65535,179,181,183,65535,185,187,189,65535,65535,191,193,195,197,199,201,203,205,207,209,65535,65535,65535,65535,211,213,215,217,219,65535,221,223,225,227,229,231,233,235,237,239,65535,241,65535,243,245,247,249,251,253,255,257,259,261,263,65535,265,267,65535,65535,269,65535,271,65535,65535,273,275,277,279,281,283,65535,65535,285,287,289,65535,291,293,65535,65535,295,65535,297,299,301,65535,65535,65535,303,305,307,309,65535,65535,65535,311,313,315,317,319,321,323,325,327,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,65535,74,76,65535,65535,78,80,82,84,86,88,90,65535,92,94,65535,96,98,100,102,104,106,108,110,65535,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,65535,166,168,170,172,65535,174,176,178,65535,65535,65535,180,182,184,65535,186,188,190,65535,65535,192,194,196,198,200,202,204,206,208,210,65535,65535,65535,65535,212,214,216,218,220,65535,222,224,226,228,230,232,234,236,238,240,65535,242,65535,244,246,248,250,252,254,256,258,260,262,264,65535,266,268,65535,65535,270,65535,272,65535,65535,274,276,278,280,282,284,65535,65535,286,288,290,65535,292,294,65535,65535,296,65535,298,300,302,65535,65535,65535,304,306,308,310,65535,65535,65535,312,314,316,318,320,322,324,326,328,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({51.5,46,62,78,48.5,26.5,24,28.5,58.5,18.5,17.5,6.5,406,12.5,26.5,27.5,87.5,13611,42,2.5,30.5,16.5,20.5,4.5,12.5,5.5,127,73,3229.5,131.5,53,65.5,28.5,24,118,15.5,27038,14.5,4.5,0.015573278,7,20.5,-0.005612959,12.5,0.005654396,19.5,0.0053495406,-0.011582867,-0.031062832,-0.0046604904,-0.011863339,28.5,31.5,20,17.5,7.5,120.5,461.5,18.5,110,31593,-0.007458936,646,27.5,15.5,14.5,15.5,15.5,34.5,13.5,1118.5,65,313,15.5,14.5,3.5,38,2.5,6.5,30.5,0.007895166,0.0039088465,-0.0003312389,4948,40,40,-0.0022834935,23.5,55.5,12.5,8.5,15.5,34,423,21.5,77.5,52,4.5,6.5,26.5,18.5,6332,6332,49,2.5,340.5,15,565.5,686,72,20.5,29.5,20.5,-0.006582606,20.5,6.5,20,0.006842527,0.010546531,3.5,27,4.5,21.5,221,1986.5,5.5,82.5,43,513.5,0.004117625,18.5,0.00010452549,-0.0032461763,38,82.5,19.5,17.5,-0.0011594506,0.010289309,16468.5,12.5,4.5,5.5,4.5,9,-0.0029533054,15,-0.002036198,-0.005274162,40.5,3.5,3.5,58.5,123,52,33.5,78,2.5,17.5,21.5,21.5,185,4779.5,2510,3887,52,113,186.5,-0.0024206864,0.009292386,7,3248,429,14.5,20.5,15,0.021110063,0.00417895,17.5,-0.008417156,0.00053999457,6.5,15,-0.0026238628,-0.009667742,19,17.5,4.5,17.5,1980,19,381.5,871.5,-0.000107779495,0.0012604363,-0.002026639,0.005556719,0.0020650742,-0.0020653568,0.005655793,-8.7426095e-05,-0.002102312,-0.004731923,-0.00031316472,0.0031950555,-0.0013383805,0.0011507315,-0.0016768726,0.003441063,-0.013647238,0.00043801792,-0.0014694217,-0.0055902502,-0.012113548,-0.0043525053,-0.0012126593,-0.0040712184,0.005804352,-0.0016511586,-0.01231715,-0.0044303127,0.0018610483,-0.0044166953,-0.0022664624,-0.011739721,-0.0009302241,-0.0057457434,0.0010800296,0.00023192131,-0.003056863,0.0013236868,0.005084862,0.0020587684,0.004429412,0.001133613,-3.2792967e-05,-0.003229993,-0.015746756,-0.0019359147,0.0004219027,-0.0025065022,0.0005427482,-0.0021891023,-0.00039599143,0.0020780659,0.0033497424,0.002266703,0.0006837036,0.002343702,0.001284951,-0.0012869122,-0.0017281479,0.0032506136,-0.0007391901,-0.0044185026,0.0013021472,0.005203349,0.0005079691,-0.00038123337,-0.009782537,-0.0033694468,-0.007993636,0.00037182836,0.004889197,-0.0013721313,-0.004207203,-0.0022627853,-0.00043694323,0.0030712176,0.011062773,0.0011792957,-0.005769873,-0.0015440029,-0.00046632905,0.0009792843,-0.0034067486,0.002617777,-0.001959281,0.000662904,-0.006934244,-0.00092826254,-0.0034710502,0.008108455,-0.0007349631,0.0010712331,-0.012369417,-0.0028766932,0.001946132,-0.0029763351,0.00071634393,0.0054237773,0.003538473,0.00060993544,-0.0022453386,0.0017965849,-0.006194438,-2.5862546e-05,0.002625368,0.0008412422,-0.0018664071,0.0006784989,-0.002292838,-0.00052889454,-0.002090277,-0.00042870865,-0.0045039305,-0.010600423,0.001811852,-0.008738039,-0.0040319622,0.0013388022,0.005914443,0.0020559959,-0.0028021873,0.00022666031,-3.5523328e-05,0.0017458994,0.00381132,0.030144641,-0.011602587,-0.0027974881,-0.0012543298,-6.537844e-07}, {2,2,0,0,0,3,7,0,6,8,8,8,6,8,7,0,6,0,2,8,0,8,8,8,8,8,2,3,0,3,2,4,2,1,7,8,0,8,8,255,8,8,255,8,255,8,255,255,255,255,255,1,3,8,8,8,0,0,8,2,3,255,0,3,8,8,8,8,4,8,6,1,0,8,8,8,4,8,8,0,255,255,255,4,4,4,255,1,1,8,8,8,0,2,8,2,6,8,8,4,8,0,0,3,8,0,8,1,0,6,8,2,8,255,8,8,8,255,255,8,1,8,8,6,6,8,1,1,0,255,8,255,255,4,1,8,8,255,255,0,8,8,8,8,8,255,8,255,255,3,8,8,0,4,4,3,3,8,8,8,8,2,5,3,7,6,0,0,255,255,8,4,0,8,8,8,255,255,8,255,255,8,8,255,255,8,8,8,8,5,8,5,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,65535,79,81,65535,83,65535,85,65535,65535,65535,65535,65535,87,89,91,93,95,97,99,101,103,105,65535,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,65535,65535,65535,143,145,147,65535,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,65535,201,203,205,65535,65535,207,209,211,213,215,217,219,221,223,225,65535,227,65535,65535,229,231,233,235,65535,65535,237,239,241,243,245,247,65535,249,65535,65535,251,253,255,257,259,261,263,265,267,269,271,273,275,277,279,281,283,285,287,65535,65535,289,291,293,295,297,299,65535,65535,301,65535,65535,303,305,65535,65535,307,309,311,313,315,317,319,321,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,65535,80,82,65535,84,65535,86,65535,65535,65535,65535,65535,88,90,92,94,96,98,100,102,104,106,65535,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,65535,65535,65535,144,146,148,65535,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,65535,202,204,206,65535,65535,208,210,212,214,216,218,220,222,224,226,65535,228,65535,65535,230,232,234,236,65535,65535,238,240,242,244,246,248,65535,250,65535,65535,252,254,256,258,260,262,264,266,268,270,272,274,276,278,280,282,284,286,288,65535,65535,290,292,294,296,298,300,65535,65535,302,65535,65535,304,306,65535,65535,308,310,312,314,316,318,320,322,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({8291,8285.5,8644.5,18.5,8111.5,7282.5,8351.5,15.5,9430.5,17.5,2.5,7323,8398.5,5106.5,9998,6524.5,1731,4010.5,9445.5,15,0.004626794,-0.0030641423,13.5,6840.5,1.5,534,9718,4147,8705,6935.5,8861,6496.5,6531.5,987.5,6443,880,581,-0.0125535,7930.5,11.5,-0.00032421184,0.017135737,0.008191874,8.5,6936,0.004164775,7061,18.5,6962,-0.027224133,7488,22912.5,-0.017266843,10249.5,9718.5,6904.5,9803.5,15.5,7073.5,6719.5,7086.5,11466.5,8492.5,1023.5,5554,2300.5,6242.5,1050,1139,6332,3147.5,3290,13796.5,-0.0016309656,-0.0057923547,7787.5,6382.5,7028.5,-0.017092634,-0.01857968,-0.0064175995,1.5,903,4.5,15.5,6263,13308,21.5,17.5,9833,3.5,8249,8050,6846,10821,8278.5,29276.5,12481,18.5,5909.5,11034.5,63.5,6786,9749,0.008570192,0.014837787,7,8420,9653.5,459.5,913,1784.5,16.5,2834,3682.5,6005,7478,887.5,330,809.5,788.5,7664,20.5,6062,4622.5,2908,3346,6454,19443.5,2.5,3.5,17,8100,-0.0023592114,-0.0057192417,0.0032700014,4.5,435,-0.007844533,2.5,16,12.5,6924,7.5,0.009092156,8622.5,20226.5,5.5,21984,32006,18.5,5933.5,0.015085341,0.0023175417,-0.0050012614,8190.5,6835,12.5,15.5,6689.5,-0.010660704,0.009523275,0.0011783658,8633,1.5,8127,1.5,12.5,12.5,8635,11441.5,11193.5,30995,10769,2.5,0.00088520563,-6.452521e-07,-0.006663952,-0.00053795957,-0.0074912156,0.0003947288,0.00052649627,0.00273969,1.1796914e-05,-0.016273962,0.010339686,0.0004346795,0.00092754944,-0.0026342766,0.011157068,0.0027571053,-0.0032228031,-0.0080571715,-0.0030407223,0.00021078163,-0.002193448,0.003732375,0.0053001507,0.0015457011,0.0075087175,0.0008617242,-0.0028165902,-0.00024172539,-0.0005663396,-0.017592195,-0.00013450284,0.009528443,0.0070149857,-0.014217079,-0.0048095165,-0.00049676065,-0.004021281,-0.012080564,0.00215752,0.0002490754,0.00834081,0.0007556746,-0.00080356747,0.0011707254,-0.0010262824,0.0025067558,-0.005263836,-0.0013666656,0.001147069,0.005722407,-0.0013371207,0.0025138254,-0.0061800587,0.00029273296,0.006626115,-0.0018460306,0.00031317622,0.0011833683,-0.001623804,-0.004140181,-0.00032452616,0.0006100239,6.577939e-05,-0.0021710973,0.002962106,0.0012893612,-0.0018024043,0.0012942719,0.0030081915,-0.0015364884,0.0028730659,0.0055068056,0.0012649511,-0.00047482844,-0.0026494719,-0.0073868553,-0.00056746433,0.0063502677,-0.00089538936,0.00063243863,0.004579046,-0.0011069577,0.00041556233,-0.0015479259,-0.010035162,-0.00065415766,0.0008117836,0.006017012,0.0012171083,0.008298903,-0.00057164807,-0.011788566,0.008172122,0.0029326733,0.0012896619,0.0036387492,0.0007556043,-0.010010726,-0.00485041,-0.01634478,0.008201512,-0.019024849,-0.0023774528,0.0012033348,-0.0017818132,-0.009073166,0.0009330165,-0.0006566456,0.0043216436,0.0010674371,0.002891885,0.000804556,0.0028936586,0.004274928,-0.0067055314,0.00042578692,0.0034559236,-0.005490459,3.3078057e-05,-0.0012817917,0.0004469575,-4.6407986e-05}, {5,5,5,8,0,1,4,8,0,8,8,7,0,0,5,3,1,3,0,8,255,255,8,1,8,6,0,0,5,3,4,3,3,2,7,7,7,255,7,8,255,255,255,8,0,255,0,8,4,255,3,7,255,0,5,2,4,8,1,5,1,0,4,3,2,4,6,0,7,0,7,5,6,255,255,3,0,1,255,255,255,8,2,8,8,2,3,8,8,0,8,4,2,2,0,1,0,3,8,1,5,2,5,0,255,255,8,4,2,1,0,6,8,5,0,4,6,0,7,1,2,2,8,0,5,5,3,2,4,8,8,8,4,255,255,255,8,2,255,8,8,8,2,8,255,1,1,8,7,3,8,0,255,255,255,4,0,8,8,3,255,255,255,7,8,7,8,8,8,4,7,5,4,7,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,65535,65535,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,65535,71,73,65535,65535,65535,75,77,65535,79,81,83,65535,85,87,65535,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,65535,65535,129,131,133,65535,65535,65535,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,65535,65535,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,65535,65535,65535,235,237,65535,239,241,243,245,247,65535,249,251,253,255,257,259,261,65535,65535,65535,263,265,267,269,271,65535,65535,65535,273,275,277,279,281,283,285,287,289,291,293,295,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,65535,65535,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,65535,72,74,65535,65535,65535,76,78,65535,80,82,84,65535,86,88,65535,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,65535,65535,130,132,134,65535,65535,65535,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,65535,65535,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,65535,65535,65535,236,238,65535,240,242,244,246,248,65535,250,252,254,256,258,260,262,65535,65535,65535,264,266,268,270,272,65535,65535,65535,274,276,278,280,282,284,286,288,290,292,294,296,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({18.5,7774.5,7708,6395,7915.5,8943.5,14610.5,6309.5,7279.5,7911,12708,3971.5,9046,7999,17605.5,16.5,6756.5,6499.5,9604.5,7795,-0.019776545,7943.5,8021.5,1013.5,5600.5,10897,6713,6655,22,17467.5,21732.5,17419.5,1948,6324,9921.5,1.5,6192.5,6493,9792.5,3,1.5,7900.5,13115.5,7985,21766.5,1348.5,1118.5,1554,8211.5,4754,8306.5,17047.5,12485,7982.5,8866,-0.009745694,8066,17260.5,17523.5,16328.5,30086,2.5,17765,830.5,8455,5703.5,12792.5,9859.5,7882.5,6153.5,7759.5,7000.5,5025,5880.5,8285,6647,9604,0.001379462,-0.013494319,7997,7935.5,7851.5,4.5,6851.5,13439,4.5,13743.5,7.5,22484,1011.5,2534.5,1061,1199.5,0.014854135,5493.5,9098.5,3594,-0.014763757,8964,0.0048015425,-0.0032002446,10092,18291,9769.5,7290,5396.5,8065,7975,9832,7114,8075,19784,22104.5,17501.5,17597,20171.5,21711,25886,24719,5644.5,7.5,4.5,5245.5,692.5,1814.5,8133,6308,13,6341,6199,-0.010398014,7198,6652,3,8546,7249,0.01758158,12385,7834,5317.5,7412,0.008184793,9308.5,7296,8546,8427,7588,7.5,4.5,4.5,11692.5,0.0016743172,7863,8167.5,7994,5628.5,7884,0.009160215,9050.5,6795.5,7914.5,10227.5,0.0069242204,8171.5,7146,12.5,21990,15457,15118,16533,14379.5,457,0.01704492,1323,2796.5,853.5,6602.5,1837.5,1390.5,5477.5,5433.5,4780,9295.5,-0.009212004,7985.5,-0.0032598227,-0.008106542,9501.5,8847.5,3999,4620,6563,6350.5,6593.5,21990,0.0056904107,6738,-0.010102189,9720,6938,10642,-0.0023087051,0.0005709368,5872,7424.5,0.015249326,8781,13218,14782.5,17506,-0.0066724205,0.003330143,0.008789203,16603.5,22562.5,0.011133795,16144,23067.5,0.0098032905,26134.5,21295,24767.5,24802.5,-0.00020677818,-0.00290573,0.00033998498,-0.00011995201,0.011504461,0.0036228064,0.00042181322,0.0025122038,-0.0004426299,0.0023996602,-0.0034709354,-0.012703096,0.0015332854,0.0037474842,0.00058235106,-0.0011332104,0.0011750808,-0.00067477627,-0.0054868986,-0.011675271,-0.001336751,0.0030021935,-0.00791579,-0.016407533,0.0033273257,0.0004884258,-0.0036417549,-0.011367197,0.0033047714,-0.0012071406,0.0033235934,-0.0012555787,0.0013146189,-0.0072058286,-0.016525622,-0.0006050746,-0.009507469,-0.0012995512,0.024900943,0.0008134818,-0.007186737,0.0011967486,0.005914893,2.380561e-05,-0.010873566,-0.0011777211,0.0054329853,0.012579791,-0.0130680045,-0.0019215684,0.0006816107,0.005768826,-0.009757734,-0.0039844047,-0.0066423537,-0.0014468243,0.0018278748,-7.652026e-05,-0.00950947,-0.024455553,0.001447571,-0.003246915,-0.0090347715,-0.0014636818,-0.00029261093,0.001467517,-0.014221966,-0.0020315398,-0.00092339993,0.0046295025,1.6829477e-05,0.008295773,-0.0062100356,-0.00072912086,0.003498107,0.0009225781,-0.0034469776,0.0037997372,0.00052771723,-0.003079844,0.0061165853,0.001885859,-0.0023097713,0.003032466,-0.0025316654,0.0011103011,0.0024298213,0.00018813458,-1.5667894e-05,-0.0038870142,-0.00074170943,0.00013652287,6.879594e-05,-0.0030906491,-0.015663994,0.009674581,-0.016793592,0.00034211774,-0.008512179,-0.03478073,-0.013351767,0.0014073238,0.01505576,-0.00848557,-0.0047776634,-0.00086310523,-0.0016624973,0.001816933,-0.008445854,0.009677873,0.003314256,-0.0031827108,0.015911149,0.0024483255,0.0068273507,-0.003131317,0.001179323,-0.0020928506,-0.0060146633,0.0007647984,-0.0026524717,-0.0072928197,0.00048049306,-0.0031215518,-0.0023631358,0.008195374,-0.006670279,-0.0029876672,-0.0011119667,0.004966249,-0.0008594446,0.002290434,-0.002448447,0.0036779668,0.0012406037,-0.0041072387,0.013252257,0.007969674,-0.0024163432,0.0058522555,-0.0017145723,-0.017614698,0.0021079916,-0.00054945424,-0.0001385986,0.0010550095,-0.0009992893,-0.0021489873,-0.00016182043,0.0056725363,-0.0010579672,-0.003303948,-0.0017123088,-0.010179862,0.005452566,-0.0006696232,0.0015997334,0.0063607777,-0.00046792027,0.0027848775,-0.0058956,0.00049114984,0.004936974,-0.0002880024,-0.00088396406,-0.0024590665,0.001091624,0.00022753699}, {8,1,3,1,1,2,2,1,0,1,6,3,2,3,7,8,5,0,4,1,255,0,3,7,3,6,5,1,6,1,0,2,2,2,6,8,6,3,0,8,8,0,7,7,6,2,7,6,2,1,0,2,2,7,4,255,3,1,1,5,7,8,2,3,2,0,6,2,3,0,2,4,4,7,7,1,6,255,255,0,2,0,8,3,3,8,7,8,6,7,2,1,6,255,3,1,6,255,2,255,255,6,6,4,5,0,7,1,0,4,3,5,2,1,6,0,0,6,4,1,8,8,1,6,6,0,7,8,4,7,255,3,0,8,0,1,255,6,2,4,5,255,3,1,6,6,0,8,8,8,0,255,1,0,0,6,0,255,1,3,3,2,255,1,3,8,2,6,0,3,7,7,255,0,2,1,0,0,4,0,4,6,0,255,1,255,255,0,0,1,3,7,3,7,2,255,6,255,7,6,0,255,255,4,2,255,2,5,7,0,255,255,255,6,6,255,1,7,255,0,2,2,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,65535,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,65535,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,65535,65535,151,153,155,157,159,161,163,165,167,169,171,173,175,177,65535,179,181,183,65535,185,65535,65535,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,65535,245,247,249,251,253,65535,255,257,259,261,65535,263,265,267,269,271,273,275,277,279,65535,281,283,285,287,289,65535,291,293,295,297,65535,299,301,303,305,307,309,311,313,315,65535,317,319,321,323,325,327,329,331,333,335,65535,337,65535,65535,339,341,343,345,347,349,351,353,65535,355,65535,357,359,361,65535,65535,363,365,65535,367,369,371,373,65535,65535,65535,375,377,65535,379,381,65535,383,385,387,389,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,65535,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,65535,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,65535,65535,152,154,156,158,160,162,164,166,168,170,172,174,176,178,65535,180,182,184,65535,186,65535,65535,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,65535,246,248,250,252,254,65535,256,258,260,262,65535,264,266,268,270,272,274,276,278,280,65535,282,284,286,288,290,65535,292,294,296,298,65535,300,302,304,306,308,310,312,314,316,65535,318,320,322,324,326,328,330,332,334,336,65535,338,65535,65535,340,342,344,346,348,350,352,354,65535,356,65535,358,360,362,65535,65535,364,366,65535,368,370,372,374,65535,65535,65535,376,378,65535,380,382,65535,384,386,388,390,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({39.5,98.5,202.5,126,107.5,8.5,189.5,75,29,154,86,188.5,91,2664.5,26.5,132.5,4.5,15.5,6.5,24.5,7.5,25.5,15.5,22,6135,78,35,-0.007803512,4.5,26.5,734.5,22.5,-0.00734303,47.5,49.5,1367,17.5,29.5,20.5,15.5,76.5,4.5,17,1280,30.5,109,109,4.5,122.5,2.5,67,20.5,110,147.5,5373.5,0.0055171386,13,18.5,20.5,597,779.5,26,2.5,3.5,56.5,-0.01477418,6.5,-0.0044845114,1.5,0.0010787677,4228,4,3.5,15.5,67,150.5,20.5,45.5,4.5,0.0007930905,-0.0074403747,0.006663631,0.0022143747,2.5,21.5,1.5,20.5,8.5,6.5,0.0033564586,87,2.5,0.00034242708,6.5,120.5,329.5,374.5,2,0.004980556,32.5,70,107.5,101,19.5,-0.010995088,15.5,12,-0.0071756863,19,2,426,3927,15373.5,438,20.5,18.5,257,10.5,-0.0138035985,27.5,12.5,49.5,0.006441237,170.5,-0.0002696431,37,15.5,0.004892472,12,93.5,21,69,-0.0019070512,0.000477523,0.0033567946,29.5,18.5,29.5,21.5,8.5,0.001391855,-0.0054600164,-0.0014427332,6.5,2.5,2.5,7,0.009604422,20,19.5,5419,5919.5,117.5,15.5,-0.0041176137,4.5,-0.008000353,4.5,7.5,0.004674242,0.010823025,1.5,-0.0037645572,60.5,49.5,4.5,6,349.5,76.5,44.5,117,-0.0036447567,4.5,67.5,51.5,21.5,63.5,13.5,15.5,51,0.0072851963,12.5,120.5,103,170.5,0.004559686,154,0.0032728412,-0.00062835304,-0.011032934,7.5,20.5,20,16.5,4.5,287.5,12640,333.5,392.5,662.5,631,739,857.5,21.5,1818.5,0.00019294629,-0.0013791703,0.0010395637,0.006522802,-0.00060761685,0.0007278287,0.0018435803,-0.0017969372,-0.004037985,-0.00078365154,-0.002270169,-0.018862292,-0.0034389736,-0.008017675,0.00044887094,-0.0011902618,0.004526301,0.0012090462,0.0011274599,0.0027486554,5.0234154e-05,-0.0020375673,0.0020948735,0.00793806,0.009745519,0.0019804344,-0.00027375534,0.0021332258,-0.0051160273,-0.0011832626,0.0001308864,-0.0024639855,-0.011915832,-0.0018738749,-0.003965256,-0.010366644,0.0047938633,0.0006604818,-0.011290674,-0.0012757316,-0.0059630214,0.0018987993,0.00076357933,-0.004402179,-0.0028627818,0.008391289,-0.0010558116,0.0050979513,-0.0023139021,-0.0052408064,-0.0012384321,0.0028521407,-0.004320161,-0.0010810153,0.0012991064,-0.013549725,0.0045319353,0.0013121627,0.00033615856,-0.0007597403,0.008071161,0.0045143585,0.008303738,0.001682726,0.0010559162,-0.0029649355,0.0020734696,0.0046565696,-0.006701791,-0.0030033838,-0.0014315489,0.0018021573,-0.0006696134,0.0049419045,-0.0028641415,0.0007387438,0.0017373106,-5.7741814e-05,0.006352155,0.0009508972,-0.0030921006,0.0016318792,-0.003557941,0.001755006,-0.0041662334,-0.011830333,-0.006193751,-0.013872786,-0.0029625476,-0.0057147555,-0.0007788203,-0.004960725,0.0047256243,0.00085307145,-0.00745285,0.0017808968,0.007782434,0.0008276915,0.004299837,0.0067393556,0.0007934076,-0.0029343483,0.005696169,-0.0023304897,0.0012131883,-0.004722899,0.010045393,0.02655018,-0.0031500817,0.0019499613,0.003200474,-0.00093046174,-0.0031710358,-0.017210227,-0.0034847006,0.003290509,9.338203e-05,0.0034214219,-0.007292813,-0.00016334809,0.004649196,0.0016132841,0.036764868,0.0034333554,-0.0014481908,-0.0048235515,-0.0031038194,-0.017893609,0.002328823,0.009621272,-0.0004576434,-1.0234547e-05}, {1,2,0,4,4,8,1,4,3,0,0,6,1,2,7,0,8,8,8,1,8,1,8,2,6,0,4,255,8,4,6,7,255,5,6,4,8,0,8,8,6,8,8,5,1,2,2,8,0,8,0,8,2,0,4,255,8,8,8,7,6,5,8,8,2,255,8,255,8,255,4,8,8,8,3,2,8,6,8,255,255,255,255,8,8,8,8,8,8,255,6,8,255,8,1,2,4,8,255,3,1,0,0,8,255,8,8,255,8,8,0,0,0,6,8,8,0,8,255,1,8,0,255,6,255,0,8,255,8,0,8,2,255,255,255,0,8,0,8,8,255,255,255,8,8,8,8,255,8,8,4,6,2,8,255,8,255,8,8,255,255,8,255,4,0,8,8,5,0,1,0,255,8,1,6,8,2,8,8,1,255,8,0,0,0,255,0,255,255,255,8,8,8,8,8,0,4,7,5,0,6,7,3,8,5,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,65535,55,57,59,61,65535,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,65535,107,109,111,113,115,117,119,121,123,65535,125,65535,127,65535,129,131,133,135,137,139,141,143,145,65535,65535,65535,65535,147,149,151,153,155,157,65535,159,161,65535,163,165,167,169,171,65535,173,175,177,179,181,65535,183,185,65535,187,189,191,193,195,197,199,201,203,205,65535,207,209,211,65535,213,65535,215,217,65535,219,221,223,225,65535,65535,65535,227,229,231,233,235,65535,65535,65535,237,239,241,243,65535,245,247,249,251,253,255,65535,257,65535,259,261,65535,65535,263,65535,265,267,269,271,273,275,277,279,65535,281,283,285,287,289,291,293,295,65535,297,299,301,303,65535,305,65535,65535,65535,307,309,311,313,315,317,319,321,323,325,327,329,331,333,335,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,65535,56,58,60,62,65535,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,65535,108,110,112,114,116,118,120,122,124,65535,126,65535,128,65535,130,132,134,136,138,140,142,144,146,65535,65535,65535,65535,148,150,152,154,156,158,65535,160,162,65535,164,166,168,170,172,65535,174,176,178,180,182,65535,184,186,65535,188,190,192,194,196,198,200,202,204,206,65535,208,210,212,65535,214,65535,216,218,65535,220,222,224,226,65535,65535,65535,228,230,232,234,236,65535,65535,65535,238,240,242,244,65535,246,248,250,252,254,256,65535,258,65535,260,262,65535,65535,264,65535,266,268,270,272,274,276,278,280,65535,282,284,286,288,290,292,294,296,65535,298,300,302,304,65535,306,65535,65535,65535,308,310,312,314,316,318,320,322,324,326,328,330,332,334,336,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({8479,8675,8480.5,9893,8683.5,-0.023172589,8639.5,9104,7906.5,0.023139818,7574,7059,6564,9040,1.5,11633.5,7876,10961,6239,9261,7229.5,6541,6579.5,9245,2.5,9690.5,5877,7974,12331,1.5,-0.0251847,8181,5964,8036,3.5,5294.5,7995,6.5,6034,6531.5,12.5,5669.5,7129.5,7919.5,9955.5,-0.0038643007,-0.013818798,7281,9395,6771,8627.5,4.5,7546.5,1.5,9703,0.0081906775,7824.5,9356,8797.5,0.0060553467,0.0019477288,-0.009743507,7143.5,7653.5,7155,5.5,1.5,-0.005796369,-0.008644126,-0.0077101844,9618.5,-0.024276702,2.5,9759,15.5,-0.010064032,9893,14,10126,6945.5,7478.5,7886,7441,4844,-0.011432099,7940.5,-0.024584431,0.0073840367,0.0018654418,12.5,7353.5,3507,-0.017151078,2.5,7222,8608,3.5,-0.0029013508,6404.5,554.5,2.5,3.5,9,15.5,9563.5,3.5,6510.5,3,12.5,0.0015999122,10202,8317.5,9154.5,2354.5,6482.5,7940.5,6.5,-0.007144504,17.5,-0.003953035,-0.014020674,5468,11542.5,0.008456926,0.00031621518,-0.0038088157,-0.0073529906,-0.0048161186,-7.231322e-05,0.00954184,8,7279.5,6686,7184.5,5894,0.00016847061,0.012057041,-5.1954936e-05,-0.01628413,0.0008851494,0.0038724837,-0.0046847076,0.0011795588,0.010282933,0.0075223558,0.00042809095,0.0035941754,-0.011174776,0.0020106228,-0.0027376884,0.006437966,-0.0002011363,-0.0032444287,-0.014103018,-0.0044248225,-0.0041351137,-0.01656731,0.0014940373,0.009251533,0.002297569,-0.0023494742,0.0012285699,0.005179047,-0.0022888377,-0.008049223,-6.0740458e-05,-0.0009923121,0.0006701897,0.0021685886,-0.0018521668,0.00015510176,-0.002406935,-0.012040745,0.0010600825,-0.0069540846,0.0024394197,0.00073614274,0.00013854493,-0.0008802105,0.006726015,0.003177829,0.003968407,0.007317347,-0.0024052202,0.0021608335,0.009138478,0.00064902037,0.00041598655,-0.0028780736,-0.016489455,-0.0038192177,0.0004925736,0.005561857,-0.00222744,0.0006875962,-0.00025849396,-0.0023390062,0.00050954276,-0.0005258892,0.0013734978,0.005801912,0.003601394,0.008915892,0.004693595,-0.00034439398,0.0024322364,-0.012733667,-0.0020776985,1.9145342e-05}, {2,3,2,6,3,255,2,6,3,255,0,5,5,6,8,6,0,4,7,4,6,5,5,7,8,7,2,5,6,8,255,2,0,0,8,1,0,8,0,5,8,1,6,7,0,255,255,7,4,0,3,8,3,8,1,255,2,3,3,255,255,255,2,0,7,8,8,255,255,255,0,255,8,6,8,255,0,8,0,5,6,7,0,0,255,0,255,255,255,8,0,0,255,8,2,5,8,255,0,1,8,8,8,8,3,8,0,8,8,255,1,0,3,3,4,0,8,255,8,255,255,5,6,255,255,255,255,255,255,255,8,4,1,4,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,65535,11,13,15,65535,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,65535,57,59,61,63,65,67,69,71,73,75,77,79,81,83,65535,65535,85,87,89,91,93,95,97,99,65535,101,103,105,65535,65535,65535,107,109,111,113,115,65535,65535,65535,117,65535,119,121,123,65535,125,127,129,131,133,135,137,139,65535,141,65535,65535,65535,143,145,147,65535,149,151,153,155,65535,157,159,161,163,165,167,169,171,173,175,177,65535,179,181,183,185,187,189,191,65535,193,65535,65535,195,197,65535,65535,65535,65535,65535,65535,65535,199,201,203,205,207,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,65535,12,14,16,65535,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,65535,58,60,62,64,66,68,70,72,74,76,78,80,82,84,65535,65535,86,88,90,92,94,96,98,100,65535,102,104,106,65535,65535,65535,108,110,112,114,116,65535,65535,65535,118,65535,120,122,124,65535,126,128,130,132,134,136,138,140,65535,142,65535,65535,65535,144,146,148,65535,150,152,154,156,65535,158,160,162,164,166,168,170,172,174,176,178,65535,180,182,184,186,188,190,192,65535,194,65535,65535,196,198,65535,65535,65535,65535,65535,65535,65535,200,202,204,206,208,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({10243.5,10239.5,10924.5,8425,7,13662.5,2720,5871.5,10348,3.5,5276,10447.5,10931,2716.5,11536.5,5869,5873.5,7962,17.5,-0.010048797,5.5,-6.834994e-05,-0.010346708,8019,10560,0.0040585934,0.0064775087,2.5,12.5,11505.5,12045.5,4941,-0.01563681,6145,6442.5,7875,9312.5,4.5,8573,0.00781428,0.0010717257,5582.5,1.5,13037,11366,-0.00519828,4.5,4.5,11851,7805.5,9964,2.5,11254,5268.5,5191.5,4332,-0.004464066,7213.5,6450,7222.5,0.0104788095,8197.5,10030.5,9122,10217,10527,10214.5,10673,2.5,-0.017975768,0.011557943,1.5,10550.5,-0.016619405,5,10556.5,16.5,2.5,14220,16.5,-0.0037974187,9944,12156.5,7,1.5,11564.5,14.5,7685.5,11668.5,6630,6124,5660.5,5272,12.5,13.5,9208.5,5941,6445.5,7275,9072.5,7229,7369,9611.5,1.5,10771.5,10051,13117.5,8635,9770.5,6562,9122,9020,10131,2425,10824,10693,5585,11823.5,11516.5,17.5,0.006027403,-0.0006547123,-0.0043608113,-0.0018209523,11176.5,12.5,11121,2788.5,11851,11851,-0.0025407549,-0.0011348393,-0.00023516023,6978,5274,13434.5,0.012687328,4.5,7835.5,0.017596312,2.5,9636,11776.5,13152.5,6187.5,-0.0010420419,18.5,12260.5,12401.5,7.3105507e-06,-0.0012583261,-0.002953063,-0.0006126442,0.0019678767,0.010839424,-0.003390052,0.00026351944,0.005792249,0.010356974,0.012763408,0.0062462026,0.0010052609,0.006234619,-0.012599594,-0.0010468349,-0.020452205,-0.0075588743,-0.00032844438,0.0005849599,-0.0005742166,0.0019834521,-0.0022625818,-0.011841224,-0.004940022,-0.022306321,-0.0019627535,0.0038236578,0.011870229,-0.010891089,-0.024162108,-0.008821799,0.0055996138,0.00043003223,0.0010641798,0.0042460603,0.00069765496,-0.00071693346,-0.0012384088,-0.014674331,0.0014931015,-0.002534884,0.005141667,0.0026315195,0.0036695823,0.00095785083,-0.012236678,-0.0025611643,-0.0016653299,0.0015421831,0.0028669373,0.008461758,-0.0065063867,-0.00087505387,-0.003614304,0.00093878835,0.006012606,-0.0003818386,-0.0002292221,-0.0030387386,0.0014383972,0.003052642,0.00023357458,0.0010600673,-0.0036622249,-0.0054161963,-0.002155566,-0.0034660846,-0.0007115306,-0.0021546273,7.3690107e-06,0.0020263798,-0.00037892806,0.0005459225,-6.442116e-05,-0.0057510505,5.4952656e-05,0.0030775208,-0.0029455526,-0.00053426175,0.0008108833,-0.0016311342,-0.00036160907,0.0067546368,-0.0019854032,0.011239604,-0.0076087797,0.0024104922,0.009117283,0.0034021575,2.3059069e-05,-0.0040407474,2.4876126e-05,-0.0037438173,0.0044589075,0.002025479,-0.0056029144,0.0012819238,0.0003455876,-2.2480273e-05}, {2,2,2,2,8,1,3,0,3,8,0,3,0,1,6,0,0,5,8,255,8,255,255,1,0,255,255,8,8,6,6,5,255,1,0,5,1,8,4,255,255,5,8,3,4,255,8,8,0,5,0,8,2,0,5,1,255,2,0,5,255,4,3,5,2,3,2,4,8,255,255,8,6,255,8,6,8,8,0,8,255,6,7,8,8,4,8,0,2,6,4,6,5,8,8,6,0,0,2,3,7,6,0,8,0,6,7,4,0,0,5,2,1,3,0,2,3,1,4,8,255,255,255,255,2,8,4,1,0,0,255,255,255,5,1,3,255,8,0,255,8,3,0,2,5,255,8,3,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,65535,39,65535,65535,41,43,65535,65535,45,47,49,51,53,65535,55,57,59,61,63,65,65535,65535,67,69,71,73,65535,75,77,79,81,83,85,87,89,91,93,65535,95,97,99,65535,101,103,105,107,109,111,113,115,65535,65535,117,119,65535,121,123,125,127,129,131,65535,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,209,65535,65535,65535,65535,211,213,215,217,219,221,65535,65535,65535,223,225,227,65535,229,231,65535,233,235,237,239,241,65535,243,245,247,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,65535,40,65535,65535,42,44,65535,65535,46,48,50,52,54,65535,56,58,60,62,64,66,65535,65535,68,70,72,74,65535,76,78,80,82,84,86,88,90,92,94,65535,96,98,100,65535,102,104,106,108,110,112,114,116,65535,65535,118,120,65535,122,124,126,128,130,132,65535,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,210,65535,65535,65535,65535,212,214,216,218,220,222,65535,65535,65535,224,226,228,65535,230,232,65535,234,236,238,240,242,65535,244,246,248,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({8.5,7844,5632.5,7721,8952.5,5545,6768.5,1668.5,2720,9506.5,27390.5,4622.5,5065.5,7445.5,7101,1348.5,1188,7335.5,6725,8424,2.5,18122.5,30603,4730,5204,5631.5,5220,8459.5,7612.5,8309.5,6713,1655,1369,1900,1251,0.0020271572,0.009450517,6311,7988.5,2005,1.5,9258,5829,13475.5,31872,28329,24220,4680.5,3544,4848.5,5266.5,5358,-0.010822204,4445.5,7292,7112.5,8500,7482.5,9443.5,7031.5,6915,6564,9526.5,24,4,6111,1578,1828.5,2104,4.5,4044,4198,-0.012165169,8740,7503,4.5,8268.5,8254,11947.5,3248,8611,4.5,9258,4.5,13384.5,27996,18578.5,2.5,27458,1.5,1.5,4612,6439,17.5,3319.5,6402,17.5,5501,5892,11.5,5571.5,-0.0052429675,-0.014474149,5630.5,12.5,5715.5,7615.5,0.019667177,8901.5,6158.5,-0.02281366,6744,6710,3962.5,7996.5,8343,-0.016713908,6085.5,9330,7965,21794,24,74.5,0.0027002604,-0.010613013,-0.011288893,2.5,9141.5,2.5,7.5,4.5,6,6.5,879,1564,3781,9098.5,6298.5,6575,2719,7644,4.5,-0.013491039,0.013012076,0.0032720526,7852.5,9743,-0.029719455,11205,7966.5,2.5,0.0024984952,0.0060089724,0.00045836926,7784.5,0.0006353843,6.5,9782,7.5,11073,8898.5,11453.5,1.5,19152,31694.5,16936,30039,1.5,26413.5,24135,29761.5,-0.0013046801,20377.5,29585,30152,1579.5,-0.01464685,0.00026058566,11.5,3767.5,5933,14,8365,3125,-0.009497347,4182,5113,3168.5,0.0027565018,7594.5,8795.5,4889.5,3628.5,12.5,16.5,5240,-0.01319209,5567.5,6686,5614.5,6776,7185.5,6041.5,7314.5,11337.5,5600.5,-0.003362432,6406.5,7479,15.5,17.5,4167.5,6814,4011,6453,6812,10878.5,12.5,8902.5,0.00954694,6564,7552.5,7672,13414.5,18578.5,5.5040095e-05,-0.0024412489,0.0015236778,-3.3343935e-05,0.00068229006,-0.0007909749,-0.0008270067,-0.00801483,-0.0037368087,0.0052345786,0.009775217,-0.002957782,-0.014032348,0.05003512,-0.015082105,0.0006232617,-0.00097411696,0.00591686,0.006250324,-0.0024916725,-0.003260842,-0.0110189235,0.00058841205,0.003971148,0.000107783235,0.0014431885,-0.004624616,0.0012257731,0.0058151153,-0.00015779915,-0.00016399563,0.005661232,-0.008218326,-9.445545e-05,0.0049247164,-0.0030065577,-0.0010178133,-0.016098656,4.5802884e-05,0.008526294,0.009530733,-0.009565371,-0.0036695662,-0.010133668,0.0011176701,0.003912324,0.0019307965,0.0035682076,-0.0025508825,0.000906435,0.005597794,0.0028866946,0.001013555,0.0019727906,-0.0007351416,0.0016918903,0.0013459877,-0.00082041154,-0.0013701379,0.0046055536,0.00469707,-0.0051158234,0.0010141478,-0.0017205663,0.0032094237,-0.00025001413,-0.0018876931,-0.000680215,-0.0021866427,0.00033883328,0.0027248932,-0.0016568914,-0.0027624238,-0.007489315,-0.0014681417,0.003238761,0.00031797556,-0.0012315803,0.0019750944,0.0007508104,-0.00013619462,-0.0011240746,-0.0018659746,-0.00012434965,0.00014897903,-0.0004831138,0.0041414537,0.007386271,-0.0015137551,0.0027451725,-0.003061342,0.001439681,-0.003596623,0.0055257706,-0.004374808,-0.00067418243,-4.446833e-05,0.0042147734,0.0011150986,0.006562465,0.010230678,0.0029712059,-0.009312404,-0.021488776,-0.0027773315,0.0004732342,0.0043882593,-0.00031998713,-0.0019255227,0.0037050971,0.0019532633,0.0053574303,0.0022574977,-0.0023837953,-0.00012705209,0.0058453884,-0.0006171896,-0.004878178,0.004170321,-0.0020257446,-0.00584049,-0.001418657,0.000823324,0.0080281785,-0.0037239806,0.0014618625,0.00431425,-0.017910317,0.010701763,0.027251502,0.006284058,-0.008414186,0.0006764507,-0.0017307537,0.00026712174,-0.00065141305,-0.00070797355,0.0042516985,-0.011063374,-0.0015991236,0.0010890487,0.004620837,0.0010606026,-0.0029570493,-0.0010741901,-0.0069316537,0.0046127555,-0.00057014776,-0.0019714767,-0.0060517294,0.0011096458,0.004803002,-0.017389586,8.6782275e-05,5.9376976e-05,-0.008917084,-0.005098514,-0.0010436842,0.0008932226,-0.00030032173,0.0051345867,0.0020173811,-0.0031374616,6.344846e-05,0.00077142566,-0.0024045452,-0.00011561052,0.0010180506,-0.0005981481,4.5540644e-05}, {8,2,4,2,2,4,4,6,3,3,7,5,2,3,4,2,7,0,0,1,8,6,7,4,3,4,0,6,3,6,5,6,2,0,7,255,255,5,0,3,8,6,6,0,4,6,4,4,1,4,3,5,255,0,7,3,6,2,1,4,5,5,5,1,8,0,6,0,2,8,4,5,255,7,5,8,1,3,6,4,4,8,6,8,7,4,7,8,1,8,8,5,0,8,2,0,8,4,6,8,3,255,255,3,8,5,6,255,0,0,255,0,4,1,6,2,255,2,0,5,6,5,0,255,255,255,8,1,8,8,8,8,8,1,2,4,1,4,0,5,0,8,255,255,255,1,0,255,0,7,8,255,255,255,0,255,8,3,8,0,1,7,8,5,2,5,2,8,6,2,6,255,2,6,3,0,255,255,8,5,2,8,0,0,255,2,4,0,255,1,2,0,2,8,8,3,255,4,2,7,5,2,4,2,2,0,255,0,1,8,8,3,3,3,0,5,0,8,2,255,3,4,4,6,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,65535,65535,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,65535,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,65535,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,65535,65535,195,197,199,201,65535,203,205,65535,207,209,211,213,215,65535,217,219,221,223,225,227,65535,65535,65535,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,259,65535,65535,65535,261,263,65535,265,267,269,65535,65535,65535,271,65535,273,275,277,279,281,283,285,287,289,291,293,295,297,299,301,65535,303,305,307,309,65535,65535,311,313,315,317,319,321,65535,323,325,327,65535,329,331,333,335,337,339,341,65535,343,345,347,349,351,353,355,357,359,65535,361,363,365,367,369,371,373,375,377,379,381,383,65535,385,387,389,391,393,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,65535,65535,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,65535,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,65535,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,65535,65535,196,198,200,202,65535,204,206,65535,208,210,212,214,216,65535,218,220,222,224,226,228,65535,65535,65535,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,260,65535,65535,65535,262,264,65535,266,268,270,65535,65535,65535,272,65535,274,276,278,280,282,284,286,288,290,292,294,296,298,300,302,65535,304,306,308,310,65535,65535,312,314,316,318,320,322,65535,324,326,328,65535,330,332,334,336,338,340,342,65535,344,346,348,350,352,354,356,358,360,65535,362,364,366,368,370,372,374,376,378,380,382,384,65535,386,388,390,392,394,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({29895,27990,18879.5,27934,27340.5,24104,30020.5,28894.5,13815,15383.5,29977.5,-0.008014692,18695,29519,16671.5,27953,26797,-0.013985366,18230.5,28082,12.5,29725.5,30009.5,18816.5,18195,25743.5,29728,1.5,20457.5,27893,24241.5,23958,1.5,26029.5,17.5,16.5,28708,29271.5,27656,29906.5,29788,29744.5,29658,31853,-0.008569679,19258,18777,15.5,2.5,29644.5,27369,28063,16.5,1.5,18049.5,13931,15,13871,24178,28931,16.5,-0.00856672,15.5,-0.0020790033,7,28634,28634,0.013980716,0.004952743,23500,30343.5,1.5,28987,29394.5,18653,29869,29582.5,29709,29998.5,-0.0030012303,29817,7.5,29720.5,11180,27957.5,19210,3,19950,30215.5,0.0070769438,0.0012458231,0.00085826183,0.0027045298,29562.5,30013.5,20807,29733,0.002821268,0.00016380765,6.5,28063,19383,19574,30608,20467.5,16203.5,32077,0.011592848,0.004467904,28773.5,17364.5,17199,24286.5,0.0036052165,26118,13384,18596,3.5,25674.5,-0.0025137218,-0.0060898545,7,0.002476008,0.00021135893,-0.0024092996,28965,20163.5,12.5,13,26574.5,16356,2.5,31674,15.5,16.5,18485.5,23199,29605.5,29757.5,30086,29968,29652,29712.5,29820,29920,14.5,-0.0024169448,-0.0011657843,15.5,12,3.5,6.5,17181,-0.008144021,32234,7,17537,-0.0018628208,7.5,6.5,20210,14,19478,-0.0021296747,0.002083452,-0.0023816607,29674.5,-0.004945866,6.5,15.5,30323.5,28063,-0.0013501606,-0.0048421044,-0.0018689971,19571.5,19829,19254,19831,3,-0.0077333213,-0.00477237,24002.5,1.3820938e-05,0.0024636772,-0.00087247556,0.00027748835,0.0034467094,-0.0012793314,0.010452988,0.0043494008,0.0049981507,0.0014366987,-0.0054543708,-9.6894386e-05,-0.001955149,0.00044096448,0.0028698144,0.00787178,0.004526865,2.4433391e-05,-0.0030128115,0.00054149725,-0.0010966613,-0.004409866,5.1548614e-05,0.00024929072,0.00062687736,0.0061810613,-0.0008251762,0.0017689867,-0.0076921224,-0.011668528,-0.0020713245,0.00042293067,0.010579152,-0.00046797376,0.0029972421,0.006820374,0.000837665,0.005913514,0.0022746883,-0.00077726616,0.0090194065,0.0042385883,0.003422283,-0.0007243519,0.0004959262,-0.0015125241,0.002093381,0.00057016296,-0.00038743563,0.00021360947,-0.0030715594,0.00072167045,0.0006057069,-0.001848291,-0.0021911224,-0.003091104,0.00068776956,0.00016047373,-0.0037904435,-0.0004883953,0.0006587507,0.0016588791,-0.0017584587,0.00016930181,-0.00036850694,0.0004969907,-0.0005721153,-0.00026608133,-0.0009986124,-0.00024056935,-0.00027970207,0.0004059593,0.003627222,0.0006931224,-0.0014712991,1.6146632e-05,-0.0019045182,-0.00083295675,-0.00017438992,0.0002904209,0.0006483594,0.001206751,-0.0005262709,-6.919987e-05,-0.0017106595,-0.0011565158,0.00082190585,-0.0005244884,-0.000919057,9.3866074e-05,0.00025992835,0.0026597632,0.0004858216,-0.0025460985,-0.0017787647,-0.00117221,0.0001778007,0.0010737678,-0.00034501767,-0.0019413527,-0.00038497435,-0.002382156,0.0002648557,0.0032065671,0.0051429193,0.0019885814,-0.00021614121,0.0005521068,0.0014169649,9.270223e-05,-0.0046970765,0.0017915178,-0.00023823087,0.00018114218}, {6,4,5,4,1,2,2,6,3,7,2,255,1,4,1,0,4,255,1,4,8,2,4,5,7,3,4,8,7,4,4,2,8,0,8,8,6,6,6,0,4,6,6,0,255,3,7,8,8,0,5,0,8,8,1,5,8,5,6,6,8,255,8,255,8,0,0,255,255,0,0,8,2,0,7,4,2,4,4,255,6,8,0,5,4,1,8,1,4,255,255,255,255,0,6,0,2,255,255,8,0,3,7,0,7,3,5,255,255,0,3,3,4,255,0,3,7,8,0,255,255,8,255,255,255,4,5,8,8,0,1,8,2,8,8,5,1,4,0,0,0,4,4,6,0,8,255,255,8,8,8,8,5,255,2,8,3,255,8,8,1,8,3,255,255,255,4,255,8,8,6,0,255,255,255,7,3,3,3,8,255,255,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,65535,23,25,27,29,31,65535,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,65535,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,65535,117,65535,119,121,123,65535,65535,125,127,129,131,133,135,137,139,141,143,65535,145,147,149,151,153,155,157,159,161,65535,65535,65535,65535,163,165,167,169,65535,65535,171,173,175,177,179,181,183,185,65535,65535,187,189,191,193,65535,195,197,199,201,203,65535,65535,205,65535,65535,65535,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,65535,65535,249,251,253,255,257,65535,259,261,263,65535,265,267,269,271,273,65535,65535,65535,275,65535,277,279,281,283,65535,65535,65535,285,287,289,291,293,65535,65535,295,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,65535,24,26,28,30,32,65535,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,65535,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,65535,118,65535,120,122,124,65535,65535,126,128,130,132,134,136,138,140,142,144,65535,146,148,150,152,154,156,158,160,162,65535,65535,65535,65535,164,166,168,170,65535,65535,172,174,176,178,180,182,184,186,65535,65535,188,190,192,194,65535,196,198,200,202,204,65535,65535,206,65535,65535,65535,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,65535,65535,250,252,254,256,258,65535,260,262,264,65535,266,268,270,272,274,65535,65535,65535,276,65535,278,280,282,284,65535,65535,65535,286,288,290,292,294,65535,65535,296,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6214.5,2.5,6421.5,5699.5,5697,7409,6483.5,137,5054,5531,6357,6418.5,5884,6912,6498.5,3638,3508.5,5293.5,2713,5508,17.5,6360,6210,9202.5,14.5,0.016076518,5820.5,5491.5,7117,15.5,6568,74,1915.5,4907,5317.5,272,5941,-0.012698397,1.5,6562,5618.5,6085.5,5549.5,5962,5591,8279,-0.012141679,5871,8175.5,11.5,0.008810214,0.014756853,6345,6450.5,12.5,-0.02010645,6516.5,5709.5,6495.5,3800.5,6976,67,22,0.008287798,2486.5,2335,1.5,21768,1.5,1.5,5942.5,4156.5,7905,5615,6866,6685.5,5276.5,-0.021202404,15.5,15.5,6888.5,5376.5,6256,5890,5800.5,7105,5870,5998.5,8902,4880,6019.5,0.008353557,1.5,0.004785001,0.0010886703,6367,11452.5,7.5,0.008929239,5814,6077.5,7149,1.5,7.5,14.5,16.5,0.0125129325,-0.015790464,7024.5,6869,7801.5,60.5,67.5,50.5,87,-0.0030810942,0.0018679834,1349.5,2801,0.0076422403,5526,3586,1.5,6101.5,5475,-0.014584002,-0.0031700954,7085.5,8381.5,1216.5,1.5,1.5,7749,-0.0068937405,6599,8428.5,8469.5,6496,17.5,5300,2740.5,5729.5,5729.5,5734,5510.5,5533,5189,4924.5,0.01123821,5664.5,8605.5,5717.5,7625.5,11.5,5894.5,4.5,5818.5,5779.5,7451.5,4879,16.5,7170,12127,2660.5,6313.5,-0.012628004,7267.5,0.0088738315,7.5,4.5,6,17.5,-0.0053666937,4.5,16.5,4.5,1.5,2180,7945.5,6440,6443.5,0.011199818,6813,2.5,5086.5,0.0034946722,0.0006587215,6490,6491.5,6512.5,6538,8282.5,9771.5,7525,8077.5,0.00043842752,0.0058562267,0.009358847,0.0016923199,0.0019170037,0.0005076914,-0.0030641095,-0.00026125635,-0.0022791263,-0.006663783,0.0011951284,-0.0034145531,0.0020545318,-0.00034214754,0.009108166,0.0009346855,-0.0017349422,-0.0068522817,-0.0005578949,0.009889721,-0.00066202576,-0.0067190393,0.004568803,0.00082106324,-0.0046618017,0.0075090975,0.0011104004,0.0035704044,0.00049419416,-0.0040920894,-0.019148624,-0.003740732,0.0011177661,-0.0032847188,0.0077459225,0.001916869,0.0031823132,0.011130327,-0.0024971662,0.0010483552,0.00011190023,-0.009040755,0.0015808092,0.009512111,-0.00069343415,-0.013296139,-0.0027914715,0.0005959281,-0.0038072676,0.00056175096,0.0078634,0.00015258986,-0.00010176079,-0.003434195,-0.0019417017,0.007244362,0.0014478281,0.009285874,0.0019506756,-0.0006540367,0.011404071,-0.0026959095,0.00035753316,-0.0055517717,0.0056037223,0.00034477,-0.002406799,0.004816319,-0.0134949,0.0029830504,0.015179514,0.0074228346,-0.005613767,0.0028481414,0.0011974758,0.004235385,-0.0043276916,0.0012515213,-0.0008674646,0.0058818352,-0.009888765,-0.016069636,0.0015750986,-0.00068153255,0.0017751906,0.007849146,-0.01624437,-0.004774732,0.0013235423,-0.00025124813,0.0006131308,-0.0015599855,0.0015567293,0.009248938,-0.0015960004,-0.0080329245,0.0018905662,-0.00011089172,-0.003097036,-0.010587274,0.0038320904,9.619738e-05,0.001433554,0.0037155685,0.0019600517,0.0056917774,0.0014999814,0.0036327024,-0.0024238823,-0.0081622545,-0.009116149,0.0022394096,-0.00067647774,0.0051668123,-0.002180534,0.0013752556,0.00017724907,-0.0059899087,-0.0067884224,-0.015325668,-0.0028822215,0.0010374605,0.0011451992,-0.0020082581,0.00013583704,0.0011040037,0.0016992942,0.0061579538,0.0037501685,0.0004914146,-0.005131356,0.0019622035,-0.0031963133,-0.011478658,0.0006960568,-0.000254493,-0.002405272,0.002194747,0.00014415247,0.0027530813,-0.0018981434,3.110113e-05}, {0,8,0,2,1,5,0,0,1,1,1,0,1,4,0,4,7,5,5,1,8,5,0,6,8,255,2,6,4,8,0,7,3,5,2,4,6,255,8,6,0,6,5,5,0,5,255,5,2,8,255,255,3,0,8,255,1,2,0,6,2,7,2,255,2,1,8,3,8,8,0,0,7,3,2,7,0,255,8,8,3,2,4,6,4,2,3,4,7,3,5,255,8,255,255,0,6,8,255,4,1,3,8,8,8,8,255,255,4,6,2,3,1,4,3,255,255,4,6,255,4,7,8,5,4,255,255,2,4,0,8,8,2,255,1,6,3,7,8,1,1,0,0,2,2,1,0,0,255,1,2,4,2,8,0,8,1,0,6,2,8,6,5,3,0,255,5,255,8,8,8,8,255,8,8,8,8,1,2,0,0,255,1,8,2,255,255,0,0,0,0,0,0,6,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,65535,51,53,55,57,59,61,63,65,67,69,71,65535,73,75,77,79,81,83,85,87,65535,89,91,93,65535,65535,95,97,99,65535,101,103,105,107,109,111,113,65535,115,117,119,121,123,125,127,129,131,133,135,137,139,65535,141,143,145,147,149,151,153,155,157,159,161,163,165,65535,167,65535,65535,169,171,173,65535,175,177,179,181,183,185,187,65535,65535,189,191,193,195,197,199,201,65535,65535,203,205,65535,207,209,211,213,215,65535,65535,217,219,221,223,225,227,65535,229,231,233,235,237,239,241,243,245,247,249,251,253,255,65535,257,259,261,263,265,267,269,271,273,275,277,279,281,283,285,287,65535,289,65535,291,293,295,297,65535,299,301,303,305,307,309,311,313,65535,315,317,319,65535,65535,321,323,325,327,329,331,333,335,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,65535,52,54,56,58,60,62,64,66,68,70,72,65535,74,76,78,80,82,84,86,88,65535,90,92,94,65535,65535,96,98,100,65535,102,104,106,108,110,112,114,65535,116,118,120,122,124,126,128,130,132,134,136,138,140,65535,142,144,146,148,150,152,154,156,158,160,162,164,166,65535,168,65535,65535,170,172,174,65535,176,178,180,182,184,186,188,65535,65535,190,192,194,196,198,200,202,65535,65535,204,206,65535,208,210,212,214,216,65535,65535,218,220,222,224,226,228,65535,230,232,234,236,238,240,242,244,246,248,250,252,254,256,65535,258,260,262,264,266,268,270,272,274,276,278,280,282,284,286,288,65535,290,65535,292,294,296,298,65535,300,302,304,306,308,310,312,314,65535,316,318,320,65535,65535,322,324,326,328,330,332,334,336,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({38,4825,22.5,31.5,18.5,36.5,41.5,248.5,34,5092,5858,6.5,25.5,24.5,48.5,22,3.5,63.5,33.5,6075.5,2,-0.011697431,-0.0025831745,2.5,49.5,15.5,14,-0.012985811,29.5,10.5,9031,22,27,27.5,15,5.5,29.5,32.5,31,-0.005275773,16.5,0.003463056,26.5,-0.0031805385,49.5,15.5,85.5,3,-0.0071789064,101,101,9,5280.5,45.5,18.5,5937.5,9826,15.5,17.5,15,28.5,2.5,1.5,27.5,27.5,34.5,26.5,5,-0.013169651,15.5,2.5,16,170,3.5,-0.00045678098,0.001067823,-0.00084794016,-0.0049320646,-0.015640816,13,-0.008663486,12.5,-0.0023960925,0.00016095063,4.5,7.5,6.5,20.5,20.5,2.5,-0.0072579957,2.5,3,2,6.5,14.5,19.5,5769,10811.5,9682.5,10009,22,22,22,26,12.5,21.5,15.5,49,0.005534206,0.0020245106,0.0020973908,2.5,8,6,20.5,18.5,3.5,35.5,14,34.5,-0.002538179,13.5,27,55.5,0.022101132,16.5,36.5,21.5,14.5,205.5,-0.0005474245,-0.001938577,-0.003457559,-0.0011529264,-0.0007207153,0.00072995876,-0.0011831808,-0.0028038882,4.5,-0.0027042525,1.5,12,15.5,-0.004740109,-0.004748946,-0.0015169426,-0.00056899065,0.00022014194,27,7.5,-0.0039405534,15.5,0.00019795277,6,2.5,-0.0012978062,11.5,45.5,0.0024661454,21.5,5713,8027,5497,11610.5,8812,10465,18104,21547.5,0.0004343721,-0.0028178715,-0.0025546986,0.0021422727,0.0011733598,-0.0010699055,0.0033270798,0.007086356,-0.0047397553,-0.007591887,-0.002020423,-0.004304795,0.0019406332,-0.0012532859,-0.0030152153,0.00041481975,-0.0013989242,0.0016407798,-0.00018824938,0.0013101428,0.001124899,-0.0014432267,0.00042270156,0.0035319943,0.005238178,0.00096860866,-0.0022674685,0.0011558332,0.0052012014,0.00016655293,0.0006993409,-0.00014583737,0.0050347494,0.008791019,0.0025162685,-8.197739e-05,-0.00016275562,0.0031639503,-0.0016843539,0.0036077015,0.005972982,-0.0034012967,0.00016374035,0.005175767,-0.004145037,0.0053279772,-0.0037878808,-0.008890879,-0.002614623,-1.2017835e-05,-0.002353821,0.00063777325,0.0020451392,0.0005609279,0.003175635,0.00073847204,-0.0041059754,0.004163434,-7.129567e-05,0.005356968,-0.00020817593,-0.0025110564,0.0016489107,0.00027528437,0.003335812,0.0015159108,0.0023207814,0.0006374691,0.010191539,0.002725134,0.011284915,0.0047928984,0.00033922392,0.0010120373,-1.6336382e-05,-0.0030328087,0.0013333606,0.008734783,0.0006625274,-0.00090767985,0.004247029,-0.00023350348,0.0006584186,-0.0033772744,0.0058901752,0.0012378041,-0.004449442,0.002187181,0.00022230796,-4.326901e-05}, {0,6,3,6,8,1,0,4,7,4,6,8,6,3,0,4,8,4,0,6,8,255,255,8,0,8,8,255,3,8,3,0,2,0,8,8,0,1,4,255,8,255,0,255,0,8,0,8,255,0,0,8,2,0,8,3,3,8,8,8,4,8,8,0,0,0,0,8,255,8,8,8,6,8,255,255,255,255,255,8,255,8,255,255,8,8,8,8,8,8,255,8,8,8,8,8,8,3,6,2,3,6,6,2,0,8,8,8,4,255,255,255,8,8,8,8,8,8,0,8,0,255,8,0,6,255,8,0,8,8,5,255,255,255,255,255,255,255,255,8,255,8,8,8,255,255,255,255,255,5,8,255,8,255,8,8,255,8,0,255,8,3,7,4,6,0,2,0,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,65535,65535,43,45,47,49,65535,51,53,55,57,59,61,63,65,67,69,71,65535,73,65535,75,65535,77,79,81,83,65535,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,65535,123,125,127,129,131,65535,65535,65535,65535,65535,133,65535,135,65535,65535,137,139,141,143,145,147,65535,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,65535,65535,65535,185,187,189,191,193,195,197,199,201,65535,203,205,207,65535,209,211,213,215,217,65535,65535,65535,65535,65535,65535,65535,65535,219,65535,221,223,225,65535,65535,65535,65535,65535,227,229,65535,231,65535,233,235,65535,237,239,65535,241,243,245,247,249,251,253,255,257,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,65535,65535,44,46,48,50,65535,52,54,56,58,60,62,64,66,68,70,72,65535,74,65535,76,65535,78,80,82,84,65535,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,65535,124,126,128,130,132,65535,65535,65535,65535,65535,134,65535,136,65535,65535,138,140,142,144,146,148,65535,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,65535,65535,65535,186,188,190,192,194,196,198,200,202,65535,204,206,208,65535,210,212,214,216,218,65535,65535,65535,65535,65535,65535,65535,65535,220,65535,222,224,226,65535,65535,65535,65535,65535,228,230,65535,232,65535,234,236,65535,238,240,65535,242,244,246,248,250,252,254,256,258,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6305.5,5954,6321,5931.5,7055.5,5779.5,6374.5,5922.5,5602.5,6287.5,7195,6.5,7093,6370.5,6471.5,5879,0.01139843,1.5,2.5,4766.5,5755.5,6729,4.5,8043.5,-0.0118470155,9962.5,3.5,6053,19.5,6455.5,7525,5873,11411,-0.015400328,-0.005336632,-0.004758574,-0.013241731,725,5971,10,5845.5,6821,0.026434122,5984.5,5.5,-0.004132319,0.0021926106,5.5,5,-0.002267013,-0.011057085,-0.013335955,12.5,0.009776781,9280.5,5980.5,6195.5,1.5,7762,5802,2827.5,5078.5,6258,2486.5,18.5,6162.5,6154.5,0.01560788,0.006545683,5,6121.5,1.5,5431,11537,10807,10187.5,7551,4,11,-0.007900235,6.5,8212.5,6452,0.010972046,2.0630107e-05,11222,5768,0.006976669,9955,7819.5,7713.5,9747,9038.5,5794.5,7193,16.5,17,8,9077.5,16.5,15.5,2257.5,5.5,5845.5,3886,-0.016504455,2.5,6407.5,0.0061508897,3,-0.005723407,6052.5,1.5,5862.5,5699,3932.5,3.5,5267,0.008098605,7564.5,10393.5,9566,11742.5,-0.016030123,9194,8085.5,8177,8177,6919,0.0026998455,13,6344,10420.5,15.5,7641,12.5,5,7643,6140.5,7,-0.010137809,4955,2388.5,5838,9927.5,6844,2617.5,7702,8938,5.8736117e-05,0.010864672,-0.0025985015,0.0046969983,-0.00024395296,-0.009327873,0.0043078787,0.013664712,0.0028923412,-0.0033873455,-0.011491498,-0.005311328,-0.0034230244,0.00040524834,0.0025842588,0.005822493,-0.004035377,-0.0077353986,0.00030023055,-0.0014926129,-4.4861365e-05,0.0048525333,0.0071215006,0.00068463304,0.004139356,-0.0049567884,-0.0014470852,-0.007839124,-0.0041339705,0.003344709,0.007590418,0.003963155,0.0018722715,0.00014079017,0.0003209854,-0.017168816,0.004739034,0.013120057,0.0020599102,0.010197504,-0.003813595,-0.012488938,0.0046000355,-0.0020056635,0.006709657,-0.0040471028,0.004583712,-0.00081826,3.569612e-05,0.018641664,-0.0059463005,4.859833e-05,0.006042614,0.00062659575,0.0029861769,-0.0028711897,-0.00016444427,0.010864955,0.00037531616,-0.0045828545,4.6901634e-05,-0.0016552685,-0.0061233207,-0.0015816017,-0.0040026475,-0.00060876925,0.0045630843,0.001280649,0.010765735,0.004628338,-0.0028103555,0.0016763617,0.001268407,0.0056578307,-0.0008358448,-0.006184585,-0.012474452,-0.0067578666,0.0041984334,-0.0034499497,0.00011160151,-0.006036169,-0.010280771,0.012711716,0.0055750133,0.00015679433,0.0014645987,-0.003520868,0.0005960199,-0.017414957,-0.000541269,0.0063089407,0.016433196,-0.00037350805,-0.014630987,-0.00130611,0.0010229041,-1.6271342e-05}, {7,7,7,7,2,5,7,7,4,6,0,8,1,7,7,7,255,8,8,2,0,0,8,0,255,0,8,0,8,7,6,7,4,255,255,255,255,0,5,8,0,3,255,7,8,255,255,8,8,255,255,255,8,255,0,5,3,8,7,7,0,3,1,2,8,7,6,255,255,8,2,8,0,0,6,6,2,8,8,255,8,1,1,255,255,0,1,255,2,7,7,6,7,7,3,8,8,8,0,8,8,2,8,0,0,255,8,4,255,8,255,2,8,0,0,0,8,1,255,0,0,0,6,255,6,0,0,0,1,255,8,7,0,8,0,8,8,0,1,8,255,5,2,4,0,0,1,6,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,65535,33,35,37,39,41,43,45,65535,47,49,51,53,55,57,59,61,65535,65535,65535,65535,63,65,67,69,71,65535,73,75,65535,65535,77,79,65535,65535,65535,81,65535,83,85,87,89,91,93,95,97,99,101,103,105,107,65535,65535,109,111,113,115,117,119,121,123,125,127,65535,129,131,133,65535,65535,135,137,65535,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,65535,173,175,65535,177,65535,179,181,183,185,187,189,191,65535,193,195,197,199,65535,201,203,205,207,209,65535,211,213,215,217,219,221,223,225,227,229,65535,231,233,235,237,239,241,243,245,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,65535,34,36,38,40,42,44,46,65535,48,50,52,54,56,58,60,62,65535,65535,65535,65535,64,66,68,70,72,65535,74,76,65535,65535,78,80,65535,65535,65535,82,65535,84,86,88,90,92,94,96,98,100,102,104,106,108,65535,65535,110,112,114,116,118,120,122,124,126,128,65535,130,132,134,65535,65535,136,138,65535,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,65535,174,176,65535,178,65535,180,182,184,186,188,190,192,65535,194,196,198,200,65535,202,204,206,208,210,65535,212,214,216,218,220,222,224,226,228,230,65535,232,234,236,238,240,242,244,246,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31866.5,8.5,18713,18320,17509.5,31919.5,1.5,17407.5,20758.5,26226.5,18008,11271.5,20609.5,21834.5,20598,18850.5,15526.5,18351,17162.5,23156,4769,28298,18191,27023.5,31854.5,17690.5,1.5,19101,22304.5,19474.5,20600.5,4408,19616,17309.5,18463.5,11334.5,1.5,11784.5,20195.5,17316,18382.5,29427.5,19699.5,15848,29467,15.5,18444.5,-0.00860376,7.5,18429,31896,17087,17554.5,-0.0022546842,-0.0076065264,32369,32140.5,-0.0033066787,30971.5,19521,32140.5,-0.005667319,23592.5,4369.5,4949,31520,26018,17812.5,25262.5,22053,23454,2.5,18550,21495,21721,24869.5,22952.5,23067.5,21436,19612,17155.5,17.5,10034,0.008783731,12.5,12822,16.5,18593,19373.5,15.5,29905.5,31265.5,15192.5,19116,17070,5,-0.0014575019,8425.5,18602,-0.0048160916,4.5,32250.5,2,7.5,19894.5,19944.5,18512,-0.0026464856,19763.5,24000.5,31781,18182,18744.5,19804.5,12.5,21834.5,15.5,1544.5,4.5,4914.5,11833,14563.5,28463.5,19707,1.5,14507.5,2.5,28040,-0.0041757147,17958,21743,30317.5,6.5,0.010653908,9233,1.5,3249,19942.5,0.010562968,5.5,2.5,-0.004319367,29036.5,9966,13094.5,1.5,19043.5,30388,22260,17051.5,26267,19665.5,14.5,0.007943986,14596,17.5,0.0020813057,11,0.003721581,24030,14083,26488.5,17288,15738.5,19879.5,17177.5,27570.5,12.5,18.5,-0.0025342111,9.5,25967.5,18134.5,18093,15452,18938,18.5,29622.5,32144.5,-0.0012427786,0.005394306,11,21412.5,6.5,1.5,-0.0030990967,13.5,32004,17012,-0.0021724382,-0.008043152,-0.002599662,-0.008810538,32244.5,2.5,0.00088957243,0.0028649156,20547.5,19501,18722.5,19827.5,24467.5,30501.5,32036.5,-0.0026067358,18613.5,19197,6,3.5,3,-0.0046324693,2.5,19826,20614,22713,30603,16.5,-2.3533774e-05,0.0007470946,0.0082731815,0.0025640156,-0.00027364222,-0.0074052783,0.0005048057,-0.0002768094,6.267297e-05,-0.002497057,0.0006705559,0.0047977283,0.011253691,0.0046308516,-0.0021718023,0.0022655458,0.0037197128,-0.007843752,-0.003648777,-0.010016433,0.007679107,0.0011625921,0.0054780967,0.008930144,0.007115863,-6.1499166e-05,0.004494976,0.00016698375,-0.0021865983,0.0018350605,0.0048546433,0.00045108996,0.0028597447,-0.0083515905,-0.0017328141,0.0017391307,0.00462812,0.00076139893,-0.013273696,-0.007204704,0.005003287,0.00038405982,-0.00086646917,-0.0023868426,0.00416009,0.011714017,-0.0010576694,0.0044306614,0.0050048507,-0.009309579,0.0004031021,-0.0033979956,0.004652607,-0.0004575742,-0.0040407283,-0.00013213087,-2.9950692e-05,-0.0012562879,0.0045804027,0.0014015656,-0.0030372608,0.009874276,-0.0014400145,-0.006209647,0.00057775783,0.005839539,0.0008527074,-0.002445159,0.0008314792,0.0002418059,0.0014326965,-0.0009399185,-0.004526252,-0.0012545396,0.001848602,0.005359731,0.0010779504,-0.0019511404,0.0005627146,-0.0033710804,0.007469531,0.0018425019,0.0053516077,0.0095436135,0.0012663305,0.005076897,0.0033297576,0.0016122757,-0.00085990236,-2.5258336e-05,-0.001653705,-0.00049002416,0.0004348273,0.0039257063,-0.0066538677,-5.6212175e-05,-0.0030537785,-0.0005275858,0.004759542,0.00040863446,-0.003505742,-0.0114949,-0.002245233,-0.00059928896,0.0045765266,0.0010791885,-0.00029037797,0.0001292696,-0.0004316236,0.0011961929,-0.0042531616,-0.000986182,-0.0019379084,-0.0071084597,-0.0013606946,-0.002388834,-0.0005196685,-0.0021880723,0.0026600584,0.00013863787,-0.0011722649,0.0007898719,-0.00086994044,0.00022164542,0.00015252599,-0.0016790804,-0.00040677312,0.0015072139,-0.0011211791,-0.0022874998,0.0016186165,0.003964836,0.0032948267,0.0017549813,0.0002143291,-0.0003110881,0.00074657885,0.00011301452,4.8280326e-05,-0.0006214976,0.000640565,-4.5200828e-05,-0.00022780096,-0.0008815227,-0.0005704219,0.0004769406,0.0035789863,0.0015095536,0.00068870117,-0.0010654792,0.0017745817,0.0007043222,0.00059411954,-0.000161899,-0.00041916035,0.0007090384,-0.009722288,-0.0005871842,-0.000244273,0.00087141676,0.0008211435,0.00026078484}, {6,8,1,5,1,2,8,7,4,0,1,7,5,1,1,1,3,4,3,5,3,6,5,0,2,5,8,7,1,5,1,0,4,4,1,1,8,3,0,1,3,0,5,7,6,8,5,255,8,1,0,5,7,255,255,4,6,255,1,3,6,255,7,0,5,3,6,6,2,3,7,8,5,5,5,0,0,7,1,3,3,8,0,255,8,3,8,5,3,8,0,0,5,3,3,8,255,0,1,255,8,2,8,8,3,1,7,255,1,1,0,7,7,1,8,1,8,6,8,5,4,5,1,1,8,0,8,6,255,7,0,2,8,255,0,8,6,4,255,8,8,255,0,1,1,8,0,2,1,3,4,0,8,255,1,8,255,8,255,6,3,0,1,5,0,6,6,8,8,255,8,0,1,6,7,0,8,0,5,255,255,8,0,8,8,255,8,0,5,255,255,255,255,4,8,255,255,3,1,3,3,5,3,6,255,5,1,8,8,8,255,8,3,3,1,7,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,65535,95,97,99,101,103,65535,65535,105,107,65535,109,111,113,65535,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,65535,157,159,161,163,165,167,169,171,173,175,177,179,65535,181,183,65535,185,187,189,191,193,195,197,65535,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,65535,239,241,243,245,65535,247,249,251,253,65535,255,257,65535,259,261,263,265,267,269,271,273,275,277,279,65535,281,283,65535,285,65535,287,289,291,293,295,297,299,301,303,305,65535,307,309,311,313,315,317,319,321,323,65535,65535,325,327,329,331,65535,333,335,337,65535,65535,65535,65535,339,341,65535,65535,343,345,347,349,351,353,355,65535,357,359,361,363,365,65535,367,369,371,373,375,377,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,65535,96,98,100,102,104,65535,65535,106,108,65535,110,112,114,65535,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,65535,158,160,162,164,166,168,170,172,174,176,178,180,65535,182,184,65535,186,188,190,192,194,196,198,65535,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,65535,240,242,244,246,65535,248,250,252,254,65535,256,258,65535,260,262,264,266,268,270,272,274,276,278,280,65535,282,284,65535,286,65535,288,290,292,294,296,298,300,302,304,306,65535,308,310,312,314,316,318,320,322,324,65535,65535,326,328,330,332,65535,334,336,338,65535,65535,65535,65535,340,342,65535,65535,344,346,348,350,352,354,356,65535,358,360,362,364,366,65535,368,370,372,374,376,378,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31.5,65,32.5,78,107,43,26.5,83.5,39,99.5,21.5,33.5,92,162.5,36.5,36.5,92.5,13611,142.5,28.5,18,20.5,3737.5,16,8.5,3.5,15.5,5.5,364.5,7.5,55.5,24,16,-0.012637563,1118.5,19.5,27038,2.5,18.5,77,21.5,-0.0020259419,-0.02345722,13.5,625.5,-0.009733527,16176,3.5,17.5,31.5,17.5,62,55,1.5,60,92,-0.01103381,7,6.5,108.5,38,146.5,335.5,22,63.5,1.5,21,15.5,1986.5,26.5,313,0.0029194586,18.5,-0.0076677226,7.5,5.5,834.5,31.5,4.5,185.5,136.5,351.5,587,0.020244494,-0.0027477613,-0.0022802814,-0.00017683039,1.5,28.5,28.5,21.5,2.5,4.5,15.5,21,32.5,2,11,4.5,544,34,21.5,17.5,-0.0054541575,-0.0007642323,106,83.5,1367,17.5,1.5,4.5,146.5,4789.5,29.5,18,163.5,354,60.5,22.5,26.5,9,0.01584678,7.5,-0.0049135173,-0.00095200876,128.5,73.5,0.0062011154,2572,5.5,2.5,-0.009434595,-0.0026772493,11,-0.0019922324,149,15.5,1.5,15,20.5,-0.005805947,19,20.5,0.0018020178,13.5,67.5,16.5,0.0026844486,71,5,1.5,15.5,15.5,-0.0019422075,-0.008962405,7.5,-0.004480721,0.0055032657,0.0010600066,18.5,0.00035701948,0.0061733364,6.5,3,6.5,31.5,29,22,0.00068751845,0.01978659,2.5,-0.001148527,0.011606651,7,15.5,-0.0021765444,10,69,1432.5,957.5,544,16.5,957.5,0.005237409,494,0.0016571699,-0.0022070927,-0.0010157396,-0.004413783,864,0.001075068,1367,0.0032460806,0.0047214516,42.5,4789.5,-0.008362102,17.5,12,0.006679558,16,3.5,33.5,3496.5,3496.5,164.5,2.5,349,3742.5,-0.0005771345,0.004093073,0.004249124,0.0004951086,-0.0023744805,-0.00038721279,-0.018414797,-0.007510967,-0.0007718936,0.008367647,-0.0007288578,-0.004466883,-0.0076244134,-0.0024287435,-0.0021710075,-0.0057273996,-0.0014364332,-0.003941518,-0.002135799,-0.006196959,-0.00085648027,0.00016920186,-0.004203738,0.0042518466,-0.0056418204,0.0006631082,0.0013686874,-0.0010043763,0.0050220788,0.0011519856,-0.002690033,-0.00077926466,-0.0072197164,-0.0029534572,-0.003620933,0.0022223492,-0.0026356436,-0.00014696963,-0.004710722,-0.0005283977,-0.0077480334,-0.0023015272,-0.01866076,-0.00470727,0.008933014,0.004509265,-0.0061898963,0.00054876826,0.0004214809,-0.00605619,-0.002733952,0.00084562256,0.0011115738,-0.003713074,7.888332e-05,-0.0013677626,-0.0036041818,0.0061131865,-0.00011960442,0.0016946413,-0.0004809076,-0.00019371267,-0.0016937029,-0.00034313856,0.00053451926,0.0033148543,-0.0008869606,-0.004373275,0.0010676704,0.010316755,-0.0014216244,0.0075354227,-0.0042722556,0.002051167,0.0021454268,0.0045794826,-0.008547416,-0.0027836931,0.001795765,4.3802553e-05,0.002800551,0.0012474759,-0.0003776274,0.0012111857,0.0022090757,0.0068410942,-0.0007490938,0.0038296625,-0.0041466583,-0.002274622,-0.0004172921,-0.0039927135,-7.8975085e-05,0.0015054395,-0.0027574392,0.0021337173,0.002610318,-0.005753049,0.001835185,-0.001245604,0.008491377,0.002967987,0.0007550418,0.003421332,-0.00014439106,-0.0056477035,-0.0038134288,-0.0009867157,-0.00040310118,0.0029352815,0.0044838614,-0.0019908508,0.000438823,-0.0027125815,-0.0029933017,0.0021964656,-0.0012156201,-0.012294591,-0.00019587351,3.4928118e-05}, {5,2,2,0,3,6,3,6,2,3,8,4,6,6,5,3,6,0,6,1,8,8,0,8,8,8,8,8,4,8,5,5,8,255,6,8,0,8,8,4,8,255,255,8,0,255,0,8,8,6,8,0,6,8,4,4,255,8,8,2,7,2,2,2,2,8,8,8,6,2,0,255,8,255,8,8,0,3,8,2,0,0,1,255,255,255,255,8,2,2,8,8,8,8,8,3,8,8,8,0,4,8,8,255,255,4,4,4,8,8,8,0,0,7,8,3,2,6,1,2,8,255,8,255,255,6,7,255,6,8,8,255,255,8,255,0,8,8,8,8,255,8,8,255,8,2,8,255,2,8,8,8,8,255,255,8,255,255,255,8,255,255,8,8,8,6,0,0,255,255,8,255,255,8,8,255,8,0,0,0,0,8,0,255,0,255,255,255,255,4,255,4,255,255,0,0,255,8,8,255,8,8,3,0,0,2,8,2,1,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,65535,67,69,71,73,75,77,79,65535,65535,81,83,65535,85,87,89,91,93,95,97,99,101,103,65535,105,107,109,111,113,115,117,119,121,123,125,127,129,131,65535,133,65535,135,137,139,141,143,145,147,149,151,65535,65535,65535,65535,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,65535,65535,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,65535,217,65535,65535,219,221,65535,223,225,227,65535,65535,229,65535,231,233,235,237,239,65535,241,243,65535,245,247,249,65535,251,253,255,257,259,65535,65535,261,65535,65535,65535,263,65535,65535,265,267,269,271,273,275,65535,65535,277,65535,65535,279,281,65535,283,285,287,289,291,293,295,65535,297,65535,65535,65535,65535,299,65535,301,65535,65535,303,305,65535,307,309,65535,311,313,315,317,319,321,323,325,327,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,65535,68,70,72,74,76,78,80,65535,65535,82,84,65535,86,88,90,92,94,96,98,100,102,104,65535,106,108,110,112,114,116,118,120,122,124,126,128,130,132,65535,134,65535,136,138,140,142,144,146,148,150,152,65535,65535,65535,65535,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,65535,65535,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,65535,218,65535,65535,220,222,65535,224,226,228,65535,65535,230,65535,232,234,236,238,240,65535,242,244,65535,246,248,250,65535,252,254,256,258,260,65535,65535,262,65535,65535,65535,264,65535,65535,266,268,270,272,274,276,65535,65535,278,65535,65535,280,282,65535,284,286,288,290,292,294,296,65535,298,65535,65535,65535,65535,300,65535,302,65535,65535,304,306,65535,308,310,65535,312,314,316,318,320,322,324,326,328,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({39,25.5,70.5,24,4.5,20.5,78,24,52,40.5,24,46.5,22,70,126.5,22,22,31.5,8.5,36.5,62.5,6.5,26.5,12.5,2.5,287.5,26.5,19.5,69,15.5,1689,20.5,12.5,15,16.5,23.5,17.5,-0.0200406,-0.006570133,3.5,42,146,0.010975629,30,30,21.5,258,38,19.5,48.5,30.5,72.5,0.037156463,13192.5,30,175,55.5,-0.005414323,-0.013260989,83,47,21.5,1756,15.5,71,70,33.5,2,17.5,5,0.005158765,18.5,49.5,15.5,22,23.5,29,0.018320581,0.0069823186,33.5,62,-0.00086494035,58.5,-0.0075103343,9.5,1118.5,65.5,38.5,17.5,232.5,48.5,16.5,120.5,0.019290855,53,16,18.5,0.0066598863,71,49,-0.00013221592,544,33.5,37,17,41.5,65,14.5,11.5,20.5,19.5,1686,326,1500.5,543.5,6.5,23,23,-0.006479289,37.5,36.5,15.5,21.5,0.0028452815,0.0095709795,-0.00073395215,0.006190131,3,12,2.5,0.0041754153,-0.0056162197,14.5,52.5,64.5,50.5,89,-0.004734351,41,61,32.5,26.5,30.5,3,0.0077710426,-0.0061861193,-0.027440507,55,27,27.5,1986.5,56.5,-0.0036714193,27.5,15.5,8.5,41,34.5,2.5,2.5,4.5,236,125.5,-0.0064211893,171,0.0003065753,0.0030839818,7,18.5,63.5,67,0.0021598777,190.5,-0.0024585777,439,0.0048850123,0.01744725,21.5,51,17.5,2.5,-0.0077893743,-0.0014833291,172.5,50.5,-0.005773923,-0.011411487,65,-0.0048707346,5.5,0.01054799,19,21.5,17.5,20.5,575.5,18.5,423.5,607.5,15.5,12.5,6.5,1532.5,-0.0016988047,-0.00016478806,-0.0026372296,0.00048301797,0.0011354863,0.007879892,0.0017162742,-0.00042910982,-0.007748714,-0.001092781,0.0036617573,0.0015612014,-0.00042684757,-0.0061188224,0.0048249387,0.0016316159,-0.00041733665,-0.0020456125,-0.00092449004,-0.002042682,0.00030984494,-0.004910102,-0.0003617714,0.0018228343,0.0053541325,0.000541915,-0.004866,-0.0017911257,-0.001145575,0.0025217186,0.0011527827,-0.0014473852,0.010986473,-0.003026618,-0.0021673457,2.3219254e-05,-0.005138142,0.00025772708,7.53898e-05,-0.0062731877,-0.0010905841,0.0007627254,-0.0011841952,0.0020318313,0.00029984044,-0.0024242464,-0.002963213,-0.006912908,0.005933329,-0.0016216291,0.01453017,-0.0041946187,-0.00072225876,0.00082335545,-0.002927442,-0.0007640137,-0.0005665882,0.00011222883,0.0064969207,0.0011878052,-0.0014166556,0.0017318499,-0.00534946,0.00030783968,0.02001094,0.004422913,0.004312051,0.0002588047,-0.0023903206,0.00041437297,-0.0027632462,0.0018140359,1.702244e-05,-0.0028360286,0.00042062695,-0.0035445818,0.0017777318,0.0047638626,0.002997809,0.006187373,-0.0037968897,-0.0006291811,-0.0022597986,-0.0003219711,-0.005814667,-0.020313378,0.00017652659,0.005829733,-0.0031048513,0.0007467228,0.0006115029,0.007431092,0.00300199,-0.0008579694,-0.0017076863,0.00081903016,-0.004588659,-0.00091614213,0.0013150085,-0.0021258087,-0.0025090356,0.00197737,0.010219127,0.005380827,-2.0764895e-05,0.00090940966,-0.0018669078,0.00021877194,0.002281737,0.006459201,-0.0008778856,0.00036205302,0.0043210248,0.01989362,0.03026706,-0.0007290108,-0.005573535,0.005130095,-0.0036478979,-0.013481542,-0.005041622,0.0017781528,0.0015927803,0.006856295,-0.0007138629,-2.285055e-05}, {3,3,4,5,8,8,3,3,2,4,5,4,6,3,2,6,0,5,8,4,1,8,3,8,8,0,7,8,0,8,2,8,8,8,8,0,8,255,255,8,0,0,255,3,3,8,6,7,8,0,0,0,255,0,6,2,3,255,255,0,0,8,2,8,0,0,7,8,8,8,255,8,0,8,2,0,1,255,255,1,6,255,0,255,8,6,6,5,8,0,2,8,1,255,3,8,8,255,2,3,255,0,0,0,8,3,0,8,8,8,8,2,4,4,3,8,0,0,255,6,1,8,8,255,255,255,255,8,8,8,255,255,8,4,4,4,0,255,6,6,2,7,7,8,255,255,255,0,7,5,6,0,255,1,8,8,0,1,8,8,8,6,0,255,0,255,255,8,8,7,0,255,0,255,0,255,255,8,4,8,8,255,255,4,3,255,255,0,255,8,255,8,8,8,8,5,8,2,2,8,8,8,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,65535,65535,75,77,79,65535,81,83,85,87,89,91,93,95,97,65535,99,101,103,105,65535,65535,107,109,111,113,115,117,119,121,123,125,127,65535,129,131,133,135,137,139,65535,65535,141,143,65535,145,65535,147,149,151,153,155,157,159,161,163,65535,165,167,169,65535,171,173,65535,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,207,65535,209,211,213,215,65535,65535,65535,65535,217,219,221,65535,65535,223,225,227,229,231,65535,233,235,237,239,241,243,65535,65535,65535,245,247,249,251,253,65535,255,257,259,261,263,265,267,269,271,273,65535,275,65535,65535,277,279,281,283,65535,285,65535,287,65535,65535,289,291,293,295,65535,65535,297,299,65535,65535,301,65535,303,65535,305,307,309,311,313,315,317,319,321,323,325,327,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,65535,65535,76,78,80,65535,82,84,86,88,90,92,94,96,98,65535,100,102,104,106,65535,65535,108,110,112,114,116,118,120,122,124,126,128,65535,130,132,134,136,138,140,65535,65535,142,144,65535,146,65535,148,150,152,154,156,158,160,162,164,65535,166,168,170,65535,172,174,65535,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,208,65535,210,212,214,216,65535,65535,65535,65535,218,220,222,65535,65535,224,226,228,230,232,65535,234,236,238,240,242,244,65535,65535,65535,246,248,250,252,254,65535,256,258,260,262,264,266,268,270,272,274,65535,276,65535,65535,278,280,282,284,65535,286,65535,288,65535,65535,290,292,294,296,65535,65535,298,300,65535,65535,302,65535,304,65535,306,308,310,312,314,316,318,320,322,324,326,328,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({6067.5,6056.5,6077.5,6133,-0.011925534,6075.5,6102.5,5918.5,6153.5,10.5,0.0058280816,6331.5,8914,5907.5,5722.5,0.011140078,6205.5,6069.5,16,6081,6083.5,8530.5,9364.5,5888.5,13.5,3965.5,1.5,5713,6992,0.0012419202,0.004788633,12.5,0.0035263859,18.5,-0.009278772,-0.0024997168,3.5,8496.5,8187.5,9819,9381,5882,-0.017102838,0.0107863685,0.0038715445,-0.016405262,5765,0.004994889,7411.5,5800,3.5,2.5,7314,0.0019114811,6486.5,-0.0011201253,-0.0003386246,0.003419802,6093.5,8494.5,6976.5,11.5,8755.5,8576.5,11393,12,2065,5666,5886,5238.5,5628,5787,-0.006315919,9,0.00402511,-0.0014018825,-0.011166955,1.5,6608.5,21.5,7720.5,0.00017211161,-0.0006001035,7.5,0.000978281,8368.5,2,-0.025787173,1.5,10881.5,2017,2.5,11744,9203,9500.5,9320.5,0.0050788666,0.011883221,0.0066773556,0.015050839,7099.5,-0.00015843521,-0.0020720612,0.011258928,0.0011576911,-0.0011391202,-0.007605175,-0.0015377963,0.0024877018,-0.0102699315,-0.017390106,0.00063765416,-0.004051568,0.004905916,0.0025415428,4.323886e-05,0.0021074412,0.0021607282,0.0100148,-0.0024835572,0.00018646302,-0.001028167,-0.00015867544,0.00017719773,-0.0012005327,-0.0059954296,0.016023275,-0.010203915,-0.001030337,0.00011790363,0.01174835,-0.0071697654,0.004927383,0.0036175866,-0.011769895,0.0010672454,-0.0038840126,-0.0007452974,-0.004585154,-0.0125832325,-0.002991407,0.0012892577,-0.00043639267,0.0014908558,-2.3115788e-05}, {0,0,0,1,255,0,0,1,1,8,255,6,6,1,0,255,1,0,8,0,0,6,6,1,8,6,8,2,1,255,255,8,255,8,255,255,8,6,7,7,6,1,255,255,255,255,5,255,2,0,8,8,3,255,1,255,255,255,0,6,0,8,2,7,7,8,1,1,1,0,2,0,255,8,255,255,255,8,1,8,3,255,255,8,255,6,8,255,8,0,1,8,0,6,2,2,255,255,255,255,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,65535,9,11,13,15,17,65535,19,21,23,25,65535,27,29,31,33,35,37,39,41,43,45,47,49,51,65535,65535,53,65535,55,65535,65535,57,59,61,63,65,67,65535,65535,65535,65535,69,65535,71,73,75,77,79,65535,81,65535,65535,65535,83,85,87,89,91,93,95,97,99,101,103,105,107,109,65535,111,65535,65535,65535,113,115,117,119,65535,65535,121,65535,123,125,65535,127,129,131,133,135,137,139,141,65535,65535,65535,65535,143,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,65535,10,12,14,16,18,65535,20,22,24,26,65535,28,30,32,34,36,38,40,42,44,46,48,50,52,65535,65535,54,65535,56,65535,65535,58,60,62,64,66,68,65535,65535,65535,65535,70,65535,72,74,76,78,80,65535,82,65535,65535,65535,84,86,88,90,92,94,96,98,100,102,104,106,108,110,65535,112,65535,65535,65535,114,116,118,120,65535,65535,122,65535,124,126,65535,128,130,132,134,136,138,140,142,65535,65535,65535,65535,144,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({3507,1272.5,3576.5,20.5,1508.5,3106,3610,3.5,2542.5,18.5,1689,16,18.5,18,5871.5,1440,1564,1332.5,636,4.5,1013.5,18.5,914,6.5,4238.5,15.5,4790,3606.5,6353,5869,5872.5,233.5,1469,655,1185.5,312.5,2105,4774.5,3719.5,1715,1279,0.031724464,1344,1672,1104,18.5,1732,-0.007961006,9.5,-0.012559182,-0.0028646372,8.5,3801.5,-0.0054233936,9810.5,3600,8,0.013899309,-0.00052947126,5666,-0.013119407,6145,5873.5,106,459.5,2.5,2.5,569,914.5,1452.5,18.5,103.5,306,666.5,21826,671,437,1466,-0.003465994,2.5,2.5,6.5,1281,1884,1935.5,16.5,14.5,-0.010594112,1398,3775.5,457,2766.5,2172.5,0.00014443997,4238.5,2.5,4790,0.008170128,11836.5,-0.00022309204,0.0018814737,4,8,3.5,13,4985.5,6341.5,0.007105221,-0.0035121266,-0.02083893,6427.5,25.5,75,438,28.5,1577,1728.5,1107,1741,67,548.5,1283,985.5,15.5,1762.5,941,804.5,79.5,591,68,602.5,-0.0017886302,-0.010898879,21.5,-0.0035947282,1174,4601,0.0007154552,0.010163872,0.007969903,0.022042282,7461.5,1320,2931,2931,5.5,1602,0.014731556,2285,1213.5,19.5,1449,4948.5,6.5,1398,6,16.5,0.030921742,1658.5,683,4.5,3049,1319.5,16.5,2.5,15.5,7581.5,-0.0061234236,12.5,6929,3543,13.5,12.5,0.0015856944,0.00013801681,4831,15.5,3,14,1.5,-0.0042496296,-0.00023731783,0.0012029129,4408,2735,5756,6951,7887.5,6458.5,0.0004955716,0.0028153467,-0.0034523786,0.00021978658,-0.0024089369,-0.011143683,-0.0083383955,0.0007766654,0.0021032218,0.025921166,0.0136815,-0.0047557782,-0.0034126022,-0.010835828,0.013448059,-0.00486194,-0.00034787087,0.0005457482,0.009903419,0.001402135,-0.002881948,0.00034011065,0.0020439995,-0.00044829692,-0.0038394872,-0.012382235,-0.007481906,0.0016203666,-0.015126886,-0.005775215,-0.013058804,0.009949141,6.176627e-05,0.004774535,-0.00792848,-0.0019959963,0.0041107843,0.025903791,-0.0053524347,0.0033421235,0.00016043286,0.002977443,-0.0021565708,-0.0068592466,-0.0012106817,0.00055286265,0.0034010918,0.0003958005,0.00013467588,-0.0023723326,-0.0043785763,0.010849059,0.020400004,-0.0015396274,-0.00028925305,0.016916296,-0.00012213814,-0.00515185,0.003163216,-0.0006195488,-0.0038453825,0.0048840228,0.014988272,0.009220025,-0.010717356,-1.0336882e-05,0.009572883,0.0017023648,-0.003465463,0.0021338258,-0.010910106,-0.001536694,0.0018179332,0.012559458,-0.0012764185,-0.0044928654,-0.0043836334,0.015476951,-7.014703e-05,0.0027859071,0.0020323924,0.004245309,0.00023330441,0.0035691825,0.016517453,0.0031431005,-0.0026661688,-0.017728588,-0.0072056795,-0.0002023374,0.0007225041,-0.0064344094,0.0007443991,-0.0025879515,0.00024339459,-0.002714115,-0.0022507908,0.0016160008,0.0011079537,0.0031068006,-0.0054574083,-0.0025990326,0.001513749,0.00048226886,0.0016646025,-0.00014580185,-0.0006184826,0.0014276847,0.004063524,0.0007863605,0.004997392,0.0018685326,0.0007793456,-2.1219654e-05,0.0001611309,-0.00085174706,-0.006334897,0.0010078138,-0.0026481566,-0.011407803,0.002312484,0.00017468237,0.00027564313,0.0022571215,-0.0050774175,-7.3102924e-06}, {2,3,2,8,3,1,2,8,7,8,2,8,8,8,0,2,2,7,3,8,2,8,6,8,0,8,1,2,0,0,0,0,4,2,3,1,1,4,4,2,7,255,5,2,6,8,7,255,8,255,255,8,0,255,0,2,8,255,255,1,255,1,0,6,1,8,8,3,3,6,8,3,6,4,0,0,0,4,255,8,8,8,3,0,7,8,8,255,2,1,6,0,4,255,0,8,1,255,0,255,255,8,8,8,8,1,1,255,255,255,0,3,4,0,4,0,0,3,6,7,2,1,2,8,2,5,1,3,6,7,6,255,255,8,255,4,0,255,255,255,255,0,2,0,0,8,2,255,5,0,8,2,0,8,2,8,8,255,3,6,8,0,4,8,8,8,6,255,8,0,2,8,8,255,255,0,8,8,8,8,255,255,255,0,6,0,1,5,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,65535,83,85,87,89,91,65535,93,65535,65535,95,97,65535,99,101,103,65535,65535,105,65535,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,65535,141,143,145,147,149,151,153,155,65535,157,159,161,163,165,65535,167,169,171,65535,173,65535,65535,175,177,179,181,183,185,65535,65535,65535,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,65535,65535,229,65535,231,233,65535,65535,65535,65535,235,237,239,241,243,245,65535,247,249,251,253,255,257,259,261,263,65535,265,267,269,271,273,275,277,279,281,65535,283,285,287,289,291,65535,65535,293,295,297,299,301,65535,65535,65535,303,305,307,309,311,313,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,65535,84,86,88,90,92,65535,94,65535,65535,96,98,65535,100,102,104,65535,65535,106,65535,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,65535,142,144,146,148,150,152,154,156,65535,158,160,162,164,166,65535,168,170,172,65535,174,65535,65535,176,178,180,182,184,186,65535,65535,65535,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,65535,65535,230,65535,232,234,65535,65535,65535,65535,236,238,240,242,244,246,65535,248,250,252,254,256,258,260,262,264,65535,266,268,270,272,274,276,278,280,282,65535,284,286,288,290,292,65535,65535,294,296,298,300,302,65535,65535,65535,304,306,308,310,312,314,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({4705.5,4471,4724,3789,8940.5,9855,7259,3622,3842,3442.5,9083,2.5,12,6854.5,7262,3483,4553.5,4.5,4.5,17.5,7636.5,13.5,4774,-0.003839404,18.5,2.5,0.010155777,6844.5,9091,-0.019775173,9098.5,16621,4351,4084.5,5440,5086,3958.5,5475,5244,3611.5,2817.5,6791,4592,4,9085.5,14332,13514,16.5,7482.5,0.00089685584,5,1.5,-0.019318521,8304.5,9347.5,8983.5,8141,3805.5,3.5,4525,4936,3932,0.014980893,17.5,15.5,4545,3813,3688.5,13.5,3219,5946,8414.5,5494,2.5,6.5,2706,0.0124769015,7.5,2.5,11.5,7745.5,9085.5,-0.005222903,-0.013389559,0.0041666045,20.5,6.5,2.5,4.5,7.5,0.0120471725,0.00038146647,0.0011854923,0.0061848317,8,6223,8235,8013,7072.5,6306.5,4118.5,7418.5,6853.5,9260.5,8162.5,3731.5,3810,11779,-0.004166703,3158,1968.5,4.5,4.5,5,4364,4.5,5001.5,3779,4375.5,0.0014060969,0.000330118,6525.5,9021.5,2505.5,6.5,8.5,18.5,1376,2.5,8302,4317.5,5733,12.5,17.5,5246,0.00447521,7,2.5,2776.5,-0.0015062599,18.5,7031.5,4974,5626.5,6968,4.5,0.0062902793,0.007935939,10217.5,0.006360698,-0.0063984357,5.5,0.0013267035,24766,13.5,-0.0015912586,16.5,23708,23708,7482.5,14.5,-0.0016376398,0.0035031808,6206.5,5993,7604.5,6167,6112.5,7049,0.0043398547,7360.5,5859.5,1.5,2555,4661.5,5602.5,8099,5469.5,9320.5,6361,7004.5,-0.01816752,10286.5,-7.348702e-06,0.002386985,-0.0047822017,-0.00028925197,-0.0010884227,-0.008192119,-0.0013953475,-0.0051161656,-0.0072638677,0.00062684313,-0.0009290981,-0.004482991,-0.0032295794,0.0014402823,-0.0065238476,-0.001515766,0.005209196,0.0017088173,-0.0030454444,0.001676412,0.00016518345,-0.0033988138,0.0010596317,-0.0063782367,0.010502535,0.0031699005,-0.0055987183,-0.009710831,-0.0007432971,-0.004764997,-0.0060776514,-0.0014181979,-0.0023938532,-0.0068469266,2.7714184e-05,0.0032114764,-0.0008071813,0.00072732806,0.007836606,-0.0012978947,0.0013200027,0.004915657,-0.0021207745,-0.009997117,0.001264158,-0.0015077696,-0.0015717201,0.0006026743,-0.0016641384,-0.0059060077,0.000762801,0.007382651,0.0043565403,-1.8798999e-05,0.0006951043,0.0023625416,6.666157e-05,-0.0021890039,-0.00010920769,0.0011486171,0.0004879627,0.0016314756,0.003944599,-0.0033524826,-0.0032732673,0.0033776257,-0.008040016,-0.01676198,-0.015056878,-0.0032983476,0.0047406205,0.0002479422,0.0007630284,-0.0011089832,-0.001982026,-0.0043801023,-0.003767385,-0.0014483299,0.0015847686,-0.00227785,0.0036236725,0.0084885545,0.0044812304,0.00043262666,-0.0043247556,-0.0011718103,0.00107045,-0.00067094545,0.0033588035,0.0006778622,0.0024056784,-0.01186386,0.0021543973,0.0131594585,-0.00017213667,-0.004340045,0.004369566,0.0002655176,0.008000375,0.0025394403,0.008006435,0.016760793,-0.020373082,-0.0081621865,-0.0026635404,0.004058534,-0.021400739,-0.008094727,0.013823834,0.0027671491,-0.0027544803,0.00029116045,0.003262102,-0.0034860466,0.0029415542,-0.00078444986,0.00041644648,-0.0038299449,-0.018763771,-0.004672294,-0.00063408696,0.022196535,-3.9186878e-05,0.0026339944,-0.00088745885,3.107968e-05}, {7,7,7,3,6,0,1,3,3,2,2,8,8,0,1,3,4,8,8,8,4,8,1,255,8,8,255,0,6,255,1,4,1,5,6,2,7,1,3,6,4,0,5,8,0,0,0,8,0,255,8,8,255,7,6,1,3,7,8,0,1,2,255,8,8,1,3,7,8,7,2,6,2,8,8,0,255,8,8,8,4,0,255,255,255,8,8,8,8,8,255,255,255,255,8,1,4,7,0,7,1,7,6,0,3,7,7,0,255,0,1,8,8,8,6,8,6,3,0,255,255,0,0,1,8,8,8,5,8,1,7,6,8,8,3,255,8,8,4,255,8,4,5,2,0,8,255,255,4,255,255,8,255,6,8,255,8,0,0,0,8,255,255,0,0,4,7,6,0,255,0,7,8,1,1,3,7,2,2,2,6,255,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,47,49,65535,51,53,65535,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,65535,93,95,65535,97,99,101,103,105,107,109,111,113,65535,115,117,119,121,123,125,127,129,131,133,135,137,139,65535,141,143,145,147,149,65535,65535,65535,151,153,155,157,159,65535,65535,65535,65535,161,163,165,167,169,171,173,175,177,179,181,183,185,187,65535,189,191,193,195,197,199,201,203,205,207,65535,65535,209,211,213,215,217,219,221,223,225,227,229,231,233,235,65535,237,239,241,65535,243,245,247,249,251,253,65535,65535,255,65535,65535,257,65535,259,261,65535,263,265,267,269,271,65535,65535,273,275,277,279,281,283,65535,285,287,289,291,293,295,297,299,301,303,305,65535,307,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,48,50,65535,52,54,65535,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,65535,94,96,65535,98,100,102,104,106,108,110,112,114,65535,116,118,120,122,124,126,128,130,132,134,136,138,140,65535,142,144,146,148,150,65535,65535,65535,152,154,156,158,160,65535,65535,65535,65535,162,164,166,168,170,172,174,176,178,180,182,184,186,188,65535,190,192,194,196,198,200,202,204,206,208,65535,65535,210,212,214,216,218,220,222,224,226,228,230,232,234,236,65535,238,240,242,65535,244,246,248,250,252,254,65535,65535,256,65535,65535,258,65535,260,262,65535,264,266,268,270,272,65535,65535,274,276,278,280,282,284,65535,286,288,290,292,294,296,298,300,302,304,306,65535,308,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7792.5,7615.5,7924.5,7614.5,8608,8231,7975.5,10101,6514.5,8340,8495,8097.5,7630,7957.5,5618,9669,7426.5,5.5,-0.017444115,6676.5,7391.5,8362,-0.021628188,7183.5,3.5,5.5,5.5,7936.5,8249,9068.5,5818.5,9636.5,1.5,8212.5,4.5,-0.0027726924,17.5,6946.5,7633.5,6210,8966,15.5,1.5,5726.5,8254,-0.007595283,-0.022214487,0.0011594541,-0.0081698,8369.5,8369.5,7549,7956.5,6992,8487.5,4252.5,5430.5,6475,7758,6927,2.5,7587.5,6496,5824,15.5,-0.0015301903,-0.015617731,15.5,0.0009788565,5821,4334,6.5,2268.5,0.011241767,0.025676353,4.5,5.5,7501,17.5,-0.015251617,8158,9.5,4738,7286,8997.5,1.5,1.5,16,9242.5,-0.0017754043,0.004891731,17.5,-0.009624667,21.5,0.007759191,0.028099341,0.013295698,3722.5,5119.5,16,1.5,5688.5,12955.5,6954,1611.5,6719.5,8282.5,-0.002373591,-0.017774608,-0.027040338,6761.5,6295,9888,25163,1.5,3695.5,9117.5,11,-0.0021435816,6592,3.5,15.5,-0.011343725,2,18.5,5.5,7387,0.0017666307,-0.0028229177,0.0064050765,0.0118654715,12.5,5,0.006825933,7209,-0.0077757235,10.5,2.5,14.5,7562.5,1.5,0.010603471,7486,5.5,9.5,-0.009282802,-0.002610045,0.0015062004,10800,0.0038420844,0.009120983,8.5,19.5,7955.5,4296.5,17.5,0.008915107,4.5,1.5,4.5,-0.015596571,11.5,-0.004664247,5104.5,9886.5,18.5,0.013758095,7605,0.0072505004,7544.5,10669.5,5.5,8877,0.00010435064,0.0043582614,-1.2997406e-05,-0.0045758057,0.003234402,-0.0055454825,0.002634764,0.008121203,0.0012151784,-0.0028098137,0.0029342647,-0.0005737708,-0.0079112565,-0.00075740606,0.006563195,-0.001162655,-0.009801756,-0.0025904328,0.00089983403,8.9242707e-07,0.0014117791,0.005940778,-0.0013882624,-0.0052204784,-0.0017726045,-0.00584582,-0.015307534,-0.0057999785,-0.0003104751,0.0022073644,-0.005692897,-0.0010488929,0.0063086334,0.0030533485,-0.0004860961,-0.0036052037,0.0035479614,0.0017969933,0.0026783396,-0.00042074473,-0.0031857328,-0.000583168,-2.2621956e-05,0.0065446245,-0.0029767905,0.0026655796,-0.0033541692,-0.008621595,0.004460473,-0.009655335,-0.0013824408,0.0042600143,-0.0013979109,-0.0067177513,0.0013475501,-0.001198766,-0.0007527385,0.00017645319,-0.00023252364,0.0025993867,-0.0006658914,0.00058308523,-5.578848e-05,-0.0027627836,-0.0012136799,0.0036727109,0.0023275483,-0.0031259346,0.00070879934,-0.0018774321,-0.008949316,-0.003216463,-0.0029262896,-0.0096610775,-0.0028339094,0.0004856465,0.0006929378,-0.015040553,0.0022709635,0.00052786566,0.0072399126,0.00041756468,-2.8720955e-05,-0.004491029,-2.3993764e-05,-0.0028627543,-0.013559512,0.00042544553,-0.015300167,-0.0060285777,0.0005293021,-1.5177028e-05}, {6,6,6,6,5,4,6,2,0,1,0,0,0,6,2,2,6,8,255,2,4,4,255,3,8,8,8,6,0,7,2,2,8,4,8,255,8,4,6,4,0,8,8,4,7,255,255,255,255,0,0,0,6,2,0,3,4,0,4,3,8,4,7,6,8,255,255,8,255,2,3,8,3,255,255,8,8,0,8,255,0,8,1,0,3,8,8,8,1,255,255,8,255,8,255,255,255,3,2,8,8,3,7,5,3,3,4,255,255,255,6,1,2,2,8,0,0,8,255,0,8,8,255,8,8,8,3,255,255,255,255,8,8,255,0,255,8,8,8,4,8,255,1,8,8,255,255,255,0,255,255,8,8,6,4,8,255,8,8,8,255,8,255,0,7,8,255,1,255,4,3,8,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,65535,37,39,41,65535,43,45,47,49,51,53,55,57,59,61,63,65,65535,67,69,71,73,75,77,79,81,83,65535,65535,65535,65535,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,65535,65535,117,65535,119,121,123,125,65535,65535,127,129,131,133,65535,135,137,139,141,143,145,147,149,151,65535,65535,153,65535,155,65535,65535,65535,157,159,161,163,165,167,169,171,173,175,65535,65535,65535,177,179,181,183,185,187,189,191,65535,193,195,197,65535,199,201,203,205,65535,65535,65535,65535,207,209,65535,211,65535,213,215,217,219,221,65535,223,225,227,65535,65535,65535,229,65535,65535,231,233,235,237,239,65535,241,243,245,65535,247,65535,249,251,253,65535,255,65535,257,259,261,263,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,65535,38,40,42,65535,44,46,48,50,52,54,56,58,60,62,64,66,65535,68,70,72,74,76,78,80,82,84,65535,65535,65535,65535,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,65535,65535,118,65535,120,122,124,126,65535,65535,128,130,132,134,65535,136,138,140,142,144,146,148,150,152,65535,65535,154,65535,156,65535,65535,65535,158,160,162,164,166,168,170,172,174,176,65535,65535,65535,178,180,182,184,186,188,190,192,65535,194,196,198,65535,200,202,204,206,65535,65535,65535,65535,208,210,65535,212,65535,214,216,218,220,222,65535,224,226,228,65535,65535,65535,230,65535,65535,232,234,236,238,240,65535,242,244,246,65535,248,65535,250,252,254,65535,256,65535,258,260,262,264,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({8.5,4785,5908.5,4768,6395,5872.5,5954,1215.5,5560,5920.5,6529.5,5871.5,7829.5,15.5,9048.5,3285.5,3742.5,1.5,4.5,6005.5,4.5,6520,7476,5798,6145,6056.5,-0.015812827,5928,3076.5,7608.5,9110.5,109,6.5,1256.5,2771.5,0.0009911036,0.008755864,0.0031041275,7.5,6003.5,5417,6350,9630,6434.5,2.5,5036,11543.5,5787.5,5472.5,11.5,-0.0024677138,5740.5,12.5,5582,5009.5,0.011115898,6290.5,6181,7998,3456,2065,100,845.5,4897,-0.0021129341,4.5,6754,2274,5761.5,6.911765e-05,0.0019152807,7741.5,-0.01675881,5466,7183.5,1.5,12030,6364,5.5,11400.5,4.5,0.02062562,9407.5,1.5,5442,17376,11666,4979.5,5509.5,5506.5,5541,0.00377082,0.008252501,20.5,-0.007847183,0.0026026226,16.5,12,5916.5,11.5,12.5,18.5,5924.5,6296.5,8072.5,5343,9067,0.010744124,9263,0.012610473,10255,354.5,0.009395819,808,887.5,-0.012952635,-0.0061290185,2203.5,2203.5,3673,2571.5,731.5,4109.5,3948,5072,5098,1.5,7581,1.5,9276,7774,6006,5684.5,6519.5,6059,6235,9546,10267,6519.5,6419,10718,6647,5.5,6673.5,0.011432275,6785,2559.5,4720,9576,9458,17512,11639.5,21829,4055.5,2054,5792,0.009453224,-0.016268285,12.5,16.5,7497.5,6210.5,5552,-0.0022409407,0.0011882841,5916.5,5925,0.001473725,6042,0.0021227612,-0.00018700294,6948.5,5946.5,4895.5,5939,0.0022281,-0.0095938705,5888.5,6064.5,7357.5,15.5,12141,9814.5,6595.5,6733,3629.5,10763,5246,10965.5,0.00069483137,-0.0014529786,-0.0011754186,-0.005761047,0.011333567,0.0005611124,0.0033006668,0.012098007,0.0071065496,-0.005964801,0.00069834484,0.0048693917,0.0019542782,0.0048350696,-0.0032633473,0.0004271126,0.0041804393,0.0006537436,-0.0015596979,-0.00020715245,0.0018856442,-0.00056547776,0.0008325094,-0.0003488574,-0.01901836,-0.003803743,0.006205782,-0.00038324652,-0.013878591,-0.002640969,0.006721013,-0.0006382628,-0.0075619468,0.0009233765,-0.0034358965,0.0077390536,0.0025884293,-0.0041711074,-0.0035885142,-0.0072340467,-0.0007526884,0.004845194,-0.0022588528,0.00074132,-0.006299683,0.0039477567,0.014653756,-0.0005248789,0.001931409,-0.0025947609,0.001383698,0.005838487,-0.002209489,-0.008427943,-0.0037413388,0.0031042087,0.0067377756,-0.0003320784,-0.0004324885,0.00645803,0.00030890346,-0.018703496,-0.01053804,-0.0005244386,0.0022114946,0.0069481404,-0.00059104915,0.00138879,-1.3705934e-06,-0.0017618142,0.008191744,0.00039206893,0.00038318356,0.012869489,0.0002956421,-0.0001213652,-0.00015041855,-0.001083232,0.003867967,0.0002044691,-0.0010873923,0.0022243587,0.00083091966,-0.006862311,0.00011622163,0.005647523,-0.0068937014,-0.0006127966,-0.00016575126,-0.0021048384,-0.003053115,0.00027800264,0.00081100885,-0.0006926582,0.001316574,0.0025318644,0.008092461,0.0023508042,-0.008793207,-0.0027506093,-0.0037659274,-2.379653e-05,0.0005342679,0.0047690957,0.0023677794,-0.0005545233,-0.00014396232,-0.00753374,0.00075632107,0.010612547,-0.0009266411,-0.0088820215,-0.00038581918,0.0024927738,0.0004636786,-0.005068579,0.0051765162,-0.0017588356,0.004581394,-0.00627751,0.003856514,0.0004330358,7.842093e-05,-0.007524053,0.004496624,-0.0032752089,0.0016950334,-0.00060434145,0.0017784821,-3.4066095e-05}, {8,0,0,0,1,0,0,5,6,1,1,0,4,8,4,0,3,8,8,7,8,1,1,0,1,1,255,0,7,6,4,6,8,5,4,255,255,255,8,7,0,0,6,1,8,3,1,0,4,8,255,1,8,1,2,255,5,7,7,5,1,6,3,2,255,8,6,1,2,255,255,3,255,5,2,8,0,5,8,2,8,255,0,8,7,2,1,1,4,3,5,255,255,8,255,255,8,8,0,8,8,8,0,5,7,1,7,255,0,255,2,0,255,3,3,255,255,2,2,3,3,0,1,1,3,6,8,6,8,6,6,1,3,3,1,0,3,6,3,3,0,3,8,0,255,0,7,7,0,0,2,1,1,0,6,0,255,255,8,8,3,4,1,255,255,0,0,255,1,255,255,6,0,2,0,255,255,7,6,7,8,2,6,3,3,2,0,5,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,65535,53,55,57,59,61,63,65,67,65535,65535,65535,69,71,73,75,77,79,81,83,85,87,89,91,65535,93,95,97,99,65535,101,103,105,107,109,111,113,115,65535,117,119,121,123,65535,65535,125,65535,127,129,131,133,135,137,139,141,65535,143,145,147,149,151,153,155,157,159,65535,65535,161,65535,65535,163,165,167,169,171,173,175,177,179,181,183,65535,185,65535,187,189,65535,191,193,65535,65535,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,65535,249,251,253,255,257,259,261,263,265,267,269,65535,65535,271,273,275,277,279,65535,65535,281,283,65535,285,65535,65535,287,289,291,293,65535,65535,295,297,299,301,303,305,307,309,311,313,315,317,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,65535,54,56,58,60,62,64,66,68,65535,65535,65535,70,72,74,76,78,80,82,84,86,88,90,92,65535,94,96,98,100,65535,102,104,106,108,110,112,114,116,65535,118,120,122,124,65535,65535,126,65535,128,130,132,134,136,138,140,142,65535,144,146,148,150,152,154,156,158,160,65535,65535,162,65535,65535,164,166,168,170,172,174,176,178,180,182,184,65535,186,65535,188,190,65535,192,194,65535,65535,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,65535,250,252,254,256,258,260,262,264,266,268,270,65535,65535,272,274,276,278,280,65535,65535,282,284,65535,286,65535,65535,288,290,292,294,65535,65535,296,298,300,302,304,306,308,310,312,314,316,318,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({305,210,331.5,146.5,588.5,21,6365.5,39,21.5,91.5,2174.5,15.5,235,5765.5,6366.5,34,26.5,8.5,-0.007990465,15.5,2663.5,7.5,16.5,7.5,274.5,-0.0017946431,0.04110441,2.5,5437.5,1.5,5618,53.5,14.5,19.5,62.5,3,17.5,0.004393332,0.00012741178,15.5,12,2211.5,12.5,3.5,6312.5,64.5,274.5,0.007519629,18.5,3597.5,4.5,7007,5588.5,-0.016941676,-0.00547313,6419,5651,37.5,55.5,42,24.5,15.5,121.5,12.5,42.5,135.5,0.0078094043,538,135.5,65.5,-0.013364761,347,16,8646,4.5,4595,18.5,828,7608,-0.0059586195,11965.5,2.5,0.0080964295,64.5,8.5,17.5,-0.00096558465,1973,4355,1224.5,403.5,1217,5183.5,5109.5,8524.5,-0.015490013,3773,6272.5,5718,74,111,78,41,8.5,4.5,0.008515761,88.5,31520,625.5,608,12905.5,32.5,66,15.5,5.5,0.002801273,1.5,12.5,15,-0.0080209,0.008079918,134,-0.007974281,7.5,4.5,14.5,19.5,0.0030349873,0.00038412985,2,-0.009062309,8.5,0.0064267553,5378.5,20.5,5457.5,-0.008310138,7.5,-0.0043990887,-0.0023280631,0.0007161981,1.5,4.5,0.0015308325,0.0038769823,-0.0027109573,-0.001134818,0.002373749,0.005956816,1155.5,2417,3239,4918,87.5,2360,427.5,942,15.5,4.5,0.012213621,0.0051086703,7.5,5469,6071.5,8792,2.5,3089,6238,5,7724.5,7793,-0.0002746832,-0.0049947766,-0.0075620473,-0.00063992396,-0.00059109734,-0.0035364067,0.00013928556,0.0028022474,-0.0002875592,0.0036551089,-0.0012939229,-0.007798319,-0.0025971606,0.0020489967,-0.0019050373,0.0028833665,0.0032735523,-0.0061209435,-0.002357644,0.015992751,-0.0077459575,-0.0007769063,-0.0013934405,0.0048407703,-0.00129568,0.0021817237,-0.0027708095,-0.008868865,-0.0012910047,0.00094996596,-0.0059532737,-0.002028798,0.004584344,0.00060303014,-0.002285511,0.0021046742,-0.0009859082,-0.0031565465,-0.009379158,-0.004258875,-0.00012138255,0.0005209949,0.0028448123,0.009664361,0.001383027,-0.00021491983,0.0025850015,-0.0014753819,0.00038972253,0.0013211393,0.0001452224,-0.0051911213,0.005809964,0.0018427207,-0.003019653,0.0020472598,0.0017003333,-0.0006916774,0.0006631527,-0.0018448031,0.0015707588,0.00041098185,-0.002218283,0.0030158355,-0.00718306,-0.0014893111,-0.0029206264,0.001691447,-0.0025327688,0.0010232613,-0.0156424,-0.0014169278,0.0078005414,0.0008284356,0.00080010726,-0.0055263597,0.0011187501,-6.5388995e-05,-0.002936649,-0.008010793,-0.00088838395,0.0022171696,0.005903495,0.0006294721,-0.0052086846,-0.015618697,0.00051552756,-0.0020801723,0.018713778,0.0013742133,-0.0017051625,0.00015387127,-0.011954182,-0.0010802803,0.012521818,0.0064303773,-3.1264583e-05,0.0018219072,-0.009669059,0.0016839936,0.00048179957,-2.8879409e-05}, {5,4,4,5,0,8,6,3,8,2,1,8,0,6,6,3,7,8,255,8,2,8,8,8,0,255,255,8,4,8,2,0,8,8,2,8,8,255,255,8,8,0,8,8,2,0,0,255,8,1,8,3,4,255,255,6,2,2,6,6,5,8,2,8,0,0,255,0,0,0,255,0,8,2,8,0,8,4,7,255,0,8,255,0,8,8,255,2,6,2,5,0,5,0,3,255,3,0,2,4,4,0,7,8,8,255,4,3,0,1,0,1,4,8,8,255,8,8,8,255,255,2,255,8,8,8,8,255,255,8,255,8,255,0,8,0,255,8,255,255,255,8,8,255,255,255,255,255,255,7,3,0,7,3,5,4,4,8,8,255,255,8,4,7,3,8,1,0,8,6,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,65535,37,39,41,43,45,47,65535,65535,49,51,53,55,57,59,61,63,65,67,65535,65535,69,71,73,75,77,79,81,83,65535,85,87,89,91,93,65535,65535,95,97,99,101,103,105,107,109,111,113,115,65535,117,119,121,65535,123,125,127,129,131,133,135,137,65535,139,141,65535,143,145,147,65535,149,151,153,155,157,159,161,163,65535,165,167,169,171,173,175,177,179,181,65535,183,185,187,189,191,193,195,197,199,65535,201,203,205,65535,65535,207,65535,209,211,213,215,65535,65535,217,65535,219,65535,221,223,225,65535,227,65535,65535,65535,229,231,65535,65535,65535,65535,65535,65535,233,235,237,239,241,243,245,247,249,251,65535,65535,253,255,257,259,261,263,265,267,269,271,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,65535,38,40,42,44,46,48,65535,65535,50,52,54,56,58,60,62,64,66,68,65535,65535,70,72,74,76,78,80,82,84,65535,86,88,90,92,94,65535,65535,96,98,100,102,104,106,108,110,112,114,116,65535,118,120,122,65535,124,126,128,130,132,134,136,138,65535,140,142,65535,144,146,148,65535,150,152,154,156,158,160,162,164,65535,166,168,170,172,174,176,178,180,182,65535,184,186,188,190,192,194,196,198,200,65535,202,204,206,65535,65535,208,65535,210,212,214,216,65535,65535,218,65535,220,65535,222,224,226,65535,228,65535,65535,65535,230,232,65535,65535,65535,65535,65535,65535,234,236,238,240,242,244,246,248,250,252,65535,65535,254,256,258,260,262,264,266,268,270,272,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({41.5,39.5,2635,39,41.5,2631,2646,27.5,58,16,18.5,10834,-0.01441056,2643.5,2670.5,26,20.5,7,15.5,2.5,40.5,231,231,53,26097.5,8.5,6087,2629.5,6396,53,4.5,47.5,31,3.5,46,3.5,94,40.5,7.5,17.5,0.00051675225,16.5,15.5,-0.0016323827,0.010711496,64.5,2652,9320.5,17.5,2463,2463,0.014113511,15,18.5,18516,5639.5,6434,22,15.5,57,9.5,35.5,28.5,284.5,27,-0.008022774,-0.022554278,-0.0063783126,12.5,94,8.5,-0.0025343488,0.0010732099,0.018017484,0.0017114998,3.5,11.5,-0.000489464,-0.0031838485,8.5,17.5,-0.0061091557,0.0020450058,37,7.5,2408.5,3058,10866,2176,12.5,-0.0031982593,2.5,0.005867286,15.5,15,0.0077141463,16.5,6.5,2233,16,13.5,5631.5,5480,7874,6374.5,23.5,22,22,27.5,2.5,-0.0048501315,24,11.5,27,17.5,24,1.5,21.5,461.5,6332,36.5,-0.0013388654,15,0.0008910478,-0.0040265783,0.000987889,0.0020509472,-0.0010123412,-0.003488725,40.5,0.0060444917,6.5,13,-0.007519398,-0.00047597763,29.5,46,2,51,2161,2402.5,5.5,18.5,-0.0068754344,13838,1.5,2794,0.0027383333,0.0054588453,1.5,6.5,14.5,5103.5,10785.5,10785.5,-0.00041813875,0.0016310994,2.5,12.5,2873.5,4236,7.5,19,8.5,17.5,3124,0.016275382,5397.5,7137,6327.5,0.021761091,6362.5,6479.5,-0.00069626677,0.0008051423,0.0062365346,-0.00021764857,0.003263722,0.0013730173,0.0018837812,-0.0020509746,0.011603138,0.0068427804,0.0053326,-0.0047340584,0.007994247,0.0026652953,-0.0018946332,0.0006123697,-0.0021305792,-0.00794518,0.0003766973,-0.0011601577,-0.0029860416,0.0017582873,-0.0023778607,0.0067853094,0.038595345,0.018176856,-0.0080203945,-4.0694755e-05,-0.0012236986,0.0038241223,0.0025172494,-0.00012339569,0.0057056365,0.014762856,0.0019937314,-0.004696338,0.010119605,0.0003776963,-0.0020456568,0.0022737163,-0.0005415023,-0.0037040082,-0.0047237175,0.0091365045,-0.004352968,-0.0005156027,-2.3644532e-05,-0.0010433652,-0.00015310386,0.0022741957,-0.0055932417,-0.0016347051,-0.00030573367,0.001844949,-0.0027648667,-0.0064892056,0.0020147485,-0.00059531414,-0.0022937832,0.0012581432,-4.8455677e-05,0.0013443253,-0.00089570286,0.0012144998,-0.00018070161,-0.0023765157,-0.0006497786,0.0016870638,0.0006311693,-0.0010932069,-0.0069771926,-0.002517641,0.0009709878,-0.0020283326,0.0038453385,-4.906773e-05,-0.004390191,-0.013016234,0.010654223,-0.002334193,0.006804701,0.0020849018,0.010028444,0.0029145402,0.00015567579,-0.00040445462,0.0014231208,-0.00013002155,-0.0013989074,0.0001032522,-0.0004469806,0.0033504819,-0.0030455801,0.00014228991,0.0037080252,-0.008456747,0.00029272024,0.0055548907,-0.0026778134,1.9958983e-05}, {6,7,7,6,2,7,7,1,0,8,8,0,255,7,6,0,8,8,8,8,0,0,0,6,1,8,0,6,4,4,8,3,4,8,0,8,0,0,8,8,255,8,8,255,255,1,3,5,8,1,1,255,8,8,1,1,4,0,8,4,8,4,7,0,7,255,255,255,8,0,8,255,255,255,255,8,8,255,255,8,8,255,255,2,8,3,1,0,7,8,255,8,255,8,8,255,8,8,4,8,8,1,4,1,7,3,2,0,2,8,255,3,8,3,8,7,8,8,0,0,4,255,8,255,255,255,255,255,255,0,255,8,8,255,255,4,0,8,4,3,1,8,8,255,2,8,6,255,255,8,8,8,0,0,0,255,255,8,8,7,5,8,8,8,8,7,255,4,0,5,255,7,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,65535,79,81,65535,65535,83,85,87,89,91,93,65535,95,97,99,101,103,105,107,109,111,113,115,117,119,65535,65535,65535,121,123,125,65535,65535,65535,65535,127,129,65535,65535,131,133,65535,65535,135,137,139,141,143,145,147,65535,149,65535,151,153,65535,155,157,159,161,163,165,167,169,171,173,175,177,179,181,65535,183,185,187,189,191,193,195,197,199,201,65535,203,65535,65535,65535,65535,65535,65535,205,65535,207,209,65535,65535,211,213,215,217,219,221,223,225,65535,227,229,231,65535,65535,233,235,237,239,241,243,65535,65535,245,247,249,251,253,255,257,259,261,65535,263,265,267,65535,269,271,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,65535,80,82,65535,65535,84,86,88,90,92,94,65535,96,98,100,102,104,106,108,110,112,114,116,118,120,65535,65535,65535,122,124,126,65535,65535,65535,65535,128,130,65535,65535,132,134,65535,65535,136,138,140,142,144,146,148,65535,150,65535,152,154,65535,156,158,160,162,164,166,168,170,172,174,176,178,180,182,65535,184,186,188,190,192,194,196,198,200,202,65535,204,65535,65535,65535,65535,65535,65535,206,65535,208,210,65535,65535,212,214,216,218,220,222,224,226,65535,228,230,232,65535,65535,234,236,238,240,242,244,65535,65535,246,248,250,252,254,256,258,260,262,65535,264,266,268,65535,270,272,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({5709.5,5512,5817.5,2416.5,5545,6433.5,5821.5,2403.5,2615,5541,2946.5,4.5,7712.5,-0.011037442,1439,1234,18,1568,2810.5,7276,-0.018665334,12.5,6534,5806,5834,10.5,-0.00811144,8241,2670,1210.5,18.5,14.5,0.024085756,7.5,1713.5,3535.5,5322.5,4454.5,16.5,4,4260.5,3883.5,5756,5618.5,5650.5,5725,5447.5,5775,9860.5,244.5,11482,8371.5,2741,1602,15.5,4.5,1144.5,5.5,16.5,3,12,15.5,12.5,2.5,4.5,2067,5162.5,4363.5,8.5,7.5,0.0005415582,7855.5,5936,15.5,14.5,4677,5689,5664.5,5603,5596.5,5935,-0.005622115,-0.0006207183,4204,5773,-0.01263955,4877.5,0.012123353,0.005389903,0.0070044696,0.003484359,12.5,5.5,1422,1.5,14.5,9255.5,1772,5904,1001,1539,1106.5,838,1275,1766.5,576,2140.5,3,0.0038414213,-0.0022421477,-0.00559722,-0.0020533202,0.017021682,-0.0028577466,18.5,7,-0.02262273,6.5,18.5,2674.5,2801.5,0.002352189,7.5,3827,2741,5192.5,5906.5,15,0.0033274565,5103.5,-0.005533206,-0.0003412242,-0.0011094488,-0.004643816,2.5,-0.0030679964,-0.010531323,-0.0005468179,-0.004725618,-0.0018198806,0.004168074,18.5,18.5,5676.5,5820.5,7119,5741.5,0.016385337,6049,5674.5,-0.008820262,1.5,-0.00090193393,14.5,5.5,19.5,0.006667405,0.004276838,12.5,3346.5,20.5,873,7552,11020,5,-0.015995305,20942.5,6040,3569.5,11788,-0.0067373724,6.5,6.5,5698,6111,-8.2379884e-05,0.0026644461,-0.008702369,-0.0010275365,0.007792478,-0.0069636665,0.00019869737,-0.026707876,0.006829262,-0.0009028789,-0.0012203277,0.0024075152,0.004930183,-0.009787952,0.0067991777,-0.001911127,0.0020110623,-0.0025178026,0.003264442,-0.0007549183,-0.008954356,0.003923769,-0.00085153634,-0.0057578986,0.00010936925,-0.0042570755,-0.007588481,-0.0015976437,0.0027567837,-9.8539786e-05,0.008156261,0.004127896,0.00014944587,0.004132439,-0.0030150441,-0.00043244808,-6.816182e-05,0.0046847737,-0.0015108151,0.0017777322,-0.0020481772,-0.0043254285,-0.0025069024,-0.0058917697,0.0021289221,0.00017573895,0.004992982,-0.00012342383,-0.0009585943,0.003566805,-0.0027284436,0.0014522531,-0.004120519,-0.014117514,0.0044034594,-0.0012101098,-0.0026111973,-0.009485866,0.005243939,0.0007773693,0.0033735798,-0.0010621109,0.003043718,0.010578795,-0.002736564,-0.0055166506,0.0036912195,-0.00081482105,0.0022449547,0.0007445518,-0.0015784753,-0.0051065003,-0.0011353483,0.0036839563,-0.0023858796,-0.0045897365,-0.0016160768,-0.009220443,-0.0077259354,0.00016209621,0.0005053903,-0.0008045806,-0.0020835279,-0.010781536,-0.0043845936,-0.0020565046,0.0073251724,0.0018533928,0.00142159,0.0079082,0.0010954187,-0.00036139955,-0.0008614335,-0.0055151857,-0.0037378327,-0.000262378,-8.037767e-05,-0.006509417,0.001436452,2.4089035e-05}, {6,6,6,0,6,3,6,0,0,6,7,8,5,255,0,2,8,1,0,0,255,8,4,6,7,8,255,7,0,2,8,8,255,8,1,4,6,4,8,8,1,5,2,3,2,6,0,6,0,1,2,7,0,0,8,8,6,8,8,8,8,8,8,8,8,7,3,0,8,8,255,0,0,8,8,2,6,6,6,7,2,255,255,1,3,255,2,255,255,255,255,8,8,0,8,8,5,1,6,1,1,1,3,5,1,6,1,8,255,255,255,255,255,255,8,8,255,8,8,2,4,255,8,6,5,2,7,8,255,5,255,255,255,255,8,255,255,255,255,255,255,8,8,6,0,0,2,255,2,4,255,8,255,8,8,8,255,255,8,3,8,2,6,7,8,255,2,6,5,7,255,8,8,7,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,65535,27,29,31,33,35,37,65535,39,41,43,45,47,65535,49,51,53,55,57,65535,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,65535,133,135,137,139,141,143,145,147,149,151,65535,65535,153,155,65535,157,65535,65535,65535,65535,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,65535,65535,65535,65535,65535,65535,193,195,65535,197,199,201,203,65535,205,207,209,211,213,215,65535,217,65535,65535,65535,65535,219,65535,65535,65535,65535,65535,65535,221,223,225,227,229,231,65535,233,235,65535,237,65535,239,241,243,65535,65535,245,247,249,251,253,255,257,65535,259,261,263,265,65535,267,269,271,273,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,65535,28,30,32,34,36,38,65535,40,42,44,46,48,65535,50,52,54,56,58,65535,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,65535,134,136,138,140,142,144,146,148,150,152,65535,65535,154,156,65535,158,65535,65535,65535,65535,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,65535,65535,65535,65535,65535,65535,194,196,65535,198,200,202,204,65535,206,208,210,212,214,216,65535,218,65535,65535,65535,65535,220,65535,65535,65535,65535,65535,65535,222,224,226,228,230,232,65535,234,236,65535,238,65535,240,242,244,65535,65535,246,248,250,252,254,256,258,65535,260,262,264,266,65535,268,270,272,274,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({991,937.5,928,20.5,11.5,20,1912.5,2534.5,3688,1257,1257,1067.5,900.5,891,1256.5,1671,12.5,24,5033.5,729.5,-0.014321096,933,13.5,12.5,6.5,0.0072490172,0.037202626,18.5,15.5,4294,1456,1580,17.5,6.5,688.5,429,34.5,1117,7485,4.5,1050,657.5,4576.5,0.0014845592,17.5,898,17.5,0.0023712956,0.006600775,4.5,1769,1764.5,1519.5,2963,18.5,1937.5,1818.5,1557,12.5,2107,2019.5,688.5,0.0082992455,18.5,-0.0063686157,33.5,0.016436826,33,41.5,493.5,1354,21.5,8760.5,2.5,956.5,853.5,1.5,18.5,18.5,18.5,-0.006634388,1395.5,0.010182517,4.5,6,898,898,1748.5,10.5,1004,0.00079105666,3519.5,1142.5,2058.5,1029.5,18.5,630.5,5480.5,6935,20.5,17.5,2766.5,4070,64.5,6,5,16,4.5,12.5,18.5,-0.00024239717,4,-0.0034106371,15.5,19.5,25,123,36.5,124,320.5,1307,21.5,0.017269235,0.00083561474,0.003151598,1017.5,26.5,5076.5,1300,0.0005663707,-0.00096560875,0.000998695,0.002207487,7,1.5,0.0012111276,4.5,15,20,1027,897.5,17.5,779.5,0.007820868,0.0013959937,0.0039589102,8.5,-0.0011262429,0.0035773017,0.0013949744,15.5,-0.0024078267,18.5,2.5,0.0215658,1632.5,1632.5,0.005083648,20.5,1141,5516,4.5,2.5,943.5,5129,-0.021685671,1529,2034,2118,18.5,1225.5,29302,1.5,490,8466,6.5,-0.0081275655,4.5,1349,4.5,1516.5,3866,4086.5,-0.00020343732,0.00023522419,-0.019856067,-0.0002268739,0.006190171,-0.0033740073,0.015705874,0.00084684364,-0.0004933612,-0.007880057,0.0037246093,-0.004097206,0.0017741108,0.0053838855,-0.00020751935,0.0032815486,-0.0012038253,0.004867572,-0.0016063759,-0.00024008758,0.00034700875,0.0044488716,-0.0063612857,-0.0013071053,0.00060804514,-0.0027885719,-0.009102026,-0.021750567,0.000905481,0.012532367,-0.0030871779,0.0011673592,0.00063633703,-0.0007424414,-0.008297316,-0.0006274734,0.011117059,-0.004568438,0.004640823,0.0010210847,0.0005709859,-0.0017458277,-0.0026306265,9.776276e-05,0.0011848386,-0.0065331594,-0.0012276579,0.00012488398,0.0018018195,-0.0032417048,0.005779382,-1.6205942e-05,-0.0050938088,-0.0017106821,-0.008017403,-0.02103176,3.0263041e-05,-0.0067620263,-0.014119402,0.0048797186,0.001012361,0.0036687048,-0.0038657375,-0.0009099251,0.0019174982,0.00767695,-0.0031878662,0.004642094,0.0010728588,-0.01011317,0.00055116665,0.008750894,0.009742441,0.01551061,-0.0015814266,0.0016253982,-0.000820334,-0.004730088,-0.00801245,0.028798684,0.008451178,0.0018613947,0.0007267138,-0.009021039,0.0049042962,0.00017287153,0.016647993,0.0009740621,-0.0034831357,-0.00056701555,0.007039203,-0.0011065794,0.0004834924,-0.0048341653,-0.009703002,-0.0038141073,0.00143397,-0.00033142552,-0.0040339073,6.753959e-05,-0.00020700414,-0.0037953947,-0.0007576809,0.0013058082,-0.0021554446,0.0006161068,0.0059361714,0.00094734377,0.0099738045,0.0017340363,0.0017384932,-0.0068068854,0.0009508121,-0.000846679,9.793879e-05,0.0027235239,-0.00550922,1.089791e-05}, {1,1,0,8,8,8,0,0,7,0,0,1,0,7,5,0,8,7,6,7,255,7,8,8,8,255,255,8,8,1,5,0,8,8,1,0,6,2,6,8,0,2,4,255,8,0,8,255,255,8,1,0,4,1,8,2,5,0,8,0,0,1,255,8,255,1,255,6,6,2,2,8,7,8,1,0,8,8,8,8,255,0,255,8,8,0,0,0,8,1,255,4,7,2,7,8,6,2,6,8,8,0,4,3,8,8,8,8,8,8,255,8,255,8,8,1,2,2,2,0,0,8,255,255,255,2,0,3,4,255,255,255,255,8,8,255,8,8,8,2,2,8,0,255,255,255,8,255,255,255,8,255,8,8,255,0,0,255,8,3,6,8,8,4,2,255,4,0,0,8,7,0,8,6,1,8,255,8,7,8,7,4,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,65535,41,43,45,47,65535,65535,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,65535,81,83,85,65535,65535,87,89,91,93,95,97,99,101,103,105,107,109,111,65535,113,65535,115,65535,117,119,121,123,125,127,129,131,133,135,137,139,141,65535,143,65535,145,147,149,151,153,155,157,65535,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,65535,197,65535,199,201,203,205,207,209,211,213,215,65535,65535,65535,217,219,221,223,65535,65535,65535,65535,225,227,65535,229,231,233,235,237,239,241,65535,65535,65535,243,65535,65535,65535,245,65535,247,249,65535,251,253,65535,255,257,259,261,263,265,267,65535,269,271,273,275,277,279,281,283,285,287,65535,289,291,293,295,297,299,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,65535,42,44,46,48,65535,65535,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,65535,82,84,86,65535,65535,88,90,92,94,96,98,100,102,104,106,108,110,112,65535,114,65535,116,65535,118,120,122,124,126,128,130,132,134,136,138,140,142,65535,144,65535,146,148,150,152,154,156,158,65535,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,65535,198,65535,200,202,204,206,208,210,212,214,216,65535,65535,65535,218,220,222,224,65535,65535,65535,65535,226,228,65535,230,232,234,236,238,240,242,65535,65535,65535,244,65535,65535,65535,246,65535,248,250,65535,252,254,65535,256,258,260,262,264,266,268,65535,270,272,274,276,278,280,282,284,286,288,65535,290,292,294,296,298,300,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7798,7721,7822.5,3092,8740,7987,8076.5,3072.5,3146,7339.5,-0.011435418,7820.5,-0.01379554,9563.5,8108.5,7603,3095,6421.5,1.5,7757.5,2706,10.5,-0.008453967,7852.5,7359,8397.5,1934,2151.5,7623,14.5,3910.5,18.5,7.5,5029.5,3779.5,4719.5,7791.5,14.5,5591.5,1667.5,1667.5,6989.5,7632,6031,12.5,6559,6809,15.5,8422.5,1679.5,2692.5,6.5,4.5,7.5,-0.010895807,18.5,7.5,16.5,3191,2.5,11.5,3119.5,1505.5,4186,4343.5,2.5,-0.0101982085,8014,17,0.008644803,17,11.5,4.5,0.0024718733,2.5,17,16.5,7201,7536.5,20.5,-0.022642428,4.5,19.5,0.0049728206,16.5,2400.5,-0.007013637,0.0023411883,0.01942402,5.5,25493.5,8585.5,8428,1494.5,2965,2600.5,7602.5,-0.016329914,19,6953,11.5,5.5,-0.0061066193,15.5,7519.5,4710,12.5,12.5,2799.5,3114.5,2796.5,7725,5.5,-0.0038802386,18.5,7156.5,3429,7583.5,11733,3648,6150,4253,5888.5,0.0027853723,14,7,0.006487964,14,19,15.5,0.0027026848,7313.5,0.0070126653,7774,6.5,0.0004736328,6493.5,-0.0016526984,3.4225344e-05,-0.0038698122,7808.5,5964,4218,0.013581695,7,8827.5,-0.0017335255,1.5,7.5,2.5,6270.5,14.5,0.0028558422,12.5,5295.5,10612,6817,18.5,32077,8554.5,6364.5,1.5,8653,0.0001076672,-0.0020780112,0.002214576,-0.0013047839,-0.0011277209,-0.0037656017,3.7291546e-05,-0.0010801335,-0.0043390873,-0.008655007,-0.0023728383,-0.0077142008,0.00051251746,-0.0017417374,-0.0047204313,8.708299e-05,-0.0011166654,0.006446074,-0.0045595425,0.0015387795,0.0010855937,-0.0016341647,-0.005253501,-0.0024852974,0.0038642145,0.001422457,-0.002051462,0.007086129,-0.0043970323,-0.00035877773,0.0010744528,0.0048337313,-0.0009267263,-0.0026722052,0.006602322,0.0025901787,0.0009430731,-0.0011166503,0.006429483,-0.00025834536,-0.0055340747,-9.855453e-05,-0.016813232,0.004742598,0.004634582,-0.0019154396,0.00024806638,-0.003964771,0.00069855823,0.00230568,-0.0005119968,-0.00489081,0.0009292473,-0.00026667092,-0.003074538,-0.00032911074,0.00013480264,0.0042613116,0.0023053072,0.004530007,-0.0009825554,-0.0028393033,0.0009898305,-0.00034045798,0.0059887418,0.002177209,0.0038964,0.008618324,-0.002779524,0.0018471439,-0.0024976041,-0.0011484493,-0.0028723492,-0.0010140003,-0.00063329394,-0.0059255883,-0.0014292505,0.001463509,0.0018901824,-0.001962263,-0.010293466,-0.004442916,-0.0010390895,0.0011943853,-0.00087078335,-4.9125094e-05,0.0021252008,0.0005522735,0.0033042566,0.0011318761,0.0010663118,-0.0006740597,0.0012618998,-0.00014908459,0.0026642652,0.0073731313,-0.008627999,0.00252076,0.0025307506,-0.0007699227,-0.004232874,-0.00813266,-0.0005503438,0.0034389028,0.00019285291,-0.021649504,0.0036408529,-0.000109266584,-0.02848134,-0.0031281721,-0.0008682731,-1.5537282e-06}, {2,2,2,3,7,0,2,3,3,6,255,2,255,3,2,2,5,6,8,2,3,8,255,1,0,3,7,6,2,8,2,8,8,3,5,1,2,8,4,1,1,1,7,0,8,1,0,8,2,6,6,8,8,8,255,8,8,8,5,8,8,1,4,6,1,8,255,0,8,255,8,8,8,255,8,8,8,0,0,8,255,8,8,255,8,1,255,255,255,8,0,4,2,6,0,6,4,255,8,6,8,8,255,8,0,0,8,8,7,3,7,0,8,255,8,2,3,1,4,5,4,1,1,255,8,8,255,8,8,8,255,0,255,2,8,255,0,255,255,255,2,4,3,255,8,1,255,8,8,8,0,8,255,8,4,2,0,8,5,4,1,8,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,65535,21,65535,23,25,27,29,31,33,35,37,39,65535,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,65535,103,105,107,109,111,113,115,117,119,121,123,65535,125,127,65535,129,131,133,65535,135,137,139,141,143,145,65535,147,149,65535,151,153,65535,65535,65535,155,157,159,161,163,165,167,169,65535,171,173,175,177,65535,179,181,183,185,187,189,191,193,195,197,65535,199,201,203,205,207,209,211,213,215,65535,217,219,65535,221,223,225,65535,227,65535,229,231,65535,233,65535,65535,65535,235,237,239,65535,241,243,65535,245,247,249,251,253,65535,255,257,259,261,263,265,267,269,271,273,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,65535,22,65535,24,26,28,30,32,34,36,38,40,65535,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,65535,104,106,108,110,112,114,116,118,120,122,124,65535,126,128,65535,130,132,134,65535,136,138,140,142,144,146,65535,148,150,65535,152,154,65535,65535,65535,156,158,160,162,164,166,168,170,65535,172,174,176,178,65535,180,182,184,186,188,190,192,194,196,198,65535,200,202,204,206,208,210,212,214,216,65535,218,220,65535,222,224,226,65535,228,65535,230,232,65535,234,65535,65535,65535,236,238,240,65535,242,244,65535,246,248,250,252,254,65535,256,258,260,262,264,266,268,270,272,274,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7107,7102,7210,7.5,13,6606,6780.5,6926.5,9015.5,5,7141,9288.5,7020,8309,6808.5,5286.5,6943.5,8784.5,8882.5,0.0057677305,6.5,0.003426697,0.009517944,8440,0.008610024,9504.5,7756,7413.5,9957.5,1.5,6826,5616.5,6706.5,6942,9519,6931,11417,7332,6316.5,-0.00024727348,0.004140776,7466.5,4,-0.0021596355,7142.5,9754.5,8451.5,4765,5107.5,4434.5,6430.5,-0.0070552686,0.014700945,-0.009586597,7798,6781.5,5552.5,5288,1.5,7494,7264,7281,10676.5,6903.5,6100.5,5087.5,15.5,6997,6686,5311,20.5,19.5,6555,-0.010670829,15.5,0.004513421,4.5,8181.5,10.5,-0.0146615775,-0.009237797,7670,2.5,5543.5,7408,4059,5714,11323,4,7929.5,7779,4540.5,4.5,5822,5510.5,-0.0073669674,6264,6252,7792.5,4.5,10541.5,0.010329149,5.5,6936.5,8551.5,2.5,1.5,9417,6264,6045.5,9032,15.5,7290.5,12.5,0.0018600331,0.019604832,7559,4756,8079.5,16.5,18.5,13325,9816,7531.5,3536,5854,3471,7332.5,2807.5,0.0008164034,6780,-0.0041493787,-0.008003145,0.0044297418,-0.0010573933,6210,1548.5,4961.5,6484,-0.0071624676,2,7777.5,8152,3708,2.5,5396.5,7785,10700.5,4965,-0.0032793593,-0.012179063,8347.5,8250.5,6998,7850.5,0.00056090695,-0.00068748783,0.0068743373,0.0024132577,0.004383126,0.009376396,0.0010767253,-0.0036860914,0.00028027294,-0.00061430706,0.0012079886,0.012492162,0.0017546908,-0.0028164762,-0.0019499604,0.000116299365,0.0064079026,0.0023156647,0.020460416,0.009051453,0.0022343954,-0.0021008498,-0.00528538,0.0008238954,0.01604054,0.008618433,7.2230374e-05,0.005027256,1.3981329e-05,-0.0034325407,0.013324975,-0.0031550247,-0.00025698237,0.008715321,-0.0061860266,-1.7988347e-06,-0.0037695894,-0.0015346683,-0.0055614472,-0.0020060402,0.000896996,-0.00062832225,-0.0069086314,0.006340669,-0.0013362943,0.0039409753,0.00012044886,0.003914658,-0.0010816641,-0.001919801,-0.0030855087,-0.004726482,0.0018105684,-0.0009374639,-0.00073304115,0.0030748018,-0.00052500714,0.0018193625,4.01106e-05,0.006466488,0.002364479,-0.00089567824,-0.0022350128,-0.008428677,-0.0022603846,0.0010948331,-0.008216473,-0.0024507663,0.0028343375,0.00103193,-0.0019472486,0.00056722714,-0.00785475,-0.0024093757,0.0007975297,-0.008010384,0.0012317406,-0.008264987,-0.007390694,0.0016859111,-0.0037627618,0.009712334,-0.00937523,-0.0024768072,0.0011479895,-0.0007468379,0.0013662236,-0.0072509605,0.004731501,0.011198357,0.0006058795,0.0023777876,-0.001310138,-0.008424045,-0.00062475284,0.0037267555,0.0011342135,0.010522302,-0.0044742674,0.00059847464,-0.00029444776,-0.0045932513,0.004257192,-2.7195529e-06}, {6,6,6,8,8,1,2,6,2,8,0,3,7,7,2,0,6,2,0,255,8,255,255,4,255,0,5,7,7,8,2,2,7,6,0,0,1,4,3,255,255,2,8,255,6,0,4,1,1,0,2,255,255,255,2,6,4,0,8,4,0,4,0,0,7,6,8,0,1,1,8,8,0,255,8,255,8,0,8,255,255,0,8,4,6,2,1,7,8,7,4,7,8,6,7,255,6,6,0,8,3,255,8,7,3,8,8,4,6,7,1,8,4,8,255,255,0,3,0,8,8,2,5,4,1,0,1,0,1,255,2,255,255,255,255,4,3,7,3,255,8,7,7,2,8,2,5,7,2,255,255,1,3,5,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,65535,39,65535,65535,41,65535,43,45,47,49,51,53,55,57,59,61,63,65,67,69,65535,65535,71,73,65535,75,77,79,81,83,85,87,65535,65535,65535,89,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,65535,127,65535,129,131,133,65535,65535,135,137,139,141,143,145,147,149,151,153,155,157,159,161,65535,163,165,167,169,171,65535,173,175,177,179,181,183,185,187,189,191,193,195,65535,65535,197,199,201,203,205,207,209,211,213,215,217,219,221,65535,223,65535,65535,65535,65535,225,227,229,231,65535,233,235,237,239,241,243,245,247,249,65535,65535,251,253,255,257,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,65535,40,65535,65535,42,65535,44,46,48,50,52,54,56,58,60,62,64,66,68,70,65535,65535,72,74,65535,76,78,80,82,84,86,88,65535,65535,65535,90,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,65535,128,65535,130,132,134,65535,65535,136,138,140,142,144,146,148,150,152,154,156,158,160,162,65535,164,166,168,170,172,65535,174,176,178,180,182,184,186,188,190,192,194,196,65535,65535,198,200,202,204,206,208,210,212,214,216,218,220,222,65535,224,65535,65535,65535,65535,226,228,230,232,65535,234,236,238,240,242,244,246,248,250,65535,65535,252,254,256,258,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7792.5,7620.5,7924.5,7619,7276,8231,7975.5,2.5,-0.020580372,7931.5,7461.5,8097.5,7630,7957.5,8072,4918,5879,6676.5,7727.5,7179.5,5988.5,7183.5,-0.019454362,-0.006726516,8369.5,7956.5,8249,8072,8915,1362,7608.5,3966.5,9159.5,6896,6768,15.5,2.5,0.019824445,0.008759841,1.5,7398,5726.5,8254,15.5,9242.5,7690.5,-0.009708132,6992,0.022010868,3562,6906.5,8582,10048,1330.5,7333.5,1.5,0.013610934,6628.5,5662.5,7328,7157.5,6592,3.5,7.5,5148,6336,7732,-0.0021016558,-0.012424557,-0.013981123,16.5,7674.5,12.5,7.5,3284.5,7286,7008,3.5,0.007692533,9,18.5,7.5,8233,20.5,0.006765763,4430,6302,8990.5,7521.5,8065,8746.5,9893.5,11536.5,1151.5,1347.5,4912,2473.5,6733.5,9903.5,6320.5,7260.5,5288,3265.5,7612,6898.5,7351,7498,1304,0.0071194656,0.002416917,7706,4.5,0.006035506,18.5,15,5.5,2.5,6383.5,-0.0071395948,5.5,18.5,1.5,1.5,7695,9522.5,3,6303,4.5,4324,0.00918742,7486,2.5,17,-0.0024436698,0.0030522838,10380,14.5,12.5,0.0014479388,4.5,19.5,6062,19.5,11.5,0.007669301,4160,7820,6855.5,7004,6684,1.5,2.5,1.5,7475,1.5,7128.5,8649.5,11818,9916.5,11482,12288,-0.0013057541,0.0016669048,0.017418304,0.0070648603,-0.0015931166,-0.015786981,-0.0018418262,0.0033943509,0.0035764424,-0.0007099623,9.877326e-05,-0.0040154955,0.00014476711,0.0021049615,-0.00044033743,-0.0022843105,0.00052004284,-0.0016298855,-0.0015546022,0.0016373014,-0.00012659273,-0.016669555,-0.0001872464,-0.010382264,0.0017030742,0.010262808,4.6901052e-05,-0.007794385,0.0010262023,-0.0020522876,-0.007784284,-0.0020109755,0.0005929973,0.0021441542,-0.0020754032,-0.006268495,0.0007833871,0.0028421837,-0.0024106891,0.002444077,0.00025063413,-0.0045324424,-0.0013456505,-0.0043076933,-0.0035045308,-0.001072205,0.00077285623,0.0015720826,0.00016213619,0.004199627,-0.0009058785,0.007690842,0.005743589,0.00084276655,-0.0014285219,0.0023823327,0.0025507223,0.005214697,0.0032707416,-0.0037449934,-0.007839242,-0.0026835294,0.000465584,-0.008903621,-0.0013438073,0.0023985102,0.0028186596,-0.0054579093,0.0013245614,-0.0015629221,0.0004910728,-0.0031360735,0.0027939454,0.0013546158,-0.0008844036,-0.0017097545,-0.0020560545,-0.004070614,0.00030643222,0.0034562682,-0.001999979,0.004443755,0.00036763406,0.0019158637,0.0030494276,-0.0005678163,-0.00063584035,0.0057909046,-0.0032440107,-3.820832e-06,0.00034496895,0.00886535,-0.003643816,-0.00016504385,7.5809716e-05,-0.009562407,-0.0018291533,0.0025892123,-0.01478403,-0.0050144624,0.00468179,-0.020731037,6.116738e-05,0.003933389,-0.019534102,-0.0029638559,-0.004353333,0.0063985656,-0.00021889375,0.002759228,-6.036847e-05,-0.0036880192,-0.006268552,-0.00068046723,0.00037009147,0.0057458305,-0.00080548646,1.5208054e-05}, {6,6,6,6,2,4,6,8,255,4,2,0,0,6,2,7,7,2,6,3,4,3,255,255,0,6,0,1,2,7,6,7,1,0,2,8,8,255,255,8,7,4,7,8,1,2,255,2,255,5,2,4,6,7,6,8,255,2,6,0,3,0,8,8,1,2,0,255,255,255,8,0,8,8,5,0,0,8,255,8,8,8,4,8,255,7,5,6,5,1,6,6,6,1,7,7,1,6,3,2,6,7,3,6,5,6,6,2,255,255,0,8,255,8,8,8,8,0,255,8,8,8,8,1,3,8,0,8,0,255,1,8,8,255,255,0,8,8,255,8,8,0,8,8,255,3,3,1,5,2,8,8,8,5,8,0,2,0,6,6,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,65535,17,19,21,23,25,27,29,31,33,35,37,39,41,65535,65535,43,45,47,49,51,53,55,57,59,61,63,65,67,65535,65535,69,71,73,75,77,79,81,65535,83,65535,85,87,89,91,93,95,97,65535,99,101,103,105,107,109,111,113,115,117,65535,65535,65535,119,121,123,125,127,129,131,133,65535,135,137,139,141,143,65535,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,65535,65535,191,193,65535,195,197,199,201,203,65535,205,207,209,211,213,215,217,219,221,223,65535,225,227,229,65535,65535,231,233,235,65535,237,239,241,243,245,65535,247,249,251,253,255,257,259,261,263,265,267,269,271,273,275,277,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,65535,18,20,22,24,26,28,30,32,34,36,38,40,42,65535,65535,44,46,48,50,52,54,56,58,60,62,64,66,68,65535,65535,70,72,74,76,78,80,82,65535,84,65535,86,88,90,92,94,96,98,65535,100,102,104,106,108,110,112,114,116,118,65535,65535,65535,120,122,124,126,128,130,132,134,65535,136,138,140,142,144,65535,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,65535,65535,192,194,65535,196,198,200,202,204,65535,206,208,210,212,214,216,218,220,222,224,65535,226,228,230,65535,65535,232,234,236,65535,238,240,242,244,246,65535,248,250,252,254,256,258,260,262,264,266,268,270,272,274,276,278,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({36.5,4.5,22.5,1.5,22,46,4660.5,25.5,23.5,22,29,8,4,4629.5,4806.5,461.5,123,187.5,30.5,15.5,15.5,29.5,27,-0.017335197,-0.0043908353,1.5,18.5,4256,4636,5270,4808,74,1300.5,29.5,579,113,2.5,29870.5,43.5,71,23,14.5,20.5,29.5,29.5,1459,21.5,-0.000101878366,-0.0066436515,58,21.5,5785.5,9.5,-0.013469574,5439.5,12.5,6567.5,-0.0173697,6501,29.5,120.5,-0.00988227,-0.003000191,31.5,0.0097422255,-0.0040383576,13003,3640,120.5,3229.5,26.5,31,25637.5,35,2.5,8.5,-0.0024171814,3432,71,306,140,187.5,26.5,22,7.5,16.5,-0.011243989,19.5,17.5,36.5,28.5,12.5,10.5,-0.0021016437,0.0021114487,3699,5844.5,4489,4435.5,0.0027417527,1.5,4.5,5518,16.5,12.5,7445.5,6525.5,23,22,0.0069515356,0.0030450765,-3.359012e-05,0.0026877334,863.5,0.004141518,22,0.0045454935,0.005371339,0.00055542454,-0.0106282225,0.0018216945,0.004322123,3088,572.5,2.5,25522.5,2.5,2.5,-0.0043301634,0.012715894,455,6.5,10.5,20.5,21,20.5,-0.0055655795,8.5,7.5,29.5,461.5,30.5,19.5,78,96.5,22,18,6.5,21.5,34,20.5,29.5,29.5,14.5,4403,15.5,5.5,87.5,0.014028787,-0.0010126486,0.001379466,7.5,0.0020304315,3846,3543.5,5250.5,4,6.5,8290,4452,9219,-0.0044741766,7.5,8967,3268,19.5,9935.5,4043.5,10783.5,4780,7318.5,7030,7611,5298.5,7275,-0.0012577062,0.0018951232,-0.004350104,-0.00069073617,0.0014406582,0.00045876097,-0.00012130671,0.0012797843,-8.513804e-05,2.4577635e-06,-0.0015539727,-0.004572653,-0.0021397457,-0.008183136,0.0014754713,0.004506965,0.00011788506,-3.7049234e-05,0.0025339774,0.00076444226,-0.0014559434,0.006176123,-0.000125494,0.0027088798,-0.0009837601,0.00024100316,-0.0022610668,-0.0043153814,-0.0007615483,0.0030213932,0.00033001887,0.008746869,0.0027411648,7.248855e-05,-0.0018702596,-0.0003726776,-0.0012741631,0.0028414358,-0.008352342,-0.0041688583,0.0031505153,-0.00073245633,0.0067029195,0.0025754448,0.00079336663,0.012535817,-0.022299035,-0.0066179372,0.0026524318,0.005578022,-0.00055060524,0.0019557874,0.004909209,-0.008752781,0.005001267,0.011380078,0.00027871024,0.0020925046,-0.0037295762,0.0016832931,-0.0001040289,-0.0034288645,-0.004423125,-0.016011544,0.0002647933,-0.002805263,0.008525686,0.0006000846,-0.0011329845,-0.004090055,-0.0019660757,0.0012217009,0.0004245444,0.0047562327,0.0019504679,-0.00044269423,-5.2413376e-05,0.0027369233,-0.0031819493,-0.0004044182,0.00015793336,-0.0018691786,0.00935765,0.0033224754,0.0010888495,-0.002322883,-0.0037605837,-0.0012446846,-0.0027701007,0.0002790419,0.0019129141,-0.0016335661,2.2605425e-05,-0.0025420857,-0.00042347034,0.0039630155,-0.005493698,-0.0008308018,0.0004868401,-0.0028965648,0.0052942527,0.00062865665,0.0026113312,-0.00032088722,0.005280703,0.000910408,0.010680008,0.0005114247,0.0013639396,0.004726061,0.0007567583,0.0062226155,-0.0060223485,-9.2323375e-05,-0.013129964,-0.0036146746,-0.00042801202,2.9857812e-05}, {6,8,7,8,6,0,1,7,7,2,1,8,8,1,1,0,0,0,7,8,8,5,7,255,255,8,8,1,1,7,1,2,0,0,0,0,8,1,2,0,0,8,8,0,0,0,8,255,255,0,8,0,8,255,2,8,4,255,0,1,0,255,255,2,255,255,0,4,0,0,4,6,0,0,8,8,255,4,0,2,0,0,4,2,8,8,255,8,8,1,7,8,8,255,255,0,3,1,1,255,8,8,2,8,8,3,0,0,4,255,255,255,255,0,255,2,255,255,255,255,255,255,0,0,8,0,8,8,255,255,0,8,8,8,8,8,255,8,8,0,0,2,8,2,2,0,8,8,8,2,8,6,6,8,0,8,8,0,255,255,255,8,255,1,6,5,8,8,0,3,6,255,8,4,3,8,0,4,2,1,0,2,3,6,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,65535,65535,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,65535,65535,91,93,95,97,65535,99,101,103,65535,105,107,109,65535,65535,111,65535,65535,113,115,117,119,121,123,125,127,129,131,65535,133,135,137,139,141,143,145,147,149,65535,151,153,155,157,159,161,65535,65535,163,165,167,169,65535,171,173,175,177,179,181,183,185,187,65535,65535,65535,65535,189,65535,191,65535,65535,65535,65535,65535,65535,193,195,197,199,201,203,65535,65535,205,207,209,211,213,215,65535,217,219,221,223,225,227,229,231,233,235,237,239,241,243,245,247,249,251,253,255,257,65535,65535,65535,259,65535,261,263,265,267,269,271,273,275,65535,277,279,281,283,285,287,289,291,293,295,297,299,301,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,65535,65535,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,65535,65535,92,94,96,98,65535,100,102,104,65535,106,108,110,65535,65535,112,65535,65535,114,116,118,120,122,124,126,128,130,132,65535,134,136,138,140,142,144,146,148,150,65535,152,154,156,158,160,162,65535,65535,164,166,168,170,65535,172,174,176,178,180,182,184,186,188,65535,65535,65535,65535,190,65535,192,65535,65535,65535,65535,65535,65535,194,196,198,200,202,204,65535,65535,206,208,210,212,214,216,65535,218,220,222,224,226,228,230,232,234,236,238,240,242,244,246,248,250,252,254,256,258,65535,65535,65535,260,65535,262,264,266,268,270,272,274,276,65535,278,280,282,284,286,288,290,292,294,296,298,300,302,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({2035.5,1299.5,2172.5,1293,1204,2122.5,1278,1930.5,20.5,1264,1173,2120.5,2151,2087,1374,1839.5,5,4.5,-0.012279505,17.5,1334.5,18,1055.5,2503.5,12.5,15.5,2159,15,13.5,3,2405,1042,12.5,-0.016896572,14,-0.006933944,11.5,1192,706,18.5,1549,12.5,0.016206918,19.5,15.5,14.5,5195.5,5.5,16,2109,-0.02188693,15.5,5.5,2.5,1251.5,6.5,4003,0.013978138,16.5,18.5,6067.5,457.5,1200,0.039551847,-0.023485329,1178,1178,8.5,18,2.5,13.5,-0.0034319402,-0.018483872,7,0.014833726,21.5,2856,0.011726281,15.5,17.5,371.5,965,1375,1712.5,1712.5,4.5,13,2,0.005985535,-0.0013220982,19,3291.5,2149,6.5,-0.0033427805,0.0003449661,3244,1.5,12.5,-0.0062273294,16.5,2729.5,1219.5,19,3270,12.5,19.5,4.5,2354,6056.5,6185.5,426.5,440,1218.5,13.5,8.5,11,0.0041757333,-0.02168435,-0.002746882,0.0021177416,15.5,-0.0018116955,1.5,706,6.5,-0.0005755801,2.5,16,20.5,2649,14.5,12.5,14.5,-0.004736913,6.5,1598,21.5,1397.5,2.5,6.5,-0.010921031,2146,4,12.5,16,4800,1.5,15.5,3,18,0.0016906776,-0.0010390098,0.003751805,-0.0014390618,8.5,0.0041059423,5,-0.0114980815,3124,0.008503745,15,11.5,1628,8.251306e-05,-0.010764825,-0.0042294445,-0.0014559648,18,2.5,3.5,12.5,12.5,15.5,20.5,-0.009355143,15.5,5645,5645,5645,1336.5,2.5,2121.5,3453.5,2540.5,4941,-0.009648359,6.5,2845.5,4.4070453e-05,0.0031631382,-0.0078548,-0.0002635752,0.0034886224,-0.00080356,0.0006831653,-0.000966389,-0.00011332414,0.0010150087,0.011417192,-0.000536834,-0.002669729,-0.006095411,0.00019290786,-0.0013751643,-0.0021821265,-0.005903666,0.0007752328,0.004621673,0.0012470804,-0.0009299346,0.002900901,-0.00036795865,0.00030687198,0.0032168494,-0.008003916,0.0005605602,-0.00424661,-0.009334206,0.0012469474,-0.0015819985,0.0012224343,0.0035746812,-0.00025757073,0.003229528,0.0017858221,-0.008837967,-0.010283527,0.007774023,-0.0035196438,0.021912085,-0.00462319,0.010547085,-0.00075079274,0.0022643723,0.0004532635,-0.0040747654,-0.001521686,-0.011030558,-0.00027757612,-0.0039802636,0.008432169,0.004387136,-0.006941758,-0.0006885099,0.002383161,-0.0032180813,0.0025778802,-0.0008476825,-0.000421912,-0.0045743934,-0.00048673013,-0.0018128892,-0.0034556582,0.00020133385,-0.010854781,0.0006582996,0.0020473027,-0.0016971527,0.00045253846,-0.0007824685,-0.0041598277,-0.002319472,-0.007958258,-0.00074679556,0.00093610765,0.0033742834,0.0007816646,-0.0063333446,0.003103119,-0.000517927,0.006548166,-0.0030320955,-0.0010449426,0.0037067942,0.0025133898,-0.004679804,0.0072853253,-0.001781484,-0.0059585064,-0.002598386,-0.00421874,0.0037255485,0.01222518,0.0028518753,-0.0043987813,0.0016524511,-0.0032565333,0.004090998,-0.002444858,0.00962545,-0.0052823485,0.00063397386,0.0020588553,0.014201327,0.008236411,0.019266298,-0.0004483029,0.00013194341,-0.00070214935,0.0020392693,0.0028842643,-2.128765e-06}, {4,5,4,5,7,4,5,4,8,3,6,4,7,2,5,4,8,8,255,8,4,8,0,2,8,8,4,8,8,8,4,1,8,255,8,255,8,2,0,8,5,8,255,8,8,8,0,8,8,2,255,8,8,8,2,8,4,255,8,8,0,2,1,255,255,0,0,8,8,8,8,255,255,8,255,8,0,255,8,8,0,1,6,0,0,8,8,8,255,255,8,0,0,8,255,255,0,8,8,255,8,6,5,8,0,8,8,8,4,0,0,2,3,7,8,8,8,255,255,255,255,8,255,8,0,8,255,8,8,8,0,8,8,8,255,8,5,8,6,8,8,255,5,8,8,8,0,8,8,8,8,255,255,255,255,8,255,8,255,0,255,8,8,0,255,255,255,255,8,8,8,8,8,8,8,255,8,0,0,0,3,8,3,5,5,5,255,8,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,65535,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65535,65,65535,67,69,71,73,75,77,65535,79,81,83,85,87,89,91,65535,93,95,97,99,101,103,65535,105,107,109,111,113,65535,65535,115,117,119,121,123,125,65535,65535,127,65535,129,131,65535,133,135,137,139,141,143,145,147,149,151,65535,65535,153,155,157,159,65535,65535,161,163,165,65535,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,65535,65535,65535,65535,201,65535,203,205,207,65535,209,211,213,215,217,219,221,65535,223,225,227,229,231,233,65535,235,237,239,241,243,245,247,249,251,65535,65535,65535,65535,253,65535,255,65535,257,65535,259,261,263,65535,65535,65535,65535,265,267,269,271,273,275,277,65535,279,281,283,285,287,289,291,293,295,297,65535,299,301,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,65535,38,40,42,44,46,48,50,52,54,56,58,60,62,64,65535,66,65535,68,70,72,74,76,78,65535,80,82,84,86,88,90,92,65535,94,96,98,100,102,104,65535,106,108,110,112,114,65535,65535,116,118,120,122,124,126,65535,65535,128,65535,130,132,65535,134,136,138,140,142,144,146,148,150,152,65535,65535,154,156,158,160,65535,65535,162,164,166,65535,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,65535,65535,65535,65535,202,65535,204,206,208,65535,210,212,214,216,218,220,222,65535,224,226,228,230,232,234,65535,236,238,240,242,244,246,248,250,252,65535,65535,65535,65535,254,65535,256,65535,258,65535,260,262,264,65535,65535,65535,65535,266,268,270,272,274,276,278,65535,280,282,284,286,288,290,292,294,296,298,65535,300,302,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({1730.5,1680.5,1796.5,15.5,2029,1794.5,3919.5,1830,2227.5,20.5,18.5,3235,15.5,2648,3924.5,1190.5,1874.5,1245,2764.5,7886,3929,5016.5,5016.5,2.5,17.5,5,-0.0010925472,18.5,3373.5,-0.016809821,4909,1271,1307.5,6211.5,1328.5,1512,1312.5,3944.5,16.5,6.5,2.5,-0.005423838,0.0002745592,7.5,7112,0.00495519,-0.00047871316,1.5,4.5,16.5,5673,0.019148005,0.012387204,2134,1913.5,3288.5,16.5,5785.5,37,1257.5,14.5,12.5,1494.5,4.5,10613.5,10,2014,1089,1392.5,569,2665.5,1364,6713,1356,2055,4.5,3929,0.0009587719,4.5,4.5,2849,7.5,16,4400,2901,2901,15.5,5.5,5673,0.012030856,18.5,2154,2081,2218.5,2285.5,2776.5,4762,3902,3388,5168.5,6595.5,19.5,3173.5,74.5,5668,6.5,3951.5,1389.5,1579,1418,1842.5,1224,13.5,-0.00096823333,7,3,-0.014272093,7496,3.5,1011.5,1155.5,1125,19,18.5,18.5,996,2994.5,17.5,-0.018180003,18.5,0.0013566092,4628,-0.006541843,1516.5,18.5,-2.3058417e-05,5.5,0.0028207467,0.0008002012,-0.0010310925,7.5,2.5,5.5,15.5,-0.015468955,-0.00032233668,-0.0027444854,4,0.00039994819,0.001725867,-0.0002084052,-0.010457364,-0.0026026282,0.013151993,2023.5,6.5,1781.5,2,7145.5,-0.0020604986,0.00088119734,0.0008293683,0.003656044,1023.5,11.5,8.5,6.5,1358,-0.015774962,2544,2121.5,18.5,2801.5,14.5,6571.5,3767.5,4467.5,0.010404258,3593,4533.5,5615,6140,7802.5,5092,5858,842.5,3560.5,9.65717e-05,-0.00045979788,0.012120276,0.0006965988,0.0013023559,-0.0054102074,0.012717719,-0.0036066137,0.0026611523,-0.0010816714,0.0018031526,0.013492474,0.0033930296,1.1837592e-06,-0.0018416742,-0.011559615,0.0060336436,-0.005666211,0.028896062,0.0058384417,0.0008319118,-0.0003608668,-0.01118522,0.00101687,0.0013418981,-0.0007996837,-0.005115088,-0.00019617965,-0.00062847644,0.0025638104,-0.012945006,-0.0020430058,-0.0126180565,-0.022439918,0.00037179806,0.004761431,0.0025368643,-0.0009918829,-0.00430815,-0.014801207,0.0047453004,0.00011790693,-0.010411317,0.00027561115,-0.011389235,-0.007612338,-0.0020893344,0.0003767608,-0.0030977516,0.0008834756,0.00090330484,-0.0039384067,-0.00044895132,-0.004325003,0.00077631563,-3.2112155e-05,0.00096132664,-0.00031340527,-0.007804678,-0.017987212,0.0004111228,-0.0047138347,0.0027356392,-0.016863361,-0.0009134069,-0.00030206086,0.00018817685,-0.003465357,0.0025129074,-0.004004441,0.0034531504,-0.0066466588,0.0041034934,-0.0008540516,0.004544912,0.001930793,-0.0033370424,0.0006394961,-0.013467533,0.0011397029,0.009623282,0.0040663145,-0.0011109472,0.0025398352,0.0042119776,-0.003885612,0.026855592,-0.0025061895,0.003345397,0.012009581,-0.00041829832,-0.0057400507,0.0042898147,3.7258393e-05,-0.0072455066,-0.0140488,0.0015977065,-0.0016840395,0.0009308776,0.0044281892,-0.0022947404,0.0006833872,0.006751732,0.00138199,-0.00043415904,-0.0030312082,-0.0040266607,-0.018358797,0.002246572,0.008106704,0.0005777501,-0.002500181,-0.0030603325,-3.534277e-05,-0.010734671,-0.0011554083,-0.00076044217,0.0015195331,-0.0022713614,1.1050562e-05}, {7,7,7,8,6,7,6,6,6,8,8,3,8,1,6,7,6,2,4,0,0,0,0,8,8,8,255,8,6,255,6,6,7,0,2,6,0,0,8,8,8,255,255,8,0,255,255,8,8,8,0,255,255,3,6,6,8,2,0,6,8,8,6,8,0,8,3,2,4,0,2,1,0,3,1,8,0,255,8,8,0,8,8,0,0,0,8,8,0,255,8,1,7,1,6,4,4,4,6,2,2,8,2,0,0,8,0,6,6,7,3,0,8,255,8,8,255,0,8,7,1,2,8,8,8,7,2,8,255,8,255,0,255,7,8,255,8,255,255,255,8,8,8,8,255,255,255,8,255,255,255,255,255,255,5,8,7,8,0,255,255,255,255,4,8,8,8,0,255,0,1,8,4,8,0,2,5,255,0,3,3,2,0,4,6,0,2,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,65535,53,55,65535,57,59,61,63,65,67,69,71,73,75,77,65535,65535,79,81,65535,65535,83,85,87,89,65535,65535,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,65535,139,141,143,145,147,149,151,153,155,157,159,65535,161,163,165,167,169,171,173,175,177,179,181,183,185,187,189,191,193,195,197,199,201,203,205,65535,207,209,65535,211,213,215,217,219,221,223,225,227,229,231,65535,233,65535,235,65535,237,239,65535,241,65535,65535,65535,243,245,247,249,65535,65535,65535,251,65535,65535,65535,65535,65535,65535,253,255,257,259,261,65535,65535,65535,65535,263,265,267,269,271,65535,273,275,277,279,281,283,285,287,65535,289,291,293,295,297,299,301,303,305,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,65535,54,56,65535,58,60,62,64,66,68,70,72,74,76,78,65535,65535,80,82,65535,65535,84,86,88,90,65535,65535,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,65535,140,142,144,146,148,150,152,154,156,158,160,65535,162,164,166,168,170,172,174,176,178,180,182,184,186,188,190,192,194,196,198,200,202,204,206,65535,208,210,65535,212,214,216,218,220,222,224,226,228,230,232,65535,234,65535,236,65535,238,240,65535,242,65535,65535,65535,244,246,248,250,65535,65535,65535,252,65535,65535,65535,65535,65535,65535,254,256,258,260,262,65535,65535,65535,65535,264,266,268,270,272,65535,274,276,278,280,282,284,286,288,65535,290,292,294,296,298,300,302,304,306,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({32.5,25.5,638.5,25.5,24,529,686,12.5,52,52,21.5,524,18.5,362,335.5,5.5,22,26.5,6.5,15.5,8,6.5,48.5,6.5,10.5,591,683,674,15.5,2040,1204,22,43.5,22,15.5,29.5,23.5,4.5,80.5,8.5,-0.005909485,-0.016520811,-0.006271798,2.5,13.5,38.5,-0.018237898,404,404,-0.004019362,-0.012112464,16.5,558.5,577,1525.5,18.5,16,759.5,2051,18.5,13.5,1202,1210.5,22,22,22,24,14.5,13.5,24,49.5,22,12,5.5,13.5,80.5,76,16.5,16,1.5,13,36,46,51.5,14.5,-0.0024627715,70,113.5,573.5,376.5,573.5,536,1387,13.5,0.0069189095,442,-0.004854472,533.5,621.5,-0.014068248,0.00021681596,-0.002301845,-0.009823809,676.5,673.5,-0.008414465,661.5,525.5,826,461.5,461.5,1297.5,15.5,15,908,4.5,2.5,2.5,52,6.5,22.5,6.5,7.5,13.5,15.5,-0.0037822765,20.5,22.5,-0.0015519566,17.5,16.5,71,15,101,19,600.5,34,121.5,359,-0.0015629632,-0.005494683,-0.005520254,-0.02131812,12.5,21.5,-0.008570189,120.5,-0.00046175928,-0.0042483,49.5,1.1332019e-05,154,26.5,35.5,78,39.5,26.5,35.5,35.5,-0.0010906884,0.00054039835,48.5,6422.5,410.5,705.5,18.5,5755.5,410.5,667.5,7,8469,17.5,-0.009063091,0.0044915527,17.5,-0.00016326508,0.002913511,20.5,0.032492492,-0.0016150362,0.0002475787,667,0.003489184,2.5,7.5,0.00072934077,-4.4131153e-05,7.5,4.5,-0.00985467,503.5,0.004037393,172,18,172,403.5,631,5,-0.026970511,1203,1123.5,15.5,925.5,-0.00025405784,-0.0024199295,0.0010122955,-0.0030582526,0.0039216834,0.0019344054,-0.00046332576,0.001246678,-0.0031807006,0.00012842075,0.006023357,0.00031162958,0.0013705646,-0.002063953,-0.009990423,0.00041355213,0.0010656086,0.00038266848,-0.00065769575,-0.0019531331,0.0031235153,-0.0022476544,0.000958334,0.0039432202,0.00029283218,0.004420197,0.0016202567,0.00088823633,0.00013556973,-0.0031012134,-0.0054041524,-0.0011493721,-0.0013880817,0.0024549214,0.005090608,0.00093447353,0.003007187,-0.0028644116,-0.0033872034,-0.00079042756,0.0018315032,0.005402982,-0.00087950344,0.00395569,-0.001238898,0.0014077302,-0.0030027102,-0.0001400957,0.005622418,-0.0030162376,-0.002421192,-0.00060568075,0.0065256283,-0.00066742883,-0.0076634246,-0.00017967199,-0.0107741095,0.0006883365,0.001409142,-0.00244598,0.0013146375,0.0065512666,-0.0032501207,8.369991e-06,-0.010756381,0.0008571733,0.0012780923,-0.0016115468,0.0003292373,0.003304718,-0.0011361205,0.0017451792,-0.0069621927,-0.016246622,0.0026470458,0.00041255253,0.00072992075,-0.00059466035,-0.009227621,-6.0477825e-05,0.0020275621,0.0076047666,-0.005651422,0.0010172795,0.00095758465,0.004438649,-0.0012150704,0.00079423713,-0.0011488006,0.0017469637,-0.0013208858,0.0017917795,0.026256904,0.010327835,0.0010997927,-4.3734948e-05,0.00075588754,-0.0007359407,-0.0039501577,-0.0014665488,0.0016622387,-0.000706863,0.0015813072,0.005846382,0.0059340643,0.011309059,-0.0032390244,0.0005558539,-0.000754844,-0.0131928,0.003987982,-0.0009775474,0.0036045958,-0.0022005283,-0.008515143,0.00021053493,-0.015781192,0.006070427,0.0037621807,0.012520882,-0.0059738415,0.0031788968,0.0029031911,-0.0014106758,-0.004208918,2.4182116e-06}, {5,5,0,1,3,1,0,8,4,2,8,1,8,5,6,8,2,3,8,8,8,8,3,8,8,1,2,0,8,0,2,2,6,6,8,7,5,8,0,8,255,255,255,8,8,0,255,1,1,255,255,8,0,0,2,8,8,6,2,8,8,2,2,6,4,0,1,8,8,1,0,2,8,8,8,0,2,8,8,8,8,6,0,6,8,255,0,6,2,0,2,0,4,8,255,2,255,1,0,255,255,255,255,0,0,255,0,4,0,2,2,1,8,8,3,8,8,8,6,8,3,8,8,8,8,255,8,3,255,8,8,0,8,0,8,0,1,2,0,255,255,255,255,8,8,255,0,255,255,0,255,0,0,7,0,7,1,0,0,255,255,7,4,2,2,8,2,2,3,8,7,8,255,255,8,255,255,8,255,255,255,0,255,8,8,255,255,8,8,255,2,255,4,8,4,5,4,8,255,7,0,8,3,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,65535,65535,65535,81,83,85,65535,87,89,65535,65535,91,93,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,65535,159,161,163,165,167,169,171,173,65535,175,65535,177,179,65535,65535,65535,65535,181,183,65535,185,187,189,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,65535,223,225,65535,227,229,231,233,235,237,239,241,243,245,65535,65535,65535,65535,247,249,65535,251,65535,65535,253,65535,255,257,259,261,263,265,267,269,65535,65535,271,273,275,277,279,281,283,285,287,289,291,65535,65535,293,65535,65535,295,65535,65535,65535,297,65535,299,301,65535,65535,303,305,65535,307,65535,309,311,313,315,317,319,65535,321,323,325,327,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,65535,65535,65535,82,84,86,65535,88,90,65535,65535,92,94,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,65535,160,162,164,166,168,170,172,174,65535,176,65535,178,180,65535,65535,65535,65535,182,184,65535,186,188,190,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,65535,224,226,65535,228,230,232,234,236,238,240,242,244,246,65535,65535,65535,65535,248,250,65535,252,65535,65535,254,65535,256,258,260,262,264,266,268,270,65535,65535,272,274,276,278,280,282,284,286,288,290,292,65535,65535,294,65535,65535,296,65535,65535,65535,298,65535,300,302,65535,65535,304,306,65535,308,65535,310,312,314,316,318,320,65535,322,324,326,328,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({7804,7721,7758,6500.5,8740,7635.5,7849,6217.5,9180,7339.5,4.5,8138,8162,7794.5,7851.5,5555.5,3779,5423,5852.5,7756,14.5,-0.00066201837,-0.010609024,6714,7078.5,7653.5,7723,7825,15.5,-0.014094335,9419.5,4617,3203.5,2937,6212.5,5033,8107,7735,7212,5877.5,6675,2608,7249,8000,1.5,6870,7317.5,5580.5,8155.5,2.5,-0.004449148,10.5,7905.5,2,3079,4677,9517.5,4144.5,4821,7.5,3244.5,12.5,5.5,1.5,6316.5,1.5,5179.5,5316.5,7079,15,5095,7025.5,9461,12,6847,6548,15.5,7040.5,7956,3216,16.5,7635,5658.5,0.0011762497,-0.016020922,6830.5,1.5,9889,7411,-0.014448652,18,18.5,21.5,-0.0075119734,-0.020222,-0.0012373195,-0.0071926103,9.5,9760.5,-0.006343507,3079,0.0014000485,0.00827558,4618,7646.5,10283.5,9450,3979,4259.5,5239,18.5,5765,2856.5,5882.5,1659,-0.0020357764,-0.01212247,7505.5,7685.5,-0.010678057,2552,1.5,1.5,1375,5696.5,7393.5,7316,3.5,8100,5584,6655,11.5,16.5,5077.5,5973.5,9663,9426,7538.5,-0.017397527,5.5,0.0015131286,-0.009107451,11.5,11.5,3.5,3.5,17,7,4,5335,2.5,6992.5,5335,-0.0003611841,-0.00202539,7506,5023.5,7290,6271,6514.5,10440.5,0.0125568155,8239.5,8453,1.5,-0.013085479,7465.5,9.5,-0.010539939,15.5,7680,1.5,0.0036801302,4.5,8291.5,0.0029563508,15.5,5.5,4.5,1.5,-0.012409987,8.5,9289,8021,10145,9435.5,9532,0.00010689761,-0.001498157,0.00534561,0.00085102266,-0.005140682,0.00385214,-0.00045714434,-0.0021282749,-0.0050961794,0.00056705595,-0.00053436327,-0.0038201471,0.010010624,0.0035328213,-0.004574885,0.00067430036,-0.00037114616,-0.005530247,0.00068341265,0.006558229,0.0016614608,0.008435166,0.005269188,-0.0108687375,0.010680206,0.0011308185,0.0045028026,-0.0036748548,-0.00024554948,0.0017199739,0.008239447,0.0018511883,0.0038154405,-0.002028695,-0.0043848627,-0.015939595,-0.00046467417,0.020426793,-0.016956521,0.0012291645,-0.00028993931,-0.017170433,0.00021359754,-0.001067113,0.0029663676,0.005370475,0.00014469407,0.0020686414,-0.0008398478,0.00058118085,-0.007271635,0.00292489,0.017598744,0.008725162,-0.010022505,0.001005386,0.001697154,-0.002492028,-0.001608211,-0.0062619955,0.0033931963,-0.00069756666,0.0013004598,0.004395449,0.002279506,-0.0017826876,0.0040821508,0.0002396133,-0.0030538149,-0.00091212953,0.0046944036,-0.000111662026,-0.0011946735,0.006350402,-0.0036243468,0.0032770447,-0.0026806397,0.0006823544,-0.0019252434,0.0058479826,-0.00091491995,-0.025714163,-0.0012265368,0.00359203,0.0025479074,-0.005021386,-0.019478282,-0.009703606,0.00012264775,-0.0041613146,0.0070903967,0.002433284,-0.003302056,-0.012377442,0.00137593,0.010602783,-0.008328916,0.002200569,-0.0031925146,0.005296412,-0.0035334881,-0.00035167896,-0.00086833816,0.0016591087,-0.0081939865,-0.002081975,0.002245471,-0.00413829,0.0021909827,-0.003287399,-0.004514746,0.0027390106,0.00017138825,0.0022312223,0.0015855642,0.00021121095,0.0048958277,0.0027028264,0.0026398795,-0.00029840437,-0.0003614799,0.0054381867,-0.0017949501,0.0007103537,-0.0019527465,-0.0075181513,0.0060814205,7.4687755e-06,-0.00030325464,-0.0055246535,0.008659357,5.886453e-06}, {2,2,4,0,7,4,4,0,1,6,8,3,0,4,4,6,5,3,7,2,8,255,255,5,4,4,4,2,8,255,0,2,3,4,1,3,0,0,3,0,6,5,1,3,8,5,5,0,6,8,255,8,6,8,1,1,6,2,2,8,3,8,8,8,1,8,3,2,5,8,7,2,6,8,0,0,8,0,0,1,8,3,4,255,255,4,8,2,5,255,8,8,8,255,255,255,255,8,0,255,1,255,255,1,3,3,0,2,2,4,8,6,3,0,0,255,255,6,2,255,3,8,8,3,7,4,1,8,0,6,2,8,8,6,6,0,0,3,255,8,255,255,8,8,8,8,8,8,8,0,8,0,0,255,255,3,1,0,0,5,2,255,6,3,8,255,4,8,255,8,4,8,255,8,0,255,8,8,8,8,255,8,3,7,1,0,6,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,65535,65535,43,45,47,49,51,53,65535,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,65535,95,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,65535,65535,159,161,163,165,65535,167,169,171,65535,65535,65535,65535,173,175,65535,177,65535,65535,179,181,183,185,187,189,191,193,195,197,199,201,65535,65535,203,205,65535,207,209,211,213,215,217,219,221,223,225,227,229,231,233,235,237,239,241,65535,243,65535,65535,245,247,249,251,253,255,257,259,261,263,265,65535,65535,267,269,271,273,275,277,65535,279,281,283,65535,285,287,65535,289,291,293,65535,295,297,65535,299,301,303,305,65535,307,309,311,313,315,317,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,65535,65535,44,46,48,50,52,54,65535,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,65535,96,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,65535,65535,160,162,164,166,65535,168,170,172,65535,65535,65535,65535,174,176,65535,178,65535,65535,180,182,184,186,188,190,192,194,196,198,200,202,65535,65535,204,206,65535,208,210,212,214,216,218,220,222,224,226,228,230,232,234,236,238,240,242,65535,244,65535,65535,246,248,250,252,254,256,258,260,262,264,266,65535,65535,268,270,272,274,276,278,65535,280,282,284,65535,286,288,65535,290,292,294,65535,296,298,65535,300,302,304,306,65535,308,310,312,314,316,318,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({31969,27990,18578.5,26299,31201.5,18555,1.5,27438.5,20335,31359.5,15.5,6.5,18603,22279,30450.5,28823,14072,-0.006127161,4769,16.5,11180,1.5,32410.5,18315.5,17126.5,7,16.5,19460.5,30248.5,27948.5,30214,17084.5,24178,28870,28842.5,4.5,31289.5,28069,14700,6.5,18519,29525.5,30538.5,16.5,29500.5,12463,1.5,12.5,16.5,-0.00356045,-0.008578361,-0.0018841876,-0.0024759981,19299,18904,24194,29834.5,20807,11.5,25723,30971.5,16088,27522,21773.5,14945,19136.5,16567.5,24650.5,2.5,0.0024301447,0.007095746,26686.5,26226.5,29217.5,15383.5,28283,28736.5,1.5,31804.5,6.5,31900.5,29054,30213,29796.5,30586,28850,31922.5,29386,29473.5,31648,16428,31589,18381,7.5,16,18177,16428,18544.5,19258.5,0.00019874056,19863.5,23690,24256.5,-0.0010170864,32234,-0.0037155603,6.5,15321.5,15321.5,18593.5,28124.5,29984.5,32234,19051,17901,16629.5,26408,1880.5,22993,16105,26528.5,23747,15.5,-0.0066609937,29175,0.00496605,26268,9.0370355e-05,15.5,27925,27309,16,6.5,0.005701699,0.012479205,28708,23457.5,29058.5,28801,18151,16373.5,31729,2.5,12.5,0.0019256233,11201,31971.5,31878.5,1.5,28788.5,29490.5,31272.5,30058,29791,29820.5,30503,29844,0.00024603977,31542.5,29760,-0.0019183563,29343.5,29750.5,29450.5,29647.5,0.004575492,2.5,4.5,1.5,0.002637773,18268,4.5,-0.0017371186,0.00050017855,0.0017505989,0.0007848896,0.0003362027,11952,18721.5,31648,17551.5,0.0022965705,0.0013939635,-0.0028093073,19875.5,19761.5,19686.5,23821,23732,0.0004443585,0.0007477439,-0.00029078763,0.00017607353,29611.5,19730.5,7.5,0.0002885458,18,0.0002364441,6.5,18644,6.5,30162,7,30500.5,30675,3.5,-1.925018e-05,0.00467002,-0.00021550432,0.0072318735,0.0011067176,-0.0021146592,0.00019489665,-0.002409561,-0.0017442008,0.0020028874,0.0096251555,0.004021107,-0.0023726667,0.00025485113,0.003083838,-0.0013542235,0.0010191308,-0.0017210859,0.0059395097,-0.0007442838,-0.0016298046,-8.348063e-05,-0.00035492211,0.0021740424,0.008889951,0.0038158689,-0.0003673767,-0.0054444987,-0.0029190716,-0.009274448,0.00041760746,0.0011971834,8.913279e-05,0.00028321872,0.00086401607,-0.0033022573,0.0041312287,0.0010200242,-0.00027077226,0.0029910917,-0.010448118,-0.002212397,-0.00027751303,0.0037936324,0.0059272493,-0.00011337551,-0.0011509378,-3.956717e-05,0.008749731,0.0036658307,-0.00067394547,0.0012664583,0.002311765,-0.0010949323,-0.0021305657,-0.0008703584,-0.00015018284,-0.0040951,0.0020665254,0.0006911551,4.786911e-05,-0.00011073623,-0.0008765099,-0.000237307,0.0009594255,-0.0013094508,-0.0010105374,-0.0005040451,-0.00012857578,0.0007060011,-0.0021654612,-0.00024086812,0.0010775323,0.00045609224,0.0011720554,0.00012765554,-0.00016698267,4.347901e-05,-0.0012073833,-0.0008125405,0.00024637367,0.0022759887,-0.00093694916,-0.0032383834,-0.00018730218,-0.002749601,0.0008533813,0.00024635388,0.0007421688,-0.001196791,-0.0040995697,-0.0018855343,0.00058842124,-0.001479118,0.0006794557,-0.00036319272,-0.0001196687,-0.0010224007,-0.00063018943,0.00048201514,-0.00089839095,-0.000255041,0.0024346986,-0.001428872,0.00017409534,-0.0006282755,3.704559e-05,0.0019557527,0.00204954,0.0040320097,0.0033376478,0.0016748225,-4.0830288e-05,0.00031445012,0.000534582,0.00023430341,-0.0019977584,-0.0010826247,-0.0014116805,-0.0008328722,-0.0008322987,-0.0003622603,0.0006016027,0.0012997665,0.00061639096,0.0010073418,-0.00053260225,5.1249925e-05,-0.0032027357,-0.0016602104,0.00012931212,-0.000966299,-0.00081777055,-0.00027579427,0.0018092394,0.00102714,0.0009974076,0.00021603797,-0.003764469,-0.0011931945}, {4,4,7,4,3,7,8,2,0,0,8,8,1,1,2,0,5,255,3,8,5,8,1,1,0,8,8,5,3,5,1,3,6,0,6,8,3,4,5,8,1,0,0,8,2,7,8,8,8,255,255,255,255,1,7,3,1,0,8,1,1,3,1,2,7,1,3,6,8,255,255,3,6,0,7,0,4,8,0,8,4,0,6,0,4,1,1,2,0,2,5,0,7,8,8,5,5,1,3,255,1,1,5,255,0,255,8,0,0,7,5,3,0,5,2,1,6,2,2,1,1,4,8,255,0,255,6,255,8,4,2,8,8,255,255,6,3,4,0,3,5,0,8,8,255,1,6,4,8,2,2,5,2,0,0,2,6,255,5,4,255,2,4,0,0,255,8,8,8,255,7,8,255,255,255,255,255,1,5,2,5,255,255,255,7,3,3,7,1,255,255,255,255,2,7,8,255,8,255,8,1,8,3,8,1,2,8,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,65535,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,65535,65535,65535,65535,97,99,101,103,105,107,109,111,113,115,117,119,121,123,125,127,65535,65535,129,131,133,135,137,139,141,143,145,147,149,151,153,155,157,159,161,163,165,167,169,171,173,175,177,179,181,183,65535,185,187,189,65535,191,65535,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,65535,227,65535,229,65535,231,233,235,237,239,65535,65535,241,243,245,247,249,251,253,255,257,65535,259,261,263,265,267,269,271,273,275,277,279,281,65535,283,285,65535,287,289,291,293,65535,295,297,299,65535,301,303,65535,65535,65535,65535,65535,305,307,309,311,65535,65535,65535,313,315,317,319,321,65535,65535,65535,65535,323,325,327,65535,329,65535,331,333,335,337,339,341,343,345,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,65535,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,65535,65535,65535,65535,98,100,102,104,106,108,110,112,114,116,118,120,122,124,126,128,65535,65535,130,132,134,136,138,140,142,144,146,148,150,152,154,156,158,160,162,164,166,168,170,172,174,176,178,180,182,184,65535,186,188,190,65535,192,65535,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,65535,228,65535,230,65535,232,234,236,238,240,65535,65535,242,244,246,248,250,252,254,256,258,65535,260,262,264,266,268,270,272,274,276,278,280,282,65535,284,286,65535,288,290,292,294,65535,296,298,300,65535,302,304,65535,65535,65535,65535,65535,306,308,310,312,65535,65535,65535,314,316,318,320,322,65535,65535,65535,65535,324,326,328,65535,330,65535,332,334,336,338,340,342,344,346,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({37,22,60,27.5,3.5,26.5,62.5,22,30.5,42,27,6.5,34,16,2266.5,20.5,3,15.5,4.5,25.5,29.5,57,43.5,4.5,49.5,11,57.5,7.5,19,2191.5,1860,11.5,23,0.002094749,0.0068565845,29.5,27,3,16,2.5,38,89,1.5,78,-0.01073962,22,4.5,34.5,122,15.5,48.5,3,17,20.5,13,0.009469588,0.0037216328,-0.0003260941,-0.0037967437,2.5,2737,19,7814.5,7.5,18.5,3432,0.005784952,6.5,71,18,19,-0.0006243453,-0.00161914,0.0035822687,20,31.5,22,42.5,2.5,46.5,2.5,0.0008932543,0.013125903,22,313,20.5,83.5,51.5,14.5,2.5,-0.004743244,-0.020212924,83,10.5,-0.010022865,15.5,15.5,44,7,44,-0.0065459195,175,175,8.5,-0.00587307,3298,970.5,18.5,5441,6.5,-0.008489632,7525,7924.5,23,23,17.5,19.5,21.5,0.0029853054,2.5,-0.003773935,13.5,2.5,71,-0.0032103527,-0.00823275,-0.002519905,-0.0011637023,0.0025992605,54.5,27,27,29,32.5,30.5,78,-0.0022839685,2.5,0.009342664,22,544,4.5,4.5,154,13611,15.5,-0.0065186447,12.5,170,-0.00092367345,0.012928831,62,25.5,-0.0010843237,0.0050552557,-0.0034360897,0.00013590085,-0.0003067815,12.5,87.5,87.5,-0.0055888924,17.5,0.0015387413,0.016626146,5.5,0.0068546506,-0.002069269,0.004247647,32.5,871,21.5,52.5,6,0.00047803807,1400,1355,745,1299.5,1870,2625.5,2250.5,13,2.5,0.011757142,7522.5,6906.5,9689,7758,-0.00092667545,0.0025950328,0.0010848448,-0.0021638793,-0.0012004228,-0.0028166284,0.00068391,-0.0013773026,0.00032734658,-0.0001069715,-0.0048687253,-0.00081164995,-3.0498142e-05,0.002756677,0.001022287,-0.0012776445,0.0002850165,-0.0020390407,0.0031092558,0.00014967551,-0.0011028941,0.001888064,-0.003126314,-0.0012032298,0.0013798447,-0.0017718269,-0.007222522,-0.00236316,0.0015494782,-0.0012423375,0.005120884,-0.00019401665,0.002252586,-0.0010885039,6.8536254e-05,-0.0039016143,0.0029072156,-0.0013120158,-0.0035326805,0.0005725294,-0.00050216104,0.0053088088,-0.0011852699,-0.011555396,-0.0016911448,0.0013828326,6.504481e-05,0.004508097,0.00050476316,-0.0016164115,-0.0050157234,-0.00071957504,0.0035203963,-0.00024401034,0.005523304,0.0014212978,-0.0019709447,-0.0004622895,-0.0010646735,0.0015887825,-0.00038958265,-0.0038506517,0.00010337733,-0.0026731198,-0.00085566484,0.00074337574,-0.002609631,-0.00055700884,0.0018996376,-0.00027431676,0.00043533437,0.007221037,-0.0027724574,-0.007157989,-0.0009821054,-0.003383231,-0.00045610877,-0.0058840676,0.010476669,0.00064757204,5.807423e-05,0.0015538092,-0.0015390882,-2.5287212e-05,0.0020764298,-0.002491796,-0.015825262,-0.0015039382,-0.010430173,-0.005767463,0.00069400383,-0.0016576456,0.0025583452,0.00024219342,0.00011138911,-0.013012104,-0.0011972506,0.0023073126,-0.0019053126,-0.018498356,-0.0004946176,2.143135e-05}, {2,6,2,0,8,3,2,2,2,6,7,8,6,8,1,8,8,8,8,5,3,4,0,8,0,8,3,8,8,1,0,8,0,255,255,0,2,8,8,8,0,0,8,0,255,0,8,1,6,8,2,8,8,8,8,255,255,255,255,8,3,8,6,8,8,4,255,8,0,8,8,255,255,255,8,2,0,4,8,0,8,255,255,0,0,8,6,0,8,8,255,255,0,8,255,8,8,2,8,2,255,6,6,8,255,6,5,8,3,8,255,6,6,0,0,8,8,8,255,8,255,8,8,0,255,255,255,255,255,0,0,2,0,3,2,0,255,8,255,2,0,8,8,0,0,8,255,8,6,255,255,0,4,255,255,255,255,255,8,6,6,255,8,255,255,8,255,255,255,1,4,8,2,8,255,4,7,5,5,2,0,0,8,8,255,6,2,1,4,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,65535,65535,67,69,71,73,75,77,79,81,83,65535,85,87,89,91,93,95,97,99,101,103,65535,65535,65535,65535,105,107,109,111,113,115,117,65535,119,121,123,125,65535,65535,65535,127,129,131,133,135,137,139,65535,65535,141,143,145,147,149,151,153,65535,65535,155,157,65535,159,161,163,165,167,65535,169,171,173,65535,175,177,179,181,183,65535,185,187,189,191,193,195,197,65535,199,65535,201,203,205,65535,65535,65535,65535,65535,207,209,211,213,215,217,219,65535,221,65535,223,225,227,229,231,233,235,65535,237,239,65535,65535,241,243,65535,65535,65535,65535,65535,245,247,249,65535,251,65535,65535,253,65535,65535,65535,255,257,259,261,263,65535,265,267,269,271,273,275,277,279,281,65535,283,285,287,289,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,65535,65535,68,70,72,74,76,78,80,82,84,65535,86,88,90,92,94,96,98,100,102,104,65535,65535,65535,65535,106,108,110,112,114,116,118,65535,120,122,124,126,65535,65535,65535,128,130,132,134,136,138,140,65535,65535,142,144,146,148,150,152,154,65535,65535,156,158,65535,160,162,164,166,168,65535,170,172,174,65535,176,178,180,182,184,65535,186,188,190,192,194,196,198,65535,200,65535,202,204,206,65535,65535,65535,65535,65535,208,210,212,214,216,218,220,65535,222,65535,224,226,228,230,232,234,236,65535,238,240,65535,65535,242,244,65535,65535,65535,65535,65535,246,248,250,65535,252,65535,65535,254,65535,65535,65535,256,258,260,262,264,65535,266,268,270,272,274,276,278,280,282,65535,284,286,288,290,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({2669.5,10912.5,2703.5,1.5,4.5,4540.5,5427,8067.5,2911.5,2.5,15.5,2402.5,-0.007889315,4.5,5454.5,4937,9978,2639.5,3400,-0.0032450464,2553.5,12.5,2464.5,15.5,20.5,5993.5,7418,6930.5,4827,1203.5,7850.5,7194,12218,1136.5,6942,956.5,8657.5,9753,11046.5,7.5,11899.5,18.5,11899.5,4.5,17.5,2688,4412,5308.5,2.5,5190.5,8.5,7.5,9990.5,4692,5438.5,1269.5,2698,4507.5,0.005907048,-0.0042532403,7002,10488,0.005261916,944.5,1389.5,8.5,15,6.5,4696,4392.5,5997.5,0.0040374356,0.001542378,-0.001073847,0.00020545085,11899.5,11899.5,-0.0058641965,-0.001258111,17.5,-0.0017638076,-0.0026398813,18.5,1759,8.5,-0.0034660026,6708,17.5,14.5,0.0155564165,7060,5190.5,3800,5372,2397,7.5,5609,3518.5,5348,4405,5449,-0.013660677,-0.0057636485,4670.5,4.5,6382,5553.5,32,915,1916,8228,7035.5,-0.010249579,0.012946883,5367,2218.5,11160,686,1212,20.5,6.5,4.5,18.5,4.5,16.5,29870.5,1189,5312.5,5234.5,15.5,7814.5,3297.5,26601.5,-0.004236133,-0.0012742425,10827.5,0.00093168684,-0.0015692607,11525.5,-0.00015251854,-0.0022146327,-0.0012141191,0.0005733759,0.001435009,12.5,4360,-0.0012910914,15.5,7576,2667,2667,0.002756157,10224,2996,8217,1.5,5313,1917,6255,2754.5,7184,4429.5,4514.5,18.5,5796,13388.5,5247,5326,11.5,2,1.5,6234.5,0.00597233,8278,6977.5,7358.5,6.5,5340.5,3089,3761,5543.5,-0.0017112918,0.0013437876,0.0025154378,-0.010458722,0.0030898293,-0.0036356195,0.010610889,0.003502201,-0.0015312386,-0.0048337537,0.0043675955,-0.0037427682,-0.0032231298,0.0011835756,-0.002497757,-0.005603706,-0.0002183251,0.0019073887,-0.0031632998,-7.798289e-05,0.0011969252,0.008929484,0.0004478659,-0.00021118375,-0.0009113165,0.0018106258,-0.0015655702,0.00052077393,0.006909035,0.004479817,-0.0009743282,8.815529e-05,-0.00169877,0.002700465,0.00011578446,0.0018608393,-0.0029644181,-0.010439589,-0.0053014453,0.00010779069,-0.00029648986,0.001971776,0.0031402444,0.0010116992,-0.0025918067,-0.00068119704,0.0006070005,-0.001200725,-0.0032088116,-0.0018073887,-2.8153896e-05,0.00039457585,0.00019103769,3.8267877e-05,-1.6091964e-05,0.00093061983,9.55279e-06,-0.003810538,0.0028784398,-0.00045954567,0.0070064114,0.0026851052,0.0005063009,0.0040245894,0.00034416837,-0.00024511522,-0.00050213275,0.00079001545,0.0055903825,-0.002173144,0.0006760699,-0.0038185602,-0.011339726,0.0006990454,-0.0053560464,9.41353e-05,0.0009932375,0.015102155,-0.0023023956,-0.011039161,0.003783478,0.00017301706,0.0021821882,9.359831e-05,-8.184642e-06,-0.0014863699,0.0019254327,-0.0005102298,-0.0034046215,0.00023023532,0.0018807193,-0.0011958253,-0.003055335,0.0013742341,-1.9379837e-05,-0.013670276,0.0022531457,0.006760884,-0.0027057417,0.0051148385,0.0046841516,-0.00040332458,-0.004676807,-0.00092231866,-0.0004971169,0.0016811698,0.0052006,0.00019810526,0.010649501,0.005239945,-0.00015135591,0.0051045227,-0.003266908,-0.0131568415,-0.007403186,0.00047115414,-0.0049100765,0.001801789,-0.0025121097,-4.1746343e-06}, {5,4,5,8,8,1,7,0,1,8,8,1,255,8,7,0,0,5,7,255,1,8,5,8,8,2,6,2,3,7,1,2,2,3,0,6,6,0,0,8,2,8,2,8,8,5,0,2,8,2,8,8,0,3,3,6,1,1,255,255,6,2,255,4,2,8,8,8,3,3,1,255,255,255,255,2,2,255,255,8,255,255,8,1,8,255,0,8,8,255,0,2,3,7,3,8,2,7,7,3,7,255,255,1,8,5,3,0,3,5,6,2,255,255,3,3,0,5,2,8,8,8,8,8,8,1,4,1,1,8,2,4,6,255,255,0,255,255,0,255,255,255,255,255,8,0,255,8,0,3,3,255,0,7,5,8,2,3,5,1,3,1,6,8,2,0,7,7,8,8,8,1,255,5,6,0,8,3,1,1,7,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255}, {1,3,5,7,9,11,13,15,17,19,21,23,65535,25,27,29,31,33,35,65535,37,39,41,43,45,47,49,51,53,55,57,59,61,63,65,67,69,71,73,75,77,79,81,83,85,87,89,91,93,95,97,99,101,103,105,107,109,111,65535,65535,113,115,65535,117,119,121,123,125,127,129,131,65535,65535,65535,65535,133,135,65535,65535,137,65535,65535,139,141,143,65535,145,147,149,65535,151,153,155,157,159,161,163,165,167,169,171,65535,65535,173,175,177,179,181,183,185,187,189,65535,65535,191,193,195,197,199,201,203,205,207,209,211,213,215,217,219,221,223,225,227,65535,65535,229,65535,65535,231,65535,65535,65535,65535,65535,233,235,65535,237,239,241,243,65535,245,247,249,251,253,255,257,259,261,263,265,267,269,271,273,275,277,279,281,283,65535,285,287,289,291,293,295,297,299,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}, {2,4,6,8,10,12,14,16,18,20,22,24,65535,26,28,30,32,34,36,65535,38,40,42,44,46,48,50,52,54,56,58,60,62,64,66,68,70,72,74,76,78,80,82,84,86,88,90,92,94,96,98,100,102,104,106,108,110,112,65535,65535,114,116,65535,118,120,122,124,126,128,130,132,65535,65535,65535,65535,134,136,65535,65535,138,65535,65535,140,142,144,65535,146,148,150,65535,152,154,156,158,160,162,164,166,168,170,172,65535,65535,174,176,178,180,182,184,186,188,190,65535,65535,192,194,196,198,200,202,204,206,208,210,212,214,216,218,220,222,224,226,228,65535,65535,230,65535,65535,232,65535,65535,65535,65535,65535,234,236,65535,238,240,242,244,65535,246,248,250,252,254,256,258,260,262,264,266,268,270,272,274,276,278,280,282,284,65535,286,288,290,292,294,296,298,300,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535}),
XgTree({19.5,26.5,35.5,18.5,784.5,27.5,1233.5,25.5,25.5,436.5,1038.5,29.5,2759.5,298.5,1369,12.5,11.5,22,29,33.5,459.5,428.5,1061,21.5,20.5,45.5,20.5,168.5,2093,1397.5,1021,37.5,52,587,37,22,37.5,0.011868409,114.5,28.5,26.5,6.5,536.5,1290.5,1007,1759,1730.5,22,3432,24,21.5,88,3913.5,0.0063763894,0.003091982,2040,20.5,1535.5,1086.5,1287.5,0.016136436,2485,2141,10.5,58,15.5,15.5,1.5,25128.5,12.5,37,3432,0.003025146,23.5,57.5,39,148,72,15.5,92.5,55.5,438,542.5,14.5,681,13,7.5,6459,1943.5,4.5,1912,1529.5,1796.5,26,23.5,22,0.0026749435,0.0039038414,0.019567601,24,0.007836985,55.5,106,205.5,-0.007950208,940.5,1138.5,-0.0042265756,0.03473619,1284.5,880,8384.5,1107.5,-0.014460744,7944,658,12002.5,2687.5,2356.5,3.5,70.5,3.5,6.5,187.5,187.5,83,16.5,80,24,27038,32013.5,55.5,17.5,-0.008684628,42.5,-0.0010053277,7.953107e-05,0.003800261,0.00088292995,-0.0024546504,0.0010507449,24,31,0.00903282,68.5,6.5,15.5,55.5,44,83.5,1367,17.5,106,185.5,-0.011112745,16.5,185.5,361,646.5,18.5,503,-0.013678449,-0.004149816,-0.0051633264,12.5,1125.5,-0.008821535,2.5,17.5,1759.5,1352.5,15.5,11.5,15.5,2766.5,1794.5,2381.5,22,0.006418486,-0.0013040103,28.5,-0.0022618729,8.8152876e-05,0.00064751523,-0.00244105,20.5,21.5,21.5,21.5,-0.0067043747,22,42.5,0.010914582,-0.010355798,20.5,1188.5,20.5,449.5,-0.008834324,21.5,822.5,0.014346272,0.00093976455,863.5,9264,-0.004098441,1501.5,20.5,57.5,925.5,836.5,2352,3973,-0.00076303276,0.0004340057,-0.0014359333,0.0010742112,-0.004609481,-0.016413288,0.0005911451,-0.0020544499,-0.000104050305,-0.005166031,-0.0006363909,0.003065386,0.0035045387,-0.0062775523,0.0016234386,0.0006741005,0.0041785534,-0.003495774,0.0007656268,-0.004601141,0.0020066106,-0.0013210092,-0.0022148576,0.0011779831,0.010989557,0.0020203672,-0.0014654672,0.0045442865,-0.004554606,-0.0012291372,0.0026885653,0.0004677102,-0.0010159636,-0.006729593,-0.00195327,0.0050936877,0.0014983941,-0.0016926788,0.00024389171,0.004872713,0.0043082084,3.2846856e-05,-0.003520932,0.0057079713,-0.0032294404,-0.008749625,-0.002010044,0.0022433118,0.0020868012,-0.0018984355,0.00053935463,-0.0004774294,-0.0012859347,0.0029039884,0.010246783,0.004089716,-0.0010340136,0.0035951491,-0.004133528,0.0004184915,-0.0105692735,0.0006599444,0.0025144706,0.009847279,0.0024827893,-0.0006651445,6.760214e-05,-0.0024769795,-0.00031672724,0.0023811997,0.0007510976,-0.005673365,-0.000598076,-0.009417231,0.00775859,-0.0028320437,0.00097372936,-0.0035561342,0.01803409,-0.015761783,-0.00056145235,0.0043467307,-1.8531133e-05,-0.0010974747,-0.009440118,-0.0011698458,0.0011379182,0.011376663,0.00092496036,1.6509386e-05,0.0016732652,-0.00042462707,-0.00069256173,0.00038970853,-0