% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.pqrBayes.R
\name{predict.pqrBayes}
\alias{predict.pqrBayes}
\title{make predictions from a pqrBayes object}
\usage{
\method{predict}{pqrBayes}(
  object,
  g.new,
  u.new,
  e.new = NULL,
  y.new = NULL,
  quant = 0.5,
  kn = 2,
  degree = 2,
  ...
)
}
\arguments{
\item{object}{pqrBayes object.}

\item{g.new}{a matrix of new predictors (e.g. genetic factors) at which predictions are to be made.}

\item{u.new}{a vector of new environmental factor at which predictions are to be made.}

\item{e.new}{a vector or matrix of new clinic covariates at which predictions are to be made.}

\item{y.new}{a vector of the response of new observations. If provided, the prediction error will be computed based on Y.new.}

\item{quant}{the quantile for the response variable.  The default is 0.5.}

\item{kn}{the number of interior knots for B-spline.}

\item{degree}{the degree of B-spline basis.}

\item{...}{other predict arguments}
}
\value{
an object of class `pqrBayes.pred' is returned, which is a list with components:
\item{error}{prediction error. error is NULL if y.new=NULL.}
\item{y.pred}{predicted values of the new observations.}
}
\description{
make predictions from a pqrBayes object
}
\details{
g.new (u.new) must have the same number of columns as g (u) used for fitting the model. By default, the clinic covariates are NULL unless 
provided. The predictions are made based on the posterior estimates of coefficients in the pqrBayes object.

If y.new is provided, the prediction error will be computed based on the check loss.
}
\seealso{
\code{\link{pqrBayes}}
}
