% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-fit.R
\name{plot_fit}
\alias{plot_fit}
\title{Visualization of estimated mean trajectories and nonlinear functions from a PLSMM}
\usage{
plot_fit(
  x,
  y,
  series,
  t,
  name_group_var,
  plsmm_output,
  predicted = FALSE,
  show_obs = FALSE
)
}
\arguments{
\item{x}{A matrix of predictors.}

\item{y}{A continuous vector of response variable.}

\item{series}{A variable representing different series or groups in the data modeled as a random intercept.}

\item{t}{A numeric vector indicating the time points.}

\item{name_group_var}{A character string specifying the name of the grouping variable.}

\item{plsmm_output}{Output object obtained from the \code{\link{plsmm_lasso}} function.}

\item{predicted}{Logical indicating whether to plot predicted values. If \code{FALSE} only the observed time points are used.}

\item{show_obs}{Logical. If \code{TRUE} the observed time points are used for the position scale of the x-axis.}
}
\value{
Two plots:
\itemize{
\item The first plot shows the observed data and the estimated mean trajectories.
\item The second plot shows the estimated nonlinear functions.
}
}
\description{
This function plots the observed data, the estimated mean trajectories, and
the estimated nonlinear functions from the output of \code{\link{plsmm_lasso}}.
}
\details{
If \code{predicted} is \code{TRUE} the function uses the model from \code{plsmm_output} to predict unobserved time points on a continuous grid of time.
}
\examples{

set.seed(123)
data_sim <- simulate_group_inter(
  N = 50, n_mvnorm = 3, grouped = TRUE,
  timepoints = 3:5, nonpara_inter = TRUE,
  sample_from = seq(0, 52, 13),
  cos = FALSE, A_vec = c(1, 1.5)
)
sim <- data_sim$sim
x <- as.matrix(sim[, -1:-3])
y <- sim$y
series <- sim$series
t <- sim$t
bases <- create_bases(t)
lambda <- 0.0046
gamma <- 0.00000001
plsmm_output <- plsmm_lasso(x, y, series, t,
  name_group_var = "group", bases$bases,
  gamma = gamma, lambda = lambda, timexgroup = TRUE,
  criterion = "BIC"
)
plot_fit(x, y, series, t, name_group_var = "group", plsmm_output)

}
