% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pg_theoretical.R
\name{pg_mean}
\alias{pg_mean}
\alias{pg_var}
\title{Theoretical Polya Gamma Distribution's Mean and Variance}
\usage{
pg_mean(h, z)

pg_var(h, z)
}
\arguments{
\item{h}{A single \code{integer} value corresponding to the "shape" parameter.}

\item{z}{A single \code{numeric} value corresponding to the "scale" parameter.}
}
\value{
Either the theoretical mean or theoretical variance for a Polya Gamma
distribution.
}
\description{
Compute the theoretical mean and variance for a Polya Gamma variable.
}
\examples{
# Fixed parameter distribution simulation ----

## Parameters  ----
h = 1; z = .5
## Attempt distribution recovery  ----
vector_of_pg_samples = rpg_vector(1e6, h, z)

head(vector_of_pg_samples)
length(vector_of_pg_samples)

## Obtain the empirical results   ----
empirical_mean = mean(vector_of_pg_samples)
empirical_var = var(vector_of_pg_samples)

## Take the theoretical values ----
theoretical_mean = pg_mean(h, z)
theoretical_var = pg_var(h, z)

## Form a comparison table ----

# empirically sampled vs. theoretical values
rbind(c(empirical_mean, theoretical_mean),
      c(empirical_var, theoretical_var))
}
