% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pexp.R
\name{timeGrid}
\alias{timeGrid}
\title{Time grid for the PE distribution}
\usage{
timeGrid(time, status, n.int = NULL)
}
\arguments{
\item{time}{Vector of failure times}

\item{status}{Vector of failure indicators}

\item{n.int}{Optional. Number of intervals. If \code{NULL}, the number of intervals is
set to be equal to the number of distinct observed failure times.}
}
\value{
the time grid needed to specify the PE distribution.
}
\description{
This function make use of the observed times and failure indicators to create a time grid for the PE distribution.
}
\examples{
data(telecom)
tgrid1 <- with(telecom, timeGrid(time, status))
tgrid1
tgrid2 <- with(telecom, timeGrid(time, status, n.int = 4))
tgrid2
}
