% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summ-other.R
\name{summ_prob_true}
\alias{summ_prob_true}
\alias{summ_prob_false}
\title{Summarize boolean distribution with probability}
\usage{
summ_prob_false(f)

summ_prob_true(f)
}
\arguments{
\item{f}{A pdqr-function representing distribution.}
}
\value{
A single numeric value representing corresponding probability.
}
\description{
Here \code{summ_prob_false()} returns a probability of 0 and \code{summ_prob_true()} -
complementary probability (one minus \code{summ_prob_false()} output). Both of
them check if their input is a \strong{boolean} pdqr-function: type "discrete"
with \code{x} in \code{x_tbl} identical to \code{c(0, 1)}. If it is not, warning is thrown.
}
\examples{
d_unif <- as_d(dunif)
d_norm <- as_d(dnorm)
summ_prob_true(d_unif > d_norm)
summ_prob_false(2 * d_norm > d_unif)

# When input is "continuous" function or doesn't have 0 as distribution
# element, probability of being false is returned as 0.
summ_prob_false(d_unif)
summ_prob_true(new_d(2, "discrete"))
}
\seealso{
Other summary functions: 
\code{\link{summ_center}()},
\code{\link{summ_classmetric}()},
\code{\link{summ_distance}()},
\code{\link{summ_entropy}()},
\code{\link{summ_hdr}()},
\code{\link{summ_interval}()},
\code{\link{summ_moment}()},
\code{\link{summ_order}()},
\code{\link{summ_pval}()},
\code{\link{summ_quantile}()},
\code{\link{summ_roc}()},
\code{\link{summ_separation}()},
\code{\link{summ_spread}()}
}
\concept{summary functions}
