% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv_reg.R
\name{surv_reg}
\alias{surv_reg}
\title{Parametric survival regression}
\usage{
surv_reg(mode = "regression", engine = "survival", dist = NULL)
}
\arguments{
\item{mode}{A single character string for the prediction outcome mode.
The only possible value for this model is "regression".}

\item{engine}{A single character string specifying what computational engine
to use for fitting.}

\item{dist}{A character string for the probability distribution of the
outcome. The default is "weibull".}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function is deprecated in favor of \code{survival_reg()} which uses the
\code{"censored regression"} mode.

\code{surv_reg()} defines a parametric survival model.

More information on how \pkg{parsnip} is used for modeling is at
\url{https://www.tidymodels.org/}.
}
\details{
This function only defines what \emph{type} of model is being fit. Once an engine
is specified, the \emph{method} to fit the model is also defined. See
\code{\link[=set_engine]{set_engine()}} for more on setting the engine, including how to set engine
arguments.

The model is not trained or fit until the \code{\link[=fit.model_spec]{fit()}} function is used
with the data.

Each of the arguments in this function other than \code{mode} and \code{engine} are
captured as \link[rlang:topic-quosure]{quosures}. To pass values
programmatically, use the \link[rlang:injection-operator]{injection operator} like so:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{value <- 1
surv_reg(argument = !!value)
}\if{html}{\out{</div>}}

Since survival models typically involve censoring (and require the use of
\code{\link[survival:Surv]{survival::Surv()}} objects), the \code{\link[=fit.model_spec]{fit.model_spec()}} function will require that the
survival model be specified via the formula interface.
}
\references{
\url{https://www.tidymodels.org}, \href{https://www.tmwr.org/}{\emph{Tidy Modeling with R}}, \href{https://www.tidymodels.org/find/parsnip/}{searchable table of parsnip models}
}
\keyword{internal}
