% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations.R
\name{wsci}
\alias{wsci}
\alias{within_subjects_conf_int}
\title{Within-Subjects Confidence Intervals}
\usage{
wsci(data, id, factors, dv, level = 0.95, method = "Morey")

within_subjects_conf_int(data, id, factors, dv, level = 0.95, method = "Morey")
}
\arguments{
\item{data}{A \code{data.frame} that contains the data.}

\item{id}{Character. Variable name that identifies subjects.}

\item{factors}{Character. A vector of variable names that is used to stratify the data.}

\item{dv}{Character. The name of the dependent variable.}

\item{level}{Numeric. Defines the width of the interval. Defaults to 0.95
for 95\% confidence intervals.}

\item{method}{Character. The method that is used to calculate CIs. Currently,
"Morey" and "Cousineau" are supported. Defaults to "Morey".}
}
\value{
A \code{data.frame} with additional class \code{papaja_wsci}.
The \code{summary()} method for this class returns a \code{data.frame} with
means along lower and upper limit for each cell of the design.
}
\description{
Calculate Cousineau-Morey within-subjects confidence intervals.
}
\examples{
wsci(
   data = npk
   , id = "block"
   , dv = "yield"
   , factors = c("N", "P")
)
}
\references{
Morey, R. D. (2008). Confidence Intervals from Normalized Data: A correction to Cousineau (2005).
\emph{Tutorials in Quantitative Methods for Psychology}, \emph{4}(2), 61--64.

Cousineau, D. (2005). Confidence intervals in within-subjects designs:
A simpler solution to Loftus and Masson's method.
\emph{Tutorials in Quantitative Methods for Psychology}, \emph{1}(1), 42--45.
}
