library(paletteer)

i <- 1
pal_viz <- function() {
  name <- paste(palettes_d_names[i, ]$package, palettes_d_names[i, ]$palette, sep = "::")
  plot(
    paletteer_d(
      name
    )
  )
  title(name)
  i <<- i + 1
}

palettes_d_names <- tibble::tribble(
  ~package,                         ~palette, ~length, ~type, ~novelty,
  "awtools",                      "a_palette",      8L, "sequential", TRUE,
  "awtools",                       "ppalette",      8L, "qualitative", TRUE,
  "awtools",                       "bpalette",     16L, "qualitative", TRUE,
  "awtools",                       "gpalette",      4L, "sequential", TRUE,
  "awtools",                       "mpalette",      9L, "qualitative", TRUE,
  "awtools",                       "spalette",      6L, "qualitative", TRUE,
  "basetheme",                         "brutal",     10L, "qualitative", TRUE,
  "basetheme",                          "clean",     10L, "qualitative", TRUE,
  "basetheme",                           "dark",     10L, "qualitative", TRUE,
  "basetheme",                       "deepblue",     10L, "qualitative", TRUE,
  "basetheme",                            "ink",     10L, "qualitative", TRUE,
  "basetheme",                        "minimal",     10L, "qualitative", TRUE,
  "basetheme",                          "royal",     10L, "qualitative", TRUE,
  "basetheme",                           "void",     10L, "qualitative", TRUE,
  "beyonce",                             "X1",      6L, "divergent", TRUE,
  "beyonce",                             "X2",      6L, "sequential", TRUE,
  "beyonce",                             "X3",      6L, "sequential", TRUE,
  "beyonce",                             "X4",      6L, "qualitative", TRUE,
  "beyonce",                             "X5",      6L, "qualitative", TRUE,
  "beyonce",                             "X6",      6L, "divergent", TRUE,
  "beyonce",                             "X7",      6L, "sequential", TRUE,
  "beyonce",                             "X8",      6L, "sequential", TRUE,
  "beyonce",                             "X9",      6L, "qualitative", TRUE,
  "beyonce",                            "X10",      6L, "divergent", TRUE,
  "beyonce",                            "X11",      6L, "qualitative", TRUE,
  "beyonce",                            "X12",      6L, "qualitative", TRUE,
  "beyonce",                            "X13",      6L, "qualitative", TRUE,
  "beyonce",                            "X14",      6L, "qualitative", TRUE,
  "beyonce",                            "X15",      6L, "qualitative", TRUE,
  "beyonce",                            "X16",      6L, "sequential", TRUE,
  "beyonce",                            "X17",      6L, "qualitative", TRUE,
  "beyonce",                            "X18",      6L, "qualitative", TRUE,
  "beyonce",                            "X19",      6L, "qualitative", TRUE,
  "beyonce",                            "X20",      6L, "qualitative", TRUE,
  "beyonce",                            "X21",      6L, "qualitative", TRUE,
  "beyonce",                            "X22",      6L, "qualitative", TRUE,
  "beyonce",                            "X23",      6L, "sequential", TRUE,
  "beyonce",                            "X24",      4L, "sequential", TRUE,
  "beyonce",                            "X25",      6L, "qualitative", TRUE,
  "beyonce",                            "X26",      6L, "sequential", TRUE,
  "beyonce",                            "X27",      6L, "qualitative", TRUE,
  "beyonce",                            "X28",      6L, "sequential", TRUE,
  "beyonce",                            "X29",      6L, "qualitative", TRUE,
  "beyonce",                            "X30",      6L, "qualitative", TRUE,
  "beyonce",                            "X31",      6L, "qualitative", TRUE,
  "beyonce",                            "X32",      6L, "qualitative", TRUE,
  "beyonce",                            "X33",      6L, "qualitative", TRUE,
  "beyonce",                            "X34",      6L, "divergent", TRUE,
  "beyonce",                            "X35",      6L, "qualitative", TRUE,
  "beyonce",                            "X36",      6L, "qualitative", TRUE,
  "beyonce",                            "X37",      6L, "qualitative", TRUE,
  "beyonce",                            "X38",      6L, "qualitative", TRUE,
  "beyonce",                            "X39",      6L, "divergent", TRUE,
  "beyonce",                            "X40",      8L, "qualitative", TRUE,
  "beyonce",                            "X41",      5L, "sequential", TRUE,
  "beyonce",                            "X42",      6L, "qualitative", TRUE,
  "beyonce",                            "X43",      6L, "qualitative", TRUE,
  "beyonce",                            "X44",      6L, "qualitative", TRUE,
  "beyonce",                            "X45",      6L, "qualitative", TRUE,
  "beyonce",                            "X46",      6L, "divergent", TRUE,
  "beyonce",                            "X47",      6L, "divergent", TRUE,
  "beyonce",                            "X48",      6L, "qualitative", TRUE,
  "beyonce",                            "X49",      6L, "qualitative", TRUE,
  "beyonce",                            "X50",      6L, "sequential", TRUE,
  "beyonce",                            "X51",      6L, "divergent", TRUE,
  "beyonce",                            "X52",      6L, "sequential", TRUE,
  "beyonce",                            "X53",      6L, "qualitative", TRUE,
  "beyonce",                            "X54",      6L, "sequential", TRUE,
  "beyonce",                            "X55",      7L, "sequential", TRUE,
  "beyonce",                            "X56",      6L, "qualitative", TRUE,
  "beyonce",                            "X57",      9L, "qualitative", TRUE,
  "beyonce",                            "X58",      6L, "sequential", TRUE,
  "beyonce",                            "X59",      9L, "sequential", TRUE,
  "beyonce",                            "X60",      9L, "qualitative", TRUE,
  "beyonce",                            "X61",     15L, "qualitative", TRUE,
  "beyonce",                            "X62",     23L, "qualitative", TRUE,
  "beyonce",                            "X63",     11L, "qualitative", TRUE,
  "beyonce",                            "X64",     11L, "qualitative", TRUE,
  "beyonce",                            "X65",     13L, "qualitative", TRUE,
  "beyonce",                            "X66",     11L, "qualitative", TRUE,
  "beyonce",                            "X67",     11L, "qualitative", TRUE,
  "beyonce",                            "X68",     11L, "qualitative", TRUE,
  "beyonce",                            "X69",     11L, "qualitative", TRUE,
  "beyonce",                            "X70",     11L, "qualitative", TRUE,
  "beyonce",                            "X71",     17L, "qualitative", TRUE,
  "beyonce",                            "X72",     12L, "qualitative", TRUE,
  "beyonce",                            "X73",     14L, "qualitative", TRUE,
  "beyonce",                            "X74",     11L, "qualitative", TRUE,
  "beyonce",                            "X75",     11L, "qualitative", TRUE,
  "beyonce",                            "X76",     20L, "qualitative", TRUE,
  "beyonce",                            "X77",     11L, "qualitative", TRUE,
  "beyonce",                            "X78",      4L, "qualitative", TRUE,
  "beyonce",                            "X79",     11L, "qualitative", TRUE,
  "beyonce",                            "X80",     11L, "qualitative", TRUE,
  "beyonce",                            "X81",     10L, "qualitative", TRUE,
  "beyonce",                            "X82",     11L, "qualitative", TRUE,
  "beyonce",                            "X83",     11L, "qualitative", TRUE,
  "beyonce",                            "X84",     11L, "qualitative", TRUE,
  "beyonce",                            "X85",     11L, "sequential", TRUE,
  "beyonce",                            "X86",     11L, "sequential", TRUE,
  "beyonce",                            "X87",     14L, "sequential", TRUE,
  "beyonce",                            "X88",     12L, "qualitative", TRUE,
  "beyonce",                            "X89",     11L, "qualitative", TRUE,
  "beyonce",                            "X90",     11L, "qualitative", TRUE,
  "beyonce",                            "X91",      6L, "qualitative", TRUE,
  "beyonce",                            "X92",      8L, "qualitative", TRUE,
  "beyonce",                            "X93",     31L, "qualitative", TRUE,
  "beyonce",                            "X94",     14L, "qualitative", TRUE,
  "beyonce",                            "X95",     20L, "qualitative", TRUE,
  "beyonce",                            "X96",     20L, "qualitative", TRUE,
  "beyonce",                            "X97",     19L, "qualitative", TRUE,
  "beyonce",                            "X98",     16L, "qualitative", TRUE,
  "beyonce",                            "X99",     19L, "qualitative", TRUE,
  "beyonce",                           "X100",     14L, "qualitative", TRUE,
  "beyonce",                           "X101",      6L, "qualitative", TRUE,
  "beyonce",                           "X102",      6L, "qualitative", TRUE,
  "beyonce",                           "X103",      5L, "sequential", TRUE,
  "beyonce",                           "X104",      5L, "qualitative", TRUE,
  "beyonce",                           "X105",      6L, "qualitative", TRUE,
  "beyonce",                           "X106",      5L, "qualitative", TRUE,
  "beyonce",                           "X107",      5L, "qualitative", TRUE,
  "beyonce",                           "X108",      7L, "qualitative", TRUE,
  "beyonce",                           "X109",      6L, "qualitative", TRUE,
  "beyonce",                           "X110",     16L, "qualitative", TRUE,
  "beyonce",                           "X111",     15L, "qualitative", TRUE,
  "beyonce",                           "X112",     17L, "qualitative", TRUE,
  "beyonce",                           "X113",     14L, "qualitative", TRUE,
  "beyonce",                           "X114",     18L, "qualitative", TRUE,
  "beyonce",                           "X115",      5L, "sequential", TRUE,
  "beyonce",                           "X116",     21L, "qualitative", TRUE,
  "beyonce",                           "X117",     16L, "qualitative", TRUE,
  "beyonce",                           "X118",     10L, "qualitative", TRUE,
  "beyonce",                           "X119",      7L, "qualitative", TRUE,
  "beyonce",                           "X120",     10L, "qualitative", TRUE,
  "beyonce",                           "X121",      6L, "qualitative", TRUE,
  "beyonce",                           "X122",      6L, "qualitative", TRUE,
  "beyonce",                           "X123",      6L, "qualitative", TRUE,
  "beyonce",                           "X124",      6L, "divergent", TRUE,
  "beyonce",                           "X125",      7L, "qualitative", TRUE,
  "beyonce",                           "X126",      6L, "qualitative", TRUE,
  "beyonce",                           "X127",      6L, "qualitative", TRUE,
  "beyonce",                           "X128",      6L, "qualitative", TRUE,
  "beyonce",                           "X129",      6L, "qualitative", TRUE,
  "beyonce",                           "X130",      5L, "qualitative", TRUE,
  "ButterflyColors",                  "philaethria_dido",      5L, "qualitative", TRUE,
  "ButterflyColors",                    "anteos_menippe",      5L, "qualitative", TRUE,
  "ButterflyColors",                 "fountainea_ryphea",      5L, "qualitative", TRUE,
  "ButterflyColors",                    "lycorea_hallia",      5L, "qualitative", TRUE,
  "ButterflyColors",                    "morpho_helenor",      5L, "qualitative", TRUE,
  "ButterflyColors",  "archaeoprepona_demophon_thalpius",      5L, "qualitative", TRUE,
  "ButterflyColors",                "brassolis_sophorae",      5L, "qualitative", TRUE,
  "ButterflyColors",                "historis_acheronta",      5L, "qualitative", TRUE,
  "ButterflyColors",        "stalachtis_phlegia_susanna",      5L, "qualitative", TRUE,
  "ButterflyColors",                  "battus_polydamas",      5L, "qualitative", TRUE,
  "ButterflyColors",                   "anteos_clorinde",      5L, "qualitative", TRUE,
  "ButterflyColors",                 "chorinea_licursis",      5L, "qualitative", TRUE,
  "ButterflyColors",                   "danaus_eresimus",      5L, "qualitative", TRUE,
  "ButterflyColors",                "smyrna_blomfidiana",      5L, "qualitative", TRUE,
  "ButterflyColors",              "astraptes_fulgerator",      5L, "qualitative", TRUE,
  "ButterflyColors",                 "hamadryas_feronia",      5L, "qualitative", TRUE,
  "ButterflyColors",             "pseudolycaena_marsyas",      5L, "qualitative", TRUE,
  "ButterflyColors",                  "catagramma_pygas",      5L, "qualitative", TRUE,
  "ButterflyColors",          "heliconius_sara_apseudes",      5L, "qualitative", TRUE,
  "ButterflyColors",                   "synargis_calyce",      5L, "qualitative", TRUE,
  "ButterflyColors",                 "hamadryas_feronia",      5L, "qualitative", TRUE,
  "ButterflyColors",          "heliconius_erato_phyllis",      5L, "qualitative", TRUE,
  "ButterflyColors",                 "hylephila_phyleus",      5L, "qualitative", TRUE,
  "ButterflyColors",                    "danaus_erippus",      5L, "qualitative", TRUE,
  "ButterflyColors",                   "danaus_gilippus",      5L, "qualitative", TRUE,
  "ButterflyColors",                   "junonia_evarete",      5L, "qualitative", TRUE,
  "ButterflyColors",                   "hemiargus_hanno",      5L, "qualitative", TRUE,
  "ButterflyColors",                "dynamine_postverta",      5L, "qualitative", TRUE,
  "ButterflyColors",       "parides_zacynthus_polymetus",      5L, "qualitative", TRUE,
  "ButterflyColors",                  "marpesia_petreus",      5L, "qualitative", TRUE,
  "calecopal",                        "sierra1",      6L, "qualitative", TRUE,
  "calecopal",                        "sierra2",      6L, "qualitative", TRUE,
  "calecopal",                     "chaparral1",      6L, "qualitative", TRUE,
  "calecopal",                     "chaparral2",      6L, "qualitative", TRUE,
  "calecopal",                     "chaparral3",      5L, "sequential", TRUE,
  "calecopal",                        "conifer",      5L, "qualitative", TRUE,
  "calecopal",                         "desert",      5L, "sequential", TRUE,
  "calecopal",                        "wetland",      5L, "qualitative", TRUE,
  "calecopal",                            "oak",      5L, "qualitative", TRUE,
  "calecopal",                          "kelp1",      6L, "qualitative", TRUE,
  "calecopal",                          "kelp2",      5L, "qualitative", TRUE,
  "calecopal",                   "coastaldune1",      5L, "qualitative", TRUE,
  "calecopal",                   "coastaldune2",      5L, "qualitative", TRUE,
  "calecopal",                    "superbloom1",      5L, "qualitative", TRUE,
  "calecopal",                    "superbloom2",      5L, "qualitative", TRUE,
  "calecopal",                    "superbloom3",      6L, "qualitative", TRUE,
  "calecopal",                      "sbchannel",      5L, "sequential", TRUE,
  "calecopal",                           "lake",      5L, "qualitative", TRUE,
  "calecopal",                           "fire",      5L, "qualitative", TRUE,
  "calecopal",                    "agriculture",      5L, "qualitative", TRUE,
  "calecopal",                         "bigsur",      6L, "qualitative", TRUE,
  "calecopal",                         "figmtn",      9L, "qualitative", TRUE,
  "calecopal",                           "caqu",      5L, "qualitative", TRUE,
  "calecopal",                   "eschscholzia",      5L, "sequential", TRUE,
  "calecopal",                        "arbutus",      5L, "qualitative", TRUE,
  "calecopal",                    "calochortus",      5L, "qualitative", TRUE,
  "calecopal",                       "grassdry",      5L, "qualitative", TRUE,
  "calecopal",                       "grasswet",      6L, "qualitative", TRUE,
  "calecopal",                           "sage",      5L, "qualitative", TRUE,
  "calecopal",                       "tidepool",      6L, "qualitative", TRUE,
  "calecopal",                       "seagrass",      6L, "qualitative", TRUE,
  "calecopal",                        "bigsur2",      6L, "qualitative", TRUE,
  "calecopal",                          "bixby",      5L, "qualitative", TRUE,
  "calecopal",                       "redwood1",      5L, "qualitative", TRUE,
  "calecopal",                       "redwood2",      5L, "qualitative", TRUE,
  "calecopal",                       "halfdome",      5L, "qualitative", TRUE,
  "calecopal",                          "creek",      6L, "qualitative", TRUE,
  "calecopal",                     "vermillion",      5L, "qualitative", TRUE,
  "calecopal",                         "canary",      5L, "qualitative", TRUE,
  "calecopal",                           "casj",      5L, "qualitative", TRUE,
  "calecopal",                        "lupinus",      5L, "divergent", TRUE,
  "calecopal",                        "dudleya",      5L, "qualitative", TRUE,
  "calecopal",                     "gayophytum",      5L, "qualitative", TRUE,
  "calecopal",                      "collinsia",      5L, "qualitative", TRUE,
  "calecopal",                           "buow",      5L, "qualitative", TRUE,
  "colorBlindness",                  "paletteMartin",     15L, "qualitative", FALSE,
  "colorBlindness",         "Blue2DarkOrange12Steps",     12L, "divergent", FALSE,
  "colorBlindness",         "Blue2DarkOrange18Steps",     18L, "divergent", FALSE,
  "colorBlindness",            "Blue2DarkRed12Steps",     12L, "divergent", FALSE,
  "colorBlindness",            "Blue2DarkRed18Steps",     18L, "divergent", FALSE,
  "colorBlindness",                "Blue2Gray8Steps",      8L, "divergent", FALSE,
  "colorBlindness",              "Blue2Green14Steps",     14L, "divergent", FALSE,
  "colorBlindness",             "Blue2Orange10Steps",     10L, "divergent", FALSE,
  "colorBlindness",             "Blue2Orange12Steps",     12L, "divergent", FALSE,
  "colorBlindness",              "Blue2Orange8Steps",      8L, "divergent", FALSE,
  "colorBlindness",          "Blue2OrangeRed14Steps",     14L, "divergent", FALSE,
  "colorBlindness",              "Brown2Blue10Steps",     10L, "divergent", FALSE,
  "colorBlindness",              "Brown2Blue12Steps",     12L, "divergent", FALSE,
  "colorBlindness",           "Green2Magenta16Steps",     16L, "divergent", FALSE,
  "colorBlindness",      "LightBlue2DarkBlue10Steps",     10L, "sequential", FALSE,
  "colorBlindness",       "LightBlue2DarkBlue7Steps",      7L, "sequential", FALSE,
  "colorBlindness",  "ModifiedSpectralScheme11Steps",     11L, "divergent", FALSE,
  "colorBlindness",             "PairedColor12Steps",     12L, "qualitative", FALSE,
  "colorBlindness",        "SteppedSequential5Steps",     25L, "qualitative", FALSE,
  "colorblindr",                       "OkabeIto",      8L, "qualitative", FALSE,
  "colorblindr",                 "OkabeIto_black",      8L, "qualitative", FALSE,
  "colRoz",                        "grandis",      6L, "qualitative", TRUE,
  "colRoz",                   "flavolineata",      6L, "qualitative", TRUE,
  "colRoz",                         "whitei",      6L, "qualitative", TRUE,
  "colRoz",                          "picta",      6L, "qualitative", TRUE,
  "colRoz",                          "virgo",      6L, "qualitative", TRUE,
  "colRoz",                         "ngadju",      6L, "qualitative", TRUE,
  "colRoz",                     "c_decresii",      6L, "qualitative", TRUE,
  "colRoz",                       "c_kingii",      5L, "qualitative", TRUE,
  "colRoz",                   "e_leuraensis",      5L, "qualitative", TRUE,
  "colRoz",                    "i_lesueurii",      5L, "qualitative", TRUE,
  "colRoz",                       "l_boydii",      5L, "qualitative", TRUE,
  "colRoz",                     "m_horridus",      5L, "qualitative", TRUE,
  "colRoz",                    "m_horridus2",      5L, "qualitative", TRUE,
  "colRoz",                   "t_nigrolutea",      6L, "qualitative", TRUE,
  "colRoz",                   "v_acanthurus",      5L, "sequential", TRUE,
  "colRoz",                  "v_pilbarensis",      5L, "qualitative", TRUE,
  "colRoz",                        "n_levis",      6L, "qualitative", TRUE,
  "colRoz",                   "s_spinigerus",      6L, "qualitative", TRUE,
  "colRoz",                       "e_kingii",      6L, "qualitative", TRUE,
  "colRoz",                          "uluru",      7L, "qualitative", TRUE,
  "colRoz",                      "shark_bay",      6L, "qualitative", TRUE,
  "colRoz",                            "sky",      6L, "sequential", TRUE,
  "colRoz",                  "desert_sunset",      6L, "qualitative", TRUE,
  "colRoz",                    "desert_dusk",      6L, "qualitative", TRUE,
  "colRoz",                   "desert_flood",      6L, "qualitative", TRUE,
  "colRoz",                      "salt_lake",      6L, "qualitative", TRUE,
  "colRoz",                       "daintree",      5L, "qualitative", TRUE,
  "colRoz",                       "spinifex",      6L, "qualitative", TRUE,
  "colRoz",                      "nq_stream",      5L, "qualitative", TRUE,
  "colRoz",                      "kimberley",      5L, "qualitative", TRUE,
  "colRoz",                      "capricorn",      6L, "qualitative", TRUE,
  "colRoz",                       "p_cincta",      6L, "qualitative", TRUE,
  "colRoz",                      "c_azureus",      6L, "qualitative", TRUE,
  "colRoz",                      "m_cyaneus",      5L, "qualitative", TRUE,
  "colRoz",                        "d_novae",      6L, "qualitative", TRUE,
  "colRoz",                      "a_ramsayi",      6L, "qualitative", TRUE,
  "colRoz",                     "n_violacea",      6L, "divergent", TRUE,
  "colRoz",                         "xantho",      6L, "qualitative", TRUE,
  "colRoz",                    "r_aculeatus",      6L, "qualitative", TRUE,
  "colRoz",                    "p_mitchelli",      5L, "qualitative", TRUE,
  "colRoz",                      "k_tristis",      7L, "qualitative", TRUE,
  "colRoz",                    "m_oscellata",      6L, "qualitative", TRUE,
  "colRoz",                       "a_conica",      6L, "qualitative", TRUE,
  "colRoz",                      "v_viatica",      5L, "qualitative", TRUE,
  "colRoz",                        "c_brevi",      7L, "qualitative", TRUE,
  "colRoz",                    "a_westwoodi",      6L, "qualitative", TRUE,
  "colRoz",                     "a_plagiata",      6L, "sequential", TRUE,
  "colRoz",                       "physalia",      6L, "qualitative", TRUE,
  "colRoz",                 "c_australasiae",      6L, "qualitative", TRUE,
  "colRoz",                       "k_scurra",      6L, "qualitative", TRUE,
  "colRoz",                     "l_vestiens",      6L, "qualitative", TRUE,
  "colRoz",                    "t_australis",      6L, "qualitative", TRUE,
  "colRoz",                    "p_breviceps",      6L, "qualitative", TRUE,
  "colRoz",                      "thylacine",      5L, "qualitative", TRUE,
  "dichromat",                 "BrowntoBlue_10",     10L, "divergent", FALSE,
  "dichromat",                 "BrowntoBlue_12",     12L, "divergent", FALSE,
  "dichromat",            "BluetoDarkOrange_12",     12L, "divergent", FALSE,
  "dichromat",            "BluetoDarkOrange_18",     18L, "divergent", FALSE,
  "dichromat",               "DarkRedtoBlue_12",     12L, "divergent", FALSE,
  "dichromat",               "DarkRedtoBlue_18",     18L, "divergent", FALSE,
  "dichromat",                 "BluetoGreen_14",     14L, "divergent", FALSE,
  "dichromat",                   "BluetoGray_8",      8L, "divergent", FALSE,
  "dichromat",             "BluetoOrangeRed_14",     14L, "divergent", FALSE,
  "dichromat",                "BluetoOrange_10",     10L, "divergent", FALSE,
  "dichromat",                "BluetoOrange_12",     12L, "divergent", FALSE,
  "dichromat",                 "BluetoOrange_8",      8L, "divergent", FALSE,
  "dichromat",         "LightBluetoDarkBlue_10",     10L, "sequential", FALSE,
  "dichromat",          "LightBluetoDarkBlue_7",      7L, "sequential", FALSE,
  "dichromat",                 "Categorical_12",     12L, "qualitative", FALSE,
  "dichromat",              "GreentoMagenta_16",     16L, "divergent", FALSE,
  "dichromat",            "SteppedSequential_5",     25L, "qualitative", FALSE,
  "dutchmasters",                       "milkmaid",     13L, "qualitative", TRUE,
  "dutchmasters",                  "pearl_earring",     11L, "qualitative", TRUE,
  "dutchmasters",                  "view_of_Delft",     12L, "qualitative", TRUE,
  "dutchmasters",                  "little_street",     11L, "qualitative", TRUE,
  "dutchmasters",                        "anatomy",      7L, "qualitative", TRUE,
  "dutchmasters",                  "staalmeesters",      7L, "qualitative", TRUE,
  "DresdenColor",                     "stormfront",      6L, "qualitative", TRUE,
  "DresdenColor",                       "foolmoon",      6L, "qualitative", TRUE,
  "DresdenColor",                     "graveperil",      6L, "qualitative", TRUE,
  "DresdenColor",                   "summerknight",      6L, "qualitative", TRUE,
  "DresdenColor",                     "deathmasks",      6L, "qualitative", TRUE,
  "DresdenColor",                     "bloodrites",      6L, "qualitative", TRUE,
  "DresdenColor",                       "deadbeat",      6L, "qualitative", TRUE,
  "DresdenColor",                   "provenguilty",      6L, "qualitative", TRUE,
  "DresdenColor",                     "whitenight",      6L, "qualitative", TRUE,
  "DresdenColor",                     "smallfavor",      6L, "qualitative", TRUE,
  "DresdenColor",                       "turncoat",      6L, "qualitative", TRUE,
  "DresdenColor",                        "changes",      6L, "qualitative", TRUE,
  "DresdenColor",                     "ghoststory",      6L, "qualitative", TRUE,
  "DresdenColor",                       "colddays",      6L, "qualitative", TRUE,
  "DresdenColor",                       "skingame",      6L, "qualitative", TRUE,
  "DresdenColor",                       "sidejobs",      6L, "qualitative", TRUE,
  "DresdenColor",                     "briefcases",      6L, "qualitative", TRUE,
  "DresdenColor",                         "paired",     12L, "qualitative", TRUE,
  "feathers",                  "spotted_pardalote",      6L, "qualitative", TRUE,
  "feathers",                    "plains_wanderer",      7L, "qualitative", TRUE,
  "feathers",                          "bee_eater",      7L, "qualitative", TRUE,
  "feathers",            "rose_crowned_fruit_dove",      8L, "qualitative", TRUE,
  "feathers",                    "eastern_rosella",      7L, "qualitative", TRUE,
  "feathers",                             "oriole",     10L, "qualitative", TRUE,
  "feathers",                    "princess_parrot",      8L, "qualitative", TRUE,
  "feathers",                  "superb_fairy_wren",      5L, "qualitative", TRUE,
  "feathers",                          "cassowary",      8L, "qualitative", TRUE,
  "feathers",                       "yellow_robin",      7L, "qualitative", TRUE,
  "feathers",                              "galah",      6L, "qualitative", TRUE,
  "fishualize",      "Acanthisthius_brasilianus",      5L, "qualitative", TRUE,
  "fishualize",     "Acanthostracion_polygonius",      5L, "sequential", TRUE,
  "fishualize",   "Acanthostracion_polygonius_y",      5L, "qualitative", TRUE,
  "fishualize",           "Acanthurus_chirurgus",      5L, "qualitative", TRUE,
  "fishualize",           "Acanthurus_coeruleus",      5L, "qualitative", TRUE,
  "fishualize",        "Acanthurus_leucosternon",      5L, "qualitative", TRUE,
  "fishualize",           "Acanthurus_olivaceus",      5L, "qualitative", TRUE,
  "fishualize",               "Acanthurus_sohal",      5L, "qualitative", TRUE,
  "fishualize",          "Acanthurus_triostegus",      5L, "sequential", TRUE,
  "fishualize",                   "Alosa_fallax",      5L, "qualitative", TRUE,
  "fishualize",              "Aluterus_scriptus",      5L, "sequential", TRUE,
  "fishualize",     "Anchoviella_lepidentostole",      5L, "qualitative", TRUE,
  "fishualize",         "Anisotremus_virginicus",      5L, "qualitative", TRUE,
  "fishualize",          "Antennarius_commerson",      5L, "qualitative", TRUE,
  "fishualize",     "Antennarius_multiocellatus",      5L, "sequential", TRUE,
  "fishualize",       "Atherinella_brasiliensis",      5L, "qualitative", TRUE,
  "fishualize",           "Aulostomus_chinensis",      5L, "qualitative", TRUE,
  "fishualize",           "Balistapus_undulatus",      5L, "qualitative", TRUE,
  "fishualize",                "Balistes_vetula",      5L, "qualitative", TRUE,
  "fishualize",       "Balistoides_conspicillum",      5L, "qualitative", TRUE,
  "fishualize",                  "Barbus_barbus",      5L, "qualitative", TRUE,
  "fishualize",            "Bodianus_pulchellus",      5L, "qualitative", TRUE,
  "fishualize",                 "Bodianus_rufus",      5L, "qualitative", TRUE,
  "fishualize",              "Bryaninops_natans",      5L, "qualitative", TRUE,
  "fishualize",          "Callanthias_australis",      5L, "qualitative", TRUE,
  "fishualize",        "Cantherhines_macrocerus",      5L, "qualitative", TRUE,
  "fishualize",            "Centropyge_loricula",      5L, "qualitative", TRUE,
  "fishualize",            "Cephalopholis_argus",      5L, "qualitative", TRUE,
  "fishualize",            "Cephalopholis_fulva",      5L, "qualitative", TRUE,
  "fishualize",         "Cetengraulis_edentulus",      5L, "qualitative", TRUE,
  "fishualize",            "Chaetodon_ephippium",      5L, "qualitative", TRUE,
  "fishualize",             "Chaetodon_larvatus",      5L, "qualitative", TRUE,
  "fishualize",           "Chaetodon_pelewensis",      5L, "qualitative", TRUE,
  "fishualize",          "Chaetodon_sedentarius",      5L, "qualitative", TRUE,
  "fishualize", "Chaetodontoplus_conspicillatus",      5L, "qualitative", TRUE,
  "fishualize",          "Chlorurus_microrhinos",      5L, "qualitative", TRUE,
  "fishualize",             "Chlorurus_spilurus",      5L, "qualitative", TRUE,
  "fishualize",           "Chormis_multilineata",      5L, "qualitative", TRUE,
  "fishualize",            "Chromis_vanderbilti",      5L, "qualitative", TRUE,
  "fishualize",        "Cirrhilabrus_solorensis",      5L, "qualitative", TRUE,
  "fishualize",         "Cirrhilabrus_tonozukai",      5L, "qualitative", TRUE,
  "fishualize",         "Clepticus_brasiliensis",      5L, "qualitative", TRUE,
  "fishualize",               "Clepticus_parrae",      5L, "qualitative", TRUE,
  "fishualize",                  "Coris_gaimard",      5L, "qualitative", TRUE,
  "fishualize",            "Coryphaena_hippurus",      5L, "qualitative", TRUE,
  "fishualize",         "Ctenochaetus_strigosus",      5L, "qualitative", TRUE,
  "fishualize",           "Dermatolepis_inermis",      5L, "qualitative", TRUE,
  "fishualize",              "Elacatinus_figaro",      5L, "qualitative", TRUE,
  "fishualize",           "Elagatis_bipinnulata",      5L, "qualitative", TRUE,
  "fishualize",            "Epibulus_insidiator",      5L, "qualitative", TRUE,
  "fishualize",          "Epinephelus_fasciatus",      5L, "qualitative", TRUE,
  "fishualize",        "Epinephelus_lanceolatus",      5L, "qualitative", TRUE,
  "fishualize",         "Epinephelus_marginatus",      5L, "qualitative", TRUE,
  "fishualize",           "Epinephelus_striatus",      5L, "sequential", TRUE,
  "fishualize",                    "Esox_lucius",      5L, "sequential", TRUE,
  "fishualize",          "Etheostoma_barrenense",      5L, "qualitative", TRUE,
  "fishualize",          "Etheostoma_spectabile",      5L, "qualitative", TRUE,
  "fishualize",                "Exallias_brevis",      5L, "qualitative", TRUE,
  "fishualize",        "Forcipiger_longirostris",      5L, "qualitative", TRUE,
  "fishualize",                   "Gadus_morhua",      5L, "qualitative", TRUE,
  "fishualize",         "Ginglymostoma_cirratum",      5L, "qualitative", TRUE,
  "fishualize",               "Gomphosus_varius",      5L, "qualitative", TRUE,
  "fishualize",            "Gramma_brasiliensis",      5L, "qualitative", TRUE,
  "fishualize",                  "Gramma_loreto",      5L, "qualitative", TRUE,
  "fishualize",           "Gymnothorax_funebris",      5L, "qualitative", TRUE,
  "fishualize",           "Haemulon_squamipinna",      5L, "qualitative", TRUE,
  "fishualize",         "Halichoeres_bivittatus",      5L, "qualitative", TRUE,
  "fishualize",       "Halichoeres_brasiliensis",      5L, "sequential", TRUE,
  "fishualize",         "Halichoeres_dimidiatus",      5L, "qualitative", TRUE,
  "fishualize",            "Halichoeres_garnoti",      5L, "qualitative", TRUE,
  "fishualize",           "Halichoeres_radiatus",      5L, "qualitative", TRUE,
  "fishualize",               "Hamulon_plumieri",      5L, "qualitative", TRUE,
  "fishualize",              "Harengula_jaguana",      5L, "qualitative", TRUE,
  "fishualize",      "Hemitaurichthys_polylepis",      5L, "qualitative", TRUE,
  "fishualize",   "Heretopriacanthus_cruentatus",      5L, "qualitative", TRUE,
  "fishualize",       "Hexagrammos_lagocephalus",      5L, "qualitative", TRUE,
  "fishualize",              "Hippocampus_reidi",      5L, "qualitative", TRUE,
  "fishualize",      "Histiophryne_psychedelica",      5L, "qualitative", TRUE,
  "fishualize",           "Holacanthus_ciliaris",      5L, "qualitative", TRUE,
  "fishualize",       "Holocentrus_adscensionis",      5L, "qualitative", TRUE,
  "fishualize",     "Hypleurochilus_fissicornis",      5L, "qualitative", TRUE,
  "fishualize",            "Hypoplectrus_puella",      5L, "qualitative", TRUE,
  "fishualize",          "Hypsoblennius_invemar",      5L, "qualitative", TRUE,
  "fishualize",           "Hypsypops_rubicundus",      5L, "qualitative", TRUE,
  "fishualize",          "Koumansetta_rainfordi",      5L, "qualitative", TRUE,
  "fishualize",             "Labrisomus_cricota",      5L, "qualitative", TRUE,
  "fishualize",         "Labrisomus_nuchipinnis",      5L, "qualitative", TRUE,
  "fishualize",               "Lampris_guttatus",      5L, "qualitative", TRUE,
  "fishualize",              "Lepomis_megalotis",      5L, "qualitative", TRUE,
  "fishualize",                "Lile_piquitinga",      5L, "qualitative", TRUE,
  "fishualize",                  "Lutjanus_jocu",      5L, "qualitative", TRUE,
  "fishualize",                 "Lutjanus_sebae",      5L, "qualitative", TRUE,
  "fishualize",        "Lycengraulis_grossidens",      5L, "qualitative", TRUE,
  "fishualize",               "Melichthys_vidua",      5L, "qualitative", TRUE,
  "fishualize",        "Micropterus_punctulatus",      5L, "qualitative", TRUE,
  "fishualize",            "Minilabrus_striatus",      5L, "qualitative", TRUE,
  "fishualize",                     "Mugil_liza",      5L, "qualitative", TRUE,
  "fishualize",            "Mycteroperca_bonaci",      5L, "qualitative", TRUE,
  "fishualize",           "Myrichthys_ocellatus",      5L, "qualitative", TRUE,
  "fishualize",                 "Naso_lituratus",      5L, "qualitative", TRUE,
  "fishualize",        "Nemateleotris_magnifica",      5L, "qualitative", TRUE,
  "fishualize",         "Neogobius_melanostomus",      5L, "qualitative", TRUE,
  "fishualize",                   "Odonus_niger",      5L, "qualitative", TRUE,
  "fishualize",         "Oncorhynchus_gorbuscha",      5L, "qualitative", TRUE,
  "fishualize",              "Oncorhynchus_keta",      5L, "qualitative", TRUE,
  "fishualize",           "Oncorhynchus_kisutch",      5L, "qualitative", TRUE,
  "fishualize",            "Oncorhynchus_mykiss",      5L, "qualitative", TRUE,
  "fishualize",             "Oncorhynchus_nerka",      5L, "qualitative", TRUE,
  "fishualize",       "Oncorhynchus_tshawytscha",      5L, "qualitative", TRUE,
  "fishualize",            "Opisthonema_oglinum",      5L, "qualitative", TRUE,
  "fishualize",        "Ostorhinchus_angustatus",      5L, "qualitative", TRUE,
  "fishualize",              "Ostracion_cubicus",      5L, "sequential", TRUE,
  "fishualize",             "Ostracion_whitleyi",      5L, "sequential", TRUE,
  "fishualize",    "Oxymonacanthus_longirostris",      5L, "qualitative", TRUE,
  "fishualize",         "Parablennius_marmoreus",      5L, "qualitative", TRUE,
  "fishualize",        "Parablennius_pilicornis",      5L, "qualitative", TRUE,
  "fishualize",          "Paracanthurus_hepatus",      5L, "qualitative", TRUE,
  "fishualize",          "Paralabrax_clathratus",      5L, "sequential", TRUE,
  "fishualize",            "Paranthias_furcifer",      5L, "qualitative", TRUE,
  "fishualize",           "Pareiorhaphis_garbei",      5L, "qualitative", TRUE,
  "fishualize",           "Parupeneus_insularis",      5L, "qualitative", TRUE,
  "fishualize",             "Petromyzon_marinus",      5L, "sequential", TRUE,
  "fishualize", "Phractocephalus_hemioliopterus",      5L, "qualitative", TRUE,
  "fishualize",          "Pleuronectes_platessa",      5L, "qualitative", TRUE,
  "fishualize",          "Pomacanthus_imperator",      5L, "qualitative", TRUE,
  "fishualize",               "Pomacanthus_paru",      5L, "qualitative", TRUE,
  "fishualize",      "Pomacanthus_xanthometopon",      5L, "qualitative", TRUE,
  "fishualize",                "Prionace_glauca",      5L, "qualitative", TRUE,
  "fishualize",      "Prognathodes_brasiliensis",      5L, "qualitative", TRUE,
  "fishualize",        "Prognathodes_guyanensis",      5L, "qualitative", TRUE,
  "fishualize",   "Pronotogrammus_martinicensis",      5L, "qualitative", TRUE,
  "fishualize",    "Pseudocheilinus_tetrataenia",      5L, "qualitative", TRUE,
  "fishualize",     "Pseudochromis_aldabraensis",      5L, "qualitative", TRUE,
  "fishualize",         "Pseudupeneus_maculatus",      5L, "qualitative", TRUE,
  "fishualize",               "Pterois_volitans",      5L, "qualitative", TRUE,
  "fishualize",         "Rhinecanthus_aculeatus",      5L, "qualitative", TRUE,
  "fishualize",            "Rhinecanthus_assasi",      5L, "qualitative", TRUE,
  "fishualize",                    "Salmo_salar",      5L, "qualitative", TRUE,
  "fishualize",                   "Salmo_trutta",      5L, "qualitative", TRUE,
  "fishualize",          "Salvelinus_fontinalis",      5L, "qualitative", TRUE,
  "fishualize",              "Sander_lucioperca",      5L, "qualitative", TRUE,
  "fishualize",        "Sardinella_brasiliensis",      5L, "qualitative", TRUE,
  "fishualize",           "Sargocentron_bullisi",      5L, "qualitative", TRUE,
  "fishualize",                 "Scarus_ghobban",      5L, "qualitative", TRUE,
  "fishualize",               "Scarus_globiceps",      5L, "qualitative", TRUE,
  "fishualize",                "Scarus_hoefleri",      5L, "qualitative", TRUE,
  "fishualize",                   "Scarus_quoyi",      5L, "qualitative", TRUE,
  "fishualize",                "Scarus_tricolor",      5L, "qualitative", TRUE,
  "fishualize",                "Scarus_zelindae",      5L, "qualitative", TRUE,
  "fishualize",          "Semicossyphus_pulcher",      5L, "sequential", TRUE,
  "fishualize",              "Serranus_baldwini",      5L, "qualitative", TRUE,
  "fishualize",                "Serranus_scriba",      5L, "qualitative", TRUE,
  "fishualize",          "Sparisoma_frondosum_m",      5L, "qualitative", TRUE,
  "fishualize",        "Sparisoma_tuyupiranga_f",      5L, "qualitative", TRUE,
  "fishualize",        "Sparisoma_tuyupiranga_m",      5L, "qualitative", TRUE,
  "fishualize",               "Sparisoma_viride",      5L, "qualitative", TRUE,
  "fishualize",            "Stegastes_nigricans",      5L, "qualitative", TRUE,
  "fishualize",             "Stegastes_partitus",      5L, "qualitative", TRUE,
  "fishualize",           "Stegastes_variabilis",      5L, "qualitative", TRUE,
  "fishualize",        "Stethojulis_bandanensis",      5L, "qualitative", TRUE,
  "fishualize",         "Synchiropus_splendidus",      5L, "qualitative", TRUE,
  "fishualize",                 "Taeniura_lymma",      5L, "qualitative", TRUE,
  "fishualize",         "Thalassoma_bifasciatum",      5L, "qualitative", TRUE,
  "fishualize",           "Thalassoma_hardwicke",      5L, "qualitative", TRUE,
  "fishualize",          "Thalassoma_noronhanum",      5L, "qualitative", TRUE,
  "fishualize",                "Thalassoma_pavo",      5L, "qualitative", TRUE,
  "fishualize",                 "Thunnus_obesus",      5L, "qualitative", TRUE,
  "fishualize",                 "Trimma_lantana",      5L, "qualitative", TRUE,
  "fishualize",          "Valenciennea_strigata",      5L, "qualitative", TRUE,
  "fishualize",                  "Variola_louti",      5L, "qualitative", TRUE,
  "fishualize",            "Xyrichthys_novacula",      5L, "qualitative", TRUE,
  "fishualize",               "Zanclus_cornutus",      5L, "qualitative", TRUE,
  "fishualize",          "Zapteryx_brevirostris",      5L, "qualitative", TRUE,
  "fishualize",              "Zebrasoma_velifer",      5L, "qualitative", TRUE,
  "fishualize",            "Zebrasoma_xanthurum",      5L, "qualitative", TRUE,
  "futurevisions",                          "venus",      5L, "qualitative", TRUE,
  "futurevisions",                          "earth",      7L, "qualitative", TRUE,
  "futurevisions",                           "mars",      6L, "qualitative", TRUE,
  "futurevisions",                        "jupiter",      6L, "qualitative", TRUE,
  "futurevisions",                          "ceres",      4L, "sequential", TRUE,
  "futurevisions",                      "enceladus",      5L, "qualitative", TRUE,
  "futurevisions",                         "europa",      5L, "sequential", TRUE,
  "futurevisions",                          "titan",      6L, "sequential", TRUE,
  "futurevisions",                         "cancri",      6L, "sequential", TRUE,
  "futurevisions",                             "hd",      6L, "qualitative", TRUE,
  "futurevisions",                      "kepler186",      9L, "divergent", TRUE,
  "futurevisions",                      "kepler16b",      7L, "qualitative", TRUE,
  "futurevisions",                         "pegasi",      8L, "qualitative", TRUE,
  "futurevisions",                            "pso",      5L, "sequential", TRUE,
  "futurevisions",                       "trappest",      8L, "qualitative", TRUE,
  "futurevisions",                     "grand_tour",      7L, "qualitative", TRUE,
  "futurevisions",                   "atomic_clock",      5L, "qualitative", TRUE,
  "futurevisions",                     "atomic_red",      3L, "qualitative", TRUE,
  "futurevisions",                    "atomic_blue",      3L, "qualitative", TRUE,
  "futurevisions",                  "atomic_orange",      3L, "qualitative", TRUE,
  "ggsci",                        "nrc_npg",     10L, "qualitative", TRUE,
  "ggsci",                   "default_aaas",     10L, "qualitative", TRUE,
  "ggsci",                   "default_nejm",      8L, "qualitative", TRUE,
  "ggsci",                  "lanonc_lancet",      9L, "qualitative", TRUE,
  "ggsci",                   "default_jama",      7L, "qualitative", TRUE,
  "ggsci",                    "default_jco",     10L, "qualitative", TRUE,
  "ggsci",              "default_frontiers",     10L, "qualitative", TRUE,
  "ggsci",                 "default_flatui",     10L, "qualitative", TRUE,
  "ggsci",              "flattastic_flatui",     12L, "qualitative", TRUE,
  "ggsci",                  "aussie_flatui",     10L, "qualitative", TRUE,
  "ggsci",                 "default_ucscgb",     26L, "qualitative", FALSE,
  "ggsci",                  "category10_d3",     10L, "qualitative", FALSE,
  "ggsci",                  "category20_d3",     20L, "qualitative", FALSE,
  "ggsci",                 "category20b_d3",     20L, "qualitative", FALSE,
  "ggsci",                 "category20c_d3",     20L, "qualitative", FALSE,
  "ggsci",                    "default_igv",     51L, "qualitative", FALSE,
  "ggsci",                "alternating_igv",      2L, "qualitative", FALSE,
  "ggsci",              "default_locuszoom",      7L, "qualitative", TRUE,
  "ggsci",               "default_uchicago",      9L, "qualitative", TRUE,
  "ggsci",                 "light_uchicago",      9L, "qualitative", TRUE,
  "ggsci",                  "dark_uchicago",      9L, "qualitative", TRUE,
  "ggsci",          "hallmarks_dark_cosmic",     10L, "qualitative", TRUE,
  "ggsci",         "hallmarks_light_cosmic",     10L, "qualitative", TRUE,
  "ggsci", "signature_substitutions_cosmic",      6L, "qualitative", TRUE,
  "ggsci",           "springfield_simpsons",     16L, "qualitative", TRUE,
  "ggsci",         "planetexpress_futurama",     12L, "qualitative", TRUE,
  "ggsci",          "schwifty_rickandmorty",     12L, "qualitative", TRUE,
  "ggsci",               "uniform_startrek",      7L, "qualitative", TRUE,
  "ggsci",                    "legacy_tron",      7L, "qualitative", TRUE,
  "ggsci",                   "default_gsea",     12L, "divergent", FALSE,
  "ggsci",                   "red_material",     10L, "sequential", FALSE,
  "ggsci",                  "pink_material",     10L, "sequential", FALSE,
  "ggsci",                "purple_material",     10L, "sequential", FALSE,
  "ggsci",           "deep_purple_material",     10L, "sequential", FALSE,
  "ggsci",                "indigo_material",     10L, "sequential", FALSE,
  "ggsci",                  "blue_material",     10L, "sequential", FALSE,
  "ggsci",            "light_blue_material",     10L, "sequential", FALSE,
  "ggsci",                  "cyan_material",     10L, "sequential", FALSE,
  "ggsci",                  "teal_material",     10L, "sequential", FALSE,
  "ggsci",                 "green_material",     10L, "sequential", FALSE,
  "ggsci",           "light_green_material",     10L, "sequential", FALSE,
  "ggsci",                  "lime_material",     10L, "sequential", FALSE,
  "ggsci",                "yellow_material",     10L, "sequential", FALSE,
  "ggsci",                 "amber_material",     10L, "sequential", FALSE,
  "ggsci",                "orange_material",     10L, "sequential", FALSE,
  "ggsci",           "deep_orange_material",     10L, "sequential", FALSE,
  "ggsci",                 "brown_material",     10L, "sequential", FALSE,
  "ggsci",                  "grey_material",     10L, "sequential", FALSE,
  "ggsci",             "blue_grey_material",     10L, "sequential", FALSE,
  "ggpomological",               "pomological_base",      7L, "qualitative", TRUE,
  "ggpomological",            "pomological_palette",      9L, "qualitative", TRUE,
  "ggprism",                  "autumn_leaves",      9L, "qualitative", TRUE,
  "ggprism",                  "beer_and_ales",      9L, "qualitative", TRUE,
  "ggprism",                "black_and_white",      9L, "qualitative", TRUE,
  "ggprism",                      "blueprint",      9L, "qualitative", TRUE,
  "ggprism",                     "blueprint2",      9L, "qualitative", TRUE,
  "ggprism",                     "blueprint3",      9L, "qualitative", TRUE,
  "ggprism",                   "candy_bright",      9L, "qualitative", TRUE,
  "ggprism",                     "candy_soft",      9L, "qualitative", TRUE,
  "ggprism",                "colorblind_safe",      6L, "qualitative", TRUE,
  "ggprism",                         "colors",     20L, "qualitative", TRUE,
  "ggprism",                          "diazo",      9L, "qualitative", TRUE,
  "ggprism",                    "earth_tones",     10L, "qualitative", TRUE,
  "ggprism",                      "evergreen",      9L, "qualitative", TRUE,
  "ggprism",                            "fir",      9L, "qualitative", TRUE,
  "ggprism",                           "fir2",      9L, "qualitative", TRUE,
  "ggprism",                           "fir3",      9L, "qualitative", TRUE,
  "ggprism",                         "flames",      9L, "qualitative", TRUE,
  "ggprism",                        "flames2",      9L, "qualitative", TRUE,
  "ggprism",                         "floral",     12L, "qualitative", TRUE,
  "ggprism",                        "floral2",     12L, "qualitative", TRUE,
  "ggprism",                      "greenwash",     10L, "qualitative", TRUE,
  "ggprism",                        "inferno",      6L, "sequential", TRUE,
  "ggprism",                          "magma",      6L, "sequential", TRUE,
  "ggprism",                  "mustard_field",      9L, "qualitative", TRUE,
  "ggprism",                 "mustard_field2",      9L, "qualitative", TRUE,
  "ggprism",                  "muted_rainbow",     10L, "qualitative", TRUE,
  "ggprism",                           "neon",      9L, "qualitative", TRUE,
  "ggprism",                          "ocean",      9L, "qualitative", TRUE,
  "ggprism",                         "ocean2",      9L, "qualitative", TRUE,
  "ggprism",                         "ocean3",      9L, "qualitative", TRUE,
  "ggprism",                         "office",      9L, "qualitative", TRUE,
  "ggprism",                        "pastels",      9L, "qualitative", TRUE,
  "ggprism",                          "pearl",      6L, "qualitative", TRUE,
  "ggprism",                         "pearl2",      6L, "qualitative", TRUE,
  "ggprism",                         "plasma",      6L, "sequential", TRUE,
  "ggprism",                     "prism_dark",     10L, "qualitative", TRUE,
  "ggprism",                    "prism_dark2",     10L, "qualitative", TRUE,
  "ggprism",                    "prism_light",     10L, "qualitative", TRUE,
  "ggprism",                   "prism_light2",     10L, "qualitative", TRUE,
  "ggprism",                 "purple_passion",      9L, "qualitative", TRUE,
  "ggprism",                          "quiet",      9L, "qualitative", TRUE,
  "ggprism",                         "quiet2",      9L, "qualitative", TRUE,
  "ggprism",                 "shades_of_gray",      9L, "qualitative", TRUE,
  "ggprism",                         "spring",      9L, "qualitative", TRUE,
  "ggprism",                        "spring2",      9L, "qualitative", TRUE,
  "ggprism",                  "stained_glass",      9L, "qualitative", TRUE,
  "ggprism",                 "stained_glass2",      9L, "qualitative", TRUE,
  "ggprism",                         "starry",      5L, "qualitative", TRUE,
  "ggprism",                        "starry2",      5L, "qualitative", TRUE,
  "ggprism",                         "summer",     10L, "qualitative", TRUE,
  "ggprism",                   "sunny_garden",      9L, "qualitative", TRUE,
  "ggprism",                  "sunny_garden2",      9L, "qualitative", TRUE,
  "ggprism",                  "sunny_garden3",      9L, "qualitative", TRUE,
  "ggprism",                      "the_blues",      9L, "qualitative", TRUE,
  "ggprism",                        "viridis",      6L, "sequential", TRUE,
  "ggprism",                 "warm_and_sunny",      9L, "qualitative", TRUE,
  "ggprism",                   "warm_pastels",      9L, "qualitative", TRUE,
  "ggprism",                  "warm_pastels2",      9L, "qualitative", TRUE,
  "ggprism",                          "waves",      5L, "qualitative", TRUE,
  "ggprism",                         "waves2",      5L, "qualitative", TRUE,
  "ggprism",                  "winter_bright",      9L, "qualitative", TRUE,
  "ggprism",                    "winter_soft",      9L, "qualitative", TRUE,
  "ggprism",                   "wool_muffler",      9L, "qualitative", TRUE,
  "ggprism",                  "wool_muffler2",      9L, "qualitative", TRUE,
  "ggprism",                  "wool_muffler3",      9L, "qualitative", TRUE,
  "ggthemes",                           "calc",     12L, "qualitative", TRUE,
  "ggthemes",                        "manyeys",     19L, "qualitative", TRUE,
  "ggthemes",                           "gdoc",     10L, "qualitative", TRUE,
  "ggthemes",                "fivethirtyeight",      6L, "qualitative", TRUE,
  "ggthemes",                     "colorblind",      8L, "qualitative", FALSE,
  "ggthemes",                     "Tableau_10",     10L, "qualitative", FALSE,
  "ggthemes",                     "Tableau_20",     20L, "qualitative", FALSE,
  "ggthemes",                    "Color_Blind",     10L, "qualitative", FALSE,
  "ggthemes",                  "Seattle_Grays",      5L, "qualitative", TRUE,
  "ggthemes",                        "Traffic",      9L, "qualitative", TRUE,
  "ggthemes",                   "Miller_Stone",     11L, "qualitative", TRUE,
  "ggthemes",              "Superfishel_Stone",     10L, "qualitative", TRUE,
  "ggthemes",                   "Nuriel_Stone",      9L, "qualitative", TRUE,
  "ggthemes",                   "Jewel_Bright",      9L, "qualitative", TRUE,
  "ggthemes",                         "Summer",      8L, "qualitative", TRUE,
  "ggthemes",                         "Winter",     10L, "qualitative", TRUE,
  "ggthemes",              "Green_Orange_Teal",     12L, "qualitative", TRUE,
  "ggthemes",                 "Red_Blue_Brown",     12L, "qualitative", TRUE,
  "ggthemes",               "Purple_Pink_Gray",     12L, "qualitative", TRUE,
  "ggthemes",                     "Hue_Circle",     19L, "qualitative", TRUE,
  "ggthemes",                     "Classic_10",     10L, "qualitative", FALSE,
  "ggthemes",              "Classic_10_Medium",     10L, "qualitative", FALSE,
  "ggthemes",               "Classic_10_Light",     10L, "qualitative", FALSE,
  "ggthemes",                     "Classic_20",     20L, "qualitative", FALSE,
  "ggthemes",                 "Classic_Gray_5",      5L, "qualitative", FALSE,
  "ggthemes",            "Classic_Color_Blind",     10L, "qualitative", FALSE,
  "ggthemes",          "Classic_Traffic_Light",      9L, "qualitative", FALSE,
  "ggthemes",          "Classic_Purple_Gray_6",      6L, "qualitative", FALSE,
  "ggthemes",         "Classic_Purple_Gray_12",     12L, "qualitative", FALSE,
  "ggthemes",         "Classic_Green_Orange_6",      6L, "qualitative", FALSE,
  "ggthemes",        "Classic_Green_Orange_12",     12L, "qualitative", FALSE,
  "ggthemes",             "Classic_Blue_Red_6",      6L, "qualitative", FALSE,
  "ggthemes",            "Classic_Blue_Red_12",     12L, "qualitative", FALSE,
  "ggthemes",                 "Classic_Cyclic",     13L, "qualitative", FALSE,
  "ggthemes",                      "few_Light",      9L, "qualitative", FALSE,
  "ggthemes",                     "few_Medium",      9L, "qualitative", FALSE,
  "ggthemes",                       "few_Dark",      9L, "qualitative", FALSE,
  "ggthemes",                    "excel_Atlas",      6L, "qualitative", FALSE,
  "ggthemes",                    "excel_Badge",      6L, "qualitative", FALSE,
  "ggthemes",                   "excel_Berlin",      6L, "qualitative", FALSE,
  "ggthemes",                "excel_Celestial",      6L, "qualitative", FALSE,
  "ggthemes",                     "excel_Crop",      6L, "qualitative", FALSE,
  "ggthemes",                    "excel_Depth",      6L, "qualitative", FALSE,
  "ggthemes",                  "excel_Droplet",      6L, "qualitative", FALSE,
  "ggthemes",                    "excel_Facet",      6L, "qualitative", FALSE,
  "ggthemes",                "excel_Feathered",      6L, "qualitative", FALSE,
  "ggthemes",                  "excel_Gallery",      6L, "qualitative", FALSE,
  "ggthemes",                "excel_Headlines",      6L, "qualitative", TRUE,
  "ggthemes",                 "excel_Integral",      6L, "qualitative", TRUE,
  "ggthemes",            "excel_Ion_Boardroom",      6L, "qualitative", TRUE,
  "ggthemes",                      "excel_Ion",      6L, "qualitative", TRUE,
  "ggthemes",                  "excel_Madison",      6L, "qualitative", TRUE,
  "ggthemes",               "excel_Main_Event",      6L, "qualitative", TRUE,
  "ggthemes",                     "excel_Mesh",      6L, "qualitative", TRUE,
  "ggthemes",             "excel_Office_Theme",      6L, "qualitative", TRUE,
  "ggthemes",                  "excel_Organic",      6L, "qualitative", TRUE,
  "ggthemes",                 "excel_Parallax",      6L, "qualitative", TRUE,
  "ggthemes",                   "excel_Parcel",      6L, "qualitative", TRUE,
  "ggthemes",               "excel_Retrospect",      6L, "qualitative", TRUE,
  "ggthemes",                    "excel_Savon",      6L, "qualitative", TRUE,
  "ggthemes",                    "excel_Slice",      6L, "qualitative", TRUE,
  "ggthemes",              "excel_Vapor_Trail",      6L, "qualitative", TRUE,
  "ggthemes",                     "excel_View",      6L, "qualitative", TRUE,
  "ggthemes",                     "excel_Wisp",      6L, "qualitative", TRUE,
  "ggthemes",                "excel_Wood_Type",      6L, "qualitative", TRUE,
  "ggthemes",                   "excel_Aspect",      6L, "qualitative", TRUE,
  "ggthemes",               "excel_Blue_Green",      6L, "qualitative", TRUE,
  "ggthemes",                  "excel_Blue_II",      6L, "qualitative", TRUE,
  "ggthemes",                "excel_Blue_Warm",      6L, "qualitative", TRUE,
  "ggthemes",                     "excel_Blue",      6L, "qualitative", TRUE,
  "ggthemes",                "excel_Grayscale",      6L, "sequential", FALSE,
  "ggthemes",             "excel_Green_Yellow",      6L, "qualitative", TRUE,
  "ggthemes",                    "excel_Green",      6L, "qualitative", TRUE,
  "ggthemes",                  "excel_Marquee",      6L, "qualitative", TRUE,
  "ggthemes",                   "excel_Median",      6L, "qualitative", TRUE,
  "ggthemes",         "excel_Office_2007_2010",      6L, "qualitative", TRUE,
  "ggthemes",               "excel_Orange_Red",      6L, "qualitative", TRUE,
  "ggthemes",                   "excel_Orange",      6L, "qualitative", TRUE,
  "ggthemes",                    "excel_Paper",      6L, "qualitative", TRUE,
  "ggthemes",               "excel_Red_Orange",      6L, "qualitative", TRUE,
  "ggthemes",               "excel_Red_Violet",      6L, "qualitative", TRUE,
  "ggthemes",                      "excel_Red",      6L, "qualitative", TRUE,
  "ggthemes",               "excel_Slipstream",      6L, "qualitative", TRUE,
  "ggthemes",                "excel_Violet_II",      6L, "qualitative", TRUE,
  "ggthemes",                   "excel_Violet",      6L, "qualitative", TRUE,
  "ggthemes",            "excel_Yellow_Orange",      6L, "qualitative", TRUE,
  "ggthemes",                   "excel_Yellow",      6L, "qualitative", TRUE,
  "ggthemes",                       "wsj_rgby",      4L, "qualitative", TRUE,
  "ggthemes",                  "wsj_red_green",      2L, "qualitative", TRUE,
  "ggthemes",                "wsj_black_green",      4L, "qualitative", TRUE,
  "ggthemes",                    "wsj_dem_rep",      3L, "qualitative", TRUE,
  "ggthemes",                    "wsj_colors6",      6L, "qualitative", TRUE,
  "ggthemes",                  "stata_s2color",     15L, "qualitative", TRUE,
  "ggthemes",                 "stata_s1rcolor",     15L, "qualitative", TRUE,
  "ggthemes",                  "stata_s1color",     15L, "qualitative", TRUE,
  "ggthemes",                     "stata_mono",     15L, "qualitative", TRUE,
  "ggthemes",                "stata_economist",     15L, "qualitative", TRUE,
  "ggthemes",                     "hc_default",     10L, "qualitative", TRUE,
  "ggthemes",                   "hc_darkunica",     11L, "qualitative", TRUE,
  "ggthemes",                          "hc_bg",      5L, "qualitative", TRUE,
  "ggthemes",                          "hc_fg",     12L, "qualitative", TRUE,
  "ggthemr",                           "flat",      9L, "qualitative", TRUE,
  "ggthemr",                      "flat_dark",      9L, "qualitative", TRUE,
  "ggthemr",                           "dust",      9L, "qualitative", TRUE,
  "ggthemr",                          "light",      9L, "qualitative", TRUE,
  "ggthemr",                          "earth",      9L, "qualitative", TRUE,
  "ggthemr",                          "fresh",      9L, "qualitative", TRUE,
  "ggthemr",                          "chalk",      7L, "qualitative", TRUE,
  "ggthemr",                          "lilac",     11L, "qualitative", TRUE,
  "ggthemr",                         "carrot",      9L, "qualitative", TRUE,
  "ggthemr",                           "pale",     10L, "qualitative", TRUE,
  "ggthemr",                         "copper",     11L, "qualitative", TRUE,
  "ggthemr",                          "grape",      9L, "qualitative", TRUE,
  "ggthemr",                      "greyscale",      9L, "qualitative", TRUE,
  "ggthemr",                            "sky",      6L, "qualitative", TRUE,
  "ggthemr",                      "solarized",      7L, "qualitative", TRUE,
  "ggthemr",                          "grass",      7L, "qualitative", TRUE,
  "ggthemr",                            "sea",     11L, "qualitative", TRUE,
  "ggthemr",                     "camouflage",      7L, "qualitative", TRUE,
  "ghibli",                   "MarnieLight1",      7L, "qualitative", TRUE,
  "ghibli",                  "MarnieMedium1",      7L, "qualitative", TRUE,
  "ghibli",                    "MarnieDark1",      7L, "qualitative", TRUE,
  "ghibli",                   "MarnieLight2",      7L, "qualitative", TRUE,
  "ghibli",                  "MarnieMedium2",      7L, "qualitative", TRUE,
  "ghibli",                    "MarnieDark2",      7L, "qualitative", TRUE,
  "ghibli",                     "PonyoLight",      7L, "qualitative", TRUE,
  "ghibli",                    "PonyoMedium",      7L, "qualitative", TRUE,
  "ghibli",                      "PonyoDark",      7L, "qualitative", TRUE,
  "ghibli",                    "LaputaLight",      7L, "qualitative", TRUE,
  "ghibli",                   "LaputaMedium",      7L, "qualitative", TRUE,
  "ghibli",                     "LaputaDark",      7L, "qualitative", TRUE,
  "ghibli",                  "MononokeLight",      7L, "qualitative", TRUE,
  "ghibli",                 "MononokeMedium",      7L, "qualitative", TRUE,
  "ghibli",                   "MononokeDark",      7L, "qualitative", TRUE,
  "ghibli",                  "SpiritedLight",      7L, "qualitative", TRUE,
  "ghibli",                 "SpiritedMedium",      7L, "qualitative", TRUE,
  "ghibli",                   "SpiritedDark",      7L, "qualitative", TRUE,
  "ghibli",                 "YesterdayLight",      7L, "qualitative", TRUE,
  "ghibli",                "YesterdayMedium",      7L, "qualitative", TRUE,
  "ghibli",                  "YesterdayDark",      7L, "qualitative", TRUE,
  "ghibli",                      "KikiLight",      7L, "qualitative", TRUE,
  "ghibli",                     "KikiMedium",      7L, "qualitative", TRUE,
  "ghibli",                       "KikiDark",      7L, "qualitative", TRUE,
  "ghibli",                    "TotoroLight",      7L, "qualitative", TRUE,
  "ghibli",                   "TotoroMedium",      7L, "qualitative", TRUE,
  "ghibli",                     "TotoroDark",      7L, "qualitative", TRUE,
  "grDevices",                         "blues9",      9L, "sequential", FALSE,
  "IslamicArt",                         "shiraz",     12L, "qualitative", TRUE,
  "IslamicArt",                      "samarqand",     12L, "qualitative", TRUE,
  "IslamicArt",                     "samarqand2",      4L, "qualitative", TRUE,
  "IslamicArt",                        "shiraz2",     12L, "qualitative", TRUE,
  "IslamicArt",                      "abu_dhabi",     13L, "qualitative", TRUE,
  "IslamicArt",                       "istanbul",      8L, "qualitative", TRUE,
  "IslamicArt",                      "istanbul2",     11L, "qualitative", TRUE,
  "IslamicArt",                      "istanbul3",      8L, "qualitative", TRUE,
  "IslamicArt",                          "konya",      8L, "qualitative", TRUE,
  "IslamicArt",                      "jerusalem",      9L, "qualitative", TRUE,
  "IslamicArt",                            "fes",      8L, "qualitative", TRUE,
  "IslamicArt",                           "fes2",      9L, "qualitative", TRUE,
  "IslamicArt",                       "alhambra",      6L, "qualitative", TRUE,
  "IslamicArt",                        "cordoba",      8L, "qualitative", TRUE,
  "IslamicArt",                       "damascus",      9L, "qualitative", TRUE,
  "IslamicArt",                        "ottoman",      5L, "qualitative", TRUE,
  "khroma",                           "broc",    256L, "divergent", FALSE,
  "khroma",                           "cork",    256L, "divergent", FALSE,
  "khroma",                            "vik",    256L, "divergent", FALSE,
  "khroma",                         "lisbon",    256L, "divergent", FALSE,
  "khroma",                         "tofino",    256L, "divergent", FALSE,
  "khroma",                         "berlin",    256L, "divergent", FALSE,
  "khroma",                           "roma",    256L, "divergent", FALSE,
  "khroma",                            "bam",    256L, "divergent", FALSE,
  "khroma",                         "vanimo",    256L, "divergent", FALSE,
  "khroma",                         "oleron",    256L, "divergent", FALSE,
  "khroma",                         "bukavu",    256L, "divergent", FALSE,
  "khroma",                            "fes",    256L, "divergent", FALSE,
  "khroma",                          "devon",    256L, "sequential", FALSE,
  "khroma",                        "lajolla",    256L, "sequential", FALSE,
  "khroma",                         "bamako",    256L, "sequential", FALSE,
  "khroma",                          "davos",    256L, "sequential", FALSE,
  "khroma",                         "bilbao",    256L, "sequential", FALSE,
  "khroma",                           "nuuk",    256L, "sequential", FALSE,
  "khroma",                           "oslo",    256L, "sequential", FALSE,
  "khroma",                          "grayC",    256L, "sequential", FALSE,
  "khroma",                         "hawaii",    256L, "sequential", FALSE,
  "khroma",                          "lapaz",    256L, "sequential", FALSE,
  "khroma",                          "tokyo",    256L, "sequential", FALSE,
  "khroma",                           "buda",    256L, "sequential", FALSE,
  "khroma",                          "acton",    256L, "sequential", FALSE,
  "khroma",                          "turku",    256L, "sequential", FALSE,
  "khroma",                          "imola",    256L, "sequential", FALSE,
  "khroma",                         "batlow",    256L, "sequential", FALSE,
  "khroma",                        "batlowW",    256L, "sequential", FALSE,
  "khroma",                        "batlowK",    256L, "sequential", FALSE,
  "khroma",                          "brocO",    256L, "divergent", FALSE,
  "khroma",                          "corkO",    256L, "divergent", FALSE,
  "khroma",                           "vikO",    256L, "divergent", FALSE,
  "khroma",                          "romaO",    256L, "divergent", FALSE,
  "khroma",                           "bamO",    256L, "divergent", FALSE,
  "khroma",                         "bright",      7L, "qualitative", FALSE,
  "khroma",                        "vibrant",      7L, "qualitative", FALSE,
  "khroma",                          "muted",      9L, "qualitative", FALSE,
  "khroma",                           "pale",      6L, "qualitative", FALSE,
  "khroma",                           "dark",      6L, "qualitative", FALSE,
  "khroma",                          "light",      9L, "qualitative", FALSE,
  "khroma",                         "sunset",     11L, "divergent", FALSE,
  "khroma",                           "BuRd",      9L, "divergent", FALSE,
  "khroma",                           "PRGn",      9L, "divergent", FALSE,
  "khroma",                         "YlOrBr",      9L, "sequential", FALSE,
  "khroma",                     "iridescent",     23L, "sequential", FALSE,
  "khroma",                "discreterainbow",     29L, "qualitative", FALSE,
  "khroma",                  "smoothrainbow",     34L, "sequential", FALSE,
  "khroma",                       "okabeito",      8L, "qualitative", FALSE,
  "khroma",                   "stratigraphy",    175L, "qualitative", FALSE,
  "khroma",                           "soil",     24L, "qualitative", FALSE,
  "khroma",                           "land",     14L, "qualitative", FALSE,
  "khroma",                   "highcontrast",      3L, "qualitative", FALSE,
  "khroma",                 "mediumcontrast",      6L, "qualitative", FALSE,
  "khroma",                      "nightfall",     17L, "qualitative", FALSE,
  "khroma",                   "incandescent",     11L, "qualitative", FALSE,
  "khroma",                  "okabeitoblack",      8L, "qualitative", FALSE,
  "jcolors",                        "default",      5L, "qualitative", TRUE,
  "jcolors",                           "pal2",      5L, "qualitative", TRUE,
  "jcolors",                           "pal3",      5L, "qualitative", TRUE,
  "jcolors",                           "pal4",      6L, "qualitative", TRUE,
  "jcolors",                           "pal5",      6L, "qualitative", TRUE,
  "jcolors",                           "pal6",      8L, "qualitative", TRUE,
  "jcolors",                           "pal7",      8L, "qualitative", TRUE,
  "jcolors",                           "pal8",     12L, "qualitative", TRUE,
  "jcolors",                           "pal9",      6L, "qualitative", TRUE,
  "jcolors",                          "pal10",     10L, "sequential", TRUE,
  "jcolors",                          "pal11",     12L, "sequential", TRUE,
  "jcolors",                          "pal12",     13L, "sequential", TRUE,
  "jcolors",                        "rainbow",      9L, "qualitative", TRUE,
  "LaCroixColoR",                   "PassionFruit",      6L, "qualitative", TRUE,
  "LaCroixColoR",                          "Mango",      6L, "qualitative", TRUE,
  "LaCroixColoR",                           "Pure",      6L, "qualitative", TRUE,
  "LaCroixColoR",                           "Lime",      6L, "divergent", TRUE,
  "LaCroixColoR",                          "Lemon",      6L, "divergent", TRUE,
  "LaCroixColoR",                         "Orange",      6L, "divergent", TRUE,
  "LaCroixColoR",                          "Berry",      6L, "divergent", TRUE,
  "LaCroixColoR",                  "CranRaspberry",      6L, "divergent", TRUE,
  "LaCroixColoR",                   "Pamplemousse",      6L, "divergent", TRUE,
  "LaCroixColoR",                      "PeachPear",      6L, "divergent", TRUE,
  "LaCroixColoR",                        "Coconut",      6L, "divergent", TRUE,
  "LaCroixColoR",                        "Apricot",      6L, "qualitative", TRUE,
  "LaCroixColoR",                      "Tangerine",      7L, "qualitative", TRUE,
  "LaCroixColoR",                        "KeyLime",      5L, "qualitative", TRUE,
  "LaCroixColoR",                      "PommeBaya",      5L, "qualitative", TRUE,
  "LaCroixColoR",                    "CeriseLimon",      6L, "qualitative", TRUE,
  "LaCroixColoR",                     "PinaFraise",      6L, "qualitative", TRUE,
  "LaCroixColoR",                     "KiwiSandia",      7L, "qualitative", TRUE,
  "LaCroixColoR",                    "MelonPomelo",      6L, "qualitative", TRUE,
  "LaCroixColoR",                     "MurePepino",      6L, "qualitative", TRUE,
  "LaCroixColoR",                         "paired",     14L, "qualitative", TRUE,
  "impressionist.colors", "les_nympheas", 15L, "qualitative", TRUE,
  "impressionist.colors", "les_nympheas_2", 15L, "qualitative", TRUE,
  "impressionist.colors", "les_peupliers", 16L, "qualitative",  TRUE,
  "impressionist.colors", "le_dejeuner_des_canotiers", 13L,  "qualitative", TRUE,
  "impressionist.colors", "pres_du_lac", 11L, "qualitative", TRUE,
  "impressionist.colors", "la_yole", 14L, "qualitative", TRUE,
  "impressionist.colors", "dans_la_serre", 13L, "qualitative", TRUE,
  "impressionist.colors", "melon_et_peches", 10L, "qualitative", TRUE,
  "impressionist.colors", "fleurs_dans_un_vase_de_cristal", 14L, "qualitative", TRUE,
  "impressionist.colors", "danseuses_a_la_barre", 12L, "qualitative", TRUE,
  "impressionist.colors", "chanteuse_de_cafe_concert", 12L, "qualitative", TRUE,
  "impressionist.colors", "la_chanson_du_chien", 10L, "qualitative", TRUE,
  "impressionist.colors", "la_recolte_des_foins_eragny", 12L, "qualitative", TRUE,
  "impressionist.colors", "paysage_tropical_avec_masureset_palmiers", 11L, "qualitative", TRUE,
  "impressionist.colors", "lestaque_aux_toits_rouges", 13L, "qualitative", TRUE,
  "impressionist.colors", "bouilloire_et_fruits", 9L, "qualitative", TRUE,
  "impressionist.colors", "korenveld_onder_onweerslucht", 14L, "qualitative", TRUE,
  "impressionist.colors", "irissen", 14L, "qualitative", TRUE,
  "impressionist.colors", "de_slaapkamer", 13L, "qualitative", TRUE,
  "impressionist.colors", "te_aa_no_areois", 14L, "qualitative", TRUE,
  "impressionist.colors", "la_sieste", 16L, "qualitative", TRUE,
  "impressionist.colors", "vahine_no_te_tiare", 15L, "qualitative",  TRUE,
  "impressionist.colors", "les_terrassiers", 13L, "qualitative",  TRUE,
  "impressionist.colors", "un_dimanche_apres_midi_a_l_ile_de_la_grande_jatte",  16L, "qualitative", TRUE,
  "lisa",                    "JosefAlbers",      5L, "qualitative", TRUE,
  "lisa",                  "JosefAlbers_1",      5L, "qualitative", TRUE,
  "lisa",               "GretchenAlbrecht",      5L, "qualitative", TRUE,
  "lisa",                     "BillyApple",      5L, "qualitative", TRUE,
  "lisa",                     "PerArnoldi",      5L, "qualitative", TRUE,
  "lisa",                    "MiltonAvery",      5L, "qualitative", TRUE,
  "lisa",                  "MiltonAvery_1",      5L, "qualitative", TRUE,
  "lisa",                   "HilmaafKlint",      5L, "qualitative", TRUE,
  "lisa",            "Jean_MichelBasquiat",      5L, "qualitative", TRUE,
  "lisa",          "Jean_MichelBasquiat_1",      5L, "qualitative", TRUE,
  "lisa",                    "MaxBeckmann",      5L, "qualitative", TRUE,
  "lisa",                 "FernandoBotero",      5L, "qualitative", TRUE,
  "lisa",               "SandroBotticelli",      5L, "qualitative", TRUE,
  "lisa",             "SandroBotticelli_1",      5L, "qualitative", TRUE,
  "lisa",                  "PieterBruegel",      5L, "qualitative", TRUE,
  "lisa",                       "JackBush",      5L, "qualitative", TRUE,
  "lisa",                     "JackBush_1",      5L, "qualitative", TRUE,
  "lisa",                    "MaryCassatt",      5L, "qualitative", TRUE,
  "lisa",                    "PaulCezanne",      5L, "qualitative", TRUE,
  "lisa",                    "MarcChagall",      5L, "qualitative", TRUE,
  "lisa",                   "C_M_Coolidge",      5L, "divergent", TRUE,
  "lisa",                   "SalvadorDali",      5L, "qualitative", TRUE,
  "lisa",                 "SalvadorDali_1",      5L, "qualitative", TRUE,
  "lisa",                "LeonardodaVinci",      5L, "qualitative", TRUE,
  "lisa",                      "GeneDavis",      5L, "qualitative", TRUE,
  "lisa",               "GiorgiodeChirico",      5L, "qualitative", TRUE,
  "lisa",             "GiorgiodeChirico_1",      5L, "qualitative", TRUE,
  "lisa",                     "EdgarDegas",      5L, "qualitative", TRUE,
  "lisa",                 "RobertDelaunay",      5L, "qualitative", TRUE,
  "lisa",               "RobertDelaunay_1",      5L, "qualitative", TRUE,
  "lisa",                  "CharlesDemuth",      5L, "qualitative", TRUE,
  "lisa",              "RichardDiebenkorn",      5L, "qualitative", TRUE,
  "lisa",                        "OttoDix",      5L, "qualitative", TRUE,
  "lisa",                      "OttoDix_1",      5L, "qualitative", TRUE,
  "lisa",                  "MarcelDuchamp",      5L, "qualitative", TRUE,
  "lisa",                  "AlbrechtDurer",      5L, "qualitative", TRUE,
  "lisa",                       "MaxErnst",      5L, "qualitative", TRUE,
  "lisa",                     "M_C_Escher",      5L, "qualitative", TRUE,
  "lisa",                     "PaulFeeley",      5L, "qualitative", TRUE,
  "lisa",                "LorserFeitelson",      5L, "qualitative", TRUE,
  "lisa",             "HelenFrankenthaler",      5L, "qualitative", TRUE,
  "lisa",                    "LucianFreud",      5L, "qualitative", TRUE,
  "lisa",                     "TerryFrost",      5L, "qualitative", TRUE,
  "lisa",                    "PaulGauguin",      5L, "qualitative", TRUE,
  "lisa",                "RupprechtGeiger",      5L, "qualitative", TRUE,
  "lisa",                    "HansHofmann",      5L, "qualitative", TRUE,
  "lisa",              "KatsushikaHokusai",      5L, "qualitative", TRUE,
  "lisa",                   "WinslowHomer",      5L, "qualitative", TRUE,
  "lisa",                   "EdwardHopper",      5L, "qualitative", TRUE,
  "lisa",                  "RobertIndiana",      5L, "qualitative", TRUE,
  "lisa",                      "JamesJean",      5L, "qualitative", TRUE,
  "lisa",                    "JasperJohns",      5L, "qualitative", TRUE,
  "lisa",                     "FridaKahlo",      5L, "divergent", TRUE,
  "lisa",               "WassilyKandinsky",      5L, "qualitative", TRUE,
  "lisa",             "WassilyKandinsky_1",      5L, "qualitative", TRUE,
  "lisa",             "WassilyKandinsky_2",      5L, "qualitative", TRUE,
  "lisa",                       "PaulKlee",      5L, "qualitative", TRUE,
  "lisa",                     "PaulKlee_1",      5L, "qualitative", TRUE,
  "lisa",                      "YvesKlein",      5L, "qualitative", TRUE,
  "lisa",                    "GustavKlimt",      5L, "qualitative", TRUE,
  "lisa",                      "JeffKoons",      5L, "qualitative", TRUE,
  "lisa",                     "LeeKrasner",      5L, "qualitative", TRUE,
  "lisa",                  "JacobLawrence",      5L, "qualitative", TRUE,
  "lisa",                "JacobLawrence_1",      5L, "qualitative", TRUE,
  "lisa",                      "SolLeWitt",      5L, "qualitative", TRUE,
  "lisa",                "RoyLichtenstein",      5L, "qualitative", TRUE,
  "lisa",              "RoyLichtenstein_1",      5L, "qualitative", TRUE,
  "lisa",              "RoyLichtenstein_2",      5L, "qualitative", TRUE,
  "lisa",                "KazimirMalevich",      5L, "qualitative", TRUE,
  "lisa",                   "EdouardManet",      5L, "qualitative", TRUE,
  "lisa",                   "ReneMagritte",      5L, "qualitative", TRUE,
  "lisa",                 "ReneMagritte_1",      5L, "qualitative", TRUE,
  "lisa",                       "Masaccio",      5L, "qualitative", TRUE,
  "lisa",                   "Michelangelo",      5L, "qualitative", TRUE,
  "lisa",                       "JoanMiro",      5L, "qualitative", TRUE,
  "lisa",               "AmedeoModigliani",      5L, "qualitative", TRUE,
  "lisa",                   "PietMondrian",      5L, "qualitative", TRUE,
  "lisa",                    "ClaudeMonet",      5L, "qualitative", TRUE,
  "lisa",                  "ClaudeMonet_1",      5L, "qualitative", TRUE,
  "lisa",                  "ClaudeMonet_2",      5L, "qualitative", TRUE,
  "lisa",                    "EdvardMunch",      5L, "qualitative", TRUE,
  "lisa",                  "EdvardMunch_1",      5L, "qualitative", TRUE,
  "lisa",                  "BarnettNewman",      5L, "qualitative", TRUE,
  "lisa",                  "KennethNoland",      5L, "qualitative", TRUE,
  "lisa",                 "GeorgiaOKeeffe",      5L, "sequential", TRUE,
  "lisa",                 "ClaesOldenburg",      5L, "qualitative", TRUE,
  "lisa",                   "PabloPicasso",      5L, "qualitative", TRUE,
  "lisa",                 "PabloPicasso_1",      5L, "qualitative", TRUE,
  "lisa",                 "JacksonPollock",      5L, "qualitative", TRUE,
  "lisa",                         "Prince",      5L, "sequential", TRUE,
  "lisa",                     "JohnQuidor",      5L, "qualitative", TRUE,
  "lisa",                       "MelRamos",      5L, "qualitative", TRUE,
  "lisa",                    "OdilonRedon",      5L, "qualitative", TRUE,
  "lisa",                      "Rembrandt",      5L, "qualitative", TRUE,
  "lisa",           "Pierre_AugusteRenoir",      5L, "qualitative", TRUE,
  "lisa",         "Pierre_AugusteRenoir_1",      5L, "qualitative", TRUE,
  "lisa",                   "BridgetRiley",      5L, "qualitative", TRUE,
  "lisa",                "JamesRosenquist",      5L, "qualitative", TRUE,
  "lisa",                     "MarkRothko",      5L, "sequential", TRUE,
  "lisa",                   "MarkRothko_1",      5L, "qualitative", TRUE,
  "lisa",              "JohnSingerSargent",      5L, "qualitative", TRUE,
  "lisa",            "JohnSingerSargent_1",      5L, "qualitative", TRUE,
  "lisa",            "JohnSingerSargent_2",      5L, "qualitative", TRUE,
  "lisa",                 "OskarSchlemmer",      5L, "divergent", TRUE,
  "lisa",                  "GeorgesSeurat",      5L, "qualitative", TRUE,
  "lisa",                  "SandySkoglund",      5L, "qualitative", TRUE,
  "lisa",               "PavelTchelitchew",      5L, "qualitative", TRUE,
  "lisa",                   "J_M_W_Turner",      5L, "qualitative", TRUE,
  "lisa",                      "CyTwombly",      5L, "qualitative", TRUE,
  "lisa",              "JohannJacobUlrich",      5L, "sequential", TRUE,
  "lisa",                "TheovanDoesburg",      5L, "qualitative", TRUE,
  "lisa",              "TheovanDoesburg_1",      5L, "qualitative", TRUE,
  "lisa",                     "JanvanEyck",      5L, "qualitative", TRUE,
  "lisa",                 "VincentvanGogh",      5L, "qualitative", TRUE,
  "lisa",               "VincentvanGogh_1",      5L, "qualitative", TRUE,
  "lisa",               "VincentvanGogh_2",      5L, "qualitative", TRUE,
  "lisa",                   "RemediosVaro",      5L, "qualitative", TRUE,
  "lisa",                 "DiegoVelazquez",      5L, "qualitative", TRUE,
  "lisa",                "JohannesVermeer",      5L, "qualitative", TRUE,
  "lisa",              "JohannesVermeer_1",      5L, "qualitative", TRUE,
  "lisa",                     "AndyWarhol",      5L, "qualitative", TRUE,
  "lisa",                   "AndyWarhol_1",      5L, "qualitative", TRUE,
  "lisa",                   "AndyWarhol_2",      5L, "qualitative", TRUE,
  "lisa",                   "AndyWarhol_3",      5L, "qualitative", TRUE,
  "lisa",                      "GrantWood",      5L, "qualitative", TRUE,
  "lisa",                 "FrancescoXanto",      5L, "qualitative", TRUE,
  "lisa",                 "JackYoungerman",      5L, "qualitative", TRUE,
  "lisa",                      "KarlZerbe",      5L, "qualitative", TRUE,
  "ltc",                      "paloma",      5L, "qualitative", TRUE,
  "ltc",                        "maya",      5L, "qualitative", TRUE,
  "ltc",                        "dora",      5L, "qualitative", TRUE,
  "ltc",                       "ploen",      5L, "qualitative", TRUE,
  "ltc",                        "olga",      5L, "qualitative", TRUE,
  "ltc",                     "mterese",      5L, "qualitative", TRUE,
  "ltc",                        "gaby",      5L, "qualitative", TRUE,
  "ltc",                  "franscoise",      5L, "qualitative", TRUE,
  "ltc",                    "fernande",      4L, "qualitative", TRUE,
  "ltc",                      "sylvie",      5L, "qualitative", TRUE,
  "ltc",                     "crbhits",      9L, "qualitative", TRUE,
  "ltc",                      "expevo",      6L, "qualitative", TRUE,
  "ltc",                       "minou",      6L, "qualitative", TRUE,
  "ltc",                        "kiss",      5L, "qualitative", TRUE,
  "ltc",                         "hat",     10L, "qualitative", TRUE,
  "ltc",                     "reading",      8L, "qualitative", TRUE,
  "ltc",                  "ten_colors",     10L, "qualitative", TRUE,
  "ltc",                       "alger",      5L, "qualitative", TRUE,
  "ltc",                       "trio1",      3L, "qualitative", TRUE,
  "ltc",                       "trio2",      3L, "qualitative", TRUE,
  "ltc",                       "trio3",      3L, "qualitative", TRUE,
  "ltc",                       "trio4",      3L, "qualitative", TRUE,
  "ltc",                     "heatmap",      9L, "qualitative", TRUE,
  "ltc",                   "pantone23",      5L, "qualitative", TRUE,
  "MetBrewer",               "Archambault",  7L,     "qualitative", TRUE,
  "MetBrewer",                   "Austria",  7L,     "qualitative", TRUE,
  "MetBrewer",                "Benedictus", 13L,     "qualitative", TRUE,
  "MetBrewer",                  "Cassatt1",  8L,     "qualitative", TRUE,
  "MetBrewer",                  "Cassatt2", 10L,     "qualitative", TRUE,
  "MetBrewer",                     "Cross",  9L,     "qualitative", TRUE,
  "MetBrewer",                     "Degas",  7L,     "qualitative", TRUE,
  "MetBrewer",                    "Demuth", 10L,     "qualitative", TRUE,
  "MetBrewer",                    "Derain",  7L,     "qualitative", TRUE,
  "MetBrewer",                     "Egypt",  4L,     "qualitative", TRUE,
  "MetBrewer",                   "Gauguin",  6L,     "qualitative", TRUE,
  "MetBrewer",                     "Greek",  5L,     "qualitative", TRUE,
  "MetBrewer",                 "Hiroshige", 10L,     "qualitative", TRUE,
  "MetBrewer",                  "Hokusai1",  7L,     "qualitative", TRUE,
  "MetBrewer",                  "Hokusai2",  6L,     "qualitative", TRUE,
  "MetBrewer",                  "Hokusai3",  6L,     "qualitative", TRUE,
  "MetBrewer",                    "Homer1",  8L,     "qualitative", TRUE,
  "MetBrewer",                    "Homer2",  6L,     "qualitative", TRUE,
  "MetBrewer",                    "Ingres",  8L,     "qualitative", TRUE,
  "MetBrewer",                  "Isfahan1",  8L,     "qualitative", TRUE,
  "MetBrewer",                  "Isfahan2",  5L,     "qualitative", TRUE,
  "MetBrewer",                      "Java",  5L,     "qualitative", TRUE,
  "MetBrewer",                   "Johnson",  5L,     "qualitative", TRUE,
  "MetBrewer",                    "Juarez",  6L,     "qualitative", TRUE,
  "MetBrewer",                 "Kandinsky",  4L,     "qualitative", TRUE,
  "MetBrewer",                     "Klimt",  6L,     "qualitative", TRUE,
  "MetBrewer",                    "Lakota",  6L,     "qualitative", TRUE,
  "MetBrewer",                     "Manet", 11L,     "qualitative", TRUE,
  "MetBrewer",                     "Monet",  9L,     "qualitative", TRUE,
  "MetBrewer",                    "Moreau",  7L,     "qualitative", TRUE,
  "MetBrewer",               "Morgenstern",  8L,     "qualitative", TRUE,
  "MetBrewer",                   "Nattier",  7L,     "qualitative", TRUE,
  "MetBrewer",                    "Navajo",  5L,     "qualitative", TRUE,
  "MetBrewer",                "NewKingdom",  5L,     "qualitative", TRUE,
  "MetBrewer",                    "Nizami",  8L,     "qualitative", TRUE,
  "MetBrewer",                  "OKeeffe1", 11L,     "qualitative", TRUE,
  "MetBrewer",                  "OKeeffe2",  7L,     "qualitative", TRUE,
  "MetBrewer",                    "Paquin", 11L,     "qualitative", TRUE,
  "MetBrewer",                     "Peru1",  6L,     "qualitative", TRUE,
  "MetBrewer",                     "Peru2",  6L,     "qualitative", TRUE,
  "MetBrewer",                 "Pillement",  6L,     "qualitative", TRUE,
  "MetBrewer",                   "Pissaro",  7L,     "qualitative", TRUE,
  "MetBrewer",                     "Redon", 12L,     "qualitative", TRUE,
  "MetBrewer",                    "Renoir", 12L,     "qualitative", TRUE,
  "MetBrewer",                    "Signac", 14L,     "qualitative", TRUE,
  "MetBrewer",                       "Tam",  8L,     "qualitative", TRUE,
  "MetBrewer",                      "Tara",  5L,     "qualitative", TRUE,
  "MetBrewer",                    "Thomas",  8L,     "qualitative", TRUE,
  "MetBrewer",                   "Tiepolo",  8L,     "qualitative", TRUE,
  "MetBrewer",                      "Troy",  8L,     "qualitative", TRUE,
  "MetBrewer",                 "Tsimshian",  7L,     "qualitative", TRUE,
  "MetBrewer",                  "VanGogh1",  7L,     "qualitative", TRUE,
  "MetBrewer",                  "VanGogh2",  8L,     "qualitative", TRUE,
  "MetBrewer",                  "VanGogh3",  8L,     "qualitative", TRUE,
  "MetBrewer",                  "Veronese",  7L,     "qualitative", TRUE,
  "MetBrewer",                   "Wissing",  5L,     "qualitative", TRUE,
  "MexBrewer",             "Alacena",  10L,       "divergent", TRUE,
  "MexBrewer",            "Atentado",  10L,     "qualitative", TRUE,
  "MexBrewer",              "Aurora",   7L,      "sequential", TRUE,
  "MexBrewer",             "Casita1",   5L,     "qualitative", TRUE,
  "MexBrewer",             "Casita2",   5L,     "qualitative", TRUE,
  "MexBrewer",             "Casita3",   5L,     "qualitative", TRUE,
  "MexBrewer",              "Concha",   7L,      "sequential", TRUE,
  "MexBrewer",               "Frida",   7L,      "sequential", TRUE,
  "MexBrewer",               "Huida",  10L,       "divergent", TRUE,
  "MexBrewer",                "Maiz",  10L,       "divergent", TRUE,
  "MexBrewer",          "Naturaleza",   7L,      "sequential", TRUE,
  "MexBrewer",             "Ofrenda",  10L,       "divergent", TRUE,
  "MexBrewer",          "Revolucion",  10L,       "divergent", TRUE,
  "MexBrewer",               "Ronda",  10L,       "divergent", TRUE,
  "MexBrewer",             "Taurus1",   7L,      "sequential", TRUE,
  "MexBrewer",             "Taurus2",   7L,      "sequential", TRUE,
  "MexBrewer",              "Tierra",   7L,      "sequential", TRUE,
  "MexBrewer",           "Vendedora",  10L,       "divergent", TRUE,
  "musculusColors",              "Bmlunge",  6L,     "qualitative", TRUE,
  "musculusColors",            "Bmsurface",  6L,     "qualitative", TRUE,
  "musculusColors",               "Bmpoop",  5L,     "qualitative", TRUE,
  "musculusColors",              "ErFluke",  5L,     "qualitative", TRUE,
  "musculusColors",               "ErHead",  5L,     "qualitative", TRUE,
  "musculusColors",               "ErMole",  5L,     "qualitative", TRUE,
  "musculusColors",              "ErWhale",  5L,     "qualitative", TRUE,
  "nationalparkcolors",                 "SmokyMountains",      6L, "qualitative", TRUE,
  "nationalparkcolors",                 "RockyMountains",      5L, "qualitative", TRUE,
  "nationalparkcolors",                    "Yellowstone",      6L, "qualitative", TRUE,
  "nationalparkcolors",                         "Arches",      6L, "qualitative", TRUE,
  "nationalparkcolors",                    "ArcticGates",      6L, "qualitative", TRUE,
  "nationalparkcolors",                     "MtMckinley",      6L, "qualitative", TRUE,
  "nationalparkcolors",                   "GeneralGrant",      8L, "qualitative", TRUE,
  "nationalparkcolors",                         "Hawaii",      5L, "qualitative", TRUE,
  "nationalparkcolors",                     "CraterLake",      7L, "qualitative", TRUE,
  "nationalparkcolors",                        "Saguaro",      6L, "qualitative", TRUE,
  "nationalparkcolors",                     "GrandTeton",      5L, "qualitative", TRUE,
  "nationalparkcolors",                    "BryceCanyon",      5L, "qualitative", TRUE,
  "nationalparkcolors",                      "MtRainier",      5L, "qualitative", TRUE,
  "nationalparkcolors",                       "Badlands",      5L, "qualitative", TRUE,
  "nationalparkcolors",                       "Redwoods",      5L, "qualitative", TRUE,
  "nationalparkcolors",                     "Everglades",      5L, "qualitative", TRUE,
  "nationalparkcolors",                      "Voyageurs",      5L, "qualitative", TRUE,
  "nationalparkcolors",                  "BlueRidgePkwy",      6L, "qualitative", TRUE,
  "nationalparkcolors",                         "Denali",      5L, "qualitative", TRUE,
  "nationalparkcolors",                     "GreatBasin",      6L, "qualitative", TRUE,
  "nationalparkcolors",                 "ChannelIslands",      6L, "qualitative", TRUE,
  "nationalparkcolors",                       "Yosemite",      5L, "qualitative", TRUE,
  "nationalparkcolors",                         "Acadia",      6L, "qualitative", TRUE,
  "nationalparkcolors",                    "DeathValley",      6L, "qualitative", TRUE,
  "nationalparkcolors",                           "Zion",      5L, "qualitative", TRUE,
  "NatParksPalettes",                           "Acadia",      9L, "qualitative", TRUE,
  "NatParksPalettes",                           "Arches",      9L, "qualitative", TRUE,
  "NatParksPalettes",                          "Arches2",      5L, "qualitative", TRUE,
  "NatParksPalettes",                            "Banff",      7L, "qualitative", TRUE,
  "NatParksPalettes",                      "BryceCanyon",      7L, "qualitative", TRUE,
  "NatParksPalettes",                      "CapitolReef",      6L, "qualitative", TRUE,
  "NatParksPalettes",                        "Charmonix",      6L, "qualitative", TRUE,
  "NatParksPalettes",                       "CraterLake",      7L, "qualitative", TRUE,
  "NatParksPalettes",                         "Cuyahoga",      6L, "qualitative", TRUE,
  "NatParksPalettes",                      "DeathValley",      7L, "qualitative", TRUE,
  "NatParksPalettes",                           "Denali",      6L, "qualitative", TRUE,
  "NatParksPalettes",                       "Everglades",      6L, "qualitative", TRUE,
  "NatParksPalettes",                          "Glacier",      5L, "qualitative", TRUE,
  "NatParksPalettes",                      "GrandCanyon",      7L, "qualitative", TRUE,
  "NatParksPalettes",                         "Halekala",      5L, "qualitative", TRUE,
  "NatParksPalettes",                      "IguazuFalls",      6L, "qualitative", TRUE,
  "NatParksPalettes",                      "KingsCanyon",      6L, "qualitative", TRUE,
  "NatParksPalettes",                       "LakeNakuru",      6L, "qualitative", TRUE,
  "NatParksPalettes",                          "Olympic",      9L, "qualitative", TRUE,
  "NatParksPalettes",                          "Redwood",      6L, "qualitative", TRUE,
  "NatParksPalettes",                         "RockyMtn",      7L, "qualitative", TRUE,
  "NatParksPalettes",                          "Saguaro",      6L, "qualitative", TRUE,
  "NatParksPalettes",                        "SmokyMtns",      7L, "qualitative", TRUE,
  "NatParksPalettes",                       "SouthDowns",      6L, "qualitative", TRUE,
  "NatParksPalettes",                           "Torres",     10L, "qualitative", TRUE,
  "NatParksPalettes",                          "Triglav",      6L, "qualitative", TRUE,
  "NatParksPalettes",                         "WindCave",      5L, "qualitative", TRUE,
  "NatParksPalettes",                        "Volcanoes",      5L, "qualitative", TRUE,
  "NatParksPalettes",                      "Yellowstone",      6L, "qualitative", TRUE,
  "NatParksPalettes",                          "Yosemite",     6L, "qualitative", TRUE,
  "nbapalettes",                        "bobcats",      5L, "qualitative", TRUE,
  "nbapalettes",               "bobcats_original",      4L, "qualitative", TRUE,
  "nbapalettes",                        "blazers",      3L, "qualitative", TRUE,
  "nbapalettes",              "blazers_statement",      3L, "qualitative", TRUE,
  "nbapalettes",                   "blazers_city",      5L, "qualitative", TRUE,
  "nbapalettes",                  "blazers_city2",      4L, "qualitative", TRUE,
  "nbapalettes",                          "bucks",      4L, "qualitative", TRUE,
  "nbapalettes",                   "bucks_earned",      6L, "qualitative", TRUE,
  "nbapalettes",                      "bucks_00s",      3L, "qualitative", TRUE,
  "nbapalettes",                    "bucks_retro",      5L, "qualitative", TRUE,
  "nbapalettes",                     "bucks_city",      4L, "qualitative", TRUE,
  "nbapalettes",                    "bucks_city2",      6L, "qualitative", TRUE,
  "nbapalettes",                          "bulls",      2L, "qualitative", TRUE,
  "nbapalettes",                     "bulls_city",      3L, "qualitative", TRUE,
  "nbapalettes",                    "bulls_city2",      3L, "qualitative", TRUE,
  "nbapalettes",                  "bulls_holiday",      3L, "qualitative", TRUE,
  "nbapalettes",                      "cavaliers",      4L, "qualitative", TRUE,
  "nbapalettes",                  "cavaliers_90s",      3L, "qualitative", TRUE,
  "nbapalettes",                "cavaliers_retro",      2L, "qualitative", TRUE,
  "nbapalettes",                        "celtics",      3L, "qualitative", TRUE,
  "nbapalettes",                       "celtics2",      5L, "qualitative", TRUE,
  "nbapalettes",                 "celtics_europe",      3L, "qualitative", TRUE,
  "nbapalettes",                  "celtics_champ",      4L, "qualitative", TRUE,
  "nbapalettes",                       "clippers",      4L, "qualitative", TRUE,
  "nbapalettes",                  "clippers_city",      5L, "qualitative", TRUE,
  "nbapalettes",                 "clippers_retro",      3L, "qualitative", TRUE,
  "nbapalettes",              "clippers_original",      4L, "qualitative", TRUE,
  "nbapalettes",                      "grizzlies",      5L, "qualitative", TRUE,
  "nbapalettes",                  "grizzlies_00s",      4L, "qualitative", TRUE,
  "nbapalettes",                "grizzlies_retro",      4L, "qualitative", TRUE,
  "nbapalettes",               "grizzlies_europe",      5L, "qualitative", TRUE,
  "nbapalettes",                          "hawks",      4L, "qualitative", TRUE,
  "nbapalettes",                "hawks_statement",      3L, "qualitative", TRUE,
  "nbapalettes",                      "hawks_90s",      4L, "qualitative", TRUE,
  "nbapalettes",                    "hawks_retro",      3L, "qualitative", TRUE,
  "nbapalettes",                           "heat",      3L, "qualitative", TRUE,
  "nbapalettes",                       "heat_90s",      3L, "qualitative", TRUE,
  "nbapalettes",                      "heat_vice",      3L, "qualitative", TRUE,
  "nbapalettes",                      "heat_dark",      4L, "qualitative", TRUE,
  "nbapalettes",                      "heat_0506",      3L, "qualitative", TRUE,
  "nbapalettes",                  "heat_military",      5L, "qualitative", TRUE,
  "nbapalettes",                        "hornets",      3L, "qualitative", TRUE,
  "nbapalettes",                       "hornets2",      4L, "qualitative", TRUE,
  "nbapalettes",                "hornets_classic",      6L, "qualitative", TRUE,
  "nbapalettes",                   "hornets_city",      3L, "qualitative", TRUE,
  "nbapalettes",                  "hornets_city2",      4L, "qualitative", TRUE,
  "nbapalettes",                        "huskies",      2L, "qualitative", TRUE,
  "nbapalettes",                           "jazz",      3L, "qualitative", TRUE,
  "nbapalettes",                      "jazz_city",      9L, "sequential", TRUE,
  "nbapalettes",                   "jazz_classic",      5L, "qualitative", TRUE,
  "nbapalettes",                     "jazz_retro",      5L, "qualitative", TRUE,
  "nbapalettes",                          "kings",      3L, "qualitative", TRUE,
  "nbapalettes",                     "kings_city",      4L, "qualitative", TRUE,
  "nbapalettes",                      "kings_alt",      5L, "qualitative", TRUE,
  "nbapalettes",                     "kings_alt2",      3L, "qualitative", TRUE,
  "nbapalettes",                         "knicks",      3L, "qualitative", TRUE,
  "nbapalettes",                   "knicks_retro",      3L, "qualitative", TRUE,
  "nbapalettes",                    "knicks_city",      4L, "qualitative", TRUE,
  "nbapalettes",                   "knicks_city2",      4L, "qualitative", TRUE,
  "nbapalettes",                 "knicks_holiday",      5L, "qualitative", TRUE,
  "nbapalettes",                         "lakers",      3L, "qualitative", TRUE,
  "nbapalettes",                    "lakers_city",      4L, "qualitative", TRUE,
  "nbapalettes",                     "lakers_alt",      3L, "qualitative", TRUE,
  "nbapalettes",                          "magic",      3L, "qualitative", TRUE,
  "nbapalettes",                     "magic_city",      3L, "qualitative", TRUE,
  "nbapalettes",                    "magic_city2",      5L, "qualitative", TRUE,
  "nbapalettes",                      "mavericks",      4L, "qualitative", TRUE,
  "nbapalettes",                  "mavericks_alt",      5L, "qualitative", TRUE,
  "nbapalettes",                 "mavericks_city",      4L, "qualitative", TRUE,
  "nbapalettes",                "mavericks_retro",      3L, "qualitative", TRUE,
  "nbapalettes",               "mavericks_banner",      5L, "qualitative", TRUE,
  "nbapalettes",                           "nets",      2L, "qualitative", TRUE,
  "nbapalettes",                      "nets_city",      5L, "qualitative", TRUE,
  "nbapalettes",                "hornets_believe",      6L, "qualitative", TRUE,
  "nbapalettes",                        "nuggets",      4L, "qualitative", TRUE,
  "nbapalettes",                    "nuggets_80s",      7L, "qualitative", TRUE,
  "nbapalettes",              "nuggets_statement",      4L, "qualitative", TRUE,
  "nbapalettes",                   "nuggets_city",      5L, "qualitative", TRUE,
  "nbapalettes",                  "nuggets_city2",      7L, "qualitative", TRUE,
  "nbapalettes",                         "pacers",      3L, "qualitative", TRUE,
  "nbapalettes",                 "pacers_classic",      2L, "qualitative", TRUE,
  "nbapalettes",                   "pacers_venue",      4L, "qualitative", TRUE,
  "nbapalettes",              "pacers_foundation",      4L, "qualitative", TRUE,
  "nbapalettes",                       "pelicans",      3L, "qualitative", TRUE,
  "nbapalettes",                  "pelicans_city",      4L, "qualitative", TRUE,
  "nbapalettes",                 "pelicans_pride",      4L, "qualitative", TRUE,
  "nbapalettes",                        "pistons",      4L, "qualitative", TRUE,
  "nbapalettes",                    "pistons_90s",      5L, "qualitative", TRUE,
  "nbapalettes",                   "pistons_city",      4L, "qualitative", TRUE,
  "nbapalettes",                        "raptors",      5L, "qualitative", TRUE,
  "nbapalettes",              "raptors_statement",      3L, "qualitative", TRUE,
  "nbapalettes",                   "raptors_city",      4L, "qualitative", TRUE,
  "nbapalettes",               "raptors_original",      4L, "qualitative", TRUE,
  "nbapalettes",                 "raptors_europe",      4L, "qualitative", TRUE,
  "nbapalettes",               "raptors_military",      5L, "qualitative", TRUE,
  "nbapalettes",                        "rockets",      4L, "qualitative", TRUE,
  "nbapalettes",                    "rockets_90s",      4L, "qualitative", TRUE,
  "nbapalettes",                   "rockets_city",      3L, "qualitative", TRUE,
  "nbapalettes",               "rockets_original",      3L, "qualitative", TRUE,
  "nbapalettes",                         "sixers",      5L, "qualitative", TRUE,
  "nbapalettes",                   "sixers_retro",      2L, "qualitative", TRUE,
  "nbapalettes",                     "sixers_90s",      4L, "qualitative", TRUE,
  "nbapalettes",                    "sixers_city",      4L, "qualitative", TRUE,
  "nbapalettes",                          "spurs",      5L, "qualitative", TRUE,
  "nbapalettes",                           "suns",      7L, "qualitative", TRUE,
  "nbapalettes",                       "suns_00s",      6L, "qualitative", TRUE,
  "nbapalettes",                     "suns_retro",      3L, "qualitative", TRUE,
  "nbapalettes",                 "suns_statement",      5L, "qualitative", TRUE,
  "nbapalettes",                      "suns_city",     13L, "qualitative", TRUE,
  "nbapalettes",                    "supersonics",      3L, "qualitative", TRUE,
  "nbapalettes",                "supersonics_90s",      5L, "qualitative", TRUE,
  "nbapalettes",            "supersonics_holiday",      4L, "qualitative", TRUE,
  "nbapalettes",                        "thunder",      4L, "qualitative", TRUE,
  "nbapalettes",              "thunder_statement",      3L, "qualitative", TRUE,
  "nbapalettes",                   "thunder_city",      6L, "qualitative", TRUE,
  "nbapalettes",                  "thunder_city2",      5L, "qualitative", TRUE,
  "nbapalettes",                "thunder_tribute",      9L, "qualitative", TRUE,
  "nbapalettes",                   "timberwolves",      4L, "qualitative", TRUE,
  "nbapalettes",               "timberwolves_00s",      6L, "qualitative", TRUE,
  "nbapalettes",           "timberwolves_classic",      6L, "qualitative", TRUE,
  "nbapalettes",         "timberwolves_statement",      4L, "qualitative", TRUE,
  "nbapalettes",                       "warriors",      3L, "qualitative", TRUE,
  "nbapalettes",                   "warriors_00s",      4L, "qualitative", TRUE,
  "nbapalettes",                  "warriors_city",      3L, "qualitative", TRUE,
  "nbapalettes",                 "warriors_city2",      4L, "qualitative", TRUE,
  "nbapalettes",                   "warriors_cny",      3L, "qualitative", TRUE,
  "nbapalettes",                        "wizards",      3L, "qualitative", TRUE,
  "nbapalettes",                   "wizards_city",      3L, "qualitative", TRUE,
  "nbapalettes",                 "wizards_earned",      4L, "qualitative", TRUE,
  "NineteenEightyR",                          "cobra",      6L, "qualitative", TRUE,
  "NineteenEightyR",               "electronic_night",      5L, "qualitative", TRUE,
  "NineteenEightyR",                        "hotpink",      5L, "sequential", TRUE,
  "NineteenEightyR",                         "malibu",      5L, "qualitative", TRUE,
  "NineteenEightyR",                         "miami1",      5L, "divergent", TRUE,
  "NineteenEightyR",                         "miami2",      5L, "divergent", TRUE,
  "NineteenEightyR",        "seventies_aint_done_yet",      5L, "qualitative", TRUE,
  "NineteenEightyR",                          "sonny",      5L, "qualitative", TRUE,
  "NineteenEightyR",                        "sunset1",      5L, "qualitative", TRUE,
  "NineteenEightyR",                        "sunset2",      5L, "sequential", TRUE,
  "NineteenEightyR",                        "sunset3",      5L, "sequential", TRUE,
  "NineteenEightyR",                     "youngturqs",     12L, "qualitative", TRUE,
  "nord",                     "polarnight",      4L, "sequential", TRUE,
  "nord",                      "snowstorm",      3L, "sequential", TRUE,
  "nord",                          "frost",      4L, "qualitative", TRUE,
  "nord",                         "aurora",      5L, "qualitative", TRUE,
  "nord",                         "lumina",      5L, "qualitative", TRUE,
  "nord",                 "mountain_forms",      5L, "divergent", TRUE,
  "nord",                    "silver_mine",      5L, "divergent", TRUE,
  "nord",                  "lake_superior",      6L, "qualitative", TRUE,
  "nord",                  "victory_bonds",      5L, "qualitative", TRUE,
  "nord",                 "halifax_harbor",      6L, "sequential", TRUE,
  "nord",                     "moose_pond",      8L, "qualitative", TRUE,
  "nord",                  "algoma_forest",      7L, "qualitative", TRUE,
  "nord",                 "rocky_mountain",      6L, "qualitative", TRUE,
  "nord",                   "red_mountain",      8L, "qualitative", TRUE,
  "nord",                    "baie_mouton",      7L, "qualitative", TRUE,
  "nord",               "afternoon_prarie",      9L, "qualitative", TRUE,
  "ochRe",                 "namatjira_qual",      8L, "qualitative", TRUE,
  "ochRe",                  "namatjira_div",      8L, "qualitative", TRUE,
  "ochRe",                         "mccrea",     11L, "qualitative", TRUE,
  "ochRe",                     "parliament",      8L, "qualitative", TRUE,
  "ochRe",                       "tasmania",      7L, "qualitative", TRUE,
  "ochRe",                      "nolan_ned",      5L, "qualitative", TRUE,
  "ochRe",                         "winmar",      7L, "qualitative", TRUE,
  "ochRe",                     "olsen_qual",      6L, "qualitative", TRUE,
  "ochRe",                      "olsen_seq",     14L, "qualitative", TRUE,
  "ochRe",               "williams_pilbara",      7L, "qualitative", TRUE,
  "ochRe",                   "healthy_reef",      9L, "qualitative", TRUE,
  "ochRe",               "emu_woman_paired",     18L, "qualitative", TRUE,
  "ochRe",                          "galah",      6L, "divergent", TRUE,
  "ochRe",                       "lorikeet",      6L, "qualitative", TRUE,
  "ochRe",                      "dead_reef",      6L, "qualitative", TRUE,
  "ochRe",                   "jumping_frog",      5L, "qualitative", TRUE,
  "palettetown",                      "bulbasaur",     13L, "qualitative", TRUE,
  "palettetown",                        "ivysaur",     13L, "qualitative", TRUE,
  "palettetown",                       "venusaur",     14L, "qualitative", TRUE,
  "palettetown",                     "charmander",     13L, "qualitative", TRUE,
  "palettetown",                     "charmeleon",     12L, "qualitative", TRUE,
  "palettetown",                      "charizard",     14L, "qualitative", TRUE,
  "palettetown",                       "squirtle",     14L, "qualitative", TRUE,
  "palettetown",                      "wartortle",     13L, "qualitative", TRUE,
  "palettetown",                      "blastoise",     14L, "qualitative", TRUE,
  "palettetown",                       "caterpie",     12L, "qualitative", TRUE,
  "palettetown",                        "metapod",      5L, "qualitative", TRUE,
  "palettetown",                     "butterfree",     13L, "qualitative", TRUE,
  "palettetown",                         "weedle",     11L, "qualitative", TRUE,
  "palettetown",                         "kakuna",      8L, "qualitative", TRUE,
  "palettetown",                       "beedrill",     14L, "qualitative", TRUE,
  "palettetown",                         "pidgey",     12L, "qualitative", TRUE,
  "palettetown",                      "pidgeotto",     13L, "qualitative", TRUE,
  "palettetown",                        "pidgeot",     14L, "qualitative", TRUE,
  "palettetown",                        "rattata",     13L, "qualitative", TRUE,
  "palettetown",                       "raticate",     13L, "qualitative", TRUE,
  "palettetown",                        "spearow",     15L, "qualitative", TRUE,
  "palettetown",                         "fearow",     12L, "qualitative", TRUE,
  "palettetown",                          "ekans",     12L, "qualitative", TRUE,
  "palettetown",                          "arbok",     10L, "qualitative", TRUE,
  "palettetown",                        "pikachu",     10L, "qualitative", TRUE,
  "palettetown",                         "raichu",     14L, "qualitative", TRUE,
  "palettetown",                      "sandshrew",     10L, "qualitative", TRUE,
  "palettetown",                      "sandslash",     13L, "qualitative", TRUE,
  "palettetown",                       "nidoranf",     11L, "qualitative", TRUE,
  "palettetown",                       "nidorina",     13L, "qualitative", TRUE,
  "palettetown",                      "nidoqueen",     13L, "qualitative", TRUE,
  "palettetown",                       "nidoranm",     10L, "qualitative", TRUE,
  "palettetown",                       "nidorino",     12L, "qualitative", TRUE,
  "palettetown",                       "nidoking",     11L, "qualitative", TRUE,
  "palettetown",                       "clefairy",     13L, "qualitative", TRUE,
  "palettetown",                       "clefable",     12L, "qualitative", TRUE,
  "palettetown",                         "vulpix",     13L, "qualitative", TRUE,
  "palettetown",                      "ninetales",      7L, "qualitative", TRUE,
  "palettetown",                     "jigglypuff",     11L, "qualitative", TRUE,
  "palettetown",                     "wigglytuff",     12L, "qualitative", TRUE,
  "palettetown",                          "zubat",     11L, "qualitative", TRUE,
  "palettetown",                         "golbat",     11L, "qualitative", TRUE,
  "palettetown",                         "oddish",     10L, "qualitative", TRUE,
  "palettetown",                          "gloom",     14L, "qualitative", TRUE,
  "palettetown",                      "vileplume",     13L, "qualitative", TRUE,
  "palettetown",                          "paras",     12L, "qualitative", TRUE,
  "palettetown",                       "parasect",     11L, "qualitative", TRUE,
  "palettetown",                        "venonat",     14L, "qualitative", TRUE,
  "palettetown",                       "venomoth",     11L, "qualitative", TRUE,
  "palettetown",                        "diglett",      4L, "qualitative", TRUE,
  "palettetown",                        "dugtrio",     12L, "qualitative", TRUE,
  "palettetown",                         "meowth",     13L, "qualitative", TRUE,
  "palettetown",                        "persian",     12L, "qualitative", TRUE,
  "palettetown",                        "psyduck",     10L, "qualitative", TRUE,
  "palettetown",                        "golduck",     13L, "qualitative", TRUE,
  "palettetown",                         "mankey",     14L, "qualitative", TRUE,
  "palettetown",                       "primeape",     15L, "qualitative", TRUE,
  "palettetown",                      "growlithe",     11L, "qualitative", TRUE,
  "palettetown",                       "arcanine",     14L, "qualitative", TRUE,
  "palettetown",                        "poliwag",     11L, "qualitative", TRUE,
  "palettetown",                      "poliwhirl",      9L, "qualitative", TRUE,
  "palettetown",                      "poliwrath",      9L, "qualitative", TRUE,
  "palettetown",                           "abra",      8L, "qualitative", TRUE,
  "palettetown",                        "kadabra",     14L, "qualitative", TRUE,
  "palettetown",                       "alakazam",     12L, "qualitative", TRUE,
  "palettetown",                         "machop",     13L, "qualitative", TRUE,
  "palettetown",                        "machoke",     13L, "qualitative", TRUE,
  "palettetown",                        "machamp",     13L, "qualitative", TRUE,
  "palettetown",                     "bellsprout",     13L, "qualitative", TRUE,
  "palettetown",                     "weepinbell",     14L, "qualitative", TRUE,
  "palettetown",                     "victreebel",     14L, "qualitative", TRUE,
  "palettetown",                      "tentacool",     14L, "qualitative", TRUE,
  "palettetown",                     "tentacruel",     14L, "qualitative", TRUE,
  "palettetown",                        "geodude",      6L, "qualitative", TRUE,
  "palettetown",                       "graveler",      6L, "qualitative", TRUE,
  "palettetown",                          "golem",     12L, "qualitative", TRUE,
  "palettetown",                         "ponyta",     11L, "qualitative", TRUE,
  "palettetown",                       "rapidash",     11L, "qualitative", TRUE,
  "palettetown",                       "slowpoke",     12L, "qualitative", TRUE,
  "palettetown",                        "slowbro",     13L, "qualitative", TRUE,
  "palettetown",                      "magnemite",     14L, "qualitative", TRUE,
  "palettetown",                       "magneton",     14L, "qualitative", TRUE,
  "palettetown",                      "farfetchd",     14L, "qualitative", TRUE,
  "palettetown",                          "doduo",      9L, "qualitative", TRUE,
  "palettetown",                         "dodrio",     15L, "qualitative", TRUE,
  "palettetown",                           "seel",     11L, "qualitative", TRUE,
  "palettetown",                        "dewgong",      7L, "qualitative", TRUE,
  "palettetown",                         "grimer",      9L, "qualitative", TRUE,
  "palettetown",                            "muk",      8L, "qualitative", TRUE,
  "palettetown",                       "shellder",      9L, "qualitative", TRUE,
  "palettetown",                       "cloyster",      9L, "qualitative", TRUE,
  "palettetown",                         "gastly",      8L, "qualitative", TRUE,
  "palettetown",                        "haunter",     10L, "qualitative", TRUE,
  "palettetown",                         "gengar",     10L, "qualitative", TRUE,
  "palettetown",                           "onix",      6L, "qualitative", TRUE,
  "palettetown",                        "drowzee",      9L, "qualitative", TRUE,
  "palettetown",                          "hypno",      9L, "qualitative", TRUE,
  "palettetown",                         "krabby",     10L, "qualitative", TRUE,
  "palettetown",                        "kingler",     10L, "qualitative", TRUE,
  "palettetown",                        "voltorb",      9L, "qualitative", TRUE,
  "palettetown",                      "electrode",     10L, "qualitative", TRUE,
  "palettetown",                      "exeggcute",      9L, "qualitative", TRUE,
  "palettetown",                      "exeggutor",     14L, "qualitative", TRUE,
  "palettetown",                         "cubone",     13L, "qualitative", TRUE,
  "palettetown",                        "marowak",     14L, "qualitative", TRUE,
  "palettetown",                      "hitmonlee",     12L, "qualitative", TRUE,
  "palettetown",                     "hitmonchan",     13L, "qualitative", TRUE,
  "palettetown",                      "lickitung",      9L, "qualitative", TRUE,
  "palettetown",                        "koffing",     12L, "qualitative", TRUE,
  "palettetown",                        "weezing",     13L, "qualitative", TRUE,
  "palettetown",                        "rhyhorn",      8L, "qualitative", TRUE,
  "palettetown",                         "rhydon",     11L, "qualitative", TRUE,
  "palettetown",                        "chansey",      9L, "qualitative", TRUE,
  "palettetown",                        "tangela",      9L, "qualitative", TRUE,
  "palettetown",                     "kangaskhan",     14L, "qualitative", TRUE,
  "palettetown",                         "horsea",     10L, "qualitative", TRUE,
  "palettetown",                         "seadra",     10L, "qualitative", TRUE,
  "palettetown",                        "goldeen",     11L, "qualitative", TRUE,
  "palettetown",                        "seaking",     12L, "qualitative", TRUE,
  "palettetown",                         "staryu",     12L, "qualitative", TRUE,
  "palettetown",                        "starmie",     12L, "qualitative", TRUE,
  "palettetown",                        "mr_mime",     12L, "qualitative", TRUE,
  "palettetown",                        "scyther",     12L, "qualitative", TRUE,
  "palettetown",                           "jynx",     15L, "qualitative", TRUE,
  "palettetown",                     "electabuzz",     10L, "qualitative", TRUE,
  "palettetown",                         "magmar",     12L, "qualitative", TRUE,
  "palettetown",                         "pinsir",      9L, "qualitative", TRUE,
  "palettetown",                         "tauros",     13L, "qualitative", TRUE,
  "palettetown",                       "magikarp",     13L, "qualitative", TRUE,
  "palettetown",                       "gyarados",     15L, "qualitative", TRUE,
  "palettetown",                         "lapras",     15L, "qualitative", TRUE,
  "palettetown",                          "ditto",      6L, "qualitative", TRUE,
  "palettetown",                          "eevee",      9L, "qualitative", TRUE,
  "palettetown",                       "vaporeon",     15L, "qualitative", TRUE,
  "palettetown",                        "jolteon",     11L, "qualitative", TRUE,
  "palettetown",                        "flareon",     10L, "qualitative", TRUE,
  "palettetown",                        "porygon",     11L, "qualitative", TRUE,
  "palettetown",                        "omanyte",     12L, "qualitative", TRUE,
  "palettetown",                        "omastar",     12L, "qualitative", TRUE,
  "palettetown",                         "kabuto",     11L, "qualitative", TRUE,
  "palettetown",                       "kabutops",      9L, "qualitative", TRUE,
  "palettetown",                     "aerodactyl",      7L, "qualitative", TRUE,
  "palettetown",                        "snorlax",     14L, "qualitative", TRUE,
  "palettetown",                       "articuno",     12L, "qualitative", TRUE,
  "palettetown",                         "zapdos",     10L, "qualitative", TRUE,
  "palettetown",                        "moltres",     14L, "qualitative", TRUE,
  "palettetown",                        "dratini",      9L, "qualitative", TRUE,
  "palettetown",                      "dragonair",     12L, "qualitative", TRUE,
  "palettetown",                      "dragonite",     13L, "qualitative", TRUE,
  "palettetown",                         "mewtwo",      9L, "qualitative", TRUE,
  "palettetown",                            "mew",      6L, "qualitative", TRUE,
  "palettetown",                      "chikorita",     11L, "qualitative", TRUE,
  "palettetown",                        "bayleef",     14L, "qualitative", TRUE,
  "palettetown",                       "meganium",     14L, "qualitative", TRUE,
  "palettetown",                      "cyndaquil",     13L, "qualitative", TRUE,
  "palettetown",                        "quilava",     14L, "qualitative", TRUE,
  "palettetown",                     "typhlosion",     14L, "qualitative", TRUE,
  "palettetown",                       "totodile",     11L, "qualitative", TRUE,
  "palettetown",                       "croconaw",     13L, "qualitative", TRUE,
  "palettetown",                     "feraligatr",     14L, "qualitative", TRUE,
  "palettetown",                        "sentret",     12L, "qualitative", TRUE,
  "palettetown",                         "furret",     11L, "qualitative", TRUE,
  "palettetown",                       "hoothoot",     13L, "qualitative", TRUE,
  "palettetown",                        "noctowl",     13L, "qualitative", TRUE,
  "palettetown",                         "ledyba",     12L, "qualitative", TRUE,
  "palettetown",                         "ledian",     14L, "qualitative", TRUE,
  "palettetown",                       "spinarak",     14L, "qualitative", TRUE,
  "palettetown",                        "ariados",     14L, "qualitative", TRUE,
  "palettetown",                         "crobat",      9L, "qualitative", TRUE,
  "palettetown",                       "chinchou",     13L, "qualitative", TRUE,
  "palettetown",                        "lanturn",     14L, "qualitative", TRUE,
  "palettetown",                          "pichu",     11L, "qualitative", TRUE,
  "palettetown",                         "cleffa",     11L, "qualitative", TRUE,
  "palettetown",                      "igglybuff",      9L, "qualitative", TRUE,
  "palettetown",                         "togepi",     12L, "qualitative", TRUE,
  "palettetown",                        "togetic",     11L, "qualitative", TRUE,
  "palettetown",                           "natu",     14L, "qualitative", TRUE,
  "palettetown",                           "xatu",     15L, "qualitative", TRUE,
  "palettetown",                         "mareep",     14L, "qualitative", TRUE,
  "palettetown",                        "flaaffy",     13L, "qualitative", TRUE,
  "palettetown",                       "ampharos",     12L, "qualitative", TRUE,
  "palettetown",                      "bellossom",     13L, "qualitative", TRUE,
  "palettetown",                         "marill",     10L, "qualitative", TRUE,
  "palettetown",                      "azumarill",     10L, "qualitative", TRUE,
  "palettetown",                      "sudowoodo",     11L, "qualitative", TRUE,
  "palettetown",                       "politoed",     14L, "qualitative", TRUE,
  "palettetown",                         "hoppip",     10L, "qualitative", TRUE,
  "palettetown",                       "skiploom",     11L, "qualitative", TRUE,
  "palettetown",                       "jumpluff",     13L, "qualitative", TRUE,
  "palettetown",                          "aipom",     12L, "qualitative", TRUE,
  "palettetown",                        "sunkern",     13L, "qualitative", TRUE,
  "palettetown",                       "sunflora",     12L, "qualitative", TRUE,
  "palettetown",                          "yanma",     11L, "qualitative", TRUE,
  "palettetown",                         "wooper",      9L, "qualitative", TRUE,
  "palettetown",                       "quagsire",      9L, "qualitative", TRUE,
  "palettetown",                         "espeon",      9L, "qualitative", TRUE,
  "palettetown",                        "umbreon",     10L, "qualitative", TRUE,
  "palettetown",                        "murkrow",     12L, "qualitative", TRUE,
  "palettetown",                       "slowking",     13L, "qualitative", TRUE,
  "palettetown",                     "misdreavus",     13L, "qualitative", TRUE,
  "palettetown",                          "unown",      5L, "qualitative", TRUE,
  "palettetown",                      "wobbuffet",      8L, "qualitative", TRUE,
  "palettetown",                      "girafarig",     13L, "qualitative", TRUE,
  "palettetown",                         "pineco",      5L, "qualitative", TRUE,
  "palettetown",                     "forretress",     10L, "qualitative", TRUE,
  "palettetown",                      "dunsparce",     13L, "qualitative", TRUE,
  "palettetown",                         "gligar",     12L, "qualitative", TRUE,
  "palettetown",                        "steelix",      7L, "qualitative", TRUE,
  "palettetown",                       "snubbull",     12L, "qualitative", TRUE,
  "palettetown",                       "granbull",     11L, "qualitative", TRUE,
  "palettetown",                       "qwilfish",     12L, "qualitative", TRUE,
  "palettetown",                         "scizor",     11L, "qualitative", TRUE,
  "palettetown",                        "shuckle",     12L, "qualitative", TRUE,
  "palettetown",                      "heracross",     11L, "qualitative", TRUE,
  "palettetown",                        "sneasel",     14L, "qualitative", TRUE,
  "palettetown",                      "teddiursa",     12L, "qualitative", TRUE,
  "palettetown",                       "ursaring",     13L, "qualitative", TRUE,
  "palettetown",                         "slugma",      9L, "qualitative", TRUE,
  "palettetown",                       "magcargo",     12L, "qualitative", TRUE,
  "palettetown",                         "swinub",      9L, "qualitative", TRUE,
  "palettetown",                      "piloswine",     12L, "qualitative", TRUE,
  "palettetown",                        "corsola",      9L, "qualitative", TRUE,
  "palettetown",                       "remoraid",      9L, "qualitative", TRUE,
  "palettetown",                      "octillery",     12L, "qualitative", TRUE,
  "palettetown",                       "delibird",     13L, "qualitative", TRUE,
  "palettetown",                        "mantine",     13L, "qualitative", TRUE,
  "palettetown",                       "skarmory",     12L, "qualitative", TRUE,
  "palettetown",                       "houndour",     11L, "qualitative", TRUE,
  "palettetown",                       "houndoom",     12L, "qualitative", TRUE,
  "palettetown",                        "kingdra",     12L, "qualitative", TRUE,
  "palettetown",                         "phanpy",      9L, "qualitative", TRUE,
  "palettetown",                        "donphan",     13L, "qualitative", TRUE,
  "palettetown",                       "porygon2",     12L, "qualitative", TRUE,
  "palettetown",                       "stantler",     12L, "qualitative", TRUE,
  "palettetown",                       "smeargle",     12L, "qualitative", TRUE,
  "palettetown",                        "tyrogue",     12L, "qualitative", TRUE,
  "palettetown",                      "hitmontop",     12L, "qualitative", TRUE,
  "palettetown",                       "smoochum",     12L, "qualitative", TRUE,
  "palettetown",                         "elekid",      9L, "qualitative", TRUE,
  "palettetown",                          "magby",     10L, "qualitative", TRUE,
  "palettetown",                        "miltank",     15L, "qualitative", TRUE,
  "palettetown",                        "blissey",      9L, "qualitative", TRUE,
  "palettetown",                         "raikou",     13L, "qualitative", TRUE,
  "palettetown",                          "entei",     14L, "qualitative", TRUE,
  "palettetown",                        "suicune",     14L, "qualitative", TRUE,
  "palettetown",                       "larvitar",      9L, "qualitative", TRUE,
  "palettetown",                        "pupitar",      9L, "qualitative", TRUE,
  "palettetown",                      "tyranitar",     11L, "qualitative", TRUE,
  "palettetown",                          "lugia",      9L, "qualitative", TRUE,
  "palettetown",                          "ho_oh",     13L, "qualitative", TRUE,
  "palettetown",                         "celebi",     11L, "qualitative", TRUE,
  "palettetown",                        "treecko",     14L, "qualitative", TRUE,
  "palettetown",                        "grovyle",     14L, "qualitative", TRUE,
  "palettetown",                       "sceptile",     13L, "qualitative", TRUE,
  "palettetown",                        "torchic",     12L, "qualitative", TRUE,
  "palettetown",                      "combusken",     14L, "qualitative", TRUE,
  "palettetown",                       "blaziken",     14L, "qualitative", TRUE,
  "palettetown",                         "mudkip",     14L, "qualitative", TRUE,
  "palettetown",                      "marshtomp",     14L, "qualitative", TRUE,
  "palettetown",                       "swampert",     14L, "qualitative", TRUE,
  "palettetown",                      "poochyena",     14L, "qualitative", TRUE,
  "palettetown",                      "mightyena",     11L, "qualitative", TRUE,
  "palettetown",                      "zigzagoon",     14L, "qualitative", TRUE,
  "palettetown",                        "linoone",     11L, "qualitative", TRUE,
  "palettetown",                        "wurmple",     13L, "qualitative", TRUE,
  "palettetown",                        "silcoon",      9L, "qualitative", TRUE,
  "palettetown",                      "beautifly",     13L, "qualitative", TRUE,
  "palettetown",                        "cascoon",      8L, "qualitative", TRUE,
  "palettetown",                         "dustox",     14L, "qualitative", TRUE,
  "palettetown",                          "lotad",     13L, "qualitative", TRUE,
  "palettetown",                         "lombre",     12L, "qualitative", TRUE,
  "palettetown",                       "ludicolo",     15L, "qualitative", TRUE,
  "palettetown",                         "seedot",     11L, "qualitative", TRUE,
  "palettetown",                        "nuzleaf",     14L, "qualitative", TRUE,
  "palettetown",                        "shiftry",     13L, "qualitative", TRUE,
  "palettetown",                        "taillow",     15L, "qualitative", TRUE,
  "palettetown",                        "swellow",     15L, "qualitative", TRUE,
  "palettetown",                        "wingull",     14L, "qualitative", TRUE,
  "palettetown",                       "pelipper",     15L, "qualitative", TRUE,
  "palettetown",                          "ralts",     11L, "qualitative", TRUE,
  "palettetown",                         "kirlia",     13L, "qualitative", TRUE,
  "palettetown",                      "gardevoir",     12L, "qualitative", TRUE,
  "palettetown",                        "surskit",     12L, "qualitative", TRUE,
  "palettetown",                     "masquerain",     14L, "qualitative", TRUE,
  "palettetown",                      "shroomish",     11L, "qualitative", TRUE,
  "palettetown",                        "breloom",     15L, "qualitative", TRUE,
  "palettetown",                        "slakoth",     14L, "qualitative", TRUE,
  "palettetown",                       "vigoroth",     15L, "qualitative", TRUE,
  "palettetown",                        "slaking",     14L, "qualitative", TRUE,
  "palettetown",                        "nincada",     15L, "qualitative", TRUE,
  "palettetown",                        "ninjask",     13L, "qualitative", TRUE,
  "palettetown",                       "shedinja",     10L, "qualitative", TRUE,
  "palettetown",                        "whismur",     12L, "qualitative", TRUE,
  "palettetown",                        "loudred",     14L, "qualitative", TRUE,
  "palettetown",                        "exploud",     15L, "qualitative", TRUE,
  "palettetown",                       "makuhita",     12L, "qualitative", TRUE,
  "palettetown",                       "hariyama",     15L, "qualitative", TRUE,
  "palettetown",                        "azurill",     11L, "qualitative", TRUE,
  "palettetown",                       "nosepass",     11L, "qualitative", TRUE,
  "palettetown",                         "skitty",     11L, "qualitative", TRUE,
  "palettetown",                       "delcatty",     15L, "qualitative", TRUE,
  "palettetown",                        "sableye",     13L, "qualitative", TRUE,
  "palettetown",                         "mawile",     14L, "qualitative", TRUE,
  "palettetown",                           "aron",      9L, "qualitative", TRUE,
  "palettetown",                         "lairon",     12L, "qualitative", TRUE,
  "palettetown",                         "aggron",     12L, "qualitative", TRUE,
  "palettetown",                       "meditite",     13L, "qualitative", TRUE,
  "palettetown",                       "medicham",     13L, "qualitative", TRUE,
  "palettetown",                      "electrike",     10L, "qualitative", TRUE,
  "palettetown",                      "manectric",     13L, "qualitative", TRUE,
  "palettetown",                         "plusle",     10L, "qualitative", TRUE,
  "palettetown",                          "minun",     13L, "qualitative", TRUE,
  "palettetown",                        "volbeat",     15L, "qualitative", TRUE,
  "palettetown",                       "illumise",     15L, "qualitative", TRUE,
  "palettetown",                        "roselia",     15L, "qualitative", TRUE,
  "palettetown",                         "gulpin",     11L, "qualitative", TRUE,
  "palettetown",                         "swalot",     14L, "qualitative", TRUE,
  "palettetown",                       "carvanha",     13L, "qualitative", TRUE,
  "palettetown",                       "sharpedo",     14L, "qualitative", TRUE,
  "palettetown",                        "wailmer",     15L, "qualitative", TRUE,
  "palettetown",                        "wailord",     13L, "qualitative", TRUE,
  "palettetown",                          "numel",     15L, "qualitative", TRUE,
  "palettetown",                       "camerupt",     13L, "qualitative", TRUE,
  "palettetown",                        "torkoal",     12L, "qualitative", TRUE,
  "palettetown",                         "spoink",     13L, "qualitative", TRUE,
  "palettetown",                        "grumpig",     15L, "qualitative", TRUE,
  "palettetown",                         "spinda",     10L, "qualitative", TRUE,
  "palettetown",                       "trapinch",     10L, "qualitative", TRUE,
  "palettetown",                        "vibrava",     14L, "qualitative", TRUE,
  "palettetown",                         "flygon",     15L, "qualitative", TRUE,
  "palettetown",                         "cacnea",     14L, "qualitative", TRUE,
  "palettetown",                       "cacturne",     12L, "qualitative", TRUE,
  "palettetown",                         "swablu",     12L, "qualitative", TRUE,
  "palettetown",                        "altaria",     12L, "qualitative", TRUE,
  "palettetown",                       "zangoose",     15L, "qualitative", TRUE,
  "palettetown",                        "seviper",     14L, "qualitative", TRUE,
  "palettetown",                       "lunatone",     14L, "qualitative", TRUE,
  "palettetown",                        "solrock",     14L, "qualitative", TRUE,
  "palettetown",                       "barboach",     12L, "qualitative", TRUE,
  "palettetown",                       "whiscash",     15L, "qualitative", TRUE,
  "palettetown",                       "corphish",     13L, "qualitative", TRUE,
  "palettetown",                      "crawdaunt",     15L, "qualitative", TRUE,
  "palettetown",                         "baltoy",      7L, "qualitative", TRUE,
  "palettetown",                        "claydol",     12L, "qualitative", TRUE,
  "palettetown",                         "lileep",     12L, "qualitative", TRUE,
  "palettetown",                        "cradily",     12L, "qualitative", TRUE,
  "palettetown",                        "anorith",     14L, "qualitative", TRUE,
  "palettetown",                        "armaldo",     14L, "qualitative", TRUE,
  "palettetown",                         "feebas",     13L, "qualitative", TRUE,
  "palettetown",                        "milotic",     14L, "qualitative", TRUE,
  "palettetown",                       "castform",      9L, "qualitative", TRUE,
  "palettetown",                        "kecleon",     15L, "qualitative", TRUE,
  "palettetown",                        "shuppet",     12L, "qualitative", TRUE,
  "palettetown",                        "banette",     12L, "qualitative", TRUE,
  "palettetown",                        "duskull",     13L, "qualitative", TRUE,
  "palettetown",                       "dusclops",     11L, "qualitative", TRUE,
  "palettetown",                        "tropius",     15L, "qualitative", TRUE,
  "palettetown",                       "chimecho",     13L, "qualitative", TRUE,
  "palettetown",                          "absol",     11L, "qualitative", TRUE,
  "palettetown",                         "wynaut",     11L, "qualitative", TRUE,
  "palettetown",                        "snorunt",     15L, "qualitative", TRUE,
  "palettetown",                         "glalie",     13L, "qualitative", TRUE,
  "palettetown",                         "spheal",     12L, "qualitative", TRUE,
  "palettetown",                         "sealeo",     15L, "qualitative", TRUE,
  "palettetown",                        "walrein",     12L, "qualitative", TRUE,
  "palettetown",                       "clamperl",     14L, "qualitative", TRUE,
  "palettetown",                        "huntail",     14L, "qualitative", TRUE,
  "palettetown",                       "gorebyss",     12L, "qualitative", TRUE,
  "palettetown",                      "relicanth",     13L, "qualitative", TRUE,
  "palettetown",                        "luvdisc",      9L, "qualitative", TRUE,
  "palettetown",                          "bagon",     11L, "qualitative", TRUE,
  "palettetown",                        "shelgon",     12L, "qualitative", TRUE,
  "palettetown",                      "salamence",     13L, "qualitative", TRUE,
  "palettetown",                         "beldum",     10L, "qualitative", TRUE,
  "palettetown",                         "metang",     13L, "qualitative", TRUE,
  "palettetown",                      "metagross",     13L, "qualitative", TRUE,
  "palettetown",                       "regirock",     13L, "qualitative", TRUE,
  "palettetown",                         "regice",     10L, "qualitative", TRUE,
  "palettetown",                      "registeel",     13L, "qualitative", TRUE,
  "palettetown",                         "latias",     14L, "qualitative", TRUE,
  "palettetown",                         "latios",     14L, "qualitative", TRUE,
  "palettetown",                         "kyogre",     14L, "qualitative", TRUE,
  "palettetown",                        "groudon",     14L, "qualitative", TRUE,
  "palettetown",                       "rayquaza",     12L, "qualitative", TRUE,
  "palettetown",                        "jirachi",     12L, "qualitative", TRUE,
  "palettetown",                         "deoxys",     14L, "qualitative", TRUE,
  "palettetown",                     "teamrocket",      6L, "qualitative", TRUE,
  "palettetown",                  "starterspairs",      6L, "qualitative", TRUE,
  "palettetown",                   "startersDark",      6L, "qualitative", TRUE,
  "pals",                       "alphabet",     26L, "qualitative", FALSE,
  "pals",                      "alphabet2",     26L, "qualitative", FALSE,
  "pals",                        "glasbey",     32L, "qualitative", FALSE,
  "pals",                          "kelly",     22L, "qualitative", FALSE,
  "pals",                     "polychrome",     36L, "qualitative", FALSE,
  "pals",                        "stepped",     24L, "qualitative", FALSE,
  "pals",                            "tol",     12L, "qualitative", FALSE,
  "pals",                     "watlington",     16L, "qualitative", FALSE,
  "Polychrome",                       "alphabet",     26L, "qualitative", FALSE,
  "Polychrome",                           "dark",     24L, "qualitative", FALSE,
  "Polychrome",                        "glasbey",     32L, "qualitative", FALSE,
  "Polychrome",                 "green_armytage",     26L, "qualitative", FALSE,
  "Polychrome",                          "kelly",     22L, "qualitative", FALSE,
  "Polychrome",                          "light",     24L, "qualitative", FALSE,
  "Polychrome",                      "palette36",     36L, "qualitative", FALSE,
  "Polychrome",                            "sky",     24L, "qualitative", FALSE,
  "severance",                          "Dinner",      5L, "qualitative", TRUE,
  "severance",                            "Half",      5L, "qualitative", TRUE,
  "severance",                            "Hell",      6L, "qualitative", TRUE,
  "severance",                     "HideAndSeek",      6L, "qualitative", TRUE,
  "severance",                          "Jazz01",      5L, "qualitative", TRUE,
  "severance",                          "Jazz02",      6L, "qualitative", TRUE,
  "severance",                    "TheYouYouAre",      5L, "qualitative", TRUE,
  "Manu",                           "Hihi",      5L, "qualitative", TRUE,
  "Manu",                          "Hoiho",      6L, "qualitative", TRUE,
  "Manu",                           "Kaka",      5L, "qualitative", TRUE,
  "Manu",                         "Kakapo",      6L, "qualitative", TRUE,
  "Manu",                       "Kakariki",      5L, "qualitative", TRUE,
  "Manu",                            "Kea",      7L, "qualitative", TRUE,
  "Manu",                         "Kereru",      6L, "qualitative", TRUE,
  "Manu",                    "Kereru_orig",      5L, "qualitative", TRUE,
  "Manu",                       "Korimako",      6L, "qualitative", TRUE,
  "Manu",                         "Korora",      5L, "qualitative", TRUE,
  "Manu",                         "Kotare",      6L, "qualitative", TRUE,
  "Manu",                   "Putangitangi",      6L, "qualitative", TRUE,
  "Manu",                         "Takahe",      5L, "qualitative", TRUE,
  "Manu",                         "Takapu",      5L, "qualitative", TRUE,
  "Manu",                    "Titipounamu",      6L, "qualitative", TRUE,
  "Manu",                            "Tui",      6L, "qualitative", TRUE,
  "Manu",                       "Pepetuna",      5L, "qualitative", TRUE,
  "Manu",                     "Pohutukawa",      6L, "qualitative", TRUE,
  "Manu",                    "Gloomy_Nudi",      5L, "qualitative", TRUE,
  "Manu",                           "Kiwi",      6L, "qualitative", TRUE,
  "Manu",                         "Kokako",      5L, "qualitative", TRUE,
  "MapPalettes",                  "green_machine",      5L, "sequential", FALSE,
  "MapPalettes",                        "bruiser",      5L, "sequential", FALSE,
  "MapPalettes",                  "tealberry_pie",      5L, "divergent", FALSE,
  "MapPalettes",                      "the_joker",      5L, "divergent", FALSE,
  "MapPalettes",                         "sunset",      5L, "divergent", FALSE,
  "MapPalettes",                     "irish_flag",      5L, "divergent", FALSE,
  "miscpalettes",                       "dreaming",      8L, "qualitative", TRUE,
  "miscpalettes",                           "jojo",      8L, "qualitative", TRUE,
  "miscpalettes",                          "beach",      8L, "qualitative", TRUE,
  "miscpalettes",                      "waterfall",      8L, "qualitative", TRUE,
  "miscpalettes",                         "sunset",      8L, "qualitative", TRUE,
  "miscpalettes",                         "bright",     16L, "qualitative", TRUE,
  "miscpalettes",                      "grayscale",     16L, "sequential", TRUE,
  "miscpalettes",                          "excel",     16L, "qualitative", TRUE,
  "miscpalettes",                          "light",     10L, "qualitative", TRUE,
  "miscpalettes",                         "pastel",     16L, "qualitative", TRUE,
  "miscpalettes",                     "earthTones",     16L, "qualitative", TRUE,
  "miscpalettes",                "semiTransparent",     16L, "qualitative", TRUE,
  "miscpalettes",                          "berry",     11L, "qualitative", TRUE,
  "miscpalettes",                      "chocolate",     10L, "qualitative", TRUE,
  "miscpalettes",                           "fire",     10L, "qualitative", TRUE,
  "miscpalettes",                       "seaGreen",     10L, "qualitative", TRUE,
  "miscpalettes",                   "brightPastel",     15L, "qualitative", TRUE,
  "MoMAColors",         "Abbott",      8L, "qualitative", TRUE,
  "MoMAColors",       "Alkalay1",      5L,  "sequential", TRUE,
  "MoMAColors",       "Alkalay2",      8L,  "sequential", TRUE,
  "MoMAColors",        "Althoff",      5L,  "sequential", TRUE,
  "MoMAColors",          "Andri",      4L, "qualitative", TRUE,
  "MoMAColors",         "Avedon",     11L,   "divergent", TRUE,
  "MoMAColors",        "Budnitz",      5L, "qualitative", TRUE,
  "MoMAColors",           "Clay",      6L, "qualitative", TRUE,
  "MoMAColors",        "Connors",      5L, "qualitative", TRUE,
  "MoMAColors",           "Dali",      9L, "qualitative", TRUE,
  "MoMAColors",       "Doughton",     10L,   "divergent", TRUE,
  "MoMAColors",          "Ernst",      8L,  "sequential", TRUE,
  "MoMAColors",          "Exter",     10L,  "sequential", TRUE,
  "MoMAColors",          "Flash",      8L,  "sequential", TRUE,
  "MoMAColors",        "Fritsch",      4L, "qualitative", TRUE,
  "MoMAColors",   "Kippenberger",     11L,   "divergent", TRUE,
  "MoMAColors",          "Klein",     11L, "qualitative", TRUE,
  "MoMAColors",          "Koons",      5L, "qualitative", TRUE,
  "MoMAColors",        "Levine1",      8L, "qualitative", TRUE,
  "MoMAColors",        "Levine2",      7L, "qualitative", TRUE,
  "MoMAColors",            "Liu",      6L, "qualitative", TRUE,
  "MoMAColors",           "Lupi",      8L, "qualitative", TRUE,
  "MoMAColors",          "Ohchi",      5L, "qualitative", TRUE,
  "MoMAColors",        "OKeeffe",      6L, "qualitative", TRUE,
  "MoMAColors",        "Palermo",      4L, "qualitative", TRUE,
  "MoMAColors",         "Panton",      7L, "qualitative", TRUE,
  "MoMAColors",        "Picabia",     11L,   "divergent", TRUE,
  "MoMAColors",        "Picasso",      6L, "qualitative", TRUE,
  "MoMAColors",        "Rattner",      8L, "qualitative", TRUE,
  "MoMAColors",          "Sidhu",      7L, "qualitative", TRUE,
  "MoMAColors",          "Smith",      5L, "qualitative", TRUE,
  "MoMAColors",          "ustwo",      6L, "qualitative", TRUE,
  "MoMAColors",        "VanGogh",      7L, "qualitative", TRUE,
  "MoMAColors",        "vonHeyl",      5L, "qualitative", TRUE,
  "MoMAColors",         "Warhol",     15L, "qualitative", TRUE,
  "peRReo",                             "aventura",      9L, "qualitative", TRUE,
  "peRReo",                            "badbunny1",      9L, "qualitative", TRUE,
  "peRReo",                            "badbunny2",      9L, "qualitative", TRUE,
  "peRReo",                              "badgyal",      9L, "qualitative", TRUE,
  "peRReo",                               "beckyg",      9L, "qualitative", TRUE,
  "peRReo",                           "buenavista",      9L, "qualitative", TRUE,
  "peRReo",                              "calle13",      9L, "qualitative", TRUE,
  "peRReo",                               "daddy1",      9L, "qualitative", TRUE,
  "peRReo",                               "daddy2",      9L, "qualitative", TRUE,
  "peRReo",                                  "don",      9L, "qualitative", TRUE,
  "peRReo",                               "eminem",      9L, "qualitative", TRUE,
  "peRReo",                             "ivyqueen",      9L, "qualitative", TRUE,
  "peRReo",                               "karolg",      9L, "qualitative", TRUE,
  "peRReo",                                "natti",      9L, "qualitative", TRUE,
  "peRReo",                                "nicky",      9L, "qualitative", TRUE,
  "peRReo",                                "ozuna",      9L, "qualitative", TRUE,
  "peRReo",                                "planb",      9L, "qualitative", TRUE,
  "peRReo",                                 "rauw",      9L, "qualitative", TRUE,
  "peRReo",                              "rosalia",      9L, "qualitative", TRUE,
  "peRReo",                              "shakira",      9L, "qualitative", TRUE,
  "peRReo",                                  "wyy",      9L, "qualitative", TRUE,
  "palettesForR",                        "Android",     15L, "qualitative", TRUE,
  "palettesForR",                          "Bears",    256L, "qualitative", TRUE,
  "palettesForR",                          "Bgold",    256L, "qualitative", TRUE,
  "palettesForR",                          "Blues",    256L, "qualitative", TRUE,
  "palettesForR",                        "Borders",    256L, "qualitative", TRUE,
  "palettesForR",                         "Browns",     22L, "qualitative", TRUE,
  "palettesForR",                        "Caramel",    256L, "qualitative", TRUE,
  "palettesForR",                        "Cascade",    256L, "qualitative", TRUE,
  "palettesForR",                          "China",    256L, "qualitative", TRUE,
  "palettesForR",                       "Coldfire",    256L, "qualitative", TRUE,
  "palettesForR",                           "Cool",      8L, "qualitative", TRUE,
  "palettesForR",                         "Cranes",    256L, "qualitative", TRUE,
  "palettesForR",                           "Dark",    256L, "qualitative", TRUE,
  "palettesForR",                        "Default",     23L, "qualitative", TRUE,
  "palettesForR",                           "Echo",     27L, "qualitative", TRUE,
  "palettesForR",                            "Ega",    240L, "qualitative", TRUE,
  "palettesForR",                       "Firecode",    256L, "sequential", TRUE,
  "palettesForR",                           "Gold",    102L, "sequential", TRUE,
  "palettesForR",                           "Gray",    256L, "sequential", TRUE,
  "palettesForR",                       "Grayblue",    256L, "divergent", TRUE,
  "palettesForR",                          "Grays",     31L, "sequential", TRUE,
  "palettesForR",                     "GrayViolet",    256L, "divergent", TRUE,
  "palettesForR",                         "Greens",    256L, "qualitative", TRUE,
  "palettesForR",                         "Hilite",    170L, "qualitative", TRUE,
  "palettesForR",                       "Inkscape",    431L, "qualitative", TRUE,
  "palettesForR",                          "Khaki",    156L, "qualitative", TRUE,
  "palettesForR",                          "LaTeX",    136L, "qualitative", TRUE,
  "palettesForR",                         "Lights",     25L, "qualitative", TRUE,
  "palettesForR",                         "MATLAB",     73L, "qualitative", TRUE,
  "palettesForR",                          "Muted",     78L, "qualitative", TRUE,
  "palettesForR",                          "Named",    448L, "qualitative", TRUE,
  "palettesForR",                          "News3",    256L, "qualitative", TRUE,
  "palettesForR",                            "Op2",    256L, "qualitative", TRUE,
  "palettesForR",                       "Paintjet",     16L, "qualitative", TRUE,
  "palettesForR",                        "Pastels",     18L, "qualitative", TRUE,
  "palettesForR",                         "Plasma",    256L, "qualitative", TRUE,
  "palettesForR",                           "Reds",    177L, "qualitative", TRUE,
  "palettesForR",                          "Royal",    222L, "qualitative", TRUE,
  "palettesForR",                            "SVG",    139L, "qualitative", TRUE,
  "palettesForR",                          "Tango",     29L, "qualitative", TRUE,
  "palettesForR",                    "Topographic",    191L, "qualitative", TRUE,
  "palettesForR",                       "Visibone",    336L, "qualitative", TRUE,
  "palettesForR",                        "Volcano",    256L, "qualitative", TRUE,
  "palettesForR",                           "Warm",      7L, "qualitative", TRUE,
  "palettesForR",                            "Web",    216L, "qualitative", TRUE,
  "palettesForR",                         "WebHex",    216L, "qualitative", TRUE,
  "palettesForR",                      "WebSafe22",     22L, "qualitative", TRUE,
  "palettesForR",                        "Windows",     31L, "qualitative", TRUE,
  "PNWColors",                       "Starfish",      7L, "sequential", TRUE,
  "PNWColors",                        "Shuksan",      8L, "sequential", TRUE,
  "PNWColors",                            "Bay",      5L, "qualitative", TRUE,
  "PNWColors",                         "Winter",      5L, "sequential", TRUE,
  "PNWColors",                           "Lake",      8L, "sequential", TRUE,
  "PNWColors",                         "Sunset",      7L, "sequential", TRUE,
  "PNWColors",                       "Shuksan2",      5L, "divergent", TRUE,
  "PNWColors",                       "Cascades",      6L, "qualitative", TRUE,
  "PNWColors",                       "Sailboat",      6L, "qualitative", TRUE,
  "PNWColors",                           "Moth",      5L, "qualitative", TRUE,
  "PNWColors",                         "Spring",      6L, "divergent", TRUE,
  "PNWColors",                       "Mushroom",      6L, "sequential", TRUE,
  "PNWColors",                        "Sunset2",      5L, "sequential", TRUE,
  "PNWColors",                        "Anemone",      7L, "divergent", TRUE,
  "PrettyCols",                         "Blues",      5L,  "sequential", FALSE,
  "PrettyCols",                       "Purples",      5L,  "sequential", FALSE,
  "PrettyCols",                    "Tangerines",      5L,  "sequential", FALSE,
  "PrettyCols",                        "Greens",      5L,  "sequential", FALSE,
  "PrettyCols",                         "Pinks",      5L,  "sequential", FALSE,
  "PrettyCols",                         "Teals",      5L,  "sequential", FALSE,
  "PrettyCols",                       "Yellows",      5L,  "sequential", FALSE,
  "PrettyCols",                          "Reds",      5L,  "sequential", FALSE,
  "PrettyCols",                  "PurpleGreens",      9L,   "divergent", FALSE,
  "PrettyCols",                    "PinkGreens",      9L,   "divergent", FALSE,
  "PrettyCols",                "TangerineBlues",      9L,   "divergent", FALSE,
  "PrettyCols",              "PurpleTangerines",      9L,   "divergent", FALSE,
  "PrettyCols",                   "PurplePinks",      9L,   "divergent", FALSE,
  "PrettyCols",                    "TealGreens",      9L,   "divergent", FALSE,
  "PrettyCols",                 "PurpleYellows",      9L,   "divergent", FALSE,
  "PrettyCols",                      "RedBlues",      9L,   "divergent", FALSE,
  "PrettyCols",                          "Bold",      5L, "qualitative", FALSE,
  "PrettyCols",                          "Dark",      5L, "qualitative", FALSE,
  "PrettyCols",                         "Light",      5L, "qualitative", FALSE,
  "PrettyCols",                          "Neon",      6L, "qualitative", FALSE,
  "PrettyCols",                        "Summer",     12L, "qualitative", FALSE,
  "PrettyCols",                        "Autumn",     12L, "qualitative", FALSE,
  "PrettyCols",                        "Winter",     12L, "qualitative", FALSE,
  "PrettyCols",                       "Rainbow",     12L, "qualitative", FALSE,
  "PrettyCols",                         "Beach",      5L, "qualitative", FALSE,
  "PrettyCols",                           "Fun",      5L, "qualitative", FALSE,
  "PrettyCols",                           "Sea",      5L, "qualitative", FALSE,
  "PrettyCols",                        "Bright",      5L, "qualitative", FALSE,
  "PrettyCols",                         "Relax",      5L, "qualitative", FALSE,
  "PrettyCols",                        "Lucent",      5L, "qualitative", FALSE,
  "PrettyCols",                        "Lively",      5L, "qualitative", FALSE,
  "PrettyCols",                        "Joyful",      5L, "qualitative", FALSE,
  "rcartocolor",                      "ag_Sunset",      7L, "sequential", FALSE,
  "rcartocolor",                       "ag_GrnYl",      7L, "sequential", FALSE,
  "rcartocolor",                         "Tropic",      7L, "divergent", FALSE,
  "rcartocolor",                          "Temps",      7L, "divergent", FALSE,
  "rcartocolor",                       "TealRose",      7L, "divergent", FALSE,
  "rcartocolor",                         "Geyser",      7L, "divergent", FALSE,
  "rcartocolor",                           "Fall",      7L, "divergent", FALSE,
  "rcartocolor",                          "Earth",      7L, "divergent", FALSE,
  "rcartocolor",                       "ArmyRose",      7L, "divergent", FALSE,
  "rcartocolor",                          "Vivid",     12L, "qualitative", FALSE,
  "rcartocolor",                           "Safe",     12L, "qualitative", FALSE,
  "rcartocolor",                          "Prism",     12L, "qualitative", FALSE,
  "rcartocolor",                         "Pastel",     12L, "qualitative", FALSE,
  "rcartocolor",                           "Bold",     12L, "qualitative", FALSE,
  "rcartocolor",                        "Antique",     12L, "qualitative", FALSE,
  "rcartocolor",                        "TealGrn",      7L, "sequential", FALSE,
  "rcartocolor",                           "Teal",      7L, "sequential", FALSE,
  "rcartocolor",                     "SunsetDark",      7L, "sequential", FALSE,
  "rcartocolor",                         "Sunset",      7L, "sequential", FALSE,
  "rcartocolor",                          "RedOr",      7L, "sequential", FALSE,
  "rcartocolor",                         "PurpOr",      7L, "sequential", FALSE,
  "rcartocolor",                           "Purp",      7L, "sequential", FALSE,
  "rcartocolor",                         "PinkYl",      7L, "sequential", FALSE,
  "rcartocolor",                          "Peach",      7L, "sequential", FALSE,
  "rcartocolor",                          "OrYel",      7L, "sequential", FALSE,
  "rcartocolor",                           "Mint",      7L, "sequential", FALSE,
  "rcartocolor",                        "Magenta",      7L, "sequential", FALSE,
  "rcartocolor",                          "Emrld",      7L, "sequential", FALSE,
  "rcartocolor",                       "DarkMint",      7L, "sequential", FALSE,
  "rcartocolor",                         "BurgYl",      7L, "sequential", FALSE,
  "rcartocolor",                           "Burg",      7L, "sequential", FALSE,
  "rcartocolor",                         "BrwnYl",      7L, "sequential", FALSE,
  "rcartocolor",                          "BluYl",      7L, "sequential", FALSE,
  "rcartocolor",                         "BluGrn",      7L, "sequential", FALSE,
  "RColorBrewer",                           "BrBG",     11L, "divergent", FALSE,
  "RColorBrewer",                           "PiYG",     11L, "divergent", FALSE,
  "RColorBrewer",                           "PRGn",     11L, "divergent", FALSE,
  "RColorBrewer",                           "PuOr",     11L, "divergent", FALSE,
  "RColorBrewer",                           "RdBu",     11L, "divergent", FALSE,
  "RColorBrewer",                           "RdGy",     11L, "divergent", FALSE,
  "RColorBrewer",                         "RdYlBu",     11L, "divergent", FALSE,
  "RColorBrewer",                         "RdYlGn",     11L, "divergent", FALSE,
  "RColorBrewer",                       "Spectral",     11L, "sequential", FALSE,
  "RColorBrewer",                         "Accent",      8L, "qualitative", FALSE,
  "RColorBrewer",                          "Dark2",      8L, "qualitative", FALSE,
  "RColorBrewer",                         "Paired",     12L, "qualitative", FALSE,
  "RColorBrewer",                        "Pastel1",      9L, "qualitative", FALSE,
  "RColorBrewer",                        "Pastel2",      8L, "qualitative", FALSE,
  "RColorBrewer",                           "Set1",      9L, "qualitative", FALSE,
  "RColorBrewer",                           "Set2",      8L, "qualitative", FALSE,
  "RColorBrewer",                           "Set3",     12L, "qualitative", FALSE,
  "RColorBrewer",                          "Blues",      9L, "sequential", FALSE,
  "RColorBrewer",                           "BuGn",      9L, "sequential", FALSE,
  "RColorBrewer",                           "BuPu",      9L, "sequential", FALSE,
  "RColorBrewer",                           "GnBu",      9L, "sequential", FALSE,
  "RColorBrewer",                         "Greens",      9L, "sequential", FALSE,
  "RColorBrewer",                          "Greys",      9L, "sequential", FALSE,
  "RColorBrewer",                        "Oranges",      9L, "sequential", FALSE,
  "RColorBrewer",                           "OrRd",      9L, "sequential", FALSE,
  "RColorBrewer",                           "PuBu",      9L, "sequential", FALSE,
  "RColorBrewer",                         "PuBuGn",      9L, "sequential", FALSE,
  "RColorBrewer",                           "PuRd",      9L, "sequential", FALSE,
  "RColorBrewer",                        "Purples",      9L, "sequential", FALSE,
  "RColorBrewer",                           "RdPu",      9L, "sequential", FALSE,
  "RColorBrewer",                           "Reds",      9L, "sequential", FALSE,
  "RColorBrewer",                           "YlGn",      9L, "sequential", FALSE,
  "RColorBrewer",                         "YlGnBu",      9L, "sequential", FALSE,
  "RColorBrewer",                         "YlOrBr",      9L, "sequential", FALSE,
  "RColorBrewer",                         "YlOrRd",      9L, "sequential", FALSE,
  "Redmonder",                       "dPBIYlBu",     11L, "divergent", TRUE,
  "Redmonder",                       "dPBIYlPu",     11L, "divergent", TRUE,
  "Redmonder",                       "dPBIPuGn",     11L, "divergent", TRUE,
  "Redmonder",                       "dPBIPuOr",     11L, "divergent", TRUE,
  "Redmonder",                       "dPBIRdBu",     11L, "divergent", TRUE,
  "Redmonder",                       "dPBIRdGy",     11L, "divergent", TRUE,
  "Redmonder",                       "dPBIRdGn",     11L, "divergent", TRUE,
  "Redmonder",                        "qMSOStd",     10L, "qualitative", TRUE,
  "Redmonder",                         "qMSO12",      8L, "qualitative", TRUE,
  "Redmonder",                         "qMSO15",      8L, "qualitative", TRUE,
  "Redmonder",                     "qMSOBuWarm",      8L, "qualitative", TRUE,
  "Redmonder",                         "qMSOBu",      8L, "qualitative", TRUE,
  "Redmonder",                        "qMSOBu2",      8L, "qualitative", TRUE,
  "Redmonder",                       "qMSOBuGn",      8L, "qualitative", TRUE,
  "Redmonder",                         "qMSOGn",      8L, "qualitative", TRUE,
  "Redmonder",                       "qMSOGnYl",      8L, "qualitative", TRUE,
  "Redmonder",                         "qMSOYl",      8L, "qualitative", TRUE,
  "Redmonder",                       "qMSOYlOr",      8L, "qualitative", TRUE,
  "Redmonder",                         "qMSOOr",      8L, "qualitative", TRUE,
  "Redmonder",                       "qMSOOrRd",      8L, "qualitative", TRUE,
  "Redmonder",                       "qMSORdOr",      8L, "qualitative", TRUE,
  "Redmonder",                         "qMSORd",      8L, "qualitative", TRUE,
  "Redmonder",                       "qMSORdPu",      8L, "qualitative", TRUE,
  "Redmonder",                         "qMSOPu",      8L, "qualitative", TRUE,
  "Redmonder",                        "qMSOPu2",      8L, "qualitative", TRUE,
  "Redmonder",                        "qMSOMed",      8L, "qualitative", TRUE,
  "Redmonder",                        "qMSOPap",      8L, "qualitative", TRUE,
  "Redmonder",                        "qMSOMrq",      8L, "qualitative", TRUE,
  "Redmonder",                        "qMSOSlp",      8L, "qualitative", TRUE,
  "Redmonder",                        "qMSOAsp",      8L, "qualitative", TRUE,
  "Redmonder",                           "qPBI",      8L, "qualitative", TRUE,
  "Redmonder",                         "sPBIGn",      9L, "sequential", TRUE,
  "Redmonder",                        "sPBIGy1",      9L, "sequential", TRUE,
  "Redmonder",                         "sPBIRd",      9L, "sequential", TRUE,
  "Redmonder",                         "sPBIYl",      9L, "sequential", TRUE,
  "Redmonder",                        "sPBIGy2",      9L, "sequential", TRUE,
  "Redmonder",                         "sPBIBu",      9L, "sequential", TRUE,
  "Redmonder",                         "sPBIOr",      9L, "sequential", TRUE,
  "Redmonder",                         "sPBIPu",      9L, "sequential", TRUE,
  "Redmonder",                       "sPBIYlGn",      9L, "sequential", TRUE,
  "Redmonder",                       "sPBIRdPu",      9L, "sequential", TRUE,
  "rockthemes",                          "alice",      4L, "qualitative", TRUE,
  "rockthemes",                "californication",      4L, "qualitative", TRUE,
  "rockthemes",                       "coltrane",      4L, "qualitative", TRUE,
  "rockthemes",                        "deelite",      4L, "qualitative", TRUE,
  "rockthemes",                       "electric",      4L, "qualitative", TRUE,
  "rockthemes",                       "facelift",      4L, "qualitative", TRUE,
  "rockthemes",                    "faithnomore",      4L, "qualitative", TRUE,
  "rockthemes",                         "harvey",      4L, "qualitative", TRUE,
  "rockthemes",                           "heep",      4L, "qualitative", TRUE,
  "rockthemes",                     "hellawaits",      4L, "qualitative", TRUE,
  "rockthemes",                         "husker",      4L, "qualitative", TRUE,
  "rockthemes",                        "janelle",      4L, "qualitative", TRUE,
  "rockthemes",                   "melloncollie",      4L, "qualitative", TRUE,
  "rockthemes",                          "miles",      4L, "qualitative", TRUE,
  "rockthemes",                           "muse",      4L, "qualitative", TRUE,
  "rockthemes",                        "nodoubt",      4L, "qualitative", TRUE,
  "rockthemes",                     "peacesells",      4L, "qualitative", TRUE,
  "rockthemes",                      "secondlaw",      4L, "qualitative", TRUE,
  "rockthemes",                   "siamesedream",      4L, "qualitative", TRUE,
  "rockthemes",                          "swift",      4L, "qualitative", TRUE,
  "rockthemes",                       "zeppelin",      4L, "qualitative", TRUE,
  "RSkittleBrewer",                       "original",      5L, "qualitative", TRUE,
  "RSkittleBrewer",                       "tropical",      5L, "qualitative", TRUE,
  "RSkittleBrewer",                      "wildberry",      5L, "qualitative", TRUE,
  "RSkittleBrewer",                            "M_M",      6L, "qualitative", TRUE,
  "RSkittleBrewer",                       "smarties",      8L, "qualitative", TRUE,
  "rtist",                        "raphael",      5L, "qualitative", TRUE,
  "rtist",                        "hokusai",      5L, "qualitative", TRUE,
  "rtist",                        "vermeer",      5L, "qualitative", TRUE,
  "rtist",                          "degas",      5L, "qualitative", TRUE,
  "rtist",                        "davinci",      5L, "qualitative", TRUE,
  "rtist",                        "vangogh",      5L, "qualitative", TRUE,
  "rtist",                         "hopper",      5L, "qualitative", TRUE,
  "rtist",                          "klimt",      5L, "qualitative", TRUE,
  "rtist",                      "rembrandt",      5L, "qualitative", TRUE,
  "rtist",                          "munch",      5L, "qualitative", TRUE,
  "rtist",                         "warhol",      5L, "qualitative", TRUE,
  "rtist",                        "okeeffe",      5L, "qualitative", TRUE,
  "rtist",                      "oldenburg",      5L, "qualitative", TRUE,
  "rtist",                        "picasso",      5L, "qualitative", TRUE,
  "rtist",                        "pollock",      5L, "qualitative", TRUE,
  "soilpalettes",                        "alaquod",      5L, "qualitative", TRUE,
  "soilpalettes",                         "bangor",      5L, "qualitative", TRUE,
  "soilpalettes",                      "durorthod",      5L, "sequential", TRUE,
  "soilpalettes",                     "paleustalf",      5L, "qualitative", TRUE,
  "soilpalettes",                        "rendoll",      5L, "qualitative", TRUE,
  "soilpalettes",                          "redox",      5L, "qualitative", TRUE,
  "soilpalettes",                         "podzol",      5L, "sequential", TRUE,
  "soilpalettes",                      "eutrostox",      5L, "sequential", TRUE,
  "soilpalettes",                         "pywell",      5L, "qualitative", TRUE,
  "soilpalettes",                      "natrudoll",      5L, "sequential", TRUE,
  "soilpalettes",                    "vitrixerand",      5L, "sequential", TRUE,
  "soilpalettes",                          "crait",      5L, "sequential", TRUE,
  "soilpalettes",                           "gley",      5L, "sequential", TRUE,
  "soilpalettes",                         "redox2",      5L, "qualitative", TRUE,
  "suffrager",                         "london",      4L, "qualitative", TRUE,
  "suffrager",                           "oxon",      5L, "qualitative", TRUE,
  "suffrager",                       "CarolMan",      4L, "qualitative", TRUE,
  "suffrager",                        "hanwell",      5L, "qualitative", TRUE,
  "suffrager",                        "chelsea",      5L, "qualitative", TRUE,
  "suffrager",                        "classic",      2L, "qualitative", TRUE,
  "tayloRswift",                    "taylorSwift",      6L, "qualitative", TRUE,
  "tayloRswift",                       "fearless",      5L, "qualitative", TRUE,
  "tayloRswift",                       "speakNow",      5L, "qualitative", TRUE,
  "tayloRswift",                   "speakNowLive",      5L, "qualitative", TRUE,
  "tayloRswift",                      "taylorRed",      5L, "qualitative", TRUE,
  "tayloRswift",                     "taylor1989",      6L, "qualitative", TRUE,
  "tayloRswift",                     "reputation",      6L, "qualitative", TRUE,
  "tayloRswift",                          "lover",      6L, "qualitative", TRUE,
  "tayloRswift",                       "folklore",      4L,  "sequential", TRUE,
  "tayloRswift",                       "evermore",      5L, "qualitative", TRUE,
  "tayloRswift",                            "Red",      5L, "qualitative", TRUE,
  "tayloRswift",                      "midnights",      5L, "qualitative", TRUE,
  "tayloRswift",             "midnightsBloodMoon",      5L, "qualitative", TRUE,
  "tayloRswift",             "midnightsJadeGreen",      6L, "qualitative", TRUE,
  "tayloRswift",              "midnightsMahogany",      5L, "qualitative", TRUE,
  "tidyquant",                       "tq_light",     12L, "qualitative", FALSE,
  "tidyquant",                        "tq_dark",     12L, "qualitative", FALSE,
  "tidyquant",                       "tq_green",     12L, "qualitative", FALSE,
  "trekcolors",                       "andorian",      9L, "sequential", TRUE,
  "trekcolors",                        "bajoran",      6L, "qualitative", TRUE,
  "trekcolors",                           "borg",      9L, "sequential", TRUE,
  "trekcolors",                          "breen",      8L, "qualitative", TRUE,
  "trekcolors",                         "breen2",      9L, "sequential", TRUE,
  "trekcolors",                       "dominion",      7L, "qualitative", TRUE,
  "trekcolors",                          "enara",      9L, "sequential", TRUE,
  "trekcolors",                         "enara2",      4L, "qualitative", TRUE,
  "trekcolors",                        "ferengi",      9L, "divergent", TRUE,
  "trekcolors",                           "gorn",      9L, "qualitative", TRUE,
  "trekcolors",                        "iconian",      9L, "sequential", TRUE,
  "trekcolors",                        "klingon",      9L, "sequential", TRUE,
  "trekcolors",                   "lcars_series",     31L, "qualitative", TRUE,
  "trekcolors",                     "lcars_2357",      9L, "qualitative", TRUE,
  "trekcolors",                     "lcars_2369",      8L, "qualitative", TRUE,
  "trekcolors",                     "lcars_2375",      8L, "qualitative", TRUE,
  "trekcolors",                     "lcars_2379",      8L, "qualitative", TRUE,
  "trekcolors",                      "lcars_alt",     17L, "qualitative", TRUE,
  "trekcolors",            "lcars_first_contact",      8L, "qualitative", TRUE,
  "trekcolors",                  "lcars_nemesis",     10L, "qualitative", TRUE,
  "trekcolors",                     "lcars_nx01",      6L, "qualitative", TRUE,
  "trekcolors",                      "lcars_29c",      8L, "qualitative", TRUE,
  "trekcolors",                      "lcars_23c",      7L, "qualitative", TRUE,
  "trekcolors",                "lcars_red_alert",      8L, "qualitative", TRUE,
  "trekcolors",               "lcars_cardassian",     21L, "qualitative", TRUE,
  "trekcolors",                        "romulan",      9L, "divergent", TRUE,
  "trekcolors",                       "romulan2",      9L, "divergent", TRUE,
  "trekcolors",                      "starfleet",      3L, "qualitative", TRUE,
  "trekcolors",                     "starfleet2",      6L, "qualitative", TRUE,
  "trekcolors",                        "tholian",      9L, "divergent", TRUE,
  "trekcolors",                         "terran",      9L, "sequential", TRUE,
  "trekcolors",                            "ufp",      9L, "sequential", TRUE,
  "trekcolors",                      "red_alert",      6L, "qualitative", TRUE,
  "trekcolors",                   "yellow_alert",      6L, "qualitative", TRUE,
  "trekcolors",                    "black_alert",      5L, "qualitative", TRUE,
  "tvthemes",                  "attackOnTitan",      8L, "qualitative", TRUE,
  "tvthemes",                     "FireNation",      8L, "qualitative", TRUE,
  "tvthemes",                      "AirNomads",      7L, "qualitative", TRUE,
  "tvthemes",                   "EarthKingdom",      9L, "qualitative", TRUE,
  "tvthemes",                     "WaterTribe",      8L, "qualitative", TRUE,
  "tvthemes",                       "bigHero6",      8L, "qualitative", TRUE,
  "tvthemes",                        "Regular",     10L, "qualitative", TRUE,
  "tvthemes",                           "Dark",      9L, "qualitative", TRUE,
  "tvthemes",                   "gravityFalls",     14L, "qualitative", TRUE,
  "tvthemes",                            "Day",      8L, "qualitative", TRUE,
  "tvthemes",                           "Dusk",      8L, "qualitative", TRUE,
  "tvthemes",                          "Night",      8L, "qualitative", TRUE,
  "tvthemes",                    "kimPossible",     12L, "qualitative", TRUE,
  "tvthemes",                    "parksAndRec",     10L, "qualitative", TRUE,
  "tvthemes",                   "rickAndMorty",      9L, "qualitative", TRUE,
  "tvthemes",                       "simpsons",     10L, "qualitative", TRUE,
  "tvthemes",                      "spongeBob",      9L, "qualitative", TRUE,
  "tvthemes",                          "Stark",      9L, "qualitative", TRUE,
  "tvthemes",                        "Stannis",      7L, "qualitative", TRUE,
  "tvthemes",                      "Lannister",      6L, "qualitative", TRUE,
  "tvthemes",                         "Tyrell",      9L, "qualitative", TRUE,
  "tvthemes",                      "Targaryen",      5L, "qualitative", TRUE,
  "tvthemes",                        "Martell",      8L, "qualitative", TRUE,
  "tvthemes",                          "Tully",      6L, "qualitative", TRUE,
  "tvthemes",                        "Greyjoy",      6L, "qualitative", TRUE,
  "tvthemes",                       "Manderly",      7L, "qualitative", TRUE,
  "tvthemes",                          "Arryn",      7L, "qualitative", TRUE,
  "tvthemes",                         "Steven",     8L, "qualitative", TRUE,
  "tvthemes",                         "Garnet",     9L, "qualitative", TRUE,
  "tvthemes",                       "Amethyst",     6L, "qualitative", TRUE,
  "tvthemes",                          "Pearl",     6L, "qualitative", TRUE,
  "tvthemes",                     "RoseQuartz",     7L, "qualitative", TRUE,
  "tvthemes",                        "Peridot",     7L, "qualitative", TRUE,
  "tvthemes",                    "LapisLazuli",     7L, "qualitative", TRUE,
  "tvthemes",                       "Diamonds",     9L, "qualitative", TRUE,
  "tvthemes",                         "Jasper",     6L, "qualitative", TRUE,
  "tvthemes",                          "Topaz",     6L, "qualitative", TRUE,
  "tvthemes",                         "Spinel",     6L, "qualitative", TRUE,
  "tvthemes",                        "Bismuth",     8L, "qualitative", TRUE,
  "tvthemes",                           "Ruby",     6L, "qualitative", TRUE,
  "tvthemes",                       "Sapphire",     7L, "qualitative", TRUE,
  "tvthemes",                        "Emerald",     7L, "qualitative", TRUE,
  "tvthemes",                       "Nephrite",     7L, "qualitative", TRUE,
  "tvthemes",                     "Aquamarine",     7L, "qualitative", TRUE,
  "tvthemes",                   "Padparadscha",     6L, "qualitative", TRUE,
  "tvthemes",                         "Rutile",     5L, "qualitative", TRUE,
  "tvthemes",                      "Rhodonite",     8L, "qualitative", TRUE,
  "tvthemes",                       "Flourite",     8L, "qualitative", TRUE,
  "tvthemes",                      "MegaPearl",     9L, "qualitative", TRUE,
  "tvthemes",                       "Sugilite",     6L, "qualitative", TRUE,
  "tvthemes",                 "CrazyLaceAgate",     7L, "qualitative", TRUE,
  "tvthemes",                       "Sardonyx",     8L, "qualitative", TRUE,
  "tvthemes",                    "Alexandrite",     8L, "qualitative", TRUE,
  "tvthemes",                    "SmokyQuartz",     6L, "qualitative", TRUE,
  "tvthemes",                "BluebirdAzurite",     5L, "qualitative", TRUE,
  "tvthemes",                       "Sunstone",     9L, "qualitative", TRUE,
  "tvthemes",                           "Opal",     7L, "qualitative", TRUE,
  "tvthemes",                    "CrystalGems",     12L, "qualitative", TRUE,
  "unikn",                      "pal_unikn",     11L, "divergent", TRUE,
  "unikn",                  "pal_unikn_web",     10L, "divergent", TRUE,
  "unikn",                  "pal_unikn_ppt",     10L, "divergent", TRUE,
  "unikn",                "pal_unikn_light",     10L, "qualitative", TRUE,
  "unikn",                 "pal_unikn_dark",     10L, "qualitative", TRUE,
  "unikn",                 "pal_unikn_pair",     16L, "qualitative", TRUE,
  "unikn",                 "pal_unikn_pref",      9L, "qualitative", TRUE,
  "unikn",                    "pal_seeblau",      5L, "sequential", TRUE,
  "unikn",                      "pal_peach",      5L, "sequential", TRUE,
  "unikn",                       "pal_grau",      5L, "sequential", TRUE,
  "unikn",                     "pal_petrol",      5L, "sequential", TRUE,
  "unikn",                   "pal_seegruen",      5L, "sequential", TRUE,
  "unikn",                "pal_karpfenblau",      5L, "sequential", TRUE,
  "unikn",                      "pal_pinky",      5L, "sequential", TRUE,
  "unikn",                   "pal_bordeaux",      5L, "sequential", TRUE,
  "unikn",                     "pal_signal",      3L, "qualitative", TRUE,
  "vangogh",                  "StarryNight",            5L, "qualitative", TRUE,
  "vangogh",                  "StarryRhone",            5L, "qualitative", TRUE,
  "vangogh",                 "SelfPortrait",            5L, "qualitative", TRUE,
  "vangogh",                  "CafeTerrace",            5L, "qualitative", TRUE,
  "vangogh",                       "Eglise",            5L, "qualitative", TRUE,
  "vangogh",                       "Irises",            5L, "qualitative", TRUE,
  "vangogh",             "SunflowersMunich",            5L, "qualitative", TRUE,
  "vangogh",             "SunflowersLondon",            5L, "qualitative", TRUE,
  "vangogh",                         "Rest",            5L, "qualitative", TRUE,
  "vangogh",                      "Bedroom",            5L, "qualitative", TRUE,
  "vangogh",                   "CafeDeNuit",            5L, "qualitative", TRUE,
  "vangogh",                       "Chaise",            5L, "qualitative", TRUE,
  "vangogh",                        "Shoes",            5L, "qualitative", TRUE,
  "vangogh",                    "Landscape",            5L, "qualitative", TRUE,
  "vangogh",                    "Cypresses",            5L, "qualitative", TRUE,
  "vapeplot",                      "vaporwave",     14L, "qualitative", TRUE,
  "vapeplot",                           "cool",      5L, "qualitative", TRUE,
  "vapeplot",                  "crystal_pepsi",      4L, "qualitative", TRUE,
  "vapeplot",                       "mallsoft",      6L, "qualitative", TRUE,
  "vapeplot",                        "jazzcup",      5L, "qualitative", TRUE,
  "vapeplot",                         "sunset",      5L, "qualitative", TRUE,
  "vapeplot",                        "macplus",      6L, "qualitative", TRUE,
  "vapeplot",                        "seapunk",      5L, "qualitative", TRUE,
  "vapoRwave",                         "avanti",      5L, "qualitative", TRUE,
  "vapoRwave",                           "cool",      5L, "sequential", TRUE,
  "vapoRwave",                   "crystalPepsi",      4L, "sequential", TRUE,
  "vapoRwave",                   "floralShoppe",      8L, "qualitative", TRUE,
  "vapoRwave",                   "hotlineBling",      8L, "qualitative", TRUE,
  "vapoRwave",                    "hyperBubble",      7L, "qualitative", TRUE,
  "vapoRwave",                        "jazzCup",      5L, "qualitative", TRUE,
  "vapoRwave",                            "jwz",      8L, "qualitative", TRUE,
  "vapoRwave",                        "macPlus",      6L, "divergent", TRUE,
  "vapoRwave",                       "mallSoft",      6L, "qualitative", TRUE,
  "vapoRwave",                       "newRetro",      9L, "qualitative", TRUE,
  "vapoRwave",                        "seaPunk",      5L, "qualitative", TRUE,
  "vapoRwave",                         "sunSet",      5L, "qualitative", TRUE,
  "vapoRwave",                      "vapoRwave",     11L, "qualitative", TRUE,
  "waRhol",                          "skull_77",      5L, "qualitative", TRUE,
  "waRhol",                        "skull_76_1",      4L, "qualitative", TRUE,
  "waRhol",                        "skull_76_2",      4L, "qualitative", TRUE,
  "waRhol",                          "skull_86",      4L, "qualitative", TRUE,
  "waRhol",                 "marilyn_orange_62",      6L, "qualitative", TRUE,
  "waRhol",                  "marilyn_green_62",      6L, "qualitative", TRUE,
  "waRhol",                        "marilyn_67",      4L, "qualitative", TRUE,
  "waRhol",                         "camo_87_1",      4L, "qualitative", TRUE,
  "waRhol",                         "camo_87_2",      4L, "qualitative", TRUE,
  "waRhol",                         "camo_87_3",      4L, "qualitative", TRUE,
  "waRhol",                         "camo_87_4",      4L, "qualitative", TRUE,
  "waRhol",                         "camo_87_5",      4L, "qualitative", TRUE,
  "waRhol",                    "bighorn_ram_83",      5L, "qualitative", TRUE,
  "waRhol",                       "basquiat_85",      6L, "qualitative", TRUE,
  "waRhol",                      "the_big_c_86",      4L, "qualitative", TRUE,
  "werpals",                     "cinderella",      5L, "qualitative", TRUE,
  "werpals",                          "monet",      6L, "sequential", TRUE,
  "werpals",                    "small_world",      6L, "qualitative", TRUE,
  "werpals",                          "alice",      6L, "qualitative", TRUE,
  "werpals",                            "pan",      6L, "qualitative", TRUE,
  "werpals",            "when_i_was_your_age",      6L, "qualitative", TRUE,
  "werpals",                        "firefly",      7L, "qualitative", TRUE,
  "werpals",                          "uyuni",     10L, "qualitative", TRUE,
  "werpals",                       "okavango",     10L, "qualitative", TRUE,
  "werpals",                     "lakelouise",     10L, "qualitative", TRUE,
  "werpals",                       "provence",     10L, "qualitative", TRUE,
  "werpals",                         "halong",     10L, "qualitative", TRUE,
  "werpals",                    "vatnajokull",     10L, "qualitative", TRUE,
  "werpals",                     "arashiyama",     10L, "qualitative", TRUE,
  "werpals",                      "mountcook",     10L, "qualitative", TRUE,
  "werpals",                        "benagil",     10L, "qualitative", TRUE,
  "werpals",                          "bryce",     10L, "qualitative", TRUE,
  "werpals",                           "jozi",     10L, "qualitative", TRUE,
  "wesanderson",                  "BottleRocket1",      7L, "qualitative", TRUE,
  "wesanderson",                  "BottleRocket2",      5L, "qualitative", TRUE,
  "wesanderson",                      "Rushmore1",      5L, "qualitative", TRUE,
  "wesanderson",                       "Rushmore",      5L, "qualitative", TRUE,
  "wesanderson",                         "Royal1",      4L, "qualitative", TRUE,
  "wesanderson",                         "Royal2",      5L, "qualitative", TRUE,
  "wesanderson",                        "Zissou1",      5L, "qualitative", TRUE,
  "wesanderson",                    "Darjeeling1",      5L, "qualitative", TRUE,
  "wesanderson",                    "Darjeeling2",      5L, "qualitative", TRUE,
  "wesanderson",                     "Chevalier1",      4L, "qualitative", TRUE,
  "wesanderson",                  "FantasticFox1",      5L, "qualitative", TRUE,
  "wesanderson",                      "Moonrise1",      4L, "qualitative", TRUE,
  "wesanderson",                      "Moonrise2",      4L, "qualitative", TRUE,
  "wesanderson",                      "Moonrise3",      5L, "qualitative", TRUE,
  "wesanderson",                    "Cavalcanti1",      5L, "qualitative", TRUE,
  "wesanderson",                 "GrandBudapest1",      4L, "qualitative", TRUE,
  "wesanderson",                 "GrandBudapest2",      4L, "qualitative", TRUE,
  "wesanderson",                    "IsleofDogs1",      6L, "qualitative", TRUE,
  "wesanderson",                    "IsleofDogs2",      5L, "qualitative", TRUE,
  "wesanderson",              "Zissou1Continuous",     11L, "qualitative", TRUE,
  "wesanderson",                 "FrenchDispatch",      5L, "qualitative", TRUE,
  "wesanderson",                  "AsteroidCity1",      5L, "qualitative", TRUE,
  "wesanderson",                  "AsteroidCity2",      6L, "qualitative", TRUE,
  "wesanderson",                  "AsteroidCity3",      4L, "qualitative", TRUE,
  "yarrr",                          "basel",     10L, "qualitative", TRUE,
  "yarrr",                           "pony",      9L, "qualitative", TRUE,
  "yarrr",                           "xmen",      8L, "qualitative", TRUE,
  "yarrr",                       "decision",      6L, "qualitative", TRUE,
  "yarrr",                      "southpark",      6L, "qualitative", TRUE,
  "yarrr",                         "google",      4L, "qualitative", TRUE,
  "yarrr",                        "eternal",      7L, "qualitative", TRUE,
  "yarrr",                       "evildead",      6L, "qualitative", TRUE,
  "yarrr",                  "usualsuspects",      7L, "qualitative", TRUE,
  "yarrr",                      "ohbrother",      7L, "qualitative", TRUE,
  "yarrr",                        "appletv",      6L, "qualitative", TRUE,
  "yarrr",                          "brave",      5L, "qualitative", TRUE,
  "yarrr",                           "bugs",      5L, "qualitative", TRUE,
  "yarrr",                           "cars",      5L, "qualitative", TRUE,
  "yarrr",                           "nemo",      5L, "qualitative", TRUE,
  "yarrr",                            "rat",      5L, "qualitative", TRUE,
  "yarrr",                             "up",      5L, "qualitative", TRUE,
  "yarrr",                       "espresso",      5L, "qualitative", TRUE,
  "yarrr",                           "ipod",      7L, "qualitative", TRUE,
  "yarrr",                           "info",      9L, "qualitative", TRUE,
  "yarrr",                          "info2",     14L, "qualitative", TRUE,
)

readr::write_csv(palettes_d_names, "data-raw/palettes_d_names.csv")
usethis::use_data(palettes_d_names, overwrite = TRUE)
