library(paletteer)

i <- 1
pal_viz <- function() {
  name <- paste(palettes_c_names[i, ]$package, palettes_c_names[i, ]$palette, sep = "::")
  plot(paletteer_c(name, n = 256))
  title(name)
  i <<- i + 1
}

palettes_c_names <- tibble::tribble(
  ~package,                                   ~palette,         ~type,
  # "gameofthrones",                                "targaryen",  "sequential",
  # "gameofthrones",                               "targaryen2",  "sequential",
  # "gameofthrones",                                    "stark",  "sequential",
  # "gameofthrones",                                   "stark2",  "sequential",
  # "gameofthrones",                                "lannister",  "sequential",
  # "gameofthrones",                                  "martell",  "sequential",
  # "gameofthrones",                                    "tully",  "diverging",
  # "gameofthrones",                                  "greyjoy",  "sequential",
  # "gameofthrones",                                "baratheon",  "sequential",
  # "gameofthrones",                               "baratheon2",  "sequential",
  # "gameofthrones",                                   "tyrell",  "sequential",
  # "gameofthrones",                            "white_walkers",  "sequential",
  # "gameofthrones",                                 "jon_snow",  "sequential",
  # "gameofthrones",                                 "margaery",  "sequential",
  # "gameofthrones",                                 "daenerys",  "sequential",
  # "gameofthrones",                          "game_of_thrones",  "sequential",
  # "gameofthrones",                                 "wildfire",  "sequential",
  # "gameofthrones",                                     "arya",  "sequential",
  "ggthemes",                    "Blue-Green Sequential",  "sequential",
  "ggthemes",                               "Blue Light",  "sequential",
  "ggthemes",                             "Orange Light",  "sequential",
  "ggthemes",                                     "Blue",  "sequential",
  "ggthemes",                                   "Orange",  "sequential",
  "ggthemes",                                    "Green",  "sequential",
  "ggthemes",                                      "Red",  "sequential",
  "ggthemes",                                   "Purple",  "sequential",
  "ggthemes",                                    "Brown",  "sequential",
  "ggthemes",                                     "Gray",  "sequential",
  "ggthemes",                                "Gray Warm",  "sequential",
  "ggthemes",                                "Blue-Teal",  "sequential",
  "ggthemes",                              "Orange-Gold",  "sequential",
  "ggthemes",                               "Green-Gold",  "sequential",
  "ggthemes",                                 "Red-Gold",  "sequential",
  "ggthemes",                            "Classic Green",  "sequential",
  "ggthemes",                             "Classic Gray",  "sequential",
  "ggthemes",                             "Classic Blue",  "sequential",
  "ggthemes",                              "Classic Red",  "sequential",
  "ggthemes",                           "Classic Orange",  "sequential",
  "ggthemes",                         "Classic Area Red",  "sequential",
  "ggthemes",                       "Classic Area Green",  "sequential",
  "ggthemes",                       "Classic Area-Brown",  "sequential",
  "ggthemes",                    "Orange-Blue Diverging",   "diverging",
  "ggthemes",                      "Red-Green Diverging",   "diverging",
  "ggthemes",                     "Green-Blue Diverging",   "diverging",
  "ggthemes",                       "Red-Blue Diverging",   "diverging",
  "ggthemes",                      "Red-Black Diverging",   "diverging",
  "ggthemes",                    "Gold-Purple Diverging",   "diverging",
  "ggthemes",                 "Red-Green-Gold Diverging",   "diverging",
  "ggthemes",                 "Sunset-Sunrise Diverging",   "diverging",
  "ggthemes",              "Orange-Blue-White Diverging",   "diverging",
  "ggthemes",                "Red-Green-White Diverging",   "diverging",
  "ggthemes",               "Green-Blue-White Diverging",   "diverging",
  "ggthemes",                 "Red-Blue-White Diverging",   "diverging",
  "ggthemes",                "Red-Black-White Diverging",   "diverging",
  "ggthemes",              "Orange-Blue Light Diverging",   "diverging",
  "ggthemes",                    "Temperature Diverging",   "diverging",
  "ggthemes",                        "Classic Red-Green",   "diverging",
  "ggthemes",                         "Classic Red-Blue",   "diverging",
  "ggthemes",                        "Classic Red-Black",   "diverging",
  "ggthemes",                   "Classic Area Red-Green",   "diverging",
  "ggthemes",                      "Classic Orange-Blue",   "diverging",
  "ggthemes",                       "Classic Green-Blue",   "diverging",
  "ggthemes",                  "Classic Red-White-Green",   "diverging",
  "ggthemes",                  "Classic Red-White-Black",   "diverging",
  "ggthemes",                "Classic Orange-White-Blue",   "diverging",
  "ggthemes",            "Classic Red-White-Black Light",   "diverging",
  "ggthemes",          "Classic Orange-White-Blue Light",   "diverging",
  "ggthemes",            "Classic Red-White-Green Light",   "diverging",
  "ggthemes",                  "Classic Red-Green Light",   "diverging",
  "grDevices",                                  "rainbow",  "sequential",
  "grDevices",                              "heat.colors",  "sequential",
  "grDevices",                           "terrain.colors",  "sequential",
  "grDevices",                              "topo.colors",  "sequential",
  "grDevices",                                "cm.colors",   "diverging",
  "grDevices",                                 "Pastel 1", "qualitative",
  "grDevices",                                   "Dark 2", "qualitative",
  "grDevices",                                   "Dark 3", "qualitative",
  "grDevices",                                    "Set 2", "qualitative",
  "grDevices",                                    "Set 3", "qualitative",
  "grDevices",                                     "Warm", "sequential",
  "grDevices",                                     "Cold", "sequantial",
  "grDevices",                                 "Harmonic", "sequantial",
  "grDevices",                                  "Dynamic", "sequantial",
  "grDevices",                                    "Grays",  "sequential",
  "grDevices",                              "Light Grays",  "sequential",
  "grDevices",                                  "Blues 2",  "sequential",
  "grDevices",                                  "Blues 3",  "sequential",
  "grDevices",                                "Purples 2",  "sequential",
  "grDevices",                                "Purples 3",  "sequential",
  "grDevices",                                   "Reds 2",  "sequential",
  "grDevices",                                   "Reds 3",  "sequential",
  "grDevices",                                 "Greens 2",  "sequential",
  "grDevices",                                 "Greens 3",  "sequential",
  "grDevices",                                     "Oslo",  "sequential",
  "grDevices",                              "Purple-Blue",  "sequential",
  "grDevices",                               "Red-Purple",  "sequential",
  "grDevices",                                 "Red-Blue",  "sequential",
  "grDevices",                            "Purple-Orange",  "sequential",
  "grDevices",                            "Purple-Yellow",  "sequential",
  "grDevices",                              "Blue-Yellow",  "sequential",
  "grDevices",                             "Green-Yellow",  "sequential",
  "grDevices",                               "Red-Yellow",  "sequential",
  "grDevices",                                     "Heat",  "sequential",
  "grDevices",                                   "Heat 2",  "sequential",
  "grDevices",                                  "Terrain",  "sequential",
  "grDevices",                                "Terrain 2",  "sequential",
  "grDevices",                                  "Viridis",  "sequential",
  "grDevices",                                   "Plasma",  "sequential",
  "grDevices",                                  "Inferno",  "sequential",
  "grDevices",                                   "Rocket",  "sequential",
  "grDevices",                                     "Mako",  "sequential",
  "grDevices",                                "Dark Mint",  "sequential",
  "grDevices",                                     "Mint",  "sequential",
  "grDevices",                                   "BluGrn",  "sequential",
  "grDevices",                                     "Teal",  "sequential",
  "grDevices",                                  "TealGrn",  "sequential",
  "grDevices",                                    "Emrld",  "sequential",
  "grDevices",                                    "BluYl",  "sequential",
  "grDevices",                                 "ag_GrnYl",  "sequential",
  "grDevices",                                    "Peach",  "sequential",
  "grDevices",                                   "PinkYl",  "sequential",
  "grDevices",                                     "Burg",  "sequential",
  "grDevices",                                   "BurgYl",  "sequential",
  "grDevices",                                    "RedOr",  "sequential",
  "grDevices",                                    "OrYel",  "sequential",
  "grDevices",                                     "Purp",  "sequential",
  "grDevices",                                   "PurpOr",  "sequential",
  "grDevices",                                   "Sunset",  "sequential",
  "grDevices",                                  "Magenta",  "sequential",
  "grDevices",                               "SunsetDark",  "sequential",
  "grDevices",                                "ag_Sunset",  "sequential",
  "grDevices",                                   "BrwnYl",  "sequential",
  "grDevices",                                   "YlOrRd",  "sequential",
  "grDevices",                                   "YlOrBr",  "sequential",
  "grDevices",                                     "OrRd",  "sequential",
  "grDevices",                                  "Oranges",  "sequential",
  "grDevices",                                     "YlGn",  "sequential",
  "grDevices",                                   "YlGnBu",  "sequential",
  "grDevices",                                     "Reds",  "sequential",
  "grDevices",                                     "RdPu",  "sequential",
  "grDevices",                                     "PuRd",  "sequential",
  "grDevices",                                  "Purples",  "sequential",
  "grDevices",                                   "PuBuGn",  "sequential",
  "grDevices",                                     "PuBu",  "sequential",
  "grDevices",                                   "Greens",  "sequential",
  "grDevices",                                     "BuGn",  "sequential",
  "grDevices",                                     "GnBu",  "sequential",
  "grDevices",                                     "BuPu",  "sequential",
  "grDevices",                                    "Blues",  "sequential",
  "grDevices",                                  "Lajolla",  "sequential",
  "grDevices",                                    "Turku",  "sequential",
  "grDevices",                                   "Hawaii",  "sequential",
  "grDevices",                                   "Batlow",  "sequential",
  "grDevices",                                 "Blue-Red",   "diverging",
  "grDevices",                               "Blue-Red 2",   "diverging",
  "grDevices",                               "Blue-Red 3",   "diverging",
  "grDevices",                                "Red-Green",   "diverging",
  "grDevices",                             "Purple-Green",   "diverging",
  "grDevices",                             "Purple-Brown",   "diverging",
  "grDevices",                              "Green-Brown",   "diverging",
  "grDevices",                            "Blue-Yellow 2",   "diverging",
  "grDevices",                            "Blue-Yellow 3",   "diverging",
  "grDevices",                             "Green-Orange",   "diverging",
  "grDevices",                             "Cyan-Magenta",   "diverging",
  "grDevices",                                   "Tropic",   "diverging",
  "grDevices",                                     "Broc",   "diverging",
  "grDevices",                                     "Cork",   "diverging",
  "grDevices",                                      "Vik",   "diverging",
  "grDevices",                                   "Berlin",   "diverging",
  "grDevices",                                   "Lisbon",   "diverging",
  "grDevices",                                   "Tofino",   "diverging",
  "grDevices",                                 "ArmyRose",   "diverging",
  "grDevices",                                    "Earth",   "diverging",
  "grDevices",                                     "Fall",   "diverging",
  "grDevices",                                   "Geyser",   "diverging",
  "grDevices",                                 "TealRose",   "diverging",
  "grDevices",                                    "Temps",   "diverging",
  "grDevices",                                     "PuOr",   "diverging",
  "grDevices",                                     "RdBu",   "diverging",
  "grDevices",                                     "RdGy",   "diverging",
  "grDevices",                                     "PiYG",   "diverging",
  "grDevices",                                     "PRGn",   "diverging",
  "grDevices",                                     "BrBG",   "diverging",
  "grDevices",                                   "RdYlBu",   "diverging",
  "grDevices",                                   "RdYlGn",   "diverging",
  "grDevices",                                 "Spectral",   "diverging",
  "grDevices",                                 "Zissou 1",   "diverging",
  "grDevices",                                  "Cividis",   "sequential",
  "grDevices",                                     "Roma",   "diverging",
  "harrypotter",                                "slytherin",  "sequential",
  "harrypotter",                               "gryffindor",  "sequential",
  "harrypotter",                              "gryffindor2",  "sequential",
  "harrypotter",                               "hufflepuff",  "sequential",
  "harrypotter",                               "ravenclaw2",  "sequential",
  "harrypotter",                             "lunalovegood",  "sequential",
  "harrypotter",                          "hermionegranger",  "sequential",
  "harrypotter",                                 "mischief",  "sequential",
  "harrypotter",                                   "sprout",  "sequential",
  "harrypotter",                                   "always",  "sequential",
  "harrypotter",                                "ravenclaw",  "sequential",
  "harrypotter",                              "harrypotter",  "sequential",
  "harrypotter",                              "dracomalfoy",  "sequential",
  "harrypotter",                            "newtscamander",  "sequential",
  "harrypotter",                               "ronweasley",  "sequential",
  "harrypotter",                              "ronweasley2",  "sequential",
  "oompaBase",                                 "redscale",  "sequential",
  "oompaBase",                               "greenscale",  "sequential",
  "oompaBase",                                "bluescale",  "sequential",
  "oompaBase",                               "blueyellow",   "diverging",
  "oompaBase",                               "cyanyellow",   "diverging",
  "oompaBase",                                 "redgreen",   "diverging",
  "oompaBase",                                "jetColors",  "sequential",
  "oompaBase",                                "greyscale",  "sequential",
  "palr",                           "bathy_deep_pal",  "sequential",
  "palr",                                  "chl_pal",  "sequential",
  "palr",                                  "ice_pal",  "sequential",
  "palr",                                  "sst_pal",  "sequential",
  "pals",                                 "coolwarm",   "diverging",
  "pals",                                 "warmcool",   "diverging",
  "pals",                                      "jet",  "sequential",
  "pals",                                   "parula",  "sequential",
  "pals",                                  "cubicyf",  "sequential",
  "pals",                                     "isol",  "sequential",
  "pals",                                   "cubicl",  "sequential",
  "pals",                                  "linearl",  "sequential",
  "pals",                               "linearlhot",  "sequential",
  "pals",                              "ocean.algae",  "sequential",
  "pals",                               "ocean.deep",  "sequential",
  "pals",                              "ocean.dense",  "sequential",
  "pals",                               "ocean.gray",  "sequential",
  "pals",                             "ocean.haline",  "sequential",
  "pals",                                "ocean.ice",  "sequential",
  "pals",                             "ocean.matter",  "sequential",
  "pals",                                "ocean.oxy",  "sequential",
  "pals",                              "ocean.phase",  "sequential",
  "pals",                              "ocean.solar",  "sequential",
  "pals",                            "ocean.thermal",  "sequential",
  "pals",                             "ocean.turbid",  "sequential",
  "pals",                            "ocean.balance",   "diverging",
  "pals",                               "ocean.curl",   "diverging",
  "pals",                              "ocean.delta",   "diverging",
  "pals",                                "ocean.amp",  "sequential",
  "pals",                              "ocean.speed",  "sequential",
  "pals",                              "ocean.tempo",  "sequential",
  "pals",              "kovesi.cyclic_grey_15_85_c0",  "sequential",
  "pals",          "kovesi.cyclic_grey_15_85_c0_s25",  "sequential",
  "pals",            "kovesi.cyclic_mrybm_35_75_c68",  "sequential",
  "pals",        "kovesi.cyclic_mrybm_35_75_c68_s25",  "sequential",
  "pals",            "kovesi.cyclic_mygbm_30_95_c78",  "sequential",
  "pals",        "kovesi.cyclic_mygbm_30_95_c78_s25",  "sequential",
  "pals",            "kovesi.cyclic_wrwbw_40_90_c42",  "sequential",
  "pals",        "kovesi.cyclic_wrwbw_40_90_c42_s25",  "sequential",
  "pals",  "kovesi.diverging_isoluminant_cjm_75_c23",   "diverging",
  "pals",  "kovesi.diverging_isoluminant_cjm_75_c24",   "diverging",
  "pals",  "kovesi.diverging_isoluminant_cjo_70_c25",   "diverging",
  "pals",    "kovesi.diverging_linear_bjr_30_55_c53",   "diverging",
  "pals",    "kovesi.diverging_linear_bjy_30_90_c45",   "diverging",
  "pals", "kovesi.diverging_rainbow_bgymr_45_85_c67",  "sequential",
  "pals",           "kovesi.diverging_bkr_55_10_c35",   "diverging",
  "pals",           "kovesi.diverging_bky_60_10_c30",   "diverging",
  "pals",           "kovesi.diverging_bwr_40_95_c42",   "diverging",
  "pals",           "kovesi.diverging_bwr_55_98_c37",   "diverging",
  "pals",          "kovesi.diverging_cwm_80_100_c22",   "diverging",
  "pals",           "kovesi.diverging_gkr_60_10_c40",   "diverging",
  "pals",           "kovesi.diverging_gwr_55_95_c38",   "diverging",
  "pals",           "kovesi.diverging_gwv_55_95_c39",   "diverging",
  "pals",            "kovesi.isoluminant_cgo_70_c39",  "sequential",
  "pals",            "kovesi.isoluminant_cgo_80_c38",  "sequential",
  "pals",             "kovesi.isoluminant_cm_70_c39",  "sequential",
  "pals",              "kovesi.linear_bgy_10_95_c74",  "sequential",
  "pals",            "kovesi.linear_bgyw_15_100_c67",  "sequential",
  "pals",            "kovesi.linear_bgyw_15_100_c68",  "sequential",
  "pals",              "kovesi.linear_blue_5_95_c73",  "sequential",
  "pals",             "kovesi.linear_blue_95_50_c20",  "sequential",
  "pals",               "kovesi.linear_bmw_5_95_c86",  "sequential",
  "pals",               "kovesi.linear_bmw_5_95_c89",  "sequential",
  "pals",              "kovesi.linear_bmy_10_95_c71",  "sequential",
  "pals",              "kovesi.linear_bmy_10_95_c78",  "sequential",
  "pals",              "kovesi.linear_gow_60_85_c27",  "sequential",
  "pals",              "kovesi.linear_gow_65_90_c35",  "sequential",
  "pals",             "kovesi.linear_green_5_95_c69",  "sequential",
  "pals",              "kovesi.linear_grey_0_100_c0",  "sequential",
  "pals",              "kovesi.linear_grey_10_95_c0",  "sequential",
  "pals",               "kovesi.linear_kry_5_95_c72",  "sequential",
  "pals",               "kovesi.linear_kry_5_98_c75",  "sequential",
  "pals",             "kovesi.linear_kryw_5_100_c64",  "sequential",
  "pals",             "kovesi.linear_kryw_5_100_c67",  "sequential",
  "pals",      "kovesi.linear_ternary_blue_0_44_c57",  "sequential",
  "pals",     "kovesi.linear_ternary_green_0_46_c42",  "sequential",
  "pals",       "kovesi.linear_ternary_red_0_50_c52",  "sequential",
  "pals",            "kovesi.rainbow_bgyr_35_85_c72",  "sequential",
  "pals",            "kovesi.rainbow_bgyr_35_85_c73",  "sequential",
  "pals",           "kovesi.rainbow_bgyrm_35_85_c69",  "sequential",
  "pals",           "kovesi.rainbow_bgyrm_35_85_c71",  "sequential",
  "scico",                                    "acton",  "sequential",
  "scico",                                   "bamako",  "sequential",
  "scico",                                   "batlow",  "sequential",
  "scico",                                   "berlin",   "diverging",
  "scico",                                   "bilbao",  "sequential",
  "scico",                                     "broc",   "diverging",
  "scico",                                    "brocO",   "diverging",
  "scico",                                     "buda",  "sequential",
  "scico",                                     "cork",   "diverging",
  "scico",                                    "corkO",   "diverging",
  "scico",                                    "davos",  "sequential",
  "scico",                                    "devon",  "sequential",
  "scico",                                    "grayC",  "sequential",
  "scico",                                   "hawaii",  "sequential",
  "scico",                                    "imola",  "sequential",
  "scico",                                  "lajolla",  "sequential",
  "scico",                                    "lapaz",  "sequential",
  "scico",                                   "lisbon",   "diverging",
  "scico",                                     "nuuk",  "sequential",
  "scico",                                   "oleron",  "sequential",
  "scico",                                     "oslo",  "sequential",
  "scico",                                     "roma",   "diverging",
  "scico",                                    "romaO",   "diverging",
  "scico",                                   "tofino",   "diverging",
  "scico",                                    "tokyo",  "sequential",
  "scico",                                    "turku",  "sequential",
  "scico",                                      "vik",   "diverging",
  "scico",                                     "vikO",   "diverging",
  "scico",                                      "bam",   "diverging",
  "scico",                                     "bamO",   "diverging",
  "scico",                                  "batlowK",  "sequential",
  "scico",                                  "batlowW",  "sequential",
  "scico",                                   "bukavu",  "sequential",
  "scico",                                      "fes",  "sequential",
  "scico",                                   "vanimo",   "diverging",
  "viridis",                                  "viridis",  "sequential",
  "viridis",                                  "inferno",  "sequential",
  "viridis",                                    "magma",  "sequential",
  "viridis",                                   "plasma",  "sequential",
  "viridis",                                  "cividis",  "sequential",
  "viridis",                                   "rocket",  "sequential",
  "viridis",                                    "turbo",  "sequential",
  "viridis",                                     "mako",  "sequential"
)

usethis::use_data(palettes_c_names, overwrite = TRUE)
