% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_order}
\alias{wb_order}
\alias{wb_get_order}
\alias{wb_set_order}
\title{Order of worksheets in xlsx file}
\usage{
wb_get_order(wb)

wb_set_order(wb, sheets)
}
\arguments{
\item{wb}{A \code{wbWorkbook} object}

\item{sheets}{Sheet order}
}
\description{
Get/set order of worksheets in a Workbook object
}
\details{
This function does not reorder the worksheets within the workbook
object, it simply shuffles the order when writing to file.
}
\examples{
## setup a workbook with 3 worksheets
wb <- wb_workbook()
wb$add_worksheet("Sheet 1", gridLines = FALSE)
wb$add_data_table(sheet = 1, x = iris)

wb$add_worksheet("mtcars (Sheet 2)", gridLines = FALSE)
wb$add_data(sheet = 2, x = mtcars)

wb$add_worksheet("Sheet 3", gridLines = FALSE)
wb$add_data(sheet = 3, x = Formaldehyde)

wb_get_order(wb)
wb$get_sheet_na
wb$set_order(c(1, 3, 2)) # switch position of sheets 2 & 3
wb$add_data(2, 'This is still the "mtcars" worksheet', startCol = 15)
wb_get_order(wb)
wb$get_sheet_names() ## ordering within workbook is not changed
wb$set_order(3:1)
}
