% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_cell_style}
\alias{wb_add_cell_style}
\title{add cell style for cell region}
\usage{
wb_add_cell_style(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  applyAlignment = NULL,
  applyBorder = NULL,
  applyFill = NULL,
  applyFont = NULL,
  applyNumberFormat = NULL,
  applyProtection = NULL,
  borderId = NULL,
  extLst = NULL,
  fillId = NULL,
  fontId = NULL,
  hidden = NULL,
  horizontal = NULL,
  indent = NULL,
  justifyLastLine = NULL,
  locked = NULL,
  numFmtId = NULL,
  pivotButton = NULL,
  quotePrefix = NULL,
  readingOrder = NULL,
  relativeIndent = NULL,
  shrinkToFit = NULL,
  textRotation = NULL,
  vertical = NULL,
  wrapText = NULL,
  xfId = NULL
)
}
\arguments{
\item{wb}{a workbook}

\item{sheet}{the worksheet}

\item{dims}{the cell range}

\item{applyAlignment}{logical apply alignment}

\item{applyBorder}{logical apply border}

\item{applyFill}{logical apply fill}

\item{applyFont}{logical apply font}

\item{applyNumberFormat}{logical apply number format}

\item{applyProtection}{logical apply protection}

\item{borderId}{border ID to apply}

\item{extLst}{extension list something like \verb{<extLst>...</extLst>}}

\item{fillId}{fill ID to apply}

\item{fontId}{font ID to apply}

\item{hidden}{logical cell is hidden}

\item{horizontal}{align content horizontal ('left', 'center', 'right')}

\item{indent}{logical indent content}

\item{justifyLastLine}{logical justify last line}

\item{locked}{logical cell is locked}

\item{numFmtId}{number format ID to apply}

\item{pivotButton}{unknown}

\item{quotePrefix}{unknown}

\item{readingOrder}{reading order left to right}

\item{relativeIndent}{relative indentation}

\item{shrinkToFit}{logical shrink to fit}

\item{textRotation}{degrees of text rotation}

\item{vertical}{vertical alignment of content ('top', 'center', 'bottom')}

\item{wrapText}{wrap text in cell}

\item{xfId}{xf ID to apply}
}
\value{
The \code{wbWorksheetObject}, invisibly
}
\description{
add cell style for cell region
}
\examples{
 wb <-
   wb_workbook() \%>\%
   wb_add_worksheet("S1") \%>\%
   wb_add_data("S1", mtcars)

 wb \%>\%
   wb_add_cell_style(
     "S1",
     "A1:K1",
     textRotation = "45",
     horizontal = "center",
     vertical = "center",
     wrapText = "1"
   )
}
\seealso{
Other styles: 
\code{\link{wb_add_border}()},
\code{\link{wb_add_fill}()},
\code{\link{wb_add_font}()},
\code{\link{wb_add_numfmt}()},
\code{\link{wb_clone_sheet_style}()}
}
\concept{styles}
